#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_WDT_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
WDT overflow Interrupt(WDTF) => WDTF_Flag
****************************************************************/
uint8_t WDTF_Flag;

void main()
{
    /****************************************************************
    Variables
    ClearEN       => For check WDT counter clear function EN/Disable
    ****************************************************************/
    uint8_t ClearEN;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P70 used for WDT counter clear option
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P7ModeSelect(P70_OpenDrainPullUp);

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable WDT interrupt (WDTFIE) = Enable;
     *  2. Enable System interrupt (ESF) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_WDT_IT_Cmd(MW_ENABLE);
    __DRV_INT_SystemFlag_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  WDT Initialized
     *  1. Enable WDT
     ****************************************************************/
    __DRV_WDT_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         * WDT will continue overflow interrupt(WDTF_Flag) and then to inverse LED_D4(P55)
         ****************************************************************/
        if (WDTF_Flag)
        {
            __DRV_GPIO_InversePinP5(P55);
            WDTF_Flag = 0;
        }

        __DRV_GPIO_ReadP7(ClearEN);
        if (ClearEN == 0x01)
        {
            __DRV_WDT_ClearCounter();
        }
    }
}

void SYSFlag_WDT_ISR() interrupt SYSFLAG_ISR_VECTOR
{
    // WDT Interrupt
    if ((PCON1 & WDTF) == WDTF)
    {
        WDTF_Flag = 1;
        __DRV_WDT_ClearFlag();
    }
}
