#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "stdio.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_UART0_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : UART0_9600_Init
 *  Use the Timer1(T1OF) as UART0 clock source.
 ****************************************************************/
void UART0_9600_Init(void)
{
    // UART0 Register initial Tx:P31 Rx:P30
    __DRV_URT0_SetSM10(UART0_MODE1_8BIT);
    __DRV_URT0_SerialReception_Cmd(MW_ENABLE);
    TI0 = 1;

    // Use Timer1 Auto reload mode to generate the baud rate 9600
    __DRV_TIMER1_Mode_Select(TIMER1_MODE2_8BIT_AUTORELOAD);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK);
    __DRV_TIMER1_Set8BitIntervalAutoReload(217);
    __DRV_TIMER1_Run_Cmd(MW_ENABLE);
}

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer4 overflow Interrupt(TH4) => TF4_Flag
Timer4 external Interrupt      => EXF4_Flag
Timer4 overflow Interrupt(TL4) => TF4L_Flag
****************************************************************/
uint8_t TF4_Flag, EXF4_Flag, TF4L_Flag;

void main()
{
    /****************************************************************
    Variables
    Temp_TH4 => Store the TH4 value
    Temp_TL4 => Store the TL4 value
    ****************************************************************/
    uint8_t Temp_TH4 = 0, Temp_TL4 = 0;

    /****************************************************************
     *  UART0 Initialized
     ****************************************************************/
    UART0_9600_Init();

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer4 interrupt (ET4) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER4_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P71 used for T4EX Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P7ModeSelect(P71_OpenDrainPullUp);

    /****************************************************************
     *  Timer4 Initialized
     *  1. Capture Source = T4EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER4_Capture_Source_Select(TIMER4_CAPTURE_SOURCE_T4EX_PIN);
    __DRV_TIMER4_Capture_Source_Dectect(Timer4_FALLING_EDGE);

    /****************************************************************
     *  Timer4 Initialized
     *  Interrupt time => (1 / (SYSCLK/12)) * 1000 * 100 = 1 S
     ****************************************************************/
    __DRV_TIMER4_Mode_Select(TIMER4_MODE1_16BIT_AUTORELOAD_WITH_EXTERNAL_INTERRUPT);
    __DRV_TIMER4_Clock_Source_Select(TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER4_Set16BitCounter(0);
    __DRV_TIMER4_Set16Bit_AutoReloadValue(0);
    __DRV_TIMER4_Run_Cmd(MW_ENABLE);

    /****************************************************************
     *  Timer4 External Trigger
     ****************************************************************/
    __DRV_GPIO_WriteP7(P71, 1);

    while (1)
    {
        delay_ms(3);
        __DRV_TIMER_Globel_Stop_Cmd(T4SC);
        Temp_TH4 = DRV_TIMER4_GetTH4();
        Temp_TL4 = DRV_TIMER4_GetTL4();
        printf("Before Trigger Counter TH4=%X TL4=%X\n", (unsigned int)Temp_TH4, (unsigned int)Temp_TL4);
        __DRV_GPIO_WriteP7(P71, 0);
        while (EXF4_Flag == 0)
            ;
        if (EXF4_Flag)
        {
            Temp_TH4 = DRV_TIMER4_GetTH4();
            Temp_TL4 = DRV_TIMER4_GetTL4();
            printf("After Trigger Counter TH4=%X TL4=%X\n", (unsigned int)Temp_TH4, (unsigned int)Temp_TL4);
            __DRV_GPIO_WriteP7(P71, 1);
            __DRV_TIMER_Globel_Enable_Cmd(TR4E);
            EXF4_Flag = 0;
        }
    }
}

/****************************************************************
Timer4 interrupt
The Timer4 has TF4, EXF4, TF4L flags to trigger the Timer4 interrupt.
****************************************************************/
void TIMER4_TF4_EXF4_TF4L_ISR(void) interrupt TIMER4_ISR_VECTOR
{
    if (DRV_TIMER4_GetTF4() == 1)
    {
        TF4_Flag = 1;
        DRV_TIMER4_ClearTF4();
    }

    if (DRV_TIMER4_GetTF4L() == 1)
    {
        TF4L_Flag = 1;
        DRV_TIMER4_ClearTF4L();
    }

    if (DRV_TIMER4_GetEXF4() == 1)
    {
        EXF4_Flag = 1;
        DRV_TIMER4_ClearEXF4();
    }
}
