#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "stdio.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_UART0_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : UART0_9600_Init
 *  Use the Timer1(T1OF) as UART0 clock source.
 ****************************************************************/
void UART0_9600_Init(void)
{
    // UART0 Register initial Tx:P31 Rx:P30
    __DRV_URT0_SetSM10(UART0_MODE1_8BIT);
    __DRV_URT0_SerialReception_Cmd(MW_ENABLE);
    TI0 = 1;

    // Use Timer1 Auto reload mode to generate the baud rate 9600
    __DRV_TIMER1_Mode_Select(TIMER1_MODE2_8BIT_AUTORELOAD);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK);
    __DRV_TIMER1_Set8BitIntervalAutoReload(217);
    __DRV_TIMER1_Run_Cmd(MW_ENABLE);
}

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer3 overflow Interrupt(TH3) => TF3_Flag
Timer3 external Interrupt      => EXF3_Flag
Timer3 overflow Interrupt(TL3) => TF3L_Flag
****************************************************************/
uint8_t TF3_Flag, EXF3_Flag, TF3L_Flag;

void main()
{
    /****************************************************************
    Variables
    count       => For time delay
    Temp_TH3    => Store the TH3 value
    Temp_TL3    => Store the TL3 value
    Temp_RCAP3H => Store the RCAP3H value
    Temp_RCAP3L => Store the RCAP3L value
    ****************************************************************/
    uint32_t count = 0;
    uint8_t Temp_RCAP3H = 0, Temp_RCAP3L = 0;
    uint8_t Temp_TH3 = 0, Temp_TL3 = 0;

    /****************************************************************
     *  UART0 Initialized
     ****************************************************************/
    UART0_9600_Init();

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer3 interrupt (ET3) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER3_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P46 used for T3 Pin
     *  2. P00 used for T3EX Pin
     ****************************************************************/
    __DRV_GPIO_P4ModeSelect(P46_OpenDrainPullUp);
    __DRV_GPIO_P0ModeSelect(P00_OpenDrainPullUp);

    /****************************************************************
     *  Timer3 Initialized
     *  1. Capture Source = T3EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER3_Mode_Select(TIMER3_MODE2_16BIT_CAPTURE);
    __DRV_TIMER3_Clock_Source_Select(TIMER3_CLOCK_SOURCE_T3_PIN);
    __DRV_TIMER3_Set16BitCounter(0);
    __DRV_TIMER3_Set16Bit_AutoReloadValue(0);
    __DRV_TIMER3_Capture_Source_Select(TIMER3_CAPTURE_SOURCE_T3EX_PIN);
    __DRV_TIMER3_Capture_Source_Dectect(Timer3_FALLING_EDGE);
    __DRV_TIMER3_Run_Cmd(MW_ENABLE);

    /****************************************************************
     *  Timer3 External Trigger
     *  Trigger source = T3EX Pin(P00)
     ****************************************************************/
    __DRV_GPIO_WriteP0(P00, 1);

    while (1)
    {
        for (count = 0; count < 0x2FE; count++)
        {
            __DRV_GPIO_InversePinP4(P46);
        }
        __DRV_GPIO_WriteP0(P00, 0);
        while (EXF3_Flag == 0)
            ;
        if (EXF3_Flag == 1)
        {
            Temp_TH3 = DRV_TIMER3_GetTH3();
            Temp_TL3 = DRV_TIMER3_GetTL3();
            printf("Counter TH3=%X TL3=%X\n", (uint16_t)Temp_TH3, (uint16_t)Temp_TL3);
            Temp_RCAP3H = DRV_TIMER3_GetRCAP3H();
            Temp_RCAP3L = DRV_TIMER3_GetRCAP3L();
            printf("Capture RCAP3H = %X, RCAP3L = %X\n", (uint16_t)Temp_RCAP3H, (uint16_t)Temp_RCAP3L);
            __DRV_TIMER3_Set16BitCounter(0);
            __DRV_TIMER3_Set16Bit_AutoReloadValue(0);
            __DRV_GPIO_WriteP0(P00, 1);
            delay_ms(1000);
            EXF3_Flag = 0;
        }
    }
}

/****************************************************************
Timer3 interrupt
The Timer3 has TF3, EXF3, TF3L flags to trigger the Timer3 interrupt.
****************************************************************/
void TIMER3_TF3_EXF3_TF3L_ISR(void) interrupt TIMER3_ISR_VECTOR
{
    if (DRV_TIMER3_GetTF3() == 1)
    {
        TF3_Flag = 1;
        DRV_TIMER3_ClearTF3();
    }

    if (DRV_TIMER3_GetTF3L() == 1)
    {
        TF3L_Flag = 1;
        DRV_TIMER3_ClearTF3L();
    }

    if (DRV_TIMER3_GetEXF3() == 1)
    {
        EXF3_Flag = 1;
        DRV_TIMER3_ClearEXF3();
    }
}
