#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "stdio.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_UART0_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Delay function
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}


void main()
{
    // UART0 Register initial Tx:P31 Rx:P30
    __DRV_URT0_SetSM10(UART0_MODE1_8BIT);
    __DRV_URT0_SerialReception_Cmd(MW_ENABLE);
    TI0 = 1;

    // Use Timer2 Auto reload mode to generate the baud rate 38400
    __DRV_TIMER2_Mode_Select(TIMER2_MODE1_16BIT_AUTORELOAD_WITH_EXTERNAL_INTERRUPT);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_SYSCLK);
    __DRV_URT0_BaudRateX2X4_Select(UART0_DOUBLE_BAUD_RATE_X4);
    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER2_RECEIVE_CLOCK_SOURCE_TIMER2);
    __DRV_TIMER2_Set16Bit_AutoReloadValue(65458);
    __DRV_TIMER2_Run_Cmd(MW_ENABLE);
    while (1)
    {
        printf("T2OF as UART0 clock source successfully! Baud-Rate : 38400\n");
        delay_ms(1000);
    }
}
