/**
 ******************************************************************************
 *
 * @file        MGEQ1C064_INT_VECTOR.c
 *
 * @brief       This is the C code format main file.
 *
 * @par         Project
 *              MGEQ1C064
 * @version     V1.02
 * @date        2021/10/26
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IF"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#include "MGEQ1C064_CONFIG.h"

/**
 *******************************************************************************
 * Interrupts ISR
 *******************************************************************************
 */

/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_INT_ALL_WIZARD
/// @endcond


/**
 *******************************************************************************
 * @brief       External Interrupt 0 Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    ExINT0_IE0_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_INT0_VECTOR_CONFIG
/// @endcond
void ExINT0_IE0_ISR(void)  interrupt INT0_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_INT0_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       Timer 0 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    TIMER0_TF0_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_TIMER0_IT_VECTOR_CONFIG
/// @endcond
void TIMER0_TF0_ISR(void)   interrupt TIMER0_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_TIMER0_ClearTF0();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       External Interrupt 1 Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    ExINT1_IE1_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_INT1_VECTOR_CONFIG
/// @endcond
void ExINT1_IE1_ISR(void)   interrupt INT1_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_INT1_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       Timer 1 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    TIMER1_TF1_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_TIMER1_IT_VECTOR_CONFIG
/// @endcond
void TIMER1_TF1_ISR(void)   interrupt TIMER1_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_TIMER1_ClearTF1();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       UART0 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    UART0_RI0_TI0_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_S0_IT_VECTOR_CONFIG
/// @endcond
void UART0_RI0_TI0_ISR(void)   interrupt S0_ISR_VECTOR
{
    _push_(SFRPI);

    //TX Interrupt
    if (DRV_URT0_GetTI0())
        DRV_URT0_ClearTI0();

    //RX Interrupt
    if (DRV_URT0_GetRI0())
        DRV_URT0_ClearRI0();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       Timer 2 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    TIMER2_TF2_EXF2_TF2L_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_TIMER2_IT_VECTOR_CONFIG
/// @endcond
void TIMER2_TF2_EXF2_TF2L_ISR(void)   interrupt TIMER2_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_TIMER2_ClearTF2();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       External Interrupt 2 Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    ExINT2_IE2_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_INT2_VECTOR_CONFIG
/// @endcond
void ExINT2_IE2_ISR(void)   interrupt INT2_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_INT2_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       SPI Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    SPI_SPIF_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_SPI_IT_VECTOR_CONFIG
/// @endcond
void SPI_SPIF_ISR(void)   interrupt SPI_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_SPI_ClearSPIF();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       ADC Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    ADC_ADCI_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_ADC_IT_VECTOR_CONFIG
/// @endcond
void ADC_ADCI_ISR(void)   interrupt ADC_ISR_VECTOR
{
    _push_(SFRPI);

    //ADCI Interrupt
    __DRV_ADC_ClearFlag();

    //Window Detect Interrupt
    __DRV_ADC_ClearWindowFlag();

    //Sample Flag Interrupt
    __DRV_ADC_ClearSampleFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       PCA 0 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    PCA0_CF_CCFn_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_PCA_IT_VECTOR_CONFIG
/// @endcond
void PCA0_CF_CCFn_ISR(void)   interrupt PCA0_ISR_VECTOR
{
    _push_(SFRPI);

    if (DRV_PCA_GetModule0Flag())
        __DRV_PCA_Module0_ClearFlag();

    if (DRV_PCA_GetModule1Flag())
        __DRV_PCA_Module1_ClearFlag();

    if (DRV_PCA_GetModule2Flag())
        __DRV_PCA_Module2_ClearFlag();

    if (DRV_PCA_GetModule3Flag())
        __DRV_PCA_Module3_ClearFlag();

    if (DRV_PCA_GetModule4Flag())
        __DRV_PCA_Module4_ClearFlag();

    if (DRV_PCA_GetModule5Flag())
        __DRV_PCA_Module5_ClearFlag();

    if (DRV_PCA_GetModule6Flag())
        __DRV_PCA_Module6_ClearFlag();

    if (DRV_PCA_GetModule7Flag())
        __DRV_PCA_Module7_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       System Flag Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    SYSFlag_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_SYSFLAG_IT_VECTOR_CONFIG
/// @endcond
void SYSFlag_ISR()  interrupt SYSFLAG_ISR_VECTOR
{
    _push_(SFRPI);

    //WDT Interrupt
    __DRV_WDT_ClearFlag();

    //RTC Interrupt
    __DRV_RTC_ClearFlag();

    //BOD0 Interrupt
    __DRV_BODx_BOD0_ClearFlag();

    //BOD1 Interrupt
    __DRV_BODx_BOD1_ClearFlag();


    //SI2C Interrupt
    if (__DRV_SI2C_GetStartFlag())
    {
        __DRV_SI2C_ClearStartFlag();
    }

    if (__DRV_SI2C_GetStopFlag())
    {
        __DRV_SI2C_ClearStopFlag();
    }

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       KBI Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    KBI_KBIF_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_KBI_IT_VECTOR_CONFIG
/// @endcond
void KBI_KBIF_ISR()  interrupt KBI_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_KBI_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       I2C0 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    I2C0_SI_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_I2C0_IT_VECTOR_CONFIG
/// @endcond
void I2C0_SI_ISR(void)   interrupt I2C0_ISR_VECTOR
{
    _push_(SFRPI);

    Sample_I2C0_ISR_Handle();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       AC0 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    AC0_AC0F_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_AC0_IT_VECTOR_CONFIG
/// @endcond
void AC0_AC0F_ISR(void)   interrupt AC0_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_AC0_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       UART1 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    UART1_RI1_STI1_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_S1_IT_VECTOR_CONFIG
/// @endcond
void UART1_RI1_STI1_ISR(void)   interrupt S1_ISR_VECTOR
{
    _push_(SFRPI);

    //TX Interrupt
    if (DRV_URT1_GetTI1())
        DRV_URT1_ClearTI1();

    //RX Interrupt
    if (DRV_URT1_GetRI1())
        DRV_URT1_ClearRI1();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       External Interrupt 3 Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    ExINT3_IE3_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_INT3_VECTOR_CONFIG
/// @endcond
void ExINT3_IE3_ISR(void)   interrupt INT3_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_INT3_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       Timer 3 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    TIMER3_TF3_EXF3_TF3L_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_TIMER3_IT_VECTOR_CONFIG
/// @endcond
void TIMER3_TF3_EXF3_TF3L_ISR(void)   interrupt TIMER3_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_TIMER3_ClearTF3();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       AC1 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    AC1_AC1F_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_AC1_IT_VECTOR_CONFIG
/// @endcond
void AC1_AC1F_ISR(void)   interrupt AC1_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_AC1_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       DMA Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    DMA_DCF0_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_DMA_IT_VECTOR_CONFIG
/// @endcond
void DMA_DCF0_ISR(void)   interrupt DMA_ISR_VECTOR
{
    _push_(SFRPI);

    if (DRV_DMA_GetFlag())
        __DRV_DMA_ClearCompleteFlag();

    //TF5 Interrupt
    if (DRV_TIMER5_GetTF5())
        DRV_TIMER5_ClearTF5();

    //TF6 Interrupt
    if (DRV_TIMER6_GetTF6())
        DRV_TIMER6_ClearTF6();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond



/**
 *******************************************************************************
 * @brief       AC2 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    AC2_AC2F_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_AC2_IT_VECTOR_CONFIG
/// @endcond
void AC2_AC2F_ISR(void)   interrupt AC2_ISR_VECTOR
{
    _push_(SFRPI);

    __DRV_AC2_ClearFlag();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond




/**
 *******************************************************************************
 * @brief       UART2 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    UART2_RI2_TI2_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_S2_IT_VECTOR_CONFIG
/// @endcond
void UART2_RI2_TI2_ISR(void)   interrupt S2_ISR_VECTOR
{
    _push_(SFRPI);

    //TX Interrupt
    if (DRV_URT2_GetTI2())
        DRV_URT2_ClearTI2();

    //RX Interrupt
    if (DRV_URT2_GetRI2())
        DRV_URT2_ClearRI2();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       Timer 4 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    TIMER4_TF4_EXF4_TF4L_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_TIMER4_IT_VECTOR_CONFIG
/// @endcond
void TIMER4_TF4_EXF4_TF4L_ISR(void)   interrupt TIMER4_ISR_VECTOR
{
    _push_(SFRPI);

    DRV_TIMER4_ClearTF4();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond

/**
 *******************************************************************************
 * @brief       UART3 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    UART3_RI3_TI3_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_S3_IT_VECTOR_CONFIG
/// @endcond
void UART3_RI3_TI3_ISR(void)   interrupt S3_ISR_VECTOR
{
    _push_(SFRPI);

    //TX Interrupt
    if (DRV_URT3_GetTI3())
        DRV_URT3_ClearTI3();

    //RX Interrupt
    if (DRV_URT3_GetRI3())
        DRV_URT3_ClearRI3();

    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       I2C1 Interrupt Vector Service Routine
 * @details
 * @return      None
 * @note
 * @par         Example
 * @code
 *    I2C1_SI1_ISR();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MGEQ1C064_I2C1_IT_VECTOR_CONFIG
/// @endcond
void I2C1_SI1_ISR(void)   interrupt I2C1_ISR_VECTOR
{
    _push_(SFRPI);
    Sample_I2C1_ISR_Handle();
    _pop_(SFRPI);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


