#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P70 used for T4CKO Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P7ModeSelect(P70_PushPull);

    /****************************************************************
     *  Timer4 Initialized
     ****************************************************************/
    __DRV_TIMER4_Mode_Select(TIMER4_SPLIT_MODE4_8BIT_PWM);
    __DRV_TIMER4_Clock_Source_Select(TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER4_SetLowByte(25);
    __DRV_TIMER4_SetRCAP4L(25);
    __DRV_TIMER4_Clock_Out_Cmd(MW_ENABLE);
    __DRV_TIMER4_Run_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Timer4 PWM Signal output
         *  T4CKO(P70) output to LED_D4(P55)
         ****************************************************************/
        __DRV_GPIO_WriteP5(P55, P70);
    }
}
