#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
    Variables
    Temp_TH3    => Store the TH3 value
    Temp_TL3    => Store the TL3 value
    ****************************************************************/
    uint8_t Temp_TH3 = 0, Temp_TL3 = 0;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer3 Initialized
     *  LED Toggle time => (1/(SYSCLK/12)) * 60000) = 0.06 S
     ****************************************************************/
    __DRV_TIMER3_Mode_Select(TIMER3_MODE1_16BIT_AUTORELOAD_WITH_EXTERNAL_INTERRUPT);
    __DRV_TIMER3_Clock_Source_Select(TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12);

    while (1)
    {
        __DRV_TIMER_Globel_Enable_Cmd(TR3E);
        while (Temp_TH3 < 0xEA || Temp_TL3 < 0x60)
        {
            Temp_TH3 = DRV_TIMER3_GetTH3();
            Temp_TL3 = DRV_TIMER3_GetTL3();
        }
        __DRV_TIMER_Globel_Stop_Cmd(T3SC);
        Temp_TH3 = Temp_TL3 = 0;
        __DRV_GPIO_InversePinP5(P55);
        __DRV_TIMER_Globel_Reload_Cmd(T3RLC);
    }
}
