#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer2 overflow Interrupt(TH2) => TF2_Flag
Timer2 external Interrupt      => EXF2_Flag
Timer2 overflow Interrupt(TL2) => TF2L_Flag
****************************************************************/
uint8_t TF2_Flag, EXF2_Flag, TF2L_Flag;

void main()
{
    /****************************************************************
    Variables
    TF2_count(TH2)        => For time delay
    TF2L_count(TL2)       => For time delay
    ****************************************************************/
    uint16_t TF2_count = 0, TF2L_count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer2 interrupt (ET2) = Enable;
     *  2. Setting TL2IS and then open the TF2L interrupt (TL2IE) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER2_IT_Cmd(MW_ENABLE);
    __DRV_TIMER2_Function_Access_Control_Cmd(MW_ENABLE);
    __DRV_TIMER2_TF2L_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P56 used for LED_D5
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P56_PushPull | P55_PushPull);

    /****************************************************************
     *  Timer2 Initialized
     *  TF2 Interrupt time => (1 / (SYSCLK/12)) * 256 * 3906 = 1 S
     *  TF2L Interrupt time => (1 / (SYSCLK/12)) * 100 * 5000 = 0.5 S
     ****************************************************************/
    __DRV_TIMER2_Mode_Select(TIMER2_SPLIT_MODE3_TWO_8BIT_CAPTURE_WITH_AUTO_ZERO);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER2_SetLowByte(156);
    __DRV_TIMER2_SetRCAP2L(156);
    __DRV_TIMER_Globel_Enable_Cmd(TR2E | TR2LE);

    while (1)
    {
        if (TF2_Flag)
        {
            TF2_count += 1;
            if (TF2_count == 3906)
            {
                __DRV_GPIO_InversePinP5(P55);
                TF2_count = 0;
            }
            TF2_Flag = 0;
        }

        if (TF2L_Flag)
        {
            TF2L_count += 1;
            if (TF2L_count == 5000)
            {
                __DRV_GPIO_InversePinP5(P56);
                TF2L_count = 0;
            }
            TF2L_Flag = 0;
        }
    }
}

/****************************************************************
Timer2 interrupt
The Timer2 has TF2, EXF2, TF2L flags to trigger the Timer2 interrupt.
****************************************************************/
void TIMER2_TF2_EXF2_TF2L_ISR(void) interrupt TIMER2_ISR_VECTOR
{
    if (DRV_TIMER2_GetTF2() == 1)
    {
        TF2_Flag = 1;
        DRV_TIMER2_ClearTF2();
    }

    if (DRV_TIMER2_GetTF2L() == 1)
    {
        TF2L_Flag = 1;
        DRV_TIMER2_ClearTF2L();
    }

    if (DRV_TIMER2_GetEXF2() == 1)
    {
        EXF2_Flag = 1;
        DRV_TIMER2_ClearEXF2();
    }
}
