#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer2 overflow Interrupt(TH2) => TF2_Flag
Timer2 external Interrupt      => EXF2_Flag
Timer2 overflow Interrupt(TL2) => TF2L_Flag
****************************************************************/
uint8_t TF2_Flag, EXF2_Flag, TF2L_Flag;

void main()
{
    /****************************************************************
    Variables
    count       => For time delay
    ****************************************************************/
    uint16_t count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer1 interrupt (ET1) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER2_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer2 Initialized
     *  Interrupt time => (1 / (SYSCLK/12)) * 65536 * 15 = 0.983 S
     ****************************************************************/
    __DRV_TIMER2_Mode_Select(TIMER2_MODE2_16BIT_CAPTURE);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER2_Run_Cmd(MW_ENABLE);

    while (1)
    {
        if (TF2_Flag)
        {
            count += 1;
            if (count == 15)
            {
                __DRV_GPIO_InversePinP5(P55);
                count = 0;
            }
            TF2_Flag = 0;
        }
    }
}

/****************************************************************
Timer2 interrupt
The Timer2 has TF2, EXF2, TF2L flags to trigger the Timer2 interrupt.
****************************************************************/
void TIMER2_TF2_EXF2_TF2L_ISR(void) interrupt TIMER2_ISR_VECTOR
{
    if (DRV_TIMER2_GetTF2() == 1)
    {
        TF2_Flag = 1;
        DRV_TIMER2_ClearTF2();
    }

    if (DRV_TIMER2_GetTF2L() == 1)
    {
        TF2L_Flag = 1;
        DRV_TIMER2_ClearTF2L();
    }

    if (DRV_TIMER2_GetEXF2() == 1)
    {
        EXF2_Flag = 1;
        DRV_TIMER2_ClearEXF2();
    }
}
