#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "stdio.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_UART0_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : UART0_9600_Init
 *  Use the Timer1(T1OF) as UART0 clock source.
 ****************************************************************/
void UART0_9600_Init(void)
{
    // UART0 Register initial Tx:P31 Rx:P30
    __DRV_URT0_SetSM10(UART0_MODE1_8BIT);
    __DRV_URT0_SerialReception_Cmd(MW_ENABLE);
    TI0 = 1;

    // Use Timer1 Auto reload mode to generate the baud rate 9600
    __DRV_TIMER1_Mode_Select(TIMER1_MODE2_8BIT_AUTORELOAD);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK);
    __DRV_TIMER1_Set8BitIntervalAutoReload(217);
    __DRV_TIMER1_Run_Cmd(MW_ENABLE);
}

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer2 overflow Interrupt(TH2) => TF2_Flag
Timer2 external Interrupt      => EXF2_Flag
Timer2 overflow Interrupt(TL2) => TF2L_Flag
****************************************************************/
uint8_t TF2_Flag, EXF2_Flag, TF2L_Flag;

void main()
{
    /****************************************************************
    Variables
    count       => For time delay
    Temp_TH2    => Store the TH2 value
    Temp_TL2    => Store the TL2 value
    Temp_RCAP2H => Store the RCAP2H value
    Temp_RCAP2L => Store the RCAP2L value
    ****************************************************************/
    uint32_t count = 0;
    uint8_t Temp_RCAP2H = 0, Temp_RCAP2L = 0;
    uint8_t Temp_TH2 = 0, Temp_TL2 = 0;

    /****************************************************************
     *  UART0 Initialized
     ****************************************************************/
    UART0_9600_Init();

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer2 interrupt (ET2) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER2_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P10 used for T2 Pin
     *  2. P11 used for T2EX Pin
     ****************************************************************/
    __DRV_GPIO_P1ModeSelect(P11_OpenDrainPullUp | P10_OpenDrainPullUp);

    /****************************************************************
     *  Timer2 Initialized
     *  1. Capture Source = T2EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER2_Mode_Select(TIMER2_MODE2_16BIT_CAPTURE);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_T2_PIN);
    __DRV_TIMER2_Set16BitCounter(0);
    __DRV_TIMER2_Set16Bit_AutoReloadValue(0);
    __DRV_TIMER2_Capture_Source_Select(TIMER2_CAPTURE_SOURCE_T2EX_PIN);
    __DRV_TIMER2_Capture_Source_Dectect(Timer2_FALLING_EDGE);
    __DRV_TIMER2_Run_Cmd(MW_ENABLE);

    /****************************************************************
     *  Timer2 External Trigger
     *  Timer counter source = T2 Pin(P10)
     *  Trigger source = T2EX Pin(P11)
     ****************************************************************/
    __DRV_GPIO_WriteP1(P11, 1);
    while (1)
    {
        for (count = 0; count < 0x2FE; count++)
        {
            __DRV_GPIO_InversePinP1(P10);
        }
        __DRV_GPIO_WriteP1(P11, 0);
        while (EXF2_Flag == 0);
        if (EXF2_Flag == 1)
        {
            Temp_TH2 = DRV_TIMER2_GetTH2();
            Temp_TL2 = DRV_TIMER2_GetTL2();
            printf("Counter TH2=%X TL2=%X\n", (uint16_t)Temp_TH2, (uint16_t)Temp_TL2);
            Temp_RCAP2H = DRV_TIMER2_GetRCAP2H();
            Temp_RCAP2L = DRV_TIMER2_GetRCAP2L();
            printf("Capture RCAP2H = %X, RCAP2L = %X\n", (uint16_t)Temp_RCAP2H, (uint16_t)Temp_RCAP2L);
            __DRV_TIMER2_Set16BitCounter(0);
            __DRV_TIMER2_Set16Bit_AutoReloadValue(0);
            __DRV_GPIO_WriteP1(P11, 1);
            delay_ms(1000);
            EXF2_Flag = 0;
        }
    }
}

/****************************************************************
Timer2 interrupt
The Timer2 has TF2?EXF2?TF2L flags to trigger the Timer2 interrupt.
****************************************************************/
void TIMER2_TF2_EXF2_TF2L_ISR(void) interrupt TIMER2_ISR_VECTOR
{
    if (DRV_TIMER2_GetTF2() == 1)
    {
        TF2_Flag = 1;
        DRV_TIMER2_ClearTF2();
    }

    if (DRV_TIMER2_GetTF2L() == 1)
    {
        TF2L_Flag = 1;
        DRV_TIMER2_ClearTF2L();
    }

    if (DRV_TIMER2_GetEXF2() == 1)
    {
        EXF2_Flag = 1;
        DRV_TIMER2_ClearEXF2();
    }
}
