#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
    Variables
    Temp_TH2 => Store the TH2 value
    Temp_TL2 => Store the TL2 value
    ****************************************************************/
    uint8_t Temp_TH2 = 0, Temp_TL2 = 0;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer2 Initialized
     *  LED Toggle time => (1/(SYSCLK/12)) * 60000) = 0.06 S
     ****************************************************************/
    __DRV_TIMER2_Mode_Select(TIMER2_MODE1_16BIT_AUTORELOAD_WITH_EXTERNAL_INTERRUPT);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12);

    while (1)
    {
        /****************************************************************
         *  Timer2 Global control running
         *  Run to 0xEA60(60000) -> stop running -> Inverse P55(LED4) -> Reload 0x0000
         ****************************************************************/
        __DRV_TIMER_Globel_Enable_Cmd(TR2E);
        while (Temp_TH2 < 0xEA || Temp_TL2 < 0x60)
        {
            Temp_TH2 = DRV_TIMER2_GetTH2();
            Temp_TL2 = DRV_TIMER2_GetTL2();
        }
        __DRV_TIMER_Globel_Stop_Cmd(T2SC);
        Temp_TH2 = Temp_TL2 = 0;
        __DRV_GPIO_InversePinP5(P55);
        __DRV_TIMER_Globel_Reload_Cmd(T2RLC);
    }
}
