#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_Timer_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer0 Interrupt => TF0_Flag
Timer1 Interrupt => TF1_Flag
****************************************************************/
uint8_t TF0_Flag, TF1_Flag;

void main()
{
    /****************************************************************
    Variables
    T0_count => For time delay(TL0)
    T1_count => For time delay(TH0)
    ****************************************************************/
    uint16_t T0_count = 0, T1_count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer0 interrupt (ET0) = Enable;
     *  2. Enable Timer1 interrupt (ET1) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER0_IT_Cmd(MW_ENABLE);
    __DRV_TIMER1_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  1. P56 used for LED_D5
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull | P56_PushPull);

    /****************************************************************
     *  Timer0 Initialized
     *  Interrupt time = 1 S (1/ILRCO * 256 * 125)
     ****************************************************************/
    __DRV_TIMER1_Mode_Select(TIMER1_MODE3_TIMER1_STOPPED);
    __DRV_TIMER0_Mode_Select(TIMER0_MODE3_TWO_8BIT);
    __DRV_TIMER0_Clock_Source_Select(TIMER0_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER1_Clock_Source_Select(TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER_Globel_Enable_Cmd(TR0E | TR1E);

    while (1)
    {
        /****************************************************************
         *  Handle interrupt request & count interrupt times
         ****************************************************************/
        if (TF0_Flag)
        {
            T0_count += 1;
            TF0_Flag = 0;
        }
        else if (TF1_Flag)
        {
            T1_count += 1;
            TF1_Flag = 0;
        }

        /****************************************************************
         *  LED_D4 => (1 / (SYSCLK/12)) * 256 * 3906 = 1 S
         *  LED_D5 => (1 / (SYSCLK/12)) * 256 * 1953 = 0.5 S
         ****************************************************************/
        if (T0_count == 3906)
        {
            __DRV_GPIO_InversePinP5(P55);
            T0_count = 0;
        }
        else if (T1_count == 1953)
        {
            __DRV_GPIO_InversePinP5(P56);
            T1_count = 0;
        }
    }
}

/****************************************************************
Timer0 interrupt
Timer0 interrupt flag (TF0) is cleared by hardware interrupt.
****************************************************************/
void TIMER0_TF0_ISR(void) interrupt TIMER0_ISR_VECTOR
{
    TF0_Flag = 1;
}

/****************************************************************
Timer1 interrupt
Timer1 interrupt flag (TF1) is cleared by hardware interrupt.
****************************************************************/
void TIMER1_TF1_ISR(void) interrupt TIMER1_ISR_VECTOR
{
    TF1_Flag = 1;
}
