#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"
#include "MGEQ1C064_RTC_DRV.h"
#include "MGEQ1C064_PW_DRV.h"
#include "MGEQ1C064_INT_DRV.h"
#include "MGEQ1C064_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
RTC Interrupt => RTCF_Flag
****************************************************************/
uint8_t RTCF_Flag = 0;

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable RTCF interrupt (RTCFIE) = Enable;
     *  2. Enable System Flag interrupt (ESF) = Enable;
     *  3. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_RTC_IT_Cmd(MW_ENABLE);
    __DRV_INT_SystemFlag_IT_Enable();
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P44 & P45 Disable OCD Function (OCDE) = Disable
     *  2.1 P45 used for RTCKO
     *  2.2 P56 used for LED_D5
     *  2.3 P57 used for LED_D6
     *  2.4 P60 used for ECKI (External clock input)
     ****************************************************************/
    __DRV_GPIO_SetOCD2IO(MW_DISABLE);
    __DRV_GPIO_P4ModeSelect(P45_OpenDrainPullUp);
    __DRV_GPIO_P5ModeSelect(P57_PushPull | P56_PushPull);
    __DRV_GPIO_P6ModeSelect(P60_OpenDrainPullUp);

    /****************************************************************
     *  RTC Initialized
     *  1. RTCKO Speed = ECKI / 32768
     *  2. Enable the RTCKO output on P4.5
     *  3. RTC = Enable
     ****************************************************************/
    __DRV_RTC_ClockSource_Select(RTC_CLK_P60);
    __DRV_RTC_SetPrescaler(RTC_RTCCS_DIV_32768);
    __DRV_RTC_SetRTCKO(MW_ENABLE);
    __DRV_RTC_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Interrupt time of RTC_Flag
         *  ECKI(32768KHz) / 32768 = 1S (Hardware output of RTCKO = 1S)
         *  If P6.0 (ECKI) have clock input the RTC interrupt will be invert P5.6 level.
         *  P5.7 will be continuously invert pin level per 50mS.
         ****************************************************************/
        if (RTCF_Flag)
        {
            __DRV_GPIO_InversePinP5(P56);
            RTCF_Flag = 0;
        }
        __DRV_GPIO_InversePinP5(P57);
        delay_ms(50);
    }
}

void SYSFlag_RTC_ISR() interrupt SYSFLAG_ISR_VECTOR
{
    // To check RTC Flag
    if ((PCON1 & RTCF) == RTCF)
    {
        RTCF_Flag = 1;
        __DRV_RTC_ClearFlag();
    }
}
