#include <intrins.h>
#include "REG_MGEQ1C064.h"
#include "TYPEDEF.h"
#include "MGEQ1C064_COMMON_DRV.h"
#include "MGEQ1C064_GPIO_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    while (1)
    {
        /****************************************************************
         *  P4 OCD, RST pin used to port operation.
         *  1. Disable OCD(P44, P45), RST(P47) function.
         *  2. Setting pin mode.
         *  3. Inverse P44, P45, P47 every 200mS.
         *  4. Enable OCD, RST function.
         *  P.S EV board TH210A P47 pin can't inverse because the pin voltage level is lock by reset circuit.
         ****************************************************************/
        __DRV_GPIO_SetOCD2IO(MW_DISABLE);
        __DRV_GPIO_SetRST2IO(MW_DISABLE);
        __DRV_GPIO_P4ModeSelect(P44_OpenDrainPullUp | P45_OpenDrainPullUp | P47_OpenDrainPullUp);
        __DRV_GPIO_InversePinP4(P44);
        __DRV_GPIO_InversePinP4(P45);
        __DRV_GPIO_InversePinP4(P47);
        delay_ms(200);
        __DRV_GPIO_SetOCD2IO(MW_ENABLE);
        __DRV_GPIO_SetRST2IO(MW_ENABLE);
    }
}
