/*********************************************************************
    Ŀ:MA82G5Cxx-DEMO
			԰ʹ MA82G5C64 LQFP64_V10	Ev Board (TH167A)
			CpuCLK=12MHz, SysCLK=12MHz
	  
			ʹTWSI0 (SCL/P40, SDA/P41)ģʽжϴ
			ʹTWSI1 (SCL/P42, SDA/P43)ģʽжϴ
 	  ע

	  ʱ:
	  ޸־:
	  
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5Cxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5Cxx.H"
#include ".\include\API_Uart_BRGRL_MA82G5Cxx.H"


/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.25MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define TWI0_SCL		P40
#define TWI0_SDA		P41

#define TWI1_SCL		P42
#define TWI1_SDA		P43

#define SLAVE_ADDRESS	0xA0
#define TEST_BUF_SIZE	16

#define	TWI_OV_TIME_MAX			20

u8	TWI0OvTime;
u8	TWI1OvTime;
bit bTWI0Error;
bit bTWI1Error;
bit bTWI0ADFlag;
bit bTWI1ADFlag;

bit bTWI0RXFlag;
bit bTWI1RXFlag;

WordTypeDef TWI0RegAddr;
WordTypeDef TWI1RegAddr;
xdata u8 TWI0Buf[TEST_BUF_SIZE];
xdata u8 TWI1Buf[TEST_BUF_SIZE];
u8 TWI0Inx;
u8 TWI1Inx;
bit bES0;
u8 LedTime;

/***********************************************************************************
:   void INT_T0(void)
:T0 жϷ
		 1ms
:   
ز:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;
	if(TWI0OvTime!=0) 
	{
		TWI0OvTime--;
		if(TWI0OvTime==0) bTWI0Error=TRUE;
	}
	if(TWI1OvTime!=0) 
	{
		TWI1OvTime--;
		if(TWI1OvTime==0) bTWI1Error=TRUE;
	}
	if(LedTime!=0) LedTime--;
}


/***********************************************************************************
:   void INT_TWI0(void)
:TWI0 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_TWI0() interrupt INT_VECTOR_TWI0
{
	_push_(SFRPI);
	SFR_SetPage(0);
	if(SISTA==0x80)
	{ // 0x80: յ,ҷACK
		TWI0OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
		if(bTWI0ADFlag==0)
		{// Regַ
			if(TWI0Inx==0)
			{
				TWI0RegAddr.B.BHigh=SIDAT;
				TWI0Inx++;
			}
			else 
			{
				TWI0RegAddr.B.BLow=SIDAT;
				bTWI0ADFlag=1;					// Data
				TWI0Inx=0;
			}
		}
		else
		{
			TWI0Buf[TWI0Inx]=SIDAT;				// յݶȡ
			TWI0Inx++;
			if(TWI0Inx>=TEST_BUF_SIZE) 
			{
				bTWI0RXFlag=TRUE;
				TWI0Inx=0;
				TWI0OvTime = 0; 				// ʱʱ㣬ټ鳬ʱ
			}
		}
	}
	else if((SISTA==0x60)||(SISTA==0x68))
	{// 0x60,0x68: յӻַ+д,ҷACK
		bTWI0ADFlag=0;					// Regַ
		TWI0Inx=0;
		TWI0OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
	}
	else if((SISTA==0xA8)||(SISTA==0xB0))
	{// 0x60,0x68: յӻַ+,ҷACK
		TWI0Inx=0;						// ͻ
		goto _IIC_SET_SIDAT;
	}
	else if((SISTA==0xB8)||(SISTA==0xC0)||(SISTA==0xC8))
	{
        // 0xB8:  SIDATѾͳȥ,յACK
		// 0xC0:  SIDATѾͳȥ,ûյACK
		// 0xC8:  SIDATѾͳȥ,յACK
_IIC_SET_SIDAT:
		TWI0OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
		if(TWI0Inx>=TEST_BUF_SIZE) 
		{
			TWI0Inx=0;
			TWI0OvTime = 0; 				// ʱʱ㣬ټ鳬ʱ
		}
		SIDAT=TWI0Buf[TWI0Inx]; 				// Ҫ͵
		TWI0Inx++;
	}
	TWI0_SCL=0;
	SICON=SICON|(AA);						// AA
	SICON=SICON&(~SI);						// жϱ־
	TWI0_SCL=1;

	_pop_(SFRPI);
}

/***********************************************************************************
:   void INT_TWI1(void)
:TWI1 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_TWI1() interrupt INT_VECTOR_TWI1
{
	_push_(SFRPI);
	SFR_SetPage(1);
	if(SI1STA==0x80)
	{ // 0x80: յ,ҷACK
		TWI1OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
		if(bTWI1ADFlag==0)
		{// Regַ
			if(TWI1Inx==0)
			{
				TWI1RegAddr.B.BHigh=SI1DAT;
				TWI1Inx++;
			}
			else 
			{
				TWI1RegAddr.B.BLow=SI1DAT;
				bTWI1ADFlag=1;					// Data
				TWI1Inx=0;
			}
		}
		else
		{
			TWI1Buf[TWI1Inx]=SI1DAT;				// յݶȡ
			TWI1Inx++;
			if(TWI1Inx>=TEST_BUF_SIZE) 
			{
				bTWI1RXFlag=TRUE;
				TWI1Inx=0;
				TWI1OvTime = 0; 				// ʱʱ㣬ټ鳬ʱ
			}
		}
	}
	else if((SI1STA==0x60)||(SI1STA==0x68))
	{// 0x60,0x68: յӻַ+д,ҷACK
		bTWI1ADFlag=0;					// Regַ
		TWI1Inx=0;
		TWI1OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
	}
	else if((SI1STA==0xA8)||(SI1STA==0xB0))
	{// 0x60,0x68: յӻַ+,ҷACK
		TWI1Inx=0;						// ͻ
		goto _IIC_SET_SI1DAT;
	}
	else if((SI1STA==0xB8)||(SI1STA==0xC0)||(SI1STA==0xC8))
	{
        // 0xB8:  SIDATѾͳȥ,յACK
		// 0xC0:  SIDATѾͳȥ,ûյACK
		// 0xC8:  SIDATѾͳȥ,յACK
_IIC_SET_SI1DAT:
		TWI1OvTime = TWI_OV_TIME_MAX;			// IICʱʱ
		if(TWI1Inx>=TEST_BUF_SIZE) 
		{
			TWI1Inx=0;
			TWI1OvTime = 0; 					// ʱʱ㣬ټ鳬ʱ
		}
		SI1DAT=TWI1Buf[TWI1Inx]; 				// Ҫ͵
		TWI1Inx++;
	}
	TWI1_SCL=0;
	SI1CON=SI1CON|(AA);						// AA
	SI1CON=SI1CON&(~SI1);					// жϱ־
	TWI1_SCL=1;
	_pop_(SFRPI);
}


/***********************************************************************************
:   void SendByte(u8 tByte)
:ͨUARTһֽ
: 
		u8 tByte: ͵
ز:

*************************************************************************************/
void SendByte(u8 tByte)
{
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
:   void SendStr(u8* PStr)
:ͨUARTַ
: 
		u8* PStr: ַַ  
ز:

*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
:   void SendHex(u8 ToSend)
:ͨUARTASCII뷢16Ƶ
: 
		u8 ToSend: ͵16  
ز:

*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}


/*************************************************
:     void DelayXus(u16 xUs)
:   		ʱ,λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
:        		
:
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}


/*************************************************
:     void DelayXms(u16 xMs)
:   		ʱ,λΪms
ú:        
:     u16 xMs -> *1ms  (1~65535)
:     
:        		
:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;

	}
}

/***********************************************************************************
:   void InitUart0_S1BRG(void)
:   Uartʼ
		  S1BRGΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{
	// 8λ ɱ䲨
	UART0_SetMode8bitUARTVar();

	// òԴΪ T1
	UART0_SetBRGFromS1BRG();
	// 4x
	UART0_SetS1BRGBaudRateX4();

	UART1_SetS1BRGSelSYSCLK();
	UART1_SetS1BRGValue(S1BRG_BRGRL_115200_4X_12000000_1T);
	UART1_EnS1BRG();	
}

/***********************************************************************************
:   void InitTimer0(void)
:Timer0ʼ
		 T0Ϊ16λʱ,ʱΪSysclk/12 
:   
ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);						// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);					// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);					// P55,P56,P57Ϊ(LED)
	PORT_SetP4OpenDrain(BIT0|BIT1|BIT2|BIT3);			// P40,P41,P42,P43Ϊ©(TWI1:SCL/SDA)
	PORT_EnP40P41P42P43PullHigh();
}

/***********************************************************************************
:   void InitTWI0_Slave(void)
:TWI0ʼ ӻģʽ
:   
ز:     
*************************************************************************************/
void InitTWI0_Slave()
{
	TWI0_Clear();
	TWI0_SetClock(TWI0_CLK_SYSCLK_32);
	TWI0_SetSCLSDAP40P41();
	TWI0_Enable();
	TWI0_SetSlaveAddr(SLAVE_ADDRESS);
	TWI0_SendACK();

}

/***********************************************************************************
:   void InitTWI1_Slave(void)
:TWI1ʼ ӻģʽ
:   
ز:     
*************************************************************************************/
void InitTWI1_Slave()
{
	TWI1_Clear();
	TWI1_SetClock(TWI1_CLK_SYSCLK_32);
	TWI1_SetSCLSDAP42P43();
	TWI1_Enable();
	TWI1_SetSlaveAddr(SLAVE_ADDRESS);
	TWI1_SendACK();

}


/******************************************************************************
*****
:   void InitClock(void)
:   ϵͳʱӳʼ
:   
ز:     
*******************************************************************************
******/
void InitClock()
{
	
#if (MCU_CPUCLK>=24000000)
	CLK_SetCpuCLK_HighSpeed();
#endif		


#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}


/***********************************************************************************
:   void InitInterrupt(void)
:   жϳʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();						// ʹT0ж
	INT_EnTWI0();						// ʹTWI0ж
	INT_EnTWI1();						// ʹTWI1ж
}	


/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTWI0_Slave();
	InitTWI1_Slave();
	InitTimer0();
	InitUart0_S1BRG();
	InitInterrupt();

	INT_EnAll();			//  ʹȫж

}

void main()
{
	u8 i;
    InitSystem();


 	SendStr("\nStart");
 	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	TWI0OvTime = 0; 				// ʱʱ㣬鳬ʱ
	TWI1OvTime = 0; 				// ʱʱ㣬鳬ʱ

    while(1)
    {
    	if(LedTime==0)
    	{
			LED_R = !LED_R;
			if(LED_R==0)
			{
				LedTime=20;
			}
			else
			{
				LedTime=250;
			}
    	}
    	if(bTWI0RXFlag==TRUE)
    	{
			LED_G_0=0;LED_R=1;
			SendStr("\nTWI0 RX 0x");
			SendHex(TWI0RegAddr.B.BHigh);
			SendHex(TWI0RegAddr.B.BLow);
			for(i=0;i<TEST_BUF_SIZE;i++)
			{
				SendByte(' ');
				SendHex(TWI0Buf[i]);
			}
			bTWI0RXFlag=FALSE;
			LED_G_0=1;LED_R=1;
			LedTime=250;
    	}
    	if(bTWI1RXFlag==TRUE)
    	{
			LED_G_1=0;LED_R=1;
			SendStr("\nTWI1 RX 0x");
			SendHex(TWI1RegAddr.B.BHigh);
			SendHex(TWI1RegAddr.B.BLow);
			for(i=0;i<TEST_BUF_SIZE;i++)
			{
				SendByte(' ');
				SendHex(TWI1Buf[i]);
			}
			bTWI1RXFlag=FALSE;
			LED_G_1=1;LED_R=1;
			LedTime=250;
    	}
    	
    	if(bTWI0Error==TRUE)
    	{
    		bTWI0Error=FALSE;
			// ,TWI0
			LED_G_0=0;LED_R=0;
			InitTWI0_Slave();
			DelayXms(50);
			LED_G_0=1;LED_R=1;
			LedTime=250;
    	}
		if(bTWI1Error==TRUE)
		{
			bTWI1Error=FALSE;
			// ,TWI0
			LED_G_1=0;LED_R=0;
			InitTWI1_Slave();
			DelayXms(50);
			LED_G_1=1;LED_R=1;
			LedTime=250;
		}
    }
}



