/**
 ******************************************************************************
 *
 * @file        REG_MG82F6P32.H
 *
 * @brief       This is the header file of the SFR address.
 *
 * @par         Project
 *              MG82F6P32
 * @version     v1.00
 * @date        2024/01/15
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IF"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 @if HIDE
 Modify History:
 * #1.00_Blake_20240115
 * >>Initial version
 @endif
 ******************************************************************************
 * @internal
 * @sign
 * @endinternal
 */

#ifndef __REG_MG82F6P32_H
#define __REG_MG82F6P32_H

#define GF_7         0x80
#define GF_6         0x40
#define GF_5         0x20
#define GF_4         0x10
#define GF_3         0x08
#define GF_2         0x04
#define GF_1         0x02
#define GF_0         0x01

sfr P0                     = 0x80;     //Port 0
#define P0_Page              0x00
// (bits in P0)
sbit P07                   = P0^7;
sbit P05                   = P0^5;
sbit P02                   = P0^2;
sbit P01                   = P0^1;

sfr SP                     = 0x81;     //Stack Pointer
#define SP_Page              0x00

sfr DPL                    = 0x82;     //Data Pointer Low
#define DPL_Page             0x00

sfr DPH                    = 0x83;     //Data Pointer High
#define DPH_Page             0x00

sfr SPSTAT                 = 0x84;     //SPI Status Register
#define SPSTAT_Page          0x00
// (bits in SPSTAT)
#define SPIF                 0x80
#define WCOL                 0x40
#define THRF                 0x20
#define SPIBSY               0x10
#define MODF                 0x08

sfr SPCON                  = 0x85;     //SPI Control Register
#define SPCON_Page           0x00
// (bits in SPCON)
#define SSIG                 0x80
#define SPEN                 0x40
#define DORD                 0x20
#define MSTR                 0x10
#define CPOL                 0x08
#define CPHA                 0x04

sfr SPCR1                  = 0x85;     //SPI Control Register 1
#define SPCR1_Page           0x08
// (bits in SPCR1)
#define SPSOES               0x80
#define SPFACE               0x40
#define SPI0M0               0x08
#define SPR2                 0x04
#define SPR1                 0x02
#define SPR0                 0x01

sfr SPDAT                  = 0x86;     //SPI Data Register
#define SPDAT_Page           0x00

sfr PCON0                  = 0x87;     //Power Control 0
#define PCON0_Page           0x00
// (bits in PCON0)
#define SMOD1                0x80
#define SMOD0                0x40
#define POF0                 0x10
#define GF1                  0x08
#define GF0                  0x04
#define PD                   0x02
#define IDL                  0x01

sfr TCON                   = 0x88;     //Timer Control
#define TCON_Page            0x00
// (bits in TCON)
sbit TF1                   = TCON^7;
sbit TR1                   = TCON^6;
sbit TF0                   = TCON^5;
sbit TR0                   = TCON^4;
sbit IE1                   = TCON^3;
sbit IT1                   = TCON^2;
sbit IE0                   = TCON^1;
sbit IT0                   = TCON^0;

sfr TMOD                   = 0x89;     //Timer Mode
#define TMOD_Page            0x00
// (bits in TMOD)
#define T1GATE               0x80
#define T1C_T                0x40
#define T1M1                 0x20
#define T1M0                 0x10
#define T0GATE               0x08
#define T0C_T                0x04
#define T0M1                 0x02
#define T0M0                 0x01

sfr TL0                    = 0x8A;     //Timer Low 0
#define TL0_Page             0x00

sfr TL1                    = 0x8B;     //Timer Low 1
#define TL1_Page             0x00

sfr TH0                    = 0x8C;     //Timer High 0
#define TH0_Page             0x00

sfr TH1                    = 0x8D;     //Timer High 1
#define TH1_Page             0x00

sfr SFIE                   = 0x8E;     //System Flag INT En.
#define SFIE_Page            0x00
// (bits in SFIE)
#define SIDFIE               0x80
#define MCDRE                0x40
#define MCDFIE               0x20
#define RTCFIE               0x10
#define SPWIE                0x08
#define BOF1IE               0x04
#define BOF0IE               0x02
#define WDTFIE               0x01

sfr XRPS                   = 0x8F;     //XRAM Page Select
#define XRPS_Page            0x00

sfr P1                     = 0x90;     //Port 1
#define P1_Page              0x00
// (bits in P1)
sbit P17                   = P1^7;
sbit P16                   = P1^6;
sbit P15                   = P1^5;
sbit P14                   = P1^4;
sbit P13                   = P1^3;
sbit P12                   = P1^2;
sbit P11                   = P1^1;
sbit P10                   = P1^0;

sfr P1M0                   = 0x91;     //P1 Mode Register 0
#define P1M0_Page            0x00
// (bits in P1M0)
#define P1M07                0x80
#define P1M06                0x40
#define P1M05                0x20
#define P1M04                0x10
#define P1M03                0x08
#define P1M02                0x04
#define P1M01                0x02
#define P1M00                0x01

sfr P1M1                   = 0x92;     //P1 Mode Register 1
#define P1M1_Page            0x00
// (bits in P1M1)
#define P1M17                0x80
#define P1M16                0x40
#define P1M15                0x20
#define P1M14                0x10
#define P1M13                0x08
#define P1M12                0x04
#define P1M11                0x02
#define P1M10                0x01

sfr P2M1                   = 0x92;     //P2 Mode Register 1
#define P2M1_Page            0x01
// (bits in P2M1)
#define P2M16                0x40
#define P2M14                0x10
#define P2M13                0x08
#define P2M12                0x04

sfr P4M1                   = 0x92;     //P4 Mode Register 1
#define P4M1_Page            0x02
// (bits in P4M1)
#define P4M17                0x80
#define P4M15                0x20
#define P4M14                0x10
#define P4M11                0x02
#define P4M10                0x01

sfr P6M1                   = 0x92;     //P6 Mode Register 1
#define P6M1_Page            0x03
// (bits in P6M1)
#define P6M11                0x02
#define P6M10                0x01

sfr P0M1                   = 0x92;     //P0 Mode Register 1
#define P0M1_Page            0x04
// (bits in P0M1)
#define P0M17                0x80
#define P0M15                0x20
#define P0M12                0x04
#define P0M11                0x02

sfr P3FDC                  = 0x92;     //P3 Fast Drv. Ctrl.
#define P3FDC_Page           0x07
// (bits in P3FDC)
#define P3FDC5               0x20
#define P3FDC4               0x10
#define P3FDC3               0x08
#define P3FDC2               0x04
#define P3FDC1               0x02
#define P3FDC0               0x01

sfr P1FDC                  = 0x92;     //P1 Fast Drv. Ctrl.
#define P1FDC_Page           0x08
// (bits in P1FDC)
#define P1FDC7               0x80
#define P1FDC6               0x40
#define P1FDC5               0x20
#define P1FDC4               0x10
#define P1FDC3               0x08
#define P1FDC2               0x04
#define P1FDC1               0x02
#define P1FDC0               0x01

sfr P2FDC                  = 0x92;     //P2 Fast Drv. Ctrl.
#define P2FDC_Page           0x09
// (bits in P2FDC)
#define P2FDC6               0x40
#define P2FDC4               0x10
#define P2FDC3               0x08
#define P2FDC2               0x04

sfr P4FDC                  = 0x92;     //P4 Fast Drv. Ctrl.
#define P4FDC_Page           0x0A
// (bits in P4FDC)
#define P4FDC7               0x80
#define P4FDC5               0x20
#define P4FDC4               0x10
#define P4FDC1               0x02
#define P4FDC0               0x01

sfr P0FDC                  = 0x92;     //P0 Fast Drv. Ctrl.
#define P0FDC_Page           0x0B
// (bits in P0FDC)
#define P0FDC7               0x80
#define P0FDC5               0x20
#define P0FDC2               0x04
#define P0FDC1               0x02

sfr P3M2                   = 0x92;     //P3 Mode Register 2
#define P3M2_Page            0x0F
// (bits in P3M2)
#define P3M25                0x20
#define P3M24                0x10
#define P3M23                0x08
#define P3M22                0x04
#define P3M21                0x02
#define P3M20                0x01

sfr P0M0                   = 0x93;     //P0 Mode Register 0
#define P0M0_Page            0x00
// (bits in P0M0)
#define P0M07                0x80
#define P0M05                0x20
#define P0M02                0x04
#define P0M01                0x02

sfr T2MOD1                 = 0x93;     //Timer2 mode 1 Reg.
#define T2MOD1_Page          0x01
// (bits in T2MOD1)
#define TL2CS                0x80
#define TF2IG                0x40
#define TL2IS                0x20
#define T2CKS                0x10
#define T2MS1                0x08
#define CP2S2                0x04
#define CP2S1                0x02
#define CP2S0                0x01

sfr T3MOD1                 = 0x93;     //Timer3 mode 1 Reg.
#define T3MOD1_Page          0x02
// (bits in T3MOD1)
#define TL3CS                0x80
#define TF3IG                0x40
#define TL3IS                0x20
#define T3CKS                0x10
#define T3MS1                0x08
#define CP3S2                0x04
#define CP3S1                0x02
#define CP3S0                0x01

sfr DMACR0                 = 0x94;     //DMA Control Reg. 0
#define DMACR0_Page          0x00
// (bits in DMACR0)
#define DMAE0                0x08
#define DMAS0                0x04
#define DIE0                 0x02
#define DCF0                 0x01

sfr DMACG0                 = 0x94;     //DMA Configured Reg. 0
#define DMACG0_Page          0x08
// (bits in DMACG0)
#define PDMAH                0x80
#define PDMAL                0x40
#define CRCW0                0x20
#define EXTS10               0x08
#define EXTS00               0x04
#define LOOP0                0x01

sfr DMADS0                 = 0x94;     //DMA Data path Selection 0
#define DMADS0_Page          0x09
// (bits in DMADS0)
#define DSS30                0x80
#define DSS20                0x40
#define DSS10                0x20
#define DSS00                0x10
#define DDS30                0x08
#define DDS20                0x04
#define DDS10                0x02
#define DDS00                0x01

sfr P2M0                   = 0x95;     //P2 Mode Register 0
#define P2M0_Page            0x00
// (bits in P2M0)
#define P2M06                0x40
#define P2M04                0x10
#define P2M03                0x08
#define P2M02                0x04

sfr TREN0                  = 0x95;     //Timer Run Enable Register 0
#define TREN0_Page           0x01
// (bits in TREN0)
#define TR2E                 0x80
#define TR3E                 0x40
#define TR4E                 0x20
#define C1CR                 0x02
#define PTMCR                0x01

sfr TRLC0                  = 0x95;     //Timer Reload Control Register 0
#define TRLC0_Page           0x02
// (bits in TRLC0)
#define T2RLC                0x80
#define T3RLC                0x40
#define T4RLC                0x20
#define C1RLC                0x02
#define PTMRLC               0x01

sfr TSPC0                  = 0x95;     //Timer Stop Control Register 0
#define TSPC0_Page           0x03
// (bits in TSPC0)
#define T2SC                 0x80
#define T3SC                 0x40
#define T4SC                 0x20
#define C1SC                 0x02
#define PTMSC                0x01

sfr BOREV                  = 0x96;     //Bit Order Reversed
#define BOREV_Page           0x00

sfr PCON1                  = 0x97;     //Power Control 1
#define PCON1_Page           0x00
// (bits in PCON1)
#define SWRF                 0x80
#define EXRF                 0x40
#define MCDF                 0x20
#define RTCF                 0x10
#define SPWF                 0x08
#define BOF1                 0x04
#define BOF0                 0x02
#define WDTF                 0x01

sfr S0CON                  = 0x98;     //Serial 0 Control
#define S0CON_Page           0x00
// (bits in S0CON)
sbit SM00                  = S0CON^7;
sbit FE                    = S0CON^7;
sbit SM00_FE               = S0CON^7;
sbit SM10                  = S0CON^6;
sbit SM20                  = S0CON^5;
sbit REN0                  = S0CON^4;
sbit TB80                  = S0CON^3;
sbit RB80                  = S0CON^2;
sbit TI0                   = S0CON^1;
sbit RI0                   = S0CON^0;

sfr S0AGCR                 = 0x98;     //Serial 0 ARGB Control
#define S0AGCR_Page          0x00
// (bits in S0AGCR)
sbit S0DTY1                = S0AGCR^5;
sbit S0GFIE                = S0AGCR^4;
sbit S0IDT11               = S0AGCR^3;
sbit S0IDT01               = S0AGCR^2;
sbit S0AGBF                = S0AGCR^1;
sbit S0AGBRF               = S0AGCR^0;

sfr S1CON                  = 0x98;     //Serial 1 Control
#define S1CON_Page           0x01
// (bits in S1CON)
sbit SM01                  = S1CON^7;
sbit SM11                  = S1CON^6;
sbit SM21                  = S1CON^5;
sbit REN1                  = S1CON^4;
sbit TB81                  = S1CON^3;
sbit RB81                  = S1CON^2;
sbit TI1                   = S1CON^1;
sbit RI1                   = S1CON^0;

sfr S1AGCR                 = 0x98;     //Serial 1 ARGB Control
#define S1AGCR_Page          0x01
// (bits in S1AGCR)
sbit S1DTY1                = S1AGCR^5;
sbit S1GFIE                = S1AGCR^4;
sbit S1IDT11               = S1AGCR^3;
sbit S1IDT01               = S1AGCR^2;
sbit S1AGBF                = S1AGCR^1;
sbit S1AGBRF               = S1AGCR^0;

sfr S0BUF                  = 0x99;     //Serial 0 Buffer
#define S0BUF_Page           0x00

sfr S1BUF                  = 0x99;     //Serial 1 Buffer
#define S1BUF_Page           0x01

sfr S0BRT                  = 0x9A;     //S0 Baud-Rate Timer
#define S0BRT_Page           0x00

sfr S1BRT                  = 0x9A;     //S1 Baud-Rate Timer
#define S1BRT_Page           0x01

sfr S0BRC                  = 0x9B;     //S0 Baud-Rate Counter
#define S0BRC_Page           0x00

sfr S1BRC                  = 0x9B;     //S1 Baud-Rate Counter
#define S1BRC_Page           0x01

sfr S1CR1                  = 0x9B;     //S1 Control 1
#define S1CR1_Page           0x01
// (bits in S1CR1)
#define M6RER1               0x80
#define TXDO1                0x40
#define SOPWEC               0x20
#define TOTXD1               0x10
#define RMRI1                0x08
#define EXTFLT               0x04
#define TXINV1               0x02
#define RXINV1               0x01

sfr S0CFG                  = 0x9C;     //S0 Configuration
#define S0CFG_Page           0x00
// (bits in S0CFG)
#define URTS                 0x80
#define SMOD2                0x40
#define SM30                 0x10
#define S0DOR                0x08
#define BTI                  0x04
#define UTIE                 0x02
#define SMOD3                0x01

sfr S1CFG                  = 0x9C;     //S1 Configuration
#define S1CFG_Page           0x01
// (bits in S1CFG)
#define SM31                 0x80
#define S1MOD3               0x40
#define S1DOR                0x20
#define S1TR                 0x10
#define S1MOD1               0x08
#define S1TX12               0x04
#define S1CKOE               0x02
#define S1TME                0x01

sfr S0CFG1                 = 0x9D;     //S0 Configuration 1
#define S0CFG1_Page          0x00
// (bits in S0CFG1)
#define SBF0                 0x80
#define TXER0                0x40
#define S0SB16               0x20
#define ATBR0                0x10
#define TXRX0                0x08
#define SYNC0                0x04

sfr S1CFG6                 = 0x9D;     //S1 Configuration 6
#define S1CFG6_Page          0x01
// (bits in S1CFG6)
#define PDOEC1               0x80
#define M6TGU1               0x40
#define M6TXB1               0x20
#define M6IDL1               0x10
#define M6TUR1               0x08
#define M6ROR1               0x04
#define PDOE1                0x02
#define M6PDE1               0x01

sfr AC0CON                 = 0x9E;     //AC0 Control Reg.
#define AC0CON_Page          0x00
// (bits in AC0CON)
#define AC0LP                0x80
#define AC0PDX               0x40
#define AC0OUT               0x20
#define AC0F                 0x10
#define AC0EN                0x08
#define AC0INV               0x04
#define AC0M1                0x02
#define AC0M0                0x01

sfr AC1CON                 = 0x9E;     //AC1 Control Reg.
#define AC1CON_Page          0x01
// (bits in AC1CON)
#define AC1LP                0x80
#define AC1PDX               0x40
#define AC1OUT               0x20
#define AC1F                 0x10
#define AC1EN                0x08
#define AC1INV               0x04
#define AC1M1                0x02
#define AC1M0                0x01

sfr AC0CR1                 = 0x9E;     //AC0 Control Reg. 1
#define AC0CR1_Page          0x03
// (bits in AC0CR1)
#define AC0HC1               0x40
#define AC0HC0               0x20
#define AC0FLT1              0x04
#define AC0FLT0              0x02
#define AC0TR                0x01

sfr AC0MOD                 = 0x9F;     //AC0 Mode Reg.
#define AC0MOD_Page          0x00
// (bits in AC0MOD)
#define NVRS3                0x80
#define NVRS2                0x40
#define NVRS1                0x20
#define NVRS0                0x10
#define NVRL                 0x08
#define AC0PIS1              0x02
#define AC0PIS0              0x01

sfr AC1MOD                 = 0x9F;     //AC1 Mode Reg.
#define AC1MOD_Page          0x01
// (bits in AC1MOD)
#define AC1HC1               0x40
#define AC1HC0               0x20
#define AC1NIS               0x10
#define NVRL1                0x08
#define AC1FLT1              0x04
#define AC1FLT0              0x02
#define AC1TR                0x01

sfr P2                     = 0xA0;     //Port 2
#define P2_Page              0x00
// (bits in P2)
sbit P26                   = P2^6;
sbit P24                   = P2^4;
sbit P23                   = P2^3;
sbit P22                   = P2^2;

sfr AUXR0                  = 0xA1;     //Auxiliary Register 0
#define AUXR0_Page           0x00
// (bits in AUXR0)
#define C1BKF                0x20
#define PBKF                 0x10
#define INT1H                0x02
#define INT0H                0x01

sfr AUXR1                  = 0xA2;     //Auxiliary Register 1
#define AUXR1_Page           0x00
// (bits in AUXR1)
#define OP1Fr                0x80
#define OP0Fr                0x40
#define CRCDS1               0x20
#define CRCDS0               0x10
#define AC1Fr                0x04
#define AC0Fr                0x02
#define DPS                  0x01

sfr AUXR2                  = 0xA3;     //Auxiliary Register 2
#define AUXR2_Page           0x00
// (bits in AUXR2)
#define STAF                 0x80
#define STOF                 0x40
#define C1PLK                0x20
#define C0PLK                0x10
#define T1X12                0x08
#define T0X12                0x04

sfr AUXR3                  = 0xA4;     //Auxiliary Register 3
#define AUXR3_Page           0x00
// (bits in AUXR3)
#define T0PS1                0x80
#define T0PS0                0x40
#define BPOC1                0x20
#define BPOC0                0x10
#define S0PS0                0x08
#define TWIPS1               0x04
#define TWIPS0               0x02
#define T0XL                 0x01

sfr AUXR4                  = 0xA4;     //Auxiliary Register 4
#define AUXR4_Page           0x01
// (bits in AUXR4)
#define T2PS1                0x80
#define T2PS0                0x40
#define T1PS1                0x20
#define T1PS0                0x10
#define AC1OE                0x08
#define AC0OE                0x02

sfr AUXR5                  = 0xA4;     //Auxiliary Register 5
#define AUXR5_Page           0x02
// (bits in AUXR5)
#define C0PPS1               0x20
#define C0PPS0               0x10
#define EC1IPS0              0x08
#define C1COPS               0x04
#define ECIPS0               0x02
#define C0COPS               0x01

sfr AUXR6                  = 0xA4;     //Auxiliary Register 6
#define AUXR6_Page           0x03
// (bits in AUXR6)
#define KBIHPS1              0x80
#define KBIHPS0              0x40
#define KBILPS1              0x20
#define KBILPS0              0x10
#define T3FCS                0x08
#define T2FCS                0x04
#define SnMIPS               0x02
#define S0COPS               0x01

sfr AUXR7                  = 0xA4;     //Auxiliary Register 7
#define AUXR7_Page           0x04
// (bits in AUXR7)
#define C0CKOE               0x20
#define C1CKOE               0x10

sfr AUXR8                  = 0xA4;     //Auxiliary Register 8
#define AUXR8_Page           0x05
// (bits in AUXR8)
#define C1ICS1               0x40
#define C1ICS0               0x20
#define S1COPS               0x04
#define T3PS1                0x02
#define T3PS0                0x01

sfr AUXR9                  = 0xA4;     //Auxiliary Register 9
#define AUXR9_Page           0x06
// (bits in AUXR9)
#define SIDPS1               0x80
#define SIDPS0               0x40
#define T1G1                 0x20
#define T0G1                 0x10
#define S1PS1                0x02
#define S1PS0                0x01

sfr AUXR10                 = 0xA4;     //Aux. Register 10
#define AUXR10_Page          0x07
// (bits in AUXR10)
#define SPIPS1               0x20
#define SPIPS0               0x10
#define S0PS1                0x08
#define P60OC1               0x04
#define P60OC0               0x02
#define P60FD                0x01

sfr AUXR11                 = 0xA4;     //Aux. Register 11
#define AUXR11_Page          0x08
// (bits in AUXR11)
#define I2C1PS1              0x20
#define I2C1PS0              0x10
#define RX1S0                0x08
#define T1CKOE               0x02
#define T0CKOE               0x01

sfr AUXR12                 = 0xA4;     //Aux. Register 12
#define AUXR12_Page          0x09
// (bits in AUXR12)
#define CRCDS2               0x80
#define CRCM0                0x40
#define PDOES1               0x20
#define PDOES0               0x10
#define EDCM0                0x08
#define GPLC0                0x04

sfr AUXR16                 = 0xA4;     //Auxiliary Register 16
#define AUXR16_Page          0x0D
// (bits in AUXR16)
#define C0OPS5               0x20
#define C0OPS4               0x10
#define C0OPS3               0x08
#define C0OPS2               0x04
#define C0OPS1               0x02
#define C0OPS0               0x01

sfr AUXR17                 = 0xA4;     //Auxiliary Register 17
#define AUXR17_Page          0x0E
// (bits in AUXR17)
#define C1OPS1               0x02
#define C1OPS0               0x01

sfr EIE2                   = 0xA5;     //Extended INT Enable 2
#define EIE2_Page            0x00
// (bits in EIE2)
#define ETWI1                0x40
#define EPCA1                0x20
#define EAC1                 0x02
#define ET3                  0x01

sfr EIP2L                  = 0xA6;     //Ext. INT Priority 2 Low
#define EIP2L_Page           0x00
// (bits in EIP2L)
#define PTWI1L               0x40
#define PPCA1L               0x20
#define PAC1L                0x02
#define PT3L                 0x01

sfr EIP2H                  = 0xA7;     //Ext. INT Priority 2 High
#define EIP2H_Page           0x00
// (bits in EIP2H)
#define PTWI1H               0x40
#define PPCA1H               0x20
#define PAC1H                0x02
#define PT3H                 0x01

sfr IE                     = 0xA8;     //Interrupt Enable
#define IE_Page              0x00
// (bits in IE)
sbit EA                    = IE^7;
sbit EDMA                  = IE^6;
sbit ET2                   = IE^5;
sbit ES0                   = IE^4;
sbit ET1                   = IE^3;
sbit EX1                   = IE^2;
sbit ET0                   = IE^1;
sbit EX0                   = IE^0;

sfr SADDR                  = 0xA9;     //Slave Address
#define SADDR_Page           0x00

sfr EDC45                  = 0xA9;     //4b5b ENDEC
#define EDC45_Page           0x00

sfr SFRPI                  = 0xAC;     //SFR Page Index
#define SFRPI_Page           0x00
// (bits in SFRPI)
#define IDX3                 0x08
#define IDX2                 0x04
#define IDX1                 0x02
#define IDX0                 0x01

sfr EIE1                   = 0xAD;     //Extended INT Enable 1
#define EIE1_Page            0x00
// (bits in EIE1)
#define EAC0                 0x80
#define ETWI0                0x40
#define EKB                  0x20
#define ES1                  0x10
#define ESF                  0x08
#define EPCA                 0x04
#define EADC                 0x02
#define ESPI                 0x01

sfr EIP1L                  = 0xAE;     //Ext. INT Priority 1 Low
#define EIP1L_Page           0x00
// (bits in EIP1L)
#define PAC0L                0x80
#define PTWI0L               0x40
#define PKBL                 0x20
#define PS1L                 0x10
#define PSFL                 0x08
#define PPCAL                0x04
#define PADCL                0x02
#define PSPIL                0x01

sfr EIP1H                  = 0xAF;     //Ext. INT Priority 1 High
#define EIP1H_Page           0x00
// (bits in EIP1H)
#define PAC0H                0x80
#define PTWI0H               0x40
#define PKBH                 0x20
#define PS1H                 0x10
#define PSFH                 0x08
#define PPCAH                0x04
#define PADCH                0x02
#define PSPIH                0x01

sfr P3                     = 0xB0;     //Port 3
#define P3_Page              0x00
// (bits in P3)
sbit P35                   = P3^5;
sbit P34                   = P3^4;
sbit P33                   = P3^3;
sbit P32                   = P3^2;
sbit P31                   = P3^1;
sbit P30                   = P3^0;

sfr P3M0                   = 0xB1;     //P3 Mode Register 0
#define P3M0_Page            0x00
// (bits in P3M0)
#define P3M05                0x20
#define P3M04                0x10
#define P3M03                0x08
#define P3M02                0x04
#define P3M01                0x02
#define P3M00                0x01

sfr P3M1                   = 0xB2;     //P3 Mode Register 1
#define P3M1_Page            0x00
// (bits in P3M1)
#define P3M15                0x20
#define P3M14                0x10
#define P3M13                0x08
#define P3M12                0x04
#define P3M11                0x02
#define P3M10                0x01

sfr P4M0                   = 0xB3;     //P4 Mode Register 0
#define P4M0_Page            0x00
// (bits in P4M0)
#define P4M07                0x80
#define P4M05                0x20
#define P4M04                0x10
#define P4M01                0x02
#define P4M00                0x01

sfr PDRVC0                 = 0xB4;     //Port Driving Control 0
#define PDRVC0_Page          0x02
// (bits in PDRVC0)
#define P3DC1                0x80
#define P3DC0                0x40
#define P2DC1                0x20
#define P2DC0                0x10
#define P1DC1                0x08
#define P1DC0                0x04
#define P0DC1                0x02
#define P0DC0                0x01

sfr PDRVC1                 = 0xB4;     //Port Driving Control 1
#define PDRVC1_Page          0x03
// (bits in PDRVC1)
#define P4DC1                0x02
#define P4DC0                0x01

sfr P6M0                   = 0xB5;     //P6 Mode Register 0
#define P6M0_Page            0x01
// (bits in P6M0)
#define P6M01                0x02
#define P6M00                0x01

sfr IP0H                   = 0xB7;     //Interrupt Priority 0 High
#define IP0H_Page            0x00
// (bits in IP0H)
#define PX3H                 0x80
#define PX2H                 0x40
#define PT2H                 0x20
#define PSH                  0x10
#define PT1H                 0x08
#define PX1H                 0x04
#define PT0H                 0x02
#define PX0H                 0x01

sfr IP0L                   = 0xB8;     //Interrupt Priority Low
#define IP0L_Page            0x00
// (bits in IP0L)
sbit PX3L                  = IP0L^7;
sbit PX2L                  = IP0L^6;
sbit PT2L                  = IP0L^5;
sbit PSL                   = IP0L^4;
sbit PT1L                  = IP0L^3;
sbit PX1L                  = IP0L^2;
sbit PT0L                  = IP0L^1;
sbit PX0L                  = IP0L^0;

sfr SADEN                  = 0xB9;     //Slave Address Mask
#define SADEN_Page           0x00

sfr S0CR1                  = 0xB9;     //S0 Control 1
#define S0CR1_Page           0x00
// (bits in S0CR1)
#define S0TR                 0x80
#define S0TX12               0x40
#define S0TCK                0x20
#define S0RCK                0x10
#define S0CKOE               0x08
#define ARTE                 0x04

sfr OPSTA                  = 0xBA;     //OPA Status
#define OPSTA_Page           0x00
// (bits in OPSTA)
#define OP1CMPF              0x02
#define OP0CMPF              0x01

sfr OP0CON0                = 0xBA;     //OPA0 Control 0
#define OP0CON0_Page         0x01
// (bits in OP0CON0)
#define OP0EN                0x80
#define OPPWR                0x40
#define OP0LP                0x20
#define OP0IG                0x10
#define OP0PIS1              0x08
#define OP0PIS0              0x04
#define OP0NIS1              0x02
#define OP0NIS0              0x01

sfr OP1CON0                = 0xBA;     //OPA1 Control 0
#define OP1CON0_Page         0x02
// (bits in OP1CON0)
#define OP1EN                0x80
#define OP1LP                0x20
#define OP1IG                0x10
#define OP1PIS1              0x08
#define OP1PIS0              0x04
#define OP1NIS1              0x02
#define OP1NIS0              0x01

sfr PGACON0                = 0xBA;     //PGA Control 0
#define PGACON0_Page         0x05
// (bits in PGACON0)
#define PGEN                 0x80
#define PGLP                 0x20
#define PGAOE                0x10
#define PGPIS1               0x08
#define PGPIS0               0x04

sfr PGACON1                = 0xBA;     //PGA Control 1
#define PGACON1_Page         0x06
// (bits in PGACON1)
#define PGENS1GN             0x20
#define PGGNM                0x08
#define PGGN2                0x04
#define PGGN1                0x02
#define PGGN0                0x01

sfr OPCMP                  = 0xBA;     //OPA Comparator Mode
#define OPCMP_Page           0x07
// (bits in OPCMP)
#define OP1PDX               0x20
#define OP0PDX               0x10
#define OP1M1                0x08
#define OP1M0                0x04
#define OP0M1                0x02
#define OP0M0                0x01

sfr PWMCR                  = 0xBC;     //PWM Control Reg.
#define PWMCR_Page           0x00
// (bits in PWMCR)
#define PCAE                 0x80
#define C0OFS                0x40
#define PBKM                 0x20
#define PBKE11               0x10
#define PBKE10               0x08
#define PBKE02               0x04
#define PBKE01               0x02
#define PBKE00               0x01

sfr PDTCRA                 = 0xBC;     //PWM Dead-Time Control Reg. -A
#define PDTCRA_Page          0x01
// (bits in PDTCRA)
#define DTPS1                0x80
#define DTPS0                0x40
#define DT5                  0x20
#define DT4                  0x10
#define DT3                  0x08
#define DT2                  0x04
#define DT1                  0x02
#define DT0                  0x01

sfr C1PWMCR                = 0xBC;     //PWM Control Reg.
#define C1PWMCR_Page         0x0A
// (bits in C1PWMCR)
#define PCA1E                0x80
#define C1OFS                0x40
#define C1BKM                0x20
#define C1BKE11              0x10
#define C1BKE10              0x08
#define C1BKE02              0x04
#define C1BKE01              0x02
#define C1BKE00              0x01

sfr C1PDTCR                = 0xBC;     //PWM Dead-Time Control Reg.
#define C1PDTCR_Page         0x01
// (bits in C1PDTCR)
#define C1DTPS1              0x80
#define C1DTPS0              0x40
#define C1DT5                0x20
#define C1DT4                0x10
#define C1DT3                0x08
#define C1DT2                0x04
#define C1DT1                0x02
#define C1DT0                0x01

sfr CRC0DA                 = 0xBD;     //CRC0 Data Port
#define CRC0DA_Page          0x00

sfr CKCON1                 = 0xBF;     //Clock Control 1
#define CKCON1_Page          0x00
// (bits in CKCON1)
#define XTOR                 0x80
#define PLLOCKF              0x40
#define MCKSTA1              0x20
#define MCKSTA0              0x10
#define OSCSTA3              0x08
#define OSCSTA2              0x04
#define OSCSTA1              0x02
#define OSCSTA0              0x01

sfr XICON                  = 0xC0;     //External INT Control
#define XICON_Page           0x00
// (bits in XICON)
sbit INT3H                 = XICON^7;
sbit EX3                   = XICON^6;
sbit IE3                   = XICON^5;
sbit IT3                   = XICON^4;
sbit INT2H                 = XICON^3;
sbit EX2                   = XICON^2;
sbit IE2                   = XICON^1;
sbit IT2                   = XICON^0;

sfr XICFG                  = 0xC1;     //Ext. INT. Configured
#define XICFG_Page           0x00
// (bits in XICFG)
#define INT1IS1              0x80
#define INT1IS0              0x40
#define INT0IS1              0x20
#define INT0IS0              0x10
#define X3FLT                0x08
#define X2FLT                0x04
#define X1FLT                0x02
#define X0FLT                0x01

sfr XICFG1                 = 0xC1;     //Ext. INT. Configured 1
#define XICFG1_Page          0x01
// (bits in XICFG1)
#define INT1IS2              0x80
#define INT0IS2              0x40
#define INT2IS1              0x20
#define INT2IS0              0x10
#define X3FLT1               0x08
#define X2FLT1               0x04
#define X1FLT1               0x02
#define X0FLT1               0x01

sfr XICFG2                 = 0xC1;     //Ext. INT. Configured 2
#define XICFG2_Page          0x02
// (bits in XICFG2)
#define INT3IS2              0x08
#define INT3IS1              0x04
#define INT3IS0              0x02
#define INT2IS2              0x01

sfr ADCFG0                 = 0xC3;     //ADC Configuration 0
#define ADCFG0_Page          0x00
// (bits in ADCFG0)
#define ADCKS2               0x80
#define ADCKS1               0x40
#define ADCKS0               0x20
#define ADRJ                 0x10
#define ACHS                 0x08
#define SMPF                 0x04
#define ADTM1                0x02
#define ADTM0                0x01

sfr ADCFG1                 = 0xC3;     //ADC Configuration 1
#define ADCFG1_Page          0x01
// (bits in ADCFG1)
#define IGADCI               0x80
#define EADCWI               0x40
#define SMPFIE               0x20
#define SIGN                 0x10
#define AOS3                 0x08
#define AOS2                 0x04
#define AOS1                 0x02
#define AOS0                 0x01

sfr ADCFG2                 = 0xC3;     //ADC Configuration 2
#define ADCFG2_Page          0x02
// (bits in ADCFG2)
#define SHT7                 0x80
#define SHT6                 0x40
#define SHT5                 0x20
#define SHT4                 0x10
#define SHT3                 0x08
#define SHT2                 0x04
#define SHT1                 0x02
#define SHT0                 0x01

sfr ADCFG3                 = 0xC3;     //ADC Configuration 3
#define ADCFG3_Page          0x03
// (bits in ADCFG3)
#define ADPS1                0x80
#define ADPS0                0x40
#define ADHS                 0x20
#define ADHS1                0x10
#define ARES1                0x08
#define ARES0                0x04
#define ADES0                0x02

sfr ADCFG4                 = 0xC3;     //ADC Configuration 4
#define ADCFG4_Page          0x04
// (bits in ADCFG4)
#define ADMINS               0x80
#define ADWM0                0x40
#define ADTM3                0x20
#define ADTM2                0x10
#define VRS0                 0x04
#define DBSD                 0x02
#define DOSD                 0x01

sfr ADCFG5                 = 0xC3;     //ADC Configuration 5
#define ADCFG5_Page          0x05
// (bits in ADCFG5)
#define ASCE7                0x80
#define ASCE6                0x40
#define ASCE5                0x20
#define ASCE4                0x10
#define ASCE3                0x08
#define ASCE2                0x04
#define ASCE1                0x02
#define ASCE0                0x01

sfr ADCFG7                 = 0xC3;     //ADC Configuration 7
#define ADCFG7_Page          0x07
// (bits in ADCFG7)
#define ASCS3                0x08
#define ASCS2                0x04
#define ASCS1                0x02
#define ASCS0                0x01

sfr ADCFG11                = 0xC3;     //ADC Configuration 11
#define ADCFG11_Page         0x0B
// (bits in ADCFG11)
#define WHB3                 0x80
#define WHB2                 0x40
#define WHB1                 0x20
#define WHB0                 0x10

sfr ADCFG12                = 0xC3;     //ADC Configuration 12
#define ADCFG12_Page         0x0C
// (bits in ADCFG12)
#define WHB11                0x80
#define WHB10                0x40
#define WHB9                 0x20
#define WHB8                 0x10
#define WHB7                 0x08
#define WHB6                 0x04
#define WHB5                 0x02
#define WHB4                 0x01

sfr ADCFG13                = 0xC3;     //ADC Configuration 13
#define ADCFG13_Page         0x0D
// (bits in ADCFG13)
#define WLB3                 0x80
#define WLB2                 0x40
#define WLB1                 0x20
#define WLB0                 0x10

sfr ADCFG14                = 0xC3;     //ADC Configuration 14
#define ADCFG14_Page         0x0E
// (bits in ADCFG14)
#define WLB11                0x80
#define WLB10                0x40
#define WLB9                 0x20
#define WLB8                 0x10
#define WLB7                 0x08
#define WLB6                 0x04
#define WLB5                 0x02
#define WLB4                 0x01

sfr ADCON0                 = 0xC4;     //ADC Control 0
#define ADCON0_Page          0x00
// (bits in ADCON0)
#define ADCEN                0x80
#define ADCWI                0x40
#define CHS3                 0x20
#define ADCI                 0x10
#define ADCS                 0x08
#define CHS2                 0x04
#define CHS1                 0x02
#define CHS0                 0x01

sfr ADCDL                  = 0xC5;     //ADC Data Low
#define ADCDL_Page           0x00
// (bits in ADCDL)
#define ADCV3                0x80
#define ADCV2                0x40
#define ADCV1                0x20
#define ADCV0                0x10

sfr ADCDH                  = 0xC6;     //ADC Data High
#define ADCDH_Page           0x00
// (bits in ADCDH)
#define ADCV11               0x80
#define ADCV10               0x40
#define ADCV9                0x20
#define ADCV8                0x10
#define ADCV7                0x08
#define ADCV6                0x04
#define ADCV5                0x02
#define ADCV4                0x01

sfr CKCON0                 = 0xC7;     //Clock Control 0
#define CKCON0_Page          0x00
// (bits in CKCON0)
#define AFS                  0x80
#define ENCKM                0x40
#define CKMIS1               0x20
#define CKMIS0               0x10
#define CCKS                 0x08
#define SCKS2                0x04
#define SCKS1                0x02
#define SCKS0                0x01

sfr T2CON                  = 0xC8;     //Timer 2 Control Reg.
#define T2CON_Page           0x00
// (bits in T2CON)
sbit TF2                   = T2CON^7;
sbit EXF2                  = T2CON^6;
sbit RCLK                  = T2CON^5;
sbit TF2L                  = T2CON^5;
sbit RCLK_TF2L             = T2CON^5;
sbit TCLK                  = T2CON^4;
sbit TL2IE                 = T2CON^4;
sbit TCLK_TL2IE            = T2CON^4;
sbit EXEN2                 = T2CON^3;
sbit TR2                   = T2CON^2;
sbit C_T2                  = T2CON^1;
sbit CP_RL2                = T2CON^0;

sfr T3CON                  = 0xC8;     //Timer 3 Control Reg.
#define T3CON_Page           0x01
// (bits in T3CON)
sbit TF3                   = T3CON^7;
sbit EXF3                  = T3CON^6;
sbit TF3L                  = T3CON^5;
sbit TL3IE                 = T3CON^4;
sbit EXEN3                 = T3CON^3;
sbit TR3                   = T3CON^2;
sbit C_T3                  = T3CON^1;
sbit CP_RL3                = T3CON^0;

sfr T5CON                  = 0xC8;     //Timer 5 Control Reg.
#define T5CON_Page           0x03
// (bits in T5CON)
sbit TF5                   = T5CON^7;
sbit T5CKS1                = T5CON^5;
sbit T5CKS0                = T5CON^4;
sbit T5IE                  = T5CON^3;
sbit TR5                   = T5CON^2;
sbit T5GAT1                = T5CON^1;
sbit T5GAT0                = T5CON^0;

sfr T6CON                  = 0xC8;     //Timer 6 Control Reg.
#define T6CON_Page           0x04
// (bits in T6CON)
sbit TF6                   = T6CON^7;
sbit T6CKS1                = T6CON^5;
sbit T6CKS0                = T6CON^4;
sbit T6IE                  = T6CON^3;
sbit TR6                   = T6CON^2;
sbit T6GAT1                = T6CON^1;
sbit T6GAT0                = T6CON^0;

sfr T2MOD                  = 0xC9;     //Timer 2 mode Reg.
#define T2MOD_Page           0x00
// (bits in T2MOD)
#define T2SPL                0x80
#define TL2X12               0x40
#define T2EIP                0x40
#define TL2X12_T2EIP         0x40
#define T2EXH                0x20
#define T2X12                0x10
#define TR2L                 0x08
#define TR2LC                0x04
#define T2OE                 0x02
#define T2MS0                0x01

sfr T3MOD                  = 0xC9;     //Timer 3 mode Reg.
#define T3MOD_Page           0x01
// (bits in T3MOD)
#define T3SPL                0x80
#define TL3X12               0x40
#define T3EIP                0x40
#define TL3X12_T3EIP         0x40
#define T3EXH                0x20
#define T3X12                0x10
#define TR3L                 0x08
#define TR3LC                0x04
#define T3OE                 0x02
#define T3MS0                0x01

sfr RCAP2L                 = 0xCA;     //Timer2 Capture Low
#define RCAP2L_Page          0x00

sfr RCAP3L                 = 0xCA;     //Timer3 Capture Low
#define RCAP3L_Page          0x01

sfr TLR5                   = 0xCA;     //TL5 reload Reg.
#define TLR5_Page            0x03

sfr TLR6                   = 0xCA;     //TL6 reload Reg.
#define TLR6_Page            0x04

sfr RCAP2H                 = 0xCB;     //Timer2 Capture High
#define RCAP2H_Page          0x00

sfr RCAP3H                 = 0xCB;     //Timer3 Capture High
#define RCAP3H_Page          0x01

sfr THR5                   = 0xCB;     //TH5 reload Reg.
#define THR5_Page            0x03

sfr THR6                   = 0xCB;     //TH6 reload Reg.
#define THR6_Page            0x04

sfr TL2                    = 0xCC;     //Timer Low 2
#define TL2_Page             0x00

sfr TL3                    = 0xCC;     //Timer Low 3
#define TL3_Page             0x01

sfr TL5                    = 0xCC;     //Timer Low 5
#define TL5_Page             0x03

sfr TL6                    = 0xCC;     //Timer Low 6
#define TL6_Page             0x04

sfr TH2                    = 0xCD;     //Timer High 2
#define TH2_Page             0x00

sfr TH3                    = 0xCD;     //Timer High 3
#define TH3_Page             0x01

sfr TH5                    = 0xCD;     //Timer High 5
#define TH5_Page             0x03

sfr TH6                    = 0xCD;     //Timer High 6
#define TH6_Page             0x04

sfr CLRL                   = 0xCE;     //CL Reload register
#define CLRL_Page            0x00

sfr CL1RL                  = 0xCE;     //CL1 Reload register
#define CL1RL_Page           0x01

sfr CHRL                   = 0xCF;     //CH Reload register
#define CHRL_Page            0x00

sfr CH1RL                  = 0xCF;     //CH1 Reload register
#define CH1RL_Page           0x01

sfr PSW                    = 0xD0;     //Program Status Word
#define PSW_Page             0x00
// (bits in PSW)
sbit CY                    = PSW^7;
sbit AC                    = PSW^6;
sbit F0                    = PSW^5;
sbit RS1                   = PSW^4;
sbit RS0                   = PSW^3;
sbit OV                    = PSW^2;
sbit F1                    = PSW^1;
sbit P                     = PSW^0;

sfr SIADR                  = 0xD1;     //TWI0 Address Reg.
#define SIADR_Page           0x00
// (bits in SIADR)
#define GC                   0x01

sfr SI1ADR                 = 0xD1;     //TWI1 Address Reg.
#define SI1ADR_Page          0x01
// (bits in SI1ADR)
#define GC1                  0x01

sfr SIA2                   = 0xD1;     //TWI0 2nd Addr Reg.
#define SIA2_Page            0x02
// (bits in SIA2)
#define A2E                  0x01

sfr SI1A2                  = 0xD1;     //TWI1 2nd Addr Reg.
#define SI1A2_Page           0x03
// (bits in SI1A2)
#define A2E1                 0x01

sfr SIDAT                  = 0xD2;     //TWI0 Data Reg.
#define SIDAT_Page           0x00

sfr SI1DAT                 = 0xD2;     //TWI1 Data Reg.
#define SI1DAT_Page          0x01

sfr SIA2M                  = 0xD2;     //SIA2 Mask Reg.
#define SIA2M_Page           0x02
// (bits in SIA2M)
#define SIA2M7               0x80
#define SIA2M6               0x40
#define SIA2M5               0x20
#define SIA2M4               0x10
#define SIA2M3               0x08
#define SIA2M2               0x04
#define SIA2M1               0x02

sfr SI1A2M                 = 0xD2;     //SI1A2 Mask Reg.
#define SI1A2M_Page          0x03
// (bits in SI1A2M)
#define SI1A2M7              0x80
#define SI1A2M6              0x40
#define SI1A2M5              0x20
#define SI1A2M4              0x10
#define SI1A2M3              0x08
#define SI1A2M2              0x04
#define SI1A2M1              0x02

sfr SISTA                  = 0xD3;     //TWI0 Status Reg.
#define SISTA_Page           0x00

sfr SI1STA                 = 0xD3;     //TWI1 Status Reg.
#define SI1STA_Page          0x01

sfr SICON                  = 0xD4;     //TWI0 Control Reg.
#define SICON_Page           0x00
// (bits in SICON)
#define CR2                  0x80
#define ENSI                 0x40
#define STA                  0x20
#define STO                  0x10
#define SI                   0x08
#define AA                   0x04
#define CR1                  0x02
#define CR0                  0x01

sfr SI1CON                 = 0xD4;     //TWI1 Control Reg.
#define SI1CON_Page          0x01
// (bits in SI1CON)
#define CR21                 0x80
#define ENSI1                0x40
#define STA1                 0x20
#define STO1                 0x10
#define SI1                  0x08
#define AA1                  0x04
#define CR11                 0x02
#define CR01                 0x01

sfr SICR1                  = 0xD4;     //TWI0 Control Reg. 1
#define SICR1_Page           0x02
// (bits in SICR1)
#define F8IE                 0x08
#define MTSE                 0x04
#define PAA                  0x02
#define CR3                  0x01

sfr SI1CR1                 = 0xD4;     //TWI1 Control Reg. 1
#define SI1CR1_Page          0x03
// (bits in SI1CR1)
#define F8IE1                0x08
#define MTSE1                0x04
#define PAA1                 0x02
#define CR31                 0x01

sfr KBPATN                 = 0xD5;     //Keypad Pattern
#define KBPATN_Page          0x00

sfr KBCON                  = 0xD6;     //Keypad Control
#define KBCON_Page           0x00
// (bits in KBCON)
#define KBCS1                0x80
#define KBCS0                0x40
#define KBES                 0x20
#define PATN_SEL             0x02
#define KBIF                 0x01

sfr KBMASK                 = 0xD7;     //Keypad Int. Mask
#define KBMASK_Page          0x00

sfr CCON                   = 0xD8;     //PTM Control Reg.
#define CCON_Page            0x00
// (bits in CCON)
sbit CF                    = CCON^7;
sbit CR                    = CCON^6;
sbit CCF5                  = CCON^5;
sbit CCF4                  = CCON^4;
sbit CCF3                  = CCON^3;
sbit CCF2                  = CCON^2;
sbit CCF1                  = CCON^1;
sbit CCF0                  = CCON^0;

sfr C1CON                  = 0xD8;     //PCA1 Control Reg.
#define C1CON_Page           0x01
// (bits in C1CON)
sbit C1F                   = C1CON^7;
sbit C1R                   = C1CON^6;
sbit C1CF1                 = C1CON^1;
sbit C1CF0                 = C1CON^0;

sfr CMOD                   = 0xD9;     //PTM Mode Reg.
#define CMOD_Page            0x00
// (bits in CMOD)
#define CIDL                 0x80
#define BME4                 0x40
#define BME2                 0x20
#define BME0                 0x10
#define CPS2                 0x08
#define CPS1                 0x04
#define CPS0                 0x02
#define ECF                  0x01

sfr C1MOD                  = 0xD9;     //PCA1 Mode Reg.
#define C1MOD_Page           0x01
// (bits in C1MOD)
#define C1IDL                0x80
#define BME01                0x10
#define C1PS2                0x08
#define C1PS1                0x04
#define C1PS0                0x02
#define ECF1                 0x01

sfr CCAPM0                 = 0xDA;     //PTM Module0 Mode
#define CCAPM0_Page          0x00
// (bits in CCAPM0)
#define DTE0                 0x80
#define ECOM0                0x40
#define MAT0                 0x08
#define TOG0                 0x04
#define PWM0                 0x02
#define ECCF0                0x01

sfr C1CAPM0                = 0xDA;     //PCA1 Module0 Mode
#define C1CAPM0_Page         0x01
// (bits in C1CAPM0)
#define DT1E0                0x80
#define ECOM01               0x40
#define CAP1P0               0x20
#define CAP1N0               0x10
#define MAT01                0x08
#define TOG01                0x04
#define PWM01                0x02
#define EC1CF0               0x01

sfr CCAPM1                 = 0xDB;     //PTM Module1 Mode
#define CCAPM1_Page          0x00
// (bits in CCAPM1)
#define ECOM1                0x40
#define MAT1                 0x08
#define TOG1                 0x04
#define PWM1                 0x02
#define ECCF1                0x01

sfr C1CAPM1                = 0xDB;     //PCA1 Module0 Mode
#define C1CAPM1_Page         0x01
// (bits in C1CAPM1)
#define ECOM11               0x40
#define CAP1P1               0x20
#define CAP1N1               0x10
#define MAT11                0x08
#define TOG11                0x04
#define PWM11                0x02
#define EC1CF1               0x01

sfr CCAPM2                 = 0xDC;     //PCA Module2 Mode
#define CCAPM2_Page          0x00
// (bits in CCAPM2)
#define DTE2                 0x80
#define ECOM2                0x40
#define MAT2                 0x08
#define TOG2                 0x04
#define PWM2                 0x02
#define ECCF2                0x01

sfr CCAPM3                 = 0xDD;     //PCA Module3 Mode
#define CCAPM3_Page          0x00
// (bits in CCAPM3)
#define ECOM3                0x40
#define MAT3                 0x08
#define TOG3                 0x04
#define PWM3                 0x02
#define ECCF3                0x01

sfr CCAPM4                 = 0xDE;     //PCA Module4 Mode
#define CCAPM4_Page          0x00
// (bits in CCAPM4)
#define DTE4                 0x80
#define ECOM4                0x40
#define MAT4                 0x08
#define TOG4                 0x04
#define PWM4                 0x02
#define ECCF4                0x01

sfr CCAPM5                 = 0xDF;     //PCA Module5 Mode
#define CCAPM5_Page          0x00
// (bits in CCAPM5)
#define ECOM5                0x40
#define MAT5                 0x08
#define TOG5                 0x04
#define PWM5                 0x02
#define ECCF5                0x01

sfr ACC                    = 0xE0;     //Accumulator
#define ACC_Page             0x00

sfr WDTCR                  = 0xE1;     //WDT Control register
#define WDTCR_Page           0x00
// (bits in WDTCR)
#define WREN                 0x80
#define NSW                  0x40
#define ENW                  0x20
#define CLRW                 0x10
#define WIDL                 0x08
#define PS2                  0x04
#define PS1                  0x02
#define PS0                  0x01

sfr IFD                    = 0xE2;     //ISP Flash data
#define IFD_Page             0x00

sfr IFADRH                 = 0xE3;     //ISP Flash Addr. High
#define IFADRH_Page          0x00

sfr IFADRL                 = 0xE4;     //ISP Flash Addr. Low
#define IFADRL_Page          0x00

sfr IFMT                   = 0xE5;     //ISP Mode Table
#define IFMT_Page            0x00
// (bits in IFMT)
#define MS7                  0x80
#define MS3                  0x08
#define MS2                  0x04
#define MS1                  0x02
#define MS0                  0x01

sfr SCMD                   = 0xE6;     //ISP Serial Command
#define SCMD_Page            0x00

sfr ISPCR                  = 0xE7;     //ISP Control Register
#define ISPCR_Page           0x00
// (bits in ISPCR)
#define ISPEN                0x80
#define SWBS                 0x40
#define SRST                 0x20
#define CFAIL                0x10

sfr P4                     = 0xE8;     //Port 4
#define P4_Page              0x00
// (bits in P4)
sbit P47                   = P4^7;
sbit P45                   = P4^5;
sbit P44                   = P4^4;
sbit P41                   = P4^1;
sbit P40                   = P4^0;

sfr CL                     = 0xE9;     //PTM base timer Low
#define CL_Page              0x00

sfr CL1                    = 0xE9;     //PCA1 base timer Low
#define CL1_Page             0x01

sfr CCAP0L                 = 0xEA;     //PTM module0 compare Low
#define CCAP0L_Page          0x00

sfr C1CAP0L                = 0xEA;     //PCA1 module0 capture Low
#define C1CAP0L_Page         0x01

sfr CCAP1L                 = 0xEB;     //PTM module1 compare Low
#define CCAP1L_Page          0x00

sfr C1CAP1L                = 0xEB;     //PCA1 module1 capture Low
#define C1CAP1L_Page         0x01

sfr CCAP2L                 = 0xEC;     //PTM module2 compare Low
#define CCAP2L_Page          0x00

sfr CCAP3L                 = 0xED;     //PTM module3 compare Low
#define CCAP3L_Page          0x00

sfr CCAP4L                 = 0xEE;     //PTM module4 compare Low
#define CCAP4L_Page          0x00

sfr CCAP5L                 = 0xEF;     //PTM module5 compare Low
#define CCAP5L_Page          0x00

sfr B                      = 0xF0;     //B Register
#define B_Page               0x00

sfr PAOE                   = 0xF1;     //PWM Additional Output Enable
#define PAOE_Page            0x00
// (bits in PAOE)
#define POE3                 0x80
#define POE2B                0x40
#define POE2A                0x20
#define POE2                 0x10
#define POE1                 0x08
#define POE0B                0x04
#define POE0A                0x02
#define POE0                 0x01

sfr C0AOE1                 = 0xF1;     //PTM0 Additional Output Enable 1
#define C0AOE1_Page          0x08
// (bits in C0AOE1)
#define POEM0                0x80
#define POE5                 0x08
#define POE4                 0x01

sfr C1AOE0                 = 0xF1;     //PCA1 Additional Output Enable 0
#define C1AOE0_Page          0x09
// (bits in C1AOE0)
#define C1POE1               0x08
#define C1POE0               0x01

sfr C1AOE1                 = 0xF1;     //PCA1 Additional Output Enable 1
#define C1AOE1_Page          0x0A
// (bits in C1AOE1)
#define C1POEM0              0x80

sfr PCAPWM0                = 0xF2;     //PTM PWM0 Mode
#define PCAPWM0_Page         0x00
// (bits in PCAPWM0)
#define P0RS1                0x80
#define P0RS0                0x40
#define P0INV                0x04
#define ECAP0H               0x02
#define ECAP0L               0x01

sfr C1PWM0                 = 0xF2;     //PCA1 PWM0 Mode
#define C1PWM0_Page          0x01
// (bits in C1PWM0)
#define P0RS11               0x80
#define P0RS01               0x40
#define P0INV1               0x04
#define ECAP0H1              0x02
#define ECAP0L1              0x01

sfr PCAPWM1                = 0xF3;     //PTM PWM1 Mode
#define PCAPWM1_Page         0x00
// (bits in PCAPWM1)
#define P1RS1                0x80
#define P1RS0                0x40
#define P1INV                0x04
#define ECAP1H               0x02
#define ECAP1L               0x01

sfr C1PWM1                 = 0xF3;     //PCA1 PWM1 Mode
#define C1PWM1_Page          0x01
// (bits in C1PWM1)
#define P1RS11               0x80
#define P1RS01               0x40
#define P1INV1               0x04
#define ECAP1H1              0x02
#define ECAP1L1              0x01

sfr PCAPWM2                = 0xF4;     //PTM PWM2 Mode
#define PCAPWM2_Page         0x00
// (bits in PCAPWM2)
#define P2RS1                0x80
#define P2RS0                0x40
#define P2INV                0x04
#define ECAP2H               0x02
#define ECAP2L               0x01

sfr PCAPWM3                = 0xF5;     //PTM PWM3 Mode
#define PCAPWM3_Page         0x00
// (bits in PCAPWM3)
#define P3RS1                0x80
#define P3RS0                0x40
#define P3INV                0x04
#define ECAP3H               0x02
#define ECAP3L               0x01

sfr PCAPWM4                = 0xF6;     //PTM PWM4 Mode
#define PCAPWM4_Page         0x00
// (bits in PCAPWM4)
#define P4RS1                0x80
#define P4RS0                0x40
#define P4INV                0x04
#define ECAP4H               0x02
#define ECAP4L               0x01

sfr PCAPWM5                = 0xF7;     //PTM PWM5 Mode
#define PCAPWM5_Page         0x00
// (bits in PCAPWM5)
#define P5RS1                0x80
#define P5RS0                0x40
#define P5INV                0x04
#define ECAP5H               0x02
#define ECAP5L               0x01

sfr P6                     = 0xF8;     //Port 6
#define P6_Page              0x01
// (bits in P6)
sbit P61                   = P6^1;
sbit P60                   = P6^0;

sfr CH                     = 0xF9;     //PTM base timer High
#define CH_Page              0x00

sfr CH1                    = 0xF9;     //PCA1 base timer High
#define CH1_Page             0x01

sfr CCAP0H                 = 0xFA;     //PTM Module0 compare High
#define CCAP0H_Page          0x00

sfr C1CAP0H                = 0xFA;     //PCA1 Module0 capture High
#define C1CAP0H_Page         0x01

sfr CCAP1H                 = 0xFB;     //PTM Module1 compare High
#define CCAP1H_Page          0x00

sfr C1CAP1H                = 0xFB;     //PCA1 Module1 capture High
#define C1CAP1H_Page         0x01

sfr CCAP2H                 = 0xFC;     //PTM Module2 compare High
#define CCAP2H_Page          0x00

sfr CCAP3H                 = 0xFD;     //PTM Module3 compare High
#define CCAP3H_Page          0x00

sfr CCAP4H                 = 0xFE;     //PTM Module4 compare High
#define CCAP4H_Page          0x00

sfr CCAP5H                 = 0xFF;     //PTM Module5 compare High
#define CCAP5H_Page          0x00


//===== Page P =====//
#define IAPLB_P              0x03     //IAP Low Boundary
// (bits in IAPLB)
#define IAPLB6_P             0x80
#define IAPLB5_P             0x40
#define IAPLB4_P             0x20
#define IAPLB3_P             0x10
#define IAPLB2_P             0x08
#define IAPLB1_P             0x04
#define IAPLB0_P             0x02

#define OP0CFG0_P            0x13     //OP0 Configuration 0
// (bits in OP0CFG0)
#define OP0OS5_P             0x20
#define OP0OS4_P             0x10
#define OP0OS3_P             0x08
#define OP0OS2_P             0x04
#define OP0OS1_P             0x02
#define OP0OS0_P             0x01

#define OP1CFG0_P            0x14     //OP1 Configuration 0
// (bits in OP1CFG0)
#define OP1OS5_P             0x20
#define OP1OS4_P             0x10
#define OP1OS3_P             0x08
#define OP1OS2_P             0x04
#define OP1OS1_P             0x02
#define OP1OS0_P             0x01

#define PGACFG0_P            0x15     //PGA Configuration 0
// (bits in PGACFG0)
#define PGAOS5_P             0x20
#define PGAOS4_P             0x10
#define PGAOS3_P             0x08
#define PGAOS2_P             0x04
#define PGAOS1_P             0x02
#define PGAOS0_P             0x01

#define AC0CF0_P             0x16     //AC0 Configuration 0
// (bits in AC0CF0)
#define AC0OSE_P             0x80
#define AC0OS6_P             0x40
#define AC0OS5_P             0x20
#define AC0OS4_P             0x10
#define AC0OS3_P             0x08
#define AC0OS2_P             0x04
#define AC0OS1_P             0x02
#define AC0OS0_P             0x01

#define AC1CF0_P             0x17     //AC1 Configuration 0
// (bits in AC1CF0)
#define AC1OSE_P             0x80
#define AC1OS6_P             0x40
#define AC1OS5_P             0x20
#define AC1OS4_P             0x10
#define AC1OS3_P             0x08
#define AC1OS2_P             0x04
#define AC1OS1_P             0x02
#define AC1OS0_P             0x01

#define CKCON2_P             0x40     //Clock Control 2
// (bits in CKCON2)
#define XTGS1_P              0x80
#define XTGS0_P              0x40
#define XTALE_P              0x20
#define IHRCOE_P             0x10
#define MCKS1_P              0x08
#define MCKS0_P              0x04
#define OSCS1_P              0x02
#define OSCS0_P              0x01

#define CKCON3_P             0x41     //Clock Control 3
// (bits in CKCON3)
#define WDTCS1_P             0x80
#define WDTCS0_P             0x40
#define FWKP_P               0x20
#define WDTFS_P              0x10
#define MCKD1_P              0x08
#define MCKD0_P              0x04
#define MCDS1_P              0x02
#define MCDS0_P              0x01

#define CKCON4_P             0x42     //Clock Control 4
// (bits in CKCON4)
#define RCSS2_P              0x80
#define RCSS1_P              0x40
#define RCSS0_P              0x20
#define RPSC2_P              0x10
#define RPSC1_P              0x08
#define RPSC0_P              0x04
#define RTCCS3_P             0x02
#define RTCCS2_P             0x01

#define PCON2_P              0x44     //Power Control 2
// (bits in PCON2)
#define AWBOD1_P             0x80
#define BO1S1_P              0x20
#define BO1S0_P              0x10
#define BO1RE_P              0x08
#define EBOD1_P              0x04
#define BO0RE_P              0x02

#define PCON3_P              0x45     //Power Control 3
// (bits in PCON3)
#define IVREN_P              0x80
#define IVRPDE_P             0x40
#define PSM0_P               0x20
#define SPWRE_P              0x10

#define SPCON0_P             0x48     //SFR Page Control 0
// (bits in SPCON0)
#define P6CTL_P              0x40
#define P4CTL_P              0x20
#define WRCTL_P              0x10
#define CKCTL0_P             0x04
#define PWCTL1_P             0x02
#define PWCTL0_P             0x01

#define DCON0_P              0x4C     //Device Control 0
// (bits in DCON0)
#define HSE_P                0x80
#define IAPO_P               0x40
#define HSE1_P               0x20
#define IORCTL_P             0x04
#define RSTIO_P              0x02
#define OCDE_P               0x01

#define SPHB_P               0x53     //SP High Boundary
// (bits in SPHB)
#define SPHB3_P              0x08
#define SPHB2_P              0x04
#define SPHB1_P              0x02
#define SPHB0_P              0x01

#define RTCCR_P              0x54     //RTC Control Reg.
// (bits in RTCCR)
#define RTCE_P               0x80
#define RTCO_P               0x40
#define RTCRL5_P             0x20
#define RTCRL4_P             0x10
#define RTCRL3_P             0x08
#define RTCRL2_P             0x04
#define RTCRL1_P             0x02
#define RTCRL0_P             0x01

#define RTCTM_P              0x55     //RTC Timer Register
// (bits in RTCTM)
#define RTCCS1_P             0x80
#define RTCCS0_P             0x40
#define RTCCT5_P             0x20
#define RTCCT4_P             0x10
#define RTCCT3_P             0x08
#define RTCCT2_P             0x04
#define RTCCT1_P             0x02
#define RTCCT0_P             0x01

#define PCON0_P              0x87     //Power Control 0
// (bits in PCON0)
#define SMOD1_P              0x80
#define SMOD0_P              0x40
#define POF0_P               0x10
#define GF1_P                0x08
#define GF0_P                0x04
#define PD_P                 0x02
#define IDL_P                0x01

#define PCON1_P              0x97     //Power Control 1
// (bits in PCON1)
#define SWRF_P               0x80
#define EXRF_P               0x40
#define MCDF_P               0x20
#define RTCF_P               0x10
#define SPWF_P               0x08
#define BOF1_P               0x04
#define BOF0_P               0x02
#define WDTF_P               0x01

#define CKCON0_P             0xC7     //Clock Control 0
// (bits in CKCON0)
#define AFS_P                0x80
#define ENCKM_P              0x40
#define CKMIS1_P             0x20
#define CKMIS0_P             0x10
#define CCKS_P               0x08
#define SCKS2_P              0x04
#define SCKS1_P              0x02
#define SCKS0_P              0x01

#define WDTCR_P              0xE1     //Watch-dog-timer Control register
// (bits in WDTCR)
#define WREN_P               0x80
#define NSW_P                0x40
#define ENW_P                0x20
#define CLRW_P               0x10
#define WIDL_P               0x08
#define PS2_P                0x04
#define PS1_P                0x02
#define PS0_P                0x01

#define P4_P                 0xE8     //Port 4
// (bits in P4)
#define P47_P                0x80
#define P45_P                0x20
#define P44_P                0x10
#define P41_P                0x02
#define P40_P                0x01

#define P6_P                 0xF8     //Port 6
// (bits in P6)
#define P61_P                0x02
#define P60_P                0x01

#endif
