/**
 * @file    reg_hwdiv.h
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    25-April-2025
 * @brief   This flie contains all the HWDIV's register and its field definition.
 */


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __REG_HWDIV_H
#define __REG_HWDIV_H

/* Files includes ------------------------------------------------------------*/
#include <core_cm0.h>

#if defined(__CC_ARM)
#pragma anon_unions
#endif

/**
  * @brief HWDIV Base Address Definition
  */
#define HWDIV_BASE                      (AHBPERIPH_BASE + 0x00010000)           /*!< Base Address: 0x40030000 */

/**
  * @brief HWDIV Register Structure Definition
  */
typedef struct
{
    __IO uint32_t DVDR;                 /*!< Divider data register,                         offset: 0x00 */
    __IO uint32_t DVSR;                 /*!< Divisor register,                              offset: 0x04 */
    __IO uint32_t QUOTR;                /*!< Quotient register,                             offset: 0x08 */
    __IO uint32_t RMDR;                 /*!< Remainder register,                            offset: 0x0C */
    __IO uint32_t SR;                   /*!< Status register,                               offset: 0x10 */
    __IO uint32_t CR;                   /*!< Control register,                              offset: 0x14 */
} HWDIV_TypeDef;

/**
  * @brief HWDIV type pointer Definition
  */
#define HWDIV                           ((HWDIV_TypeDef *)HWDIV_BASE)

/**
  * @brief HWDIV_DVDR Register Bit Definition
  */
#define  HWDIV_DVDR_DIVIDEND_Pos        (0)
#define  HWDIV_DVDR_DIVIDEND            (0xFFFFFFFFU << HWDIV_DVDR_DIVIDEND_Pos) /*!< Dividend data register */

/**
  * @brief HWDIV_DVSR Register Bit Definition
  */
#define  HWDIV_DVSR_DIVISOR_Pos         (0)
#define  HWDIV_DVSR_DIVISOR             (0xFFFFFFFFU << HWDIV_DVSR_DIVISOR_Pos) /*!< Divisor data register */

/**
  * @brief HWDIV_QUOTR Register Bit Definition
  */
#define  HWDIV_QUOTR_QUOTIENT_Pos       (0)
#define  HWDIV_QUOTR_QUOTIENT           (0xFFFFFFFFU << HWDIV_QUOTR_QUOTIENT_Pos) /*!< Quotient data register */

/**
  * @brief HWDIV_RMDR Register Bit Definition
  */
#define  HWDIV_RMDR_REMAINDER_Pos       (0)
#define  HWDIV_RMDR_REMAINDER           (0xFFFFFFFFU << HWDIV_RMDR_REMAINDER_Pos) /*!< Remainder data register */

/**
  * @brief HWDIV_DVSR Register Bit Definition
  */
#define  HWDIV_SR_OVF_Pos               (0)
#define  HWDIV_SR_OVF_Msk               (0x01U << HWDIV_SR_OVF_Pos)             /*!< Overflow state bit */

/**
  * @brief HWDIV_CR Register Bit Definition
  */
#define  HWDIV_CR_USIGN_Pos             (0)
#define  HWDIV_CR_USIGN                 (0x01U << HWDIV_CR_USIGN_Pos)           /*!< Unsigned enable */
#define  HWDIV_CR_OVFE_Pos              (1)
#define  HWDIV_CR_OVFE                  (0x01U << HWDIV_CR_OVFE_Pos)            /*!< Overflow interruput enable */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/** --------------------------------------------------------------------------*/
#endif
/** --------------------------------------------------------------------------*/

