/**
 * @file    usart_synchronous_dma_interrupt.h
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#ifndef _USART_SYNCHRONOUS_DMA_INTERRUPT_H_
#define _USART_SYNCHRONOUS_DMA_INTERRUPT_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Files include */
#include "mg32_conf.h"

/* Exported types *****************************************************************************************************/

/* Exported constants *************************************************************************************************/

/* Exported macro *****************************************************************************************************/

/* Exported variables *************************************************************************************************/
#undef EXTERN

#ifdef _USART_SYNCHRONOUS_DMA_INTERRUPT_C_
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN volatile uint32_t USART_TX_DMA_InterruptFlag;
EXTERN volatile uint32_t USART_RX_DMA_InterruptFlag;

/* Exported functions *************************************************************************************************/
void PLATFORM_InitConsole(uint32_t Baudrate);
void USART_Synchronous_DMA_Interrupt_Sample(void);

#ifdef __cplusplus
}
#endif

#endif /* _USART_SYNCHRONOUS_DMA_INTERRUPT_H_ */

