/**
 * @file    mdf101a_it.c
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _MDF101A_IT_C_

/* Files include */
#include "platform.h"
#include "tim2_pwm_inputcapture.h"
#include "mdf101a_it.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup TIM2
  * @{
  */

/**
  * @addtogroup TIM2_PWM_InputCapture
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief  This function handles NMI exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void NMI_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles Hard Fault exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void HardFault_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/***********************************************************************************************************************
  * @brief  This function handles SVCall exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SVC_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles PendSVC exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void PendSV_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles SysTick Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SysTick_Handler(void)
{
    if (0 != PLATFORM_DelayTick)
    {
        PLATFORM_DelayTick--;
    }
}

/***********************************************************************************************************************
  * @brief  This function handles TIM2 Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void TIM2_IRQHandler(void)
{
    if (SET == TIM_GetITStatus(TIM2, TIM_IT_CC1))
    {
        if (0 == TIM2_CC_InterruptFlag)
        {
            TIM2_CC_InterruptFlag = 1;

            TIM2_CC_Value1 = TIM_GetCapture1(TIM2) + 1;
            TIM2_CC_Value2 = TIM_GetCapture2(TIM2) + 1;
        }

        TIM_ClearITPendingBit(TIM2, TIM_IT_CC1);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

