/**
 * @file    mdf101a_it.c
 * @author  MegawinTech Application Team
 * @version V1.0.1
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _MDF101A_IT_C_

/* Files include */
#include "platform.h"
#include "comp_window_tim1_oc1ref.h"
#include "mdf101a_it.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup COMP
  * @{
  */

/**
  * @addtogroup COMP_Window_TIM1_OC1REF
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief  This function handles NMI exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void NMI_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles Hard Fault exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void HardFault_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/***********************************************************************************************************************
  * @brief  This function handles SVCall exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SVC_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles PendSVC exception
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void PendSV_Handler(void)
{
}

/***********************************************************************************************************************
  * @brief  This function handles SysTick Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SysTick_Handler(void)
{
    if (0 != PLATFORM_DelayTick)
    {
        PLATFORM_DelayTick--;
    }
}

/***********************************************************************************************************************
  * @brief  This function handles COMP1_2 Handler
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP1_2_IRQHandler(void)
{
    if (RESET != EXTI_GetITStatus(EXTI_Line19))
    {
        COMP_InterruptFlag = 1;

        EXTI_ClearITPendingBit(EXTI_Line19);

        PLATFORM_LED_Toggle(LED2);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

