///*********************************************************************
//    Ŀ:MG82F6D17-DEMO
//        :LZD
//			԰ʹ MG82F6D17 SSOP20_V10 EV Board (TH194A)
//			CpuCLK=12MHz, SysCLK=12MHz
//	
//			0LIN Master
//	ע
//
//    ʱ:
//    ޸־:
//    
//*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D17.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D17.H"
#include ".\include\API_Uart_BRGRL_MG82F6D17.H"


///*************************************************
//ϵͳʱSysClk (MAX.50MHz)
//ѡ: 
//	11059200,12000000,
//	22118400,24000000,
//	29491200,32000000,
//	44236800,48000000
//*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
///*************************************************
//CPUʱ CpuClk (MAX.36MHz)
//	1) CpuCLK=SysCLK
//	2) CpuClk=SysClk/2
//*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35



#define LIN_SYNC_BYTE				0x55

#define LIN_PID_MASTER_TX_MSG		0x30		
#define LIN_PID_MASTER_RX_MSG		0x31

#define LIN_PID_MASTER_TX_MSG_P		0xF0		
#define LIN_PID_MASTER_RX_MSG_P		0xB1


// LIN״̬
typedef enum
{
  LIN_IDLE_BREAK=0,
  LIN_SYNC,
  LIN_PID,
  LIN_MASTER_RX_DATA,
  LIN_MASTER_RX_CHECKSUM,
  LIN_MASTER_RX_DONE,
  LIN_MASTER_TX_DATA,
  LIN_MASTER_TX_CHECKSUM,
  LIN_MASTER_TX_DONE,
  LIN_ERR
}LIN_State;

// LINģʽ
typedef enum
{
  	LIN_MODE_MASTER_TX=0,
	LIN_MODE_MASTER_RX,
	LIN_MODE_SLAVE_TX,
	LIN_MODE_SLAVE_RX
}LIN_Mode;

// ֡ṹ
typedef struct
{
	LIN_Mode Mode;
  	LIN_State State;
  	u8 PID ;
  	u8 Data[8];
  	u8 DataLength;
  	u8 DataInx;
  	u8 Check;
} LIN_Frame ;

#define BIT(A,B)      ((A>>B)&0x01)  

idata LIN_Frame LINFrame;

u8 LedTime;
u8 LINOverTime;

void LIN_Master_StartFrame(void);
u8 LIN_CalcParity(u8 id);
u8 LIN_CalcChecksum(u8 id,u8 *lindata,u8 length);

///***********************************************************************************
//:   void INT_UART0(void)
//:UART0 жϷ
//:   
//ز:     
//*************************************************************************************/
void INT_UART0(void) interrupt INT_VECTOR_UART0
{
	_push_(SFRPI);
	SFRPI=0;
	if(RI0==1)
	{
		if(LINFrame.State==LIN_MASTER_RX_DATA)
		{ // Rx data
			
			LINFrame.Data[LINFrame.DataInx] = S0BUF;
			LINFrame.DataInx++;
			if(LINFrame.DataInx>=LINFrame.DataLength)
			{
				LINFrame.State++;
			}

		}
		else if(LINFrame.State==LIN_MASTER_RX_CHECKSUM)
		{ // Rx checksum
			LINFrame.Check=S0BUF;
			LINFrame.State++;
			
		}
		else if(LINFrame.State==LIN_MASTER_RX_DONE)
		{ // Rx done
		
		}
		else
		{
			LINFrame.State=LIN_ERR;
		}
		RI0 = 0;
	}
	else
	{
		TI0 = 0;
		
		if(LINFrame.State==LIN_IDLE_BREAK)
		{
			if((S0CFG1&SBF0)!=0)
			{ // Send break end
				UART0_LIN_ClrSBF0();
				S0BUF=LIN_SYNC_BYTE;		// Send SYNC
				LINFrame.State++;
			}
		}
		/**/
		else if(LINFrame.State==LIN_SYNC)
		{// Send SYNC end
			LINFrame.State++;
			S0BUF=LINFrame.PID;				// Send PID
		}
		/**/
		else if(LINFrame.State==LIN_PID)
		{// Send PID end 
			if(LINFrame.Mode == LIN_MODE_MASTER_RX)
			{
				LINFrame.DataInx=0;
				LINFrame.State= LIN_MASTER_RX_DATA;
				UART0_LIN_SetRX();			// Ϊ LIN RXģʽ
				
			}
			else if(LINFrame.Mode == LIN_MODE_MASTER_TX)
			{// Start send DATA
				S0BUF = LINFrame.Data[0];
				LINFrame.DataInx=1;
				LINFrame.State= LIN_MASTER_TX_DATA;
			}
			else
			{ 
				LINFrame.State=LIN_ERR;
			}
		}
		else if(LINFrame.State==LIN_MASTER_TX_DATA)
		{
			
			S0BUF=LINFrame.Data[LINFrame.DataInx];
			LINFrame.DataInx++;
			if(LINFrame.DataInx>=LINFrame.DataLength)
			{
				LINFrame.State++;
			}

		}
		else if(LINFrame.State==LIN_MASTER_TX_CHECKSUM)
		{
			S0BUF=LINFrame.Check;
			LINFrame.State++;
		}
		else if(LINFrame.State==LIN_MASTER_TX_DONE)
		{
		}
		else
		{
			LINFrame.State=LIN_ERR;
		}
	}
	_pop_(SFRPI);
}

///***********************************************************************************
//:   void INT_T0(void)
//:T0 жϷ
//:   
//ز:     
//*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;

	if(LedTime!=0) LedTime--;
	if(LINOverTime!=0) LINOverTime--;
}


///*************************************************
//:     void DelayXus(u16 xUs)
//:   	ʱ򣬵λΪus
//:     u8 Us -> *1us  (1~255)
//:     
//*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

///*************************************************
//:     void DelayXms(u16 xMs)
//:     ʱ򣬵λΪms
//:     u16 xMs -> *1ms  (1~65535)
//:     
//*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

///***********************************************************************************
//:   void InitPort(void)
//:   IO
//:   
//ز:     
//*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);		//  P30,P31,P33,P34,P35 Ϊ׼˫
}


///***********************************************************************************
//:   void InitUart0_LIN(void)
//:   Uart0ʼ Ϊ LIN
//:   
//ز:     
//*************************************************************************************/
void InitUart0_LIN(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetModeLIN();					// ôLIN ģʽ				
	UART0_EnReception();				// չ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_19200_2X_12000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
	
	UART0_LIN_TxSYNC_16Bit();			//  TX break 16bit
	
}

///***********************************************************************************
//:   void InitTimer0(void)
//:Timer0ʼ
//		 T0Ϊ16λʱ,ʱΪSysclk/192 6us~393216us	
//:   
//ز:     
//*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();					// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// T08λ

	TM_EnableT0();							// ʹT0
}


///***********************************************************************************
//:   void InitInterrupt(void)
//:   жϳʼ
//:   
//ز:     
//*************************************************************************************/
void InitInterrupt(void)
{
//	INT_EnUART0();				// ʹT0ж
	INT_EnTIMER0();				// ʹT0ж
}	


///***********************************************************************************
//:   void InitSystem(void)
//:   ϵͳʼ
//:   
//ز:     
//*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitTimer0();
	InitUart0_LIN();
	InitInterrupt();
}


/*
*************************************************************************************
*  Function
*
*************************************************************************************
*/

///***********************************************************************************
//:   void LIN_Master_StartFrame(void)
//:   LIN Master ʼһ֡ͨ
//:   
//ز:     
//*************************************************************************************/
void LIN_Master_StartFrame(void)
{
	UART0_LIN_SetTX();
	UART0_LIN_ClrTXER0();
	UART0_LIN_ClrSBF0();
	TI0=0;
	UART0_LIN_SendSYNC();
	S0BUF=0x55;
}

///***********************************************************************************
//:	uint8 LIN_CalcParity(uint8 id)
//: LINżУ
//:	
//ز:	  
//*************************************************************************************/
u8 LIN_CalcParity(u8 id)
{
	u8 parity, p0,p1;
	parity=id; 
	p0=(BIT(parity,0)^BIT(parity,1)^BIT(parity,2)^BIT(parity,4))<<6;     //żУλ
	p1=(!(BIT(parity,1)^BIT(parity,3)^BIT(parity,4)^BIT(parity,5)))<<7;  //Уλ
	parity|=(p0|p1);
	return parity;
}


///***********************************************************************************
//:	u8 LIN_CalcChecksum(uint8 id,uint8 *data,uint8 length)
//: LINУͼ
//:	
//ز:	  
//*************************************************************************************/
u8 LIN_CalcChecksum(u8 id,u8 *lindata,u8 length)
{
	u8 i;
	u16 check_sum = 0;
	//0x3C 0x3D ʹñ׼У
	if(id != 0x3c && id != 0x7d)  
	{//ʹǿУ
	 	check_sum  = id ;
	} 
	else 
	{//ʹñ׼У
	 	check_sum = 0 ;
	}
	for (i = 0; i < length; i++) 
	{    
	 	 check_sum += *(lindata++);
	  
	  	if (check_sum > 0xFF)      
	  	{
	  		check_sum -= 0xFF;
	  	}
	}
	return (~check_sum);  
}




/*
*************************************************************************************
*/ 

///***********************************************************************************
//:	void TestMasterTxMsgToSlave()
//: Էݵӻ
//:	
//ز:	  
//*************************************************************************************/
void TestMasterTxMsgToSlave()
{
	u8 i;

	// Master Tx Test
	LINFrame.Mode=LIN_MODE_MASTER_TX;
	LINFrame.PID=LIN_CalcParity(LIN_PID_MASTER_TX_MSG);
	LINFrame.DataInx=0;
	LINFrame.DataLength=8;
	for(i=0;i<8;i++)
	{
		LINFrame.Data[i]=i+0x30;
	}
	LINFrame.Check=LIN_CalcChecksum(LINFrame.PID, &LINFrame.Data[0],LINFrame.DataLength);
	LINFrame.State=LIN_IDLE_BREAK;
	LIN_Master_StartFrame();
	TI0=0;RI0=0;
	INT_EnUART0();		// ʹ UART0ж
	
	LINOverTime=20;
	while (LINOverTime!=0)
	{
		if((LINFrame.State==LIN_ERR)||(LINFrame.State==LIN_MASTER_TX_DONE))
		{
		  break;
		}
	}
	INT_DisUART0(); 	// ֹ UART0ж
	if(LINFrame.State==LIN_MASTER_TX_DONE)
	{// ͳɹ
		LED_R=0;
	}
	DelayXms(2);
	LED_R=1;
}

///***********************************************************************************
//:	void TestMasterRxMsgFromSlave()
//: Զȡӻ
//:	
//ز:	  
//*************************************************************************************/
void TestMasterRxMsgFromSlave()
{
	u8 i;
	// Master Rx Test
	LINFrame.Mode=LIN_MODE_MASTER_RX;
	LINFrame.PID=LIN_CalcParity(LIN_PID_MASTER_RX_MSG);
	LINFrame.DataInx=0;
	LINFrame.DataLength=8;
	for(i=0;i<8;i++)
	{
		LINFrame.Data[i]=0x00;
	}
	LINFrame.State=LIN_IDLE_BREAK;
	LIN_Master_StartFrame();
	TI0=0;RI0=0;
	INT_EnUART0();		// ʹ UART0ж
	
	LINOverTime=20;
	while (LINOverTime!=0)
	{
		if((LINFrame.State==LIN_ERR)||(LINFrame.State==LIN_MASTER_RX_DONE))
		{
		  break;
		}
	}
	INT_DisUART0(); 	// ֹ UART0ж
	if(LINFrame.State==LIN_MASTER_RX_DONE)
	{// ճɹ
		// У
		if(LINFrame.Check == LIN_CalcChecksum(LINFrame.PID, &LINFrame.Data[0], LINFrame.DataLength))
		{ // Уɹ
			LED_G_1=0;
		}
	}
	DelayXms(2);
	LED_G_1=1;
}

void main()
{
	
	InitSystem();
	
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	

	INT_EnAll();		// ʹȫж

	while(1)
    {
    	LED_G_0=0;
    	DelayXms(50);
		TestMasterTxMsgToSlave();
    	LED_G_0=1;
    	DelayXms(50);
		TestMasterRxMsgFromSlave();
		
    }

}


