///*********************************************************************
//    Ŀ:MG82F6D17-DEMO
//        :LZD
//			԰ʹ MG82F6D17 SSOP20_V10 EV Board (TH194A)
//			CpuCLK=12MHz, SysCLK=12MHz
//	
//			ADC ڵѹ⣬ɼADCֵuart
//			ADCֵڴֵڣڴϢ
//			ɼţP10	 ڣP30 P31
//	ע
//
//    ʱ:
//    ޸־:
//*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D17.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D17.H"
#include ".\include\API_Uart_BRGRL_MG82F6D17.H"


///*************************************************
//ϵͳʱSysClk (MAX.50MHz)
//ѡ: 
//	11059200,12000000,
//	22118400,24000000,
//	29491200,32000000,
//	44236800,48000000
//*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
///*************************************************
//CPUʱ CpuClk (MAX.36MHz)
//	1) CpuCLK=SysCLK
//	2) CpuClk=SysClk/2
//*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35


bit bES0;
bit bADCFinish =0;
WordTypeDef wAdcValue;

#define TEST_ADC_BUF_SIZE	16
xdata u16 wAdcBuf[TEST_ADC_BUF_SIZE];
u8 AdcBufCnt;

///***********************************************************************************
//:   void INT_ADC(void)
//:ADC жϷ
//		 
//:   
//ز:     
//*************************************************************************************/
void INT_ADC(void) interrupt INT_VECTOR_ADC
{
	
	if((ADCON0 & ADCWI) != 0)	//ж
	{
		ADCON0 &= ~ADCWI;//ж
		LED_R = ~LED_R;
		wAdcValue.B.BHigh = ADCDH;
   	 	wAdcValue.B.BLow = ADCDL;
		wAdcValue.W &= 0xFFF;
		wAdcBuf[AdcBufCnt]=wAdcValue.W;
		AdcBufCnt++;
		if(AdcBufCnt>=TEST_ADC_BUF_SIZE)
		{
			bADCFinish=TRUE;
			INT_DisADC();		// Buf,ֹADCж
		}
		
	}
	
}

///*************************************************
//: char putchar (char c)   
//: printf Ĵ
//:     char c
//:     
//*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}


///*************************************************
//:     void DelayXus(u16 xUs)
//:   	ʱ򣬵λΪus
//:     u8 Us -> *1us  (1~255)
//:     
//*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

///*************************************************
//:     void DelayXms(u16 xMs)
//:     ʱ򣬵λΪms
//:     u16 xMs -> *1ms  (1~65535)
//:     
//*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

///***********************************************************************************
//:   void InitPort(void)
//:   IO
//:   
//ز:     
//*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);		//  P30,P31,P33,P34,P35 Ϊ׼˫
	PORT_SetP1AInputOnly(BIT0);							//  P10(AIN0) 룬ADCͨ
}


///***********************************************************************************
//:   void InitADC(void)
//:   ADCʼ
//:   
//ز:     
//*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();						// ʹADC
	ADC_SetClock_SYSCLK();			    // ADCתʱΪ SYSCLK
	ADC_SetMode_FreeRunning();			// ADCȫ
	ADC_SetADCData_12Bit();				// ADCλ: 12bit			
	ADC_SetRightJustified();			// ADCתҶ

	ADC_SetWindow_WithIn();				// ڴλADCWI
	ADC_SetWindow_High(0x700);			// ADCֵߵ
	ADC_SetWindow_Low(0x200);			// ADCֵ͵

	ADC_DisInterrupt_ADCI();			// ֹADCɱ־λADCIǷж
	ADC_EnInterrupt_ADCWI();			// ʹADCڱ־λADCWIж
	ADC_DisInterrupt_SMPF();			// ֹADCɱ־λSFPFж



	
}

///***********************************************************************************
//:   void InitInterrupt(void)
//:   жϳʼ
//:   
//ز:     
//*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnADC();						// ʹADCж

	INT_EnAll();						//  ʹȫж
	
}	


///***********************************************************************************
//:   void InitUart0(void)
//:   Uart0ʼ,ʹS0BRGΪԴ
//:   
//ز:     
//*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_12000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

///***********************************************************************************
//:   void InitSystem(void)
//:   ϵͳʼ
//:   
//ز:     
//*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitADC();
	InitUart0_S0BRG();
	InitInterrupt();
}

void main()
{
	u8 i;
	
	InitSystem();
	AdcBufCnt=0;
	bADCFinish=FALSE;

	printf("\nStart!");

	LED_G_0=0;LED_R=0;LED_G_1=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

  	while(1)
  	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;

		if(bADCFinish)
		{
			LED_R=1;
			printf("\nADC Win:");
			for(i=0;i<TEST_ADC_BUF_SIZE;i++)
			{
				printf("%04X ",wAdcBuf[i]);
			}
			bADCFinish=FALSE;
			INT_EnADC();	// ,ʹADCж
		}
			
    }
}


