///*********************************************************************
//    Ŀ:MG82F6D17-DEMO
//        :LZD
//			԰ʹ MG82F6D17 SSOP20_V10 EV Board (TH194A)
//			CpuCLK=12MHz, SysCLK=12MHz
//	
//			0ģʽ4 (SPIģʽ)
//			SPICLK <-->TXD	P31
//			MOSI	<-->RXD  P30
//			MISO	<-->S0MI P16
//	ע
//
//    ʱ:
//    ޸־:
//    
//*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D17.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D17.H"
#include ".\include\API_Uart_BRGRL_MG82F6D17.H"


///*************************************************
//ϵͳʱSysClk (MAX.50MHz)
//ѡ: 
//	11059200,12000000,
//	22118400,24000000,
//	29491200,32000000,
//	44236800,48000000
//*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
///*************************************************
//CPUʱ CpuClk (MAX.36MHz)
//	1) CpuCLK=SysCLK
//	2) CpuClk=SysClk/2
//*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35

#define SFR_Page_(x)		SFRPI = x;
#define SPI_NSS		P33

sfr UARTSPICLK		= 0xBB;

// ѡSPICLK ʼƽ
#define SPICLK_LOW	0	// SPICLK  ʼΪ͵ƽ
#define SPICLK_HIGH	1	// SPICLK  ʼΪ͵ƽ
#define SPI_CPOL  SPICLK_LOW	

// ѡݴ˳
#define LSB	0	// λ
#define MSB	1	// λ
#define SPI_DORD	MSB

// ѡSPI Ĵٶ
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

///*************************************************
//:     void DelayXus(u16 xUs)
//:   	ʱ򣬵λΪus
//:     u8 Us -> *1us  (1~255)
//:     
//*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

///*************************************************
//:     void DelayXms(u16 xMs)
//:     ʱ򣬵λΪms
//:     u16 xMs -> *1ms  (1~65535)
//:     
//*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

///***********************************************************************************
//:   void InitPort(void)
//:   IO
//:   
//ز:     
//*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT3|BIT4|BIT5);		// P33,P34,P35Ϊ˫
	PORT_SetP3PushPull(BIT0|BIT1);			// P30P31ΪMOSI,SPICLK
	PORT_SetP1OpenDrainPu(BIT6);			// P16,MISO
}

///***********************************************************************************
//:   BYTE Uart0SPITransceiver(BYTE ToSend)
//:   SPIͺ
//:   BYTE ToSend
//ز:     
//*************************************************************************************/
BYTE Uart0SPITransceiver(BYTE ToSend)
{
	S0BUF=ToSend;
	while(TI0==0);
	TI0=0;
	return S0BUF;
}

///***********************************************************************************
//:   void InitUart0_SPI_Master(void)
//:   Uart0ʼ SPI Master
//:   
//ز:     
//*************************************************************************************/
void InitUart0_SPI_Master(void)
{
	P31=1;
	UART0_SetModeSPIMaster();			// ôSPIģʽ
	UART0_SetMISOP16();					// ôSPIMISOΪP16
	UART0_SetRxTxP30P31();				// ôSPIRXMOSI,TX(SPI_CLK)ΪP30,P31
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART0_SetSPIClock_SYSCLKDiv4();		// SPIʱΪϵͳʱӵ4Ƶ
#else
	UART0_SetSPIClock_SYSCLKDiv12();	// SPIʱΪϵͳʱӵ12Ƶ
#endif

#if (SPI_DORD==MSB)
	UART0_SetDataMSB();
#else
	UART0_SetDataLSB();
#endif

#if (SPI_CPOL==SPICLK_LOW)									
	UARTSPICLK = 0x21;					// SPICLK  ʼΪ͵ƽ
#endif

	
}

///***********************************************************************************
//:   void InitSystem(void)
//:   ϵͳʼ
//:   
//ز:     
//*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart0_SPI_Master();
}

void main()
{
	InitSystem();
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;	
		Uart0SPITransceiver(0x05);	
	}

}


