///*********************************************************************
//    Ŀ:MG82F6D17-DEMO
//        :LZD
//			԰ʹ MG82F6D17 SSOP20_V10 EV Board (TH194A)
//			CpuCLK=12MHz, SysCLK=12MHz
//	
//			RTCʱΪILRCO 32KHz
//			RTC Clock ԤƵ 32768
//			RTC ֵ (64-1)=63
//			RTCƵΪ 32K/32768/10 ~= 1Hz
//			ģʽ, RTC
//	ע
//
//    ʱ:
//    ޸־:
//    
//*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D17.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D17.H"
#include ".\include\API_Uart_BRGRL_MG82F6D17.H"


///*************************************************
//ϵͳʱSysClk (MAX.50MHz)
//ѡ: 
//	11059200,12000000,
//	22118400,24000000,
//	29491200,32000000,
//	44236800,48000000
//*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
///*************************************************
//CPUʱ CpuClk (MAX.36MHz)
//	1) CpuCLK=SysCLK
//	2) CpuClk=SysClk/2
//*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P33
#define LED_R		P34
#define LED_G_1		P35



///***********************************************************************************
//:   void INT_SF(void)
//:SF(ϵͳ־λ)жϷ
//		 RTC,WDTF,BOD0F,BOD1F
//:   
//ز:     
//*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	 if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;
		LED_R=!LED_R;
	}
}

///***********************************************************************************
//:   u8 IAP_ReadPPage(u8 PsfrAddr)
//:ȡPҳ⹦
//:   
//		 u8 PsfrAddr: Pҳַ
//ز:     
//		 u8: Pҳ
//*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					
	return IFD;
}

///***********************************************************************************
//:void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
//:дPҳ⹦
//:   
//		 u8 PsfrAddr: Pҳַ,u8 PsfrData:  Pҳ
//ز:     
//*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					
}

///*************************************************
//:     void DelayXus(u16 xUs)
//:   	ʱ򣬵λΪus
//:     u8 Us -> *1us  (1~255)
//:     
//*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

///*************************************************
//:     void DelayXms(u16 xMs)
//:     ʱ򣬵λΪms
//:     u16 xMs -> *1ms  (1~65535)
//:     
//*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

///***********************************************************************************
//:   void InitRTC(void)
//:RTC ʼ	
//		RTCʱΪILRCO 32KHz
//		RTC Clock ԤƵ 32
//		RTC ֵ (64-1)=63
//		RTCƵΪ 32K/32768/1~=1Hz
//:   
//ز:     
//*************************************************************************************/
void InitRTC(void)
{	
	RTC_Disable();
	RTC_SetClock_ILRCO();		// ѡRTCʱΪ ILRCO 32KHz
	RTC_SetClock_Div_32768();	// ѡRTC Clock ԤƵ 32768
	RTC_SetReload(64-1);		// RTC ֵ (64-1)=63
	RTC_SetCounter(64-1);

	RTC_ClearRTCF();			// RTCF
	RTC_Enable();				// ʹRTC
	
}


///***********************************************************************************
//:   void InitInterrupt(void)
//:InitInterruptʼ
//:   
//ز:     
//*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// ʹRTCж,ʹϵͳ־ж
	INT_EnSF();				// ʹϵͳ־ж
}


///***********************************************************************************
//:   void InitPort(void)
//:   IO
//:   
//ز:     
//*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);		//  P30,P31,P33,P34,P35 Ϊ׼˫
}



///***********************************************************************************
//:   void InitSystem(void)
//:   ϵͳʼ
//:   
//ز:     
//*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	
	InitRTC();			

	InitInterrupt();		
	
	INT_EnAll();			// ʹȫж

}



void main()
{
	u8 i;
	
	//u8 BakCKCON2;			// CKCON2 (ʹPLL CKMƵ)
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
    	for(i=0;i<20;i++)
    	{
	    	DelayXms(100);
	    	LED_G_0=!LED_G_0;
    	}
		LED_G_0=1;
    	LED_G_1=0;
    	InitRTC();
    	LED_R=1;

		//BakCKCON2=IAP_ReadPPage(CKCON2_P);							// CKCON2 (ʹPLL CKMƵ)
		//IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));		// MCK=OSCin (ʹPLL CKMƵ)

    	POW_SetMode_PD();	// ģʽ

		_nop_();
		//DelayXus(100);												// ʱCKMȶ (ʹPLL CKMƵ)
		//IAP_WritePPage(CKCON2_P,BakCKCON2);							// ָCKCON2,ѡʹñƵ (ʹPLL CKMƵ)

    	LED_G_1=1;
    	
    }
}

