/**
 * @file    flash_mainflash_readprotection.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the system functions 
 */

/* Define to prevent recursive inclusion */
#define _FLASH_MAINFLASH_READPROTECTION_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "flash_mainflash_readprotection.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup FLASH
  * @{
  */

/**
  * @addtogroup FLASH_MainFlash_ReadProtection
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void FLASH_MainFlash_ReadProtection_Sample(void)
{
    printf("\r\nTest %s", __FUNCTION__);

    /* Main flash block read protection */
    FLASH_Unlock();
    FLASH_EraseOptionBytes();
    FLASH_ProgramOptionHalfWord(0x1FFFF800, 0x7F80);
    FLASH_Lock();

    while(1)
    {
        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */



