//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"

#define BUSY 	0x10
#define START 	0x01
//********************************************************************************
//								   ADC INIT
//********************************************************************************
void Adc_Init (void){
	ADCCONT = ADCCONT_REGS;
	ADCSTR = ADCSTR_REGS;
}
//********************************************************************************
//								  ADC Channel
//********************************************************************************
signed int Adc_Channel (unsigned char Channel){
	int16 Temp;
	ADCCONT = (ADCCONT | Channel);
	ADCSTR = (ADCSTR | START);
	while((ADCSTR & BUSY) == BUSY){}; //Check ADC Busy end
	Temp = ADCD1;
	Temp = Temp << 8;
	Temp |= ADCD2;
	ADCCONT = (ADCCONT & 0xF8);
	return Temp;
}