#ifndef PROTECTION_H
#define PROTECTION_H

// <<< Use Configuration Wizard in Context Menu >>>

// <e> Over Voltage Protection (Enable / Disable)
//   <o1> VBus_Normal_Voltage (unit : 0.1 Volt)
//   <o3> VBus_Over_Voltage (unit : 0.1 Volt)
//   <o5> VBus_Lower_Voltage (unit : 0.1 Volt)
//   <o7> VBus_Over_Voltage_Restart (unit : 0.1 Volt)
//   <o9> VBus_Lower_Voltage_Restart (unit : 0.1 Volt)
//   <o11> VBus_R1 (unit : 0.1 kOhms)
//   <o13> VBus_R2 (unit : 0.1 kOhms)
//   <o15> OVP_CH <0=> CH0 <1=> CH1  <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5  <6=> CH6 <7=> CH7
// </e>
#define dOVP_PROTECTION_ENABLE 0
#define dVDC_NORMAL_VOLTAGE					((float)120/10)		// @ Volt,
#define dVDC_OVER_VOLTAGE						((float)140/10)		// @ Volt,
#define dVDC_LOWER_VOLTAGE					((float)100/10)		// @ Volt,
#define dVDC_OVER_VOLTAGE_RESTART		((float)130/10)		// @ Volt,
#define dVDC_LOWER_VOLTAGE_RESTART	((float)110/10)		// @ Volt,
#define dVIN_R1											((float)200/10)		// @ kOhms, Up Side Resistor Value of the Voltage Divider
#define dVIN_R2											((float)20/10)		// @ kOhms, Down Side Resistor Value of the Voltage Divider
#define OVP_CH											(6)								// ADC Channel of the OVP, CH3 as OVP
#if (dOVP_PROTECTION_ENABLE == 1)
	#define	dOVP_PROTECTION_ON
#endif

//<e> Lock Rotor Protection (Enable / Disable)
	#define dLOCK_ROTOR_PROTECTION_ENABLE 	1
	#if(dLOCK_ROTOR_PROTECTION_ENABLE == 1)
//	<o> Rotor_Lock_Detection_Time (unit : ms)
			#define	ROTORLOCK_DETECTION_TIME 		(5000)

		#define	dLOCK_ROTOR_PROTECTION_ON
	#endif
//</e>

// <e> Over Temperature Protection (Enable / Disable)
#define dOTP_PROTECTION_ENABLE 0
#if (dOTP_PROTECTION_ENABLE == 1)
	#define	dOTP_PROTECTION_ON
#endif
//   <o> OTP_CH <0=> CH0 <1=> CH1  <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5  <6=> CH6 <7=> CH7
#define OTP_CH										(4) // ADC Channel of the OTP, CH4 as OTP
// <o> OTP_Mode <0=> Positive <1=> Negative 
#define OTP_Mode 1
//   <o> OTP_Over_Temp (unit : 0.001 Volt)
#define dOTP_OVER_TEMP						((float)500/1000) // @Volt, 5.698k@100C, (1.8148)
//   <o> OTP_Over_Temp_Restart (unit : 0.001 Volt)
#define dOTP_OVER_TEMP_RESTART		((float)1500/1000) // @Volt, 50.52k@40C
// <o> OTP_Duty_Limit_Protect <0=> Disable <1=> Enable 
#define OTP_DUTY_LIMIT_PROTECTION (1) 
//   <o> OTP_Limit_Temp (unit : 0.001 Volt)
#define dOTP_LIMIT_TEMP						((float)650/1000) // @Volt, 5.698k@100C, (1.8148)
//   <o> OTP_Limit_Temp_Restart (unit : 0.001 Volt)
#define dOTP_LIMIT_TEMP_RESTART		((float)1500/1000) // @Volt, 5.698k@100C, (1.8148)
// <o> OTP_Duty_Amplitude_Max[OpenLoop](unit : %) <0-100>
// <i> Limit : 0 ~ 100% Only For OpenLoop
#define	OTP_AMP_MAX								(unsigned int)((float)50.0  / 100 * DUTY_MAX)	 	// Define Maximum Amplitude //300 RPM
// <o> OTP_Speed_Max[SpeedLoop](unit : RPM)
// <i> Limit : Only For SpeedLoop
#define	OTP_Speed_Max							((400) >> SPEED_SHIFT)						// @RPM
// </e>

// <h> Error Code Retry
//   <o> Restart_Time (unit : ms)
#define	dROTOR_LOCKED_TO_RESTART_TIMER		(3000)
//   <o> Retry_Time 	(unit : x)
#define	dRESTART_TIME											(3)
// <o> Unlimit_Retry_Time <0=> Disable <1=> Enable 
#define dUNLIMIT_RETRY_TIME 0
// </h>

/* Vdc Bus */
	extern data  unsigned int					Vdc_Bus_Data;
	extern xdata volatile unsigned char			VDC_BUS_OV_COUNTER;
	extern xdata volatile unsigned char			VDC_BUS_LV_COUNTER;
	extern xdata volatile unsigned short int 	VDC_BUS_StartCheck_Cnt;
	extern xdata volatile unsigned short int 	VDC_BUS_ReStartCheck_Cnt;
	extern xdata volatile unsigned char			Flag_Vdc_Bus_Check;

/* OTP */
	extern data  unsigned int	OTP_Data;
	extern xdata unsigned char OTP_COUNTER;
	extern xdata unsigned char OTP_LM_COUNTER;
	extern bit OTP_Duty_Limit;

extern void OVP_Function(void);
extern void OTP_Function(void);
#endif

// Error Code
#define	dERRORCODE_NORMALOPERATION										(0)
#define	dERRORCODE_MOTORSTOP											(1)
#define	dERRORCODE_OVERVOLTAGEPROTECTION								(2)
#define	dERRORCODE_OVERCURRENTPROTECTION								(3)
#define	dERRORCODE_OVERSPEEDPROTECTION									(4)
#define	dERRORCODE_OVERTEMPPROTECTION									(5)
#define	dERRORCODE_ROTORLOCKPROTECTION									(6)
#define	dERRORCODE_RESTARTPROTECTION									(7)
