#ifndef	_ENGINERRING_INTERFACE_
#define	_ENGINERRING_INTERFACE_
//---------------------------------------------------------------------------//
// Head Files                                                                //
//---------------------------------------------------------------------------//
#include	"User_Interface.h"


//---------------------------------------------------------------------------//
//                                                                           //
//                      Engineering model Don't Modify                       //
//                                                                           //
//---------------------------------------------------------------------------//
// PWM

#if( AMP_FINE_TUNE == 1)
#define	MPWMDATA_REGS						(unsigned int)((384000000) / PWM_Frequency / 2.0)								// Hz, Base on 48MHz, 1500@16KHz, 1333@18KHz, 1200@20KHz
#define 	MPWM_MAX_L							((MPWMDATA_REGS>>3) & 0xFF)
#define 	MPWM_MAX_H							((MPWMDATA_REGS>>11) & 0xFF)
#else
#define	MPWMDATA_REGS						(unsigned int)((48000000) / PWM_Frequency / 2.0)								// Hz, Base on 48MHz, 1500@16KHz, 1333@18KHz, 1200@20KHz
#define	MPWM_MAX_L							(unsigned int)((MPWMDATA_REGS     ) & 0xFF)
#define	MPWM_MAX_H							(unsigned int)((MPWMDATA_REGS >> 8) & 0xFF)
#endif

#ifdef	SINUSOLIDAL_CONTROL
#define	DUTY_MAX						(unsigned int)((MPWMDATA_REGS >> 1))
#else
#define	DUTY_MAX						(unsigned int)((MPWMDATA_REGS))
#endif

// FG Output Pulse Selection
#ifdef	FG_CAL
#define	FG_FORMULAR						(unsigned long)(60000000 / FG_CAL_PULSE_PER_ROUND)//(unsigned long)(24000000 / 12 / 2 ) * (60 / FG_CAL_PULSE_PER_ROUND)
//#define	FG_FORMULAR						(unsigned long)(24000000 / 12 / 2 ) * (60 / FG_CAL_PULSE_PER_ROUND)
#endif
#ifdef	FG_2_PULSE_PER_ROUND
#define	FG_PULSE_PER_ROUND				(3)
#endif
#ifdef	FG_3_PULSE_PER_ROUND
#define	FG_PULSE_PER_ROUND				(2)
#endif
#ifdef	FG_6_PULSE_PER_ROUND
#define	FG_PULSE_PER_ROUND				(1)
#endif


// Angle Shift
#ifdef	SPEEDLOOP_CONTROL
#define	AS_STEP_REV						(signed int)((signed int)AMP_MAX   / (AS_MAX_REV - AS_MIN_REV))
#define	AS_STEP_FRD						(signed int)((signed int)AMP_MAX   / (AS_MAX_FRD - AS_MIN_FRD))
#endif

#ifdef	CURRENTLOOP_CONTROL
#define	AS_STEP_REV						(signed int)((signed int)AMP_MAX   / (AS_MAX_REV - AS_MIN_REV))
#define	AS_STEP_FRD						(signed int)((signed int)AMP_MAX   / (AS_MAX_FRD - AS_MIN_FRD))
#endif

#ifdef	DUTY_CONTROL
#define	AS_STEP_REV						(signed int)((signed int)AMP_MAX   / (AS_MAX_REV - AS_MIN_REV))
#define	AS_STEP_FRD						(signed int)((signed int)AMP_MAX   / (AS_MAX_FRD - AS_MIN_FRD))
#endif


// Speed Command Input Source, which is Base on PWM(Digital) or VSP(Analog)
#if (Input_Command_Type==1)
#define	CMD_MAX_VAL						(unsigned int)(CMD_MAX   * 1024 / 100.0)
#define	CMD_START_VAL					(unsigned int)(CMD_START * 1024 / 100.0)
#define	CMD_STOP_VAL					(unsigned int)(CMD_STOP  * 1024 / 100.0)
#ifdef	SPEEDLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (SPEED_MAX - SPEED_MIN)) / (CMD_MAX_VAL - CMD_START_VAL)
#else
#ifdef	CURRENTLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (IBUS_MAX  - IBUS_MIN))  / (CMD_MAX_VAL - CMD_START_VAL)
#endif
#endif
#ifdef	DUTY_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (AMP_MAX   - AMP_MIN))   / (CMD_MAX_VAL - CMD_START_VAL)
#endif

#elif	(Input_Command_Type==2)
#define	CMD_MAX_VAL						(unsigned int)(CMD_MAX   )
#define	CMD_START_VAL					(unsigned int)(CMD_START )
#define	CMD_STOP_VAL					(unsigned int)(CMD_STOP  )
#ifdef	SPEEDLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (SPEED_MAX - SPEED_MIN)) / (CMD_MAX_VAL - CMD_START_VAL)
#else
#ifdef	CURRENTLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (IBUS_MAX  - IBUS_MIN))  / (CMD_MAX_VAL - CMD_START_VAL)
#endif
#endif
#ifdef	DUTY_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (AMP_MAX   - AMP_MIN))   / (CMD_MAX_VAL - CMD_START_VAL)
#endif

#elif	(Input_Command_Type==0)
#define	CMD_MAX_VAL						(unsigned int)(CMD_MAX   * 1024 / CMD_BASE)
#define	CMD_START_VAL					(unsigned int)(CMD_START * 1024 / CMD_BASE)
#define	CMD_STOP_VAL					(unsigned int)(CMD_STOP  * 1024 / CMD_BASE)
#ifdef	SPEEDLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (SPEED_MAX - SPEED_MIN)) / (CMD_MAX_VAL - CMD_START_VAL)
#else
#ifdef	CURRENTLOOP_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (IBUS_MAX  - IBUS_MIN))  / (CMD_MAX_VAL - CMD_START_VAL)
#endif
#endif
#ifdef	DUTY_CONTROL
#define	CMD_STEP						((unsigned long)1024 * (AMP_MAX   - AMP_MIN))   / (CMD_MAX_VAL - CMD_START_VAL)
#endif
#endif



// Over Voltage Protection
#define	dVDC_BUS_NORMAL_VALUE			(unsigned int)((unsigned long)dVDC_NORMAL_VOLTAGE        * (1024 + 0) / 5 * (float)dVIN_R2 / (float)(dVIN_R1 + dVIN_R2))
#define	dVDC_BUS_OV_VALUE				(unsigned int)((unsigned long)dVDC_OVER_VOLTAGE          * (1024 + 0) / 5 * (float)dVIN_R2 / (float)(dVIN_R1 + dVIN_R2))
#define	dVDC_BUS_LV_VALUE				(unsigned int)((unsigned long)dVDC_LOWER_VOLTAGE         * (1024 + 0) / 5 * (float)dVIN_R2 / (float)(dVIN_R1 + dVIN_R2))
#define	dVDC_BUS_OV_RESTART_VALUE		(unsigned int)((unsigned long)dVDC_OVER_VOLTAGE_RESTART  * (1024 + 0) / 5 * (float)dVIN_R2 / (float)(dVIN_R1 + dVIN_R2))
#define	dVDC_BUS_LV_RESTART_VALUE		(unsigned int)((unsigned long)dVDC_LOWER_VOLTAGE_RESTART * (1024 + 0) / 5 * (float)dVIN_R2 / (float)(dVIN_R1 + dVIN_R2))

// Over Temperature Protection
#define	dOTP_OV_VALUE					(unsigned int)((float)dOTP_OVER_TEMP             * (1024 + 0) / 5)
#define	dOTP_OV_RESTART_VALUE			(unsigned int)((float)dOTP_OVER_TEMP_RESTART     * (1024 + 0) / 5)
#define	dOTP_LM_VALUE					(unsigned int)((float)dOTP_LIMIT_TEMP            * (1024 + 0) / 5)
#define	dOTP_LM_RESTART_VALUE			(unsigned int)((float)dOTP_LIMIT_TEMP_RESTART    * (1024 + 0) / 5)
// 
#define	dAMP_PER_CONSTANT				(unsigned long)(((float)((float)dBUSSHUNT_R * dBUSOPA_GAIN * 1023) / 5.0) * (1 << IBUS_CONSTANT_SHIFT) * dBUS_COEFF)

// Poloe Numbers of the Rotor 
#ifdef	POLE_14
#define	dMOTOR_POLE						(14)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif
#ifdef	POLE_12
#define	dMOTOR_POLE						(12)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif
#ifdef	POLE_10
#define	dMOTOR_POLE						(10)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif
#ifdef	POLE_8
#define	dMOTOR_POLE						(8)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif
#ifdef	POLE_6
#define	dMOTOR_POLE						(6)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif
#ifdef	POLE_4
#define	dMOTOR_POLE						(4)
#define	dMOTOR_POLE_PAIRS				(dMOTOR_POLE >> 1)
#endif

// Hall Clock Selection
#ifdef	HCKS_1
#define	RPM_D							(unsigned long)(720000000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(144)												// (48000000 / 8) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE 
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 8) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_2
#define	RPM_D							(unsigned long)(360000000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(72)												// (48000000 / 16) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 16) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_3
#define	RPM_D							(unsigned long)(180000000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(36)												// (48000000 / 32) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 32) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_4
#define	RPM_D							(unsigned long)(90000000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(18)											// (48000000 / 64) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 64) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_5
#define	RPM_D							(unsigned long)(45000000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(9)												// (48000000 / 128) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 128) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_6
#define	RPM_D							(unsigned long)(22500000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(9)												// (48000000 / 256) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 256) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#ifdef	HCKS_7
#define	RPM_D							(unsigned long)(11250000 / dMOTOR_POLE)	// (((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE
#define	ROTOR60_DIVISOR					(unsigned int)(9)												// (48000000 / 512) / (24000000 / 96) * 6				// = 72 timer2 base on 24MHz / 96
#define	SPEED_3_TO_1_VAL				((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_3_TO_1
#define	SPEED_1_TO_3_VAL				((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_1_TO_3
#define	SPEED_LIMIT_VAL					((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_LIMIT
#define	SPEED_MIN_VAL					((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_MIN
#define	SPEED_MAX_VAL					((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_MAX
#define	SPEED_ERROR_RATE_VAL			((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_ERROR_RATE
#define	SPEED_BRAKE_VAL					((((unsigned long)48000000 / 512) * 60 * 2) / dMOTOR_POLE) / SPEED_BRAKE
#endif

#define	RESET							(0)
#define	SET								(1)


void IO_Init(void);
void Timer_Init(void);
void MOC_Init(void);
void Interrupt_Init(void);
void Speed_Estimation(void);

void PWM_CAPTURER(void);
void Motor_Stop(void);
void RST_PWM(void);
void Rotor_Lock_Strategy_2(unsigned int,unsigned int);
bit Rotor_Lock_Detection(bit,unsigned int);
bit Hall_Error_Status_Detection(bit,unsigned char,unsigned char,unsigned int);
void OVP_Function(void);
void OTP_Function(void);
void HallTable_Init(void);
void Angle_Shift_Compensation(void);

#endif