/**
  ******************************************************************************
 *
 * @file        Sample_CSC_EXTCK_Init.c
 *
 * @brief       CSC set CK_HS from CK_EXT sample code.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2024/04/19
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_CSC_EXTCK_Init(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       Sample CSC_EXTCK_Init
 * @details     1. CK_EXT IO Initial
 *      \n      2. CSC CK_HS Source From CK_EXT Sslect
 * @return	    None
 * @note        Cannot use the XOSC at the same time.
 * @par         Example
 * @code
    Sample_CSC_ECKI_SET();
 * @endcode
 *******************************************************************************
 */
 
void Sample_CSC_EXTCK_Init(void)
{
    /* 1. CK_EXT IO Initial */
    CSC_EXTCK_Cmd(ENABLE);
    
    UnProtectModuleReg(CSCprotect);                     // CSC register R/W protect disable
    /* 2. CSC CK_HS Source From CK_EXT Sslect */
    CSC_CK_HS_Select(HS_CK_EXT);
    
    /* 3. CSC_CK_HS STA Check */
    #if defined(CSC_STA_PLL_STA_mask_w)||defined(CSC_STA_IHRCO_STA_mask_w)||defined(CSC_STA_ILRCO_STA_mask_w)||defined(CSC_STA_XOSC_STA_mask_w)
        while(CSC_GetHsSwitchState(HS_MUX_CK_EXT) != DRV_Completed)
    #else
        __NOP();__NOP();__NOP();__NOP();__NOP();
    #endif
    
    /* 4. IHRCO Disable */
    /*
    // When the IHRCO is not in use, the IHRCO can be disable to save power.
    CSC_IHRCO_Cmd(DISABLE); 
    */
    CSC_IHRCO_Cmd(DISABLE); 
    
ProtectModuleReg(CSCprotect);                       // CSC register R/W protect enable
}
 
 
 
