#ifndef __LCD_H
#define __LCD_H		

#include "MG32_DRV.h"

//////////////////////////////////////////////////////////////////////////////////	 
//?祉?摨靘飛蝧蝙?剁??芰?雿迂?荔?銝??冽?嗅?隞颱??券?
//ALIENTEK?啗STM32???
//2.4撖?2.8撖?3.5撖?4.3撖?TFT瘨脫撽?	  
//?舀?撽?IC???:ILI9341/ILI9325/RM68042/RM68021/ILI9320/ILI9328/LGDP4531/LGDP4535/
//                  SPFD5408/SSD1289/1505/B505/C505/NT35310/NT35510蝑?	    
//甇????@ALIENTEK
//?銵?憯?www.openedv.com
//靽格?交?:2014/7/10
//?嚗2.6
//???????敹弦??
//Copyright(C) 撱??撣?蝧潮摮?????砍 2009-2019
//All rights reserved	
//********************************************************************************
//V1.2靽格隤芣?
//?舀?鈭PFD5408?????血??雯?貂D?湔??EX?澆?.?嫣噶?亦?LCD撽?IC.
//V1.3
//?鈭翰?O???
//靽格鈭???嗥?璆菜改??拍?墟1.8?誑敺???輻??穿?
//撠1.8?銋?(銝???.8)?雯?嗆芋憛?隢耨?過CD_Init?賣?CD_LED=1;?摔CD_LED=1;
//V1.4
//靽格鈭CD_ShowChar?賣嚗蝙?函暺??賜摮泵??
//?鈭帖鞊?憿舐內???
//V1.5 20110730
//1,靽格鈭505瘨脫霈憿?炊?ug.
//2,靽格鈭翰?O?帖鞊??身蝵格撘?
//V1.6 20111116
//1,?撠GDP4535瘨脫?????
//V1.7 20120713
//1,憓?LCD_RD_DATA?賣
//2,憓?撠LI9341???
//3,憓?ILI9325?蝡??誨蝣?
//4,憓?LCD_Scan_Dir?賣(??雿輻)	  
//6,?血?靽格鈭??靘??賣,隞仿??341??雿?
//V1.8 20120905
//1,?LCD???閮剔蔭蝯?擃cddev
//2,?LCD_Display_Dir?賣,?舀??函?璈怨?撅???
//V1.9 20120911
//1,?啣?RM68042撽?嚗D:6804嚗?雿6804銝?帖撅＊蝷綽?嚗????寡????孵?嚗?
//撠6804??閮剔蔭憭望?嚗岫??憭瘜銝?嚗?閫??
//V2.0 20120924
//?其?蝖砌辣閬???瘜?,ILI9341?D霈??鋡怨炊霈??300,靽格LCD_Init,撠瘜???
//??瘜?霈?衰D??300/??ID嚗?撘瑕??撽?IC?截LI9341嚗銵?341??憪???
//V2.1 20120930
//靽格迤ILI9325霈憿?ug??
//V2.2 20121007
//靽格迤LCD_Scan_Dir?ug??
//V2.3 20130120
//?啣?6804?舀?璈怠?憿舐內
//V2.4 20131120
//1,?啣?NT35310嚗D:5310嚗?????
//2,?啣?LCD_Set_Window?賣,?冽閮剔蔭蝒,撠翰?‵??瘥??,雿閰脣?詨璈怠???銝??804.
//V2.5 20140211
//1,?啣?NT35510嚗D:5510嚗?????
//V2.6 20140710
//1,靽格迤LCD_Scan_Dir璈怠??身蝵桃????孵?憿舐內銝?ug.
//////////////////////////////////////////////////////////////////////////////////	 


	 
//LCD?????
typedef struct  
{										    
	uint16_t    width;			//LCD 撖砍漲
	uint16_t    height;			//LCD 擃漲
	uint16_t    id;				//LCD ID
	uint8_t     dir;			//璈怠??鞊??批嚗?嚗?撅?1嚗帖撅?
	uint16_t    wramcmd;		//??撖剋ram?誘
	uint16_t    setxcmd;		//閮剔蔭x???誘
	uint16_t    setycmd;		//閮剔蔭y???誘	 
}_lcd_dev; 	  

//LCD?
extern _lcd_dev lcddev;	//蝞∠?LCD???
//LCD?蝑??脣????   
extern uint16_t  POINT_COLOR;//暺?蝝    
extern uint16_t  BACK_COLOR; //?憿.暺??箇??

////////////////////////////////////////////////////////////////////
//-----------------LCD蝡臬摰儔---------------- 
#define	LCD_LED PCout(10) 				//LCD?? 

#define __LCD_BackLight_On()    GPIOE->SC.B[1] = PX_SC_SET8_mask_b1;
#define __LCD_BackLight_Off()   GPIOE->SC.B[3] = PX_SC_CLR8_mask_b3;

#define __LCD_Reset_ENABLE()    GPIOE->SC.B[1] = PX_SC_SET8_mask_b1
#define __LCD_Reset_DISABLE()   GPIOE->SC.B[3] = PX_SC_CLR8_mask_b3

#define	__LCD_CS_SET()    EMB->CR1.W |= EMB_CR1_CE_SWO_mask_w     //?蝡臬
#define	__LCD_CS_CLR()    EMB->CR1.W &= ~EMB_CR1_CE_SWO_mask_w    //?蝡臬

#define	__LCD_RS_SET()    EMB->CR1.W |= EMB_CR1_BW0_SWO_mask_w    //?豢?/?賭誘	   
#define	__LCD_RS_CLR()    EMB->CR1.W &= ~EMB_CR1_BW0_SWO_mask_w   //?豢?/?賭誘	   

#define	__LCD_WR_SET()                                        //撖急??
#define	__LCD_WR_CLR()                                        //撖急??

#define	__LCD_RD_SET()                                        //霈?豢?
#define	__LCD_RD_CLR()                                        //霈?豢?

//PB0~15,雿?豢?蝺?
#define __DATAOUT(x) *(uint16_t *)0x60000000 = (x)            //?豢?頛詨
#define __DATAIN()   *(uint16_t *)0x60000000                  //?豢?頛詨		 
//////////////////////////////////////////////////////////////////////
//???孵?摰儔
#define L2R_U2D  0 //敺椰?啣,敺??唬?
#define L2R_D2U  1 //敺椰?啣,敺??唬?
#define R2L_U2D  2 //敺?啣椰,敺??唬?
#define R2L_D2U  3 //敺?啣椰,敺??唬?

#define U2D_L2R  4 //敺??唬?,敺椰?啣
#define U2D_R2L  5 //敺??唬?,敺?啣椰
#define D2U_L2R  6 //敺??唬?,敺椰?啣
#define D2U_R2L  7 //敺??唬?,敺?啣椰

#define DFT_SCAN_DIR  L2R_U2D  //暺??????
	 
//???孵?摰儔
#define L2R_U2D  0 //敺椰?啣,敺??唬?
#define L2R_D2U  1 //敺椰?啣,敺??唬?
#define R2L_U2D  2 //敺?啣椰,敺??唬?
#define R2L_D2U  3 //敺?啣椰,敺??唬?

#define U2D_L2R  4 //敺??唬?,敺椰?啣
#define U2D_R2L  5 //敺??唬?,敺?啣椰
#define D2U_L2R  6 //敺??唬?,敺椰?啣
#define D2U_R2L  7 //敺??唬?,敺?啣椰	 

#define DFT_SCAN_DIR  L2R_U2D  //暺??????

//?怎?憿
#define WHITE         	 0xFFFF
#define BLACK         	 0x0000

#define BLUE         	 0x001F  
#define BRED             0XF81F
#define GRED 			 0XFFE0
#define GBLUE			 0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define YELLOW        	 0xFFE0
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define BROWN 			 0XBC40 //璉
#define BRRED 			 0XFC07 //璉???
#define GRAY  			 0X8430 //?啗
//GUI憿

#define DARKBLUE      	 0X01CF	//瘛梯???
#define LIGHTBLUE      	 0X7D7C	//瘛箄??? 
#define GRAYBLUE       	 0X5458 //?啗???
//隞乩?銝?摺ANEL????
 
#define LIGHTGREEN     	 0X841F //瘛箇???
#define LGRAY 			 0XC618 //瘛箇??PANNEL),蝒????

#define LGRAYBLUE        0XA651 //瘛箇?(銝剝?撅日???
#define LBBLUE           0X2B12 //瘛箸??(?豢?璇????

void LCD_Init(void);													   	                //????
void LCD_DisplayOn(void);													                //?＊蝷?
void LCD_DisplayOff(void);													                //?＊蝷?
void LCD_Clear(uint16_t Color);	 												            //皜?
void LCD_ColorBar_1(void);
void LCD_ColorBar_2(void);
void LCD_GrayBar_1(void);
void LCD_SetCursor(uint16_t Xpos, uint16_t Ypos);                                           //閮剔蔭??
void LCD_DrawPoint(uint16_t x, uint16_t y, uint16_t Color);                                 //?恍?
void LCD_Fast_DrawPoint(uint16_t x, uint16_t y, uint16_t color);                            //敹恍暺?
uint16_t  LCD_ReadPoint(uint16_t x, uint16_t y);                                            //霈暺?
void LCD_Draw_Circle(uint16_t x0, uint16_t y0, uint8_t r, uint16_t Color);                  //?怠?
void LCD_DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);      //?怎?
void LCD_DrawRectangle(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color); //?怎敶?
void LCD_Fill(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t color);          //憛怠??株
void LCD_Color_Fill(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t *color);   //憛怠???憿
void LCD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint8_t mode, uint16_t Color); //憿舐內銝??蝚?
void LCD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint16_t Color);  //憿舐內銝?摮?
void LCD_ShowxNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint8_t mode, uint16_t Color);   //憿舐內 ?詨?
void LCD_ShowString(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint8_t size, uint8_t *p); //憿舐內銝??蝚虫葡,12/16摮?

void LCD_WriteReg(uint16_t LCD_Reg, uint16_t LCD_RegValue);
uint16_t LCD_ReadReg(uint16_t LCD_Reg);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteRAM(uint16_t RGB_Code);		  
void LCD_Scan_Dir(uint8_t dir);									//閮剔蔭撅????
void LCD_Display_Dir(uint8_t dir);								//閮剔蔭撅?憿舐內?孵?
void LCD_Set_Window(uint16_t sx,uint16_t sy, uint16_t width, uint16_t height);	//閮剔蔭蝒	

//撖急???
#define LCD_WR_DATA(data){\
    __LCD_CS_CLR();\
    __LCD_RS_SET();\
    __DATAOUT(data);\
    __LCD_WR_CLR();\
    __LCD_WR_SET();\
    __LCD_CS_SET();\
} 
 					   																			 
//9320/9325 LCD撖??? 
#define R0             0x00
#define R1             0x01
#define R2             0x02
#define R3             0x03
#define R4             0x04
#define R5             0x05
#define R6             0x06
#define R7             0x07
#define R8             0x08
#define R9             0x09
#define R10            0x0A
#define R12            0x0C
#define R13            0x0D
#define R14            0x0E
#define R15            0x0F
#define R16            0x10
#define R17            0x11
#define R18            0x12
#define R19            0x13
#define R20            0x14
#define R21            0x15
#define R22            0x16
#define R23            0x17
#define R24            0x18
#define R25            0x19
#define R26            0x1A
#define R27            0x1B
#define R28            0x1C
#define R29            0x1D
#define R30            0x1E
#define R31            0x1F
#define R32            0x20
#define R33            0x21
#define R34            0x22
#define R36            0x24
#define R37            0x25
#define R40            0x28
#define R41            0x29
#define R43            0x2B
#define R45            0x2D
#define R48            0x30
#define R49            0x31
#define R50            0x32
#define R51            0x33
#define R52            0x34
#define R53            0x35
#define R54            0x36
#define R55            0x37
#define R56            0x38
#define R57            0x39
#define R59            0x3B
#define R60            0x3C
#define R61            0x3D
#define R62            0x3E
#define R63            0x3F
#define R64            0x40
#define R65            0x41
#define R66            0x42
#define R67            0x43
#define R68            0x44
#define R69            0x45
#define R70            0x46
#define R71            0x47
#define R72            0x48
#define R73            0x49
#define R74            0x4A
#define R75            0x4B
#define R76            0x4C
#define R77            0x4D
#define R78            0x4E
#define R79            0x4F
#define R80            0x50
#define R81            0x51
#define R82            0x52
#define R83            0x53
#define R96            0x60
#define R97            0x61
#define R106           0x6A
#define R118           0x76
#define R128           0x80
#define R129           0x81
#define R130           0x82
#define R131           0x83
#define R132           0x84
#define R133           0x85
#define R134           0x86
#define R135           0x87
#define R136           0x88
#define R137           0x89
#define R139           0x8B
#define R140           0x8C
#define R141           0x8D
#define R143           0x8F
#define R144           0x90
#define R145           0x91
#define R146           0x92
#define R147           0x93
#define R148           0x94
#define R149           0x95
#define R150           0x96
#define R151           0x97
#define R152           0x98
#define R153           0x99
#define R154           0x9A
#define R157           0x9D
#define R192           0xC0
#define R193           0xC1
#define R229           0xE5							  		 
#endif













