/**
 ******************************************************************************
 *
 * @file        MG32_PW.h
 *
 * @brief       MG32 PW Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V3.92 (Register File Date : 2022_1109)
 * @date        2022/12/14 14:57 (H File Generated Date)
 * @author      HeadCodeGen V1.44
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_PW_H
#define _MG32_PW_H
#define _MG32_PW_H_VER                          392     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_PW_H_VER)
    #error "_MG32_PW_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      PW_Struct
 *              PW  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  PORF          :1;     //[1] Power-On reset status flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  BOD0F         :1;     //[4] BOD0 brown-out detection interrupt flag
                                        //0 = Normal : No event occurred and VDD is than high BOD0 threshold
                                        //1 = Happened : Event happened and VDD is  lower than BOD0 threshold
            __IO uint8_t  BOD1F         :1;     //[5] BOD1 brown-out detection interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  WKF           :1;     //[7] System received wakeup event flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (Event happened)
            __I  uint8_t                :8;     //[15..8] 
            __I  uint8_t  STATE         :2;     //[17..16] System operation power mode state
                                        //0x0 = ON
                                        //0x1 = SLEEP
                                        //0x2 = STOP
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[19..18] 
            __I  uint8_t  WKMODE        :2;     //[21..20] System wakeup from which power-down mode status.
                                        //0x0 = NONE : Never wakeup from power-down mode.
                                        //0x1 = SLEEP
                                        //0x2 = STOP
                                        //0x3 = Reserved
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t  BOD1_S        :1;     //[25] Brown-Out detect BOD1 status.
                                        //0 = High : VDD is high than BOD1 threshold
                                        //1 = Low : VDD is  lower than BOD1 threshold
            __I  uint8_t                :6;     //[31..26] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  PW status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] PW interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :3;     //[3..1] 
            __IO uint8_t  BOD0_IE       :1;     //[4] BOD0 brown-out detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD1_IE       :1;     //[5] BOD1 brown-out detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[6] 
            __IO uint8_t  WK_IE         :1;     //[7] System received wakeup event interrupt enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  PW interrupt enable register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t KEY           :16;    //[15..0] PW key register
                                        //0 = Unprotected
                                        //1 = Protected
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }KEY;                               /*!< KEY        ~ Offset[0x0C]  PW write protected Key register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  IVR_EN        :1;     //[1] Internal voltage reference source enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[2] 
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  BOD0_EN       :1;     //[4] BOD0 voltage detect enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BOD1_EN       :1;     //[5] BOD1 voltage detect enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  LDO_ON        :1;     //[6] Core voltage LDO mode select when ON or SLEEP mode.
                                        //0 = Normal
                                        //1 = Low power
            __IO uint8_t  LDO_STP       :1;     //[7] Core voltage LDO mode select when STOP mode. (default=1)
                                        //0 = Normal
                                        //1 = Low power
            __IO uint8_t  BOD1_TRGS     :2;     //[9..8] BOD1 Interrupt trigger selection.
                                        //0x0 = Reserved
                                        //0x1 = Rising edge
                                        //0x2 = Falling edge
                                        //0x3 = Dual-edge
            __IO uint8_t  BOD1_TH       :2;     //[11..10] BOD1 detect voltage threshold select
                                        //0x0 = 2.0v
                                        //0x1 = 2.4v
                                        //0x2 = 3.7v
                                        //0x3 = 4.2v
            __I  uint8_t                :4;     //[15..12] 
            __I  uint8_t                :2;     //[17..16] 
            __I  uint8_t                :2;     //[19..18] 
            __IO uint8_t  WKSTP_DSEL    :2;     //[21..20] Wakeup delay time selection from STOP mode
                                        //0x0 = DT0 (16~32us)
                                        //0x1 = DT1 (32~48us)
                                        //0x2 = DT2 (64~80us)
                                        //0x3 = DT3 (128~144us)
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :2;     //[25..24] 
            __I  uint8_t                :2;     //[27..26] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  PW control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __IO uint8_t  STP_POR       :1;     //[1] POR power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[3..2] 
            __IO uint8_t  STP_BOD0      :1;     //[4] BOD0 power-on configuration after enter STOP mode
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  STP_BOD1      :1;     //[5] BOD1 power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  SLP_CMP0      :1;     //[16] Analog comparator CMP0 power-on configuration after enter SLEEP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  SLP_CMP1      :1;     //[17] Analog comparator CMP1 power-on configuration after enter SLEEP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  SLP_CMP2      :1;     //[18] Analog comparator CMP2 power-on configuration after enter SLEEP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  SLP_CMP3      :1;     //[19] Analog comparator CMP3 power-on configuration after enter SLEEP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  STP_CMP0      :1;     //[20] Analog comparator CMP0 power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  STP_CMP1      :1;     //[21] Analog comparator CMP1 power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  STP_CMP2      :1;     //[22] Analog comparator CMP2 power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = power-on
            __IO uint8_t  STP_CMP3      :1;     //[23] Analog comparator CMP3 power-on configuration after enter STOP mode.
                                        //0 = Disable
                                        //1 = power-on
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  PW control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :4;     //[3..0] 
            __IO uint8_t  WKSTP_BOD0    :1;     //[4] BOD0 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_BOD1    :1;     //[5] BOD1 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  WKSTP_CMP0    :1;     //[16] Analog comparator CMP0 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_CMP1    :1;     //[17] Analog comparator CMP1 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_CMP2    :1;     //[18] Analog comparator CMP2 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_CMP3    :1;     //[19] Analog comparator CMP3 voltage detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }WKSTP0;                            /*!< WKSTP0     ~ Offset[0x18]  PW STOP mode wakeup control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :1;     //[0] 
            __I  uint8_t                :1;     //[1] 
            __I  uint8_t                :2;     //[3..2] 
            __I  uint8_t                :1;     //[4] 
            __IO uint8_t  WKSTP_RTC     :1;     //[5] RTC module events wakeup from STOP mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_IWDT    :1;     //[6] IWDT module events wakeup from STOP mode enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  WKSTP_I2C0    :1;     //[8] I2C0 slave address detection wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WKSTP_I2C1    :1;     //[9] I2C1 slave address detection event wakeup from STOP mode enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :6;     //[15..10] 
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :7;     //[30..24] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }WKSTP1;                            /*!< WKSTP1     ~ Offset[0x1C]  PW STOP mode wakeup control register 1 */

} PW_Struct;

/**
 ******************************************************************************
 *
 * @name        PW  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define PW_Base                         ((uint32_t)0x4C020000)              /*!< Power Management Controller */
#define PW                              ((PW_Struct*) PW_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        PW  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        PW_STA  [register's definitions]
 *              Offset[0x00]  PW status register (0x4C020000)
 ******************************************************************************
 */
///@{
#define PW_STA_default                              ((uint32_t)0x00000002)  /*!< Reg Reset Default Value */

/* Bit fields of PW_STA */
#define PW_STA_BOD1_S_mask_w                        ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define PW_STA_BOD1_S_mask_h1                       ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PW_STA_BOD1_S_mask_b3                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_STA_BOD1_S_high_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):High of 32bit */
#define PW_STA_BOD1_S_high_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):High of 16bit */
#define PW_STA_BOD1_S_high_b3                       ((uint8_t )0x00)        /*!< Bit Value =(0):High of 8bit */
#define PW_STA_BOD1_S_low_w                         ((uint32_t)0x02000000)  /*!< Bit Value =(1):Low of 32bit */
#define PW_STA_BOD1_S_low_h1                        ((uint16_t)0x0200)      /*!< Bit Value =(1):Low of 16bit */
#define PW_STA_BOD1_S_low_b3                        ((uint8_t )0x02)        /*!< Bit Value =(1):Low of 8bit */

#define PW_STA_WKMODE_mask_w                        ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define PW_STA_WKMODE_mask_h1                       ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define PW_STA_WKMODE_mask_b2                       ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define PW_STA_WKMODE_none_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):NONE of 32bit */
#define PW_STA_WKMODE_none_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0x0):NONE of 16bit */
#define PW_STA_WKMODE_none_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0x0):NONE of 8bit */
#define PW_STA_WKMODE_sleep_w                       ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):SLEEP of 32bit */
#define PW_STA_WKMODE_sleep_h1                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):SLEEP of 16bit */
#define PW_STA_WKMODE_sleep_b2                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):SLEEP of 8bit */
#define PW_STA_WKMODE_stop_w                        ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):STOP of 32bit */
#define PW_STA_WKMODE_stop_h1                       ((uint16_t)0x0020)      /*!< Bit Value =(0x2):STOP of 16bit */
#define PW_STA_WKMODE_stop_b2                       ((uint8_t )0x20)        /*!< Bit Value =(0x2):STOP of 8bit */

#define PW_STA_STATE_mask_w                         ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define PW_STA_STATE_mask_h1                        ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define PW_STA_STATE_mask_b2                        ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define PW_STA_STATE_on_w                           ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ON of 32bit */
#define PW_STA_STATE_on_h1                          ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ON of 16bit */
#define PW_STA_STATE_on_b2                          ((uint8_t )0x00)        /*!< Bit Value =(0x0):ON of 8bit */
#define PW_STA_STATE_sleep_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):SLEEP of 32bit */
#define PW_STA_STATE_sleep_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):SLEEP of 16bit */
#define PW_STA_STATE_sleep_b2                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):SLEEP of 8bit */
#define PW_STA_STATE_stop_w                         ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):STOP of 32bit */
#define PW_STA_STATE_stop_h1                        ((uint16_t)0x0002)      /*!< Bit Value =(0x2):STOP of 16bit */
#define PW_STA_STATE_stop_b2                        ((uint8_t )0x02)        /*!< Bit Value =(0x2):STOP of 8bit */

#define PW_STA_WKF_mask_w                           ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PW_STA_WKF_mask_h0                          ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PW_STA_WKF_mask_b0                          ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PW_STA_WKF_normal_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_STA_WKF_normal_h0                        ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_STA_WKF_normal_b0                        ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_STA_WKF_happened_w                       ((uint32_t)0x00000080)  /*!< Bit Value =(1):Happened of 32bit */
#define PW_STA_WKF_happened_h0                      ((uint16_t)0x0080)      /*!< Bit Value =(1):Happened of 16bit */
#define PW_STA_WKF_happened_b0                      ((uint8_t )0x80)        /*!< Bit Value =(1):Happened of 8bit */

#define PW_STA_BOD1F_mask_w                         ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_STA_BOD1F_mask_h0                        ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_STA_BOD1F_mask_b0                        ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_STA_BOD1F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_STA_BOD1F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_STA_BOD1F_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_STA_BOD1F_happened_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Happened of 32bit */
#define PW_STA_BOD1F_happened_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Happened of 16bit */
#define PW_STA_BOD1F_happened_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Happened of 8bit */

#define PW_STA_BOD0F_mask_w                         ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PW_STA_BOD0F_mask_h0                        ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_STA_BOD0F_mask_b0                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_STA_BOD0F_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_STA_BOD0F_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_STA_BOD0F_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_STA_BOD0F_happened_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Happened of 32bit */
#define PW_STA_BOD0F_happened_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Happened of 16bit */
#define PW_STA_BOD0F_happened_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Happened of 8bit */

#define PW_STA_PORF_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PW_STA_PORF_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PW_STA_PORF_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_STA_PORF_normal_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_STA_PORF_normal_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_STA_PORF_normal_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_STA_PORF_happened_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define PW_STA_PORF_happened_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define PW_STA_PORF_happened_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_INT  [register's definitions]
 *              Offset[0x04]  PW interrupt enable register (0x4C020004)
 ******************************************************************************
 */
///@{
#define PW_INT_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PW_INT */
#define PW_INT_WK_IE_mask_w                         ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PW_INT_WK_IE_mask_h0                        ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PW_INT_WK_IE_mask_b0                        ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PW_INT_WK_IE_disable_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_INT_WK_IE_disable_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_INT_WK_IE_disable_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_INT_WK_IE_enable_w                       ((uint32_t)0x00000080)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_INT_WK_IE_enable_h0                      ((uint16_t)0x0080)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_INT_WK_IE_enable_b0                      ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_INT_BOD1_IE_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_INT_BOD1_IE_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_INT_BOD1_IE_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_INT_BOD1_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_INT_BOD1_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_INT_BOD1_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_INT_BOD1_IE_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_INT_BOD1_IE_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_INT_BOD1_IE_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_INT_BOD0_IE_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PW_INT_BOD0_IE_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_INT_BOD0_IE_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_INT_BOD0_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_INT_BOD0_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_INT_BOD0_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_INT_BOD0_IE_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_INT_BOD0_IE_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_INT_BOD0_IE_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_INT_IEA_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define PW_INT_IEA_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PW_INT_IEA_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define PW_INT_IEA_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_INT_IEA_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_INT_IEA_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_INT_IEA_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_INT_IEA_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_INT_IEA_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_KEY  [register's definitions]
 *              Offset[0x0C]  PW write protected Key register (0x4C02000C)
 ******************************************************************************
 */
///@{
#define PW_KEY_default                              ((uint32_t)0x00000001)  /*!< Reg Reset Default Value */

/* Bit fields of PW_KEY */
#define PW_KEY_KEY_mask_w                           ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define PW_KEY_KEY_mask_h0                          ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define PW_KEY_KEY_unprotected_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Unprotected of 32bit */
#define PW_KEY_KEY_unprotected_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Unprotected of 16bit */
#define PW_KEY_KEY_unprotected_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Unprotected of 8bit */
#define PW_KEY_KEY_protected_w                      ((uint32_t)0x00000001)  /*!< Bit Value =(1):Protected of 32bit */
#define PW_KEY_KEY_protected_h0                     ((uint16_t)0x0001)      /*!< Bit Value =(1):Protected of 16bit */
#define PW_KEY_KEY_protected_b0                     ((uint8_t )0x01)        /*!< Bit Value =(1):Protected of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_CR0  [register's definitions]
 *              Offset[0x10]  PW control register 0 (0x4C020010)
 ******************************************************************************
 */
///@{
#define PW_CR0_default                              ((uint32_t)0x00000080)  /*!< Reg Reset Default Value */

/* Bit fields of PW_CR0 */
#define PW_CR0_WKSTP_DSEL_mask_w                    ((uint32_t)0x00300000)  /*!< Bit Mask of 32bit */
#define PW_CR0_WKSTP_DSEL_mask_h1                   ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define PW_CR0_WKSTP_DSEL_mask_b2                   ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define PW_CR0_WKSTP_DSEL_dt0_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):DT0 of 32bit */
#define PW_CR0_WKSTP_DSEL_dt0_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):DT0 of 16bit */
#define PW_CR0_WKSTP_DSEL_dt0_b2                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):DT0 of 8bit */
#define PW_CR0_WKSTP_DSEL_dt1_w                     ((uint32_t)0x00100000)  /*!< Bit Value =(0x1):DT1 of 32bit */
#define PW_CR0_WKSTP_DSEL_dt1_h1                    ((uint16_t)0x0010)      /*!< Bit Value =(0x1):DT1 of 16bit */
#define PW_CR0_WKSTP_DSEL_dt1_b2                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):DT1 of 8bit */
#define PW_CR0_WKSTP_DSEL_dt2_w                     ((uint32_t)0x00200000)  /*!< Bit Value =(0x2):DT2 of 32bit */
#define PW_CR0_WKSTP_DSEL_dt2_h1                    ((uint16_t)0x0020)      /*!< Bit Value =(0x2):DT2 of 16bit */
#define PW_CR0_WKSTP_DSEL_dt2_b2                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):DT2 of 8bit */
#define PW_CR0_WKSTP_DSEL_dt3_w                     ((uint32_t)0x00300000)  /*!< Bit Value =(0x3):DT3 of 32bit */
#define PW_CR0_WKSTP_DSEL_dt3_h1                    ((uint16_t)0x0030)      /*!< Bit Value =(0x3):DT3 of 16bit */
#define PW_CR0_WKSTP_DSEL_dt3_b2                    ((uint8_t )0x30)        /*!< Bit Value =(0x3):DT3 of 8bit */

#define PW_CR0_BOD1_TH_mask_w                       ((uint32_t)0x00000C00)  /*!< Bit Mask of 32bit */
#define PW_CR0_BOD1_TH_mask_h0                      ((uint16_t)0x0C00)      /*!< Bit Mask of 16bit */
#define PW_CR0_BOD1_TH_mask_b1                      ((uint8_t )0x0C)        /*!< Bit Mask of 8bit */
#define PW_CR0_BOD1_TH_2_0v_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):2.0v of 32bit */
#define PW_CR0_BOD1_TH_2_0v_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):2.0v of 16bit */
#define PW_CR0_BOD1_TH_2_0v_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):2.0v of 8bit */
#define PW_CR0_BOD1_TH_2_4v_w                       ((uint32_t)0x00000400)  /*!< Bit Value =(0x1):2.4v of 32bit */
#define PW_CR0_BOD1_TH_2_4v_h0                      ((uint16_t)0x0400)      /*!< Bit Value =(0x1):2.4v of 16bit */
#define PW_CR0_BOD1_TH_2_4v_b1                      ((uint8_t )0x04)        /*!< Bit Value =(0x1):2.4v of 8bit */
#define PW_CR0_BOD1_TH_3_7v_w                       ((uint32_t)0x00000800)  /*!< Bit Value =(0x2):3.7v of 32bit */
#define PW_CR0_BOD1_TH_3_7v_h0                      ((uint16_t)0x0800)      /*!< Bit Value =(0x2):3.7v of 16bit */
#define PW_CR0_BOD1_TH_3_7v_b1                      ((uint8_t )0x08)        /*!< Bit Value =(0x2):3.7v of 8bit */
#define PW_CR0_BOD1_TH_4_2v_w                       ((uint32_t)0x00000C00)  /*!< Bit Value =(0x3):4.2v of 32bit */
#define PW_CR0_BOD1_TH_4_2v_h0                      ((uint16_t)0x0C00)      /*!< Bit Value =(0x3):4.2v of 16bit */
#define PW_CR0_BOD1_TH_4_2v_b1                      ((uint8_t )0x0C)        /*!< Bit Value =(0x3):4.2v of 8bit */

#define PW_CR0_BOD1_TRGS_mask_w                     ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define PW_CR0_BOD1_TRGS_mask_h0                    ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define PW_CR0_BOD1_TRGS_mask_b1                    ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define PW_CR0_BOD1_TRGS_rising_edge_w              ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Rising edge of 32bit */
#define PW_CR0_BOD1_TRGS_rising_edge_h0             ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Rising edge of 16bit */
#define PW_CR0_BOD1_TRGS_rising_edge_b1             ((uint8_t )0x01)        /*!< Bit Value =(0x1):Rising edge of 8bit */
#define PW_CR0_BOD1_TRGS_falling_edge_w             ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Falling edge of 32bit */
#define PW_CR0_BOD1_TRGS_falling_edge_h0            ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Falling edge of 16bit */
#define PW_CR0_BOD1_TRGS_falling_edge_b1            ((uint8_t )0x02)        /*!< Bit Value =(0x2):Falling edge of 8bit */
#define PW_CR0_BOD1_TRGS_dual_edge_w                ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Dual-edge of 32bit */
#define PW_CR0_BOD1_TRGS_dual_edge_h0               ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Dual-edge of 16bit */
#define PW_CR0_BOD1_TRGS_dual_edge_b1               ((uint8_t )0x03)        /*!< Bit Value =(0x3):Dual-edge of 8bit */

#define PW_CR0_LDO_STP_mask_w                       ((uint32_t)0x00000080)  /*!< Bit Mask of 32bit */
#define PW_CR0_LDO_STP_mask_h0                      ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PW_CR0_LDO_STP_mask_b0                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PW_CR0_LDO_STP_normal_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_CR0_LDO_STP_normal_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_CR0_LDO_STP_normal_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_CR0_LDO_STP_low_power_w                  ((uint32_t)0x00000080)  /*!< Bit Value =(1):Low power of 32bit */
#define PW_CR0_LDO_STP_low_power_h0                 ((uint16_t)0x0080)      /*!< Bit Value =(1):Low power of 16bit */
#define PW_CR0_LDO_STP_low_power_b0                 ((uint8_t )0x80)        /*!< Bit Value =(1):Low power of 8bit */

#define PW_CR0_LDO_ON_mask_w                        ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define PW_CR0_LDO_ON_mask_h0                       ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PW_CR0_LDO_ON_mask_b0                       ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define PW_CR0_LDO_ON_normal_w                      ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define PW_CR0_LDO_ON_normal_h0                     ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define PW_CR0_LDO_ON_normal_b0                     ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define PW_CR0_LDO_ON_low_power_w                   ((uint32_t)0x00000040)  /*!< Bit Value =(1):Low power of 32bit */
#define PW_CR0_LDO_ON_low_power_h0                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Low power of 16bit */
#define PW_CR0_LDO_ON_low_power_b0                  ((uint8_t )0x40)        /*!< Bit Value =(1):Low power of 8bit */

#define PW_CR0_BOD1_EN_mask_w                       ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_CR0_BOD1_EN_mask_h0                      ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_CR0_BOD1_EN_mask_b0                      ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_CR0_BOD1_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR0_BOD1_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR0_BOD1_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR0_BOD1_EN_enable_w                     ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR0_BOD1_EN_enable_h0                    ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR0_BOD1_EN_enable_b0                    ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_CR0_BOD0_EN_mask_w                       ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PW_CR0_BOD0_EN_mask_h0                      ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_CR0_BOD0_EN_mask_b0                      ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_CR0_BOD0_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR0_BOD0_EN_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR0_BOD0_EN_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR0_BOD0_EN_enable_w                     ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR0_BOD0_EN_enable_h0                    ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR0_BOD0_EN_enable_b0                    ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_CR0_IVR_EN_mask_w                        ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PW_CR0_IVR_EN_mask_h0                       ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PW_CR0_IVR_EN_mask_b0                       ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_CR0_IVR_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR0_IVR_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR0_IVR_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR0_IVR_EN_enable_w                      ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR0_IVR_EN_enable_h0                     ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR0_IVR_EN_enable_b0                     ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_CR1  [register's definitions]
 *              Offset[0x14]  PW control register 1 (0x4C020014)
 ******************************************************************************
 */
///@{
#define PW_CR1_default                              ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PW_CR1 */
#define PW_CR1_STP_CMP3_mask_w                      ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_CMP3_mask_h1                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_CMP3_mask_b2                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_CMP3_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_CMP3_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_CMP3_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_CMP3_power_on_w                  ((uint32_t)0x00800000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_STP_CMP3_power_on_h1                 ((uint16_t)0x0080)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_STP_CMP3_power_on_b2                 ((uint8_t )0x80)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_STP_CMP2_mask_w                      ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_CMP2_mask_h1                     ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_CMP2_mask_b2                     ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_CMP2_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_CMP2_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_CMP2_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_CMP2_power_on_w                  ((uint32_t)0x00400000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_STP_CMP2_power_on_h1                 ((uint16_t)0x0040)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_STP_CMP2_power_on_b2                 ((uint8_t )0x40)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_STP_CMP1_mask_w                      ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_CMP1_mask_h1                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_CMP1_mask_b2                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_CMP1_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_CMP1_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_CMP1_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_CMP1_power_on_w                  ((uint32_t)0x00200000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_STP_CMP1_power_on_h1                 ((uint16_t)0x0020)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_STP_CMP1_power_on_b2                 ((uint8_t )0x20)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_STP_CMP0_mask_w                      ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_CMP0_mask_h1                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_CMP0_mask_b2                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_CMP0_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_CMP0_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_CMP0_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_CMP0_power_on_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_STP_CMP0_power_on_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_STP_CMP0_power_on_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_SLP_CMP3_mask_w                      ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define PW_CR1_SLP_CMP3_mask_h1                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PW_CR1_SLP_CMP3_mask_b2                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define PW_CR1_SLP_CMP3_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_SLP_CMP3_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_SLP_CMP3_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_SLP_CMP3_power_on_w                  ((uint32_t)0x00080000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_SLP_CMP3_power_on_h1                 ((uint16_t)0x0008)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_SLP_CMP3_power_on_b2                 ((uint8_t )0x08)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_SLP_CMP2_mask_w                      ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define PW_CR1_SLP_CMP2_mask_h1                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PW_CR1_SLP_CMP2_mask_b2                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define PW_CR1_SLP_CMP2_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_SLP_CMP2_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_SLP_CMP2_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_SLP_CMP2_power_on_w                  ((uint32_t)0x00040000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_SLP_CMP2_power_on_h1                 ((uint16_t)0x0004)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_SLP_CMP2_power_on_b2                 ((uint8_t )0x04)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_SLP_CMP1_mask_w                      ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define PW_CR1_SLP_CMP1_mask_h1                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PW_CR1_SLP_CMP1_mask_b2                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_CR1_SLP_CMP1_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_SLP_CMP1_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_SLP_CMP1_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_SLP_CMP1_power_on_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_SLP_CMP1_power_on_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_SLP_CMP1_power_on_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_SLP_CMP0_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PW_CR1_SLP_CMP0_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PW_CR1_SLP_CMP0_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define PW_CR1_SLP_CMP0_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_SLP_CMP0_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_SLP_CMP0_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_SLP_CMP0_power_on_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):power-on of 32bit */
#define PW_CR1_SLP_CMP0_power_on_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):power-on of 16bit */
#define PW_CR1_SLP_CMP0_power_on_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):power-on of 8bit */

#define PW_CR1_STP_BOD1_mask_w                      ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_BOD1_mask_h0                     ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_BOD1_mask_b0                     ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_BOD1_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_BOD1_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_BOD1_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_BOD1_enable_w                    ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR1_STP_BOD1_enable_h0                   ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR1_STP_BOD1_enable_b0                   ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_CR1_STP_BOD0_mask_w                      ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_BOD0_mask_h0                     ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_BOD0_mask_b0                     ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_BOD0_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_BOD0_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_BOD0_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_BOD0_enable_w                    ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR1_STP_BOD0_enable_h0                   ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR1_STP_BOD0_enable_b0                   ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_CR1_STP_POR_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define PW_CR1_STP_POR_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PW_CR1_STP_POR_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_CR1_STP_POR_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_CR1_STP_POR_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_CR1_STP_POR_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_CR1_STP_POR_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_CR1_STP_POR_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_CR1_STP_POR_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP0  [register's definitions]
 *              Offset[0x18]  PW STOP mode wakeup control register 0 (0x4C020018)
 ******************************************************************************
 */
///@{
#define PW_WKSTP0_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PW_WKSTP0 */
#define PW_WKSTP0_WKSTP_CMP3_mask_w                 ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_CMP3_mask_h1                ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_CMP3_mask_b2                ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_CMP3_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_CMP3_disable_h1             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_CMP3_disable_b2             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_CMP3_enable_w               ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_CMP3_enable_h1              ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_CMP3_enable_b2              ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP0_WKSTP_CMP2_mask_w                 ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_CMP2_mask_h1                ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_CMP2_mask_b2                ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_CMP2_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_CMP2_disable_h1             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_CMP2_disable_b2             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_CMP2_enable_w               ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_CMP2_enable_h1              ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_CMP2_enable_b2              ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP0_WKSTP_CMP1_mask_w                 ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_CMP1_mask_h1                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_CMP1_mask_b2                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_CMP1_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_CMP1_disable_h1             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_CMP1_disable_b2             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_CMP1_enable_w               ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_CMP1_enable_h1              ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_CMP1_enable_b2              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP0_WKSTP_CMP0_mask_w                 ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_CMP0_mask_h1                ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_CMP0_mask_b2                ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_CMP0_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_CMP0_disable_h1             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_CMP0_disable_b2             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_CMP0_enable_w               ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_CMP0_enable_h1              ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_CMP0_enable_b2              ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP0_WKSTP_BOD1_mask_w                 ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_BOD1_mask_h0                ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_BOD1_mask_b0                ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_BOD1_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_BOD1_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_BOD1_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_BOD1_enable_w               ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_BOD1_enable_h0              ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_BOD1_enable_b0              ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP0_WKSTP_BOD0_mask_w                 ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define PW_WKSTP0_WKSTP_BOD0_mask_h0                ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define PW_WKSTP0_WKSTP_BOD0_mask_b0                ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define PW_WKSTP0_WKSTP_BOD0_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP0_WKSTP_BOD0_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP0_WKSTP_BOD0_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP0_WKSTP_BOD0_enable_w               ((uint32_t)0x00000010)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP0_WKSTP_BOD0_enable_h0              ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP0_WKSTP_BOD0_enable_b0              ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP1  [register's definitions]
 *              Offset[0x1C]  PW STOP mode wakeup control register 1 (0x4C02001C)
 ******************************************************************************
 */
///@{
#define PW_WKSTP1_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of PW_WKSTP1 */
#define PW_WKSTP1_WKSTP_I2C1_mask_w                 ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define PW_WKSTP1_WKSTP_I2C1_mask_h0                ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define PW_WKSTP1_WKSTP_I2C1_mask_b1                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define PW_WKSTP1_WKSTP_I2C1_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP1_WKSTP_I2C1_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP1_WKSTP_I2C1_disable_b1             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP1_WKSTP_I2C1_enable_w               ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP1_WKSTP_I2C1_enable_h0              ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP1_WKSTP_I2C1_enable_b1              ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP1_WKSTP_I2C0_mask_w                 ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define PW_WKSTP1_WKSTP_I2C0_mask_h0                ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define PW_WKSTP1_WKSTP_I2C0_mask_b1                ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define PW_WKSTP1_WKSTP_I2C0_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP1_WKSTP_I2C0_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP1_WKSTP_I2C0_disable_b1             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP1_WKSTP_I2C0_enable_w               ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP1_WKSTP_I2C0_enable_h0              ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP1_WKSTP_I2C0_enable_b1              ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP1_WKSTP_IWDT_mask_w                 ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define PW_WKSTP1_WKSTP_IWDT_mask_h0                ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define PW_WKSTP1_WKSTP_IWDT_mask_b0                ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define PW_WKSTP1_WKSTP_IWDT_disable_w              ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP1_WKSTP_IWDT_disable_h0             ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP1_WKSTP_IWDT_disable_b0             ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP1_WKSTP_IWDT_enable_w               ((uint32_t)0x00000040)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP1_WKSTP_IWDT_enable_h0              ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP1_WKSTP_IWDT_enable_b0              ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define PW_WKSTP1_WKSTP_RTC_mask_w                  ((uint32_t)0x00000020)  /*!< Bit Mask of 32bit */
#define PW_WKSTP1_WKSTP_RTC_mask_h0                 ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define PW_WKSTP1_WKSTP_RTC_mask_b0                 ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define PW_WKSTP1_WKSTP_RTC_disable_w               ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define PW_WKSTP1_WKSTP_RTC_disable_h0              ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define PW_WKSTP1_WKSTP_RTC_disable_b0              ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define PW_WKSTP1_WKSTP_RTC_enable_w                ((uint32_t)0x00000020)  /*!< Bit Value =(1):Enable of 32bit */
#define PW_WKSTP1_WKSTP_RTC_enable_h0               ((uint16_t)0x0020)      /*!< Bit Value =(1):Enable of 16bit */
#define PW_WKSTP1_WKSTP_RTC_enable_b0               ((uint8_t )0x20)        /*!< Bit Value =(1):Enable of 8bit */

///@}

#endif  // _MG32_PW_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32_PW.h                          */
/*----------------------------------------------------------------------------*/
