/**
 ******************************************************************************
 *
 * @file        MG32__RegPointer.h
 *
 * @brief       MG32 Register Address Pointer Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V3.92 (Register File Date : 2022_1109)
 * @date        2022/12/14 14:57 (H File Generated Date)
 * @author      HeadCodeGen V1.44
 * @copyright   Copyright (c) 2022 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32__RegPointer_H
#define _MG32__RegPointer_H
#define _MG32__RegPointer_H_VER                 392     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32__RegPointer_H_VER)
    #error "_MG32__RegPointer_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @name        [Register Address Pointer Definitions]
 *
 ******************************************************************************
 */

/*----------------------------------------------------------------------------*/
/* @module      IOP (GPIO Input/Output Register Control Definitions)          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PX_OUT  [register's definitions]
 *              Offset[0x00]  PX output data register (0x41000000)
 ******************************************************************************
 */
///@{
#define PA_OUT                                      GPIOA->OUT.W                    /*!< Offset[0x00]  PA output data register (0x41000000) */
#define PB_OUT                                      GPIOB->OUT.W                    /*!< Offset[0x00]  PB output data register (0x41000020) */
#define PC_OUT                                      GPIOC->OUT.W                    /*!< Offset[0x00]  PC output data register (0x41000040) */
#define PD_OUT                                      GPIOD->OUT.W                    /*!< Offset[0x00]  PD output data register (0x41000060) */
#define PE_OUT                                      GPIOE->OUT.W                    /*!< Offset[0x00]  PE output data register (0x41000080) */

/* Bit fields of PX_OUT */
#define PA_OUT_OUT15                                GPIOA->OUT.MBIT.OUT15           //[15] IO pin PA15 output data bit. 
#define PB_OUT_OUT15                                GPIOB->OUT.MBIT.OUT15           //[15] IO pin PB15 output data bit. 
#define PC_OUT_OUT15                                GPIOC->OUT.MBIT.OUT15           //[15] IO pin PC15 output data bit. 
#define PD_OUT_OUT15                                GPIOD->OUT.MBIT.OUT15           //[15] IO pin PD15 output data bit. 
#define PE_OUT_OUT15                                GPIOE->OUT.MBIT.OUT15           //[15] IO pin PE15 output data bit. 

#define PA_OUT_OUT14                                GPIOA->OUT.MBIT.OUT14           //[14] IO pin PA14 output data bit. 
#define PB_OUT_OUT14                                GPIOB->OUT.MBIT.OUT14           //[14] IO pin PB14 output data bit. 
#define PC_OUT_OUT14                                GPIOC->OUT.MBIT.OUT14           //[14] IO pin PC14 output data bit. 
#define PD_OUT_OUT14                                GPIOD->OUT.MBIT.OUT14           //[14] IO pin PD14 output data bit. 
#define PE_OUT_OUT14                                GPIOE->OUT.MBIT.OUT14           //[14] IO pin PE14 output data bit. 

#define PA_OUT_OUT13                                GPIOA->OUT.MBIT.OUT13           //[13] IO pin PA13 output data bit. 
#define PB_OUT_OUT13                                GPIOB->OUT.MBIT.OUT13           //[13] IO pin PB13 output data bit. 
#define PC_OUT_OUT13                                GPIOC->OUT.MBIT.OUT13           //[13] IO pin PC13 output data bit. 
#define PD_OUT_OUT13                                GPIOD->OUT.MBIT.OUT13           //[13] IO pin PD13 output data bit. 
#define PE_OUT_OUT13                                GPIOE->OUT.MBIT.OUT13           //[13] IO pin PE13 output data bit. 

#define PA_OUT_OUT12                                GPIOA->OUT.MBIT.OUT12           //[12] IO pin PA12 output data bit. 
#define PB_OUT_OUT12                                GPIOB->OUT.MBIT.OUT12           //[12] IO pin PB12 output data bit. 
#define PC_OUT_OUT12                                GPIOC->OUT.MBIT.OUT12           //[12] IO pin PC12 output data bit. 
#define PD_OUT_OUT12                                GPIOD->OUT.MBIT.OUT12           //[12] IO pin PD12 output data bit. 
#define PE_OUT_OUT12                                GPIOE->OUT.MBIT.OUT12           //[12] IO pin PE12 output data bit. 

#define PA_OUT_OUT11                                GPIOA->OUT.MBIT.OUT11           //[11] IO pin PA11 output data bit. 
#define PB_OUT_OUT11                                GPIOB->OUT.MBIT.OUT11           //[11] IO pin PB11 output data bit. 
#define PC_OUT_OUT11                                GPIOC->OUT.MBIT.OUT11           //[11] IO pin PC11 output data bit. 
#define PD_OUT_OUT11                                GPIOD->OUT.MBIT.OUT11           //[11] IO pin PD11 output data bit. 
#define PE_OUT_OUT11                                GPIOE->OUT.MBIT.OUT11           //[11] IO pin PE11 output data bit. 

#define PA_OUT_OUT10                                GPIOA->OUT.MBIT.OUT10           //[10] IO pin PA10 output data bit. 
#define PB_OUT_OUT10                                GPIOB->OUT.MBIT.OUT10           //[10] IO pin PB10 output data bit. 
#define PC_OUT_OUT10                                GPIOC->OUT.MBIT.OUT10           //[10] IO pin PC10 output data bit. 
#define PD_OUT_OUT10                                GPIOD->OUT.MBIT.OUT10           //[10] IO pin PD10 output data bit. 
#define PE_OUT_OUT10                                GPIOE->OUT.MBIT.OUT10           //[10] IO pin PE10 output data bit. 

#define PA_OUT_OUT9                                 GPIOA->OUT.MBIT.OUT9            //[9] IO pin PA9 output data bit. 
#define PB_OUT_OUT9                                 GPIOB->OUT.MBIT.OUT9            //[9] IO pin PB9 output data bit. 
#define PC_OUT_OUT9                                 GPIOC->OUT.MBIT.OUT9            //[9] IO pin PC9 output data bit. 
#define PD_OUT_OUT9                                 GPIOD->OUT.MBIT.OUT9            //[9] IO pin PD9 output data bit. 
#define PE_OUT_OUT9                                 GPIOE->OUT.MBIT.OUT9            //[9] IO pin PE9 output data bit. 

#define PA_OUT_OUT8                                 GPIOA->OUT.MBIT.OUT8            //[8] IO pin PA8 output data bit. 
#define PB_OUT_OUT8                                 GPIOB->OUT.MBIT.OUT8            //[8] IO pin PB8 output data bit. 
#define PC_OUT_OUT8                                 GPIOC->OUT.MBIT.OUT8            //[8] IO pin PC8 output data bit. 
#define PD_OUT_OUT8                                 GPIOD->OUT.MBIT.OUT8            //[8] IO pin PD8 output data bit. 
#define PE_OUT_OUT8                                 GPIOE->OUT.MBIT.OUT8            //[8] IO pin PE8 output data bit. 

#define PA_OUT_OUT7                                 GPIOA->OUT.MBIT.OUT7            //[7] IO pin PA7 output data bit. 
#define PB_OUT_OUT7                                 GPIOB->OUT.MBIT.OUT7            //[7] IO pin PB7 output data bit. 
#define PC_OUT_OUT7                                 GPIOC->OUT.MBIT.OUT7            //[7] IO pin PC7 output data bit. 
#define PD_OUT_OUT7                                 GPIOD->OUT.MBIT.OUT7            //[7] IO pin PD7 output data bit. 
#define PE_OUT_OUT7                                 GPIOE->OUT.MBIT.OUT7            //[7] IO pin PE7 output data bit. 

#define PA_OUT_OUT6                                 GPIOA->OUT.MBIT.OUT6            //[6] IO pin PA6 output data bit. 
#define PB_OUT_OUT6                                 GPIOB->OUT.MBIT.OUT6            //[6] IO pin PB6 output data bit. 
#define PC_OUT_OUT6                                 GPIOC->OUT.MBIT.OUT6            //[6] IO pin PC6 output data bit. 
#define PD_OUT_OUT6                                 GPIOD->OUT.MBIT.OUT6            //[6] IO pin PD6 output data bit. 
#define PE_OUT_OUT6                                 GPIOE->OUT.MBIT.OUT6            //[6] IO pin PE6 output data bit. 

#define PA_OUT_OUT5                                 GPIOA->OUT.MBIT.OUT5            //[5] IO pin PA5 output data bit. 
#define PB_OUT_OUT5                                 GPIOB->OUT.MBIT.OUT5            //[5] IO pin PB5 output data bit. 
#define PC_OUT_OUT5                                 GPIOC->OUT.MBIT.OUT5            //[5] IO pin PC5 output data bit. 
#define PD_OUT_OUT5                                 GPIOD->OUT.MBIT.OUT5            //[5] IO pin PD5 output data bit. 
#define PE_OUT_OUT5                                 GPIOE->OUT.MBIT.OUT5            //[5] IO pin PE5 output data bit. 

#define PA_OUT_OUT4                                 GPIOA->OUT.MBIT.OUT4            //[4] IO pin PA4 output data bit. 
#define PB_OUT_OUT4                                 GPIOB->OUT.MBIT.OUT4            //[4] IO pin PB4 output data bit. 
#define PC_OUT_OUT4                                 GPIOC->OUT.MBIT.OUT4            //[4] IO pin PC4 output data bit. 
#define PD_OUT_OUT4                                 GPIOD->OUT.MBIT.OUT4            //[4] IO pin PD4 output data bit. 
#define PE_OUT_OUT4                                 GPIOE->OUT.MBIT.OUT4            //[4] IO pin PE4 output data bit. 

#define PA_OUT_OUT3                                 GPIOA->OUT.MBIT.OUT3            //[3] IO pin PA3 output data bit. 
#define PB_OUT_OUT3                                 GPIOB->OUT.MBIT.OUT3            //[3] IO pin PB3 output data bit. 
#define PC_OUT_OUT3                                 GPIOC->OUT.MBIT.OUT3            //[3] IO pin PC3 output data bit. 
#define PD_OUT_OUT3                                 GPIOD->OUT.MBIT.OUT3            //[3] IO pin PD3 output data bit. 
#define PE_OUT_OUT3                                 GPIOE->OUT.MBIT.OUT3            //[3] IO pin PE3 output data bit. 

#define PA_OUT_OUT2                                 GPIOA->OUT.MBIT.OUT2            //[2] IO pin PA2 output data bit. 
#define PB_OUT_OUT2                                 GPIOB->OUT.MBIT.OUT2            //[2] IO pin PB2 output data bit. 
#define PC_OUT_OUT2                                 GPIOC->OUT.MBIT.OUT2            //[2] IO pin PC2 output data bit. 
#define PD_OUT_OUT2                                 GPIOD->OUT.MBIT.OUT2            //[2] IO pin PD2 output data bit. 
#define PE_OUT_OUT2                                 GPIOE->OUT.MBIT.OUT2            //[2] IO pin PE2 output data bit. 

#define PA_OUT_OUT1                                 GPIOA->OUT.MBIT.OUT1            //[1] IO pin PA1 output data bit. 
#define PB_OUT_OUT1                                 GPIOB->OUT.MBIT.OUT1            //[1] IO pin PB1 output data bit. 
#define PC_OUT_OUT1                                 GPIOC->OUT.MBIT.OUT1            //[1] IO pin PC1 output data bit. 
#define PD_OUT_OUT1                                 GPIOD->OUT.MBIT.OUT1            //[1] IO pin PD1 output data bit. 
#define PE_OUT_OUT1                                 GPIOE->OUT.MBIT.OUT1            //[1] IO pin PE1 output data bit. 

#define PA_OUT_OUT0                                 GPIOA->OUT.MBIT.OUT0            //[0] IO pin PA0 output data bit. 
#define PB_OUT_OUT0                                 GPIOB->OUT.MBIT.OUT0            //[0] IO pin PB0 output data bit. 
#define PC_OUT_OUT0                                 GPIOC->OUT.MBIT.OUT0            //[0] IO pin PC0 output data bit. 
#define PD_OUT_OUT0                                 GPIOD->OUT.MBIT.OUT0            //[0] IO pin PD0 output data bit. 
#define PE_OUT_OUT0                                 GPIOE->OUT.MBIT.OUT0            //[0] IO pin PE0 output data bit. 

///@}
/**
 ******************************************************************************
 * @name        PX_IN  [register's definitions]
 *              Offset[0x04]  PX input data register (0x41000004)
 ******************************************************************************
 */
///@{
#define PA_IN                                       GPIOA->IN.W                     /*!< Offset[0x04]  PA input data register (0x41000004) */
#define PB_IN                                       GPIOB->IN.W                     /*!< Offset[0x04]  PB input data register (0x41000024) */
#define PC_IN                                       GPIOC->IN.W                     /*!< Offset[0x04]  PC input data register (0x41000044) */
#define PD_IN                                       GPIOD->IN.W                     /*!< Offset[0x04]  PD input data register (0x41000064) */
#define PE_IN                                       GPIOE->IN.W                     /*!< Offset[0x04]  PE input data register (0x41000084) */

/* Bit fields of PX_IN */
#define PA_IN_IN15                                  GPIOA->IN.MBIT.IN15             //[15] IO pin PA15 input pin status. 
#define PB_IN_IN15                                  GPIOB->IN.MBIT.IN15             //[15] IO pin PB15 input pin status. 
#define PC_IN_IN15                                  GPIOC->IN.MBIT.IN15             //[15] IO pin PC15 input pin status. 
#define PD_IN_IN15                                  GPIOD->IN.MBIT.IN15             //[15] IO pin PD15 input pin status. 
#define PE_IN_IN15                                  GPIOE->IN.MBIT.IN15             //[15] IO pin PE15 input pin status. 

#define PA_IN_IN14                                  GPIOA->IN.MBIT.IN14             //[14] IO pin PA14 input pin status. 
#define PB_IN_IN14                                  GPIOB->IN.MBIT.IN14             //[14] IO pin PB14 input pin status. 
#define PC_IN_IN14                                  GPIOC->IN.MBIT.IN14             //[14] IO pin PC14 input pin status. 
#define PD_IN_IN14                                  GPIOD->IN.MBIT.IN14             //[14] IO pin PD14 input pin status. 
#define PE_IN_IN14                                  GPIOE->IN.MBIT.IN14             //[14] IO pin PE14 input pin status. 

#define PA_IN_IN13                                  GPIOA->IN.MBIT.IN13             //[13] IO pin PA13 input pin status. 
#define PB_IN_IN13                                  GPIOB->IN.MBIT.IN13             //[13] IO pin PB13 input pin status. 
#define PC_IN_IN13                                  GPIOC->IN.MBIT.IN13             //[13] IO pin PC13 input pin status. 
#define PD_IN_IN13                                  GPIOD->IN.MBIT.IN13             //[13] IO pin PD13 input pin status. 
#define PE_IN_IN13                                  GPIOE->IN.MBIT.IN13             //[13] IO pin PE13 input pin status. 

#define PA_IN_IN12                                  GPIOA->IN.MBIT.IN12             //[12] IO pin PA12 input pin status. 
#define PB_IN_IN12                                  GPIOB->IN.MBIT.IN12             //[12] IO pin PB12 input pin status. 
#define PC_IN_IN12                                  GPIOC->IN.MBIT.IN12             //[12] IO pin PC12 input pin status. 
#define PD_IN_IN12                                  GPIOD->IN.MBIT.IN12             //[12] IO pin PD12 input pin status. 
#define PE_IN_IN12                                  GPIOE->IN.MBIT.IN12             //[12] IO pin PE12 input pin status. 

#define PA_IN_IN11                                  GPIOA->IN.MBIT.IN11             //[11] IO pin PA11 input pin status. 
#define PB_IN_IN11                                  GPIOB->IN.MBIT.IN11             //[11] IO pin PB11 input pin status. 
#define PC_IN_IN11                                  GPIOC->IN.MBIT.IN11             //[11] IO pin PC11 input pin status. 
#define PD_IN_IN11                                  GPIOD->IN.MBIT.IN11             //[11] IO pin PD11 input pin status. 
#define PE_IN_IN11                                  GPIOE->IN.MBIT.IN11             //[11] IO pin PE11 input pin status. 

#define PA_IN_IN10                                  GPIOA->IN.MBIT.IN10             //[10] IO pin PA10 input pin status. 
#define PB_IN_IN10                                  GPIOB->IN.MBIT.IN10             //[10] IO pin PB10 input pin status. 
#define PC_IN_IN10                                  GPIOC->IN.MBIT.IN10             //[10] IO pin PC10 input pin status. 
#define PD_IN_IN10                                  GPIOD->IN.MBIT.IN10             //[10] IO pin PD10 input pin status. 
#define PE_IN_IN10                                  GPIOE->IN.MBIT.IN10             //[10] IO pin PE10 input pin status. 

#define PA_IN_IN9                                   GPIOA->IN.MBIT.IN9              //[9] IO pin PA9 input pin status. 
#define PB_IN_IN9                                   GPIOB->IN.MBIT.IN9              //[9] IO pin PB9 input pin status. 
#define PC_IN_IN9                                   GPIOC->IN.MBIT.IN9              //[9] IO pin PC9 input pin status. 
#define PD_IN_IN9                                   GPIOD->IN.MBIT.IN9              //[9] IO pin PD9 input pin status. 
#define PE_IN_IN9                                   GPIOE->IN.MBIT.IN9              //[9] IO pin PE9 input pin status. 

#define PA_IN_IN8                                   GPIOA->IN.MBIT.IN8              //[8] IO pin PA8 input pin status. 
#define PB_IN_IN8                                   GPIOB->IN.MBIT.IN8              //[8] IO pin PB8 input pin status. 
#define PC_IN_IN8                                   GPIOC->IN.MBIT.IN8              //[8] IO pin PC8 input pin status. 
#define PD_IN_IN8                                   GPIOD->IN.MBIT.IN8              //[8] IO pin PD8 input pin status. 
#define PE_IN_IN8                                   GPIOE->IN.MBIT.IN8              //[8] IO pin PE8 input pin status. 

#define PA_IN_IN7                                   GPIOA->IN.MBIT.IN7              //[7] IO pin PA7 input pin status. 
#define PB_IN_IN7                                   GPIOB->IN.MBIT.IN7              //[7] IO pin PB7 input pin status. 
#define PC_IN_IN7                                   GPIOC->IN.MBIT.IN7              //[7] IO pin PC7 input pin status. 
#define PD_IN_IN7                                   GPIOD->IN.MBIT.IN7              //[7] IO pin PD7 input pin status. 
#define PE_IN_IN7                                   GPIOE->IN.MBIT.IN7              //[7] IO pin PE7 input pin status. 

#define PA_IN_IN6                                   GPIOA->IN.MBIT.IN6              //[6] IO pin PA6 input pin status. 
#define PB_IN_IN6                                   GPIOB->IN.MBIT.IN6              //[6] IO pin PB6 input pin status. 
#define PC_IN_IN6                                   GPIOC->IN.MBIT.IN6              //[6] IO pin PC6 input pin status. 
#define PD_IN_IN6                                   GPIOD->IN.MBIT.IN6              //[6] IO pin PD6 input pin status. 
#define PE_IN_IN6                                   GPIOE->IN.MBIT.IN6              //[6] IO pin PE6 input pin status. 

#define PA_IN_IN5                                   GPIOA->IN.MBIT.IN5              //[5] IO pin PA5 input pin status. 
#define PB_IN_IN5                                   GPIOB->IN.MBIT.IN5              //[5] IO pin PB5 input pin status. 
#define PC_IN_IN5                                   GPIOC->IN.MBIT.IN5              //[5] IO pin PC5 input pin status. 
#define PD_IN_IN5                                   GPIOD->IN.MBIT.IN5              //[5] IO pin PD5 input pin status. 
#define PE_IN_IN5                                   GPIOE->IN.MBIT.IN5              //[5] IO pin PE5 input pin status. 

#define PA_IN_IN4                                   GPIOA->IN.MBIT.IN4              //[4] IO pin PA4 input pin status. 
#define PB_IN_IN4                                   GPIOB->IN.MBIT.IN4              //[4] IO pin PB4 input pin status. 
#define PC_IN_IN4                                   GPIOC->IN.MBIT.IN4              //[4] IO pin PC4 input pin status. 
#define PD_IN_IN4                                   GPIOD->IN.MBIT.IN4              //[4] IO pin PD4 input pin status. 
#define PE_IN_IN4                                   GPIOE->IN.MBIT.IN4              //[4] IO pin PE4 input pin status. 

#define PA_IN_IN3                                   GPIOA->IN.MBIT.IN3              //[3] IO pin PA3 input pin status. 
#define PB_IN_IN3                                   GPIOB->IN.MBIT.IN3              //[3] IO pin PB3 input pin status. 
#define PC_IN_IN3                                   GPIOC->IN.MBIT.IN3              //[3] IO pin PC3 input pin status. 
#define PD_IN_IN3                                   GPIOD->IN.MBIT.IN3              //[3] IO pin PD3 input pin status. 
#define PE_IN_IN3                                   GPIOE->IN.MBIT.IN3              //[3] IO pin PE3 input pin status. 

#define PA_IN_IN2                                   GPIOA->IN.MBIT.IN2              //[2] IO pin PA2 input pin status. 
#define PB_IN_IN2                                   GPIOB->IN.MBIT.IN2              //[2] IO pin PB2 input pin status. 
#define PC_IN_IN2                                   GPIOC->IN.MBIT.IN2              //[2] IO pin PC2 input pin status. 
#define PD_IN_IN2                                   GPIOD->IN.MBIT.IN2              //[2] IO pin PD2 input pin status. 
#define PE_IN_IN2                                   GPIOE->IN.MBIT.IN2              //[2] IO pin PE2 input pin status. 

#define PA_IN_IN1                                   GPIOA->IN.MBIT.IN1              //[1] IO pin PA1 input pin status. 
#define PB_IN_IN1                                   GPIOB->IN.MBIT.IN1              //[1] IO pin PB1 input pin status. 
#define PC_IN_IN1                                   GPIOC->IN.MBIT.IN1              //[1] IO pin PC1 input pin status. 
#define PD_IN_IN1                                   GPIOD->IN.MBIT.IN1              //[1] IO pin PD1 input pin status. 
#define PE_IN_IN1                                   GPIOE->IN.MBIT.IN1              //[1] IO pin PE1 input pin status. 

#define PA_IN_IN0                                   GPIOA->IN.MBIT.IN0              //[0] IO pin PA0 input pin status. 
#define PB_IN_IN0                                   GPIOB->IN.MBIT.IN0              //[0] IO pin PB0 input pin status. 
#define PC_IN_IN0                                   GPIOC->IN.MBIT.IN0              //[0] IO pin PC0 input pin status. 
#define PD_IN_IN0                                   GPIOD->IN.MBIT.IN0              //[0] IO pin PD0 input pin status. 
#define PE_IN_IN0                                   GPIOE->IN.MBIT.IN0              //[0] IO pin PE0 input pin status. 

///@}
/**
 ******************************************************************************
 * @name        PX_SC  [register's definitions]
 *              Offset[0x08]  PX port set / clear register (0x41000008)
 ******************************************************************************
 */
///@{
#define PA_SC                                       GPIOA->SC.W                     /*!< Offset[0x08]  PA port set / clear register (0x41000008) */
#define PB_SC                                       GPIOB->SC.W                     /*!< Offset[0x08]  PB port set / clear register (0x41000028) */
#define PC_SC                                       GPIOC->SC.W                     /*!< Offset[0x08]  PC port set / clear register (0x41000048) */
#define PD_SC                                       GPIOD->SC.W                     /*!< Offset[0x08]  PD port set / clear register (0x41000068) */
#define PE_SC                                       GPIOE->SC.W                     /*!< Offset[0x08]  PE port set / clear register (0x41000088) */

/* Bit fields of PX_SC */
#define PA_SC_CLR15                                 GPIOA->SC.MBIT.CLR15            //[31] IO pin PA15 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR15                                 GPIOB->SC.MBIT.CLR15            //[31] IO pin PB15 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR15                                 GPIOC->SC.MBIT.CLR15            //[31] IO pin PC15 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR15                                 GPIOD->SC.MBIT.CLR15            //[31] IO pin PD15 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR15                                 GPIOE->SC.MBIT.CLR15            //[31] IO pin PE15 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR14                                 GPIOA->SC.MBIT.CLR14            //[30] IO pin PA14 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR14                                 GPIOB->SC.MBIT.CLR14            //[30] IO pin PB14 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR14                                 GPIOC->SC.MBIT.CLR14            //[30] IO pin PC14 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR14                                 GPIOD->SC.MBIT.CLR14            //[30] IO pin PD14 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR14                                 GPIOE->SC.MBIT.CLR14            //[30] IO pin PE14 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR13                                 GPIOA->SC.MBIT.CLR13            //[29] IO pin PA13 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR13                                 GPIOB->SC.MBIT.CLR13            //[29] IO pin PB13 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR13                                 GPIOC->SC.MBIT.CLR13            //[29] IO pin PC13 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR13                                 GPIOD->SC.MBIT.CLR13            //[29] IO pin PD13 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR13                                 GPIOE->SC.MBIT.CLR13            //[29] IO pin PE13 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR12                                 GPIOA->SC.MBIT.CLR12            //[28] IO pin PA12 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR12                                 GPIOB->SC.MBIT.CLR12            //[28] IO pin PB12 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR12                                 GPIOC->SC.MBIT.CLR12            //[28] IO pin PC12 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR12                                 GPIOD->SC.MBIT.CLR12            //[28] IO pin PD12 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR12                                 GPIOE->SC.MBIT.CLR12            //[28] IO pin PE12 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR11                                 GPIOA->SC.MBIT.CLR11            //[27] IO pin PA11 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR11                                 GPIOB->SC.MBIT.CLR11            //[27] IO pin PB11 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR11                                 GPIOC->SC.MBIT.CLR11            //[27] IO pin PC11 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR11                                 GPIOD->SC.MBIT.CLR11            //[27] IO pin PD11 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR11                                 GPIOE->SC.MBIT.CLR11            //[27] IO pin PE11 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR10                                 GPIOA->SC.MBIT.CLR10            //[26] IO pin PA10 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR10                                 GPIOB->SC.MBIT.CLR10            //[26] IO pin PB10 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR10                                 GPIOC->SC.MBIT.CLR10            //[26] IO pin PC10 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR10                                 GPIOD->SC.MBIT.CLR10            //[26] IO pin PD10 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR10                                 GPIOE->SC.MBIT.CLR10            //[26] IO pin PE10 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR9                                  GPIOA->SC.MBIT.CLR9             //[25] IO pin PA9 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR9                                  GPIOB->SC.MBIT.CLR9             //[25] IO pin PB9 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR9                                  GPIOC->SC.MBIT.CLR9             //[25] IO pin PC9 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR9                                  GPIOD->SC.MBIT.CLR9             //[25] IO pin PD9 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR9                                  GPIOE->SC.MBIT.CLR9             //[25] IO pin PE9 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR8                                  GPIOA->SC.MBIT.CLR8             //[24] IO pin PA8 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR8                                  GPIOB->SC.MBIT.CLR8             //[24] IO pin PB8 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR8                                  GPIOC->SC.MBIT.CLR8             //[24] IO pin PC8 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR8                                  GPIOD->SC.MBIT.CLR8             //[24] IO pin PD8 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR8                                  GPIOE->SC.MBIT.CLR8             //[24] IO pin PE8 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR7                                  GPIOA->SC.MBIT.CLR7             //[23] IO pin PA7 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR7                                  GPIOB->SC.MBIT.CLR7             //[23] IO pin PB7 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR7                                  GPIOC->SC.MBIT.CLR7             //[23] IO pin PC7 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR7                                  GPIOD->SC.MBIT.CLR7             //[23] IO pin PD7 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR7                                  GPIOE->SC.MBIT.CLR7             //[23] IO pin PE7 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR6                                  GPIOA->SC.MBIT.CLR6             //[22] IO pin PA6 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR6                                  GPIOB->SC.MBIT.CLR6             //[22] IO pin PB6 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR6                                  GPIOC->SC.MBIT.CLR6             //[22] IO pin PC6 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR6                                  GPIOD->SC.MBIT.CLR6             //[22] IO pin PD6 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR6                                  GPIOE->SC.MBIT.CLR6             //[22] IO pin PE6 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR5                                  GPIOA->SC.MBIT.CLR5             //[21] IO pin PA5 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR5                                  GPIOB->SC.MBIT.CLR5             //[21] IO pin PB5 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR5                                  GPIOC->SC.MBIT.CLR5             //[21] IO pin PC5 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR5                                  GPIOD->SC.MBIT.CLR5             //[21] IO pin PD5 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR5                                  GPIOE->SC.MBIT.CLR5             //[21] IO pin PE5 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR4                                  GPIOA->SC.MBIT.CLR4             //[20] IO pin PA4 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR4                                  GPIOB->SC.MBIT.CLR4             //[20] IO pin PB4 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR4                                  GPIOC->SC.MBIT.CLR4             //[20] IO pin PC4 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR4                                  GPIOD->SC.MBIT.CLR4             //[20] IO pin PD4 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR4                                  GPIOE->SC.MBIT.CLR4             //[20] IO pin PE4 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR3                                  GPIOA->SC.MBIT.CLR3             //[19] IO pin PA3 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR3                                  GPIOB->SC.MBIT.CLR3             //[19] IO pin PB3 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR3                                  GPIOC->SC.MBIT.CLR3             //[19] IO pin PC3 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR3                                  GPIOD->SC.MBIT.CLR3             //[19] IO pin PD3 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR3                                  GPIOE->SC.MBIT.CLR3             //[19] IO pin PE3 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR2                                  GPIOA->SC.MBIT.CLR2             //[18] IO pin PA2 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR2                                  GPIOB->SC.MBIT.CLR2             //[18] IO pin PB2 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR2                                  GPIOC->SC.MBIT.CLR2             //[18] IO pin PC2 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR2                                  GPIOD->SC.MBIT.CLR2             //[18] IO pin PD2 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR2                                  GPIOE->SC.MBIT.CLR2             //[18] IO pin PE2 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR1                                  GPIOA->SC.MBIT.CLR1             //[17] IO pin PA1 clear data bit. This bit is no effect for writing 0. 
#define PB_SC_CLR1                                  GPIOB->SC.MBIT.CLR1             //[17] IO pin PB1 clear data bit. This bit is no effect for writing 0. 
#define PC_SC_CLR1                                  GPIOC->SC.MBIT.CLR1             //[17] IO pin PC1 clear data bit. This bit is no effect for writing 0. 
#define PD_SC_CLR1                                  GPIOD->SC.MBIT.CLR1             //[17] IO pin PD1 clear data bit. This bit is no effect for writing 0. 
#define PE_SC_CLR1                                  GPIOE->SC.MBIT.CLR1             //[17] IO pin PE1 clear data bit. This bit is no effect for writing 0. 

#define PA_SC_CLR0                                  GPIOA->SC.MBIT.CLR0             //[16] IO pin PA0 clear data bit 
#define PB_SC_CLR0                                  GPIOB->SC.MBIT.CLR0             //[16] IO pin PB0 clear data bit 
#define PC_SC_CLR0                                  GPIOC->SC.MBIT.CLR0             //[16] IO pin PC0 clear data bit 
#define PD_SC_CLR0                                  GPIOD->SC.MBIT.CLR0             //[16] IO pin PD0 clear data bit 
#define PE_SC_CLR0                                  GPIOE->SC.MBIT.CLR0             //[16] IO pin PE0 clear data bit 

#define PA_SC_SET15                                 GPIOA->SC.MBIT.SET15            //[15] IO pin PA15 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET15                                 GPIOB->SC.MBIT.SET15            //[15] IO pin PB15 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET15                                 GPIOC->SC.MBIT.SET15            //[15] IO pin PC15 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET15                                 GPIOD->SC.MBIT.SET15            //[15] IO pin PD15 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET15                                 GPIOE->SC.MBIT.SET15            //[15] IO pin PE15 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET14                                 GPIOA->SC.MBIT.SET14            //[14] IO pin PA14 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET14                                 GPIOB->SC.MBIT.SET14            //[14] IO pin PB14 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET14                                 GPIOC->SC.MBIT.SET14            //[14] IO pin PC14 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET14                                 GPIOD->SC.MBIT.SET14            //[14] IO pin PD14 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET14                                 GPIOE->SC.MBIT.SET14            //[14] IO pin PE14 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET13                                 GPIOA->SC.MBIT.SET13            //[13] IO pin PA13 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET13                                 GPIOB->SC.MBIT.SET13            //[13] IO pin PB13 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET13                                 GPIOC->SC.MBIT.SET13            //[13] IO pin PC13 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET13                                 GPIOD->SC.MBIT.SET13            //[13] IO pin PD13 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET13                                 GPIOE->SC.MBIT.SET13            //[13] IO pin PE13 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET12                                 GPIOA->SC.MBIT.SET12            //[12] IO pin PA12 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET12                                 GPIOB->SC.MBIT.SET12            //[12] IO pin PB12 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET12                                 GPIOC->SC.MBIT.SET12            //[12] IO pin PC12 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET12                                 GPIOD->SC.MBIT.SET12            //[12] IO pin PD12 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET12                                 GPIOE->SC.MBIT.SET12            //[12] IO pin PE12 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET11                                 GPIOA->SC.MBIT.SET11            //[11] IO pin PA11 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET11                                 GPIOB->SC.MBIT.SET11            //[11] IO pin PB11 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET11                                 GPIOC->SC.MBIT.SET11            //[11] IO pin PC11 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET11                                 GPIOD->SC.MBIT.SET11            //[11] IO pin PD11 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET11                                 GPIOE->SC.MBIT.SET11            //[11] IO pin PE11 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET10                                 GPIOA->SC.MBIT.SET10            //[10] IO pin PA10 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET10                                 GPIOB->SC.MBIT.SET10            //[10] IO pin PB10 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET10                                 GPIOC->SC.MBIT.SET10            //[10] IO pin PC10 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET10                                 GPIOD->SC.MBIT.SET10            //[10] IO pin PD10 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET10                                 GPIOE->SC.MBIT.SET10            //[10] IO pin PE10 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET9                                  GPIOA->SC.MBIT.SET9             //[9] IO pin PA9 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET9                                  GPIOB->SC.MBIT.SET9             //[9] IO pin PB9 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET9                                  GPIOC->SC.MBIT.SET9             //[9] IO pin PC9 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET9                                  GPIOD->SC.MBIT.SET9             //[9] IO pin PD9 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET9                                  GPIOE->SC.MBIT.SET9             //[9] IO pin PE9 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET8                                  GPIOA->SC.MBIT.SET8             //[8] IO pin PA8 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET8                                  GPIOB->SC.MBIT.SET8             //[8] IO pin PB8 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET8                                  GPIOC->SC.MBIT.SET8             //[8] IO pin PC8 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET8                                  GPIOD->SC.MBIT.SET8             //[8] IO pin PD8 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET8                                  GPIOE->SC.MBIT.SET8             //[8] IO pin PE8 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET7                                  GPIOA->SC.MBIT.SET7             //[7] IO pin PA7 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET7                                  GPIOB->SC.MBIT.SET7             //[7] IO pin PB7 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET7                                  GPIOC->SC.MBIT.SET7             //[7] IO pin PC7 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET7                                  GPIOD->SC.MBIT.SET7             //[7] IO pin PD7 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET7                                  GPIOE->SC.MBIT.SET7             //[7] IO pin PE7 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET6                                  GPIOA->SC.MBIT.SET6             //[6] IO pin PA6 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET6                                  GPIOB->SC.MBIT.SET6             //[6] IO pin PB6 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET6                                  GPIOC->SC.MBIT.SET6             //[6] IO pin PC6 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET6                                  GPIOD->SC.MBIT.SET6             //[6] IO pin PD6 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET6                                  GPIOE->SC.MBIT.SET6             //[6] IO pin PE6 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET5                                  GPIOA->SC.MBIT.SET5             //[5] IO pin PA5 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET5                                  GPIOB->SC.MBIT.SET5             //[5] IO pin PB5 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET5                                  GPIOC->SC.MBIT.SET5             //[5] IO pin PC5 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET5                                  GPIOD->SC.MBIT.SET5             //[5] IO pin PD5 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET5                                  GPIOE->SC.MBIT.SET5             //[5] IO pin PE5 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET4                                  GPIOA->SC.MBIT.SET4             //[4] IO pin PA4 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET4                                  GPIOB->SC.MBIT.SET4             //[4] IO pin PB4 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET4                                  GPIOC->SC.MBIT.SET4             //[4] IO pin PC4 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET4                                  GPIOD->SC.MBIT.SET4             //[4] IO pin PD4 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET4                                  GPIOE->SC.MBIT.SET4             //[4] IO pin PE4 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET3                                  GPIOA->SC.MBIT.SET3             //[3] IO pin PA3 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET3                                  GPIOB->SC.MBIT.SET3             //[3] IO pin PB3 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET3                                  GPIOC->SC.MBIT.SET3             //[3] IO pin PC3 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET3                                  GPIOD->SC.MBIT.SET3             //[3] IO pin PD3 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET3                                  GPIOE->SC.MBIT.SET3             //[3] IO pin PE3 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET2                                  GPIOA->SC.MBIT.SET2             //[2] IO pin PA2 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET2                                  GPIOB->SC.MBIT.SET2             //[2] IO pin PB2 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET2                                  GPIOC->SC.MBIT.SET2             //[2] IO pin PC2 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET2                                  GPIOD->SC.MBIT.SET2             //[2] IO pin PD2 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET2                                  GPIOE->SC.MBIT.SET2             //[2] IO pin PE2 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET1                                  GPIOA->SC.MBIT.SET1             //[1] IO pin PA1 set data bit. This bit is no effect for writing 0. 
#define PB_SC_SET1                                  GPIOB->SC.MBIT.SET1             //[1] IO pin PB1 set data bit. This bit is no effect for writing 0. 
#define PC_SC_SET1                                  GPIOC->SC.MBIT.SET1             //[1] IO pin PC1 set data bit. This bit is no effect for writing 0. 
#define PD_SC_SET1                                  GPIOD->SC.MBIT.SET1             //[1] IO pin PD1 set data bit. This bit is no effect for writing 0. 
#define PE_SC_SET1                                  GPIOE->SC.MBIT.SET1             //[1] IO pin PE1 set data bit. This bit is no effect for writing 0. 

#define PA_SC_SET0                                  GPIOA->SC.MBIT.SET0             //[0] IO pin PA0 set data bit 
#define PB_SC_SET0                                  GPIOB->SC.MBIT.SET0             //[0] IO pin PB0 set data bit 
#define PC_SC_SET0                                  GPIOC->SC.MBIT.SET0             //[0] IO pin PC0 set data bit 
#define PD_SC_SET0                                  GPIOD->SC.MBIT.SET0             //[0] IO pin PD0 set data bit 
#define PE_SC_SET0                                  GPIOE->SC.MBIT.SET0             //[0] IO pin PE0 set data bit 

///@}
/**
 ******************************************************************************
 * @name        PX_SCR0  [register's definitions]
 *              Offset[0x10]  PX port set and clear register 0 (0x41000010)
 ******************************************************************************
 */
///@{
#define PA_SCR0                                     GPIOA->SCR0.W                   /*!< Offset[0x10]  PA port set and clear register 0 (0x41000010) */
#define PB_SCR0                                     GPIOB->SCR0.W                   /*!< Offset[0x10]  PB port set and clear register 0 (0x41000030) */
#define PC_SCR0                                     GPIOC->SCR0.W                   /*!< Offset[0x10]  PC port set and clear register 0 (0x41000050) */
#define PD_SCR0                                     GPIOD->SCR0.W                   /*!< Offset[0x10]  PD port set and clear register 0 (0x41000070) */
#define PE_SCR0                                     GPIOE->SCR0.W                   /*!< Offset[0x10]  PE port set and clear register 0 (0x41000090) */

/* Bit fields of PX_SCR0 */
#define PA_SCR0_SC3                                 GPIOA->SCR0.MBIT.SC3            //[24] GPIO Port set or clear bit for PA3. 
#define PB_SCR0_SC3                                 GPIOB->SCR0.MBIT.SC3            //[24] GPIO Port set or clear bit for PB3. 
#define PC_SCR0_SC3                                 GPIOC->SCR0.MBIT.SC3            //[24] GPIO Port set or clear bit for PC3. 
#define PD_SCR0_SC3                                 GPIOD->SCR0.MBIT.SC3            //[24] GPIO Port set or clear bit for PD3. 
#define PE_SCR0_SC3                                 GPIOE->SCR0.MBIT.SC3            //[24] GPIO Port set or clear bit for PE3. 

#define PA_SCR0_SC2                                 GPIOA->SCR0.MBIT.SC2            //[16] GPIO Port set or clear bit for PA2. 
#define PB_SCR0_SC2                                 GPIOB->SCR0.MBIT.SC2            //[16] GPIO Port set or clear bit for PB2. 
#define PC_SCR0_SC2                                 GPIOC->SCR0.MBIT.SC2            //[16] GPIO Port set or clear bit for PC2. 
#define PD_SCR0_SC2                                 GPIOD->SCR0.MBIT.SC2            //[16] GPIO Port set or clear bit for PD2. 
#define PE_SCR0_SC2                                 GPIOE->SCR0.MBIT.SC2            //[16] GPIO Port set or clear bit for PE2. 

#define PA_SCR0_SC1                                 GPIOA->SCR0.MBIT.SC1            //[8] GPIO Port set or clear bit for PA1. 
#define PB_SCR0_SC1                                 GPIOB->SCR0.MBIT.SC1            //[8] GPIO Port set or clear bit for PB1. 
#define PC_SCR0_SC1                                 GPIOC->SCR0.MBIT.SC1            //[8] GPIO Port set or clear bit for PC1. 
#define PD_SCR0_SC1                                 GPIOD->SCR0.MBIT.SC1            //[8] GPIO Port set or clear bit for PD1. 
#define PE_SCR0_SC1                                 GPIOE->SCR0.MBIT.SC1            //[8] GPIO Port set or clear bit for PE1. 

#define PA_SCR0_SC0                                 GPIOA->SCR0.MBIT.SC0            //[0] GPIO Port set or clear bit for PA0. 
#define PB_SCR0_SC0                                 GPIOB->SCR0.MBIT.SC0            //[0] GPIO Port set or clear bit for PB0. 
#define PC_SCR0_SC0                                 GPIOC->SCR0.MBIT.SC0            //[0] GPIO Port set or clear bit for PC0. 
#define PD_SCR0_SC0                                 GPIOD->SCR0.MBIT.SC0            //[0] GPIO Port set or clear bit for PD0. 
#define PE_SCR0_SC0                                 GPIOE->SCR0.MBIT.SC0            //[0] GPIO Port set or clear bit for PE0. 

///@}
/**
 ******************************************************************************
 * @name        PX_SCR1  [register's definitions]
 *              Offset[0x14]  PX port set and clear register 1 (0x41000014)
 ******************************************************************************
 */
///@{
#define PA_SCR1                                     GPIOA->SCR1.W                   /*!< Offset[0x14]  PA port set and clear register 1 (0x41000014) */
#define PB_SCR1                                     GPIOB->SCR1.W                   /*!< Offset[0x14]  PB port set and clear register 1 (0x41000034) */
#define PC_SCR1                                     GPIOC->SCR1.W                   /*!< Offset[0x14]  PC port set and clear register 1 (0x41000054) */
#define PD_SCR1                                     GPIOD->SCR1.W                   /*!< Offset[0x14]  PD port set and clear register 1 (0x41000074) */
#define PE_SCR1                                     GPIOE->SCR1.W                   /*!< Offset[0x14]  PE port set and clear register 1 (0x41000094) */

/* Bit fields of PX_SCR1 */
#define PA_SCR1_SC7                                 GPIOA->SCR1.MBIT.SC7            //[24] GPIO Port set or clear bit for PA7. 
#define PB_SCR1_SC7                                 GPIOB->SCR1.MBIT.SC7            //[24] GPIO Port set or clear bit for PB7. 
#define PC_SCR1_SC7                                 GPIOC->SCR1.MBIT.SC7            //[24] GPIO Port set or clear bit for PC7. 
#define PD_SCR1_SC7                                 GPIOD->SCR1.MBIT.SC7            //[24] GPIO Port set or clear bit for PD7. 
#define PE_SCR1_SC7                                 GPIOE->SCR1.MBIT.SC7            //[24] GPIO Port set or clear bit for PE7. 

#define PA_SCR1_SC6                                 GPIOA->SCR1.MBIT.SC6            //[16] GPIO Port set or clear bit for PA6. 
#define PB_SCR1_SC6                                 GPIOB->SCR1.MBIT.SC6            //[16] GPIO Port set or clear bit for PB6. 
#define PC_SCR1_SC6                                 GPIOC->SCR1.MBIT.SC6            //[16] GPIO Port set or clear bit for PC6. 
#define PD_SCR1_SC6                                 GPIOD->SCR1.MBIT.SC6            //[16] GPIO Port set or clear bit for PD6. 
#define PE_SCR1_SC6                                 GPIOE->SCR1.MBIT.SC6            //[16] GPIO Port set or clear bit for PE6. 

#define PA_SCR1_SC5                                 GPIOA->SCR1.MBIT.SC5            //[8] GPIO Port set or clear bit for PA5. 
#define PB_SCR1_SC5                                 GPIOB->SCR1.MBIT.SC5            //[8] GPIO Port set or clear bit for PB5. 
#define PC_SCR1_SC5                                 GPIOC->SCR1.MBIT.SC5            //[8] GPIO Port set or clear bit for PC5. 
#define PD_SCR1_SC5                                 GPIOD->SCR1.MBIT.SC5            //[8] GPIO Port set or clear bit for PD5. 
#define PE_SCR1_SC5                                 GPIOE->SCR1.MBIT.SC5            //[8] GPIO Port set or clear bit for PE5. 

#define PA_SCR1_SC4                                 GPIOA->SCR1.MBIT.SC4            //[0] GPIO Port set or clear bit for PA4. 
#define PB_SCR1_SC4                                 GPIOB->SCR1.MBIT.SC4            //[0] GPIO Port set or clear bit for PB4. 
#define PC_SCR1_SC4                                 GPIOC->SCR1.MBIT.SC4            //[0] GPIO Port set or clear bit for PC4. 
#define PD_SCR1_SC4                                 GPIOD->SCR1.MBIT.SC4            //[0] GPIO Port set or clear bit for PD4. 
#define PE_SCR1_SC4                                 GPIOE->SCR1.MBIT.SC4            //[0] GPIO Port set or clear bit for PE4. 

///@}
/**
 ******************************************************************************
 * @name        PX_SCR2  [register's definitions]
 *              Offset[0x18]  PX port set and clear register 2 (0x41000018)
 ******************************************************************************
 */
///@{
#define PA_SCR2                                     GPIOA->SCR2.W                   /*!< Offset[0x18]  PA port set and clear register 2 (0x41000018) */
#define PB_SCR2                                     GPIOB->SCR2.W                   /*!< Offset[0x18]  PB port set and clear register 2 (0x41000038) */
#define PC_SCR2                                     GPIOC->SCR2.W                   /*!< Offset[0x18]  PC port set and clear register 2 (0x41000058) */
#define PD_SCR2                                     GPIOD->SCR2.W                   /*!< Offset[0x18]  PD port set and clear register 2 (0x41000078) */
#define PE_SCR2                                     GPIOE->SCR2.W                   /*!< Offset[0x18]  PE port set and clear register 2 (0x41000098) */

/* Bit fields of PX_SCR2 */
#define PA_SCR2_SC11                                GPIOA->SCR2.MBIT.SC11           //[24] GPIO Port set and clear bit for PA11. 
#define PB_SCR2_SC11                                GPIOB->SCR2.MBIT.SC11           //[24] GPIO Port set and clear bit for PB11. 
#define PC_SCR2_SC11                                GPIOC->SCR2.MBIT.SC11           //[24] GPIO Port set and clear bit for PC11. 
#define PD_SCR2_SC11                                GPIOD->SCR2.MBIT.SC11           //[24] GPIO Port set and clear bit for PD11. 
#define PE_SCR2_SC11                                GPIOE->SCR2.MBIT.SC11           //[24] GPIO Port set and clear bit for PE11. 

#define PA_SCR2_SC10                                GPIOA->SCR2.MBIT.SC10           //[16] GPIO Port set or clear bit for PA10. 
#define PB_SCR2_SC10                                GPIOB->SCR2.MBIT.SC10           //[16] GPIO Port set or clear bit for PB10. 
#define PC_SCR2_SC10                                GPIOC->SCR2.MBIT.SC10           //[16] GPIO Port set or clear bit for PC10. 
#define PD_SCR2_SC10                                GPIOD->SCR2.MBIT.SC10           //[16] GPIO Port set or clear bit for PD10. 
#define PE_SCR2_SC10                                GPIOE->SCR2.MBIT.SC10           //[16] GPIO Port set or clear bit for PE10. 

#define PA_SCR2_SC9                                 GPIOA->SCR2.MBIT.SC9            //[8] GPIO Port set or clear bit for PA9. 
#define PB_SCR2_SC9                                 GPIOB->SCR2.MBIT.SC9            //[8] GPIO Port set or clear bit for PB9. 
#define PC_SCR2_SC9                                 GPIOC->SCR2.MBIT.SC9            //[8] GPIO Port set or clear bit for PC9. 
#define PD_SCR2_SC9                                 GPIOD->SCR2.MBIT.SC9            //[8] GPIO Port set or clear bit for PD9. 
#define PE_SCR2_SC9                                 GPIOE->SCR2.MBIT.SC9            //[8] GPIO Port set or clear bit for PE9. 

#define PA_SCR2_SC8                                 GPIOA->SCR2.MBIT.SC8            //[0] GPIO Port set or clear bit for PA8. 
#define PB_SCR2_SC8                                 GPIOB->SCR2.MBIT.SC8            //[0] GPIO Port set or clear bit for PB8. 
#define PC_SCR2_SC8                                 GPIOC->SCR2.MBIT.SC8            //[0] GPIO Port set or clear bit for PC8. 
#define PD_SCR2_SC8                                 GPIOD->SCR2.MBIT.SC8            //[0] GPIO Port set or clear bit for PD8. 
#define PE_SCR2_SC8                                 GPIOE->SCR2.MBIT.SC8            //[0] GPIO Port set or clear bit for PE8. 

///@}
/**
 ******************************************************************************
 * @name        PX_SCR3  [register's definitions]
 *              Offset[0x1C]  PX port set and clear register 3 (0x4100001C)
 ******************************************************************************
 */
///@{
#define PA_SCR3                                     GPIOA->SCR3.W                   /*!< Offset[0x1C]  PA port set and clear register 3 (0x4100001C) */
#define PB_SCR3                                     GPIOB->SCR3.W                   /*!< Offset[0x1C]  PB port set and clear register 3 (0x4100003C) */
#define PC_SCR3                                     GPIOC->SCR3.W                   /*!< Offset[0x1C]  PC port set and clear register 3 (0x4100005C) */
#define PD_SCR3                                     GPIOD->SCR3.W                   /*!< Offset[0x1C]  PD port set and clear register 3 (0x4100007C) */
#define PE_SCR3                                     GPIOE->SCR3.W                   /*!< Offset[0x1C]  PE port set and clear register 3 (0x4100009C) */

/* Bit fields of PX_SCR3 */
#define PA_SCR3_SC15                                GPIOA->SCR3.MBIT.SC15           //[24] GPIO Port set or clear bit for PA15. 
#define PB_SCR3_SC15                                GPIOB->SCR3.MBIT.SC15           //[24] GPIO Port set or clear bit for PB15. 
#define PC_SCR3_SC15                                GPIOC->SCR3.MBIT.SC15           //[24] GPIO Port set or clear bit for PC15. 
#define PD_SCR3_SC15                                GPIOD->SCR3.MBIT.SC15           //[24] GPIO Port set or clear bit for PD15. 
#define PE_SCR3_SC15                                GPIOE->SCR3.MBIT.SC15           //[24] GPIO Port set or clear bit for PE15. 

#define PA_SCR3_SC14                                GPIOA->SCR3.MBIT.SC14           //[16] GPIO Port set or clear bit for PA14. 
#define PB_SCR3_SC14                                GPIOB->SCR3.MBIT.SC14           //[16] GPIO Port set or clear bit for PB14. 
#define PC_SCR3_SC14                                GPIOC->SCR3.MBIT.SC14           //[16] GPIO Port set or clear bit for PC14. 
#define PD_SCR3_SC14                                GPIOD->SCR3.MBIT.SC14           //[16] GPIO Port set or clear bit for PD14. 
#define PE_SCR3_SC14                                GPIOE->SCR3.MBIT.SC14           //[16] GPIO Port set or clear bit for PE14. 

#define PA_SCR3_SC13                                GPIOA->SCR3.MBIT.SC13           //[8] GPIO Port set or clear bit for PA13. 
#define PB_SCR3_SC13                                GPIOB->SCR3.MBIT.SC13           //[8] GPIO Port set or clear bit for PB13. 
#define PC_SCR3_SC13                                GPIOC->SCR3.MBIT.SC13           //[8] GPIO Port set or clear bit for PC13. 
#define PD_SCR3_SC13                                GPIOD->SCR3.MBIT.SC13           //[8] GPIO Port set or clear bit for PD13. 
#define PE_SCR3_SC13                                GPIOE->SCR3.MBIT.SC13           //[8] GPIO Port set or clear bit for PE13. 

#define PA_SCR3_SC12                                GPIOA->SCR3.MBIT.SC12           //[0] GPIO Port set or clear bit for PA12. 
#define PB_SCR3_SC12                                GPIOB->SCR3.MBIT.SC12           //[0] GPIO Port set or clear bit for PB12. 
#define PC_SCR3_SC12                                GPIOC->SCR3.MBIT.SC12           //[0] GPIO Port set or clear bit for PC12. 
#define PD_SCR3_SC12                                GPIOD->SCR3.MBIT.SC12           //[0] GPIO Port set or clear bit for PD12. 
#define PE_SCR3_SC12                                GPIOE->SCR3.MBIT.SC12           //[0] GPIO Port set or clear bit for PE12. 

///@}

/*----------------------------------------------------------------------------*/
/* @module      PA (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PA_CR0  [register's definitions]
 *              Offset[0x00]  PA0 IO control register (0x44000000)
 ******************************************************************************
 */
///@{
#define PA_CR0                                      GPIOA->CR0.W                    /*!< Offset[0x00]  PA0 IO control register (0x44000000) */

/* Bit fields of PA_CR0 */
#define PA_CR0_AFS0                                 GPIOA->CR0.MBIT.AFS0            //[15..12] PA0 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR0_FDIV0                                GPIOA->CR0.MBIT.FDIV0           //[11..10] PA0 pin input deglitch filter clock divider select. 
#define PA_CR0_ODC0                                 GPIOA->CR0.MBIT.ODC0            //[9] PA1 pin output drive strength select. 
#define PA_CR0_INV0                                 GPIOA->CR0.MBIT.INV0            //[7] PA0 pin input inverse enable bit. 
#define PA_CR0_PU0                                  GPIOA->CR0.MBIT.PU0             //[5] PA0 pin pull-up resister enable bit. 
#define PA_CR0_HS0                                  GPIOA->CR0.MBIT.HS0             //[3] PA0 pin output high speed mode enable bit. 
#define PA_CR0_IOM0                                 GPIOA->CR0.MBIT.IOM0            //[2..0] PA0 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR1  [register's definitions]
 *              Offset[0x04]  PA1 IO control register (0x44000004)
 ******************************************************************************
 */
///@{
#define PA_CR1                                      GPIOA->CR1.W                    /*!< Offset[0x04]  PA1 IO control register (0x44000004) */

/* Bit fields of PA_CR1 */
#define PA_CR1_AFS1                                 GPIOA->CR1.MBIT.AFS1            //[15..12] PA1 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR1_FDIV1                                GPIOA->CR1.MBIT.FDIV1           //[11..10] PA1 pin input deglitch filter clock divider select. 
#define PA_CR1_ODC1                                 GPIOA->CR1.MBIT.ODC1            //[9] PA1 pin output drive strength select. 
#define PA_CR1_INV1                                 GPIOA->CR1.MBIT.INV1            //[7] PA1 pin input inverse enable bit. 
#define PA_CR1_PU1                                  GPIOA->CR1.MBIT.PU1             //[5] PA1 pin pull-up resister enable bit. 
#define PA_CR1_HS1                                  GPIOA->CR1.MBIT.HS1             //[3] PA1 pin output high speed mode enable bit. 
#define PA_CR1_IOM1                                 GPIOA->CR1.MBIT.IOM1            //[2..0] PA1 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR2  [register's definitions]
 *              Offset[0x08]  PA2 IO control register (0x44000008)
 ******************************************************************************
 */
///@{
#define PA_CR2                                      GPIOA->CR2.W                    /*!< Offset[0x08]  PA2 IO control register (0x44000008) */

/* Bit fields of PA_CR2 */
#define PA_CR2_AFS2                                 GPIOA->CR2.MBIT.AFS2            //[15..12] PA2 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR2_FDIV2                                GPIOA->CR2.MBIT.FDIV2           //[11..10] PA2 pin input deglitch filter clock divider select. 
#define PA_CR2_ODC2                                 GPIOA->CR2.MBIT.ODC2            //[9] PA2 pin output drive strength select. 
#define PA_CR2_INV2                                 GPIOA->CR2.MBIT.INV2            //[7] PA2 pin input inverse enable bit. 
#define PA_CR2_PU2                                  GPIOA->CR2.MBIT.PU2             //[5] PA2 pin pull-up resister enable bit. 
#define PA_CR2_HS2                                  GPIOA->CR2.MBIT.HS2             //[3] PA2 pin output high speed mode enable bit. 
#define PA_CR2_IOM2                                 GPIOA->CR2.MBIT.IOM2            //[2..0] PA2 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR3  [register's definitions]
 *              Offset[0x0C]  PA3 IO control register (0x4400000C)
 ******************************************************************************
 */
///@{
#define PA_CR3                                      GPIOA->CR3.W                    /*!< Offset[0x0C]  PA3 IO control register (0x4400000C) */

/* Bit fields of PA_CR3 */
#define PA_CR3_AFS3                                 GPIOA->CR3.MBIT.AFS3            //[15..12] PA3 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR3_FDIV3                                GPIOA->CR3.MBIT.FDIV3           //[11..10] PA3 pin input deglitch filter clock divider select. 
#define PA_CR3_ODC3                                 GPIOA->CR3.MBIT.ODC3            //[9] PA3 pin output drive strength select. 
#define PA_CR3_INV3                                 GPIOA->CR3.MBIT.INV3            //[7] PA3 pin input inverse enable bit. 
#define PA_CR3_PU3                                  GPIOA->CR3.MBIT.PU3             //[5] PA3 pin pull-up resister enable bit. 
#define PA_CR3_HS3                                  GPIOA->CR3.MBIT.HS3             //[3] PA3 pin output high speed mode enable bit. 
#define PA_CR3_IOM3                                 GPIOA->CR3.MBIT.IOM3            //[2..0] PA3 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR4  [register's definitions]
 *              Offset[0x10]  PA4 IO control register (0x44000010)
 ******************************************************************************
 */
///@{
#define PA_CR4                                      GPIOA->CR4.W                    /*!< Offset[0x10]  PA4 IO control register (0x44000010) */

/* Bit fields of PA_CR4 */
#define PA_CR4_AFS4                                 GPIOA->CR4.MBIT.AFS4            //[15..12] PA4 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR4_FDIV4                                GPIOA->CR4.MBIT.FDIV4           //[11..10] PA4 pin input deglitch filter clock divider select. 
#define PA_CR4_ODC4                                 GPIOA->CR4.MBIT.ODC4            //[9] PA4 pin output drive strength select. 
#define PA_CR4_INV4                                 GPIOA->CR4.MBIT.INV4            //[7] PA4 pin input inverse enable bit. 
#define PA_CR4_PU4                                  GPIOA->CR4.MBIT.PU4             //[5] PA4 pin pull-up resister enable bit. 
#define PA_CR4_HS4                                  GPIOA->CR4.MBIT.HS4             //[3] PA4 pin output high speed mode enable bit. 
#define PA_CR4_IOM4                                 GPIOA->CR4.MBIT.IOM4            //[2..0] PA4 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR5  [register's definitions]
 *              Offset[0x14]  PA5 IO control register (0x44000014)
 ******************************************************************************
 */
///@{
#define PA_CR5                                      GPIOA->CR5.W                    /*!< Offset[0x14]  PA5 IO control register (0x44000014) */

/* Bit fields of PA_CR5 */
#define PA_CR5_AFS5                                 GPIOA->CR5.MBIT.AFS5            //[15..12] PA5 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR5_FDIV5                                GPIOA->CR5.MBIT.FDIV5           //[11..10] PA5 pin input deglitch filter clock divider select. 
#define PA_CR5_ODC5                                 GPIOA->CR5.MBIT.ODC5            //[9] PA5 pin output drive strength select. 
#define PA_CR5_INV5                                 GPIOA->CR5.MBIT.INV5            //[7] PA5 pin input inverse enable bit. 
#define PA_CR5_PU5                                  GPIOA->CR5.MBIT.PU5             //[5] PA5 pin pull-up resister enable bit. 
#define PA_CR5_HS5                                  GPIOA->CR5.MBIT.HS5             //[3] PA5 pin output high speed mode enable bit. 
#define PA_CR5_IOM5                                 GPIOA->CR5.MBIT.IOM5            //[2..0] PA5 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR6  [register's definitions]
 *              Offset[0x18]  PA6 IO control register (0x44000018)
 ******************************************************************************
 */
///@{
#define PA_CR6                                      GPIOA->CR6.W                    /*!< Offset[0x18]  PA6 IO control register (0x44000018) */

/* Bit fields of PA_CR6 */
#define PA_CR6_AFS6                                 GPIOA->CR6.MBIT.AFS6            //[15..12] PA6 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR6_FDIV6                                GPIOA->CR6.MBIT.FDIV6           //[11..10] PA6 pin input deglitch filter clock divider select. 
#define PA_CR6_ODC6                                 GPIOA->CR6.MBIT.ODC6            //[9] PA6 pin output drive strength select. 
#define PA_CR6_INV6                                 GPIOA->CR6.MBIT.INV6            //[7] PA6 pin input inverse enable bit. 
#define PA_CR6_PU6                                  GPIOA->CR6.MBIT.PU6             //[5] PA6 pin pull-up resister enable bit. 
#define PA_CR6_HS6                                  GPIOA->CR6.MBIT.HS6             //[3] PA6 pin output high speed mode enable bit. 
#define PA_CR6_IOM6                                 GPIOA->CR6.MBIT.IOM6            //[2..0] PA6 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR7  [register's definitions]
 *              Offset[0x1C]  PA7 IO control register (0x4400001C)
 ******************************************************************************
 */
///@{
#define PA_CR7                                      GPIOA->CR7.W                    /*!< Offset[0x1C]  PA7 IO control register (0x4400001C) */

/* Bit fields of PA_CR7 */
#define PA_CR7_AFS7                                 GPIOA->CR7.MBIT.AFS7            //[15..12] PA7 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR7_FDIV7                                GPIOA->CR7.MBIT.FDIV7           //[11..10] PA7 pin input deglitch filter clock divider select. 
#define PA_CR7_ODC7                                 GPIOA->CR7.MBIT.ODC7            //[9] PA7 pin output drive strength select. 
#define PA_CR7_INV7                                 GPIOA->CR7.MBIT.INV7            //[7] PA7 pin input inverse enable bit. 
#define PA_CR7_PU7                                  GPIOA->CR7.MBIT.PU7             //[5] PA7 pin pull-up resister enable bit. 
#define PA_CR7_HS7                                  GPIOA->CR7.MBIT.HS7             //[3] PA7 pin output high speed mode enable bit. 
#define PA_CR7_IOM7                                 GPIOA->CR7.MBIT.IOM7            //[2..0] PA7 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR8  [register's definitions]
 *              Offset[0x20]  PA8 IO control register (0x44000020)
 ******************************************************************************
 */
///@{
#define PA_CR8                                      GPIOA->CR8.W                    /*!< Offset[0x20]  PA8 IO control register (0x44000020) */

/* Bit fields of PA_CR8 */
#define PA_CR8_AFS8                                 GPIOA->CR8.MBIT.AFS8            //[15..12] PA8 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR8_FDIV8                                GPIOA->CR8.MBIT.FDIV8           //[11..10] PA8 pin input deglitch filter clock divider select. 
#define PA_CR8_ODC8                                 GPIOA->CR8.MBIT.ODC8            //[9] PA8 pin output drive strength select. 
#define PA_CR8_INV8                                 GPIOA->CR8.MBIT.INV8            //[7] PA8 pin input inverse enable bit. 
#define PA_CR8_PU8                                  GPIOA->CR8.MBIT.PU8             //[5] PA8 pin pull-up resister enable bit. 
#define PA_CR8_HS8                                  GPIOA->CR8.MBIT.HS8             //[3] PA8 pin output high speed mode enable bit. 
#define PA_CR8_IOM8                                 GPIOA->CR8.MBIT.IOM8            //[2..0] PA8 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR9  [register's definitions]
 *              Offset[0x24]  PA9 IO control register (0x44000024)
 ******************************************************************************
 */
///@{
#define PA_CR9                                      GPIOA->CR9.W                    /*!< Offset[0x24]  PA9 IO control register (0x44000024) */

/* Bit fields of PA_CR9 */
#define PA_CR9_AFS9                                 GPIOA->CR9.MBIT.AFS9            //[15..12] PA9 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR9_FDIV9                                GPIOA->CR9.MBIT.FDIV9           //[11..10] PA9 pin input deglitch filter clock divider select. 
#define PA_CR9_ODC9                                 GPIOA->CR9.MBIT.ODC9            //[9] PA9 pin output drive strength select. 
#define PA_CR9_INV9                                 GPIOA->CR9.MBIT.INV9            //[7] PA9 pin input inverse enable bit. 
#define PA_CR9_PU9                                  GPIOA->CR9.MBIT.PU9             //[5] PA9 pin pull-up resister enable bit. 
#define PA_CR9_HS9                                  GPIOA->CR9.MBIT.HS9             //[3] PA9 pin output high speed mode enable bit. 
#define PA_CR9_IOM9                                 GPIOA->CR9.MBIT.IOM9            //[2..0] PA9 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR10  [register's definitions]
 *              Offset[0x28]  PA10 IO control register (0x44000028)
 ******************************************************************************
 */
///@{
#define PA_CR10                                     GPIOA->CR10.W                   /*!< Offset[0x28]  PA10 IO control register (0x44000028) */

/* Bit fields of PA_CR10 */
#define PA_CR10_AFS10                               GPIOA->CR10.MBIT.AFS10          //[15..12] PA10 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR10_FDIV10                              GPIOA->CR10.MBIT.FDIV10         //[11..10] PA10 pin input deglitch filter clock divider select. 
#define PA_CR10_ODC10                               GPIOA->CR10.MBIT.ODC10          //[9] PA10 pin output drive strength select. 
#define PA_CR10_INV10                               GPIOA->CR10.MBIT.INV10          //[7] PA10 pin input inverse enable bit. 
#define PA_CR10_PU10                                GPIOA->CR10.MBIT.PU10           //[5] PA10 pin pull-up resister enable bit. 
#define PA_CR10_HS10                                GPIOA->CR10.MBIT.HS10           //[3] PA10 pin output high speed mode enable bit. 
#define PA_CR10_IOM10                               GPIOA->CR10.MBIT.IOM10          //[2..0] PA10 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR11  [register's definitions]
 *              Offset[0x2C]  PA11 IO control register (0x4400002C)
 ******************************************************************************
 */
///@{
#define PA_CR11                                     GPIOA->CR11.W                   /*!< Offset[0x2C]  PA11 IO control register (0x4400002C) */

/* Bit fields of PA_CR11 */
#define PA_CR11_AFS11                               GPIOA->CR11.MBIT.AFS11          //[15..12] PA11 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR11_FDIV11                              GPIOA->CR11.MBIT.FDIV11         //[11..10] PA11 pin input deglitch filter clock divider select. 
#define PA_CR11_ODC11                               GPIOA->CR11.MBIT.ODC11          //[9] PA11 pin output drive strength select. 
#define PA_CR11_INV11                               GPIOA->CR11.MBIT.INV11          //[7] PA11 pin input inverse enable bit. 
#define PA_CR11_PU11                                GPIOA->CR11.MBIT.PU11           //[5] PA11 pin pull-up resister enable bit. 
#define PA_CR11_HS11                                GPIOA->CR11.MBIT.HS11           //[3] PA11 pin output high speed mode enable bit. 
#define PA_CR11_IOM11                               GPIOA->CR11.MBIT.IOM11          //[2..0] PA11 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR12  [register's definitions]
 *              Offset[0x30]  PA12 IO control register (0x44000030)
 ******************************************************************************
 */
///@{
#define PA_CR12                                     GPIOA->CR12.W                   /*!< Offset[0x30]  PA12 IO control register (0x44000030) */

/* Bit fields of PA_CR12 */
#define PA_CR12_AFS12                               GPIOA->CR12.MBIT.AFS12          //[15..12] PA12 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR12_FDIV12                              GPIOA->CR12.MBIT.FDIV12         //[11..10] PA12 pin input deglitch filter clock divider select. 
#define PA_CR12_ODC12                               GPIOA->CR12.MBIT.ODC12          //[9] PA12 pin output drive strength select. 
#define PA_CR12_INV12                               GPIOA->CR12.MBIT.INV12          //[7] PA12 pin input inverse enable bit. 
#define PA_CR12_PU12                                GPIOA->CR12.MBIT.PU12           //[5] PA12 pin pull-up resister enable bit. 
#define PA_CR12_HS12                                GPIOA->CR12.MBIT.HS12           //[3] PA12 pin output high speed mode enable bit. 
#define PA_CR12_IOM12                               GPIOA->CR12.MBIT.IOM12          //[2..0] PA12 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR13  [register's definitions]
 *              Offset[0x34]  PA13 IO control register (0x44000034)
 ******************************************************************************
 */
///@{
#define PA_CR13                                     GPIOA->CR13.W                   /*!< Offset[0x34]  PA13 IO control register (0x44000034) */

/* Bit fields of PA_CR13 */
#define PA_CR13_AFS13                               GPIOA->CR13.MBIT.AFS13          //[15..12] PA13 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR13_FDIV13                              GPIOA->CR13.MBIT.FDIV13         //[11..10] PA13 pin input deglitch filter clock divider select. 
#define PA_CR13_ODC13                               GPIOA->CR13.MBIT.ODC13          //[9] PA13 pin output drive strength select. 
#define PA_CR13_INV13                               GPIOA->CR13.MBIT.INV13          //[7] PA13 pin input inverse enable bit. 
#define PA_CR13_PU13                                GPIOA->CR13.MBIT.PU13           //[5] PA13 pin pull-up resister enable bit. 
#define PA_CR13_HS13                                GPIOA->CR13.MBIT.HS13           //[3] PA13 pin output high speed mode enable bit. 
#define PA_CR13_IOM13                               GPIOA->CR13.MBIT.IOM13          //[2..0] PA13 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR14  [register's definitions]
 *              Offset[0x38]  PA14 IO control register (0x44000038)
 ******************************************************************************
 */
///@{
#define PA_CR14                                     GPIOA->CR14.W                   /*!< Offset[0x38]  PA14 IO control register (0x44000038) */

/* Bit fields of PA_CR14 */
#define PA_CR14_AFS14                               GPIOA->CR14.MBIT.AFS14          //[15..12] PA14 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR14_FDIV14                              GPIOA->CR14.MBIT.FDIV14         //[11..10] PA14 pin input deglitch filter clock divider select. 
#define PA_CR14_ODC14                               GPIOA->CR14.MBIT.ODC14          //[9] PA14 pin output drive strength select. 
#define PA_CR14_INV14                               GPIOA->CR14.MBIT.INV14          //[7] PA14 pin input inverse enable bit. 
#define PA_CR14_PU14                                GPIOA->CR14.MBIT.PU14           //[5] PA14 pin pull-up resister enable bit. 
#define PA_CR14_HS14                                GPIOA->CR14.MBIT.HS14           //[3] PA14 pin output high speed mode enable bit. 
#define PA_CR14_IOM14                               GPIOA->CR14.MBIT.IOM14          //[2..0] PA14 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_CR15  [register's definitions]
 *              Offset[0x3C]  PA15 IO control register (0x4400003C)
 ******************************************************************************
 */
///@{
#define PA_CR15                                     GPIOA->CR15.W                   /*!< Offset[0x3C]  PA15 IO control register (0x4400003C) */

/* Bit fields of PA_CR15 */
#define PA_CR15_AFS15                               GPIOA->CR15.MBIT.AFS15          //[15..12] PA15 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PA_CR15_FDIV15                              GPIOA->CR15.MBIT.FDIV15         //[11..10] PA15 pin input deglitch filter clock divider select. 
#define PA_CR15_ODC15                               GPIOA->CR15.MBIT.ODC15          //[9] PA15 pin output drive strength select. 
#define PA_CR15_INV15                               GPIOA->CR15.MBIT.INV15          //[7] PA15 pin input inverse enable bit. 
#define PA_CR15_PU15                                GPIOA->CR15.MBIT.PU15           //[5] PA15 pin pull-up resister enable bit. 
#define PA_CR15_HS15                                GPIOA->CR15.MBIT.HS15           //[3] PA15 pin output high speed mode enable bit. 
#define PA_CR15_IOM15                               GPIOA->CR15.MBIT.IOM15          //[2..0] PA15 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PA_FLT  [register's definitions]
 *              Offset[0x40]  PA port input filter control register (0x44000040)
 ******************************************************************************
 */
///@{
#define PA_FLT                                      GPIOA->FLT.W                    /*!< Offset[0x40]  PA port input filter control register (0x44000040) */

/* Bit fields of PA_FLT */
#define PA_FLT_FCKS                                 GPIOA->FLT.MBIT.FCKS            //[2..0] PA port input deglitch filter clock source select for all pins of the port. 
///@}

/*----------------------------------------------------------------------------*/
/* @module      PB (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PB_CR0  [register's definitions]
 *              Offset[0x00]  PB0 IO control register (0x44010000)
 ******************************************************************************
 */
///@{
#define PB_CR0                                      GPIOB->CR0.W                    /*!< Offset[0x00]  PB0 IO control register (0x44010000) */

/* Bit fields of PB_CR0 */
#define PB_CR0_AFS0                                 GPIOB->CR0.MBIT.AFS0            //[15..12] PB0 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR0_FDIV0                                GPIOB->CR0.MBIT.FDIV0           //[11..10] PB0 pin input deglitch filter clock divider select. 
#define PB_CR0_ODC0                                 GPIOB->CR0.MBIT.ODC0            //[9] PB0 pin output drive strength select. 
#define PB_CR0_INV0                                 GPIOB->CR0.MBIT.INV0            //[7] PB0 pin input inverse enable bit. 
#define PB_CR0_PU0                                  GPIOB->CR0.MBIT.PU0             //[5] PB0 pin pull-up resister enable bit. 
#define PB_CR0_IOM0                                 GPIOB->CR0.MBIT.IOM0            //[2..0] PB0 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR1  [register's definitions]
 *              Offset[0x04]  PB1 IO control register (0x44010004)
 ******************************************************************************
 */
///@{
#define PB_CR1                                      GPIOB->CR1.W                    /*!< Offset[0x04]  PB1 IO control register (0x44010004) */

/* Bit fields of PB_CR1 */
#define PB_CR1_AFS1                                 GPIOB->CR1.MBIT.AFS1            //[15..12] PB1 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR1_FDIV1                                GPIOB->CR1.MBIT.FDIV1           //[11..10] PB1 pin input deglitch filter clock divider select. 
#define PB_CR1_ODC1                                 GPIOB->CR1.MBIT.ODC1            //[9] PB1 pin output drive strength select. 
#define PB_CR1_INV1                                 GPIOB->CR1.MBIT.INV1            //[7] PB1 pin input inverse enable bit. 
#define PB_CR1_PU1                                  GPIOB->CR1.MBIT.PU1             //[5] PB1 pin pull-up resister enable bit. 
#define PB_CR1_IOM1                                 GPIOB->CR1.MBIT.IOM1            //[2..0] PB1 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR2  [register's definitions]
 *              Offset[0x08]  PB2 IO control register (0x44010008)
 ******************************************************************************
 */
///@{
#define PB_CR2                                      GPIOB->CR2.W                    /*!< Offset[0x08]  PB2 IO control register (0x44010008) */

/* Bit fields of PB_CR2 */
#define PB_CR2_AFS2                                 GPIOB->CR2.MBIT.AFS2            //[15..12] PB2 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR2_FDIV2                                GPIOB->CR2.MBIT.FDIV2           //[11..10] PB2 pin input deglitch filter clock divider select. 
#define PB_CR2_ODC2                                 GPIOB->CR2.MBIT.ODC2            //[9] PB2 pin output drive strength select. 
#define PB_CR2_INV2                                 GPIOB->CR2.MBIT.INV2            //[7] PB2 pin input inverse enable bit. 
#define PB_CR2_PU2                                  GPIOB->CR2.MBIT.PU2             //[5] PB2 pin pull-up resister enable bit. 
#define PB_CR2_IOM2                                 GPIOB->CR2.MBIT.IOM2            //[2..0] PB2 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR3  [register's definitions]
 *              Offset[0x0C]  PB3 IO control register (0x4401000C)
 ******************************************************************************
 */
///@{
#define PB_CR3                                      GPIOB->CR3.W                    /*!< Offset[0x0C]  PB3 IO control register (0x4401000C) */

/* Bit fields of PB_CR3 */
#define PB_CR3_AFS3                                 GPIOB->CR3.MBIT.AFS3            //[15..12] PB3 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR3_FDIV3                                GPIOB->CR3.MBIT.FDIV3           //[11..10] PB3 pin input deglitch filter clock divider select. 
#define PB_CR3_ODC3                                 GPIOB->CR3.MBIT.ODC3            //[9] PB3 pin output drive strength select. 
#define PB_CR3_INV3                                 GPIOB->CR3.MBIT.INV3            //[7] PB3 pin input inverse enable bit. 
#define PB_CR3_PU3                                  GPIOB->CR3.MBIT.PU3             //[5] PB3 pin pull-up resister enable bit. 
#define PB_CR3_IOM3                                 GPIOB->CR3.MBIT.IOM3            //[2..0] PB3 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR4  [register's definitions]
 *              Offset[0x10]  PB4 IO control register (0x44010010)
 ******************************************************************************
 */
///@{
#define PB_CR4                                      GPIOB->CR4.W                    /*!< Offset[0x10]  PB4 IO control register (0x44010010) */

/* Bit fields of PB_CR4 */
#define PB_CR4_AFS4                                 GPIOB->CR4.MBIT.AFS4            //[15..12] PB4 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR4_FDIV4                                GPIOB->CR4.MBIT.FDIV4           //[11..10] PB4 pin input deglitch filter clock divider select. 
#define PB_CR4_ODC4                                 GPIOB->CR4.MBIT.ODC4            //[9] PB4 pin output drive strength select. 
#define PB_CR4_INV4                                 GPIOB->CR4.MBIT.INV4            //[7] PB4 pin input inverse enable bit. 
#define PB_CR4_PU4                                  GPIOB->CR4.MBIT.PU4             //[5] PB4 pin pull-up resister enable bit. 
#define PB_CR4_IOM4                                 GPIOB->CR4.MBIT.IOM4            //[2..0] PB4 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR5  [register's definitions]
 *              Offset[0x14]  PB5 IO control register (0x44010014)
 ******************************************************************************
 */
///@{
#define PB_CR5                                      GPIOB->CR5.W                    /*!< Offset[0x14]  PB5 IO control register (0x44010014) */

/* Bit fields of PB_CR5 */
#define PB_CR5_AFS5                                 GPIOB->CR5.MBIT.AFS5            //[15..12] PB5 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR5_FDIV5                                GPIOB->CR5.MBIT.FDIV5           //[11..10] PB5 pin input deglitch filter clock divider select. 
#define PB_CR5_ODC5                                 GPIOB->CR5.MBIT.ODC5            //[9] PB5 pin output drive strength select. 
#define PB_CR5_INV5                                 GPIOB->CR5.MBIT.INV5            //[7] PB5 pin input inverse enable bit. 
#define PB_CR5_PU5                                  GPIOB->CR5.MBIT.PU5             //[5] PB5 pin pull-up resister enable bit. 
#define PB_CR5_IOM5                                 GPIOB->CR5.MBIT.IOM5            //[2..0] PB5 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR6  [register's definitions]
 *              Offset[0x18]  PB6 IO control register (0x44010018)
 ******************************************************************************
 */
///@{
#define PB_CR6                                      GPIOB->CR6.W                    /*!< Offset[0x18]  PB6 IO control register (0x44010018) */

/* Bit fields of PB_CR6 */
#define PB_CR6_AFS6                                 GPIOB->CR6.MBIT.AFS6            //[15..12] PB6 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR6_FDIV6                                GPIOB->CR6.MBIT.FDIV6           //[11..10] PB6 pin input deglitch filter clock divider select. 
#define PB_CR6_ODC6                                 GPIOB->CR6.MBIT.ODC6            //[9] PB6 pin output drive strength select. 
#define PB_CR6_INV6                                 GPIOB->CR6.MBIT.INV6            //[7] PB6 pin input inverse enable bit. 
#define PB_CR6_PU6                                  GPIOB->CR6.MBIT.PU6             //[5] PB6 pin pull-up resister enable bit. 
#define PB_CR6_IOM6                                 GPIOB->CR6.MBIT.IOM6            //[2..0] PB6 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR7  [register's definitions]
 *              Offset[0x1C]  PB7 IO control register (0x4401001C)
 ******************************************************************************
 */
///@{
#define PB_CR7                                      GPIOB->CR7.W                    /*!< Offset[0x1C]  PB7 IO control register (0x4401001C) */

/* Bit fields of PB_CR7 */
#define PB_CR7_AFS7                                 GPIOB->CR7.MBIT.AFS7            //[15..12] PB7 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR7_FDIV7                                GPIOB->CR7.MBIT.FDIV7           //[11..10] PB7 pin input deglitch filter clock divider select. 
#define PB_CR7_ODC7                                 GPIOB->CR7.MBIT.ODC7            //[9] PB7 pin output drive strength select. 
#define PB_CR7_INV7                                 GPIOB->CR7.MBIT.INV7            //[7] PB7 pin input inverse enable bit. 
#define PB_CR7_PU7                                  GPIOB->CR7.MBIT.PU7             //[5] PB7 pin pull-up resister enable bit. 
#define PB_CR7_IOM7                                 GPIOB->CR7.MBIT.IOM7            //[2..0] PB7 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR8  [register's definitions]
 *              Offset[0x20]  PB8 IO control register (0x44010020)
 ******************************************************************************
 */
///@{
#define PB_CR8                                      GPIOB->CR8.W                    /*!< Offset[0x20]  PB8 IO control register (0x44010020) */

/* Bit fields of PB_CR8 */
#define PB_CR8_AFS8                                 GPIOB->CR8.MBIT.AFS8            //[15..12] PB8 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR8_FDIV8                                GPIOB->CR8.MBIT.FDIV8           //[11..10] PB8 pin input deglitch filter clock divider select. 
#define PB_CR8_ODC8                                 GPIOB->CR8.MBIT.ODC8            //[9] PB8 pin output drive strength select. 
#define PB_CR8_INV8                                 GPIOB->CR8.MBIT.INV8            //[7] PB8 pin input inverse enable bit. 
#define PB_CR8_PU8                                  GPIOB->CR8.MBIT.PU8             //[5] PB8 pin pull-up resister enable bit. 
#define PB_CR8_IOM8                                 GPIOB->CR8.MBIT.IOM8            //[2..0] PB8 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR9  [register's definitions]
 *              Offset[0x24]  PB9 IO control register (0x44010024)
 ******************************************************************************
 */
///@{
#define PB_CR9                                      GPIOB->CR9.W                    /*!< Offset[0x24]  PB9 IO control register (0x44010024) */

/* Bit fields of PB_CR9 */
#define PB_CR9_AFS9                                 GPIOB->CR9.MBIT.AFS9            //[15..12] PB9 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR9_FDIV9                                GPIOB->CR9.MBIT.FDIV9           //[11..10] PB9 pin input deglitch filter clock divider select. 
#define PB_CR9_ODC9                                 GPIOB->CR9.MBIT.ODC9            //[9] PB9 pin output drive strength select. 
#define PB_CR9_INV9                                 GPIOB->CR9.MBIT.INV9            //[7] PB9 pin input inverse enable bit. 
#define PB_CR9_PU9                                  GPIOB->CR9.MBIT.PU9             //[5] PB9 pin pull-up resister enable bit. 
#define PB_CR9_IOM9                                 GPIOB->CR9.MBIT.IOM9            //[2..0] PB9 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR10  [register's definitions]
 *              Offset[0x28]  PB10 IO control register (0x44010028)
 ******************************************************************************
 */
///@{
#define PB_CR10                                     GPIOB->CR10.W                   /*!< Offset[0x28]  PB10 IO control register (0x44010028) */

/* Bit fields of PB_CR10 */
#define PB_CR10_AFS10                               GPIOB->CR10.MBIT.AFS10          //[15..12] PB10 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR10_FDIV10                              GPIOB->CR10.MBIT.FDIV10         //[11..10] PB10 pin input deglitch filter clock divider select. 
#define PB_CR10_ODC10                               GPIOB->CR10.MBIT.ODC10          //[9] PB10 pin output drive strength select. 
#define PB_CR10_INV10                               GPIOB->CR10.MBIT.INV10          //[7] PB10 pin input inverse enable bit. 
#define PB_CR10_PU10                                GPIOB->CR10.MBIT.PU10           //[5] PB10 pin pull-up resister enable bit. 
#define PB_CR10_IOM10                               GPIOB->CR10.MBIT.IOM10          //[2..0] PB10 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR11  [register's definitions]
 *              Offset[0x2C]  PB11 IO control register (0x4401002C)
 ******************************************************************************
 */
///@{
#define PB_CR11                                     GPIOB->CR11.W                   /*!< Offset[0x2C]  PB11 IO control register (0x4401002C) */

/* Bit fields of PB_CR11 */
#define PB_CR11_AFS11                               GPIOB->CR11.MBIT.AFS11          //[15..12] PB11 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR11_FDIV11                              GPIOB->CR11.MBIT.FDIV11         //[11..10] PB11 pin input deglitch filter clock divider select. 
#define PB_CR11_ODC11                               GPIOB->CR11.MBIT.ODC11          //[9] PB11 pin output drive strength select. 
#define PB_CR11_INV11                               GPIOB->CR11.MBIT.INV11          //[7] PB11 pin input inverse enable bit. 
#define PB_CR11_PU11                                GPIOB->CR11.MBIT.PU11           //[5] PB11 pin pull-up resister enable bit. 
#define PB_CR11_IOM11                               GPIOB->CR11.MBIT.IOM11          //[2..0] PB11 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR12  [register's definitions]
 *              Offset[0x30]  PB12 IO control register (0x44010030)
 ******************************************************************************
 */
///@{
#define PB_CR12                                     GPIOB->CR12.W                   /*!< Offset[0x30]  PB12 IO control register (0x44010030) */

/* Bit fields of PB_CR12 */
#define PB_CR12_AFS12                               GPIOB->CR12.MBIT.AFS12          //[15..12] PB12 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR12_FDIV12                              GPIOB->CR12.MBIT.FDIV12         //[11..10] PB12 pin input deglitch filter clock divider select. 
#define PB_CR12_ODC12                               GPIOB->CR12.MBIT.ODC12          //[9] PB12 pin output drive strength select. 
#define PB_CR12_INV12                               GPIOB->CR12.MBIT.INV12          //[7] PB12 pin input inverse enable bit. 
#define PB_CR12_PU12                                GPIOB->CR12.MBIT.PU12           //[5] PB12 pin pull-up resister enable bit. 
#define PB_CR12_IOM12                               GPIOB->CR12.MBIT.IOM12          //[2..0] PB12 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_CR13  [register's definitions]
 *              Offset[0x34]  PB13 IO control register (0x44010034)
 ******************************************************************************
 */
///@{
#define PB_CR13                                     GPIOB->CR13.W                   /*!< Offset[0x34]  PB13 IO control register (0x44010034) */

/* Bit fields of PB_CR13 */
#define PB_CR13_AFS13                               GPIOB->CR13.MBIT.AFS13          //[15..12] PB13 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR13_FDIV13                              GPIOB->CR13.MBIT.FDIV13         //[11..10] PB13 pin input deglitch filter clock divider select. 
#define PB_CR13_ODC13                               GPIOB->CR13.MBIT.ODC13          //[9] PB13 pin output drive strength select. 
#define PB_CR13_INV13                               GPIOB->CR13.MBIT.INV13          //[7] PB13 pin input inverse enable bit. 
#define PB_CR13_PU13                                GPIOB->CR13.MBIT.PU13           //[5] PB13 pin pull-up resister enable bit. 
#define PB_CR13_IOM13                               GPIOB->CR13.MBIT.IOM13          //[2..0] PB13 pin IO mode control bits 
///@}
/**
 ******************************************************************************
 * @name        PB_CR14  [register's definitions]
 *              Offset[0x38]  PB14 IO control register (0x44010038)
 ******************************************************************************
 */
///@{
#define PB_CR14                                     GPIOB->CR14.W                   /*!< Offset[0x38]  PB14 IO control register (0x44010038) */

/* Bit fields of PB_CR14 */
#define PB_CR14_AFS14                               GPIOB->CR14.MBIT.AFS14          //[15..12] PB14 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR14_FDIV14                              GPIOB->CR14.MBIT.FDIV14         //[11..10] PB14 pin input deglitch filter clock divider select. 
#define PB_CR14_ODC14                               GPIOB->CR14.MBIT.ODC14          //[9] PB14 pin output drive strength select. 
#define PB_CR14_INV14                               GPIOB->CR14.MBIT.INV14          //[7] PB14 pin input inverse enable bit. 
#define PB_CR14_PU14                                GPIOB->CR14.MBIT.PU14           //[5] PB14 pin pull-up resister enable bit. 
#define PB_CR14_IOM14                               GPIOB->CR14.MBIT.IOM14          //[2..0] PB14 pin IO mode control bits 
///@}
/**
 ******************************************************************************
 * @name        PB_CR15  [register's definitions]
 *              Offset[0x3C]  PB15 IO control register (0x4401003C)
 ******************************************************************************
 */
///@{
#define PB_CR15                                     GPIOB->CR15.W                   /*!< Offset[0x3C]  PB15 IO control register (0x4401003C) */

/* Bit fields of PB_CR15 */
#define PB_CR15_AFS15                               GPIOB->CR15.MBIT.AFS15          //[15..12] PB15 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PB_CR15_FDIV15                              GPIOB->CR15.MBIT.FDIV15         //[11..10] PB15 pin input deglitch filter clock divider select. 
#define PB_CR15_ODC15                               GPIOB->CR15.MBIT.ODC15          //[9] PB15 pin output drive strength select. 
#define PB_CR15_INV15                               GPIOB->CR15.MBIT.INV15          //[7] PB15 pin input inverse enable bit. 
#define PB_CR15_PU15                                GPIOB->CR15.MBIT.PU15           //[5] PB15 pin pull-up resister enable bit. 
#define PB_CR15_IOM15                               GPIOB->CR15.MBIT.IOM15          //[2..0] PB15 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PB_FLT  [register's definitions]
 *              Offset[0x40]  PB port input filter control register (0x44010040)
 ******************************************************************************
 */
///@{
#define PB_FLT                                      GPIOB->FLT.W                    /*!< Offset[0x40]  PB port input filter control register (0x44010040) */

/* Bit fields of PB_FLT */
#define PB_FLT_FCKS                                 GPIOB->FLT.MBIT.FCKS            //[2..0] PB port input deglitch filter clock source select for all pins of the port. 
///@}

/*----------------------------------------------------------------------------*/
/* @module      PC (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PC_CR0  [register's definitions]
 *              Offset[0x00]  PC0 IO control register (0x44020000)
 ******************************************************************************
 */
///@{
#define PC_CR0                                      GPIOC->CR0.W                    /*!< Offset[0x00]  PC0 IO control register (0x44020000) */

/* Bit fields of PC_CR0 */
#define PC_CR0_AFS0                                 GPIOC->CR0.MBIT.AFS0            //[15..12] PC0 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR0_FDIV0                                GPIOC->CR0.MBIT.FDIV0           //[11..10] PC0 pin input deglitch filter clock divider select. 
#define PC_CR0_ODC0                                 GPIOC->CR0.MBIT.ODC0            //[9] PC0 pin output drive strength select. 
#define PC_CR0_INV0                                 GPIOC->CR0.MBIT.INV0            //[7] PC0 pin input inverse enable bit. 
#define PC_CR0_PU0                                  GPIOC->CR0.MBIT.PU0             //[5] PC0 pin pull-up resister enable bit. 
#define PC_CR0_HS0                                  GPIOC->CR0.MBIT.HS0             //[3] PC0 pin output high speed mode enable bit. 
#define PC_CR0_IOM0                                 GPIOC->CR0.MBIT.IOM0            //[2..0] PC0 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR1  [register's definitions]
 *              Offset[0x04]  PC1 IO control register (0x44020004)
 ******************************************************************************
 */
///@{
#define PC_CR1                                      GPIOC->CR1.W                    /*!< Offset[0x04]  PC1 IO control register (0x44020004) */

/* Bit fields of PC_CR1 */
#define PC_CR1_AFS1                                 GPIOC->CR1.MBIT.AFS1            //[15..12] PC1 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR1_FDIV1                                GPIOC->CR1.MBIT.FDIV1           //[11..10] PC1 pin input deglitch filter clock divider select. 
#define PC_CR1_ODC1                                 GPIOC->CR1.MBIT.ODC1            //[9] PC1 pin output drive strength select. 
#define PC_CR1_INV1                                 GPIOC->CR1.MBIT.INV1            //[7] PC1 pin input inverse enable bit. 
#define PC_CR1_PU1                                  GPIOC->CR1.MBIT.PU1             //[5] PC1 pin pull-up resister enable bit. 
#define PC_CR1_HS1                                  GPIOC->CR1.MBIT.HS1             //[3] PC1 pin output high speed mode enable bit. 
#define PC_CR1_IOM1                                 GPIOC->CR1.MBIT.IOM1            //[2..0] PC1 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR2  [register's definitions]
 *              Offset[0x08]  PC2 IO control register (0x44020008)
 ******************************************************************************
 */
///@{
#define PC_CR2                                      GPIOC->CR2.W                    /*!< Offset[0x08]  PC2 IO control register (0x44020008) */

/* Bit fields of PC_CR2 */
#define PC_CR2_AFS2                                 GPIOC->CR2.MBIT.AFS2            //[15..12] PC2 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR2_FDIV2                                GPIOC->CR2.MBIT.FDIV2           //[11..10] PC2 pin input deglitch filter clock divider select. 
#define PC_CR2_ODC2                                 GPIOC->CR2.MBIT.ODC2            //[9] PC2 pin output drive strength select. 
#define PC_CR2_INV2                                 GPIOC->CR2.MBIT.INV2            //[7] PC2 pin input inverse enable bit. 
#define PC_CR2_PU2                                  GPIOC->CR2.MBIT.PU2             //[5] PC2 pin pull-up resister enable bit. 
#define PC_CR2_HS2                                  GPIOC->CR2.MBIT.HS2             //[3] PC2 pin output high speed mode enable bit. 
#define PC_CR2_IOM2                                 GPIOC->CR2.MBIT.IOM2            //[2..0] PC2 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR3  [register's definitions]
 *              Offset[0x0C]  PC3 IO control register (0x4402000C)
 ******************************************************************************
 */
///@{
#define PC_CR3                                      GPIOC->CR3.W                    /*!< Offset[0x0C]  PC3 IO control register (0x4402000C) */

/* Bit fields of PC_CR3 */
#define PC_CR3_AFS3                                 GPIOC->CR3.MBIT.AFS3            //[15..12] PC3 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR3_FDIV3                                GPIOC->CR3.MBIT.FDIV3           //[11..10] PC3 pin input deglitch filter clock divider select. 
#define PC_CR3_ODC3                                 GPIOC->CR3.MBIT.ODC3            //[9] PC3 pin output drive strength select. 
#define PC_CR3_INV3                                 GPIOC->CR3.MBIT.INV3            //[7] PC3 pin input inverse enable bit. 
#define PC_CR3_PU3                                  GPIOC->CR3.MBIT.PU3             //[5] PC3 pin pull-up resister enable bit. 
#define PC_CR3_HS3                                  GPIOC->CR3.MBIT.HS3             //[3] PC3 pin output high speed mode enable bit. 
#define PC_CR3_IOM3                                 GPIOC->CR3.MBIT.IOM3            //[2..0] PC3 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR4  [register's definitions]
 *              Offset[0x10]  PC4 IO control register (0x44020010)
 ******************************************************************************
 */
///@{
#define PC_CR4                                      GPIOC->CR4.W                    /*!< Offset[0x10]  PC4 IO control register (0x44020010) */

/* Bit fields of PC_CR4 */
#define PC_CR4_LCK4                                 GPIOC->CR4.MBIT.LCK4            //[31] PC4 pin control register write un-locked control 
#define PC_CR4_AFS4                                 GPIOC->CR4.MBIT.AFS4            //[15..12] PC4 pin alternate function select 
#define PC_CR4_FDIV4                                GPIOC->CR4.MBIT.FDIV4           //[11..10] PC4 pin input deglitch filter clock divider select. 
#define PC_CR4_ODC4                                 GPIOC->CR4.MBIT.ODC4            //[9] PC4 pin output drive strength select. 
#define PC_CR4_INV4                                 GPIOC->CR4.MBIT.INV4            //[7] PC4 pin input inverse enable bit. 
#define PC_CR4_PU4                                  GPIOC->CR4.MBIT.PU4             //[5] PC4 pin pull-up resister enable bit. 
#define PC_CR4_IOM4                                 GPIOC->CR4.MBIT.IOM4            //[2..0] PC4 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR5  [register's definitions]
 *              Offset[0x14]  PC5 IO control register (0x44020014)
 ******************************************************************************
 */
///@{
#define PC_CR5                                      GPIOC->CR5.W                    /*!< Offset[0x14]  PC5 IO control register (0x44020014) */

/* Bit fields of PC_CR5 */
#define PC_CR5_LCK5                                 GPIOC->CR5.MBIT.LCK5            //[31] PC5 pin control register write un-locked control 
#define PC_CR5_AFS5                                 GPIOC->CR5.MBIT.AFS5            //[15..12] PC5 pin alternate function select 
#define PC_CR5_FDIV5                                GPIOC->CR5.MBIT.FDIV5           //[11..10] PC5 pin input deglitch filter clock divider select. 
#define PC_CR5_ODC5                                 GPIOC->CR5.MBIT.ODC5            //[9] PC5 pin output drive strength select. 
#define PC_CR5_INV5                                 GPIOC->CR5.MBIT.INV5            //[7] PC5 pin input inverse enable bit. 
#define PC_CR5_PU5                                  GPIOC->CR5.MBIT.PU5             //[5] PC5 pin pull-up resister enable bit. 
#define PC_CR5_IOM5                                 GPIOC->CR5.MBIT.IOM5            //[2..0] PC5 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR6  [register's definitions]
 *              Offset[0x18]  PC6 IO control register (0x44020018)
 ******************************************************************************
 */
///@{
#define PC_CR6                                      GPIOC->CR6.W                    /*!< Offset[0x18]  PC6 IO control register (0x44020018) */

/* Bit fields of PC_CR6 */
#define PC_CR6_LCK6                                 GPIOC->CR6.MBIT.LCK6            //[31] PC6 pin control register write un-locked control 
#define PC_CR6_AFS6                                 GPIOC->CR6.MBIT.AFS6            //[15..12] PC6 pin alternate function select 
#define PC_CR6_FDIV6                                GPIOC->CR6.MBIT.FDIV6           //[11..10] PC6 pin input deglitch filter clock divider select. 
#define PC_CR6_INV6                                 GPIOC->CR6.MBIT.INV6            //[7] PC6 pin input inverse enable bit. 
#define PC_CR6_PU6                                  GPIOC->CR6.MBIT.PU6             //[5] PC6 pin pull-up resister enable bit. 
#define PC_CR6_IOM6                                 GPIOC->CR6.MBIT.IOM6            //[2..0] PC6 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR7  [register's definitions]
 *              Offset[0x1C]  PC7 IO control register (0x4402001C)
 ******************************************************************************
 */
///@{
#define PC_CR7                                      GPIOC->CR7.W                    /*!< Offset[0x1C]  PC7 IO control register (0x4402001C) */

/* Bit fields of PC_CR7 */
#define PC_CR7_AFS7                                 GPIOC->CR7.MBIT.AFS7            //[15..12] PC7 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR7_FDIV7                                GPIOC->CR7.MBIT.FDIV7           //[11..10] PC7 pin input deglitch filter clock divider select. 
#define PC_CR7_ODC7                                 GPIOC->CR7.MBIT.ODC7            //[9] PC7 pin output drive strength select. 
#define PC_CR7_INV7                                 GPIOC->CR7.MBIT.INV7            //[7] PC7 pin input inverse enable bit. 
#define PC_CR7_PU7                                  GPIOC->CR7.MBIT.PU7             //[5] PC7 pin pull-up resister enable bit. 
#define PC_CR7_IOM7                                 GPIOC->CR7.MBIT.IOM7            //[2..0] PC7 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR8  [register's definitions]
 *              Offset[0x20]  PC8 IO control register (0x44020020)
 ******************************************************************************
 */
///@{
#define PC_CR8                                      GPIOC->CR8.W                    /*!< Offset[0x20]  PC8 IO control register (0x44020020) */

/* Bit fields of PC_CR8 */
#define PC_CR8_AFS8                                 GPIOC->CR8.MBIT.AFS8            //[15..12] PC8 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR8_FDIV8                                GPIOC->CR8.MBIT.FDIV8           //[11..10] PC8 pin input deglitch filter clock divider select. 
#define PC_CR8_ODC8                                 GPIOC->CR8.MBIT.ODC8            //[9] PC8 pin output drive strength select. 
#define PC_CR8_INV8                                 GPIOC->CR8.MBIT.INV8            //[7] PC8 pin input inverse enable bit. 
#define PC_CR8_PU8                                  GPIOC->CR8.MBIT.PU8             //[5] PC8 pin pull-up resister enable bit. 
#define PC_CR8_IOM8                                 GPIOC->CR8.MBIT.IOM8            //[2..0] PC8 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR9  [register's definitions]
 *              Offset[0x24]  PC9 IO control register (0x44020024)
 ******************************************************************************
 */
///@{
#define PC_CR9                                      GPIOC->CR9.W                    /*!< Offset[0x24]  PC9 IO control register (0x44020024) */

/* Bit fields of PC_CR9 */
#define PC_CR9_AFS9                                 GPIOC->CR9.MBIT.AFS9            //[15..12] PC9 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR9_FDIV9                                GPIOC->CR9.MBIT.FDIV9           //[11..10] PC9 pin input deglitch filter clock divider select. 
#define PC_CR9_ODC9                                 GPIOC->CR9.MBIT.ODC9            //[9] PC9 pin output drive strength select. 
#define PC_CR9_INV9                                 GPIOC->CR9.MBIT.INV9            //[7] PC9 pin input inverse enable bit. 
#define PC_CR9_PU9                                  GPIOC->CR9.MBIT.PU9             //[5] PC9 pin pull-up resister enable bit. 
#define PC_CR9_IOM9                                 GPIOC->CR9.MBIT.IOM9            //[2..0] PC9 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR10  [register's definitions]
 *              Offset[0x28]  PC10 IO control register (0x44020028)
 ******************************************************************************
 */
///@{
#define PC_CR10                                     GPIOC->CR10.W                   /*!< Offset[0x28]  PC10 IO control register (0x44020028) */

/* Bit fields of PC_CR10 */
#define PC_CR10_AFS10                               GPIOC->CR10.MBIT.AFS10          //[15..12] PC10 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR10_FDIV10                              GPIOC->CR10.MBIT.FDIV10         //[11..10] PC10 pin input deglitch filter clock divider select. 
#define PC_CR10_ODC10                               GPIOC->CR10.MBIT.ODC10          //[9] PC10 pin output drive strength select. 
#define PC_CR10_INV10                               GPIOC->CR10.MBIT.INV10          //[7] PC10 pin input inverse enable bit. 
#define PC_CR10_PU10                                GPIOC->CR10.MBIT.PU10           //[5] PC10 pin pull-up resister enable bit. 
#define PC_CR10_IOM10                               GPIOC->CR10.MBIT.IOM10          //[2..0] PC10 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR11  [register's definitions]
 *              Offset[0x2C]  PC11 IO control register (0x4402002C)
 ******************************************************************************
 */
///@{
#define PC_CR11                                     GPIOC->CR11.W                   /*!< Offset[0x2C]  PC11 IO control register (0x4402002C) */

/* Bit fields of PC_CR11 */
#define PC_CR11_AFS11                               GPIOC->CR11.MBIT.AFS11          //[15..12] PC11 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR11_FDIV11                              GPIOC->CR11.MBIT.FDIV11         //[11..10] PC11 pin input deglitch filter clock divider select. 
#define PC_CR11_ODC11                               GPIOC->CR11.MBIT.ODC11          //[9] PC11 pin output drive strength select. 
#define PC_CR11_INV11                               GPIOC->CR11.MBIT.INV11          //[7] PC11 pin input inverse enable bit. 
#define PC_CR11_PU11                                GPIOC->CR11.MBIT.PU11           //[5] PC11 pin pull-up resister enable bit. 
#define PC_CR11_IOM11                               GPIOC->CR11.MBIT.IOM11          //[2..0] PC11 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR12  [register's definitions]
 *              Offset[0x30]  PC12 IO control register (0x44020030)
 ******************************************************************************
 */
///@{
#define PC_CR12                                     GPIOC->CR12.W                   /*!< Offset[0x30]  PC12 IO control register (0x44020030) */

/* Bit fields of PC_CR12 */
#define PC_CR12_AFS12                               GPIOC->CR12.MBIT.AFS12          //[15..12] PC12 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PC_CR12_FDIV12                              GPIOC->CR12.MBIT.FDIV12         //[11..10] PC12 pin input deglitch filter clock divider select. 
#define PC_CR12_ODC12                               GPIOC->CR12.MBIT.ODC12          //[9] PC12 pin output drive strength select. 
#define PC_CR12_INV12                               GPIOC->CR12.MBIT.INV12          //[7] PC12 pin input inverse enable bit. 
#define PC_CR12_PU12                                GPIOC->CR12.MBIT.PU12           //[5] PC12 pin pull-up resister enable bit. 
#define PC_CR12_IOM12                               GPIOC->CR12.MBIT.IOM12          //[2..0] PC12 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PC_CR13  [register's definitions]
 *              Offset[0x34]  PC13 IO control register (0x44020034)
 ******************************************************************************
 */
///@{
#define PC_CR13                                     GPIOC->CR13.W                   /*!< Offset[0x34]  PC13 IO control register (0x44020034) */

/* Bit fields of PC_CR13 */
#define PC_CR13_AFS13                               GPIOC->CR13.MBIT.AFS13          //[15..12] PC13 pin alternate function select 
#define PC_CR13_FDIV13                              GPIOC->CR13.MBIT.FDIV13         //[11..10] PC13 pin input deglitch filter clock divider select. 
#define PC_CR13_INV13                               GPIOC->CR13.MBIT.INV13          //[7] PC13 pin input inverse enable bit. 
#define PC_CR13_PU13                                GPIOC->CR13.MBIT.PU13           //[5] PC13 pin pull-up resister enable bit. 
#define PC_CR13_IOM13                               GPIOC->CR13.MBIT.IOM13          //[2..0] PC13 pin IO mode control bits 
///@}
/**
 ******************************************************************************
 * @name        PC_CR14  [register's definitions]
 *              Offset[0x38]  PC14 IO control register (0x44020038)
 ******************************************************************************
 */
///@{
#define PC_CR14                                     GPIOC->CR14.W                   /*!< Offset[0x38]  PC14 IO control register (0x44020038) */

/* Bit fields of PC_CR14 */
#define PC_CR14_AFS14                               GPIOC->CR14.MBIT.AFS14          //[15..12] PC14 pin alternate function select 
#define PC_CR14_FDIV14                              GPIOC->CR14.MBIT.FDIV14         //[11..10] PC14 pin input deglitch filter clock divider select. 
#define PC_CR14_INV14                               GPIOC->CR14.MBIT.INV14          //[7] PC14 pin input inverse enable bit. 
#define PC_CR14_PU14                                GPIOC->CR14.MBIT.PU14           //[5] PC14 pin pull-up resister enable bit. 
#define PC_CR14_HS14                                GPIOC->CR14.MBIT.HS14           //[3] PC14 pin output high speed mode enable bit. 
#define PC_CR14_IOM14                               GPIOC->CR14.MBIT.IOM14          //[2..0] PC14 pin IO mode control bits 
///@}
/**
 ******************************************************************************
 * @name        PC_FLT  [register's definitions]
 *              Offset[0x40]  PC port input filter control register (0x44020040)
 ******************************************************************************
 */
///@{
#define PC_FLT                                      GPIOC->FLT.W                    /*!< Offset[0x40]  PC port input filter control register (0x44020040) */

/* Bit fields of PC_FLT */
#define PC_FLT_FCKS                                 GPIOC->FLT.MBIT.FCKS            //[2..0] PC port input deglitch filter clock source select for all pins of the port. 
///@}

/*----------------------------------------------------------------------------*/
/* @module      PD (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PD_CR0  [register's definitions]
 *              Offset[0x00]  PD0 IO control register (0x44030000)
 ******************************************************************************
 */
///@{
#define PD_CR0                                      GPIOD->CR0.W                    /*!< Offset[0x00]  PD0 IO control register (0x44030000) */

/* Bit fields of PD_CR0 */
#define PD_CR0_AFS0                                 GPIOD->CR0.MBIT.AFS0            //[15..12] PD0 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR0_FDIV0                                GPIOD->CR0.MBIT.FDIV0           //[11..10] PD0 pin input deglitch filter clock divider select. 
#define PD_CR0_ODC0                                 GPIOD->CR0.MBIT.ODC0            //[9] PD0 pin output drive strength select. 
#define PD_CR0_INV0                                 GPIOD->CR0.MBIT.INV0            //[7] PD0 pin input inverse enable bit. 
#define PD_CR0_PU0                                  GPIOD->CR0.MBIT.PU0             //[5] PD0 pin pull-up resister enable bit. 
#define PD_CR0_HS0                                  GPIOD->CR0.MBIT.HS0             //[3] PD0 pin output high speed mode enable bit. 
#define PD_CR0_IOM0                                 GPIOD->CR0.MBIT.IOM0            //[2..0] PD0 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR1  [register's definitions]
 *              Offset[0x04]  PD1 IO control register (0x44030004)
 ******************************************************************************
 */
///@{
#define PD_CR1                                      GPIOD->CR1.W                    /*!< Offset[0x04]  PD1 IO control register (0x44030004) */

/* Bit fields of PD_CR1 */
#define PD_CR1_AFS1                                 GPIOD->CR1.MBIT.AFS1            //[15..12] PD1 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR1_FDIV1                                GPIOD->CR1.MBIT.FDIV1           //[11..10] PD1 pin input deglitch filter clock divider select. 
#define PD_CR1_ODC1                                 GPIOD->CR1.MBIT.ODC1            //[9] PD1 pin output drive strength select. 
#define PD_CR1_INV1                                 GPIOD->CR1.MBIT.INV1            //[7] PD1 pin input inverse enable bit. 
#define PD_CR1_PU1                                  GPIOD->CR1.MBIT.PU1             //[5] PD1 pin pull-up resister enable bit. 
#define PD_CR1_HS1                                  GPIOD->CR1.MBIT.HS1             //[3] PD1 pin output high speed mode enable bit. 
#define PD_CR1_IOM1                                 GPIOD->CR1.MBIT.IOM1            //[2..0] PD1 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR2  [register's definitions]
 *              Offset[0x08]  PD2 IO control register (0x44030008)
 ******************************************************************************
 */
///@{
#define PD_CR2                                      GPIOD->CR2.W                    /*!< Offset[0x08]  PD2 IO control register (0x44030008) */

/* Bit fields of PD_CR2 */
#define PD_CR2_AFS2                                 GPIOD->CR2.MBIT.AFS2            //[15..12] PD2 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR2_FDIV2                                GPIOD->CR2.MBIT.FDIV2           //[11..10] PD2 pin input deglitch filter clock divider select. 
#define PD_CR2_ODC2                                 GPIOD->CR2.MBIT.ODC2            //[9] PD2 pin output drive strength select. 
#define PD_CR2_INV2                                 GPIOD->CR2.MBIT.INV2            //[7] PD2 pin input inverse enable bit. 
#define PD_CR2_PU2                                  GPIOD->CR2.MBIT.PU2             //[5] PD2 pin pull-up resister enable bit. 
#define PD_CR2_HS2                                  GPIOD->CR2.MBIT.HS2             //[3] PD2 pin output high speed mode enable bit. 
#define PD_CR2_IOM2                                 GPIOD->CR2.MBIT.IOM2            //[2..0] PD2 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR3  [register's definitions]
 *              Offset[0x0C]  PD3 IO control register (0x4403000C)
 ******************************************************************************
 */
///@{
#define PD_CR3                                      GPIOD->CR3.W                    /*!< Offset[0x0C]  PD3 IO control register (0x4403000C) */

/* Bit fields of PD_CR3 */
#define PD_CR3_AFS3                                 GPIOD->CR3.MBIT.AFS3            //[15..12] PD3 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR3_FDIV3                                GPIOD->CR3.MBIT.FDIV3           //[11..10] PD3 pin input deglitch filter clock divider select. 
#define PD_CR3_ODC3                                 GPIOD->CR3.MBIT.ODC3            //[9] PD3 pin output drive strength select. 
#define PD_CR3_INV3                                 GPIOD->CR3.MBIT.INV3            //[7] PD3 pin input inverse enable bit. 
#define PD_CR3_PU3                                  GPIOD->CR3.MBIT.PU3             //[5] PD3 pin pull-up resister enable bit. 
#define PD_CR3_HS3                                  GPIOD->CR3.MBIT.HS3             //[3] PD3 pin output high speed mode enable bit. 
#define PD_CR3_IOM3                                 GPIOD->CR3.MBIT.IOM3            //[2..0] PD3 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR4  [register's definitions]
 *              Offset[0x10]  PD4 IO control register (0x44030010)
 ******************************************************************************
 */
///@{
#define PD_CR4                                      GPIOD->CR4.W                    /*!< Offset[0x10]  PD4 IO control register (0x44030010) */

/* Bit fields of PD_CR4 */
#define PD_CR4_AFS4                                 GPIOD->CR4.MBIT.AFS4            //[15..12] PD4 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR4_FDIV4                                GPIOD->CR4.MBIT.FDIV4           //[11..10] PD4 pin input deglitch filter clock divider select. 
#define PD_CR4_ODC4                                 GPIOD->CR4.MBIT.ODC4            //[9] PD4 pin output drive strength select. 
#define PD_CR4_INV4                                 GPIOD->CR4.MBIT.INV4            //[7] PD4 pin input inverse enable bit. 
#define PD_CR4_PU4                                  GPIOD->CR4.MBIT.PU4             //[5] PD4 pin pull-up resister enable bit. 
#define PD_CR4_IOM4                                 GPIOD->CR4.MBIT.IOM4            //[2..0] PD4 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR5  [register's definitions]
 *              Offset[0x14]  PD5 IO control register (0x44030014)
 ******************************************************************************
 */
///@{
#define PD_CR5                                      GPIOD->CR5.W                    /*!< Offset[0x14]  PD5 IO control register (0x44030014) */

/* Bit fields of PD_CR5 */
#define PD_CR5_AFS5                                 GPIOD->CR5.MBIT.AFS5            //[15..12] PD5 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR5_FDIV5                                GPIOD->CR5.MBIT.FDIV5           //[11..10] PD5 pin input deglitch filter clock divider select. 
#define PD_CR5_ODC5                                 GPIOD->CR5.MBIT.ODC5            //[9] PD5 pin output drive strength select. 
#define PD_CR5_INV5                                 GPIOD->CR5.MBIT.INV5            //[7] PD5 pin input inverse enable bit. 
#define PD_CR5_PU5                                  GPIOD->CR5.MBIT.PU5             //[5] PD5 pin pull-up resister enable bit. 
#define PD_CR5_IOM5                                 GPIOD->CR5.MBIT.IOM5            //[2..0] PD5 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR6  [register's definitions]
 *              Offset[0x18]  PD6 IO control register (0x44030018)
 ******************************************************************************
 */
///@{
#define PD_CR6                                      GPIOD->CR6.W                    /*!< Offset[0x18]  PD6 IO control register (0x44030018) */

/* Bit fields of PD_CR6 */
#define PD_CR6_AFS6                                 GPIOD->CR6.MBIT.AFS6            //[15..12] PD6 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR6_FDIV6                                GPIOD->CR6.MBIT.FDIV6           //[11..10] PD6 pin input deglitch filter clock divider select. 
#define PD_CR6_ODC6                                 GPIOD->CR6.MBIT.ODC6            //[9] PD6 pin output drive strength select. 
#define PD_CR6_INV6                                 GPIOD->CR6.MBIT.INV6            //[7] PD6 pin input inverse enable bit. 
#define PD_CR6_PU6                                  GPIOD->CR6.MBIT.PU6             //[5] PD6 pin pull-up resister enable bit. 
#define PD_CR6_IOM6                                 GPIOD->CR6.MBIT.IOM6            //[2..0] PD6 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR7  [register's definitions]
 *              Offset[0x1C]  PD7 IO control register (0x4403001C)
 ******************************************************************************
 */
///@{
#define PD_CR7                                      GPIOD->CR7.W                    /*!< Offset[0x1C]  PD7 IO control register (0x4403001C) */

/* Bit fields of PD_CR7 */
#define PD_CR7_AFS7                                 GPIOD->CR7.MBIT.AFS7            //[15..12] PD7 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR7_FDIV7                                GPIOD->CR7.MBIT.FDIV7           //[11..10] PD7 pin input deglitch filter clock divider select. 
#define PD_CR7_ODC7                                 GPIOD->CR7.MBIT.ODC7            //[9] PD7 pin output drive strength select. 
#define PD_CR7_INV7                                 GPIOD->CR7.MBIT.INV7            //[7] PD7 pin input inverse enable bit. 
#define PD_CR7_PU7                                  GPIOD->CR7.MBIT.PU7             //[5] PD7 pin pull-up resister enable bit. 
#define PD_CR7_IOM7                                 GPIOD->CR7.MBIT.IOM7            //[2..0] PD7 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR8  [register's definitions]
 *              Offset[0x20]  PD8 IO control register (0x44030020)
 ******************************************************************************
 */
///@{
#define PD_CR8                                      GPIOD->CR8.W                    /*!< Offset[0x20]  PD8 IO control register (0x44030020) */

/* Bit fields of PD_CR8 */
#define PD_CR8_AFS8                                 GPIOD->CR8.MBIT.AFS8            //[15..12] PD8 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR8_FDIV8                                GPIOD->CR8.MBIT.FDIV8           //[11..10] PD8 pin input deglitch filter clock divider select. 
#define PD_CR8_ODC8                                 GPIOD->CR8.MBIT.ODC8            //[9] PD8 pin output drive strength select. 
#define PD_CR8_INV8                                 GPIOD->CR8.MBIT.INV8            //[7] PD8 pin input inverse enable bit. 
#define PD_CR8_PU8                                  GPIOD->CR8.MBIT.PU8             //[5] PD8 pin pull-up resister enable bit. 
#define PD_CR8_IOM8                                 GPIOD->CR8.MBIT.IOM8            //[2..0] PD8 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR9  [register's definitions]
 *              Offset[0x24]  PD9 IO control register (0x44030024)
 ******************************************************************************
 */
///@{
#define PD_CR9                                      GPIOD->CR9.W                    /*!< Offset[0x24]  PD9 IO control register (0x44030024) */

/* Bit fields of PD_CR9 */
#define PD_CR9_AFS9                                 GPIOD->CR9.MBIT.AFS9            //[15..12] PD9 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR9_FDIV9                                GPIOD->CR9.MBIT.FDIV9           //[11..10] PD9 pin input deglitch filter clock divider select. 
#define PD_CR9_ODC9                                 GPIOD->CR9.MBIT.ODC9            //[9] PD9 pin output drive strength select. 
#define PD_CR9_INV9                                 GPIOD->CR9.MBIT.INV9            //[7] PD9 pin input inverse enable bit. 
#define PD_CR9_PU9                                  GPIOD->CR9.MBIT.PU9             //[5] PD9 pin pull-up resister enable bit. 
#define PD_CR9_IOM9                                 GPIOD->CR9.MBIT.IOM9            //[2..0] PD9 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR10  [register's definitions]
 *              Offset[0x28]  PD10 IO control register (0x44030028)
 ******************************************************************************
 */
///@{
#define PD_CR10                                     GPIOD->CR10.W                   /*!< Offset[0x28]  PD10 IO control register (0x44030028) */

/* Bit fields of PD_CR10 */
#define PD_CR10_AFS10                               GPIOD->CR10.MBIT.AFS10          //[15..12] PD10 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR10_FDIV10                              GPIOD->CR10.MBIT.FDIV10         //[11..10] PD10 pin input deglitch filter clock divider select. 
#define PD_CR10_ODC10                               GPIOD->CR10.MBIT.ODC10          //[9] PD10 pin output drive strength select. 
#define PD_CR10_INV10                               GPIOD->CR10.MBIT.INV10          //[7] PD10 pin input inverse enable bit. 
#define PD_CR10_PU10                                GPIOD->CR10.MBIT.PU10           //[5] PD10 pin pull-up resister enable bit. 
#define PD_CR10_IOM10                               GPIOD->CR10.MBIT.IOM10          //[2..0] PD10 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR11  [register's definitions]
 *              Offset[0x2C]  PD11 IO control register (0x4403002C)
 ******************************************************************************
 */
///@{
#define PD_CR11                                     GPIOD->CR11.W                   /*!< Offset[0x2C]  PD11 IO control register (0x4403002C) */

/* Bit fields of PD_CR11 */
#define PD_CR11_AFS11                               GPIOD->CR11.MBIT.AFS11          //[15..12] PD11 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR11_FDIV11                              GPIOD->CR11.MBIT.FDIV11         //[11..10] PD11 pin input deglitch filter clock divider select. 
#define PD_CR11_ODC11                               GPIOD->CR11.MBIT.ODC11          //[9] PD11 pin output drive strength select. 
#define PD_CR11_INV11                               GPIOD->CR11.MBIT.INV11          //[7] PD11 pin input inverse enable bit. 
#define PD_CR11_PU11                                GPIOD->CR11.MBIT.PU11           //[5] PD11 pin pull-up resister enable bit. 
#define PD_CR11_IOM11                               GPIOD->CR11.MBIT.IOM11          //[2..0] PD11 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR12  [register's definitions]
 *              Offset[0x30]  PD12 IO control register (0x44030030)
 ******************************************************************************
 */
///@{
#define PD_CR12                                     GPIOD->CR12.W                   /*!< Offset[0x30]  PD12 IO control register (0x44030030) */

/* Bit fields of PD_CR12 */
#define PD_CR12_AFS12                               GPIOD->CR12.MBIT.AFS12          //[15..12] PD12 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR12_FDIV12                              GPIOD->CR12.MBIT.FDIV12         //[11..10] PD12 pin input deglitch filter clock divider select. 
#define PD_CR12_ODC12                               GPIOD->CR12.MBIT.ODC12          //[9] PD12 pin output drive strength select. 
#define PD_CR12_INV12                               GPIOD->CR12.MBIT.INV12          //[7] PD12 pin input inverse enable bit. 
#define PD_CR12_PU12                                GPIOD->CR12.MBIT.PU12           //[5] PD12 pin pull-up resister enable bit. 
#define PD_CR12_IOM12                               GPIOD->CR12.MBIT.IOM12          //[2..0] PD12 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR13  [register's definitions]
 *              Offset[0x34]  PD13 IO control register (0x44030034)
 ******************************************************************************
 */
///@{
#define PD_CR13                                     GPIOD->CR13.W                   /*!< Offset[0x34]  PD13 IO control register (0x44030034) */

/* Bit fields of PD_CR13 */
#define PD_CR13_AFS13                               GPIOD->CR13.MBIT.AFS13          //[15..12] PD13 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR13_FDIV13                              GPIOD->CR13.MBIT.FDIV13         //[11..10] PD13 pin input deglitch filter clock divider select. 
#define PD_CR13_ODC13                               GPIOD->CR13.MBIT.ODC13          //[9] PD13 pin output drive strength select. 
#define PD_CR13_INV13                               GPIOD->CR13.MBIT.INV13          //[7] PD13 pin input inverse enable bit. 
#define PD_CR13_PU13                                GPIOD->CR13.MBIT.PU13           //[5] PD13 pin pull-up resister enable bit. 
#define PD_CR13_IOM13                               GPIOD->CR13.MBIT.IOM13          //[2..0] PD13 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR14  [register's definitions]
 *              Offset[0x38]  PD14 IO control register (0x44030038)
 ******************************************************************************
 */
///@{
#define PD_CR14                                     GPIOD->CR14.W                   /*!< Offset[0x38]  PD14 IO control register (0x44030038) */

/* Bit fields of PD_CR14 */
#define PD_CR14_AFS14                               GPIOD->CR14.MBIT.AFS14          //[15..12] PD14 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR14_FDIV14                              GPIOD->CR14.MBIT.FDIV14         //[11..10] PD14 pin input deglitch filter clock divider select. 
#define PD_CR14_ODC14                               GPIOD->CR14.MBIT.ODC14          //[9] PD14 pin output drive strength select. 
#define PD_CR14_INV14                               GPIOD->CR14.MBIT.INV14          //[7] PD14 pin input inverse enable bit. 
#define PD_CR14_PU14                                GPIOD->CR14.MBIT.PU14           //[5] PD14 pin pull-up resister enable bit. 
#define PD_CR14_IOM14                               GPIOD->CR14.MBIT.IOM14          //[2..0] PD14 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_CR15  [register's definitions]
 *              Offset[0x3C]  PD15 IO control register (0x4403003C)
 ******************************************************************************
 */
///@{
#define PD_CR15                                     GPIOD->CR15.W                   /*!< Offset[0x3C]  PD15 IO control register (0x4403003C) */

/* Bit fields of PD_CR15 */
#define PD_CR15_AFS15                               GPIOD->CR15.MBIT.AFS15          //[15..12] PD15 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PD_CR15_FDIV15                              GPIOD->CR15.MBIT.FDIV15         //[11..10] PD15 pin input deglitch filter clock divider select. 
#define PD_CR15_ODC15                               GPIOD->CR15.MBIT.ODC15          //[9] PD15 pin output drive strength select. 
#define PD_CR15_INV15                               GPIOD->CR15.MBIT.INV15          //[7] PD15 pin input inverse enable bit. 
#define PD_CR15_PU15                                GPIOD->CR15.MBIT.PU15           //[5] PD15 pin pull-up resister enable bit. 
#define PD_CR15_IOM15                               GPIOD->CR15.MBIT.IOM15          //[2..0] PD15 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PD_FLT  [register's definitions]
 *              Offset[0x40]  PD port input filter control register (0x44030040)
 ******************************************************************************
 */
///@{
#define PD_FLT                                      GPIOD->FLT.W                    /*!< Offset[0x40]  PD port input filter control register (0x44030040) */

/* Bit fields of PD_FLT */
#define PD_FLT_FCKS                                 GPIOD->FLT.MBIT.FCKS            //[2..0] PD port input deglitch filter clock source select for all pins of the port. 
///@}

/*----------------------------------------------------------------------------*/
/* @module      PE (Port IO Mode/AFS Register Control Definitions)            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PE_CR0  [register's definitions]
 *              Offset[0x00]  PE0 IO control register (0x44040000)
 ******************************************************************************
 */
///@{
#define PE_CR0                                      GPIOE->CR0.W                    /*!< Offset[0x00]  PE0 IO control register (0x44040000) */

/* Bit fields of PE_CR0 */
#define PE_CR0_AFS0                                 GPIOE->CR0.MBIT.AFS0            //[15..12] PE0 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR0_FDIV0                                GPIOE->CR0.MBIT.FDIV0           //[11..10] PE0 pin input deglitch filter clock divider select. 
#define PE_CR0_ODC0                                 GPIOE->CR0.MBIT.ODC0            //[9..8] PE0 pin output drive strength select. 
#define PE_CR0_INV0                                 GPIOE->CR0.MBIT.INV0            //[7] PE0 pin input inverse enable bit. 
#define PE_CR0_PU0                                  GPIOE->CR0.MBIT.PU0             //[5] PE0 pin pull-up resister enable bit. 
#define PE_CR0_IOM0                                 GPIOE->CR0.MBIT.IOM0            //[2..0] PE0 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR1  [register's definitions]
 *              Offset[0x04]  PE1 IO control register (0x44040004)
 ******************************************************************************
 */
///@{
#define PE_CR1                                      GPIOE->CR1.W                    /*!< Offset[0x04]  PE1 IO control register (0x44040004) */

/* Bit fields of PE_CR1 */
#define PE_CR1_AFS1                                 GPIOE->CR1.MBIT.AFS1            //[15..12] PE1 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR1_FDIV1                                GPIOE->CR1.MBIT.FDIV1           //[11..10] PE1 pin input deglitch filter clock divider select. 
#define PE_CR1_ODC1                                 GPIOE->CR1.MBIT.ODC1            //[9..8] PE1 pin output drive strength select. 
#define PE_CR1_INV1                                 GPIOE->CR1.MBIT.INV1            //[7] PE1 pin input inverse enable bit. 
#define PE_CR1_PU1                                  GPIOE->CR1.MBIT.PU1             //[5] PE1 pin pull-up resister enable bit. 
#define PE_CR1_IOM1                                 GPIOE->CR1.MBIT.IOM1            //[2..0] PE1 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR2  [register's definitions]
 *              Offset[0x08]  PE2 IO control register (0x44040008)
 ******************************************************************************
 */
///@{
#define PE_CR2                                      GPIOE->CR2.W                    /*!< Offset[0x08]  PE2 IO control register (0x44040008) */

/* Bit fields of PE_CR2 */
#define PE_CR2_AFS2                                 GPIOE->CR2.MBIT.AFS2            //[15..12] PE2 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR2_FDIV2                                GPIOE->CR2.MBIT.FDIV2           //[11..10] PE2 pin input deglitch filter clock divider select. 
#define PE_CR2_ODC2                                 GPIOE->CR2.MBIT.ODC2            //[9..8] PE2 pin output drive strength select. 
#define PE_CR2_INV2                                 GPIOE->CR2.MBIT.INV2            //[7] PE2 pin input inverse enable bit. 
#define PE_CR2_PU2                                  GPIOE->CR2.MBIT.PU2             //[5] PE2 pin pull-up resister enable bit. 
#define PE_CR2_IOM2                                 GPIOE->CR2.MBIT.IOM2            //[2..0] PE2 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR3  [register's definitions]
 *              Offset[0x0C]  PE3 IO control register (0x4404000C)
 ******************************************************************************
 */
///@{
#define PE_CR3                                      GPIOE->CR3.W                    /*!< Offset[0x0C]  PE3 IO control register (0x4404000C) */

/* Bit fields of PE_CR3 */
#define PE_CR3_AFS3                                 GPIOE->CR3.MBIT.AFS3            //[15..12] PE3 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR3_FDIV3                                GPIOE->CR3.MBIT.FDIV3           //[11..10] PE3 pin input deglitch filter clock divider select. 
#define PE_CR3_ODC3                                 GPIOE->CR3.MBIT.ODC3            //[9..8] PE3 pin output drive strength select. 
#define PE_CR3_INV3                                 GPIOE->CR3.MBIT.INV3            //[7] PE3 pin input inverse enable bit. 
#define PE_CR3_PU3                                  GPIOE->CR3.MBIT.PU3             //[5] PE3 pin pull-up resister enable bit. 
#define PE_CR3_IOM3                                 GPIOE->CR3.MBIT.IOM3            //[2..0] PE3 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR8  [register's definitions]
 *              Offset[0x20]  PE8 IO control register (0x44040020)
 ******************************************************************************
 */
///@{
#define PE_CR8                                      GPIOE->CR8.W                    /*!< Offset[0x20]  PE8 IO control register (0x44040020) */

/* Bit fields of PE_CR8 */
#define PE_CR8_AFS8                                 GPIOE->CR8.MBIT.AFS8            //[15..12] PE8 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR8_FDIV8                                GPIOE->CR8.MBIT.FDIV8           //[11..10] PE8 pin input deglitch filter clock divider select. 
#define PE_CR8_ODC8                                 GPIOE->CR8.MBIT.ODC8            //[9] PE8 pin output drive strength select. 
#define PE_CR8_INV8                                 GPIOE->CR8.MBIT.INV8            //[7] PE8 pin input inverse enable bit. 
#define PE_CR8_PU8                                  GPIOE->CR8.MBIT.PU8             //[5] PE8 pin pull-up resister enable bit. 
#define PE_CR8_IOM8                                 GPIOE->CR8.MBIT.IOM8            //[2..0] PE8 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR9  [register's definitions]
 *              Offset[0x24]  PE9 IO control register (0x44040024)
 ******************************************************************************
 */
///@{
#define PE_CR9                                      GPIOE->CR9.W                    /*!< Offset[0x24]  PE9 IO control register (0x44040024) */

/* Bit fields of PE_CR9 */
#define PE_CR9_AFS9                                 GPIOE->CR9.MBIT.AFS9            //[15..12] PE9 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR9_FDIV9                                GPIOE->CR9.MBIT.FDIV9           //[11..10] PE9 pin input deglitch filter clock divider select. 
#define PE_CR9_ODC9                                 GPIOE->CR9.MBIT.ODC9            //[9] PE9 pin output drive strength select. 
#define PE_CR9_INV9                                 GPIOE->CR9.MBIT.INV9            //[7] PE9 pin input inverse enable bit. 
#define PE_CR9_PU9                                  GPIOE->CR9.MBIT.PU9             //[5] PE9 pin pull-up resister enable bit. 
#define PE_CR9_IOM9                                 GPIOE->CR9.MBIT.IOM9            //[2..0] PE9 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR12  [register's definitions]
 *              Offset[0x30]  PE12 IO control register (0x44040030)
 ******************************************************************************
 */
///@{
#define PE_CR12                                     GPIOE->CR12.W                   /*!< Offset[0x30]  PE12 IO control register (0x44040030) */

/* Bit fields of PE_CR12 */
#define PE_CR12_AFS12                               GPIOE->CR12.MBIT.AFS12          //[15..12] PE12 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR12_FDIV12                              GPIOE->CR12.MBIT.FDIV12         //[11..10] PE12 pin input deglitch filter clock divider select. 
#define PE_CR12_ODC12                               GPIOE->CR12.MBIT.ODC12          //[9] PE12 pin output drive strength select. 
#define PE_CR12_INV12                               GPIOE->CR12.MBIT.INV12          //[7] PE12 pin input inverse enable bit. 
#define PE_CR12_PU12                                GPIOE->CR12.MBIT.PU12           //[5] PE12 pin pull-up resister enable bit. 
#define PE_CR12_IOM12                               GPIOE->CR12.MBIT.IOM12          //[2..0] PE12 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR13  [register's definitions]
 *              Offset[0x34]  PE13 IO control register (0x44040034)
 ******************************************************************************
 */
///@{
#define PE_CR13                                     GPIOE->CR13.W                   /*!< Offset[0x34]  PE13 IO control register (0x44040034) */

/* Bit fields of PE_CR13 */
#define PE_CR13_AFS13                               GPIOE->CR13.MBIT.AFS13          //[15..12] PE13 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR13_FDIV13                              GPIOE->CR13.MBIT.FDIV13         //[11..10] PE13 pin input deglitch filter clock divider select. 
#define PE_CR13_ODC13                               GPIOE->CR13.MBIT.ODC13          //[9] PE13 pin output drive strength select. 
#define PE_CR13_INV13                               GPIOE->CR13.MBIT.INV13          //[7] PE13 pin input inverse enable bit. 
#define PE_CR13_PU13                                GPIOE->CR13.MBIT.PU13           //[5] PE13 pin pull-up resister enable bit. 
#define PE_CR13_IOM13                               GPIOE->CR13.MBIT.IOM13          //[2..0] PE13 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR14  [register's definitions]
 *              Offset[0x38]  PE14 IO control register (0x44040038)
 ******************************************************************************
 */
///@{
#define PE_CR14                                     GPIOE->CR14.W                   /*!< Offset[0x38]  PE14 IO control register (0x44040038) */

/* Bit fields of PE_CR14 */
#define PE_CR14_AFS14                               GPIOE->CR14.MBIT.AFS14          //[15..12] PE14 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR14_FDIV14                              GPIOE->CR14.MBIT.FDIV14         //[11..10] PE14 pin input deglitch filter clock divider select. 
#define PE_CR14_ODC14                               GPIOE->CR14.MBIT.ODC14          //[9] PE14 pin output drive strength select. 
#define PE_CR14_INV14                               GPIOE->CR14.MBIT.INV14          //[7] PE14 pin input inverse enable bit. 
#define PE_CR14_PU14                                GPIOE->CR14.MBIT.PU14           //[5] PE14 pin pull-up resister enable bit. 
#define PE_CR14_IOM14                               GPIOE->CR14.MBIT.IOM14          //[2..0] PE14 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_CR15  [register's definitions]
 *              Offset[0x3C]  PE15 IO control register (0x4404003C)
 ******************************************************************************
 */
///@{
#define PE_CR15                                     GPIOE->CR15.W                   /*!< Offset[0x3C]  PE15 IO control register (0x4404003C) */

/* Bit fields of PE_CR15 */
#define PE_CR15_AFS15                               GPIOE->CR15.MBIT.AFS15          //[15..12] PE15 pin alternate function select. Refer the GPIO AFS table for detail information. 
#define PE_CR15_FDIV15                              GPIOE->CR15.MBIT.FDIV15         //[11..10] PE15 pin input deglitch filter clock divider select. 
#define PE_CR15_ODC15                               GPIOE->CR15.MBIT.ODC15          //[9] PE15 pin output drive strength select. 
#define PE_CR15_INV15                               GPIOE->CR15.MBIT.INV15          //[7] PE15 pin input inverse enable bit. 
#define PE_CR15_PU15                                GPIOE->CR15.MBIT.PU15           //[5] PE15 pin pull-up resister enable bit. 
#define PE_CR15_IOM15                               GPIOE->CR15.MBIT.IOM15          //[2..0] PE15 pin IO mode control bits. 
///@}
/**
 ******************************************************************************
 * @name        PE_FLT  [register's definitions]
 *              Offset[0x40]  PE port input filter control register (0x44040040)
 ******************************************************************************
 */
///@{
#define PE_FLT                                      GPIOE->FLT.W                    /*!< Offset[0x40]  PE port input filter control register (0x44040040) */

/* Bit fields of PE_FLT */
#define PE_FLT_FCKS                                 GPIOE->FLT.MBIT.FCKS            //[2..0] PE port input deglitch filter clock source select for all pins of the port. 
///@}

/*----------------------------------------------------------------------------*/
/* @module      GPL (GPL Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        GPL_STA  [register's definitions]
 *              Offset[0x00]  GPL status register (0x4B000000)
 ******************************************************************************
 */
///@{
#define GPL_STA                                     GPL->STA.W                      /*!< Offset[0x00]  GPL status register (0x4B000000) */

/* Bit fields of GPL_STA */
#define GPL_STA_PAR32_OUT                           GPL->STA.MBIT.PAR32_OUT         //[14] GPL 32-bit data parity check output.
#define GPL_STA_PAR16_OUT                           GPL->STA.MBIT.PAR16_OUT         //[13..12] GPL 16-bit data parity check output.
#define GPL_STA_PAR8_OUT                            GPL->STA.MBIT.PAR8_OUT          //[11..8] GPL 8-bit data parity check output.
///@}
/**
 ******************************************************************************
 * @name        GPL_CR0  [register's definitions]
 *              Offset[0x10]  GPL control register 0 (0x4B000010)
 ******************************************************************************
 */
///@{
#define GPL_CR0                                     GPL->CR0.W                      /*!< Offset[0x10]  GPL control register 0 (0x4B000010) */

/* Bit fields of GPL_CR0 */
#define GPL_CR0_DMA_EN                              GPL->CR0.MBIT.DMA_EN            //[31] Direct memory access enable bit
#define GPL_CR0_PAR_POL                             GPL->CR0.MBIT.PAR_POL           //[10] Data parity check polarity select.
#define GPL_CR0_IN_INV                              GPL->CR0.MBIT.IN_INV            //[6] Inverse input data enable.
#define GPL_CR0_BREV_MDS                            GPL->CR0.MBIT.BREV_MDS          //[3..2] Data bit order reverse change mode select
#define GPL_CR0_BEND_EN                             GPL->CR0.MBIT.BEND_EN           //[1] Data byte big/little endian change mode enable
///@}
/**
 ******************************************************************************
 * @name        GPL_CR1  [register's definitions]
 *              Offset[0x14]  GPL control register 1 (0x4B000014)
 ******************************************************************************
 */
///@{
#define GPL_CR1                                     GPL->CR1.W                      /*!< Offset[0x14]  GPL control register 1 (0x4B000014) */

/* Bit fields of GPL_CR1 */
#define GPL_CR1_CRC_BREV                            GPL->CR1.MBIT.CRC_BREV          //[7..6] CRC data output bit order reverse change mode select.
#define GPL_CR1_CRC_DSIZE                           GPL->CR1.MBIT.CRC_DSIZE         //[5..4] CRC operation data size
#define GPL_CR1_CRC_MDS                             GPL->CR1.MBIT.CRC_MDS           //[3..2] CRC mode select.
#define GPL_CR1_CRC_EN                              GPL->CR1.MBIT.CRC_EN            //[0] CRC function enable bit.
///@}
/**
 ******************************************************************************
 * @name        GPL_DIN  [register's definitions]
 *              Offset[0x18]  GPL data input register (0x4B000018)
 ******************************************************************************
 */
///@{
#define GPL_DIN                                     GPL->DIN.W                      /*!< Offset[0x18]  GPL data input register (0x4B000018) */

/* Bit fields of GPL_DIN */
#define GPL_DIN_DIN                                 GPL->DIN.MBIT.DIN               //[31..0] GPL data input register
///@}
/**
 ******************************************************************************
 * @name        GPL_DOUT  [register's definitions]
 *              Offset[0x1C]  GPL data output register (0x4B00001C)
 ******************************************************************************
 */
///@{
#define GPL_DOUT                                    GPL->DOUT.W                     /*!< Offset[0x1C]  GPL data output register (0x4B00001C) */

/* Bit fields of GPL_DOUT */
#define GPL_DOUT_DOUT                               GPL->DOUT.MBIT.DOUT             //[31..0] GPL data output register.
///@}
/**
 ******************************************************************************
 * @name        GPL_CRCINIT  [register's definitions]
 *              Offset[0x24]  GPL CRC initial register (0x4B000024)
 ******************************************************************************
 */
///@{
#define GPL_CRCINIT                                 GPL->CRCINIT.W                  /*!< Offset[0x24]  GPL CRC initial register (0x4B000024) */

/* Bit fields of GPL_CRCINIT */
#define GPL_CRCINIT_CRC_INIT                        GPL->CRCINIT.MBIT.CRC_INIT      //[31..0] Programmable initial CRC value
///@}

/*----------------------------------------------------------------------------*/
/* @module      DMA (DMA Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        DMA_STA  [register's definitions]
 *              Offset[0x00]  DMA status register (0x4BF00000)
 ******************************************************************************
 */
///@{
#define DMA_STA                                     DMA->STA.W                      /*!< Offset[0x00]  DMA status register (0x4BF00000) */

/* Bit fields of DMA_STA */
#define DMA_STA_CH2_ERRF                            DMA->STA.MBIT.CH2_ERRF          //[11] DMA channel-2 transfer error flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH2_THF                             DMA->STA.MBIT.CH2_THF           //[10] DMA channel-2 transfer half flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH2_TCF                             DMA->STA.MBIT.CH2_TCF           //[9] DMA channel-2 transfer complete flag
#define DMA_STA_CH2_GIF                             DMA->STA.MBIT.CH2_GIF           //[8] DMA channel-2 global interrupt flag
#define DMA_STA_CH1_ERRF                            DMA->STA.MBIT.CH1_ERRF          //[7] DMA channel-1 transfer error flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH1_THF                             DMA->STA.MBIT.CH1_THF           //[6] DMA channel-1 transfer half flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH1_TCF                             DMA->STA.MBIT.CH1_TCF           //[5] DMA channel-1 transfer complete flag
#define DMA_STA_CH1_GIF                             DMA->STA.MBIT.CH1_GIF           //[4] DMA channel-1 global interrupt flag
#define DMA_STA_CH0_ERRF                            DMA->STA.MBIT.CH0_ERRF          //[3] DMA channel-0 transfer error flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH0_THF                             DMA->STA.MBIT.CH0_THF           //[2] DMA channel-0 transfer half flag. (set by hardware and clear by software writing 1)
#define DMA_STA_CH0_TCF                             DMA->STA.MBIT.CH0_TCF           //[1] DMA channel-0 transfer complete flag
#define DMA_STA_CH0_GIF                             DMA->STA.MBIT.CH0_GIF           //[0] DMA channel-0 global interrupt flag
///@}
/**
 ******************************************************************************
 * @name        DMA_INT  [register's definitions]
 *              Offset[0x04]  DMA interrupt enable register (0x4BF00004)
 ******************************************************************************
 */
///@{
#define DMA_INT                                     DMA->INT.W                      /*!< Offset[0x04]  DMA interrupt enable register (0x4BF00004) */

/* Bit fields of DMA_INT */
#define DMA_INT_IEA                                 DMA->INT.MBIT.IEA               //[0] DMA interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        DMA_CR0  [register's definitions]
 *              Offset[0x10]  DMA global control register 0 (0x4BF00010)
 ******************************************************************************
 */
///@{
#define DMA_CR0                                     DMA->CR0.W                      /*!< Offset[0x10]  DMA global control register 0 (0x4BF00010) */

/* Bit fields of DMA_CR0 */
#define DMA_CR0_CH2_ENB                             DMA->CR0.MBIT.CH2_ENB           //[18] DMA channel-0 operation enable bit. This bit is as same as DMA_CH2_EN.
#define DMA_CR0_CH1_ENB                             DMA->CR0.MBIT.CH1_ENB           //[17] DMA channel-0 operation enable bit. This bit is as same as DMA_CH1_EN.
#define DMA_CR0_CH0_ENB                             DMA->CR0.MBIT.CH0_ENB           //[16] DMA channel-0 operation enable bit. This bit is as same as DMA_CH0_EN.
#define DMA_CR0_GPL_CHS                             DMA->CR0.MBIT.GPL_CHS           //[5..4] DMA channel select for extra GPL function
#define DMA_CR0_PRI_MDS                             DMA->CR0.MBIT.PRI_MDS           //[1] DMA channel priority mode select.
#define DMA_CR0_EN                                  DMA->CR0.MBIT.EN                //[0] DMA controller enable.
///@}
/**
 ******************************************************************************
 * @name        DMA_CR2  [register's definitions]
 *              Offset[0x18]  DMA global control register 2 (0x4BF00018)
 ******************************************************************************
 */
///@{
#define DMA_CR2                                     DMA->CR2.W                      /*!< Offset[0x18]  DMA global control register 2 (0x4BF00018) */

/* Bit fields of DMA_CR2 */
#define DMA_CR2_XMDS_CH2                            DMA->CR2.MBIT.XMDS_CH2          //[26..24] DMA channel-2 XMDA control status for debug only.
#define DMA_CR2_XMDS_CH1                            DMA->CR2.MBIT.XMDS_CH1          //[22..20] DMA channel-1 XMDA control status for debug only.
#define DMA_CR2_XMDS_CH0                            DMA->CR2.MBIT.XMDS_CH0          //[18..16] DMA channel-0 XMDA control status for debug only.
#define DMA_CR2_SEL_CH2                             DMA->CR2.MBIT.SEL_CH2           //[10] DMA channel select channel-2 status for debug only.
#define DMA_CR2_SEL_CH1                             DMA->CR2.MBIT.SEL_CH1           //[9] DMA channel select channel-1 status for debug only.
#define DMA_CR2_SEL_CH0                             DMA->CR2.MBIT.SEL_CH0           //[8] DMA channel select channel-0 status for debug only.
#define DMA_CR2_CH_STA                              DMA->CR2.MBIT.CH_STA            //[6..4] DMA channel state machine status for debug only.
#define DMA_CR2_MAIN_STA                            DMA->CR2.MBIT.MAIN_STA          //[2..0] DMA main state machine status for debug only.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0A  [register's definitions]
 *              Offset[0x20]  DMA channel-0 control register 0 (0x4BF00020)
 ******************************************************************************
 */
///@{
#define DMA_CH0A                                    DMA->CH0A.W                     /*!< Offset[0x20]  DMA channel-0 control register 0 (0x4BF00020) */

/* Bit fields of DMA_CH0A */
#define DMA_CH0A_CH0_ERR2F                          DMA->CH0A.MBIT.CH0_ERR2F        //[27] DMA channel-0 transfer error flag
#define DMA_CH0A_CH0_TH2F                           DMA->CH0A.MBIT.CH0_TH2F         //[26] DMA channel-0 transfer half flag
#define DMA_CH0A_CH0_TC2F                           DMA->CH0A.MBIT.CH0_TC2F         //[25] DMA channel-0 transfer complete flag
#define DMA_CH0A_CH0_EIE                            DMA->CH0A.MBIT.CH0_EIE          //[19] DMA channel-0 transfer error interrupt enable.
#define DMA_CH0A_CH0_HIE                            DMA->CH0A.MBIT.CH0_HIE          //[18] DMA channel-0 transfer half interrupt enable.
#define DMA_CH0A_CH0_CIE                            DMA->CH0A.MBIT.CH0_CIE          //[17] DMA channel-0 transfer complete interrupt enable.
#define DMA_CH0A_CH0_REQ                            DMA->CH0A.MBIT.CH0_REQ          //[15] DMA channel data transfer request enable
#define DMA_CH0A_CH0_BSIZE                          DMA->CH0A.MBIT.CH0_BSIZE        //[13..12] DMA transfer burst size
#define DMA_CH0A_CH0_PLS                            DMA->CH0A.MBIT.CH0_PLS          //[11..10] DMA channel priority level select.
#define DMA_CH0A_CH0_XMDS                           DMA->CH0A.MBIT.CH0_XMDS         //[9..8] DMA channel external pin trigger request mode select
#define DMA_CH0A_CH0_ADSEL                          DMA->CH0A.MBIT.CH0_ADSEL        //[3] DMA address increased mode select
#define DMA_CH0A_CH0_LOOP                           DMA->CH0A.MBIT.CH0_LOOP         //[2] DMA loop mode enable
#define DMA_CH0A_CH0_HOLD                           DMA->CH0A.MBIT.CH0_HOLD         //[1] DMA channel operation hold enable
#define DMA_CH0A_CH0_EN                             DMA->CH0A.MBIT.CH0_EN           //[0] DMA channel operation enable
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0B  [register's definitions]
 *              Offset[0x24]  DMA channel-0 control register 1 (0x4BF00024)
 ******************************************************************************
 */
///@{
#define DMA_CH0B                                    DMA->CH0B.W                     /*!< Offset[0x24]  DMA channel-0 control register 1 (0x4BF00024) */

/* Bit fields of DMA_CH0B */
#define DMA_CH0B_CH0_XPIN                           DMA->CH0B.MBIT.CH0_XPIN         //[24] DMA channel external trigger pin select.
#define DMA_CH0B_CH0_DSYNC                          DMA->CH0B.MBIT.CH0_DSYNC        //[19] DMA destination process synchronization enable bit
#define DMA_CH0B_CH0_SSYNC                          DMA->CH0B.MBIT.CH0_SSYNC        //[18] DMA source process synchronization enable bit
#define DMA_CH0B_CH0_DINC                           DMA->CH0B.MBIT.CH0_DINC         //[17] DMA destination memory transfer address auto increased enable
#define DMA_CH0B_CH0_SINC                           DMA->CH0B.MBIT.CH0_SINC         //[16] DMA source memory transfer address auto increased enable
#define DMA_CH0B_CH0_DET                            DMA->CH0B.MBIT.CH0_DET          //[11..8] DMA channel transfer peripheral destination select
#define DMA_CH0B_CH0_SRC                            DMA->CH0B.MBIT.CH0_SRC          //[3..0] DMA channel transfer peripheral source select
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0NUM  [register's definitions]
 *              Offset[0x28]  DMA channel-0 control register 1 (0x4BF00028)
 ******************************************************************************
 */
///@{
#define DMA_CH0NUM                                  DMA->CH0NUM.W                   /*!< Offset[0x28]  DMA channel-0 control register 1 (0x4BF00028) */

/* Bit fields of DMA_CH0NUM */
#define DMA_CH0NUM_CH0_NUM                          DMA->CH0NUM.MBIT.CH0_NUM        //[15..0] DMA transfer data count initial number
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0CNT  [register's definitions]
 *              Offset[0x2C]  DMA channel-0 control register 1 (0x4BF0002C)
 ******************************************************************************
 */
///@{
#define DMA_CH0CNT                                  DMA->CH0CNT.W                   /*!< Offset[0x2C]  DMA channel-0 control register 1 (0x4BF0002C) */

/* Bit fields of DMA_CH0CNT */
#define DMA_CH0CNT_CH0_CNT                          DMA->CH0CNT.MBIT.CH0_CNT        //[15..0] DMA transfer data count current value
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SSA  [register's definitions]
 *              Offset[0x30]  DMA channel-0 source start address register (0x4BF00030)
 ******************************************************************************
 */
///@{
#define DMA_CH0SSA                                  DMA->CH0SSA.W                   /*!< Offset[0x30]  DMA channel-0 source start address register (0x4BF00030) */

/* Bit fields of DMA_CH0SSA */
#define DMA_CH0SSA_CH0_SSA                          DMA->CH0SSA.MBIT.CH0_SSA        //[31..0] DMA source memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SCA  [register's definitions]
 *              Offset[0x34]  DMA channel-0 source current address register (0x4BF00034)
 ******************************************************************************
 */
///@{
#define DMA_CH0SCA                                  DMA->CH0SCA.W                   /*!< Offset[0x34]  DMA channel-0 source current address register (0x4BF00034) */

/* Bit fields of DMA_CH0SCA */
#define DMA_CH0SCA_CH0_SCA                          DMA->CH0SCA.MBIT.CH0_SCA        //[31..0] DMA source memory transfer current address
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DSA  [register's definitions]
 *              Offset[0x38]  DMA channel-0 destination start address register (0x4BF00038)
 ******************************************************************************
 */
///@{
#define DMA_CH0DSA                                  DMA->CH0DSA.W                   /*!< Offset[0x38]  DMA channel-0 destination start address register (0x4BF00038) */

/* Bit fields of DMA_CH0DSA */
#define DMA_CH0DSA_CH0_DSA                          DMA->CH0DSA.MBIT.CH0_DSA        //[31..0] DMA destination memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DCA  [register's definitions]
 *              Offset[0x3C]  DMA channel-0 destination current address register (0x4BF0003C)
 ******************************************************************************
 */
///@{
#define DMA_CH0DCA                                  DMA->CH0DCA.W                   /*!< Offset[0x3C]  DMA channel-0 destination current address register (0x4BF0003C) */

/* Bit fields of DMA_CH0DCA */
#define DMA_CH0DCA_CH0_DCA                          DMA->CH0DCA.MBIT.CH0_DCA        //[31..0] DMA destination memory transfer current address
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1A  [register's definitions]
 *              Offset[0x40]  DMA channel-1 control register 0 (0x4BF00040)
 ******************************************************************************
 */
///@{
#define DMA_CH1A                                    DMA->CH1A.W                     /*!< Offset[0x40]  DMA channel-1 control register 0 (0x4BF00040) */

/* Bit fields of DMA_CH1A */
#define DMA_CH1A_CH1_ERR2F                          DMA->CH1A.MBIT.CH1_ERR2F        //[27] DMA channel-1 transfer error flag
#define DMA_CH1A_CH1_TH2F                           DMA->CH1A.MBIT.CH1_TH2F         //[26] DMA channel-1 transfer half flag
#define DMA_CH1A_CH1_TC2F                           DMA->CH1A.MBIT.CH1_TC2F         //[25] DMA channel-1 transfer complete flag
#define DMA_CH1A_CH1_EIE                            DMA->CH1A.MBIT.CH1_EIE          //[19] DMA channel-1 transfer error interrupt enable.
#define DMA_CH1A_CH1_HIE                            DMA->CH1A.MBIT.CH1_HIE          //[18] DMA channel-1 transfer half interrupt enable.
#define DMA_CH1A_CH1_CIE                            DMA->CH1A.MBIT.CH1_CIE          //[17] DMA channel-1 transfer complete interrupt enable.
#define DMA_CH1A_CH1_REQ                            DMA->CH1A.MBIT.CH1_REQ          //[15] DMA channel data transfer request enable
#define DMA_CH1A_CH1_BSIZE                          DMA->CH1A.MBIT.CH1_BSIZE        //[13..12] DMA transfer burst size
#define DMA_CH1A_CH1_PLS                            DMA->CH1A.MBIT.CH1_PLS          //[11..10] DMA channel priority level select.
#define DMA_CH1A_CH1_XMDS                           DMA->CH1A.MBIT.CH1_XMDS         //[9..8] DMA channel external pin trigger request mode select
#define DMA_CH1A_CH1_ADSEL                          DMA->CH1A.MBIT.CH1_ADSEL        //[3] DMA address increased mode select
#define DMA_CH1A_CH1_LOOP                           DMA->CH1A.MBIT.CH1_LOOP         //[2] DMA loop mode enable
#define DMA_CH1A_CH1_HOLD                           DMA->CH1A.MBIT.CH1_HOLD         //[1] DMA channel operation hold enable
#define DMA_CH1A_CH1_EN                             DMA->CH1A.MBIT.CH1_EN           //[0] DMA channel operation enable
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1B  [register's definitions]
 *              Offset[0x44]  DMA channel-1 control register 1 (0x4BF00044)
 ******************************************************************************
 */
///@{
#define DMA_CH1B                                    DMA->CH1B.W                     /*!< Offset[0x44]  DMA channel-1 control register 1 (0x4BF00044) */

/* Bit fields of DMA_CH1B */
#define DMA_CH1B_CH1_XPIN                           DMA->CH1B.MBIT.CH1_XPIN         //[24] DMA channel external trigger pin select.
#define DMA_CH1B_CH1_DSYNC                          DMA->CH1B.MBIT.CH1_DSYNC        //[19] DMA destination process synchronization enable bit
#define DMA_CH1B_CH1_SSYNC                          DMA->CH1B.MBIT.CH1_SSYNC        //[18] DMA source process synchronization enable bit
#define DMA_CH1B_CH1_DINC                           DMA->CH1B.MBIT.CH1_DINC         //[17] DMA destination memory transfer address auto increased enable
#define DMA_CH1B_CH1_SINC                           DMA->CH1B.MBIT.CH1_SINC         //[16] DMA source memory transfer address auto increased enable
#define DMA_CH1B_CH1_DET                            DMA->CH1B.MBIT.CH1_DET          //[11..8] DMA channel transfer peripheral destination select
#define DMA_CH1B_CH1_SRC                            DMA->CH1B.MBIT.CH1_SRC          //[3..0] DMA channel transfer peripheral source select
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1NUM  [register's definitions]
 *              Offset[0x48]  DMA channel-1 control register 1 (0x4BF00048)
 ******************************************************************************
 */
///@{
#define DMA_CH1NUM                                  DMA->CH1NUM.W                   /*!< Offset[0x48]  DMA channel-1 control register 1 (0x4BF00048) */

/* Bit fields of DMA_CH1NUM */
#define DMA_CH1NUM_CH1_NUM                          DMA->CH1NUM.MBIT.CH1_NUM        //[15..0] DMA transfer data count initial number
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1CNT  [register's definitions]
 *              Offset[0x4C]  DMA channel-1 control register 1 (0x4BF0004C)
 ******************************************************************************
 */
///@{
#define DMA_CH1CNT                                  DMA->CH1CNT.W                   /*!< Offset[0x4C]  DMA channel-1 control register 1 (0x4BF0004C) */

/* Bit fields of DMA_CH1CNT */
#define DMA_CH1CNT_CH1_CNT                          DMA->CH1CNT.MBIT.CH1_CNT        //[15..0] DMA transfer data count current value
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SSA  [register's definitions]
 *              Offset[0x50]  DMA channel-1 source start address register (0x4BF00050)
 ******************************************************************************
 */
///@{
#define DMA_CH1SSA                                  DMA->CH1SSA.W                   /*!< Offset[0x50]  DMA channel-1 source start address register (0x4BF00050) */

/* Bit fields of DMA_CH1SSA */
#define DMA_CH1SSA_CH1_SSA                          DMA->CH1SSA.MBIT.CH1_SSA        //[31..0] DMA source memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1SCA  [register's definitions]
 *              Offset[0x54]  DMA channel-1 source current address register (0x4BF00054)
 ******************************************************************************
 */
///@{
#define DMA_CH1SCA                                  DMA->CH1SCA.W                   /*!< Offset[0x54]  DMA channel-1 source current address register (0x4BF00054) */

/* Bit fields of DMA_CH1SCA */
#define DMA_CH1SCA_CH1_SCA                          DMA->CH1SCA.MBIT.CH1_SCA        //[31..0] DMA source memory transfer current address
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DSA  [register's definitions]
 *              Offset[0x58]  DMA channel-1 destination start address register (0x4BF00058)
 ******************************************************************************
 */
///@{
#define DMA_CH1DSA                                  DMA->CH1DSA.W                   /*!< Offset[0x58]  DMA channel-1 destination start address register (0x4BF00058) */

/* Bit fields of DMA_CH1DSA */
#define DMA_CH1DSA_CH1_DSA                          DMA->CH1DSA.MBIT.CH1_DSA        //[31..0] DMA destination memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH1DCA  [register's definitions]
 *              Offset[0x5C]  DMA channel-1 destination current address register (0x4BF0005C)
 ******************************************************************************
 */
///@{
#define DMA_CH1DCA                                  DMA->CH1DCA.W                   /*!< Offset[0x5C]  DMA channel-1 destination current address register (0x4BF0005C) */

/* Bit fields of DMA_CH1DCA */
#define DMA_CH1DCA_CH1_DCA                          DMA->CH1DCA.MBIT.CH1_DCA        //[31..0] DMA destination memory transfer current address
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2A  [register's definitions]
 *              Offset[0x60]  DMA channel-2 control register 0 (0x4BF00060)
 ******************************************************************************
 */
///@{
#define DMA_CH2A                                    DMA->CH2A.W                     /*!< Offset[0x60]  DMA channel-2 control register 0 (0x4BF00060) */

/* Bit fields of DMA_CH2A */
#define DMA_CH2A_CH2_ERR2F                          DMA->CH2A.MBIT.CH2_ERR2F        //[27] DMA channel-2 transfer error flag
#define DMA_CH2A_CH2_TH2F                           DMA->CH2A.MBIT.CH2_TH2F         //[26] DMA channel-2 transfer half flag
#define DMA_CH2A_CH2_TC2F                           DMA->CH2A.MBIT.CH2_TC2F         //[25] DMA channel-2 transfer complete flag
#define DMA_CH2A_CH2_EIE                            DMA->CH2A.MBIT.CH2_EIE          //[19] DMA channel-2 transfer error interrupt enable.
#define DMA_CH2A_CH2_HIE                            DMA->CH2A.MBIT.CH2_HIE          //[18] DMA channel-2 transfer half interrupt enable.
#define DMA_CH2A_CH2_CIE                            DMA->CH2A.MBIT.CH2_CIE          //[17] DMA channel-2 transfer complete interrupt enable.
#define DMA_CH2A_CH2_REQ                            DMA->CH2A.MBIT.CH2_REQ          //[15] DMA channel data transfer request enable
#define DMA_CH2A_CH2_BSIZE                          DMA->CH2A.MBIT.CH2_BSIZE        //[13..12] DMA transfer burst size
#define DMA_CH2A_CH2_PLS                            DMA->CH2A.MBIT.CH2_PLS          //[11..10] DMA channel priority level select.
#define DMA_CH2A_CH2_XMDS                           DMA->CH2A.MBIT.CH2_XMDS         //[9..8] DMA channel external pin trigger request mode select
#define DMA_CH2A_CH2_ADSEL                          DMA->CH2A.MBIT.CH2_ADSEL        //[3] DMA address increased mode select
#define DMA_CH2A_CH2_LOOP                           DMA->CH2A.MBIT.CH2_LOOP         //[2] DMA loop mode enable
#define DMA_CH2A_CH2_HOLD                           DMA->CH2A.MBIT.CH2_HOLD         //[1] DMA channel operation hold enable
#define DMA_CH2A_CH2_EN                             DMA->CH2A.MBIT.CH2_EN           //[0] DMA channel operation enable
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2B  [register's definitions]
 *              Offset[0x64]  DMA channel-2 control register 1 (0x4BF00064)
 ******************************************************************************
 */
///@{
#define DMA_CH2B                                    DMA->CH2B.W                     /*!< Offset[0x64]  DMA channel-2 control register 1 (0x4BF00064) */

/* Bit fields of DMA_CH2B */
#define DMA_CH2B_CH2_XPIN                           DMA->CH2B.MBIT.CH2_XPIN         //[24] DMA channel external trigger pin select.
#define DMA_CH2B_CH2_DSYNC                          DMA->CH2B.MBIT.CH2_DSYNC        //[19] DMA destination process synchronization enable bit
#define DMA_CH2B_CH2_SSYNC                          DMA->CH2B.MBIT.CH2_SSYNC        //[18] DMA source process synchronization enable bit
#define DMA_CH2B_CH2_DINC                           DMA->CH2B.MBIT.CH2_DINC         //[17] DMA destination memory transfer address auto increased enable
#define DMA_CH2B_CH2_SINC                           DMA->CH2B.MBIT.CH2_SINC         //[16] DMA source memory transfer address auto increased enable
#define DMA_CH2B_CH2_DET                            DMA->CH2B.MBIT.CH2_DET          //[11..8] DMA channel transfer peripheral destination select
#define DMA_CH2B_CH2_SRC                            DMA->CH2B.MBIT.CH2_SRC          //[3..0] DMA channel transfer peripheral source select
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2NUM  [register's definitions]
 *              Offset[0x68]  DMA channel-2 control register 1 (0x4BF00068)
 ******************************************************************************
 */
///@{
#define DMA_CH2NUM                                  DMA->CH2NUM.W                   /*!< Offset[0x68]  DMA channel-2 control register 1 (0x4BF00068) */

/* Bit fields of DMA_CH2NUM */
#define DMA_CH2NUM_CH2_NUM                          DMA->CH2NUM.MBIT.CH2_NUM        //[15..0] DMA transfer data count initial number
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2CNT  [register's definitions]
 *              Offset[0x6C]  DMA channel-2 control register 1 (0x4BF0006C)
 ******************************************************************************
 */
///@{
#define DMA_CH2CNT                                  DMA->CH2CNT.W                   /*!< Offset[0x6C]  DMA channel-2 control register 1 (0x4BF0006C) */

/* Bit fields of DMA_CH2CNT */
#define DMA_CH2CNT_CH2_CNT                          DMA->CH2CNT.MBIT.CH2_CNT        //[15..0] DMA transfer data count current value
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SSA  [register's definitions]
 *              Offset[0x70]  DMA channel-2 source start address register (0x4BF00070)
 ******************************************************************************
 */
///@{
#define DMA_CH2SSA                                  DMA->CH2SSA.W                   /*!< Offset[0x70]  DMA channel-2 source start address register (0x4BF00070) */

/* Bit fields of DMA_CH2SSA */
#define DMA_CH2SSA_CH2_SSA                          DMA->CH2SSA.MBIT.CH2_SSA        //[31..0] DMA source memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2SCA  [register's definitions]
 *              Offset[0x74]  DMA channel-2 source current address register (0x4BF00074)
 ******************************************************************************
 */
///@{
#define DMA_CH2SCA                                  DMA->CH2SCA.W                   /*!< Offset[0x74]  DMA channel-2 source current address register (0x4BF00074) */

/* Bit fields of DMA_CH2SCA */
#define DMA_CH2SCA_CH2_SCA                          DMA->CH2SCA.MBIT.CH2_SCA        //[31..0] DMA source memory transfer current address
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DSA  [register's definitions]
 *              Offset[0x78]  DMA channel-2 destination start address register (0x4BF00078)
 ******************************************************************************
 */
///@{
#define DMA_CH2DSA                                  DMA->CH2DSA.W                   /*!< Offset[0x78]  DMA channel-2 destination start address register (0x4BF00078) */

/* Bit fields of DMA_CH2DSA */
#define DMA_CH2DSA_CH2_DSA                          DMA->CH2DSA.MBIT.CH2_DSA        //[31..0] DMA destination memory transfer start address.
///@}
/**
 ******************************************************************************
 * @name        DMA_CH2DCA  [register's definitions]
 *              Offset[0x7C]  DMA channel-2 destination current address register (0x4BF0007C)
 ******************************************************************************
 */
///@{
#define DMA_CH2DCA                                  DMA->CH2DCA.W                   /*!< Offset[0x7C]  DMA channel-2 destination current address register (0x4BF0007C) */

/* Bit fields of DMA_CH2DCA */
#define DMA_CH2DCA_CH2_DCA                          DMA->CH2DCA.MBIT.CH2_DCA        //[31..0] DMA destination memory transfer current address
///@}

/*----------------------------------------------------------------------------*/
/* @module      RST (Reset Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        RST_STA  [register's definitions]
 *              Offset[0x00]  RST Reset status register (0x4C000000)
 ******************************************************************************
 */
///@{
#define RST_STA                                     RST->STA.W                      /*!< Offset[0x00]  RST Reset status register (0x4C000000) */

/* Bit fields of RST_STA */
#define RST_STA_CRF                                 RST->STA.MBIT.CRF               //[31] Cold reset flag
#define RST_STA_WRF                                 RST->STA.MBIT.WRF               //[30] Warm reset flag
#define RST_STA_CMP3F                               RST->STA.MBIT.CMP3F             //[19] Comparator CMP3 threshold comparison reset flag
#define RST_STA_CMP2F                               RST->STA.MBIT.CMP2F             //[18] Comparator CMP2 threshold comparison reset flag
#define RST_STA_CMP1F                               RST->STA.MBIT.CMP1F             //[17] Comparator CMP1 threshold comparison reset flag
#define RST_STA_CMP0F                               RST->STA.MBIT.CMP0F             //[16] Comparator CMP0 threshold comparison reset flag
#define RST_STA_ADCF                                RST->STA.MBIT.ADCF              //[13] ADC analog voltage watch-dog reset flag
#define RST_STA_WWDTF                               RST->STA.MBIT.WWDTF             //[12] WWDT reset flag
#define RST_STA_IWDTF                               RST->STA.MBIT.IWDTF             //[11] IWDT reset flag
#define RST_STA_MEMF                                RST->STA.MBIT.MEMF              //[10] Flash memory read/write protect or illegal address error reset flag
#define RST_STA_CSCF                                RST->STA.MBIT.CSCF              //[8] CSC missing clock detect reset flag
#define RST_STA_LPMF                                RST->STA.MBIT.LPMF              //[6] Low power mode reset flag
#define RST_STA_BOD1F                               RST->STA.MBIT.BOD1F             //[5] BOD1 reset flag
#define RST_STA_BOD0F                               RST->STA.MBIT.BOD0F             //[4] BOD0 reset flag
#define RST_STA_CPUF                                RST->STA.MBIT.CPUF              //[3] CPU SYSRESETREQ bit system reset flag
#define RST_STA_EXF                                 RST->STA.MBIT.EXF               //[2] External input reset flag
#define RST_STA_SWF                                 RST->STA.MBIT.SWF               //[1] Software forced reset flag
#define RST_STA_PORF                                RST->STA.MBIT.PORF              //[0] Power-on reset flag
///@}
/**
 ******************************************************************************
 * @name        RST_KEY  [register's definitions]
 *              Offset[0x0C]  RST write protected Key register (0x4C00000C)
 ******************************************************************************
 */
///@{
#define RST_KEY                                     RST->KEY.W                      /*!< Offset[0x0C]  RST write protected Key register (0x4C00000C) */

/* Bit fields of RST_KEY */
#define RST_KEY_LOCK                                RST->KEY.MBIT.LOCK              //[31..16] Reset lock register
#define RST_KEY_KEY                                 RST->KEY.MBIT.KEY               //[15..0] Reset key register
///@}
/**
 ******************************************************************************
 * @name        RST_CR0  [register's definitions]
 *              Offset[0x10]  RST control register 0 (0x4C000010)
 ******************************************************************************
 */
///@{
#define RST_CR0                                     RST->CR0.W                      /*!< Offset[0x10]  RST control register 0 (0x4C000010) */

/* Bit fields of RST_CR0 */
#define RST_CR0_WWDT_WDIS                           RST->CR0.MBIT.WWDT_WDIS         //[24] WWDT module Warm reset disable bit
#define RST_CR0_PE_DIS1                             RST->CR0.MBIT.PE_DIS1           //[17] Warm reset disable for PE[9:8] pins
#define RST_CR0_PE_DIS0                             RST->CR0.MBIT.PE_DIS0           //[16] Warm reset disable for PE[3:0] pins
#define RST_CR0_PD_DIS1                             RST->CR0.MBIT.PD_DIS1           //[15] Warm reset disable for PD[11:8] pins
#define RST_CR0_PD_DIS0                             RST->CR0.MBIT.PD_DIS0           //[14] Warm reset disable for PD[3:0] pins
#define RST_CR0_PC_DIS1                             RST->CR0.MBIT.PC_DIS1           //[13] Warm reset disable for PC[11:8] pins
#define RST_CR0_PC_DIS0                             RST->CR0.MBIT.PC_DIS0           //[12] Warm reset disable for PC[3:0] pins
#define RST_CR0_PB_DIS1                             RST->CR0.MBIT.PB_DIS1           //[11] Warm reset disable for PB[11:8] pins
#define RST_CR0_PB_DIS0                             RST->CR0.MBIT.PB_DIS0           //[10] Warm reset disable for PB[3:0] pins
#define RST_CR0_PA_DIS1                             RST->CR0.MBIT.PA_DIS1           //[9] Warm reset disable for PA[11:8] pins
#define RST_CR0_PA_DIS0                             RST->CR0.MBIT.PA_DIS0           //[8] Warm reset disable for PA[3:0] pins
#define RST_CR0_SW_EN                               RST->CR0.MBIT.SW_EN             //[1] System software forced reset enable for whole chip reset
///@}
/**
 ******************************************************************************
 * @name        RST_CE  [register's definitions]
 *              Offset[0x14]  RST Cold reset enable register (0x4C000014)
 ******************************************************************************
 */
///@{
#define RST_CE                                      RST->CE.W                       /*!< Offset[0x14]  RST Cold reset enable register (0x4C000014) */

/* Bit fields of RST_CE */
#define RST_CE_CMP3_CE                              RST->CE.MBIT.CMP3_CE            //[19] Comparator CMP3 threshold comparison Cold reset enable
#define RST_CE_CMP2_CE                              RST->CE.MBIT.CMP2_CE            //[18] Comparator CMP2 threshold comparison Cold reset enable
#define RST_CE_CMP1_CE                              RST->CE.MBIT.CMP1_CE            //[17] Comparator CMP1 threshold comparison Cold reset enable
#define RST_CE_CMP0_CE                              RST->CE.MBIT.CMP0_CE            //[16] Comparator CMP0 threshold comparison Cold reset enable
#define RST_CE_ADC_CE                               RST->CE.MBIT.ADC_CE             //[13] ADC analog voltage watch-dog Cold reset enable. (This bit only reset by POR reset) 
#define RST_CE_WWDT_CE                              RST->CE.MBIT.WWDT_CE            //[12] WWDT Cold reset enable. (This bit only reset by POR reset) 
#define RST_CE_IWDT_CE                              RST->CE.MBIT.IWDT_CE            //[11] IWDT Cold reset enable. (This bit only reset by POR reset) 
#define RST_CE_MEM_CE                               RST->CE.MBIT.MEM_CE             //[10] Flash memory read/write protect or illegal address error Cold reset enable
#define RST_CE_CSC_CE                               RST->CE.MBIT.CSC_CE             //[8] CSC missing clock detect Cold reset enable. (This bit only reset by POR reset) 
#define RST_CE_LPM_CE                               RST->CE.MBIT.LPM_CE             //[6] Low power STOP mode Cold reset enable. (This bit only reset by POR reset) 
#define RST_CE_BOD1_CE                              RST->CE.MBIT.BOD1_CE            //[5] BOD1 Cold reset enable.
#define RST_CE_BOD0_CE                              RST->CE.MBIT.BOD0_CE            //[4] BOD0 Cold reset enable.
#define RST_CE_CPU_CE                               RST->CE.MBIT.CPU_CE             //[3] CPU SYSRESETREQ bit forced Cold reset enable. (This bit only reset by POR reset)
#define RST_CE_EX_CE                                RST->CE.MBIT.EX_CE              //[2] External input Cold reset enable. (This bit only reset by POR reset)
#define RST_CE_SW_CE                                RST->CE.MBIT.SW_CE              //[1] Software forced Cold reset enable. (This bit only reset by POR reset)
///@}
/**
 ******************************************************************************
 * @name        RST_WE  [register's definitions]
 *              Offset[0x18]  RST Warm reset enable register (0x4C000018)
 ******************************************************************************
 */
///@{
#define RST_WE                                      RST->WE.W                       /*!< Offset[0x18]  RST Warm reset enable register (0x4C000018) */

/* Bit fields of RST_WE */
#define RST_WE_CMP3_WE                              RST->WE.MBIT.CMP3_WE            //[19] Comparator CMP3 threshold comparison Warm reset enable.  
#define RST_WE_CMP2_WE                              RST->WE.MBIT.CMP2_WE            //[18] Comparator CMP2 threshold comparison Warm reset enable.  
#define RST_WE_CMP1_WE                              RST->WE.MBIT.CMP1_WE            //[17] Comparator CMP1 threshold comparison Warm reset enable.  
#define RST_WE_CMP0_WE                              RST->WE.MBIT.CMP0_WE            //[16] Comparator CMP0 threshold comparison Warm reset enable.   
#define RST_WE_ADC_WE                               RST->WE.MBIT.ADC_WE             //[13] ADC analog voltage watch-dog Warm reset enable.  
#define RST_WE_WWDT_WE                              RST->WE.MBIT.WWDT_WE            //[12] WWDT Warm reset enable.  
#define RST_WE_IWDT_WE                              RST->WE.MBIT.IWDT_WE            //[11] IWDT Warm reset enable
#define RST_WE_MEM_WE                               RST->WE.MBIT.MEM_WE             //[10] Flash memory read/write protect or illegal address error Warm reset enable.  
#define RST_WE_CSC_WE                               RST->WE.MBIT.CSC_WE             //[8] CSC missing clock detect Warm reset enable.  
#define RST_WE_LPM_WE                               RST->WE.MBIT.LPM_WE             //[6] Low power STOP mode Warm reset enable.  
#define RST_WE_BOD1_WE                              RST->WE.MBIT.BOD1_WE            //[5] BOD1 Warm reset enable
#define RST_WE_BOD0_WE                              RST->WE.MBIT.BOD0_WE            //[4] BOD0 Warm reset enable
#define RST_WE_CPU_WE                               RST->WE.MBIT.CPU_WE             //[3] CPU SYSRESETREQ bit forced Warm reset enable. 
#define RST_WE_EX_WE                                RST->WE.MBIT.EX_WE              //[2] External input Warm reset enable
#define RST_WE_SW_WE                                RST->WE.MBIT.SW_WE              //[1] Software forced Warm reset enable. 
///@}
/**
 ******************************************************************************
 * @name        RST_AHB  [register's definitions]
 *              Offset[0x1C]  RST AHB reset register (0x4C00001C)
 ******************************************************************************
 */
///@{
#define RST_AHB                                     RST->AHB.W                      /*!< Offset[0x1C]  RST AHB reset register (0x4C00001C) */

/* Bit fields of RST_AHB */
#define RST_AHB_EMB_EN                              RST->AHB.MBIT.EMB_EN            //[12] System software forced reset enable for EMB module.
#define RST_AHB_GPL_EN                              RST->AHB.MBIT.GPL_EN            //[8] System software forced reset enable for GPL module.
#define RST_AHB_IOPE_EN                             RST->AHB.MBIT.IOPE_EN           //[4] System software forced reset enable for IO Port-E.
#define RST_AHB_IOPD_EN                             RST->AHB.MBIT.IOPD_EN           //[3] System software forced reset enable for IO Port-D.
#define RST_AHB_IOPC_EN                             RST->AHB.MBIT.IOPC_EN           //[2] System software forced reset enable for IO Port-C.
#define RST_AHB_IOPB_EN                             RST->AHB.MBIT.IOPB_EN           //[1] System software forced reset enable for IO Port-B.
#define RST_AHB_IOPA_EN                             RST->AHB.MBIT.IOPA_EN           //[0] System software forced reset enable for IO Port-A.
///@}
/**
 ******************************************************************************
 * @name        RST_APB0  [register's definitions]
 *              Offset[0x20]  RST APB reset register 0 (0x4C000020)
 ******************************************************************************
 */
///@{
#define RST_APB0                                    RST->APB0.W                     /*!< Offset[0x20]  RST APB reset register 0 (0x4C000020) */

/* Bit fields of RST_APB0 */
#define RST_APB0_URT3_EN                            RST->APB0.MBIT.URT3_EN          //[19] System software forced reset enable for URT3 module.
#define RST_APB0_URT2_EN                            RST->APB0.MBIT.URT2_EN          //[18] System software forced reset enable for URT2 module.
#define RST_APB0_URT1_EN                            RST->APB0.MBIT.URT1_EN          //[17] System software forced reset enable for URT1 module.
#define RST_APB0_URT0_EN                            RST->APB0.MBIT.URT0_EN          //[16] System software forced reset enable for URT0 module.
#define RST_APB0_SPI0_EN                            RST->APB0.MBIT.SPI0_EN          //[12] System software forced reset enable for SP00 module.
#define RST_APB0_I2C1_EN                            RST->APB0.MBIT.I2C1_EN          //[9] System software forced reset enable for I2C1 module.
#define RST_APB0_I2C0_EN                            RST->APB0.MBIT.I2C0_EN          //[8] System software forced reset enable for I2C0 module.
#define RST_APB0_WWDT_EN                            RST->APB0.MBIT.WWDT_EN          //[7] System software forced reset enable for WWDT module.
#define RST_APB0_IWDT_EN                            RST->APB0.MBIT.IWDT_EN          //[6] System software forced reset enable for IWDT module.
#define RST_APB0_RTC_EN                             RST->APB0.MBIT.RTC_EN           //[5] System software forced reset enable for RTC module.
#define RST_APB0_DAC_EN                             RST->APB0.MBIT.DAC_EN           //[3] System software forced reset enable for DAC module.
#define RST_APB0_CMP_EN                             RST->APB0.MBIT.CMP_EN           //[2] System software forced reset enable for CMP module.
#define RST_APB0_ADC0_EN                            RST->APB0.MBIT.ADC0_EN          //[0] System software forced reset enable for ADC0 module.
///@}
/**
 ******************************************************************************
 * @name        RST_APB1  [register's definitions]
 *              Offset[0x24]  RST APB reset register 1 (0x4C000024)
 ******************************************************************************
 */
///@{
#define RST_APB1                                    RST->APB1.W                     /*!< Offset[0x24]  RST APB reset register 1 (0x4C000024) */

/* Bit fields of RST_APB1 */
#define RST_APB1_TM36_EN                            RST->APB1.MBIT.TM36_EN          //[15] System software forced reset enable for TM36 module.
#define RST_APB1_TM26_EN                            RST->APB1.MBIT.TM26_EN          //[11] System software forced reset enable for TM26 module.
#define RST_APB1_TM20_EN                            RST->APB1.MBIT.TM20_EN          //[8] System software forced reset enable for TM20 module.
#define RST_APB1_TM16_EN                            RST->APB1.MBIT.TM16_EN          //[7] System software forced reset enable for TM16 module.
#define RST_APB1_TM10_EN                            RST->APB1.MBIT.TM10_EN          //[4] System software forced reset enable for TM10 module.
#define RST_APB1_TM01_EN                            RST->APB1.MBIT.TM01_EN          //[1] System software forced reset enable for TM01 module.
#define RST_APB1_TM00_EN                            RST->APB1.MBIT.TM00_EN          //[0] System software forced reset enable for TM00 module.
///@}

/*----------------------------------------------------------------------------*/
/* @module      CSC (Clock Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CSC_STA  [register's definitions]
 *              Offset[0x00]  CSC status register (0x4C010000)
 ******************************************************************************
 */
///@{
#define CSC_STA                                     CSC->STA.W                      /*!< Offset[0x00]  CSC status register (0x4C010000) */

/* Bit fields of CSC_STA */
#define CSC_STA_MCDF                                CSC->STA.MBIT.MCDF              //[7] XOSC missing clock detect failure event flag
#define CSC_STA_PLLF                                CSC->STA.MBIT.PLLF              //[6] PLL clock stable and ready detect flag
#define CSC_STA_IHRCOF                              CSC->STA.MBIT.IHRCOF            //[5] IHRCO clock stable and ready detect flag
#define CSC_STA_ILRCOF                              CSC->STA.MBIT.ILRCOF            //[4] ILRCO clock stable and ready detect flag
#define CSC_STA_XOSCF                               CSC->STA.MBIT.XOSCF             //[1] XOSC clock stable and ready detect flag
///@}
/**
 ******************************************************************************
 * @name        CSC_INT  [register's definitions]
 *              Offset[0x04]  CSC interrupt enable register (0x4C010004)
 ******************************************************************************
 */
///@{
#define CSC_INT                                     CSC->INT.W                      /*!< Offset[0x04]  CSC interrupt enable register (0x4C010004) */

/* Bit fields of CSC_INT */
#define CSC_INT_MCD_IE                              CSC->INT.MBIT.MCD_IE            //[7] XOSC missing clock detect failure event interrupt enable.
#define CSC_INT_PLL_IE                              CSC->INT.MBIT.PLL_IE            //[6] PLL clock stable interrupt enable.
#define CSC_INT_IHRCO_IE                            CSC->INT.MBIT.IHRCO_IE          //[5] IHRCO clock stable interrupt enable.
#define CSC_INT_ILRCO_IE                            CSC->INT.MBIT.ILRCO_IE          //[4] ILRCO clock stable interrupt enable.
#define CSC_INT_XOSC_IE                             CSC->INT.MBIT.XOSC_IE           //[1] XOSC clock stable interrupt enable.
#define CSC_INT_IEA                                 CSC->INT.MBIT.IEA               //[0] CSC interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        CSC_PLL  [register's definitions]
 *              Offset[0x08]  CSC OSC and PLL control register (0x4C010008)
 ******************************************************************************
 */
///@{
#define CSC_PLL                                     CSC->PLL.W                      /*!< Offset[0x08]  CSC OSC and PLL control register (0x4C010008) */

/* Bit fields of CSC_PLL */
#define CSC_PLL_XOSC_GN                             CSC->PLL.MBIT.XOSC_GN           //[17..16] Gain control bits of XOSC. (The default value is loaded from CFG OR after Warm reset)
#define CSC_PLL_PLL_MUL                             CSC->PLL.MBIT.PLL_MUL           //[8] CSC PLL multiplication factor select.
///@}
/**
 ******************************************************************************
 * @name        CSC_KEY  [register's definitions]
 *              Offset[0x0C]  CSC write protected Key register (0x4C01000C)
 ******************************************************************************
 */
///@{
#define CSC_KEY                                     CSC->KEY.W                      /*!< Offset[0x0C]  CSC write protected Key register (0x4C01000C) */

/* Bit fields of CSC_KEY */
#define CSC_KEY_KEY                                 CSC->KEY.MBIT.KEY               //[15..0] CSC key register
///@}
/**
 ******************************************************************************
 * @name        CSC_CR0  [register's definitions]
 *              Offset[0x10]  CSC clock source control register 0 (0x4C010010)
 ******************************************************************************
 */
///@{
#define CSC_CR0                                     CSC->CR0.W                      /*!< Offset[0x10]  CSC clock source control register 0 (0x4C010010) */

/* Bit fields of CSC_CR0 */
#define CSC_CR0_MCD_SEL                             CSC->CR0.MBIT.MCD_SEL           //[23..22] Missing clock detection duration select.
#define CSC_CR0_IHRCO_SEL                           CSC->CR0.MBIT.IHRCO_SEL         //[18] IHRCO clock frequency trimming set select.
#define CSC_CR0_ST_SEL                              CSC->CR0.MBIT.ST_SEL            //[16] System tick timer external clock source select.
#define CSC_CR0_MAIN_SEL                            CSC->CR0.MBIT.MAIN_SEL          //[15..14] System main clock source select.
#define CSC_CR0_HS_SEL                              CSC->CR0.MBIT.HS_SEL            //[11..10] Input high speed clock source select
#define CSC_CR0_LS_SEL                              CSC->CR0.MBIT.LS_SEL            //[9..8] Input low speed clock source select
#define CSC_CR0_PLL_EN                              CSC->CR0.MBIT.PLL_EN            //[5] PLL circuit enable.
#define CSC_CR0_MCD_DIS                             CSC->CR0.MBIT.MCD_DIS           //[4] MCD missing clock detector circuit disable.
#define CSC_CR0_IHRCO_EN                            CSC->CR0.MBIT.IHRCO_EN          //[3] IHRCO circuit enable
///@}
/**
 ******************************************************************************
 * @name        CSC_DIV  [register's definitions]
 *              Offset[0x14]  CSC clock  divider register (0x4C010014)
 ******************************************************************************
 */
///@{
#define CSC_DIV                                     CSC->DIV.W                      /*!< Offset[0x14]  CSC clock  divider register (0x4C010014) */

/* Bit fields of CSC_DIV */
#define CSC_DIV_UT_DIV                              CSC->DIV.MBIT.UT_DIV            //[27..26] Unit time clock source divider.
#define CSC_DIV_APB_DIV                             CSC->DIV.MBIT.APB_DIV           //[18..16] APB clock source divider. Value 0~4 mean to divide by 1,2,4,8,16.
#define CSC_DIV_AHB_DIV                             CSC->DIV.MBIT.AHB_DIV           //[11..8] AHB clock source divider. Value 0~9 mean to divide by 1,2,4,8,16,32,64,128,256,512.
#define CSC_DIV_PLLO_DIV                            CSC->DIV.MBIT.PLLO_DIV          //[5..4] PLL output clock source divider
#define CSC_DIV_PLLI_DIV                            CSC->DIV.MBIT.PLLI_DIV          //[1..0] PLL input clock source divider
///@}
/**
 ******************************************************************************
 * @name        CSC_CKO  [register's definitions]
 *              Offset[0x18]  CSC internal clock output control register (0x4C010018)
 ******************************************************************************
 */
///@{
#define CSC_CKO                                     CSC->CKO.W                      /*!< Offset[0x18]  CSC internal clock output control register (0x4C010018) */

/* Bit fields of CSC_CKO */
#define CSC_CKO_CKO_SEL                             CSC->CKO.MBIT.CKO_SEL           //[6..4] Internal clock output source select
#define CSC_CKO_CKO_DIV                             CSC->CKO.MBIT.CKO_DIV           //[3..2] Internal clock output divider
#define CSC_CKO_CKO_EN                              CSC->CKO.MBIT.CKO_EN            //[0] Internal clock output enable. When enables, it will reset the output divider.
///@}
/**
 ******************************************************************************
 * @name        CSC_AHB  [register's definitions]
 *              Offset[0x1C]  CSC AHB clock control register (0x4C01001C)
 ******************************************************************************
 */
///@{
#define CSC_AHB                                     CSC->AHB.W                      /*!< Offset[0x1C]  CSC AHB clock control register (0x4C01001C) */

/* Bit fields of CSC_AHB */
#define CSC_AHB_DMA_EN                              CSC->AHB.MBIT.DMA_EN            //[15] DMA clock source enable.
#define CSC_AHB_EMB_EN                              CSC->AHB.MBIT.EMB_EN            //[12] External memory bus clock source enable.
#define CSC_AHB_GPL_EN                              CSC->AHB.MBIT.GPL_EN            //[8] GPL clock source enable.
#define CSC_AHB_IOPE_EN                             CSC->AHB.MBIT.IOPE_EN           //[4] IO Port E clock source enable
#define CSC_AHB_IOPD_EN                             CSC->AHB.MBIT.IOPD_EN           //[3] IO Port D clock source enable
#define CSC_AHB_IOPC_EN                             CSC->AHB.MBIT.IOPC_EN           //[2] IO Port C clock source enable
#define CSC_AHB_IOPB_EN                             CSC->AHB.MBIT.IOPB_EN           //[1] IO Port B clock source enable
#define CSC_AHB_IOPA_EN                             CSC->AHB.MBIT.IOPA_EN           //[0] IO Port A clock source enable
///@}
/**
 ******************************************************************************
 * @name        CSC_APB0  [register's definitions]
 *              Offset[0x20]  CSC APB clock control register 0 (0x4C010020)
 ******************************************************************************
 */
///@{
#define CSC_APB0                                    CSC->APB0.W                     /*!< Offset[0x20]  CSC APB clock control register 0 (0x4C010020) */

/* Bit fields of CSC_APB0 */
#define CSC_APB0_URT3_EN                            CSC->APB0.MBIT.URT3_EN          //[19] URT3 UART module clock source enable.
#define CSC_APB0_URT2_EN                            CSC->APB0.MBIT.URT2_EN          //[18] URT2 UART module clock source enable.
#define CSC_APB0_URT1_EN                            CSC->APB0.MBIT.URT1_EN          //[17] URT1 UART module clock source enable.
#define CSC_APB0_URT0_EN                            CSC->APB0.MBIT.URT0_EN          //[16] URT0 UART module clock source enable.
#define CSC_APB0_SPI0_EN                            CSC->APB0.MBIT.SPI0_EN          //[12] SPI0 module clock source enable.
#define CSC_APB0_I2C1_EN                            CSC->APB0.MBIT.I2C1_EN          //[9] I2C1 module clock source enable.
#define CSC_APB0_I2C0_EN                            CSC->APB0.MBIT.I2C0_EN          //[8] I2C0 module clock source enable.
#define CSC_APB0_WWDT_EN                            CSC->APB0.MBIT.WWDT_EN          //[7] WWDT module clock source enable. (This register is reset only by Cold reset.)
#define CSC_APB0_IWDT_EN                            CSC->APB0.MBIT.IWDT_EN          //[6] IWDT module clock source enable
#define CSC_APB0_RTC_EN                             CSC->APB0.MBIT.RTC_EN           //[5] RTC module clock source enable
#define CSC_APB0_DAC_EN                             CSC->APB0.MBIT.DAC_EN           //[3] DAC module clock source enable.
#define CSC_APB0_CMP_EN                             CSC->APB0.MBIT.CMP_EN           //[2] CMP module clock source enable.
#define CSC_APB0_ADC0_EN                            CSC->APB0.MBIT.ADC0_EN          //[0] ADC module clock source enable.
///@}
/**
 ******************************************************************************
 * @name        CSC_APB1  [register's definitions]
 *              Offset[0x24]  CSC APB clock control register 1 (0x4C010024)
 ******************************************************************************
 */
///@{
#define CSC_APB1                                    CSC->APB1.W                     /*!< Offset[0x24]  CSC APB clock control register 1 (0x4C010024) */

/* Bit fields of CSC_APB1 */
#define CSC_APB1_TM36_EN                            CSC->APB1.MBIT.TM36_EN          //[15] TM36 module clock source enable.
#define CSC_APB1_TM26_EN                            CSC->APB1.MBIT.TM26_EN          //[11] TM26 module clock source enable.
#define CSC_APB1_TM20_EN                            CSC->APB1.MBIT.TM20_EN          //[8] TM20 module clock source enable.
#define CSC_APB1_TM16_EN                            CSC->APB1.MBIT.TM16_EN          //[7] TM11 module clock source enable.
#define CSC_APB1_TM10_EN                            CSC->APB1.MBIT.TM10_EN          //[4] TM10 module clock source enable.
#define CSC_APB1_TM01_EN                            CSC->APB1.MBIT.TM01_EN          //[1] TM01 module clock source enable.
#define CSC_APB1_TM00_EN                            CSC->APB1.MBIT.TM00_EN          //[0] TM00 module clock source enable.
///@}
/**
 ******************************************************************************
 * @name        CSC_SLP0  [register's definitions]
 *              Offset[0x30]  CSC SLEEP mode clock enable register 0 (0x4C010030)
 ******************************************************************************
 */
///@{
#define CSC_SLP0                                    CSC->SLP0.W                     /*!< Offset[0x30]  CSC SLEEP mode clock enable register 0 (0x4C010030) */

/* Bit fields of CSC_SLP0 */
#define CSC_SLP0_SLP_URT3                           CSC->SLP0.MBIT.SLP_URT3         //[19] URT3 UART module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_URT2                           CSC->SLP0.MBIT.SLP_URT2         //[18] URT2 UART module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_URT1                           CSC->SLP0.MBIT.SLP_URT1         //[17] URT1 UART module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_URT0                           CSC->SLP0.MBIT.SLP_URT0         //[16] URT0 UART module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_SPI0                           CSC->SLP0.MBIT.SLP_SPI0         //[12] SPI0 module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_I2C1                           CSC->SLP0.MBIT.SLP_I2C1         //[9] I2C1 module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_I2C0                           CSC->SLP0.MBIT.SLP_I2C0         //[8] I2C0 module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_WWDT                           CSC->SLP0.MBIT.SLP_WWDT         //[7] WWDT module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_IWDT                           CSC->SLP0.MBIT.SLP_IWDT         //[6] IWDT module clock enable in SLEEP mode
#define CSC_SLP0_SLP_RTC                            CSC->SLP0.MBIT.SLP_RTC          //[5] IWDT module clock enable in SLEEP mode
#define CSC_SLP0_SLP_DAC                            CSC->SLP0.MBIT.SLP_DAC          //[3] DAC module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_CMP                            CSC->SLP0.MBIT.SLP_CMP          //[2] CMP module clock enable in SLEEP mode.
#define CSC_SLP0_SLP_ADC0                           CSC->SLP0.MBIT.SLP_ADC0         //[0] ADC module clock enable in SLEEP mode.
///@}
/**
 ******************************************************************************
 * @name        CSC_SLP1  [register's definitions]
 *              Offset[0x34]  CSC SLEEP mode clock enable register 1 (0x4C010034)
 ******************************************************************************
 */
///@{
#define CSC_SLP1                                    CSC->SLP1.W                     /*!< Offset[0x34]  CSC SLEEP mode clock enable register 1 (0x4C010034) */

/* Bit fields of CSC_SLP1 */
#define CSC_SLP1_SLP_EMB                            CSC->SLP1.MBIT.SLP_EMB          //[30] EMB module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM36                           CSC->SLP1.MBIT.SLP_TM36         //[15] TM36 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM26                           CSC->SLP1.MBIT.SLP_TM26         //[11] TM26 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM20                           CSC->SLP1.MBIT.SLP_TM20         //[8] TM20 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM16                           CSC->SLP1.MBIT.SLP_TM16         //[7] TM11 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM10                           CSC->SLP1.MBIT.SLP_TM10         //[4] TM10 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM01                           CSC->SLP1.MBIT.SLP_TM01         //[1] TM01 module clock enable in SLEEP mode.
#define CSC_SLP1_SLP_TM00                           CSC->SLP1.MBIT.SLP_TM00         //[0] TM00 module clock enable in SLEEP mode.
///@}
/**
 ******************************************************************************
 * @name        CSC_STP0  [register's definitions]
 *              Offset[0x38]  CSC STOP mode clock enable register 0 (0x4C010038)
 ******************************************************************************
 */
///@{
#define CSC_STP0                                    CSC->STP0.W                     /*!< Offset[0x38]  CSC STOP mode clock enable register 0 (0x4C010038) */

/* Bit fields of CSC_STP0 */
#define CSC_STP0_STP_IWDT                           CSC->STP0.MBIT.STP_IWDT         //[6] IWDT module clock enable in STOP mode
#define CSC_STP0_STP_RTC                            CSC->STP0.MBIT.STP_RTC          //[5] IWDT module clock enable in STOP mode
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS0  [register's definitions]
 *              Offset[0x40]  CSC clock source select register 0 (0x4C010040)
 ******************************************************************************
 */
///@{
#define CSC_CKS0                                    CSC->CKS0.W                     /*!< Offset[0x40]  CSC clock source select register 0 (0x4C010040) */

/* Bit fields of CSC_CKS0 */
#define CSC_CKS0_DAC_CKS                            CSC->CKS0.MBIT.DAC_CKS          //[5] DAC process clock source select.
#define CSC_CKS0_CMP_CKS                            CSC->CKS0.MBIT.CMP_CKS          //[4] CMP process clock source select.
#define CSC_CKS0_ADC0_CKS                           CSC->CKS0.MBIT.ADC0_CKS         //[0] ADC0 process clock source select.
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS1  [register's definitions]
 *              Offset[0x44]  CSC clock source select register 1 (0x4C010044)
 ******************************************************************************
 */
///@{
#define CSC_CKS1                                    CSC->CKS1.W                     /*!< Offset[0x44]  CSC clock source select register 1 (0x4C010044) */

/* Bit fields of CSC_CKS1 */
#define CSC_CKS1_URT3_CKS                           CSC->CKS1.MBIT.URT3_CKS         //[22] URT3 process clock source select.
#define CSC_CKS1_URT2_CKS                           CSC->CKS1.MBIT.URT2_CKS         //[20] URT2 process clock source select.
#define CSC_CKS1_URT1_CKS                           CSC->CKS1.MBIT.URT1_CKS         //[18] URT1 process clock source select.
#define CSC_CKS1_URT0_CKS                           CSC->CKS1.MBIT.URT0_CKS         //[16] URT0 process clock source select.
#define CSC_CKS1_SPI0_CKS                           CSC->CKS1.MBIT.SPI0_CKS         //[8] SPI0 process clock source select.
#define CSC_CKS1_I2C1_CKS                           CSC->CKS1.MBIT.I2C1_CKS         //[2] I2C1 process clock source select.
#define CSC_CKS1_I2C0_CKS                           CSC->CKS1.MBIT.I2C0_CKS         //[0] I2C0 process clock source select.
///@}
/**
 ******************************************************************************
 * @name        CSC_CKS2  [register's definitions]
 *              Offset[0x48]  CSC clock source select register 2 (0x4C010048)
 ******************************************************************************
 */
///@{
#define CSC_CKS2                                    CSC->CKS2.W                     /*!< Offset[0x48]  CSC clock source select register 2 (0x4C010048) */

/* Bit fields of CSC_CKS2 */
#define CSC_CKS2_TM36_CKS                           CSC->CKS2.MBIT.TM36_CKS         //[30] TM36 process clock source select.
#define CSC_CKS2_TM26_CKS                           CSC->CKS2.MBIT.TM26_CKS         //[22] TM26 process clock source select.
#define CSC_CKS2_TM20_CKS                           CSC->CKS2.MBIT.TM20_CKS         //[16] TM20 process clock source select.
#define CSC_CKS2_TM16_CKS                           CSC->CKS2.MBIT.TM16_CKS         //[14] TM11 process clock source select.
#define CSC_CKS2_TM10_CKS                           CSC->CKS2.MBIT.TM10_CKS         //[8] TM10 process clock source select.
#define CSC_CKS2_TM01_CKS                           CSC->CKS2.MBIT.TM01_CKS         //[2] TM01 process clock source select.
#define CSC_CKS2_TM00_CKS                           CSC->CKS2.MBIT.TM00_CKS         //[0] TM00 process clock source select.
///@}

/*----------------------------------------------------------------------------*/
/* @module      PW (Power Control)                                            */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        PW_STA  [register's definitions]
 *              Offset[0x00]  PW status register (0x4C020000)
 ******************************************************************************
 */
///@{
#define PW_STA                                      PW->STA.W                       /*!< Offset[0x00]  PW status register (0x4C020000) */

/* Bit fields of PW_STA */
#define PW_STA_BOD1_S                               PW->STA.MBIT.BOD1_S             //[25] Brown-Out detect BOD1 status.
#define PW_STA_WKMODE                               PW->STA.MBIT.WKMODE             //[21..20] System wakeup from which power-down mode status.
#define PW_STA_STATE                                PW->STA.MBIT.STATE              //[17..16] System operation power mode state
#define PW_STA_WKF                                  PW->STA.MBIT.WKF                //[7] System received wakeup event flag. (set by hardware and clear by software writing 1)
#define PW_STA_BOD1F                                PW->STA.MBIT.BOD1F              //[5] BOD1 brown-out detection interrupt flag
#define PW_STA_BOD0F                                PW->STA.MBIT.BOD0F              //[4] BOD0 brown-out detection interrupt flag
#define PW_STA_PORF                                 PW->STA.MBIT.PORF               //[1] Power-On reset status flag. (set by hardware and clear by software writing 1)
///@}
/**
 ******************************************************************************
 * @name        PW_INT  [register's definitions]
 *              Offset[0x04]  PW interrupt enable register (0x4C020004)
 ******************************************************************************
 */
///@{
#define PW_INT                                      PW->INT.W                       /*!< Offset[0x04]  PW interrupt enable register (0x4C020004) */

/* Bit fields of PW_INT */
#define PW_INT_WK_IE                                PW->INT.MBIT.WK_IE              //[7] System received wakeup event interrupt enable bit.
#define PW_INT_BOD1_IE                              PW->INT.MBIT.BOD1_IE            //[5] BOD1 brown-out detection interrupt enable.
#define PW_INT_BOD0_IE                              PW->INT.MBIT.BOD0_IE            //[4] BOD0 brown-out detection interrupt enable.
#define PW_INT_IEA                                  PW->INT.MBIT.IEA                //[0] PW interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        PW_KEY  [register's definitions]
 *              Offset[0x0C]  PW write protected Key register (0x4C02000C)
 ******************************************************************************
 */
///@{
#define PW_KEY                                      PW->KEY.W                       /*!< Offset[0x0C]  PW write protected Key register (0x4C02000C) */

/* Bit fields of PW_KEY */
#define PW_KEY_KEY                                  PW->KEY.MBIT.KEY                //[15..0] PW key register
///@}
/**
 ******************************************************************************
 * @name        PW_CR0  [register's definitions]
 *              Offset[0x10]  PW control register 0 (0x4C020010)
 ******************************************************************************
 */
///@{
#define PW_CR0                                      PW->CR0.W                       /*!< Offset[0x10]  PW control register 0 (0x4C020010) */

/* Bit fields of PW_CR0 */
#define PW_CR0_WKSTP_DSEL                           PW->CR0.MBIT.WKSTP_DSEL         //[21..20] Wakeup delay time selection from STOP mode
#define PW_CR0_BOD1_TH                              PW->CR0.MBIT.BOD1_TH            //[11..10] BOD1 detect voltage threshold select
#define PW_CR0_BOD1_TRGS                            PW->CR0.MBIT.BOD1_TRGS          //[9..8] BOD1 Interrupt trigger selection.
#define PW_CR0_LDO_STP                              PW->CR0.MBIT.LDO_STP            //[7] Core voltage LDO mode select when STOP mode. (default=1)
#define PW_CR0_LDO_ON                               PW->CR0.MBIT.LDO_ON             //[6] Core voltage LDO mode select when ON or SLEEP mode.
#define PW_CR0_BOD1_EN                              PW->CR0.MBIT.BOD1_EN            //[5] BOD1 voltage detect enable.
#define PW_CR0_BOD0_EN                              PW->CR0.MBIT.BOD0_EN            //[4] BOD0 voltage detect enable.
#define PW_CR0_IVR_EN                               PW->CR0.MBIT.IVR_EN             //[1] Internal voltage reference source enable
///@}
/**
 ******************************************************************************
 * @name        PW_CR1  [register's definitions]
 *              Offset[0x14]  PW control register 1 (0x4C020014)
 ******************************************************************************
 */
///@{
#define PW_CR1                                      PW->CR1.W                       /*!< Offset[0x14]  PW control register 1 (0x4C020014) */

/* Bit fields of PW_CR1 */
#define PW_CR1_STP_CMP3                             PW->CR1.MBIT.STP_CMP3           //[23] Analog comparator CMP3 power-on configuration after enter STOP mode.
#define PW_CR1_STP_CMP2                             PW->CR1.MBIT.STP_CMP2           //[22] Analog comparator CMP2 power-on configuration after enter STOP mode.
#define PW_CR1_STP_CMP1                             PW->CR1.MBIT.STP_CMP1           //[21] Analog comparator CMP1 power-on configuration after enter STOP mode.
#define PW_CR1_STP_CMP0                             PW->CR1.MBIT.STP_CMP0           //[20] Analog comparator CMP0 power-on configuration after enter STOP mode.
#define PW_CR1_SLP_CMP3                             PW->CR1.MBIT.SLP_CMP3           //[19] Analog comparator CMP3 power-on configuration after enter SLEEP mode.
#define PW_CR1_SLP_CMP2                             PW->CR1.MBIT.SLP_CMP2           //[18] Analog comparator CMP2 power-on configuration after enter SLEEP mode.
#define PW_CR1_SLP_CMP1                             PW->CR1.MBIT.SLP_CMP1           //[17] Analog comparator CMP1 power-on configuration after enter SLEEP mode.
#define PW_CR1_SLP_CMP0                             PW->CR1.MBIT.SLP_CMP0           //[16] Analog comparator CMP0 power-on configuration after enter SLEEP mode.
#define PW_CR1_STP_BOD1                             PW->CR1.MBIT.STP_BOD1           //[5] BOD1 power-on configuration after enter STOP mode.
#define PW_CR1_STP_BOD0                             PW->CR1.MBIT.STP_BOD0           //[4] BOD0 power-on configuration after enter STOP mode
#define PW_CR1_STP_POR                              PW->CR1.MBIT.STP_POR            //[1] POR power-on configuration after enter STOP mode.
///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP0  [register's definitions]
 *              Offset[0x18]  PW STOP mode wakeup control register 0 (0x4C020018)
 ******************************************************************************
 */
///@{
#define PW_WKSTP0                                   PW->WKSTP0.W                    /*!< Offset[0x18]  PW STOP mode wakeup control register 0 (0x4C020018) */

/* Bit fields of PW_WKSTP0 */
#define PW_WKSTP0_WKSTP_CMP3                        PW->WKSTP0.MBIT.WKSTP_CMP3      //[19] Analog comparator CMP3 voltage detection wakeup from STOP mode enable bit.
#define PW_WKSTP0_WKSTP_CMP2                        PW->WKSTP0.MBIT.WKSTP_CMP2      //[18] Analog comparator CMP2 voltage detection wakeup from STOP mode enable bit.
#define PW_WKSTP0_WKSTP_CMP1                        PW->WKSTP0.MBIT.WKSTP_CMP1      //[17] Analog comparator CMP1 voltage detection wakeup from STOP mode enable bit.
#define PW_WKSTP0_WKSTP_CMP0                        PW->WKSTP0.MBIT.WKSTP_CMP0      //[16] Analog comparator CMP0 voltage detection wakeup from STOP mode enable bit.
#define PW_WKSTP0_WKSTP_BOD1                        PW->WKSTP0.MBIT.WKSTP_BOD1      //[5] BOD1 voltage detection wakeup from STOP mode enable bit.
#define PW_WKSTP0_WKSTP_BOD0                        PW->WKSTP0.MBIT.WKSTP_BOD0      //[4] BOD0 voltage detection wakeup from STOP mode enable bit.
///@}
/**
 ******************************************************************************
 * @name        PW_WKSTP1  [register's definitions]
 *              Offset[0x1C]  PW STOP mode wakeup control register 1 (0x4C02001C)
 ******************************************************************************
 */
///@{
#define PW_WKSTP1                                   PW->WKSTP1.W                    /*!< Offset[0x1C]  PW STOP mode wakeup control register 1 (0x4C02001C) */

/* Bit fields of PW_WKSTP1 */
#define PW_WKSTP1_WKSTP_I2C1                        PW->WKSTP1.MBIT.WKSTP_I2C1      //[9] I2C1 slave address detection event wakeup from STOP mode enable bit.
#define PW_WKSTP1_WKSTP_I2C0                        PW->WKSTP1.MBIT.WKSTP_I2C0      //[8] I2C0 slave address detection wakeup from STOP mode enable bit.
#define PW_WKSTP1_WKSTP_IWDT                        PW->WKSTP1.MBIT.WKSTP_IWDT      //[6] IWDT module events wakeup from STOP mode enable bit
#define PW_WKSTP1_WKSTP_RTC                         PW->WKSTP1.MBIT.WKSTP_RTC       //[5] RTC module events wakeup from STOP mode enable bit
///@}

/*----------------------------------------------------------------------------*/
/* @module      SYS (System Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        SYS_INT  [register's definitions]
 *              Offset[0x04]  SYS interrupt enable register (0x4C030004)
 ******************************************************************************
 */
///@{
#define SYS_INT                                     SYS->INT.W                      /*!< Offset[0x04]  SYS interrupt enable register (0x4C030004) */

/* Bit fields of SYS_INT */
#define SYS_INT_IEA                                 SYS->INT.MBIT.IEA               //[0] System interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        SYS_MID  [register's definitions]
 *              Offset[0x0C]  SYS chip manufacture identification code (0x4C03000C)
 ******************************************************************************
 */
///@{
#define SYS_MID                                     SYS->MID.W                      /*!< Offset[0x0C]  SYS chip manufacture identification code (0x4C03000C) */

/* Bit fields of SYS_MID */
#define SYS_MID_MID                                 SYS->MID.MBIT.MID               //[31..0] Chip manufacture identification code.
///@}
/**
 ******************************************************************************
 * @name        SYS_CR0  [register's definitions]
 *              Offset[0x10]  SYS System control register 0 (0x4C030010)
 ******************************************************************************
 */
///@{
#define SYS_CR0                                     SYS->CR0.W                      /*!< Offset[0x10]  SYS System control register 0 (0x4C030010) */

/* Bit fields of SYS_CR0 */
#define SYS_CR0_GPR                                 SYS->CR0.MBIT.GPR               //[23..19] General purpose data register bits.
#define SYS_CR0_CH2_LAST                            SYS->CR0.MBIT.CH2_LAST          //[18] DMA Channel-2 last loop command
#define SYS_CR0_CH1_LAST                            SYS->CR0.MBIT.CH1_LAST          //[17] DMA Channel-1 last loop command
#define SYS_CR0_CH0_LAST                            SYS->CR0.MBIT.CH0_LAST          //[16] DMA Channel-0 last loop command
///@}

/*----------------------------------------------------------------------------*/
/* @module      MEM (Memory Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        MEM_STA  [register's definitions]
 *              Offset[0x00]  MEM status register (0x4D000000)
 ******************************************************************************
 */
///@{
#define MEM_STA                                     MEM->STA.W                      /*!< Offset[0x00]  MEM status register (0x4D000000) */

/* Bit fields of MEM_STA */
#define MEM_STA_IAPSEF                              MEM->STA.MBIT.IAPSEF            //[16] IAP Flash memory size setting error flag.
#define MEM_STA_RPEF                                MEM->STA.MBIT.RPEF              //[6] Flash memory read protect error detection flag
#define MEM_STA_WPEF                                MEM->STA.MBIT.WPEF              //[5] Flash memory write protect error detection flag
#define MEM_STA_IAEF                                MEM->STA.MBIT.IAEF              //[4] Memory code execution illegal address error detection flag
#define MEM_STA_EOPF                                MEM->STA.MBIT.EOPF              //[1] Flash memory end of processing flag
#define MEM_STA_FBUSYF                              MEM->STA.MBIT.FBUSYF            //[0] Flash memory access busy flag.
///@}
/**
 ******************************************************************************
 * @name        MEM_INT  [register's definitions]
 *              Offset[0x04]  MEM interrupt enable register (0x4D000004)
 ******************************************************************************
 */
///@{
#define MEM_INT                                     MEM->INT.W                      /*!< Offset[0x04]  MEM interrupt enable register (0x4D000004) */

/* Bit fields of MEM_INT */
#define MEM_INT_RPE_RE                              MEM->INT.MBIT.RPE_RE            //[22] Flash memory read protect error detection reset enable.
#define MEM_INT_WPE_RE                              MEM->INT.MBIT.WPE_RE            //[21] Flash memory write protect error detection reset enable.
#define MEM_INT_IAE_RE                              MEM->INT.MBIT.IAE_RE            //[20] Memory code execution illegal address detection reset enable.
#define MEM_INT_RPE_IE                              MEM->INT.MBIT.RPE_IE            //[6] Flash memory read protect error detection interrupt enable.
#define MEM_INT_WPE_IE                              MEM->INT.MBIT.WPE_IE            //[5] Flash memory write protect error detection interrupt enable.
#define MEM_INT_IAE_IE                              MEM->INT.MBIT.IAE_IE            //[4] Memory code execution illegal address error detection interrupt enable.
#define MEM_INT_EOP_IE                              MEM->INT.MBIT.EOP_IE            //[1] Flash memory end of processing interrupt enable.
#define MEM_INT_IEA                                 MEM->INT.MBIT.IEA               //[0] Memory controller interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        MEM_KEY  [register's definitions]
 *              Offset[0x0C]  MEM write protected key register (0x4D00000C)
 ******************************************************************************
 */
///@{
#define MEM_KEY                                     MEM->KEY.W                      /*!< Offset[0x0C]  MEM write protected key register (0x4D00000C) */

/* Bit fields of MEM_KEY */
#define MEM_KEY_KEY2                                MEM->KEY.MBIT.KEY2              //[31..16] Reset key register-2
#define MEM_KEY_KEY                                 MEM->KEY.MBIT.KEY               //[15..0] Reset key register
///@}
/**
 ******************************************************************************
 * @name        MEM_CR0  [register's definitions]
 *              Offset[0x10]  MEM control register 0 (0x4D000010)
 ******************************************************************************
 */
///@{
#define MEM_CR0                                     MEM->CR0.W                      /*!< Offset[0x10]  MEM control register 0 (0x4D000010) */

/* Bit fields of MEM_CR0 */
#define MEM_CR0_IAP_AEN                             MEM->CR0.MBIT.IAP_AEN           //[21] IAP memory size MEM_IAP_SIZE register access enable
#define MEM_CR0_HSP_EN                              MEM->CR0.MBIT.HSP_EN            //[20] Flash memory read high speed mode enable during reset
#define MEM_CR0_BOOT_MS                             MEM->CR0.MBIT.BOOT_MS           //[17..16] System reset memory select and memory is mapped at 0x0000 0000
#define MEM_CR0_FWAIT                               MEM->CR0.MBIT.FWAIT             //[13..12] Flash memory read access wait state selection
#define MEM_CR0_MDS                                 MEM->CR0.MBIT.MDS               //[7..4] AP/IAP flash memory access mode select.
#define MEM_CR0_HOLD                                MEM->CR0.MBIT.HOLD              //[2] CPU hold control under flash memory access
#define MEM_CR0_HF_EN                               MEM->CR0.MBIT.HF_EN             //[1] Flash memory data access error HardFault enable
#define MEM_CR0_EN                                  MEM->CR0.MBIT.EN                //[0] Memory controller enable.
///@}
/**
 ******************************************************************************
 * @name        MEM_CR1  [register's definitions]
 *              Offset[0x14]  MEM control register 1 (0x4D000014)
 ******************************************************************************
 */
///@{
#define MEM_CR1                                     MEM->CR1.W                      /*!< Offset[0x14]  MEM control register 1 (0x4D000014) */

/* Bit fields of MEM_CR1 */
#define MEM_CR1_OB_WEN                              MEM->CR1.MBIT.OB_WEN            //[11] Flash OB0 Option-Byte memory write enable
#define MEM_CR1_ISP_REN                             MEM->CR1.MBIT.ISP_REN           //[9] Flash ISP Boot memory read enable for AP program
#define MEM_CR1_ISP_WEN                             MEM->CR1.MBIT.ISP_WEN           //[8] Flash ISP Boot memory write enable
#define MEM_CR1_IAP_EXEC                            MEM->CR1.MBIT.IAP_EXEC          //[4] Flash IAP data memory code execution function enable.
#define MEM_CR1_ISPD_REN                            MEM->CR1.MBIT.ISPD_REN          //[3] Flash ISP data memory read enable for ISP program
#define MEM_CR1_ISPD_WEN                            MEM->CR1.MBIT.ISPD_WEN          //[2] Flash ISP data memory write enable for ISP program
#define MEM_CR1_IAP_WEN                             MEM->CR1.MBIT.IAP_WEN           //[1] Flash IAP memory write enable.
#define MEM_CR1_AP_WEN                              MEM->CR1.MBIT.AP_WEN            //[0] Flash AP memory write enable.
///@}
/**
 ******************************************************************************
 * @name        MEM_SKEY  [register's definitions]
 *              Offset[0x1C]  MEM Flash memory protected key register (0x4D00001C)
 ******************************************************************************
 */
///@{
#define MEM_SKEY                                    MEM->SKEY.W                     /*!< Offset[0x1C]  MEM Flash memory protected key register (0x4D00001C) */

/* Bit fields of MEM_SKEY */
#define MEM_SKEY_SKEY2                              MEM->SKEY.MBIT.SKEY2            //[31..16] Reserved for internal using
#define MEM_SKEY_SKEY                               MEM->SKEY.MBIT.SKEY             //[7..0] MEM sequential key register for AP/IAP/ISPD flash
///@}
/**
 ******************************************************************************
 * @name        MEM_FADR  [register's definitions]
 *              Offset[0x20]  MEM Flash memory address register (0x4D000020)
 ******************************************************************************
 */
///@{
#define MEM_FADR                                    MEM->FADR.W                     /*!< Offset[0x20]  MEM Flash memory address register (0x4D000020) */

/* Bit fields of MEM_FADR */
#define MEM_FADR_FADR                               MEM->FADR.MBIT.FADR             //[31..0] Flash memory access address register
///@}
/**
 ******************************************************************************
 * @name        MEM_FDAT  [register's definitions]
 *              Offset[0x24]  MEM Flash memory data register (0x4D000024)
 ******************************************************************************
 */
///@{
#define MEM_FDAT                                    MEM->FDAT.W                     /*!< Offset[0x24]  MEM Flash memory data register (0x4D000024) */

/* Bit fields of MEM_FDAT */
#define MEM_FDAT_FDAT                               MEM->FDAT.MBIT.FDAT             //[31..0] Flash memory access data register.
///@}
/**
 ******************************************************************************
 * @name        MEM_IAPSZ  [register's definitions]
 *              Offset[0x28]  MEM Flash memory IAP size register (0x4D000028)
 ******************************************************************************
 */
///@{
#define MEM_IAPSZ                                   MEM->IAPSZ.W                    /*!< Offset[0x28]  MEM Flash memory IAP size register (0x4D000028) */

/* Bit fields of MEM_IAPSZ */
#define MEM_IAPSZ_IAP_SIZE                          MEM->IAPSZ.MBIT.IAP_SIZE        //[15..8] IAP memory size select
///@}
/**
 ******************************************************************************
 * @name        MEM_MCR  [register's definitions]
 *              Offset[0x2C]  MEM manufacturer control register (0x4D00002C)
 ******************************************************************************
 */
///@{
#define MEM_MCR                                     MEM->MCR.W                      /*!< Offset[0x2C]  MEM manufacturer control register (0x4D00002C) */

/* Bit fields of MEM_MCR */
#define MEM_MCR_OB1_WEN                             MEM->MCR.MBIT.OB1_WEN           //[0] Flash OB1 Option-Byte memory write enable
///@}

/*----------------------------------------------------------------------------*/
/* @module      EMB (Ext Memory Bus)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        EMB_STA  [register's definitions]
 *              Offset[0x00]  EMB status register (0x4D020000)
 ******************************************************************************
 */
///@{
#define EMB_STA                                     EMB->STA.W                      /*!< Offset[0x00]  EMB status register (0x4D020000) */

/* Bit fields of EMB_STA */
#define EMB_STA_WPEF                                EMB->STA.MBIT.WPEF              //[2] EMB bus write-protect error detect flag
#define EMB_STA_BUSYF                               EMB->STA.MBIT.BUSYF             //[0] EMB write/read access busy flag.
///@}
/**
 ******************************************************************************
 * @name        EMB_INT  [register's definitions]
 *              Offset[0x04]  EMB interrupt enable register (0x4D020004)
 ******************************************************************************
 */
///@{
#define EMB_INT                                     EMB->INT.W                      /*!< Offset[0x04]  EMB interrupt enable register (0x4D020004) */

/* Bit fields of EMB_INT */
#define EMB_INT_WPE_IE                              EMB->INT.MBIT.WPE_IE            //[2] EMB bus write-protect error detect interrupt enable.
#define EMB_INT_IEA                                 EMB->INT.MBIT.IEA               //[0] EMB controller interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        EMB_CLK  [register's definitions]
 *              Offset[0x08]  EMB clock source register (0x4D020008)
 ******************************************************************************
 */
///@{
#define EMB_CLK                                     EMB->CLK.W                      /*!< Offset[0x08]  EMB clock source register (0x4D020008) */

/* Bit fields of EMB_CLK */
#define EMB_CLK_CK_PSC                              EMB->CLK.MBIT.CK_PSC            //[6..4] EMB output clock MCLK prescaler. The value range 0~7 is indicated divider 1~8.
///@}
/**
 ******************************************************************************
 * @name        EMB_CR0  [register's definitions]
 *              Offset[0x10]  EMB control register 0 (0x4D020010)
 ******************************************************************************
 */
///@{
#define EMB_CR0                                     EMB->CR0.W                      /*!< Offset[0x10]  EMB control register 0 (0x4D020010) */

/* Bit fields of EMB_CR0 */
#define EMB_CR0_DMA_EN                              EMB->CR0.MBIT.DMA_EN            //[31] Direct memory access enable.
#define EMB_CR0_WE_CTL                              EMB->CR0.MBIT.WE_CTL            //[27] EMB MWE control timing select.
#define EMB_CR0_OE_CTL                              EMB->CR0.MBIT.OE_CTL            //[26] EMB MOE control timing select.
#define EMB_CR0_ALE2_MDS                            EMB->CR0.MBIT.ALE2_MDS          //[24] EMB MALE2 signal mode select. When EMB_MAM1_SEL=ALES, this register bit is no effect.
#define EMB_CR0_CE_MDS                              EMB->CR0.MBIT.CE_MDS            //[17..16] EMB MCE signal mode select.
#define EMB_CR0_ADR_SEL                             EMB->CR0.MBIT.ADR_SEL           //[13..12] EMB bus address range select
#define EMB_CR0_ADR_TWO                             EMB->CR0.MBIT.ADR_TWO           //[11] EMB two address phase timing mode enable
#define EMB_CR0_BUS_MDS                             EMB->CR0.MBIT.BUS_MDS           //[10] EMB address and data bus mode select.
#define EMB_CR0_SYNC_EN                             EMB->CR0.MBIT.SYNC_EN           //[3] EMB synchronous transaction enable bit
#define EMB_CR0_WEN                                 EMB->CR0.MBIT.WEN               //[1] EMB write access enable bit. 
#define EMB_CR0_EN                                  EMB->CR0.MBIT.EN                //[0] EMB controller enable bit.
///@}
/**
 ******************************************************************************
 * @name        EMB_CR1  [register's definitions]
 *              Offset[0x14]  EMB control register 1 (0x4D020014)
 ******************************************************************************
 */
///@{
#define EMB_CR1                                     EMB->CR1.W                      /*!< Offset[0x14]  EMB control register 1 (0x4D020014) */

/* Bit fields of EMB_CR1 */
#define EMB_CR1_WE_MUX                              EMB->CR1.MBIT.WE_MUX            //[31..30] MWE output signal select.
#define EMB_CR1_OE_MUX                              EMB->CR1.MBIT.OE_MUX            //[29..28] MOE output signal select.
#define EMB_CR1_BW1_SWO                             EMB->CR1.MBIT.BW1_SWO           //[25] EMB BW0 signal software control output data bit.
#define EMB_CR1_BW1_SWEN                            EMB->CR1.MBIT.BW1_SWEN          //[24] EMB BW0 signal output software control enable bit
#define EMB_CR1_BW0_SWO                             EMB->CR1.MBIT.BW0_SWO           //[23] EMB BW0 signal software control output data bit.
#define EMB_CR1_BW0_SWEN                            EMB->CR1.MBIT.BW0_SWEN          //[22] EMB BW0 signal output software control enable bit
#define EMB_CR1_ALE2_SWO                            EMB->CR1.MBIT.ALE2_SWO          //[21] EMB MALE2 signal software control output data bit.
#define EMB_CR1_ALE2_SWEN                           EMB->CR1.MBIT.ALE2_SWEN         //[20] EMB MALE2 signal output software control enable bit
#define EMB_CR1_ALE_SWO                             EMB->CR1.MBIT.ALE_SWO           //[19] EMB MALE signal software control output data bit.
#define EMB_CR1_ALE_SWEN                            EMB->CR1.MBIT.ALE_SWEN          //[18] EMB MALE signal output software control enable bit
#define EMB_CR1_CE_SWO                              EMB->CR1.MBIT.CE_SWO            //[17] EMB MCE signal software control output data bit.
#define EMB_CR1_CE_SWEN                             EMB->CR1.MBIT.CE_SWEN           //[16] EMB MCE signal output software control enable bit
#define EMB_CR1_MAM1_SEL                            EMB->CR1.MBIT.MAM1_SEL          //[13..12] EMB internal memory address A-1 signal output pin select
#define EMB_CR1_MA_SWAP                             EMB->CR1.MBIT.MA_SWAP           //[8] EMB MA[15:0] signals Msb/Lsb swap enable bit.
#define EMB_CR1_CLK_INV                             EMB->CR1.MBIT.CLK_INV           //[3] EMB MCLK clock output inverse enable bit.
#define EMB_CR1_ALE2_INV                            EMB->CR1.MBIT.ALE2_INV          //[2] EMB MALE2 output inverse enable bit. The hardware active level is default logic high.
#define EMB_CR1_ALE_INV                             EMB->CR1.MBIT.ALE_INV           //[1] EMB MALE output inverse enable bit. The hardware active level is default logic high.
#define EMB_CR1_CE_INV                              EMB->CR1.MBIT.CE_INV            //[0] EMB MCE output inverse enable bit. The hardware active level is default logic low.
///@}
/**
 ******************************************************************************
 * @name        EMB_CR2  [register's definitions]
 *              Offset[0x18]  EMB control register 2 (0x4D020018)
 ******************************************************************************
 */
///@{
#define EMB_CR2                                     EMB->CR2.W                      /*!< Offset[0x18]  EMB control register 2 (0x4D020018) */

/* Bit fields of EMB_CR2 */
#define EMB_CR2_ACCH                                EMB->CR2.MBIT.ACCH              //[20] EMB SRAM/NOR bus data write access hold time
#define EMB_CR2_ACCW                                EMB->CR2.MBIT.ACCW              //[19..16] EMB SRAM/NOR bus data access time
#define EMB_CR2_ACCS                                EMB->CR2.MBIT.ACCS              //[12] EMB SRAM/NOR bus data access setup time
#define EMB_CR2_ALEH                                EMB->CR2.MBIT.ALEH              //[8] EMB SRAM/NOR bus ALE/ALE2 hold time
#define EMB_CR2_ALEW                                EMB->CR2.MBIT.ALEW              //[6..4] EMB SRAM/NOR bus ALE/ALE2 pulse width
#define EMB_CR2_ALES                                EMB->CR2.MBIT.ALES              //[0] EMB SRAM/NOR bus ALE/ALE2 setup time
///@}

/*----------------------------------------------------------------------------*/
/* @module      CFG (Hardware Configure)                                      */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CFG_KEY  [register's definitions]
 *              Offset[0x0C]  CFG write protected Key register (0x4FF0000C)
 ******************************************************************************
 */
///@{
#define CFG_KEY                                     CFG->KEY.W                      /*!< Offset[0x0C]  CFG write protected Key register (0x4FF0000C) */

/* Bit fields of CFG_KEY */
#define CFG_KEY_KEY                                 CFG->KEY.MBIT.KEY               //[15..0] CFG key register
///@}
/**
 ******************************************************************************
 * @name        CFG_OR00  [register's definitions]
 *              Offset[0x10]  CFG option byte register 00 (0x4FF00010)
 ******************************************************************************
 */
///@{
#define CFG_OR00                                    CFG->OR00.W                     /*!< Offset[0x10]  CFG option byte register 00 (0x4FF00010) */

/* Bit fields of CFG_OR00 */
#define CFG_OR00_BOD1_WE                            CFG->OR00.MBIT.BOD1_WE          //[25] BOD1 trigger Warm reset enable
#define CFG_OR00_BOD0_WE                            CFG->OR00.MBIT.BOD0_WE          //[24] BOD0 trigger Warm reset enable
#define CFG_OR00_BOD1_TH                            CFG->OR00.MBIT.BOD1_TH          //[17..16] BOD1 detect voltage threshold select.
#define CFG_OR00_LOCK_DIS                           CFG->OR00.MBIT.LOCK_DIS         //[8] Main Flash code locked enable
#define CFG_OR00_BOOT_MS                            CFG->OR00.MBIT.BOOT_MS          //[1..0] System cold reset boot memory select and memory is mapped at 0x0000 0000
///@}
/**
 ******************************************************************************
 * @name        CFG_OR01  [register's definitions]
 *              Offset[0x14]  CFG option byte register 01 (0x4FF00014)
 ******************************************************************************
 */
///@{
#define CFG_OR01                                    CFG->OR01.W                     /*!< Offset[0x14]  CFG option byte register 01 (0x4FF00014) */

/* Bit fields of CFG_OR01 */
#define CFG_OR01_IAP_SIZE                           CFG->OR01.MBIT.IAP_SIZE         //[15..8] IAP memory size select
///@}
/**
 ******************************************************************************
 * @name        CFG_OR02  [register's definitions]
 *              Offset[0x18]  CFG option byte register 02 (0x4FF00018)
 ******************************************************************************
 */
///@{
#define CFG_OR02                                    CFG->OR02.W                     /*!< Offset[0x18]  CFG option byte register 02 (0x4FF00018) */

/* Bit fields of CFG_OR02 */
#define CFG_OR02_ISP_SIZE                           CFG->OR02.MBIT.ISP_SIZE         //[15..8] ISP memory size select
///@}
/**
 ******************************************************************************
 * @name        CFG_OR03  [register's definitions]
 *              Offset[0x1C]  CFG option byte register 03 (0x4FF0001C)
 ******************************************************************************
 */
///@{
#define CFG_OR03                                    CFG->OR03.W                     /*!< Offset[0x1C]  CFG option byte register 03 (0x4FF0001C) */

/* Bit fields of CFG_OR03 */
#define CFG_OR03_IWDT_STP                           CFG->OR03.MBIT.IWDT_STP         //[9] IWDT counting control when chip in STOP mode
#define CFG_OR03_IWDT_SLP                           CFG->OR03.MBIT.IWDT_SLP         //[8] IWDT counting control when chip in SLEEP mode
#define CFG_OR03_IWDT_DIV                           CFG->OR03.MBIT.IWDT_DIV         //[7..4] IWDT internal clock CK_IWDT_INT input divider select
#define CFG_OR03_IWDT_WE                            CFG->OR03.MBIT.IWDT_WE          //[2] IWDT reset generation enable option
#define CFG_OR03_IWDT_WP                            CFG->OR03.MBIT.IWDT_WP          //[1] IWDT registers write protected enable
#define CFG_OR03_IWDT_EN                            CFG->OR03.MBIT.IWDT_EN          //[0] IWDT enable after Cold reset
///@}
/**
 ******************************************************************************
 * @name        CFG_OR04  [register's definitions]
 *              Offset[0x20]  CFG option byte register 04 (0x4FF00020)
 ******************************************************************************
 */
///@{
#define CFG_OR04                                    CFG->OR04.W                     /*!< Offset[0x20]  CFG option byte register 04 (0x4FF00020) */

/* Bit fields of CFG_OR04 */
#define CFG_OR04_HSP_EN                             CFG->OR04.MBIT.HSP_EN           //[7] Flash memory high speed mode enable.
#define CFG_OR04_IAP_AEN                            CFG->OR04.MBIT.IAP_AEN          //[0] IAP memory size MEM_IAP_SIZE register write  access disable.
///@}
/**
 ******************************************************************************
 * @name        CFG_OR05  [register's definitions]
 *              Offset[0x24]  CFG option byte register 05 (0x4FF00024)
 ******************************************************************************
 */
///@{
#define CFG_OR05                                    CFG->OR05.W                     /*!< Offset[0x24]  CFG option byte register 05 (0x4FF00024) */

/* Bit fields of CFG_OR05 */
#define CFG_OR05_XOSC_EN                            CFG->OR05.MBIT.XOSC_EN          //[31] XOSC crystal oscillation circuit enable
#define CFG_OR05_XOSC_DB                            CFG->OR05.MBIT.XOSC_DB          //[28] XOSC clock debounce cycle select
#define CFG_OR05_XOSC_GN                            CFG->OR05.MBIT.XOSC_GN          //[25..24] Gain control bits of XOSC.
#define CFG_OR05_HSWKP                              CFG->OR05.MBIT.HSWKP            //[23..22] Wakeup delay selection from STOP mode
#define CFG_OR05_PLL_CTL                            CFG->OR05.MBIT.PLL_CTL          //[21..20] PLL control bits
#define CFG_OR05_HS_SEL                             CFG->OR05.MBIT.HS_SEL           //[17] CK_HS clock source select after power-on (Cold reset)
#define CFG_OR05_PON_MDS                            CFG->OR05.MBIT.PON_MDS          //[8] Fast power-up time mode select.
#define CFG_OR05_SWD_PIN                            CFG->OR05.MBIT.SWD_PIN          //[1] SWD interface pin control after power-on
#define CFG_OR05_EXRST_PIN                          CFG->OR05.MBIT.EXRST_PIN        //[0] External reset pin control after power-on
///@}
/**
 ******************************************************************************
 * @name        CFG_OR07  [register's definitions]
 *              Offset[0x2C]  CFG option byte register 07 (0x4FF0002C)
 ******************************************************************************
 */
///@{
#define CFG_OR07                                    CFG->OR07.W                     /*!< Offset[0x2C]  CFG option byte register 07 (0x4FF0002C) */

/* Bit fields of CFG_OR07 */
#define CFG_OR07_GF                                 CFG->OR07.MBIT.GF               //[15..13] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_CGIL                               CFG->OR07.MBIT.CGIL             //[12] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_DPORDS                             CFG->OR07.MBIT.DPORDS           //[11] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_PORDS                              CFG->OR07.MBIT.PORDS            //[10] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_PNDRC                              CFG->OR07.MBIT.PNDRC            //[9] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_PNDCE                              CFG->OR07.MBIT.PNDCE            //[8] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_LVRDS1                             CFG->OR07.MBIT.LVRDS1           //[7] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_LVRDS0                             CFG->OR07.MBIT.LVRDS0           //[6] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_LVRDE                              CFG->OR07.MBIT.LVRDE            //[5] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_CG22                               CFG->OR07.MBIT.CG22             //[2] OR control bit. (This bit is loaded by inverting from option byte flash data.)
#define CFG_OR07_CG21                               CFG->OR07.MBIT.CG21             //[1] OR control bit. (This bit is loaded by inverting from option byte flash data.)
///@}
/**
 ******************************************************************************
 * @name        CFG_OR11  [register's definitions]
 *              Offset[0x34]  CFG option byte register 11 (0x4FF00034)
 ******************************************************************************
 */
///@{
#define CFG_OR11                                    CFG->OR11.W                     /*!< Offset[0x34]  CFG option byte register 11 (0x4FF00034) */

/* Bit fields of CFG_OR11 */
#define CFG_OR11_DAC_CTRM0                          CFG->OR11.MBIT.DAC_CTRM0        //[20..16] DAC-0 output current trimming bits.
#define CFG_OR11_VBG_BTRM                           CFG->OR11.MBIT.VBG_BTRM         //[11..8] BandGap buffer output trimming bits.
#define CFG_OR11_VBG_OTRM                           CFG->OR11.MBIT.VBG_OTRM         //[2..0] BandGap reference voltage output trimming bits.
///@}
/**
 ******************************************************************************
 * @name        CFG_OR12  [register's definitions]
 *              Offset[0x38]  CFG option byte register 12 (0x4FF00038)
 ******************************************************************************
 */
///@{
#define CFG_OR12                                    CFG->OR12.W                     /*!< Offset[0x38]  CFG option byte register 12 (0x4FF00038) */

/* Bit fields of CFG_OR12 */
#define CFG_OR12_LVR_TRM                            CFG->OR12.MBIT.LVR_TRM          //[19..16] Reserved
#define CFG_OR12_BOD1_TRM                           CFG->OR12.MBIT.BOD1_TRM         //[11..8] Reserved
///@}
/**
 ******************************************************************************
 * @name        CFG_OR13  [register's definitions]
 *              Offset[0x3C]  CFG option byte register 13 (0x4FF0003C)
 ******************************************************************************
 */
///@{
#define CFG_OR13                                    CFG->OR13.W                     /*!< Offset[0x3C]  CFG option byte register 13 (0x4FF0003C) */

/* Bit fields of CFG_OR13 */
#define CFG_OR13_IHR1_CTRM                          CFG->OR13.MBIT.IHR1_CTRM        //[25..24] Reserved
#define CFG_OR13_IHR1_FTRM                          CFG->OR13.MBIT.IHR1_FTRM        //[22..16] Reserved
#define CFG_OR13_IHR0_CTRM                          CFG->OR13.MBIT.IHR0_CTRM        //[9..8] Reserved
#define CFG_OR13_IHR0_FTRM                          CFG->OR13.MBIT.IHR0_FTRM        //[6..0] Reserved
///@}
/**
 ******************************************************************************
 * @name        CFG_OR14  [register's definitions]
 *              Offset[0x40]  CFG option byte register 14 (0x4FF00040)
 ******************************************************************************
 */
///@{
#define CFG_OR14                                    CFG->OR14.W                     /*!< Offset[0x40]  CFG option byte register 14 (0x4FF00040) */

/* Bit fields of CFG_OR14 */
#define CFG_OR14_IHR_BGTI                           CFG->OR14.MBIT.IHR_BGTI         //[15..13] Reserved
#define CFG_OR14_IHR_BGTV                           CFG->OR14.MBIT.IHR_BGTV         //[9..8] Reserved
#define CFG_OR14_ILR_TRM                            CFG->OR14.MBIT.ILR_TRM          //[1..0] Reserved
///@}
/**
 ******************************************************************************
 * @name        CFG_OR15  [register's definitions]
 *              Offset[0x44]  CFG option byte register 15 (0x4FF00044)
 ******************************************************************************
 */
///@{
#define CFG_OR15                                    CFG->OR15.W                     /*!< Offset[0x44]  CFG option byte register 15 (0x4FF00044) */

/* Bit fields of CFG_OR15 */
#define CFG_OR15_ADC0_REFT                          CFG->OR15.MBIT.ADC0_REFT        //[29..24] ADC0 reference voltage top level setting.
#define CFG_OR15_ADC0_REFM                          CFG->OR15.MBIT.ADC0_REFM        //[21..16] ADC0 reference voltage middle level setting.
#define CFG_OR15_ADC0_REFB                          CFG->OR15.MBIT.ADC0_REFB        //[13..8] ADC0 reference voltage bottom level setting.
///@}
/**
 ******************************************************************************
 * @name        CFG_OR16  [register's definitions]
 *              Offset[0x48]  CFG option byte register 16 (0x4FF00048)
 ******************************************************************************
 */
///@{
#define CFG_OR16                                    CFG->OR16.W                     /*!< Offset[0x48]  CFG option byte register 16 (0x4FF00048) */

/* Bit fields of CFG_OR16 */
#define CFG_OR16_TEMP_CAL1                          CFG->OR16.MBIT.TEMP_CAL1        //[27..16] Temperature Sensor calibration value acquired at 60 degree-C.
#define CFG_OR16_TEMP_CAL0                          CFG->OR16.MBIT.TEMP_CAL0        //[11..0] Temperature Sensor calibration value acquired at 25 degree-C.
///@}
/**
 ******************************************************************************
 * @name        CFG_OR17  [register's definitions]
 *              Offset[0x4C]  CFG option byte register 17 (0x4FF0004C)
 ******************************************************************************
 */
///@{
#define CFG_OR17                                    CFG->OR17.W                     /*!< Offset[0x4C]  CFG option byte register 17 (0x4FF0004C) */

/* Bit fields of CFG_OR17 */
#define CFG_OR17_LDO_TRM                            CFG->OR17.MBIT.LDO_TRM          //[2..0] Reserved
///@}
/**
 ******************************************************************************
 * @name        CFG_TST0  [register's definitions]
 *              Offset[0x60]  CFG Test register 0 (not load from flash memory) (0x4FF00060)
 ******************************************************************************
 */
///@{
#define CFG_TST0                                    CFG->TST0.W                     /*!< Offset[0x60]  CFG Test register 0 (not load from flash memory) (0x4FF00060) */

/* Bit fields of CFG_TST0 */
#define CFG_TST0_PNDF                               CFG->TST0.MBIT.PNDF             //[6] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_DBLVRF                             CFG->TST0.MBIT.DBLVRF           //[5] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_LVRF0                              CFG->TST0.MBIT.LVRF0            //[4] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_DPORF                              CFG->TST0.MBIT.DPORF            //[3] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_POF2                               CFG->TST0.MBIT.POF2             //[2] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_POF1                               CFG->TST0.MBIT.POF1             //[1] Test using flag. (set by hardware and clear by software writing 1)
#define CFG_TST0_POF0                               CFG->TST0.MBIT.POF0             //[0] Test using flag. (set by hardware and clear by software writing 1)
///@}
/**
 ******************************************************************************
 * @name        CFG_TST1  [register's definitions]
 *              Offset[0x64]  CFG Test register 1 (not load from flash memory) (0x4FF00064)
 ******************************************************************************
 */
///@{
#define CFG_TST1                                    CFG->TST1.W                     /*!< Offset[0x64]  CFG Test register 1 (not load from flash memory) (0x4FF00064) */

/* Bit fields of CFG_TST1 */
#define CFG_TST1_PLL_TST                            CFG->TST1.MBIT.PLL_TST          //[24] PLL test enable.
#define CFG_TST1_ILRCO_EN                           CFG->TST1.MBIT.ILRCO_EN         //[18] Internal Low frequency RC Oscillator Enable
#define CFG_TST1_ILRCK_OE                           CFG->TST1.MBIT.ILRCK_OE         //[17] ILRCO clock output enable
#define CFG_TST1_IHRCK_OE                           CFG->TST1.MBIT.IHRCK_OE         //[16] IHRCO clock output enable
#define CFG_TST1_LVR_DIS                            CFG->TST1.MBIT.LVR_DIS          //[9] LVR disable bit
#define CFG_TST1_BOD_OE                             CFG->TST1.MBIT.BOD_OE           //[8] BOD0/1 output enable
#define CFG_TST1_FLH_WE                             CFG->TST1.MBIT.FLH_WE           //[0] Enable flash write operation when BOD0 active(low voltage).
///@}

/*----------------------------------------------------------------------------*/
/* @module      EXIC (EXIC Interrupt)                                         */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        EXIC_STA  [register's definitions]
 *              Offset[0x00]  EXIC interrupt status register (0x50000000)
 ******************************************************************************
 */
///@{
#define EXIC_STA                                    EXIC->STA.W                     /*!< Offset[0x00]  EXIC interrupt status register (0x50000000) */

/* Bit fields of EXIC_STA */
#define EXIC_STA_PD_AF                              EXIC->STA.MBIT.PD_AF            //[13] External interrupt PDx AND path interrupt flag
#define EXIC_STA_PD_OF                              EXIC->STA.MBIT.PD_OF            //[12] External interrupt PDx OR path interrupt flag. (set and clear by hardware)
#define EXIC_STA_PC_AF                              EXIC->STA.MBIT.PC_AF            //[9] External interrupt PCx AND path interrupt flag
#define EXIC_STA_PC_OF                              EXIC->STA.MBIT.PC_OF            //[8] External interrupt PCx OR path interrupt flag. (set and clear by hardware)
#define EXIC_STA_PB_AF                              EXIC->STA.MBIT.PB_AF            //[5] External interrupt PBx AND path interrupt flag
#define EXIC_STA_PB_OF                              EXIC->STA.MBIT.PB_OF            //[4] External interrupt PBx OR path interrupt flag. (set and clear by hardware)
#define EXIC_STA_PA_AF                              EXIC->STA.MBIT.PA_AF            //[1] External interrupt PAx AND path interrupt flag 
#define EXIC_STA_PA_OF                              EXIC->STA.MBIT.PA_OF            //[0] External interrupt PAx OR path interrupt flag. (set and clear by hardware)
///@}
/**
 ******************************************************************************
 * @name        EXIC_INT  [register's definitions]
 *              Offset[0x04]  EXIC interrupt enable register (0x50000004)
 ******************************************************************************
 */
///@{
#define EXIC_INT                                    EXIC->INT.W                     /*!< Offset[0x04]  EXIC interrupt enable register (0x50000004) */

/* Bit fields of EXIC_INT */
#define EXIC_INT_PD_IEA                             EXIC->INT.MBIT.PD_IEA           //[3] EXIC port PD external interrupt all enable
#define EXIC_INT_PC_IEA                             EXIC->INT.MBIT.PC_IEA           //[2] EXIC port PC external interrupt all enable
#define EXIC_INT_PB_IEA                             EXIC->INT.MBIT.PB_IEA           //[1] EXIC port PB external interrupt all enable
#define EXIC_INT_PA_IEA                             EXIC->INT.MBIT.PA_IEA           //[0] EXIC port PA external interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        EXIC_CR0  [register's definitions]
 *              Offset[0x10]  EXIC control register 0 (0x50000010)
 ******************************************************************************
 */
///@{
#define EXIC_CR0                                    EXIC->CR0.W                     /*!< Offset[0x10]  EXIC control register 0 (0x50000010) */

/* Bit fields of EXIC_CR0 */
#define EXIC_CR0_PD_AINV                            EXIC->CR0.MBIT.PD_AINV          //[27] External interrupt PDx AND path signal inverse enable bit.
#define EXIC_CR0_PC_AINV                            EXIC->CR0.MBIT.PC_AINV          //[26] External interrupt PCx AND path signal inverse enable bit.
#define EXIC_CR0_PB_AINV                            EXIC->CR0.MBIT.PB_AINV          //[25] External interrupt PBx AND path signal inverse enable bit.
#define EXIC_CR0_PA_AINV                            EXIC->CR0.MBIT.PA_AINV          //[24] External interrupt PAx AND path signal inverse enable bit.
#define EXIC_CR0_EM_RXEV                            EXIC->CR0.MBIT.EM_RXEV          //[9] Interrupt event mask control bit for RXEV.
#define EXIC_CR0_EM_NMI                             EXIC->CR0.MBIT.EM_NMI           //[8] Interrupt event mask control bit for NMI.
#define EXIC_CR0_NMI_SW                             EXIC->CR0.MBIT.NMI_SW           //[1] Software NMI trigger bit. (set by software and clear by hardware)
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_PF  [register's definitions]
 *              Offset[0x20]  EXIC PA input interrupt pending flag register (0x50000020)
 ******************************************************************************
 */
///@{
#define EXIC_PA_PF                                  EXIC->PA_PF.W                   /*!< Offset[0x20]  EXIC PA input interrupt pending flag register (0x50000020) */

/* Bit fields of EXIC_PA_PF */
#define EXIC_PA_PF_PA15_PF                          EXIC->PA_PF.MBIT.PA15_PF        //[15] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA14_PF                          EXIC->PA_PF.MBIT.PA14_PF        //[14] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA13_PF                          EXIC->PA_PF.MBIT.PA13_PF        //[13] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA12_PF                          EXIC->PA_PF.MBIT.PA12_PF        //[12] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA11_PF                          EXIC->PA_PF.MBIT.PA11_PF        //[11] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA10_PF                          EXIC->PA_PF.MBIT.PA10_PF        //[10] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA9_PF                           EXIC->PA_PF.MBIT.PA9_PF         //[9] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA8_PF                           EXIC->PA_PF.MBIT.PA8_PF         //[8] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA7_PF                           EXIC->PA_PF.MBIT.PA7_PF         //[7] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA6_PF                           EXIC->PA_PF.MBIT.PA6_PF         //[6] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA5_PF                           EXIC->PA_PF.MBIT.PA5_PF         //[5] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA4_PF                           EXIC->PA_PF.MBIT.PA4_PF         //[4] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA3_PF                           EXIC->PA_PF.MBIT.PA3_PF         //[3] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA2_PF                           EXIC->PA_PF.MBIT.PA2_PF         //[2] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA1_PF                           EXIC->PA_PF.MBIT.PA1_PF         //[1] Refer to EXIC_PA0_PF.
#define EXIC_PA_PF_PA0_PF                           EXIC->PA_PF.MBIT.PA0_PF         //[0] EXIC pin input interrupt pending flag x for external input interrupt pin PAx
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_TRGS  [register's definitions]
 *              Offset[0x24]  EXIC PA Pad input trigger select register (0x50000024)
 ******************************************************************************
 */
///@{
#define EXIC_PA_TRGS                                EXIC->PA_TRGS.W                 /*!< Offset[0x24]  EXIC PA Pad input trigger select register (0x50000024) */

/* Bit fields of EXIC_PA_TRGS */
#define EXIC_PA_TRGS_PA15_TRGS                      EXIC->PA_TRGS.MBIT.PA15_TRGS    //[31..30] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA14_TRGS                      EXIC->PA_TRGS.MBIT.PA14_TRGS    //[29..28] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA13_TRGS                      EXIC->PA_TRGS.MBIT.PA13_TRGS    //[27..26] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA12_TRGS                      EXIC->PA_TRGS.MBIT.PA12_TRGS    //[25..24] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA11_TRGS                      EXIC->PA_TRGS.MBIT.PA11_TRGS    //[23..22] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA10_TRGS                      EXIC->PA_TRGS.MBIT.PA10_TRGS    //[21..20] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA9_TRGS                       EXIC->PA_TRGS.MBIT.PA9_TRGS     //[19..18] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA8_TRGS                       EXIC->PA_TRGS.MBIT.PA8_TRGS     //[17..16] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA7_TRGS                       EXIC->PA_TRGS.MBIT.PA7_TRGS     //[15..14] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA6_TRGS                       EXIC->PA_TRGS.MBIT.PA6_TRGS     //[13..12] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA5_TRGS                       EXIC->PA_TRGS.MBIT.PA5_TRGS     //[11..10] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA4_TRGS                       EXIC->PA_TRGS.MBIT.PA4_TRGS     //[9..8] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA3_TRGS                       EXIC->PA_TRGS.MBIT.PA3_TRGS     //[7..6] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA2_TRGS                       EXIC->PA_TRGS.MBIT.PA2_TRGS     //[5..4] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA1_TRGS                       EXIC->PA_TRGS.MBIT.PA1_TRGS     //[3..2] Refer to EXIC_PA0_TRGS.
#define EXIC_PA_TRGS_PA0_TRGS                       EXIC->PA_TRGS.MBIT.PA0_TRGS     //[1..0] External interrupt pin edge/level trigger event select
///@}
/**
 ******************************************************************************
 * @name        EXIC_PA_MSK  [register's definitions]
 *              Offset[0x28]  EXIC PA AOI Mask register (0x50000028)
 ******************************************************************************
 */
///@{
#define EXIC_PA_MSK                                 EXIC->PA_MSK.W                  /*!< Offset[0x28]  EXIC PA AOI Mask register (0x50000028) */

/* Bit fields of EXIC_PA_MSK */
#define EXIC_PA_MSK_PA15_AM                         EXIC->PA_MSK.MBIT.PA15_AM       //[31] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA14_AM                         EXIC->PA_MSK.MBIT.PA14_AM       //[30] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA13_AM                         EXIC->PA_MSK.MBIT.PA13_AM       //[29] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA12_AM                         EXIC->PA_MSK.MBIT.PA12_AM       //[28] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA11_AM                         EXIC->PA_MSK.MBIT.PA11_AM       //[27] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA10_AM                         EXIC->PA_MSK.MBIT.PA10_AM       //[26] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA9_AM                          EXIC->PA_MSK.MBIT.PA9_AM        //[25] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA8_AM                          EXIC->PA_MSK.MBIT.PA8_AM        //[24] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA7_AM                          EXIC->PA_MSK.MBIT.PA7_AM        //[23] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA6_AM                          EXIC->PA_MSK.MBIT.PA6_AM        //[22] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA5_AM                          EXIC->PA_MSK.MBIT.PA5_AM        //[21] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA4_AM                          EXIC->PA_MSK.MBIT.PA4_AM        //[20] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA3_AM                          EXIC->PA_MSK.MBIT.PA3_AM        //[19] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA2_AM                          EXIC->PA_MSK.MBIT.PA2_AM        //[18] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA1_AM                          EXIC->PA_MSK.MBIT.PA1_AM        //[17] Refer to EXIC_PA0_AM.
#define EXIC_PA_MSK_PA0_AM                          EXIC->PA_MSK.MBIT.PA0_AM        //[16] External interrupt PAx AND mask bit x
#define EXIC_PA_MSK_PA15_OM                         EXIC->PA_MSK.MBIT.PA15_OM       //[15] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA14_OM                         EXIC->PA_MSK.MBIT.PA14_OM       //[14] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA13_OM                         EXIC->PA_MSK.MBIT.PA13_OM       //[13] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA12_OM                         EXIC->PA_MSK.MBIT.PA12_OM       //[12] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA11_OM                         EXIC->PA_MSK.MBIT.PA11_OM       //[11] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA10_OM                         EXIC->PA_MSK.MBIT.PA10_OM       //[10] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA9_OM                          EXIC->PA_MSK.MBIT.PA9_OM        //[9] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA8_OM                          EXIC->PA_MSK.MBIT.PA8_OM        //[8] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA7_OM                          EXIC->PA_MSK.MBIT.PA7_OM        //[7] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA6_OM                          EXIC->PA_MSK.MBIT.PA6_OM        //[6] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA5_OM                          EXIC->PA_MSK.MBIT.PA5_OM        //[5] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA4_OM                          EXIC->PA_MSK.MBIT.PA4_OM        //[4] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA3_OM                          EXIC->PA_MSK.MBIT.PA3_OM        //[3] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA2_OM                          EXIC->PA_MSK.MBIT.PA2_OM        //[2] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA1_OM                          EXIC->PA_MSK.MBIT.PA1_OM        //[1] Refer to EXIC_PA0_OM.
#define EXIC_PA_MSK_PA0_OM                          EXIC->PA_MSK.MBIT.PA0_OM        //[0] External interrupt PAx OR mask bit x
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_PF  [register's definitions]
 *              Offset[0x30]  EXIC PB input interrupt pending flag register (0x50000030)
 ******************************************************************************
 */
///@{
#define EXIC_PB_PF                                  EXIC->PB_PF.W                   /*!< Offset[0x30]  EXIC PB input interrupt pending flag register (0x50000030) */

/* Bit fields of EXIC_PB_PF */
#define EXIC_PB_PF_PB15_PF                          EXIC->PB_PF.MBIT.PB15_PF        //[15] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB14_PF                          EXIC->PB_PF.MBIT.PB14_PF        //[14] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB13_PF                          EXIC->PB_PF.MBIT.PB13_PF        //[13] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB12_PF                          EXIC->PB_PF.MBIT.PB12_PF        //[12] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB11_PF                          EXIC->PB_PF.MBIT.PB11_PF        //[11] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB10_PF                          EXIC->PB_PF.MBIT.PB10_PF        //[10] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB9_PF                           EXIC->PB_PF.MBIT.PB9_PF         //[9] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB8_PF                           EXIC->PB_PF.MBIT.PB8_PF         //[8] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB7_PF                           EXIC->PB_PF.MBIT.PB7_PF         //[7] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB6_PF                           EXIC->PB_PF.MBIT.PB6_PF         //[6] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB5_PF                           EXIC->PB_PF.MBIT.PB5_PF         //[5] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB4_PF                           EXIC->PB_PF.MBIT.PB4_PF         //[4] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB3_PF                           EXIC->PB_PF.MBIT.PB3_PF         //[3] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB2_PF                           EXIC->PB_PF.MBIT.PB2_PF         //[2] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB1_PF                           EXIC->PB_PF.MBIT.PB1_PF         //[1] Refer to EXIC_PA0_PF.
#define EXIC_PB_PF_PB0_PF                           EXIC->PB_PF.MBIT.PB0_PF         //[0] Refer to EXIC_PA0_PF.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_TRGS  [register's definitions]
 *              Offset[0x34]  EXIC PB Pad input trigger select register (0x50000034)
 ******************************************************************************
 */
///@{
#define EXIC_PB_TRGS                                EXIC->PB_TRGS.W                 /*!< Offset[0x34]  EXIC PB Pad input trigger select register (0x50000034) */

/* Bit fields of EXIC_PB_TRGS */
#define EXIC_PB_TRGS_PB15_TRGS                      EXIC->PB_TRGS.MBIT.PB15_TRGS    //[31..30] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB14_TRGS                      EXIC->PB_TRGS.MBIT.PB14_TRGS    //[29..28] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB13_TRGS                      EXIC->PB_TRGS.MBIT.PB13_TRGS    //[27..26] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB12_TRGS                      EXIC->PB_TRGS.MBIT.PB12_TRGS    //[25..24] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB11_TRGS                      EXIC->PB_TRGS.MBIT.PB11_TRGS    //[23..22] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB10_TRGS                      EXIC->PB_TRGS.MBIT.PB10_TRGS    //[21..20] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB9_TRGS                       EXIC->PB_TRGS.MBIT.PB9_TRGS     //[19..18] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB8_TRGS                       EXIC->PB_TRGS.MBIT.PB8_TRGS     //[17..16] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB7_TRGS                       EXIC->PB_TRGS.MBIT.PB7_TRGS     //[15..14] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB6_TRGS                       EXIC->PB_TRGS.MBIT.PB6_TRGS     //[13..12] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB5_TRGS                       EXIC->PB_TRGS.MBIT.PB5_TRGS     //[11..10] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB4_TRGS                       EXIC->PB_TRGS.MBIT.PB4_TRGS     //[9..8] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB3_TRGS                       EXIC->PB_TRGS.MBIT.PB3_TRGS     //[7..6] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB2_TRGS                       EXIC->PB_TRGS.MBIT.PB2_TRGS     //[5..4] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB1_TRGS                       EXIC->PB_TRGS.MBIT.PB1_TRGS     //[3..2] Refer to EXIC_PA0_TRGS.
#define EXIC_PB_TRGS_PB0_TRGS                       EXIC->PB_TRGS.MBIT.PB0_TRGS     //[1..0] Refer to EXIC_PA0_TRGS.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PB_MSK  [register's definitions]
 *              Offset[0x38]  EXIC PB AOI Mask register (0x50000038)
 ******************************************************************************
 */
///@{
#define EXIC_PB_MSK                                 EXIC->PB_MSK.W                  /*!< Offset[0x38]  EXIC PB AOI Mask register (0x50000038) */

/* Bit fields of EXIC_PB_MSK */
#define EXIC_PB_MSK_PB15_AM                         EXIC->PB_MSK.MBIT.PB15_AM       //[31] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB14_AM                         EXIC->PB_MSK.MBIT.PB14_AM       //[30] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB13_AM                         EXIC->PB_MSK.MBIT.PB13_AM       //[29] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB12_AM                         EXIC->PB_MSK.MBIT.PB12_AM       //[28] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB11_AM                         EXIC->PB_MSK.MBIT.PB11_AM       //[27] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB10_AM                         EXIC->PB_MSK.MBIT.PB10_AM       //[26] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB9_AM                          EXIC->PB_MSK.MBIT.PB9_AM        //[25] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB8_AM                          EXIC->PB_MSK.MBIT.PB8_AM        //[24] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB7_AM                          EXIC->PB_MSK.MBIT.PB7_AM        //[23] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB6_AM                          EXIC->PB_MSK.MBIT.PB6_AM        //[22] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB5_AM                          EXIC->PB_MSK.MBIT.PB5_AM        //[21] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB4_AM                          EXIC->PB_MSK.MBIT.PB4_AM        //[20] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB3_AM                          EXIC->PB_MSK.MBIT.PB3_AM        //[19] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB2_AM                          EXIC->PB_MSK.MBIT.PB2_AM        //[18] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB1_AM                          EXIC->PB_MSK.MBIT.PB1_AM        //[17] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB0_AM                          EXIC->PB_MSK.MBIT.PB0_AM        //[16] Refer to EXIC_PA0_AM.
#define EXIC_PB_MSK_PB15_OM                         EXIC->PB_MSK.MBIT.PB15_OM       //[15] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB14_OM                         EXIC->PB_MSK.MBIT.PB14_OM       //[14] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB13_OM                         EXIC->PB_MSK.MBIT.PB13_OM       //[13] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB12_OM                         EXIC->PB_MSK.MBIT.PB12_OM       //[12] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB11_OM                         EXIC->PB_MSK.MBIT.PB11_OM       //[11] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB10_OM                         EXIC->PB_MSK.MBIT.PB10_OM       //[10] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB9_OM                          EXIC->PB_MSK.MBIT.PB9_OM        //[9] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB8_OM                          EXIC->PB_MSK.MBIT.PB8_OM        //[8] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB7_OM                          EXIC->PB_MSK.MBIT.PB7_OM        //[7] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB6_OM                          EXIC->PB_MSK.MBIT.PB6_OM        //[6] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB5_OM                          EXIC->PB_MSK.MBIT.PB5_OM        //[5] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB4_OM                          EXIC->PB_MSK.MBIT.PB4_OM        //[4] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB3_OM                          EXIC->PB_MSK.MBIT.PB3_OM        //[3] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB2_OM                          EXIC->PB_MSK.MBIT.PB2_OM        //[2] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB1_OM                          EXIC->PB_MSK.MBIT.PB1_OM        //[1] Refer to EXIC_PA0_OM.
#define EXIC_PB_MSK_PB0_OM                          EXIC->PB_MSK.MBIT.PB0_OM        //[0] Refer to EXIC_PA0_OM.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_PF  [register's definitions]
 *              Offset[0x40]  EXIC PC input interrupt pending flag register (0x50000040)
 ******************************************************************************
 */
///@{
#define EXIC_PC_PF                                  EXIC->PC_PF.W                   /*!< Offset[0x40]  EXIC PC input interrupt pending flag register (0x50000040) */

/* Bit fields of EXIC_PC_PF */
#define EXIC_PC_PF_PC14_PF                          EXIC->PC_PF.MBIT.PC14_PF        //[14] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC13_PF                          EXIC->PC_PF.MBIT.PC13_PF        //[13] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC12_PF                          EXIC->PC_PF.MBIT.PC12_PF        //[12] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC11_PF                          EXIC->PC_PF.MBIT.PC11_PF        //[11] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC10_PF                          EXIC->PC_PF.MBIT.PC10_PF        //[10] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC9_PF                           EXIC->PC_PF.MBIT.PC9_PF         //[9] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC8_PF                           EXIC->PC_PF.MBIT.PC8_PF         //[8] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC7_PF                           EXIC->PC_PF.MBIT.PC7_PF         //[7] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC6_PF                           EXIC->PC_PF.MBIT.PC6_PF         //[6] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC5_PF                           EXIC->PC_PF.MBIT.PC5_PF         //[5] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC4_PF                           EXIC->PC_PF.MBIT.PC4_PF         //[4] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC3_PF                           EXIC->PC_PF.MBIT.PC3_PF         //[3] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC2_PF                           EXIC->PC_PF.MBIT.PC2_PF         //[2] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC1_PF                           EXIC->PC_PF.MBIT.PC1_PF         //[1] Refer to EXIC_PA0_PF.
#define EXIC_PC_PF_PC0_PF                           EXIC->PC_PF.MBIT.PC0_PF         //[0] Refer to EXIC_PA0_PF.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_TRGS  [register's definitions]
 *              Offset[0x44]  EXIC PC Pad input trigger select register (0x50000044)
 ******************************************************************************
 */
///@{
#define EXIC_PC_TRGS                                EXIC->PC_TRGS.W                 /*!< Offset[0x44]  EXIC PC Pad input trigger select register (0x50000044) */

/* Bit fields of EXIC_PC_TRGS */
#define EXIC_PC_TRGS_PC14_TRGS                      EXIC->PC_TRGS.MBIT.PC14_TRGS    //[29..28] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC13_TRGS                      EXIC->PC_TRGS.MBIT.PC13_TRGS    //[27..26] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC12_TRGS                      EXIC->PC_TRGS.MBIT.PC12_TRGS    //[25..24] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC11_TRGS                      EXIC->PC_TRGS.MBIT.PC11_TRGS    //[23..22] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC10_TRGS                      EXIC->PC_TRGS.MBIT.PC10_TRGS    //[21..20] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC9_TRGS                       EXIC->PC_TRGS.MBIT.PC9_TRGS     //[19..18] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC8_TRGS                       EXIC->PC_TRGS.MBIT.PC8_TRGS     //[17..16] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC7_TRGS                       EXIC->PC_TRGS.MBIT.PC7_TRGS     //[15..14] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC6_TRGS                       EXIC->PC_TRGS.MBIT.PC6_TRGS     //[13..12] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC5_TRGS                       EXIC->PC_TRGS.MBIT.PC5_TRGS     //[11..10] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC4_TRGS                       EXIC->PC_TRGS.MBIT.PC4_TRGS     //[9..8] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC3_TRGS                       EXIC->PC_TRGS.MBIT.PC3_TRGS     //[7..6] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC2_TRGS                       EXIC->PC_TRGS.MBIT.PC2_TRGS     //[5..4] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC1_TRGS                       EXIC->PC_TRGS.MBIT.PC1_TRGS     //[3..2] Refer to EXIC_PA0_TRGS.
#define EXIC_PC_TRGS_PC0_TRGS                       EXIC->PC_TRGS.MBIT.PC0_TRGS     //[1..0] Refer to EXIC_PA0_TRGS.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PC_MSK  [register's definitions]
 *              Offset[0x48]  EXIC  PC AOI Mask register (0x50000048)
 ******************************************************************************
 */
///@{
#define EXIC_PC_MSK                                 EXIC->PC_MSK.W                  /*!< Offset[0x48]  EXIC  PC AOI Mask register (0x50000048) */

/* Bit fields of EXIC_PC_MSK */
#define EXIC_PC_MSK_PC14_AM                         EXIC->PC_MSK.MBIT.PC14_AM       //[30] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC13_AM                         EXIC->PC_MSK.MBIT.PC13_AM       //[29] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC12_AM                         EXIC->PC_MSK.MBIT.PC12_AM       //[28] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC11_AM                         EXIC->PC_MSK.MBIT.PC11_AM       //[27] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC10_AM                         EXIC->PC_MSK.MBIT.PC10_AM       //[26] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC9_AM                          EXIC->PC_MSK.MBIT.PC9_AM        //[25] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC8_AM                          EXIC->PC_MSK.MBIT.PC8_AM        //[24] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC7_AM                          EXIC->PC_MSK.MBIT.PC7_AM        //[23] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC6_AM                          EXIC->PC_MSK.MBIT.PC6_AM        //[22] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC5_AM                          EXIC->PC_MSK.MBIT.PC5_AM        //[21] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC4_AM                          EXIC->PC_MSK.MBIT.PC4_AM        //[20] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC3_AM                          EXIC->PC_MSK.MBIT.PC3_AM        //[19] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC2_AM                          EXIC->PC_MSK.MBIT.PC2_AM        //[18] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC1_AM                          EXIC->PC_MSK.MBIT.PC1_AM        //[17] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC0_AM                          EXIC->PC_MSK.MBIT.PC0_AM        //[16] Refer to EXIC_PA0_AM.
#define EXIC_PC_MSK_PC14_OM                         EXIC->PC_MSK.MBIT.PC14_OM       //[14] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC13_OM                         EXIC->PC_MSK.MBIT.PC13_OM       //[13] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC12_OM                         EXIC->PC_MSK.MBIT.PC12_OM       //[12] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC11_OM                         EXIC->PC_MSK.MBIT.PC11_OM       //[11] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC10_OM                         EXIC->PC_MSK.MBIT.PC10_OM       //[10] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC9_OM                          EXIC->PC_MSK.MBIT.PC9_OM        //[9] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC8_OM                          EXIC->PC_MSK.MBIT.PC8_OM        //[8] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC7_OM                          EXIC->PC_MSK.MBIT.PC7_OM        //[7] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC6_OM                          EXIC->PC_MSK.MBIT.PC6_OM        //[6] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC5_OM                          EXIC->PC_MSK.MBIT.PC5_OM        //[5] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC4_OM                          EXIC->PC_MSK.MBIT.PC4_OM        //[4] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC3_OM                          EXIC->PC_MSK.MBIT.PC3_OM        //[3] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC2_OM                          EXIC->PC_MSK.MBIT.PC2_OM        //[2] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC1_OM                          EXIC->PC_MSK.MBIT.PC1_OM        //[1] Refer to EXIC_PA0_OM.
#define EXIC_PC_MSK_PC0_OM                          EXIC->PC_MSK.MBIT.PC0_OM        //[0] Refer to EXIC_PA0_OM.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_PF  [register's definitions]
 *              Offset[0x50]  EXIC PD input interrupt pending flag register (0x50000050)
 ******************************************************************************
 */
///@{
#define EXIC_PD_PF                                  EXIC->PD_PF.W                   /*!< Offset[0x50]  EXIC PD input interrupt pending flag register (0x50000050) */

/* Bit fields of EXIC_PD_PF */
#define EXIC_PD_PF_PD15_PF                          EXIC->PD_PF.MBIT.PD15_PF        //[15] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD14_PF                          EXIC->PD_PF.MBIT.PD14_PF        //[14] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD13_PF                          EXIC->PD_PF.MBIT.PD13_PF        //[13] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD12_PF                          EXIC->PD_PF.MBIT.PD12_PF        //[12] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD11_PF                          EXIC->PD_PF.MBIT.PD11_PF        //[11] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD10_PF                          EXIC->PD_PF.MBIT.PD10_PF        //[10] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD9_PF                           EXIC->PD_PF.MBIT.PD9_PF         //[9] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD8_PF                           EXIC->PD_PF.MBIT.PD8_PF         //[8] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD7_PF                           EXIC->PD_PF.MBIT.PD7_PF         //[7] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD6_PF                           EXIC->PD_PF.MBIT.PD6_PF         //[6] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD5_PF                           EXIC->PD_PF.MBIT.PD5_PF         //[5] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD4_PF                           EXIC->PD_PF.MBIT.PD4_PF         //[4] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD3_PF                           EXIC->PD_PF.MBIT.PD3_PF         //[3] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD2_PF                           EXIC->PD_PF.MBIT.PD2_PF         //[2] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD1_PF                           EXIC->PD_PF.MBIT.PD1_PF         //[1] Refer to EXIC_PA0_PF.
#define EXIC_PD_PF_PD0_PF                           EXIC->PD_PF.MBIT.PD0_PF         //[0] Refer to EXIC_PA0_PF.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_TRGS  [register's definitions]
 *              Offset[0x54]  EXIC PD Pad input trigger select register (0x50000054)
 ******************************************************************************
 */
///@{
#define EXIC_PD_TRGS                                EXIC->PD_TRGS.W                 /*!< Offset[0x54]  EXIC PD Pad input trigger select register (0x50000054) */

/* Bit fields of EXIC_PD_TRGS */
#define EXIC_PD_TRGS_PD15_TRGS                      EXIC->PD_TRGS.MBIT.PD15_TRGS    //[31..30] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD14_TRGS                      EXIC->PD_TRGS.MBIT.PD14_TRGS    //[29..28] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD13_TRGS                      EXIC->PD_TRGS.MBIT.PD13_TRGS    //[27..26] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD12_TRGS                      EXIC->PD_TRGS.MBIT.PD12_TRGS    //[25..24] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD11_TRGS                      EXIC->PD_TRGS.MBIT.PD11_TRGS    //[23..22] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD10_TRGS                      EXIC->PD_TRGS.MBIT.PD10_TRGS    //[21..20] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD9_TRGS                       EXIC->PD_TRGS.MBIT.PD9_TRGS     //[19..18] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD8_TRGS                       EXIC->PD_TRGS.MBIT.PD8_TRGS     //[17..16] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD7_TRGS                       EXIC->PD_TRGS.MBIT.PD7_TRGS     //[15..14] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD6_TRGS                       EXIC->PD_TRGS.MBIT.PD6_TRGS     //[13..12] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD5_TRGS                       EXIC->PD_TRGS.MBIT.PD5_TRGS     //[11..10] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD4_TRGS                       EXIC->PD_TRGS.MBIT.PD4_TRGS     //[9..8] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD3_TRGS                       EXIC->PD_TRGS.MBIT.PD3_TRGS     //[7..6] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD2_TRGS                       EXIC->PD_TRGS.MBIT.PD2_TRGS     //[5..4] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD1_TRGS                       EXIC->PD_TRGS.MBIT.PD1_TRGS     //[3..2] Refer to EXIC_PA0_TRGS.
#define EXIC_PD_TRGS_PD0_TRGS                       EXIC->PD_TRGS.MBIT.PD0_TRGS     //[1..0] Refer to EXIC_PA0_TRGS.
///@}
/**
 ******************************************************************************
 * @name        EXIC_PD_MSK  [register's definitions]
 *              Offset[0x58]  EXIC  PD AOI Mask register (0x50000058)
 ******************************************************************************
 */
///@{
#define EXIC_PD_MSK                                 EXIC->PD_MSK.W                  /*!< Offset[0x58]  EXIC  PD AOI Mask register (0x50000058) */

/* Bit fields of EXIC_PD_MSK */
#define EXIC_PD_MSK_PD15_AM                         EXIC->PD_MSK.MBIT.PD15_AM       //[31] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD14_AM                         EXIC->PD_MSK.MBIT.PD14_AM       //[30] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD13_AM                         EXIC->PD_MSK.MBIT.PD13_AM       //[29] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD12_AM                         EXIC->PD_MSK.MBIT.PD12_AM       //[28] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD11_AM                         EXIC->PD_MSK.MBIT.PD11_AM       //[27] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD10_AM                         EXIC->PD_MSK.MBIT.PD10_AM       //[26] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD9_AM                          EXIC->PD_MSK.MBIT.PD9_AM        //[25] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD8_AM                          EXIC->PD_MSK.MBIT.PD8_AM        //[24] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD7_AM                          EXIC->PD_MSK.MBIT.PD7_AM        //[23] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD6_AM                          EXIC->PD_MSK.MBIT.PD6_AM        //[22] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD5_AM                          EXIC->PD_MSK.MBIT.PD5_AM        //[21] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD4_AM                          EXIC->PD_MSK.MBIT.PD4_AM        //[20] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD3_AM                          EXIC->PD_MSK.MBIT.PD3_AM        //[19] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD2_AM                          EXIC->PD_MSK.MBIT.PD2_AM        //[18] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD1_AM                          EXIC->PD_MSK.MBIT.PD1_AM        //[17] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD0_AM                          EXIC->PD_MSK.MBIT.PD0_AM        //[16] Refer to EXIC_PA0_AM.
#define EXIC_PD_MSK_PD15_OM                         EXIC->PD_MSK.MBIT.PD15_OM       //[15] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD14_OM                         EXIC->PD_MSK.MBIT.PD14_OM       //[14] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD13_OM                         EXIC->PD_MSK.MBIT.PD13_OM       //[13] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD12_OM                         EXIC->PD_MSK.MBIT.PD12_OM       //[12] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD11_OM                         EXIC->PD_MSK.MBIT.PD11_OM       //[11] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD10_OM                         EXIC->PD_MSK.MBIT.PD10_OM       //[10] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD9_OM                          EXIC->PD_MSK.MBIT.PD9_OM        //[9] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD8_OM                          EXIC->PD_MSK.MBIT.PD8_OM        //[8] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD7_OM                          EXIC->PD_MSK.MBIT.PD7_OM        //[7] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD6_OM                          EXIC->PD_MSK.MBIT.PD6_OM        //[6] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD5_OM                          EXIC->PD_MSK.MBIT.PD5_OM        //[5] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD4_OM                          EXIC->PD_MSK.MBIT.PD4_OM        //[4] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD3_OM                          EXIC->PD_MSK.MBIT.PD3_OM        //[3] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD2_OM                          EXIC->PD_MSK.MBIT.PD2_OM        //[2] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD1_OM                          EXIC->PD_MSK.MBIT.PD1_OM        //[1] Refer to EXIC_PA0_OM.
#define EXIC_PD_MSK_PD0_OM                          EXIC->PD_MSK.MBIT.PD0_OM        //[0] Refer to EXIC_PA0_OM.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC0  [register's definitions]
 *              Offset[0x60]  EXIC Interrupt source identity register 0 (0x50000060)
 ******************************************************************************
 */
///@{
#define EXIC_SRC0                                   EXIC->SRC0.W                    /*!< Offset[0x60]  EXIC Interrupt source identity register 0 (0x50000060) */

/* Bit fields of EXIC_SRC0 */
#define EXIC_SRC0_ID3                               EXIC->SRC0.MBIT.ID3             //[31..24] Interrupt source-3 identity.
#define EXIC_SRC0_ID2                               EXIC->SRC0.MBIT.ID2             //[23..16] Interrupt source-2 identity.
#define EXIC_SRC0_ID1                               EXIC->SRC0.MBIT.ID1             //[15..8] Interrupt source-1 identity.
#define EXIC_SRC0_ID0                               EXIC->SRC0.MBIT.ID0             //[7..0] Interrupt source-0 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC1  [register's definitions]
 *              Offset[0x64]  EXIC interrupt source identity register 1 (0x50000064)
 ******************************************************************************
 */
///@{
#define EXIC_SRC1                                   EXIC->SRC1.W                    /*!< Offset[0x64]  EXIC interrupt source identity register 1 (0x50000064) */

/* Bit fields of EXIC_SRC1 */
#define EXIC_SRC1_ID7                               EXIC->SRC1.MBIT.ID7             //[31..24] Interrupt source-7 identity.
#define EXIC_SRC1_ID6                               EXIC->SRC1.MBIT.ID6             //[23..16] Interrupt source-6 identity.
#define EXIC_SRC1_ID5                               EXIC->SRC1.MBIT.ID5             //[15..8] Interrupt source-5 identity.
#define EXIC_SRC1_ID4                               EXIC->SRC1.MBIT.ID4             //[7..0] Interrupt source-4 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC2  [register's definitions]
 *              Offset[0x68]  EXIC interrupt source identity register 2 (0x50000068)
 ******************************************************************************
 */
///@{
#define EXIC_SRC2                                   EXIC->SRC2.W                    /*!< Offset[0x68]  EXIC interrupt source identity register 2 (0x50000068) */

/* Bit fields of EXIC_SRC2 */
#define EXIC_SRC2_ID11                              EXIC->SRC2.MBIT.ID11            //[31..24] Interrupt source-11 identity.
#define EXIC_SRC2_ID10                              EXIC->SRC2.MBIT.ID10            //[23..16] Interrupt source-10 identity.
#define EXIC_SRC2_ID9                               EXIC->SRC2.MBIT.ID9             //[15..8] Interrupt source-9 identity.
#define EXIC_SRC2_ID8                               EXIC->SRC2.MBIT.ID8             //[7..0] Interrupt source-8 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC3  [register's definitions]
 *              Offset[0x6C]  EXIC interrupt source identity register 3 (0x5000006C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC3                                   EXIC->SRC3.W                    /*!< Offset[0x6C]  EXIC interrupt source identity register 3 (0x5000006C) */

/* Bit fields of EXIC_SRC3 */
#define EXIC_SRC3_ID15                              EXIC->SRC3.MBIT.ID15            //[31..24] Interrupt source-15 identity.
#define EXIC_SRC3_ID14                              EXIC->SRC3.MBIT.ID14            //[23..16] Interrupt source-14 identity.
#define EXIC_SRC3_ID13                              EXIC->SRC3.MBIT.ID13            //[15..8] Interrupt source-13 identity.
#define EXIC_SRC3_ID12                              EXIC->SRC3.MBIT.ID12            //[7..0] Interrupt source-12 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC4  [register's definitions]
 *              Offset[0x70]  EXIC interrupt source identity register 4 (0x50000070)
 ******************************************************************************
 */
///@{
#define EXIC_SRC4                                   EXIC->SRC4.W                    /*!< Offset[0x70]  EXIC interrupt source identity register 4 (0x50000070) */

/* Bit fields of EXIC_SRC4 */
#define EXIC_SRC4_ID19                              EXIC->SRC4.MBIT.ID19            //[31..24] Interrupt source-19 identity.
#define EXIC_SRC4_ID18                              EXIC->SRC4.MBIT.ID18            //[23..16] Interrupt source-18 identity.
#define EXIC_SRC4_ID17                              EXIC->SRC4.MBIT.ID17            //[15..8] Interrupt source-17 identity.
#define EXIC_SRC4_ID16                              EXIC->SRC4.MBIT.ID16            //[7..0] Interrupt source-16 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC5  [register's definitions]
 *              Offset[0x74]  EXIC interrupt source identity register 5 (0x50000074)
 ******************************************************************************
 */
///@{
#define EXIC_SRC5                                   EXIC->SRC5.W                    /*!< Offset[0x74]  EXIC interrupt source identity register 5 (0x50000074) */

/* Bit fields of EXIC_SRC5 */
#define EXIC_SRC5_ID23                              EXIC->SRC5.MBIT.ID23            //[31..24] Interrupt source-23 identity.
#define EXIC_SRC5_ID22                              EXIC->SRC5.MBIT.ID22            //[23..16] Interrupt source-22 identity.
#define EXIC_SRC5_ID21                              EXIC->SRC5.MBIT.ID21            //[15..8] Interrupt source-21 identity.
#define EXIC_SRC5_ID20                              EXIC->SRC5.MBIT.ID20            //[7..0] Interrupt source-20 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC6  [register's definitions]
 *              Offset[0x78]  EXIC interrupt source identity register 6 (0x50000078)
 ******************************************************************************
 */
///@{
#define EXIC_SRC6                                   EXIC->SRC6.W                    /*!< Offset[0x78]  EXIC interrupt source identity register 6 (0x50000078) */

/* Bit fields of EXIC_SRC6 */
#define EXIC_SRC6_ID27                              EXIC->SRC6.MBIT.ID27            //[31..24] Interrupt source-27 identity.
#define EXIC_SRC6_ID26                              EXIC->SRC6.MBIT.ID26            //[23..16] Interrupt source-26 identity.
#define EXIC_SRC6_ID25                              EXIC->SRC6.MBIT.ID25            //[15..8] Interrupt source-25 identity.
#define EXIC_SRC6_ID24                              EXIC->SRC6.MBIT.ID24            //[7..0] Interrupt source-24 identity.
///@}
/**
 ******************************************************************************
 * @name        EXIC_SRC7  [register's definitions]
 *              Offset[0x7C]  EXIC interrupt source identity register 7 (0x5000007C)
 ******************************************************************************
 */
///@{
#define EXIC_SRC7                                   EXIC->SRC7.W                    /*!< Offset[0x7C]  EXIC interrupt source identity register 7 (0x5000007C) */

/* Bit fields of EXIC_SRC7 */
#define EXIC_SRC7_ID31                              EXIC->SRC7.MBIT.ID31            //[31..24] Interrupt source-31 identity.
#define EXIC_SRC7_ID30                              EXIC->SRC7.MBIT.ID30            //[23..16] Interrupt source-30 identity.
#define EXIC_SRC7_ID29                              EXIC->SRC7.MBIT.ID29            //[15..8] Interrupt source-29 identity.
#define EXIC_SRC7_ID28                              EXIC->SRC7.MBIT.ID28            //[7..0] Interrupt source-28 identity.
///@}

/*----------------------------------------------------------------------------*/
/* @module      I2C (I2C Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        I2C_STA  [register's definitions]
 *              Offset[0x00]  I2C status register
 ******************************************************************************
 */
///@{
#define I2C0_STA                                    I2C0->STA.W                     /*!< Offset[0x00]  I2C0 status register (0x51000000) */
#define I2C1_STA                                    I2C1->STA.W                     /*!< Offset[0x00]  I2C1 status register (0x51010000) */

/* Bit fields of I2C_STA */
#define I2C0_STA_BERRF                              I2C0->STA.MBIT.BERRF            //[23] I2C bus error flag for invalid Stop/Start state
#define I2C1_STA_BERRF                              I2C1->STA.MBIT.BERRF            //[23] I2C bus error flag for invalid Stop/Start state

#define I2C0_STA_ALOSF                              I2C0->STA.MBIT.ALOSF            //[22] I2C bus arbitration lost error flag
#define I2C1_STA_ALOSF                              I2C1->STA.MBIT.ALOSF            //[22] I2C bus arbitration lost error flag

#define I2C0_STA_NACKF                              I2C0->STA.MBIT.NACKF            //[21] I2C Not Acknowledge received error flag
#define I2C1_STA_NACKF                              I2C1->STA.MBIT.NACKF            //[21] I2C Not Acknowledge received error flag

#define I2C0_STA_TOVRF                              I2C0->STA.MBIT.TOVRF            //[20] I2C data buffer transmit underrun error flag
#define I2C1_STA_TOVRF                              I2C1->STA.MBIT.TOVRF            //[20] I2C data buffer transmit underrun error flag

#define I2C0_STA_ROVRF                              I2C0->STA.MBIT.ROVRF            //[19] I2C data buffer receive overrun error flag
#define I2C1_STA_ROVRF                              I2C1->STA.MBIT.ROVRF            //[19] I2C data buffer receive overrun error flag

#define I2C0_STA_TXRF                               I2C0->STA.MBIT.TXRF             //[18] I2C transmit data register remained status
#define I2C1_STA_TXRF                               I2C1->STA.MBIT.TXRF             //[18] I2C transmit data register remained status

#define I2C0_STA_STPSTRF                            I2C0->STA.MBIT.STPSTRF          //[17] I2C Stop or Start detection flag.  (set by hardware and clear by software writing 1)
#define I2C1_STA_STPSTRF                            I2C1->STA.MBIT.STPSTRF          //[17] I2C Stop or Start detection flag. (set by hardware and clear by software writing 1)

#define I2C0_STA_TSCF                               I2C0->STA.MBIT.TSCF             //[16] I2C shadow buffer transfer complete flag
#define I2C1_STA_TSCF                               I2C1->STA.MBIT.TSCF             //[16] I2C shadow buffer transfer complete flag

#define I2C0_STA_RWF                                I2C0->STA.MBIT.RWF              //[15] I2C read or write transfer direction status
#define I2C1_STA_RWF                                I2C1->STA.MBIT.RWF              //[15] I2C read or write transfer direction status

#define I2C0_STA_MSTF                               I2C0->STA.MBIT.MSTF             //[14] I2C master mode detection status. It set by Start command and clear by Stop state.
#define I2C1_STA_MSTF                               I2C1->STA.MBIT.MSTF             //[14] I2C master mode detection status. It set by Start command and clear by Stop state.

#define I2C0_STA_SLAF                               I2C0->STA.MBIT.SLAF             //[13] I2C slave mode detection status.
#define I2C1_STA_SLAF                               I2C1->STA.MBIT.SLAF             //[13] I2C slave mode detection status.

#define I2C0_STA_SADRF                              I2C0->STA.MBIT.SADRF            //[12] I2C slave mode slave address matched flag
#define I2C1_STA_SADRF                              I2C1->STA.MBIT.SADRF            //[12] I2C slave mode slave address matched flag

#define I2C0_STA_ERRCF                              I2C0->STA.MBIT.ERRCF            //[11] I2C master mode NACK error flag and state control bit
#define I2C1_STA_ERRCF                              I2C1->STA.MBIT.ERRCF            //[11] I2C master mode NACK error flag and state control bit

#define I2C0_STA_CNTF                               I2C0->STA.MBIT.CNTF             //[10] I2C buffer count I2C0_BUF_CNT empty status
#define I2C1_STA_CNTF                               I2C1->STA.MBIT.CNTF             //[10] I2C buffer count I2C1_BUF_CNT empty status

#define I2C0_STA_STOPF                              I2C0->STA.MBIT.STOPF            //[9] I2C stop detection flag. (set by hardware and clear by software writing 1)
#define I2C1_STA_STOPF                              I2C1->STA.MBIT.STOPF            //[9] I2C stop detection flag. (set by hardware and clear by software writing 1)

#define I2C0_STA_RSTRF                              I2C0->STA.MBIT.RSTRF            //[8] I2C repeat start asserted flag. (set by hardware and clear by software writing 1)
#define I2C1_STA_RSTRF                              I2C1->STA.MBIT.RSTRF            //[8] I2C repeat start asserted flag. (set by hardware and clear by software writing 1)

#define I2C0_STA_TXF                                I2C0->STA.MBIT.TXF              //[7] I2C Transmit data register empty
#define I2C1_STA_TXF                                I2C1->STA.MBIT.TXF              //[7] I2C Transmit data register empty

#define I2C0_STA_RXF                                I2C0->STA.MBIT.RXF              //[6] I2C Receive data register not empty
#define I2C1_STA_RXF                                I2C1->STA.MBIT.RXF              //[6] I2C Receive data register not empty

#define I2C0_STA_TMOUTF                             I2C0->STA.MBIT.TMOUTF           //[4] I2C time-out detect flag. (set and clear by hardware)
#define I2C1_STA_TMOUTF                             I2C1->STA.MBIT.TMOUTF           //[4] I2C time-out detect flag. (set and clear by hardware)

#define I2C0_STA_ERRF                               I2C0->STA.MBIT.ERRF             //[3] I2C error interrupt flag for invalid no ack, bus arbitration lost bus error or data o
#define I2C1_STA_ERRF                               I2C1->STA.MBIT.ERRF             //[3] I2C error interrupt flag for invalid no ack, bus arbitration lost bus error or data o

#define I2C0_STA_BUFF                               I2C0->STA.MBIT.BUFF             //[2] I2C buffer mode event flag. (set by hardware , clear by software setting 1)
#define I2C1_STA_BUFF                               I2C1->STA.MBIT.BUFF             //[2] I2C buffer mode event flag. (set by hardware , clear by software setting 1)

#define I2C0_STA_EVENTF                             I2C0->STA.MBIT.EVENTF           //[1] I2C status event interrupt Flag
#define I2C1_STA_EVENTF                             I2C1->STA.MBIT.EVENTF           //[1] I2C status event interrupt Flag

#define I2C0_STA_BUSYF                              I2C0->STA.MBIT.BUSYF            //[0] I2C busy flag. (set and clear by hardware)
#define I2C1_STA_BUSYF                              I2C1->STA.MBIT.BUSYF            //[0] I2C busy flag. (set and clear by hardware)

///@}
/**
 ******************************************************************************
 * @name        I2C_INT  [register's definitions]
 *              Offset[0x04]  I2C interrupt enable register
 ******************************************************************************
 */
///@{
#define I2C0_INT                                    I2C0->INT.W                     /*!< Offset[0x04]  I2C0 interrupt enable register (0x51000004) */
#define I2C1_INT                                    I2C1->INT.W                     /*!< Offset[0x04]  I2C1 interrupt enable register (0x51010004) */

/* Bit fields of I2C_INT */
#define I2C0_INT_SDAF                               I2C0->INT.MBIT.SDAF             //[31] I2C SDA line status bit.
#define I2C1_INT_SDAF                               I2C1->INT.MBIT.SDAF             //[31] I2C SDA line status bit.

#define I2C0_INT_SCLF                               I2C0->INT.MBIT.SCLF             //[30] I2C SCL line status bit.
#define I2C1_INT_SCLF                               I2C1->INT.MBIT.SCLF             //[30] I2C SCL line status bit.

#define I2C0_INT_TMOUT_IE                           I2C0->INT.MBIT.TMOUT_IE         //[4] I2C timeout error interrupt enable.
#define I2C1_INT_TMOUT_IE                           I2C1->INT.MBIT.TMOUT_IE         //[4] I2C timeout error interrupt enable.

#define I2C0_INT_ERR_IE                             I2C0->INT.MBIT.ERR_IE           //[3] I2C no ack error, bus arbitration lost, bus error or data overrun interrupt enable.
#define I2C1_INT_ERR_IE                             I2C1->INT.MBIT.ERR_IE           //[3] I2C no ack error, bus arbitration lost, bus error or data overrun interrupt enable.

#define I2C0_INT_BUF_IE                             I2C0->INT.MBIT.BUF_IE           //[2] I2C buffer mode event Interrupt enable
#define I2C1_INT_BUF_IE                             I2C1->INT.MBIT.BUF_IE           //[2] I2C buffer mode event Interrupt enable

#define I2C0_INT_EVENT_IE                           I2C0->INT.MBIT.EVENT_IE         //[1] I2C status event interrupt enable.
#define I2C1_INT_EVENT_IE                           I2C1->INT.MBIT.EVENT_IE         //[1] I2C status event interrupt enable.

#define I2C0_INT_IEA                                I2C0->INT.MBIT.IEA              //[0] I2C interrupt all enable
#define I2C1_INT_IEA                                I2C1->INT.MBIT.IEA              //[0] I2C interrupt all enable

///@}
/**
 ******************************************************************************
 * @name        I2C_CLK  [register's definitions]
 *              Offset[0x08]  I2C clock source register
 ******************************************************************************
 */
///@{
#define I2C0_CLK                                    I2C0->CLK.W                     /*!< Offset[0x08]  I2C0 clock source register (0x51000008) */
#define I2C1_CLK                                    I2C1->CLK.W                     /*!< Offset[0x08]  I2C1 clock source register (0x51010008) */

/* Bit fields of I2C_CLK */
#define I2C0_CLK_TMO_CKS                            I2C0->CLK.MBIT.TMO_CKS          //[12] I2C timeout clock source select.
#define I2C1_CLK_TMO_CKS                            I2C1->CLK.MBIT.TMO_CKS          //[12] I2C timeout clock source select.

#define I2C0_CLK_CK_PSC                             I2C0->CLK.MBIT.CK_PSC           //[10..8] I2C internal clock CK_I2C0_INT prescaler
#define I2C1_CLK_CK_PSC                             I2C1->CLK.MBIT.CK_PSC           //[10..8] I2C internal clock CK_I2C1_INT prescaler

#define I2C0_CLK_CK_DIV                             I2C0->CLK.MBIT.CK_DIV           //[6..4] I2C internal clock CK_I2C0_INT input divider
#define I2C1_CLK_CK_DIV                             I2C1->CLK.MBIT.CK_DIV           //[6..4] I2C internal clock CK_I2C1_INT input divider

#define I2C0_CLK_CK_SEL                             I2C0->CLK.MBIT.CK_SEL           //[3..2] I2C internal clock CK_I2C0 source select
#define I2C1_CLK_CK_SEL                             I2C1->CLK.MBIT.CK_SEL           //[3..2] I2C internal clock CK_I2C1 source select

///@}
/**
 ******************************************************************************
 * @name        I2C_SAC  [register's definitions]
 *              Offset[0x0C]  I2C slave mode slave address code register
 ******************************************************************************
 */
///@{
#define I2C0_SAC                                    I2C0->SAC.W                     /*!< Offset[0x0C]  I2C0 slave mode slave address code register (0x5100000C) */
#define I2C1_SAC                                    I2C1->SAC.W                     /*!< Offset[0x0C]  I2C1 slave mode slave address code register (0x5101000C) */

/* Bit fields of I2C_SAC */
#define I2C0_SAC_SA_CODE                            I2C0->SAC.MBIT.SA_CODE          //[7..1] I2C slave mode grabbed slave address code
#define I2C1_SAC_SA_CODE                            I2C1->SAC.MBIT.SA_CODE          //[7..1] I2C slave mode grabbed slave address code

#define I2C0_SAC_SA_RW                              I2C0->SAC.MBIT.SA_RW            //[0] I2C slave mode grabbed read/write bit.
#define I2C1_SAC_SA_RW                              I2C1->SAC.MBIT.SA_RW            //[0] I2C slave mode grabbed read/write bit.

///@}
/**
 ******************************************************************************
 * @name        I2C_CR0  [register's definitions]
 *              Offset[0x10]  I2C control register 0
 ******************************************************************************
 */
///@{
#define I2C0_CR0                                    I2C0->CR0.W                     /*!< Offset[0x10]  I2C0 control register 0 (0x51000010) */
#define I2C1_CR0                                    I2C1->CR0.W                     /*!< Offset[0x10]  I2C1 control register 0 (0x51010010) */

/* Bit fields of I2C_CR0 */
#define I2C0_CR0_DMA_TXEN                           I2C0->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit
#define I2C1_CR0_DMA_TXEN                           I2C1->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit

#define I2C0_CR0_DMA_RXEN                           I2C0->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive
#define I2C1_CR0_DMA_RXEN                           I2C1->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive

#define I2C0_CR0_PDRV_SEL                           I2C0->CR0.MBIT.PDRV_SEL         //[15..14] I2C pre-drive time select for both SCL and SDA by CK_I2C0 clock time.
#define I2C1_CR0_PDRV_SEL                           I2C1->CR0.MBIT.PDRV_SEL         //[15..14] I2C pre-drive time select for both SCL and SDA by CK_I2C1 clock time.

#define I2C0_CR0_SCLS_DIS                           I2C0->CR0.MBIT.SCLS_DIS         //[12] I2C slave mode clock SCL stretching low control disable
#define I2C1_CR0_SCLS_DIS                           I2C1->CR0.MBIT.SCLS_DIS         //[12] I2C slave mode clock SCL stretching low control disable

#define I2C0_CR0_SFBD_EN                            I2C0->CR0.MBIT.SFBD_EN          //[11] I2C SDA first bit drive high enable when data transmitted
#define I2C1_CR0_SFBD_EN                            I2C1->CR0.MBIT.SFBD_EN          //[11] I2C SDA first bit drive high enable when data transmitted

#define I2C0_CR0_GC_EN                              I2C0->CR0.MBIT.GC_EN            //[7] I2C general call address 0x00 recognized enable bit.
#define I2C1_CR0_GC_EN                              I2C1->CR0.MBIT.GC_EN            //[7] I2C general call address 0x00 recognized enable bit.

#define I2C0_CR0_BUF_EN                             I2C0->CR0.MBIT.BUF_EN           //[6] I2C data buffer enable bit
#define I2C1_CR0_BUF_EN                             I2C1->CR0.MBIT.BUF_EN           //[6] I2C data buffer enable bit

#define I2C0_CR0_MDS                                I2C0->CR0.MBIT.MDS              //[5..4] I2C operation mode select. The monitor mode is only support for Buffer mode.
#define I2C1_CR0_MDS                                I2C1->CR0.MBIT.MDS              //[5..4] I2C operation mode select. The monitor mode is only support for Buffer mode.

#define I2C0_CR0_SADR2_EN                           I2C0->CR0.MBIT.SADR2_EN         //[2] I2C slave mode 2nd slave address detect enable
#define I2C1_CR0_SADR2_EN                           I2C1->CR0.MBIT.SADR2_EN         //[2] I2C slave mode 2nd slave address detect enable

#define I2C0_CR0_SADR_EN                            I2C0->CR0.MBIT.SADR_EN          //[1] I2C slave mode main slave address detect enable
#define I2C1_CR0_SADR_EN                            I2C1->CR0.MBIT.SADR_EN          //[1] I2C slave mode main slave address detect enable

#define I2C0_CR0_EN                                 I2C0->CR0.MBIT.EN               //[0] I2C function enable bit
#define I2C1_CR0_EN                                 I2C1->CR0.MBIT.EN               //[0] I2C function enable bit

///@}
/**
 ******************************************************************************
 * @name        I2C_CR1  [register's definitions]
 *              Offset[0x14]  I2C control register 1
 ******************************************************************************
 */
///@{
#define I2C0_CR1                                    I2C0->CR1.W                     /*!< Offset[0x14]  I2C0 control register 1 (0x51000014) */
#define I2C1_CR1                                    I2C1->CR1.W                     /*!< Offset[0x14]  I2C1 control register 1 (0x51010014) */

/* Bit fields of I2C_CR1 */
#define I2C0_CR1_HT                                 I2C0->CR1.MBIT.HT               //[11..8] I2C SCL high cycle time by CK_I2C0_INT clock time
#define I2C1_CR1_HT                                 I2C1->CR1.MBIT.HT               //[11..8] I2C SCL high cycle time by CK_I2C1_INT clock time

#define I2C0_CR1_LT                                 I2C0->CR1.MBIT.LT               //[4..0] I2C SCL low cycle time by CK_I2C0_INT clock time
#define I2C1_CR1_LT                                 I2C1->CR1.MBIT.LT               //[4..0] I2C SCL low cycle time by CK_I2C1_INT clock time

///@}
/**
 ******************************************************************************
 * @name        I2C_CR2  [register's definitions]
 *              Offset[0x18]  I2C control register 2
 ******************************************************************************
 */
///@{
#define I2C0_CR2                                    I2C0->CR2.W                     /*!< Offset[0x18]  I2C0 control register 2 (0x51000018) */
#define I2C1_CR2                                    I2C1->CR2.W                     /*!< Offset[0x18]  I2C1 control register 2 (0x51010018) */

/* Bit fields of I2C_CR2 */
#define I2C0_CR2_ACNT                               I2C0->CR2.MBIT.ACNT             //[18..16] I2C transmitted or received data actual byte count value
#define I2C1_CR2_ACNT                               I2C1->CR2.MBIT.ACNT             //[18..16] I2C transmitted or received data actual byte count value

#define I2C0_CR2_BUF_CNT                            I2C0->CR2.MBIT.BUF_CNT          //[10..8] I2C transmitted or received data byte count threshold
#define I2C1_CR2_BUF_CNT                            I2C1->CR2.MBIT.BUF_CNT          //[10..8] I2C transmitted or received data byte count threshold

#define I2C0_CR2_AA_LCK                             I2C0->CR2.MBIT.AA_LCK           //[6] I2C0_AA bit write access protected control
#define I2C1_CR2_AA_LCK                             I2C1->CR2.MBIT.AA_LCK           //[6] I2C1_AA bit write access protected control

#define I2C0_CR2_STO_LCK                            I2C0->CR2.MBIT.STO_LCK          //[5] I2C0_STO bit write access protected control
#define I2C1_CR2_STO_LCK                            I2C1->CR2.MBIT.STO_LCK          //[5] I2C1_STO bit write access protected control

#define I2C0_CR2_STA_LCK                            I2C0->CR2.MBIT.STA_LCK          //[4] I2C0_STA bit write access protected control
#define I2C1_CR2_STA_LCK                            I2C1->CR2.MBIT.STA_LCK          //[4] I2C1_STA bit write access protected control

#define I2C0_CR2_CMD_TC                             I2C0->CR2.MBIT.CMD_TC           //[3] I2C command preload enable control bit
#define I2C1_CR2_CMD_TC                             I2C1->CR2.MBIT.CMD_TC           //[3] I2C command preload enable control bit

#define I2C0_CR2_AA                                 I2C0->CR2.MBIT.AA               //[2] I2C assert Acknowledge enable bit.
#define I2C1_CR2_AA                                 I2C1->CR2.MBIT.AA               //[2] I2C assert Acknowledge enable bit.

#define I2C0_CR2_STO                                I2C0->CR2.MBIT.STO              //[1] I2C STOP enable bit.
#define I2C1_CR2_STO                                I2C1->CR2.MBIT.STO              //[1] I2C STOP enable bit.

#define I2C0_CR2_STA                                I2C0->CR2.MBIT.STA              //[0] I2C START enable bit.
#define I2C1_CR2_STA                                I2C1->CR2.MBIT.STA              //[0] I2C START enable bit.

///@}
/**
 ******************************************************************************
 * @name        I2C_SADR  [register's definitions]
 *              Offset[0x1C]  I2C slave address detect register
 ******************************************************************************
 */
///@{
#define I2C0_SADR                                   I2C0->SADR.W                    /*!< Offset[0x1C]  I2C0 slave address detect register (0x5100001C) */
#define I2C1_SADR                                   I2C1->SADR.W                    /*!< Offset[0x1C]  I2C1 slave address detect register (0x5101001C) */

/* Bit fields of I2C_SADR */
#define I2C0_SADR_SADR2                             I2C0->SADR.MBIT.SADR2           //[15..9] I2C slave mode 2nd slave address detection request address value.
#define I2C1_SADR_SADR2                             I2C1->SADR.MBIT.SADR2           //[15..9] I2C slave mode 2nd slave address detection request address value.

#define I2C0_SADR_SADR                              I2C0->SADR.MBIT.SADR            //[7..1] I2C slave mode main slave address detection request address value.
#define I2C1_SADR_SADR                              I2C1->SADR.MBIT.SADR            //[7..1] I2C slave mode main slave address detection request address value.

///@}
/**
 ******************************************************************************
 * @name        I2C_TMOUT  [register's definitions]
 *              Offset[0x20]  I2C timeout control register
 ******************************************************************************
 */
///@{
#define I2C0_TMOUT                                  I2C0->TMOUT.W                   /*!< Offset[0x20]  I2C0 timeout control register (0x51000020) */
#define I2C1_TMOUT                                  I2C1->TMOUT.W                   /*!< Offset[0x20]  I2C1 timeout control register (0x51010020) */

/* Bit fields of I2C_TMOUT */
#define I2C0_TMOUT_TMO_CNT                          I2C0->TMOUT.MBIT.TMO_CNT        //[15..8] I2C timeout setting value.
#define I2C1_TMOUT_TMO_CNT                          I2C1->TMOUT.MBIT.TMO_CNT        //[15..8] I2C timeout setting value.

#define I2C0_TMOUT_TMO_MDS                          I2C0->TMOUT.MBIT.TMO_MDS        //[3..2] I2C timeout detection mode select
#define I2C1_TMOUT_TMO_MDS                          I2C1->TMOUT.MBIT.TMO_MDS        //[3..2] I2C timeout detection mode select

#define I2C0_TMOUT_TMO_EN                           I2C0->TMOUT.MBIT.TMO_EN         //[0] I2C timeout detect enable.
#define I2C1_TMOUT_TMO_EN                           I2C1->TMOUT.MBIT.TMO_EN         //[0] I2C timeout detect enable.

///@}
/**
 ******************************************************************************
 * @name        I2C_STA2  [register's definitions]
 *              Offset[0x28]  I2C status register 2
 ******************************************************************************
 */
///@{
#define I2C0_STA2                                   I2C0->STA2.W                    /*!< Offset[0x28]  I2C0 status register 2 (0x51000028) */
#define I2C1_STA2                                   I2C1->STA2.W                    /*!< Offset[0x28]  I2C1 status register 2 (0x51010028) */

/* Bit fields of I2C_STA2 */
#define I2C0_STA2_EVENTF2                           I2C0->STA2.MBIT.EVENTF2         //[8] I2C status event interrupt Flag
#define I2C1_STA2_EVENTF2                           I2C1->STA2.MBIT.EVENTF2         //[8] I2C status event interrupt Flag

#define I2C0_STA2_EVENT                             I2C0->STA2.MBIT.EVENT           //[7..0] I2C0 status event code
#define I2C1_STA2_EVENT                             I2C1->STA2.MBIT.EVENT           //[7..0] I2C0 status event code

///@}
/**
 ******************************************************************************
 * @name        I2C_SBUF  [register's definitions]
 *              Offset[0x2C]  I2C data shift buffer register
 ******************************************************************************
 */
///@{
#define I2C0_SBUF                                   I2C0->SBUF.W                    /*!< Offset[0x2C]  I2C0 data shift buffer register (0x5100002C) */
#define I2C1_SBUF                                   I2C1->SBUF.W                    /*!< Offset[0x2C]  I2C1 data shift buffer register (0x5101002C) */

/* Bit fields of I2C_SBUF */
#define I2C0_SBUF_SBUF                              I2C0->SBUF.MBIT.SBUF            //[7..0] I2C data shift buffer register
#define I2C1_SBUF_SBUF                              I2C1->SBUF.MBIT.SBUF            //[7..0] I2C data shift buffer register

///@}
/**
 ******************************************************************************
 * @name        I2C_DAT  [register's definitions]
 *              Offset[0x30]  I2C data register
 ******************************************************************************
 */
///@{
#define I2C0_DAT                                    I2C0->DAT.W                     /*!< Offset[0x30]  I2C0 data register (0x51000030) */
#define I2C1_DAT                                    I2C1->DAT.W                     /*!< Offset[0x30]  I2C1 data register (0x51010030) */

/* Bit fields of I2C_DAT */
#define I2C0_DAT_DAT                                I2C0->DAT.MBIT.DAT              //[31..0] I2C data byte register
#define I2C1_DAT_DAT                                I2C1->DAT.MBIT.DAT              //[31..0] I2C data byte register

///@}

/*----------------------------------------------------------------------------*/
/* @module      URT (URT Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        URT_STA  [register's definitions]
 *              Offset[0x00]  URT status register 1
 ******************************************************************************
 */
///@{
#define URT0_STA                                    URT0->STA.W                     /*!< Offset[0x00]  URT0 status register 1 (0x52000000) */
#define URT1_STA                                    URT1->STA.W                     /*!< Offset[0x00]  URT1 status register 1 (0x52010000) */
#define URT2_STA                                    URT2->STA.W                     /*!< Offset[0x00]  URT2 status register 1 (0x52020000) */
#define URT3_STA                                    URT3->STA.W                     /*!< Offset[0x00]  URT3 status register 1 (0x52030000) */

/* Bit fields of URT_STA */
#define URT0_STA_CALTMOF                            URT0->STA.MBIT.CALTMOF          //[30] UART auto baud-rate calibration sync field receive time-out time out flag
#define URT1_STA_CALTMOF                            URT1->STA.MBIT.CALTMOF          //[30] UART auto baud-rate calibration sync field receive time-out time out flag
#define URT2_STA_CALTMOF                            URT2->STA.MBIT.CALTMOF          //[30] UART auto baud-rate calibration sync field receive time-out time out flag
#define URT3_STA_CALTMOF                            URT3->STA.MBIT.CALTMOF          //[30] UART auto baud-rate calibration sync field receive time-out time out flag

#define URT0_STA_BKTMOF                             URT0->STA.MBIT.BKTMOF           //[29] UART break receive time out flag.  (set by hardware and clear by software writing 1)
#define URT1_STA_BKTMOF                             URT1->STA.MBIT.BKTMOF           //[29] UART break receive time out flag.  (set by hardware and clear by software writing 1)
#define URT2_STA_BKTMOF                             URT2->STA.MBIT.BKTMOF           //[29] UART break receive time out flag.  (set by hardware and clear by software writing 1)
#define URT3_STA_BKTMOF                             URT3->STA.MBIT.BKTMOF           //[29] UART break receive time out flag.  (set by hardware and clear by software writing 1)

#define URT0_STA_IDTMOF                             URT0->STA.MBIT.IDTMOF           //[28] UART idle state time out flag.  (set by hardware and clear by software writing 1)
#define URT1_STA_IDTMOF                             URT1->STA.MBIT.IDTMOF           //[28] UART idle state time out flag.  (set by hardware and clear by software writing 1)
#define URT2_STA_IDTMOF                             URT2->STA.MBIT.IDTMOF           //[28] UART idle state time out flag.  (set by hardware and clear by software writing 1)
#define URT3_STA_IDTMOF                             URT3->STA.MBIT.IDTMOF           //[28] UART idle state time out flag.  (set by hardware and clear by software writing 1)

#define URT0_STA_RXTMOF                             URT0->STA.MBIT.RXTMOF           //[27] UART receive time out flag.  (set by hardware and clear by software writing 1)
#define URT1_STA_RXTMOF                             URT1->STA.MBIT.RXTMOF           //[27] UART receive time out flag.  (set by hardware and clear by software writing 1)
#define URT2_STA_RXTMOF                             URT2->STA.MBIT.RXTMOF           //[27] UART receive time out flag.  (set by hardware and clear by software writing 1)
#define URT3_STA_RXTMOF                             URT3->STA.MBIT.RXTMOF           //[27] UART receive time out flag.  (set by hardware and clear by software writing 1)

#define URT0_STA_TXEF                               URT0->STA.MBIT.TXEF             //[24] UART TX error detect flag
#define URT1_STA_TXEF                               URT1->STA.MBIT.TXEF             //[24] UART TX error detect flag
#define URT2_STA_TXEF                               URT2->STA.MBIT.TXEF             //[24] UART TX error detect flag
#define URT3_STA_TXEF                               URT3->STA.MBIT.TXEF             //[24] UART TX error detect flag

#define URT0_STA_ROVRF                              URT0->STA.MBIT.ROVRF            //[23] UART receive overrun error flag
#define URT1_STA_ROVRF                              URT1->STA.MBIT.ROVRF            //[23] UART receive overrun error flag
#define URT2_STA_ROVRF                              URT2->STA.MBIT.ROVRF            //[23] UART receive overrun error flag
#define URT3_STA_ROVRF                              URT3->STA.MBIT.ROVRF            //[23] UART receive overrun error flag

#define URT0_STA_NCEF                               URT0->STA.MBIT.NCEF             //[22] UART receive noised character error flag
#define URT1_STA_NCEF                               URT1->STA.MBIT.NCEF             //[22] UART receive noised character error flag
#define URT2_STA_NCEF                               URT2->STA.MBIT.NCEF             //[22] UART receive noised character error flag
#define URT3_STA_NCEF                               URT3->STA.MBIT.NCEF             //[22] UART receive noised character error flag

#define URT0_STA_FEF                                URT0->STA.MBIT.FEF              //[21] UART frame error flag.  (set by hardware and clear by software writing 1)
#define URT1_STA_FEF                                URT1->STA.MBIT.FEF              //[21] UART frame error flag.  (set by hardware and clear by software writing 1)
#define URT2_STA_FEF                                URT2->STA.MBIT.FEF              //[21] UART frame error flag.  (set by hardware and clear by software writing 1)
#define URT3_STA_FEF                                URT3->STA.MBIT.FEF              //[21] UART frame error flag.  (set by hardware and clear by software writing 1)

#define URT0_STA_PEF                                URT0->STA.MBIT.PEF              //[20] UART parity error flag
#define URT1_STA_PEF                                URT1->STA.MBIT.PEF              //[20] UART parity error flag
#define URT2_STA_PEF                                URT2->STA.MBIT.PEF              //[20] UART parity error flag
#define URT3_STA_PEF                                URT3->STA.MBIT.PEF              //[20] UART parity error flag

#define URT0_STA_CTSF                               URT0->STA.MBIT.CTSF             //[18] UART CTS change detect interrupt flag
#define URT1_STA_CTSF                               URT1->STA.MBIT.CTSF             //[18] UART CTS change detect interrupt flag
#define URT2_STA_CTSF                               URT2->STA.MBIT.CTSF             //[18] UART CTS change detect interrupt flag
#define URT3_STA_CTSF                               URT3->STA.MBIT.CTSF             //[18] UART CTS change detect interrupt flag

#define URT0_STA_IDLF                               URT0->STA.MBIT.IDLF             //[17] UART idle line detect flag. (set by hardware and clear by software writing 1)
#define URT1_STA_IDLF                               URT1->STA.MBIT.IDLF             //[17] UART idle line detect flag. (set by hardware and clear by software writing 1)
#define URT2_STA_IDLF                               URT2->STA.MBIT.IDLF             //[17] UART idle line detect flag. (set by hardware and clear by software writing 1)
#define URT3_STA_IDLF                               URT3->STA.MBIT.IDLF             //[17] UART idle line detect flag. (set by hardware and clear by software writing 1)

#define URT0_STA_BKF                                URT0->STA.MBIT.BKF              //[16] UART break condition detect flag. (set by hardware and clear by software writing 1)
#define URT1_STA_BKF                                URT1->STA.MBIT.BKF              //[16] UART break condition detect flag. (set by hardware and clear by software writing 1)
#define URT2_STA_BKF                                URT2->STA.MBIT.BKF              //[16] UART break condition detect flag. (set by hardware and clear by software writing 1)
#define URT3_STA_BKF                                URT3->STA.MBIT.BKF              //[16] UART break condition detect flag. (set by hardware and clear by software writing 1)

#define URT0_STA_CALCF                              URT0->STA.MBIT.CALCF            //[13] UART auto baud-rate calibration complete flag
#define URT1_STA_CALCF                              URT1->STA.MBIT.CALCF            //[13] UART auto baud-rate calibration complete flag
#define URT2_STA_CALCF                              URT2->STA.MBIT.CALCF            //[13] UART auto baud-rate calibration complete flag
#define URT3_STA_CALCF                              URT3->STA.MBIT.CALCF            //[13] UART auto baud-rate calibration complete flag

#define URT0_STA_TMOF                               URT0->STA.MBIT.TMOF             //[12] UART timeout timer timeout flag. (set by hardware and clear by software writing 1)
#define URT1_STA_TMOF                               URT1->STA.MBIT.TMOF             //[12] UART timeout timer timeout flag. (set by hardware and clear by software writing 1)
#define URT2_STA_TMOF                               URT2->STA.MBIT.TMOF             //[12] UART timeout timer timeout flag. (set by hardware and clear by software writing 1)
#define URT3_STA_TMOF                               URT3->STA.MBIT.TMOF             //[12] UART timeout timer timeout flag. (set by hardware and clear by software writing 1)

#define URT0_STA_BRTF                               URT0->STA.MBIT.BRTF             //[11] UART baud-rate generator timer timeout flag
#define URT1_STA_BRTF                               URT1->STA.MBIT.BRTF             //[11] UART baud-rate generator timer timeout flag
#define URT2_STA_BRTF                               URT2->STA.MBIT.BRTF             //[11] UART baud-rate generator timer timeout flag
#define URT3_STA_BRTF                               URT3->STA.MBIT.BRTF             //[11] UART baud-rate generator timer timeout flag

#define URT0_STA_SADRF                              URT0->STA.MBIT.SADRF            //[10] UART slave address matched flag. (set by hardware and clear by software writing 1)
#define URT1_STA_SADRF                              URT1->STA.MBIT.SADRF            //[10] UART slave address matched flag. (set by hardware and clear by software writing 1)
#define URT2_STA_SADRF                              URT2->STA.MBIT.SADRF            //[10] UART slave address matched flag. (set by hardware and clear by software writing 1)
#define URT3_STA_SADRF                              URT3->STA.MBIT.SADRF            //[10] UART slave address matched flag. (set by hardware and clear by software writing 1)

#define URT0_STA_TXF                                URT0->STA.MBIT.TXF              //[7] UART transmit data register empty
#define URT1_STA_TXF                                URT1->STA.MBIT.TXF              //[7] UART transmit data register empty
#define URT2_STA_TXF                                URT2->STA.MBIT.TXF              //[7] UART transmit data register empty
#define URT3_STA_TXF                                URT3->STA.MBIT.TXF              //[7] UART transmit data register empty

#define URT0_STA_RXF                                URT0->STA.MBIT.RXF              //[6] UART receive data register not empty
#define URT1_STA_RXF                                URT1->STA.MBIT.RXF              //[6] UART receive data register not empty
#define URT2_STA_RXF                                URT2->STA.MBIT.RXF              //[6] UART receive data register not empty
#define URT3_STA_RXF                                URT3->STA.MBIT.RXF              //[6] UART receive data register not empty

#define URT0_STA_RXDF                               URT0->STA.MBIT.RXDF             //[5] UART received data byte number is different from previous received data byte number f
#define URT1_STA_RXDF                               URT1->STA.MBIT.RXDF             //[5] UART received data byte number is different from previous received data byte number f
#define URT2_STA_RXDF                               URT2->STA.MBIT.RXDF             //[5] UART received data byte number is different from previous received data byte number f
#define URT3_STA_RXDF                               URT3->STA.MBIT.RXDF             //[5] UART received data byte number is different from previous received data byte number f

#define URT0_STA_LSF                                URT0->STA.MBIT.LSF              //[4] UART line statue flag for break condition, idle line, CTS detect
#define URT1_STA_LSF                                URT1->STA.MBIT.LSF              //[4] UART line statue flag for break condition, idle line, CTS detect
#define URT2_STA_LSF                                URT2->STA.MBIT.LSF              //[4] UART line statue flag for break condition, idle line, CTS detect
#define URT3_STA_LSF                                URT3->STA.MBIT.LSF              //[4] UART line statue flag for break condition, idle line, CTS detect

#define URT0_STA_ERRF                               URT0->STA.MBIT.ERRF             //[3] UART error interrupt flag for parity error, frame error, overrun error, receive time 
#define URT1_STA_ERRF                               URT1->STA.MBIT.ERRF             //[3] UART error interrupt flag for parity error, frame error, overrun error, receive time 
#define URT2_STA_ERRF                               URT2->STA.MBIT.ERRF             //[3] UART error interrupt flag for parity error, frame error, overrun error, receive time 
#define URT3_STA_ERRF                               URT3->STA.MBIT.ERRF             //[3] UART error interrupt flag for parity error, frame error, overrun error, receive time 

#define URT0_STA_TCF                                URT0->STA.MBIT.TCF              //[2] UART transmission complete flag
#define URT1_STA_TCF                                URT1->STA.MBIT.TCF              //[2] UART transmission complete flag
#define URT2_STA_TCF                                URT2->STA.MBIT.TCF              //[2] UART transmission complete flag
#define URT3_STA_TCF                                URT3->STA.MBIT.TCF              //[2] UART transmission complete flag

#define URT0_STA_UGF                                URT0->STA.MBIT.UGF              //[1] UART general event flag
#define URT1_STA_UGF                                URT1->STA.MBIT.UGF              //[1] UART general event flag
#define URT2_STA_UGF                                URT2->STA.MBIT.UGF              //[1] UART general event flag
#define URT3_STA_UGF                                URT3->STA.MBIT.UGF              //[1] UART general event flag

#define URT0_STA_RHF                                URT0->STA.MBIT.RHF              //[0] UART receive hold flag
#define URT1_STA_RHF                                URT1->STA.MBIT.RHF              //[0] UART receive hold flag
#define URT2_STA_RHF                                URT2->STA.MBIT.RHF              //[0] UART receive hold flag
#define URT3_STA_RHF                                URT3->STA.MBIT.RHF              //[0] UART receive hold flag

///@}
/**
 ******************************************************************************
 * @name        URT_INT  [register's definitions]
 *              Offset[0x04]  URT interrupt enable register
 ******************************************************************************
 */
///@{
#define URT0_INT                                    URT0->INT.W                     /*!< Offset[0x04]  URT0 interrupt enable register (0x52000004) */
#define URT1_INT                                    URT1->INT.W                     /*!< Offset[0x04]  URT1 interrupt enable register (0x52010004) */
#define URT2_INT                                    URT2->INT.W                     /*!< Offset[0x04]  URT2 interrupt enable register (0x52020004) */
#define URT3_INT                                    URT3->INT.W                     /*!< Offset[0x04]  URT3 interrupt enable register (0x52030004) */

/* Bit fields of URT_INT */
#define URT0_INT_CALTMO_IE                          URT0->INT.MBIT.CALTMO_IE        //[30] UART auto baud-rate calibration sync field receive time-out time out interrupt enable
#define URT1_INT_CALTMO_IE                          URT1->INT.MBIT.CALTMO_IE        //[30] UART auto baud-rate calibration sync field receive time-out time out interrupt enable
#define URT2_INT_CALTMO_IE                          URT2->INT.MBIT.CALTMO_IE        //[30] UART auto baud-rate calibration sync field receive time-out time out interrupt enable
#define URT3_INT_CALTMO_IE                          URT3->INT.MBIT.CALTMO_IE        //[30] UART auto baud-rate calibration sync field receive time-out time out interrupt enable

#define URT0_INT_BKTMO_IE                           URT0->INT.MBIT.BKTMO_IE         //[29] UART break receive time out interrupt enable.
#define URT1_INT_BKTMO_IE                           URT1->INT.MBIT.BKTMO_IE         //[29] UART break receive time out interrupt enable.
#define URT2_INT_BKTMO_IE                           URT2->INT.MBIT.BKTMO_IE         //[29] UART break receive time out interrupt enable.
#define URT3_INT_BKTMO_IE                           URT3->INT.MBIT.BKTMO_IE         //[29] UART break receive time out interrupt enable.

#define URT0_INT_IDTMO_IE                           URT0->INT.MBIT.IDTMO_IE         //[28] UART idle state time out interrupt enable.
#define URT1_INT_IDTMO_IE                           URT1->INT.MBIT.IDTMO_IE         //[28] UART idle state time out interrupt enable.
#define URT2_INT_IDTMO_IE                           URT2->INT.MBIT.IDTMO_IE         //[28] UART idle state time out interrupt enable.
#define URT3_INT_IDTMO_IE                           URT3->INT.MBIT.IDTMO_IE         //[28] UART idle state time out interrupt enable.

#define URT0_INT_RXTMO_IE                           URT0->INT.MBIT.RXTMO_IE         //[27] UART receive time out interrupt enable.
#define URT1_INT_RXTMO_IE                           URT1->INT.MBIT.RXTMO_IE         //[27] UART receive time out interrupt enable.
#define URT2_INT_RXTMO_IE                           URT2->INT.MBIT.RXTMO_IE         //[27] UART receive time out interrupt enable.
#define URT3_INT_RXTMO_IE                           URT3->INT.MBIT.RXTMO_IE         //[27] UART receive time out interrupt enable.

#define URT0_INT_TXE_IE                             URT0->INT.MBIT.TXE_IE           //[24] UART TX error detect interrupt enable. Refer to URTx_TXE_MDS for detail.
#define URT1_INT_TXE_IE                             URT1->INT.MBIT.TXE_IE           //[24] UART TX error detect interrupt enable. Refer to URTx_TXE_MDS for detail.
#define URT2_INT_TXE_IE                             URT2->INT.MBIT.TXE_IE           //[24] UART TX error detect interrupt enable. Refer to URTx_TXE_MDS for detail.
#define URT3_INT_TXE_IE                             URT3->INT.MBIT.TXE_IE           //[24] UART TX error detect interrupt enable. Refer to URTx_TXE_MDS for detail.

#define URT0_INT_ROVR_IE                            URT0->INT.MBIT.ROVR_IE          //[23] UART receive overrun error interrupt enable. Refer to URTx_ROVRF for the detail.
#define URT1_INT_ROVR_IE                            URT1->INT.MBIT.ROVR_IE          //[23] UART receive overrun error interrupt enable. Refer to URTx_ROVRF for the detail.
#define URT2_INT_ROVR_IE                            URT2->INT.MBIT.ROVR_IE          //[23] UART receive overrun error interrupt enable. Refer to URTx_ROVRF for the detail.
#define URT3_INT_ROVR_IE                            URT3->INT.MBIT.ROVR_IE          //[23] UART receive overrun error interrupt enable. Refer to URTx_ROVRF for the detail.

#define URT0_INT_NCE_IE                             URT0->INT.MBIT.NCE_IE           //[22] UART receive noised character interrupt enable. 
#define URT1_INT_NCE_IE                             URT1->INT.MBIT.NCE_IE           //[22] UART receive noised character interrupt enable. 
#define URT2_INT_NCE_IE                             URT2->INT.MBIT.NCE_IE           //[22] UART receive noised character interrupt enable. 
#define URT3_INT_NCE_IE                             URT3->INT.MBIT.NCE_IE           //[22] UART receive noised character interrupt enable. 

#define URT0_INT_FE_IE                              URT0->INT.MBIT.FE_IE            //[21] UART frame error interrupt enable.
#define URT1_INT_FE_IE                              URT1->INT.MBIT.FE_IE            //[21] UART frame error interrupt enable.
#define URT2_INT_FE_IE                              URT2->INT.MBIT.FE_IE            //[21] UART frame error interrupt enable.
#define URT3_INT_FE_IE                              URT3->INT.MBIT.FE_IE            //[21] UART frame error interrupt enable.

#define URT0_INT_PE_IE                              URT0->INT.MBIT.PE_IE            //[20] UART parity error interrupt enable.
#define URT1_INT_PE_IE                              URT1->INT.MBIT.PE_IE            //[20] UART parity error interrupt enable.
#define URT2_INT_PE_IE                              URT2->INT.MBIT.PE_IE            //[20] UART parity error interrupt enable.
#define URT3_INT_PE_IE                              URT3->INT.MBIT.PE_IE            //[20] UART parity error interrupt enable.

#define URT0_INT_CTS_IE                             URT0->INT.MBIT.CTS_IE           //[18] UART CTS change detect interrupt enable.
#define URT1_INT_CTS_IE                             URT1->INT.MBIT.CTS_IE           //[18] UART CTS change detect interrupt enable.
#define URT2_INT_CTS_IE                             URT2->INT.MBIT.CTS_IE           //[18] UART CTS change detect interrupt enable.
#define URT3_INT_CTS_IE                             URT3->INT.MBIT.CTS_IE           //[18] UART CTS change detect interrupt enable.

#define URT0_INT_IDL_IE                             URT0->INT.MBIT.IDL_IE           //[17] UART idle line detect interrupt enable.
#define URT1_INT_IDL_IE                             URT1->INT.MBIT.IDL_IE           //[17] UART idle line detect interrupt enable.
#define URT2_INT_IDL_IE                             URT2->INT.MBIT.IDL_IE           //[17] UART idle line detect interrupt enable.
#define URT3_INT_IDL_IE                             URT3->INT.MBIT.IDL_IE           //[17] UART idle line detect interrupt enable.

#define URT0_INT_BK_IE                              URT0->INT.MBIT.BK_IE            //[16] UART break condition detect interrupt enable.
#define URT1_INT_BK_IE                              URT1->INT.MBIT.BK_IE            //[16] UART break condition detect interrupt enable.
#define URT2_INT_BK_IE                              URT2->INT.MBIT.BK_IE            //[16] UART break condition detect interrupt enable.
#define URT3_INT_BK_IE                              URT3->INT.MBIT.BK_IE            //[16] UART break condition detect interrupt enable.

#define URT0_INT_CALC_IE                            URT0->INT.MBIT.CALC_IE          //[13] UART auto baud-rate calibration complete interrupt enable.
#define URT1_INT_CALC_IE                            URT1->INT.MBIT.CALC_IE          //[13] UART auto baud-rate calibration complete interrupt enable.
#define URT2_INT_CALC_IE                            URT2->INT.MBIT.CALC_IE          //[13] UART auto baud-rate calibration complete interrupt enable.
#define URT3_INT_CALC_IE                            URT3->INT.MBIT.CALC_IE          //[13] UART auto baud-rate calibration complete interrupt enable.

#define URT0_INT_TMO_IE                             URT0->INT.MBIT.TMO_IE           //[12] UART timeout timer timeout interrupt enable.
#define URT1_INT_TMO_IE                             URT1->INT.MBIT.TMO_IE           //[12] UART timeout timer timeout interrupt enable.
#define URT2_INT_TMO_IE                             URT2->INT.MBIT.TMO_IE           //[12] UART timeout timer timeout interrupt enable.
#define URT3_INT_TMO_IE                             URT3->INT.MBIT.TMO_IE           //[12] UART timeout timer timeout interrupt enable.

#define URT0_INT_BRT_IE                             URT0->INT.MBIT.BRT_IE           //[11] UART baud-rate generator timer timeout interrupt enable.
#define URT1_INT_BRT_IE                             URT1->INT.MBIT.BRT_IE           //[11] UART baud-rate generator timer timeout interrupt enable.
#define URT2_INT_BRT_IE                             URT2->INT.MBIT.BRT_IE           //[11] UART baud-rate generator timer timeout interrupt enable.
#define URT3_INT_BRT_IE                             URT3->INT.MBIT.BRT_IE           //[11] UART baud-rate generator timer timeout interrupt enable.

#define URT0_INT_SADR_IE                            URT0->INT.MBIT.SADR_IE          //[10] UART slave address matched interrupt enable.
#define URT1_INT_SADR_IE                            URT1->INT.MBIT.SADR_IE          //[10] UART slave address matched interrupt enable.
#define URT2_INT_SADR_IE                            URT2->INT.MBIT.SADR_IE          //[10] UART slave address matched interrupt enable.
#define URT3_INT_SADR_IE                            URT3->INT.MBIT.SADR_IE          //[10] UART slave address matched interrupt enable.

#define URT0_INT_TX_IE                              URT0->INT.MBIT.TX_IE            //[7] UART transmit data register empty interrupt enable. Refer to URTx_TXF for the detail.
#define URT1_INT_TX_IE                              URT1->INT.MBIT.TX_IE            //[7] UART transmit data register empty interrupt enable. Refer to URTx_TXF for the detail.
#define URT2_INT_TX_IE                              URT2->INT.MBIT.TX_IE            //[7] UART transmit data register empty interrupt enable. Refer to URTx_TXF for the detail.
#define URT3_INT_TX_IE                              URT3->INT.MBIT.TX_IE            //[7] UART transmit data register empty interrupt enable. Refer to URTx_TXF for the detail.

#define URT0_INT_RX_IE                              URT0->INT.MBIT.RX_IE            //[6] UART receive data register not empty interrupt enable
#define URT1_INT_RX_IE                              URT1->INT.MBIT.RX_IE            //[6] UART receive data register not empty interrupt enable
#define URT2_INT_RX_IE                              URT2->INT.MBIT.RX_IE            //[6] UART receive data register not empty interrupt enable
#define URT3_INT_RX_IE                              URT3->INT.MBIT.RX_IE            //[6] UART receive data register not empty interrupt enable

#define URT0_INT_LS_IE                              URT0->INT.MBIT.LS_IE            //[4] UART line statue flag for break condition, idle line, CTS detect.
#define URT1_INT_LS_IE                              URT1->INT.MBIT.LS_IE            //[4] UART line statue flag for break condition, idle line, CTS detect.
#define URT2_INT_LS_IE                              URT2->INT.MBIT.LS_IE            //[4] UART line statue flag for break condition, idle line, CTS detect.
#define URT3_INT_LS_IE                              URT3->INT.MBIT.LS_IE            //[4] UART line statue flag for break condition, idle line, CTS detect.

#define URT0_INT_ERR_IE                             URT0->INT.MBIT.ERR_IE           //[3] UART error interrupt enable for parity error, frame error, overrun error, receive tim
#define URT1_INT_ERR_IE                             URT1->INT.MBIT.ERR_IE           //[3] UART error interrupt enable for parity error, frame error, overrun error, receive tim
#define URT2_INT_ERR_IE                             URT2->INT.MBIT.ERR_IE           //[3] UART error interrupt enable for parity error, frame error, overrun error, receive tim
#define URT3_INT_ERR_IE                             URT3->INT.MBIT.ERR_IE           //[3] UART error interrupt enable for parity error, frame error, overrun error, receive tim

#define URT0_INT_TC_IE                              URT0->INT.MBIT.TC_IE            //[2] UART transmission complete interrupt enable
#define URT1_INT_TC_IE                              URT1->INT.MBIT.TC_IE            //[2] UART transmission complete interrupt enable
#define URT2_INT_TC_IE                              URT2->INT.MBIT.TC_IE            //[2] UART transmission complete interrupt enable
#define URT3_INT_TC_IE                              URT3->INT.MBIT.TC_IE            //[2] UART transmission complete interrupt enable

#define URT0_INT_UG_IE                              URT0->INT.MBIT.UG_IE            //[1] UART general event interrupt enable for URTx_SADRF , URTx_TF , URTx_RCNTF or URTx_TCN
#define URT1_INT_UG_IE                              URT1->INT.MBIT.UG_IE            //[1] UART general event interrupt enable for URTx_SADRF , URTx_TF , URTx_RCNTF or URTx_TCN
#define URT2_INT_UG_IE                              URT2->INT.MBIT.UG_IE            //[1] UART general event interrupt enable for URTx_SADRF , URTx_TF , URTx_RCNTF or URTx_TCN
#define URT3_INT_UG_IE                              URT3->INT.MBIT.UG_IE            //[1] UART general event interrupt enable for URTx_SADRF , URTx_TF , URTx_RCNTF or URTx_TCN

#define URT0_INT_IEA                                URT0->INT.MBIT.IEA              //[0] UART interrupt all enable
#define URT1_INT_IEA                                URT1->INT.MBIT.IEA              //[0] UART interrupt all enable
#define URT2_INT_IEA                                URT2->INT.MBIT.IEA              //[0] UART interrupt all enable
#define URT3_INT_IEA                                URT3->INT.MBIT.IEA              //[0] UART interrupt all enable

///@}
/**
 ******************************************************************************
 * @name        URT_CLK  [register's definitions]
 *              Offset[0x08]  URT clock source register
 ******************************************************************************
 */
///@{
#define URT0_CLK                                    URT0->CLK.W                     /*!< Offset[0x08]  URT0 clock source register (0x52000008) */
#define URT1_CLK                                    URT1->CLK.W                     /*!< Offset[0x08]  URT1 clock source register (0x52010008) */
#define URT2_CLK                                    URT2->CLK.W                     /*!< Offset[0x08]  URT2 clock source register (0x52020008) */
#define URT3_CLK                                    URT3->CLK.W                     /*!< Offset[0x08]  URT3 clock source register (0x52030008) */

/* Bit fields of URT_CLK */
#define URT0_CLK_CKO_LCK                            URT0->CLK.MBIT.CKO_LCK          //[29] UART PSC clock output signal initial state control
#define URT1_CLK_CKO_LCK                            URT1->CLK.MBIT.CKO_LCK          //[29] UART PSC clock output signal initial state control
#define URT2_CLK_CKO_LCK                            URT2->CLK.MBIT.CKO_LCK          //[29] UART PSC clock output signal initial state control
#define URT3_CLK_CKO_LCK                            URT3->CLK.MBIT.CKO_LCK          //[29] UART PSC clock output signal initial state control

#define URT0_CLK_CKO_STA                            URT0->CLK.MBIT.CKO_STA          //[28] UART PSC clock output signal initial state
#define URT1_CLK_CKO_STA                            URT1->CLK.MBIT.CKO_STA          //[28] UART PSC clock output signal initial state
#define URT2_CLK_CKO_STA                            URT2->CLK.MBIT.CKO_STA          //[28] UART PSC clock output signal initial state
#define URT3_CLK_CKO_STA                            URT3->CLK.MBIT.CKO_STA          //[28] UART PSC clock output signal initial state

#define URT0_CLK_BRO_LCK                            URT0->CLK.MBIT.BRO_LCK          //[27] UART baud-rate timer timeout signal initial state control
#define URT1_CLK_BRO_LCK                            URT1->CLK.MBIT.BRO_LCK          //[27] UART baud-rate timer timeout signal initial state control
#define URT2_CLK_BRO_LCK                            URT2->CLK.MBIT.BRO_LCK          //[27] UART baud-rate timer timeout signal initial state control
#define URT3_CLK_BRO_LCK                            URT3->CLK.MBIT.BRO_LCK          //[27] UART baud-rate timer timeout signal initial state control

#define URT0_CLK_BRO_STA                            URT0->CLK.MBIT.BRO_STA          //[26] UART baud-rate timer timeout signal initial state
#define URT1_CLK_BRO_STA                            URT1->CLK.MBIT.BRO_STA          //[26] UART baud-rate timer timeout signal initial state
#define URT2_CLK_BRO_STA                            URT2->CLK.MBIT.BRO_STA          //[26] UART baud-rate timer timeout signal initial state
#define URT3_CLK_BRO_STA                            URT3->CLK.MBIT.BRO_STA          //[26] UART baud-rate timer timeout signal initial state

#define URT0_CLK_BR_MDS                             URT0->CLK.MBIT.BR_MDS           //[25] UART baud-rate timer mode select
#define URT1_CLK_BR_MDS                             URT1->CLK.MBIT.BR_MDS           //[25] UART baud-rate timer mode select
#define URT2_CLK_BR_MDS                             URT2->CLK.MBIT.BR_MDS           //[25] UART baud-rate timer mode select
#define URT3_CLK_BR_MDS                             URT3->CLK.MBIT.BR_MDS           //[25] UART baud-rate timer mode select

#define URT0_CLK_BR_EN                              URT0->CLK.MBIT.BR_EN            //[24] UART baud-rate timer enable. When enables, the baud-rate timer 
#define URT1_CLK_BR_EN                              URT1->CLK.MBIT.BR_EN            //[24] UART baud-rate timer enable. When enables, the baud-rate timer 
#define URT2_CLK_BR_EN                              URT2->CLK.MBIT.BR_EN            //[24] UART baud-rate timer enable. When enables, the baud-rate timer 
#define URT3_CLK_BR_EN                              URT3->CLK.MBIT.BR_EN            //[24] UART baud-rate timer enable. When enables, the baud-rate timer 

#define URT0_CLK_TX_CKS                             URT0->CLK.MBIT.TX_CKS           //[21..20] UART transmission clock source select.
#define URT1_CLK_TX_CKS                             URT1->CLK.MBIT.TX_CKS           //[21..20] UART transmission clock source select.
#define URT2_CLK_TX_CKS                             URT2->CLK.MBIT.TX_CKS           //[21..20] UART transmission clock source select.
#define URT3_CLK_TX_CKS                             URT3->CLK.MBIT.TX_CKS           //[21..20] UART transmission clock source select.

#define URT0_CLK_RX_CKS                             URT0->CLK.MBIT.RX_CKS           //[17..16] UART receive clock source select.
#define URT1_CLK_RX_CKS                             URT1->CLK.MBIT.RX_CKS           //[17..16] UART receive clock source select.
#define URT2_CLK_RX_CKS                             URT2->CLK.MBIT.RX_CKS           //[17..16] UART receive clock source select.
#define URT3_CLK_RX_CKS                             URT3->CLK.MBIT.RX_CKS           //[17..16] UART receive clock source select.

#define URT0_CLK_CLK_CKS                            URT0->CLK.MBIT.CLK_CKS          //[5] UART external clock output source select.
#define URT1_CLK_CLK_CKS                            URT1->CLK.MBIT.CLK_CKS          //[5] UART external clock output source select.
#define URT2_CLK_CLK_CKS                            URT2->CLK.MBIT.CLK_CKS          //[5] UART external clock output source select.
#define URT3_CLK_CLK_CKS                            URT3->CLK.MBIT.CLK_CKS          //[5] UART external clock output source select.

#define URT0_CLK_CLK_EN                             URT0->CLK.MBIT.CLK_EN           //[4] URTx_CLK signal output enable.
#define URT1_CLK_CLK_EN                             URT1->CLK.MBIT.CLK_EN           //[4] URTx_CLK signal output enable.
#define URT2_CLK_CLK_EN                             URT2->CLK.MBIT.CLK_EN           //[4] URTx_CLK signal output enable.
#define URT3_CLK_CLK_EN                             URT3->CLK.MBIT.CLK_EN           //[4] URTx_CLK signal output enable.

#define URT0_CLK_CK_SEL                             URT0->CLK.MBIT.CK_SEL           //[3..1] UART internal clock CK_UART source select.
#define URT1_CLK_CK_SEL                             URT1->CLK.MBIT.CK_SEL           //[3..1] UART internal clock CK_UART source select.
#define URT2_CLK_CK_SEL                             URT2->CLK.MBIT.CK_SEL           //[3..1] UART internal clock CK_UART source select.
#define URT3_CLK_CK_SEL                             URT3->CLK.MBIT.CK_SEL           //[3..1] UART internal clock CK_UART source select.

///@}
/**
 ******************************************************************************
 * @name        URT_STA2  [register's definitions]
 *              Offset[0x0C]  URT status register 2
 ******************************************************************************
 */
///@{
#define URT0_STA2                                   URT0->STA2.W                    /*!< Offset[0x0C]  URT0 status register 2 (0x5200000C) */
#define URT1_STA2                                   URT1->STA2.W                    /*!< Offset[0x0C]  URT1 status register 2 (0x5201000C) */
#define URT2_STA2                                   URT2->STA2.W                    /*!< Offset[0x0C]  URT2 status register 2 (0x5202000C) */
#define URT3_STA2                                   URT3->STA2.W                    /*!< Offset[0x0C]  URT3 status register 2 (0x5203000C) */

/* Bit fields of URT_STA2 */
#define URT0_STA2_TX_LVL                            URT0->STA2.MBIT.TX_LVL          //[30..28] UART data buffer transmission remained level indications.
#define URT1_STA2_TX_LVL                            URT1->STA2.MBIT.TX_LVL          //[30..28] UART data buffer transmission remained level indications.
#define URT2_STA2_TX_LVL                            URT2->STA2.MBIT.TX_LVL          //[30..28] UART data buffer transmission remained level indications.
#define URT3_STA2_TX_LVL                            URT3->STA2.MBIT.TX_LVL          //[30..28] UART data buffer transmission remained level indications.

#define URT0_STA2_RX_LVL                            URT0->STA2.MBIT.RX_LVL          //[26..24] UART data buffer received level indications.
#define URT1_STA2_RX_LVL                            URT1->STA2.MBIT.RX_LVL          //[26..24] UART data buffer received level indications.
#define URT2_STA2_RX_LVL                            URT2->STA2.MBIT.RX_LVL          //[26..24] UART data buffer received level indications.
#define URT3_STA2_RX_LVL                            URT3->STA2.MBIT.RX_LVL          //[26..24] UART data buffer received level indications.

#define URT0_STA2_CTS                               URT0->STA2.MBIT.CTS             //[12] UART CTS line status bit
#define URT1_STA2_CTS                               URT1->STA2.MBIT.CTS             //[12] UART CTS line status bit
#define URT2_STA2_CTS                               URT2->STA2.MBIT.CTS             //[12] UART CTS line status bit
#define URT3_STA2_CTS                               URT3->STA2.MBIT.CTS             //[12] UART CTS line status bit

#define URT0_STA2_IR_BUSYF                          URT0->STA2.MBIT.IR_BUSYF        //[7] UART IrDA data received busy flag. 
#define URT1_STA2_IR_BUSYF                          URT1->STA2.MBIT.IR_BUSYF        //[7] UART IrDA data received busy flag. 
#define URT2_STA2_IR_BUSYF                          URT2->STA2.MBIT.IR_BUSYF        //[7] UART IrDA data received busy flag. 
#define URT3_STA2_IR_BUSYF                          URT3->STA2.MBIT.IR_BUSYF        //[7] UART IrDA data received busy flag. 

#define URT0_STA2_BKBF                              URT0->STA2.MBIT.BKBF            //[6] UART send break busy flag.  (set and clear by hardware)
#define URT1_STA2_BKBF                              URT1->STA2.MBIT.BKBF            //[6] UART send break busy flag.  (set and clear by hardware)
#define URT2_STA2_BKBF                              URT2->STA2.MBIT.BKBF            //[6] UART send break busy flag.  (set and clear by hardware)
#define URT3_STA2_BKBF                              URT3->STA2.MBIT.BKBF            //[6] UART send break busy flag.  (set and clear by hardware)

#define URT0_STA2_NCF                               URT0->STA2.MBIT.NCF             //[5] UART receive noised character flag.  (set and clear by hardware)
#define URT1_STA2_NCF                               URT1->STA2.MBIT.NCF             //[5] UART receive noised character flag.  (set and clear by hardware)
#define URT2_STA2_NCF                               URT2->STA2.MBIT.NCF             //[5] UART receive noised character flag.  (set and clear by hardware)
#define URT3_STA2_NCF                               URT3->STA2.MBIT.NCF             //[5] UART receive noised character flag.  (set and clear by hardware)

#define URT0_STA2_ADR                               URT0->STA2.MBIT.ADR             //[2] UART data receive slave address bit of shift buffer.
#define URT1_STA2_ADR                               URT1->STA2.MBIT.ADR             //[2] UART data receive slave address bit of shift buffer.
#define URT2_STA2_ADR                               URT2->STA2.MBIT.ADR             //[2] UART data receive slave address bit of shift buffer.
#define URT3_STA2_ADR                               URT3->STA2.MBIT.ADR             //[2] UART data receive slave address bit of shift buffer.

#define URT0_STA2_PAR                               URT0->STA2.MBIT.PAR             //[1] UART data receive parity bit of shift buffer
#define URT1_STA2_PAR                               URT1->STA2.MBIT.PAR             //[1] UART data receive parity bit of shift buffer
#define URT2_STA2_PAR                               URT2->STA2.MBIT.PAR             //[1] UART data receive parity bit of shift buffer
#define URT3_STA2_PAR                               URT3->STA2.MBIT.PAR             //[1] UART data receive parity bit of shift buffer

#define URT0_STA2_BUSYF                             URT0->STA2.MBIT.BUSYF           //[0] UART RX busy flag
#define URT1_STA2_BUSYF                             URT1->STA2.MBIT.BUSYF           //[0] UART RX busy flag
#define URT2_STA2_BUSYF                             URT2->STA2.MBIT.BUSYF           //[0] UART RX busy flag
#define URT3_STA2_BUSYF                             URT3->STA2.MBIT.BUSYF           //[0] UART RX busy flag

///@}
/**
 ******************************************************************************
 * @name        URT_CR0  [register's definitions]
 *              Offset[0x10]  URT control register 0
 ******************************************************************************
 */
///@{
#define URT0_CR0                                    URT0->CR0.W                     /*!< Offset[0x10]  URT0 control register 0 (0x52000010) */
#define URT1_CR0                                    URT1->CR0.W                     /*!< Offset[0x10]  URT1 control register 0 (0x52010010) */
#define URT2_CR0                                    URT2->CR0.W                     /*!< Offset[0x10]  URT2 control register 0 (0x52020010) */
#define URT3_CR0                                    URT3->CR0.W                     /*!< Offset[0x10]  URT3 control register 0 (0x52030010) */

/* Bit fields of URT_CR0 */
#define URT0_CR0_DMA_TXEN                           URT0->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit
#define URT1_CR0_DMA_TXEN                           URT1->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit
#define URT2_CR0_DMA_TXEN                           URT2->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit
#define URT3_CR0_DMA_TXEN                           URT3->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit

#define URT0_CR0_DMA_RXEN                           URT0->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive
#define URT1_CR0_DMA_RXEN                           URT1->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive
#define URT2_CR0_DMA_RXEN                           URT2->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive
#define URT3_CR0_DMA_RXEN                           URT3->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive

#define URT0_CR0_DDTX_EN                            URT0->CR0.MBIT.DDTX_EN          //[29] Hardware force to disable DMA TX function enable bit when detects a break condition
#define URT1_CR0_DDTX_EN                            URT1->CR0.MBIT.DDTX_EN          //[29] Hardware force to disable DMA TX function enable bit when detects a break condition
#define URT2_CR0_DDTX_EN                            URT2->CR0.MBIT.DDTX_EN          //[29] Hardware force to disable DMA TX function enable bit when detects a break condition
#define URT3_CR0_DDTX_EN                            URT3->CR0.MBIT.DDTX_EN          //[29] Hardware force to disable DMA TX function enable bit when detects a break condition

#define URT0_CR0_LBM_EN                             URT0->CR0.MBIT.LBM_EN           //[23] UART Loop back mode enable bit
#define URT1_CR0_LBM_EN                             URT1->CR0.MBIT.LBM_EN           //[23] UART Loop back mode enable bit
#define URT2_CR0_LBM_EN                             URT2->CR0.MBIT.LBM_EN           //[23] UART Loop back mode enable bit
#define URT3_CR0_LBM_EN                             URT3->CR0.MBIT.LBM_EN           //[23] UART Loop back mode enable bit

#define URT0_CR0_NCHAR_DIS                          URT0->CR0.MBIT.NCHAR_DIS        //[22] UART receiving noised character disable bit
#define URT1_CR0_NCHAR_DIS                          URT1->CR0.MBIT.NCHAR_DIS        //[22] UART receiving noised character disable bit
#define URT2_CR0_NCHAR_DIS                          URT2->CR0.MBIT.NCHAR_DIS        //[22] UART receiving noised character disable bit
#define URT3_CR0_NCHAR_DIS                          URT3->CR0.MBIT.NCHAR_DIS        //[22] UART receiving noised character disable bit

#define URT0_CR0_NCHAR_HE                           URT0->CR0.MBIT.NCHAR_HE         //[21] UART receiving hold enable bit if receives a noised character
#define URT1_CR0_NCHAR_HE                           URT1->CR0.MBIT.NCHAR_HE         //[21] UART receiving hold enable bit if receives a noised character
#define URT2_CR0_NCHAR_HE                           URT2->CR0.MBIT.NCHAR_HE         //[21] UART receiving hold enable bit if receives a noised character
#define URT3_CR0_NCHAR_HE                           URT3->CR0.MBIT.NCHAR_HE         //[21] UART receiving hold enable bit if receives a noised character

#define URT0_CR0_IDL_MDS                            URT0->CR0.MBIT.IDL_MDS          //[20] UART idle line detect management mode select
#define URT1_CR0_IDL_MDS                            URT1->CR0.MBIT.IDL_MDS          //[20] UART idle line detect management mode select
#define URT2_CR0_IDL_MDS                            URT2->CR0.MBIT.IDL_MDS          //[20] UART idle line detect management mode select
#define URT3_CR0_IDL_MDS                            URT3->CR0.MBIT.IDL_MDS          //[20] UART idle line detect management mode select

#define URT0_CR0_RX_TH                              URT0->CR0.MBIT.RX_TH            //[17..16] UART data buffer high threshold for received access
#define URT1_CR0_RX_TH                              URT1->CR0.MBIT.RX_TH            //[17..16] UART data buffer high threshold for received access
#define URT2_CR0_RX_TH                              URT2->CR0.MBIT.RX_TH            //[17..16] UART data buffer high threshold for received access
#define URT3_CR0_RX_TH                              URT3->CR0.MBIT.RX_TH            //[17..16] UART data buffer high threshold for received access

#define URT0_CR0_DE_GT                              URT0->CR0.MBIT.DE_GT            //[15..14] URTx_DE signal output guard time select by unit of bit time
#define URT1_CR0_DE_GT                              URT1->CR0.MBIT.DE_GT            //[15..14] URTx_DE signal output guard time select by unit of bit time
#define URT2_CR0_DE_GT                              URT2->CR0.MBIT.DE_GT            //[15..14] URTx_DE signal output guard time select by unit of bit time
#define URT3_CR0_DE_GT                              URT3->CR0.MBIT.DE_GT            //[15..14] URTx_DE signal output guard time select by unit of bit time

#define URT0_CR0_DE_INV                             URT0->CR0.MBIT.DE_INV           //[13] URTx_DE signal inverse enable. The hardware DE output default is low level.
#define URT1_CR0_DE_INV                             URT1->CR0.MBIT.DE_INV           //[13] URTx_DE signal inverse enable. The hardware DE output default is low level.
#define URT2_CR0_DE_INV                             URT2->CR0.MBIT.DE_INV           //[13] URTx_DE signal inverse enable. The hardware DE output default is low level.
#define URT3_CR0_DE_INV                             URT3->CR0.MBIT.DE_INV           //[13] URTx_DE signal inverse enable. The hardware DE output default is low level.

#define URT0_CR0_DE_EN                              URT0->CR0.MBIT.DE_EN            //[12] URTx_DE signal output enable.
#define URT1_CR0_DE_EN                              URT1->CR0.MBIT.DE_EN            //[12] URTx_DE signal output enable.
#define URT2_CR0_DE_EN                              URT2->CR0.MBIT.DE_EN            //[12] URTx_DE signal output enable.
#define URT3_CR0_DE_EN                              URT3->CR0.MBIT.DE_EN            //[12] URTx_DE signal output enable.

#define URT0_CR0_TX_INV                             URT0->CR0.MBIT.TX_INV           //[11] URTx_TX output signal inverse enable.
#define URT1_CR0_TX_INV                             URT1->CR0.MBIT.TX_INV           //[11] URTx_TX output signal inverse enable.
#define URT2_CR0_TX_INV                             URT2->CR0.MBIT.TX_INV           //[11] URTx_TX output signal inverse enable.
#define URT3_CR0_TX_INV                             URT3->CR0.MBIT.TX_INV           //[11] URTx_TX output signal inverse enable.

#define URT0_CR0_RX_INV                             URT0->CR0.MBIT.RX_INV           //[10] URTx_RX input signal inverse enable.
#define URT1_CR0_RX_INV                             URT1->CR0.MBIT.RX_INV           //[10] URTx_RX input signal inverse enable.
#define URT2_CR0_RX_INV                             URT2->CR0.MBIT.RX_INV           //[10] URTx_RX input signal inverse enable.
#define URT3_CR0_RX_INV                             URT3->CR0.MBIT.RX_INV           //[10] URTx_RX input signal inverse enable.

#define URT0_CR0_IO_SWP                             URT0->CR0.MBIT.IO_SWP           //[8] URTx_RX/URTx_TX swap enable bit.
#define URT1_CR0_IO_SWP                             URT1->CR0.MBIT.IO_SWP           //[8] URTx_RX/URTx_TX swap enable bit.
#define URT2_CR0_IO_SWP                             URT2->CR0.MBIT.IO_SWP           //[8] URTx_RX/URTx_TX swap enable bit.
#define URT3_CR0_IO_SWP                             URT3->CR0.MBIT.IO_SWP           //[8] URTx_RX/URTx_TX swap enable bit.

#define URT0_CR0_GSA_EN                             URT0->CR0.MBIT.GSA_EN           //[7] UART multi-processor global slave address enable.
#define URT1_CR0_GSA_EN                             URT1->CR0.MBIT.GSA_EN           //[7] UART multi-processor global slave address enable.
#define URT2_CR0_GSA_EN                             URT2->CR0.MBIT.GSA_EN           //[7] UART multi-processor global slave address enable.
#define URT3_CR0_GSA_EN                             URT3->CR0.MBIT.GSA_EN           //[7] UART multi-processor global slave address enable.

#define URT0_CR0_MDS                                URT0->CR0.MBIT.MDS              //[6..4] UART mode select
#define URT1_CR0_MDS                                URT1->CR0.MBIT.MDS              //[6..4] UART mode select
#define URT2_CR0_MDS                                URT2->CR0.MBIT.MDS              //[6..4] UART mode select
#define URT3_CR0_MDS                                URT3->CR0.MBIT.MDS              //[6..4] UART mode select

#define URT0_CR0_DAT_LINE                           URT0->CR0.MBIT.DAT_LINE         //[3] UART communication data line select.
#define URT1_CR0_DAT_LINE                           URT1->CR0.MBIT.DAT_LINE         //[3] UART communication data line select.
#define URT2_CR0_DAT_LINE                           URT2->CR0.MBIT.DAT_LINE         //[3] UART communication data line select.
#define URT3_CR0_DAT_LINE                           URT3->CR0.MBIT.DAT_LINE         //[3] UART communication data line select.

#define URT0_CR0_HDX_EN                             URT0->CR0.MBIT.HDX_EN           //[2] UART Half-duplex mode enable
#define URT1_CR0_HDX_EN                             URT1->CR0.MBIT.HDX_EN           //[2] UART Half-duplex mode enable
#define URT2_CR0_HDX_EN                             URT2->CR0.MBIT.HDX_EN           //[2] UART Half-duplex mode enable
#define URT3_CR0_HDX_EN                             URT3->CR0.MBIT.HDX_EN           //[2] UART Half-duplex mode enable

#define URT0_CR0_OS_MDS                             URT0->CR0.MBIT.OS_MDS           //[1] UART RX data oversampling majority vote select.
#define URT1_CR0_OS_MDS                             URT1->CR0.MBIT.OS_MDS           //[1] UART RX data oversampling majority vote select.
#define URT2_CR0_OS_MDS                             URT2->CR0.MBIT.OS_MDS           //[1] UART RX data oversampling majority vote select.
#define URT3_CR0_OS_MDS                             URT3->CR0.MBIT.OS_MDS           //[1] UART RX data oversampling majority vote select.

#define URT0_CR0_EN                                 URT0->CR0.MBIT.EN               //[0] UART function enable bit.
#define URT1_CR0_EN                                 URT1->CR0.MBIT.EN               //[0] UART function enable bit.
#define URT2_CR0_EN                                 URT2->CR0.MBIT.EN               //[0] UART function enable bit.
#define URT3_CR0_EN                                 URT3->CR0.MBIT.EN               //[0] UART function enable bit.

///@}
/**
 ******************************************************************************
 * @name        URT_CR1  [register's definitions]
 *              Offset[0x14]  URT control register 1
 ******************************************************************************
 */
///@{
#define URT0_CR1                                    URT0->CR1.W                     /*!< Offset[0x14]  URT0 control register 1 (0x52000014) */
#define URT1_CR1                                    URT1->CR1.W                     /*!< Offset[0x14]  URT1 control register 1 (0x52010014) */
#define URT2_CR1                                    URT2->CR1.W                     /*!< Offset[0x14]  URT2 control register 1 (0x52020014) */
#define URT3_CR1                                    URT3->CR1.W                     /*!< Offset[0x14]  URT3 control register 1 (0x52030014) */

/* Bit fields of URT_CR1 */
#define URT0_CR1_TXOS_NUM                           URT0->CR1.MBIT.TXOS_NUM         //[28..24] UART TX data oversampling samples select
#define URT1_CR1_TXOS_NUM                           URT1->CR1.MBIT.TXOS_NUM         //[28..24] UARTTX data oversampling samples select
#define URT2_CR1_TXOS_NUM                           URT2->CR1.MBIT.TXOS_NUM         //[28..24] UART TX data oversampling samples select
#define URT3_CR1_TXOS_NUM                           URT3->CR1.MBIT.TXOS_NUM         //[28..24] UART TX data oversampling samples select

#define URT0_CR1_TXSTP_LEN                          URT0->CR1.MBIT.TXSTP_LEN        //[23..22] UART TX stop bit length select
#define URT1_CR1_TXSTP_LEN                          URT1->CR1.MBIT.TXSTP_LEN        //[23..22] UART TX stop bit length select
#define URT2_CR1_TXSTP_LEN                          URT2->CR1.MBIT.TXSTP_LEN        //[23..22] UART TX stop bit length select
#define URT3_CR1_TXSTP_LEN                          URT3->CR1.MBIT.TXSTP_LEN        //[23..22] UART TX stop bit length select

#define URT0_CR1_TXMSB_EN                           URT0->CR1.MBIT.TXMSB_EN         //[21] UART TX data order Msb first enable
#define URT1_CR1_TXMSB_EN                           URT1->CR1.MBIT.TXMSB_EN         //[21] UART TX data order Msb first enable
#define URT2_CR1_TXMSB_EN                           URT2->CR1.MBIT.TXMSB_EN         //[21] UART TX data order Msb first enable
#define URT3_CR1_TXMSB_EN                           URT3->CR1.MBIT.TXMSB_EN         //[21] UART TX data order Msb first enable

#define URT0_CR1_TXPAR_STK                          URT0->CR1.MBIT.TXPAR_STK        //[20] UART stuck parity bit output enable
#define URT1_CR1_TXPAR_STK                          URT1->CR1.MBIT.TXPAR_STK        //[20] UART stuck parity bit output enable
#define URT2_CR1_TXPAR_STK                          URT2->CR1.MBIT.TXPAR_STK        //[20] UART stuck parity bit output enable
#define URT3_CR1_TXPAR_STK                          URT3->CR1.MBIT.TXPAR_STK        //[20] UART stuck parity bit output enable

#define URT0_CR1_TXPAR_POL                          URT0->CR1.MBIT.TXPAR_POL        //[19] UART TX parity bit polarity. This bit is no effect for SPI and SYNC mods.
#define URT1_CR1_TXPAR_POL                          URT1->CR1.MBIT.TXPAR_POL        //[19] UART TX parity bit polarity. This bit is no effect for SPI and SYNC mods.
#define URT2_CR1_TXPAR_POL                          URT2->CR1.MBIT.TXPAR_POL        //[19] UART TX parity bit polarity. This bit is no effect for SPI and SYNC mods.
#define URT3_CR1_TXPAR_POL                          URT3->CR1.MBIT.TXPAR_POL        //[19] UART TX parity bit polarity. This bit is no effect for SPI and SYNC mods.

#define URT0_CR1_TXPAR_EN                           URT0->CR1.MBIT.TXPAR_EN         //[18] UART TX parity bit enable
#define URT1_CR1_TXPAR_EN                           URT1->CR1.MBIT.TXPAR_EN         //[18] UART TX parity bit enable
#define URT2_CR1_TXPAR_EN                           URT2->CR1.MBIT.TXPAR_EN         //[18] UART TX parity bit enable
#define URT3_CR1_TXPAR_EN                           URT3->CR1.MBIT.TXPAR_EN         //[18] UART TX parity bit enable

#define URT0_CR1_TXDSIZE                            URT0->CR1.MBIT.TXDSIZE          //[17..16] UART TX data bit length
#define URT1_CR1_TXDSIZE                            URT1->CR1.MBIT.TXDSIZE          //[17..16] UART TX data bit length
#define URT2_CR1_TXDSIZE                            URT2->CR1.MBIT.TXDSIZE          //[17..16] UART TX data bit length
#define URT3_CR1_TXDSIZE                            URT3->CR1.MBIT.TXDSIZE          //[17..16] UART TX data bit length

#define URT0_CR1_RXOS_NUM                           URT0->CR1.MBIT.RXOS_NUM         //[12..8] UART RX data oversampling samples select
#define URT1_CR1_RXOS_NUM                           URT1->CR1.MBIT.RXOS_NUM         //[12..8] UART RX data oversampling samples select
#define URT2_CR1_RXOS_NUM                           URT2->CR1.MBIT.RXOS_NUM         //[12..8] UART RX data oversampling samples select
#define URT3_CR1_RXOS_NUM                           URT3->CR1.MBIT.RXOS_NUM         //[12..8] UART RX data oversampling samples select

#define URT0_CR1_RXSTP_LEN                          URT0->CR1.MBIT.RXSTP_LEN        //[7..6] UART RX stop bit length select
#define URT1_CR1_RXSTP_LEN                          URT1->CR1.MBIT.RXSTP_LEN        //[7..6] UART RX stop bit length select
#define URT2_CR1_RXSTP_LEN                          URT2->CR1.MBIT.RXSTP_LEN        //[7..6] UART RX stop bit length select
#define URT3_CR1_RXSTP_LEN                          URT3->CR1.MBIT.RXSTP_LEN        //[7..6] UART RX stop bit length select

#define URT0_CR1_RXMSB_EN                           URT0->CR1.MBIT.RXMSB_EN         //[5] UART RX data order Msb first enable
#define URT1_CR1_RXMSB_EN                           URT1->CR1.MBIT.RXMSB_EN         //[5] UART RX data order Msb first enable
#define URT2_CR1_RXMSB_EN                           URT2->CR1.MBIT.RXMSB_EN         //[5] UART RX data order Msb first enable
#define URT3_CR1_RXMSB_EN                           URT3->CR1.MBIT.RXMSB_EN         //[5] UART RX data order Msb first enable

#define URT0_CR1_RXPAR_STK                          URT0->CR1.MBIT.RXPAR_STK        //[4] UART stuck parity bit input enable
#define URT1_CR1_RXPAR_STK                          URT1->CR1.MBIT.RXPAR_STK        //[4] UART stuck parity bit input enable
#define URT2_CR1_RXPAR_STK                          URT2->CR1.MBIT.RXPAR_STK        //[4] UART stuck parity bit input enable
#define URT3_CR1_RXPAR_STK                          URT3->CR1.MBIT.RXPAR_STK        //[4] UART stuck parity bit input enable

#define URT0_CR1_RXPAR_POL                          URT0->CR1.MBIT.RXPAR_POL        //[3] UART RX parity bit polarity. This bit is no effect for SYNC mods.
#define URT1_CR1_RXPAR_POL                          URT1->CR1.MBIT.RXPAR_POL        //[3] UART RX parity bit polarity. This bit is no effect for SYNC mods.
#define URT2_CR1_RXPAR_POL                          URT2->CR1.MBIT.RXPAR_POL        //[3] UART RX parity bit polarity. This bit is no effect for SYNC mods.
#define URT3_CR1_RXPAR_POL                          URT3->CR1.MBIT.RXPAR_POL        //[3] UART RX parity bit polarity. This bit is no effect for SYNC mods.

#define URT0_CR1_RXPAR_EN                           URT0->CR1.MBIT.RXPAR_EN         //[2] UART RX parity bit enable
#define URT1_CR1_RXPAR_EN                           URT1->CR1.MBIT.RXPAR_EN         //[2] UART RX parity bit enable
#define URT2_CR1_RXPAR_EN                           URT2->CR1.MBIT.RXPAR_EN         //[2] UART RX parity bit enable
#define URT3_CR1_RXPAR_EN                           URT3->CR1.MBIT.RXPAR_EN         //[2] UART RX parity bit enable

#define URT0_CR1_RXDSIZE                            URT0->CR1.MBIT.RXDSIZE          //[1..0] UART RX data bit length
#define URT1_CR1_RXDSIZE                            URT1->CR1.MBIT.RXDSIZE          //[1..0] UART RX data bit length
#define URT2_CR1_RXDSIZE                            URT2->CR1.MBIT.RXDSIZE          //[1..0] UART RX data bit length
#define URT3_CR1_RXDSIZE                            URT3->CR1.MBIT.RXDSIZE          //[1..0] UART RX data bit length

///@}
/**
 ******************************************************************************
 * @name        URT_CR2  [register's definitions]
 *              Offset[0x18]  URT control register 2
 ******************************************************************************
 */
///@{
#define URT0_CR2                                    URT0->CR2.W                     /*!< Offset[0x18]  URT0 control register 2 (0x52000018) */
#define URT1_CR2                                    URT1->CR2.W                     /*!< Offset[0x18]  URT1 control register 2 (0x52010018) */
#define URT2_CR2                                    URT2->CR2.W                     /*!< Offset[0x18]  URT2 control register 2 (0x52020018) */
#define URT3_CR2                                    URT3->CR2.W                     /*!< Offset[0x18]  URT3 control register 2 (0x52030018) */

/* Bit fields of URT_CR2 */
#define URT0_CR2_NSS_SWEN                           URT0->CR2.MBIT.NSS_SWEN         //[26] UART NSS signal output set by software control function enable bit.
#define URT1_CR2_NSS_SWEN                           URT1->CR2.MBIT.NSS_SWEN         //[26] UART NSS signal output use software control bit enable.
#define URT2_CR2_NSS_SWEN                           URT2->CR2.MBIT.NSS_SWEN         //[26] UART NSS signal output use software control bit enable.
#define URT3_CR2_NSS_SWEN                           URT3->CR2.MBIT.NSS_SWEN         //[26] UART NSS signal output use software control bit enable.

#define URT0_CR2_NSS_INV                            URT0->CR2.MBIT.NSS_INV          //[25] UART NSS output signal inverse enable
#define URT1_CR2_NSS_INV                            URT1->CR2.MBIT.NSS_INV          //[25] UART NSS output signal inverse enable
#define URT2_CR2_NSS_INV                            URT2->CR2.MBIT.NSS_INV          //[25] UART NSS output signal inverse enable
#define URT3_CR2_NSS_INV                            URT3->CR2.MBIT.NSS_INV          //[25] UART NSS output signal inverse enable

#define URT0_CR2_NSS_SWO                            URT0->CR2.MBIT.NSS_SWO          //[16] UART NSS signal software output control bit when URTx_NSS_SWEN is enable.
#define URT1_CR2_NSS_SWO                            URT1->CR2.MBIT.NSS_SWO          //[16] UART NSS signal software output control bit when URTx_NSS_SWEN is disable.
#define URT2_CR2_NSS_SWO                            URT2->CR2.MBIT.NSS_SWO          //[16] UART NSS signal software output control bit when URTx_NSS_SWEN is disable.
#define URT3_CR2_NSS_SWO                            URT3->CR2.MBIT.NSS_SWO          //[16] UART NSS signal software output control bit when URTx_NSS_SWEN is disable.

#define URT0_CR2_TX_HALT                            URT0->CR2.MBIT.TX_HALT          //[4] UART transmitter halt enable.
#define URT1_CR2_TX_HALT                            URT1->CR2.MBIT.TX_HALT          //[4] UART transmitter halt enable.
#define URT2_CR2_TX_HALT                            URT2->CR2.MBIT.TX_HALT          //[4] UART transmitter halt enable.
#define URT3_CR2_TX_HALT                            URT3->CR2.MBIT.TX_HALT          //[4] UART transmitter halt enable.

#define URT0_CR2_TX_EN                              URT0->CR2.MBIT.TX_EN            //[3] UART transmitter enable.
#define URT1_CR2_TX_EN                              URT1->CR2.MBIT.TX_EN            //[3] UART transmitter enable.
#define URT2_CR2_TX_EN                              URT2->CR2.MBIT.TX_EN            //[3] UART transmitter enable.
#define URT3_CR2_TX_EN                              URT3->CR2.MBIT.TX_EN            //[3] UART transmitter enable.

#define URT0_CR2_RX_EN                              URT0->CR2.MBIT.RX_EN            //[2] UART receiver enable
#define URT1_CR2_RX_EN                              URT1->CR2.MBIT.RX_EN            //[2] UART receiver enable
#define URT2_CR2_RX_EN                              URT2->CR2.MBIT.RX_EN            //[2] UART receiver enable
#define URT3_CR2_RX_EN                              URT3->CR2.MBIT.RX_EN            //[2] UART receiver enable

#define URT0_CR2_ADR_TX                             URT0->CR2.MBIT.ADR_TX           //[1] UART slave address for next data transmitted
#define URT1_CR2_ADR_TX                             URT1->CR2.MBIT.ADR_TX           //[1] UART slave address for next data transmitted
#define URT2_CR2_ADR_TX                             URT2->CR2.MBIT.ADR_TX           //[1] UART slave address for next data transmitted
#define URT3_CR2_ADR_TX                             URT3->CR2.MBIT.ADR_TX           //[1] UART slave address for next data transmitted

#define URT0_CR2_BK_TX                              URT0->CR2.MBIT.BK_TX            //[0] UART break condition for next data transmitted
#define URT1_CR2_BK_TX                              URT1->CR2.MBIT.BK_TX            //[0] UART break condition for next data transmitted
#define URT2_CR2_BK_TX                              URT2->CR2.MBIT.BK_TX            //[0] UART break condition for next data transmitted
#define URT3_CR2_BK_TX                              URT3->CR2.MBIT.BK_TX            //[0] UART break condition for next data transmitted

///@}
/**
 ******************************************************************************
 * @name        URT_CR3  [register's definitions]
 *              Offset[0x1C]  URT control register 3
 ******************************************************************************
 */
///@{
#define URT0_CR3                                    URT0->CR3.W                     /*!< Offset[0x1C]  URT0 control register 3 (0x5200001C) */
#define URT1_CR3                                    URT1->CR3.W                     /*!< Offset[0x1C]  URT1 control register 3 (0x5201001C) */
#define URT2_CR3                                    URT2->CR3.W                     /*!< Offset[0x1C]  URT2 control register 3 (0x5202001C) */
#define URT3_CR3                                    URT3->CR3.W                     /*!< Offset[0x1C]  URT3 control register 3 (0x5203001C) */

/* Bit fields of URT_CR3 */
#define URT0_CR3_TXGT_LEN                           URT0->CR3.MBIT.TXGT_LEN         //[23..16] UART TX guard time or idle-line length
#define URT1_CR3_TXGT_LEN                           URT1->CR3.MBIT.TXGT_LEN         //[23..16] UART TX guard time or idle-line length
#define URT2_CR3_TXGT_LEN                           URT2->CR3.MBIT.TXGT_LEN         //[23..16] UART TX guard time or idle-line length
#define URT3_CR3_TXGT_LEN                           URT3->CR3.MBIT.TXGT_LEN         //[23..16] UART TX guard time or idle-line length

#define URT0_CR3_DET_IDL                            URT0->CR3.MBIT.DET_IDL          //[15..8] UART idle line detect threshold value by using receive bit time
#define URT1_CR3_DET_IDL                            URT1->CR3.MBIT.DET_IDL          //[15..8] UART idle line detect threshold value by using receive bit time
#define URT2_CR3_DET_IDL                            URT2->CR3.MBIT.DET_IDL          //[15..8] UART idle line detect threshold value by using receive bit time
#define URT3_CR3_DET_IDL                            URT3->CR3.MBIT.DET_IDL          //[15..8] UART idle line detect threshold value by using receive bit time

#define URT0_CR3_DET_BK                             URT0->CR3.MBIT.DET_BK           //[4] UART bit time select for break detection or transmission
#define URT1_CR3_DET_BK                             URT1->CR3.MBIT.DET_BK           //[4] UART bit time select for break detection or transmission
#define URT2_CR3_DET_BK                             URT2->CR3.MBIT.DET_BK           //[4] UART bit time select for break detection or transmission
#define URT3_CR3_DET_BK                             URT3->CR3.MBIT.DET_BK           //[4] UART bit time select for break detection or transmission

#define URT0_CR3_CPHA                               URT0->CR3.MBIT.CPHA             //[2] UART clock phase select
#define URT1_CR3_CPHA                               URT1->CR3.MBIT.CPHA             //[2] UART clock phase select
#define URT2_CR3_CPHA                               URT2->CR3.MBIT.CPHA             //[2] UART clock phase select
#define URT3_CR3_CPHA                               URT3->CR3.MBIT.CPHA             //[2] UART clock phase select

#define URT0_CR3_CPOL                               URT0->CR3.MBIT.CPOL             //[1] UART clock polarity select. It is used to select the SPI clock level in idle state.
#define URT1_CR3_CPOL                               URT1->CR3.MBIT.CPOL             //[1] UART clock polarity select. It is used to select the SPI clock level in idle state.
#define URT2_CR3_CPOL                               URT2->CR3.MBIT.CPOL             //[1] UART clock polarity select. It is used to select the SPI clock level in idle state.
#define URT3_CR3_CPOL                               URT3->CR3.MBIT.CPOL             //[1] UART clock polarity select. It is used to select the SPI clock level in idle state.

///@}
/**
 ******************************************************************************
 * @name        URT_CR4  [register's definitions]
 *              Offset[0x20]  URT control register 4
 ******************************************************************************
 */
///@{
#define URT0_CR4                                    URT0->CR4.W                     /*!< Offset[0x20]  URT0 control register 4 (0x52000020) */
#define URT1_CR4                                    URT1->CR4.W                     /*!< Offset[0x20]  URT1 control register 4 (0x52010020) */
#define URT2_CR4                                    URT2->CR4.W                     /*!< Offset[0x20]  UART control register 4 (0x52020020) */
#define URT3_CR4                                    URT3->CR4.W                     /*!< Offset[0x20]  URT3 control register 4 (0x52030020) */

/* Bit fields of URT_CR4 */
#define URT0_CR4_TNUM                               URT0->CR4.MBIT.TNUM             //[14..12] UART remained data byte number in data register. Value 0~4 is valid only.
#define URT1_CR4_TNUM                               URT1->CR4.MBIT.TNUM             //[14..12] UART remained data byte number in data register. Value 0~4 is valid only.
#define URT2_CR4_TNUM                               URT2->CR4.MBIT.TNUM             //[14..12] UART remained data byte number in data register. Value 0~4 is valid only.
#define URT3_CR4_TNUM                               URT3->CR4.MBIT.TNUM             //[14..12] UART remained data byte number in data register. Value 0~4 is valid only.

#define URT0_CR4_RNUM                               URT0->CR4.MBIT.RNUM             //[10..8] UART received data byte number when data shadow buffer last transfer to URTx_RDAT reg
#define URT1_CR4_RNUM                               URT1->CR4.MBIT.RNUM             //[10..8] UART received data byte number when data shadow buffer last transfer to URTx_RDAT reg
#define URT2_CR4_RNUM                               URT2->CR4.MBIT.RNUM             //[10..8] UART received data byte number when data shadow buffer last transfer to URTx_RDAT reg
#define URT3_CR4_RNUM                               URT3->CR4.MBIT.RNUM             //[10..8] UART received data byte number when data shadow buffer last transfer to URTx_RDAT reg

#define URT0_CR4_TDAT_CLR                           URT0->CR4.MBIT.TDAT_CLR         //[7] UART  transmitted data clear enable
#define URT1_CR4_TDAT_CLR                           URT1->CR4.MBIT.TDAT_CLR         //[7] UART  transmitted data clear enable
#define URT2_CR4_TDAT_CLR                           URT2->CR4.MBIT.TDAT_CLR         //[7] UART  transmitted data clear enable
#define URT3_CR4_TDAT_CLR                           URT3->CR4.MBIT.TDAT_CLR         //[7] UART  transmitted data clear enable

#define URT0_CR4_RDAT_CLR                           URT0->CR4.MBIT.RDAT_CLR         //[6] UART  received data clear enable
#define URT1_CR4_RDAT_CLR                           URT1->CR4.MBIT.RDAT_CLR         //[6] UART  received data clear enable
#define URT2_CR4_RDAT_CLR                           URT2->CR4.MBIT.RDAT_CLR         //[6] UART  received data clear enable
#define URT3_CR4_RDAT_CLR                           URT3->CR4.MBIT.RDAT_CLR         //[6] UART  received data clear enable

#define URT0_CR4_TDAT_INV                           URT0->CR4.MBIT.TDAT_INV         //[5] UART inverse transmitted data enable
#define URT1_CR4_TDAT_INV                           URT1->CR4.MBIT.TDAT_INV         //[5] UART inverse transmitted data enable
#define URT2_CR4_TDAT_INV                           URT2->CR4.MBIT.TDAT_INV         //[5] UART inverse transmitted data enable
#define URT3_CR4_TDAT_INV                           URT3->CR4.MBIT.TDAT_INV         //[5] UART inverse transmitted data enable

#define URT0_CR4_RDAT_INV                           URT0->CR4.MBIT.RDAT_INV         //[4] UART inverse received data enable
#define URT1_CR4_RDAT_INV                           URT1->CR4.MBIT.RDAT_INV         //[4] UART inverse received data enable
#define URT2_CR4_RDAT_INV                           URT2->CR4.MBIT.RDAT_INV         //[4] UART inverse received data enable
#define URT3_CR4_RDAT_INV                           URT3->CR4.MBIT.RDAT_INV         //[4] UART inverse received data enable

///@}
/**
 ******************************************************************************
 * @name        URT_RLR  [register's definitions]
 *              Offset[0x24]  URT baud-rate clock counter reload register
 ******************************************************************************
 */
///@{
#define URT0_RLR                                    URT0->RLR.W                     /*!< Offset[0x24]  URT0 baud-rate clock counter reload register (0x52000024) */
#define URT1_RLR                                    URT1->RLR.W                     /*!< Offset[0x24]  URT1 baud-rate clock counter reload register (0x52010024) */
#define URT2_RLR                                    URT2->RLR.W                     /*!< Offset[0x24]  URT2 baud-rate clock counter reload register (0x52020024) */
#define URT3_RLR                                    URT3->RLR.W                     /*!< Offset[0x24]  URT3 baud-rate clock counter reload register (0x52030024) */

/* Bit fields of URT_RLR */
#define URT0_RLR_PSR                                URT0->RLR.MBIT.PSR              //[11..8] UART baud-rate clock prescaler reload register
#define URT1_RLR_PSR                                URT1->RLR.MBIT.PSR              //[11..8] UART baud-rate clock prescaler reload register
#define URT2_RLR_PSR                                URT2->RLR.MBIT.PSR              //[11..8] UART baud-rate clock prescaler reload register
#define URT3_RLR_PSR                                URT3->RLR.MBIT.PSR              //[11..8] UART baud-rate clock prescaler reload register

#define URT0_RLR_RLR                                URT0->RLR.MBIT.RLR              //[7..0] UART baud-rate clock counter reload register
#define URT1_RLR_RLR                                URT1->RLR.MBIT.RLR              //[7..0] UART baud-rate clock counter reload register
#define URT2_RLR_RLR                                URT2->RLR.MBIT.RLR              //[7..0] UART baud-rate clock counter reload register
#define URT3_RLR_RLR                                URT3->RLR.MBIT.RLR              //[7..0] UART baud-rate clock counter reload register

///@}
/**
 ******************************************************************************
 * @name        URT_CNT  [register's definitions]
 *              Offset[0x28]  URT baud-rate clock counter register
 ******************************************************************************
 */
///@{
#define URT0_CNT                                    URT0->CNT.W                     /*!< Offset[0x28]  URT0 baud-rate clock counter register (0x52000028) */
#define URT1_CNT                                    URT1->CNT.W                     /*!< Offset[0x28]  URT1 baud-rate clock counter register (0x52010028) */
#define URT2_CNT                                    URT2->CNT.W                     /*!< Offset[0x28]  URT2 baud-rate clock counter register (0x52020028) */
#define URT3_CNT                                    URT3->CNT.W                     /*!< Offset[0x28]  URT3 baud-rate clock counter register (0x52030028) */

/* Bit fields of URT_CNT */
#define URT0_CNT_PSC                                URT0->CNT.MBIT.PSC              //[11..8] UART baud-rate clock prescaler value register.
#define URT1_CNT_PSC                                URT1->CNT.MBIT.PSC              //[11..8] UART baud-rate clock prescaler value register.
#define URT2_CNT_PSC                                URT2->CNT.MBIT.PSC              //[11..8] UART baud-rate clock prescaler value register.
#define URT3_CNT_PSC                                URT3->CNT.MBIT.PSC              //[11..8] UART baud-rate clock prescaler value register.

#define URT0_CNT_CNT                                URT0->CNT.MBIT.CNT              //[7..0] UART baud-rate clock counter value register.
#define URT1_CNT_CNT                                URT1->CNT.MBIT.CNT              //[7..0] UART baud-rate clock counter value register.
#define URT2_CNT_CNT                                URT2->CNT.MBIT.CNT              //[7..0] UART baud-rate clock counter value register.
#define URT3_CNT_CNT                                URT3->CNT.MBIT.CNT              //[7..0] UART baud-rate clock counter value register.

///@}
/**
 ******************************************************************************
 * @name        URT_RCAP  [register's definitions]
 *              Offset[0x2C]  URT RX data capture register
 ******************************************************************************
 */
///@{
#define URT0_RCAP                                   URT0->RCAP.W                    /*!< Offset[0x2C]  URT0 RX data capture register (0x5200002C) */
#define URT1_RCAP                                   URT1->RCAP.W                    /*!< Offset[0x2C]  URT1 RX data capture register (0x5201002C) */
#define URT2_RCAP                                   URT2->RCAP.W                    /*!< Offset[0x2C]  URT2 RX data capture register (0x5202002C) */
#define URT3_RCAP                                   URT3->RCAP.W                    /*!< Offset[0x2C]  URT3 RX data capture register (0x5203002C) */

/* Bit fields of URT_RCAP */
#define URT0_RCAP_RCAP_ADR                          URT0->RCAP.MBIT.RCAP_ADR        //[10] UART capture address bit from RX shift buffer.
#define URT1_RCAP_RCAP_ADR                          URT1->RCAP.MBIT.RCAP_ADR        //[10] UART capture address bit from RX shift buffer.
#define URT2_RCAP_RCAP_ADR                          URT2->RCAP.MBIT.RCAP_ADR        //[10] UART capture address bit from RX shift buffer.
#define URT3_RCAP_RCAP_ADR                          URT3->RCAP.MBIT.RCAP_ADR        //[10] UART capture address bit from RX shift buffer.

#define URT0_RCAP_RCAP_PAR                          URT0->RCAP.MBIT.RCAP_PAR        //[9] UART capture parity bit from RX shift buffer.
#define URT1_RCAP_RCAP_PAR                          URT1->RCAP.MBIT.RCAP_PAR        //[9] UART capture parity bit from RX shift buffer.
#define URT2_RCAP_RCAP_PAR                          URT2->RCAP.MBIT.RCAP_PAR        //[9] UART capture parity bit from RX shift buffer.
#define URT3_RCAP_RCAP_PAR                          URT3->RCAP.MBIT.RCAP_PAR        //[9] UART capture parity bit from RX shift buffer.

#define URT0_RCAP_RCAP_STP                          URT0->RCAP.MBIT.RCAP_STP        //[8] UART capture stop bit from RX shift buffer.
#define URT1_RCAP_RCAP_STP                          URT1->RCAP.MBIT.RCAP_STP        //[8] UART capture stop bit from RX shift buffer.
#define URT2_RCAP_RCAP_STP                          URT2->RCAP.MBIT.RCAP_STP        //[8] UART capture stop bit from RX shift buffer.
#define URT3_RCAP_RCAP_STP                          URT3->RCAP.MBIT.RCAP_STP        //[8] UART capture stop bit from RX shift buffer.

#define URT0_RCAP_RCAP_DAT                          URT0->RCAP.MBIT.RCAP_DAT        //[7..0] UART capture data from RX shift buffer for Parity error / Frame error / Break detect 
#define URT1_RCAP_RCAP_DAT                          URT1->RCAP.MBIT.RCAP_DAT        //[7..0] UART capture data from RX shift buffer for Parity error / Frame error / Break detect 
#define URT2_RCAP_RCAP_DAT                          URT2->RCAP.MBIT.RCAP_DAT        //[7..0] UART capture data from RX shift buffer for Parity error / Frame error / Break detect 
#define URT3_RCAP_RCAP_DAT                          URT3->RCAP.MBIT.RCAP_DAT        //[7..0] UART capture data from RX shift buffer for Parity error / Frame error / Break detect 

///@}
/**
 ******************************************************************************
 * @name        URT_RDAT  [register's definitions]
 *              Offset[0x30]  URT RX data register
 ******************************************************************************
 */
///@{
#define URT0_RDAT                                   URT0->RDAT.W                    /*!< Offset[0x30]  URT0 RX data register (0x52000030) */
#define URT1_RDAT                                   URT1->RDAT.W                    /*!< Offset[0x30]  URT1 RX data register (0x52010030) */
#define URT2_RDAT                                   URT2->RDAT.W                    /*!< Offset[0x30]  URT2 RX data register (0x52020030) */
#define URT3_RDAT                                   URT3->RDAT.W                    /*!< Offset[0x30]  URT3 RX data register (0x52030030) */

/* Bit fields of URT_RDAT */
#define URT0_RDAT_RDAT                              URT0->RDAT.MBIT.RDAT            //[31..0] UART received data register
#define URT1_RDAT_RDAT                              URT1->RDAT.MBIT.RDAT            //[31..0] UART received data register
#define URT2_RDAT_RDAT                              URT2->RDAT.MBIT.RDAT            //[31..0] UART received data register
#define URT3_RDAT_RDAT                              URT3->RDAT.MBIT.RDAT            //[31..0] UART received data register

///@}
/**
 ******************************************************************************
 * @name        URT_TDAT  [register's definitions]
 *              Offset[0x34]  URT TX data register
 ******************************************************************************
 */
///@{
#define URT0_TDAT                                   URT0->TDAT.W                    /*!< Offset[0x34]  URT0 TX data register (0x52000034) */
#define URT1_TDAT                                   URT1->TDAT.W                    /*!< Offset[0x34]  URT1 TX data register (0x52010034) */
#define URT2_TDAT                                   URT2->TDAT.W                    /*!< Offset[0x34]  URT2 TX data register (0x52020034) */
#define URT3_TDAT                                   URT3->TDAT.W                    /*!< Offset[0x34]  URT3 TX data register (0x52030034) */

/* Bit fields of URT_TDAT */
#define URT0_TDAT_TDAT                              URT0->TDAT.MBIT.TDAT            //[31..0] UART transmitted data register
#define URT1_TDAT_TDAT                              URT1->TDAT.MBIT.TDAT            //[31..0] UART transmitted data register
#define URT2_TDAT_TDAT                              URT2->TDAT.MBIT.TDAT            //[31..0] UART transmitted data register
#define URT3_TDAT_TDAT                              URT3->TDAT.MBIT.TDAT            //[31..0] UART transmitted data register

///@}
/**
 ******************************************************************************
 * @name        URT_TDAT3  [register's definitions]
 *              Offset[0x38]  URT TX data 3-byte register
 ******************************************************************************
 */
///@{
#define URT0_TDAT3                                  URT0->TDAT3.W                   /*!< Offset[0x38]  URT0 TX data 3-byte register (0x52000038) */
#define URT1_TDAT3                                  URT1->TDAT3.W                   /*!< Offset[0x38]  URT1 TX data 3-byte register (0x52010038) */
#define URT2_TDAT3                                  URT2->TDAT3.W                   /*!< Offset[0x38]  URT2 TX data 3-byte register (0x52020038) */
#define URT3_TDAT3                                  URT3->TDAT3.W                   /*!< Offset[0x38]  URT3 TX data 3-byte register (0x52030038) */

/* Bit fields of URT_TDAT3 */
#define URT0_TDAT3_TDAT3                            URT0->TDAT3.MBIT.TDAT3          //[23..0] UART transmitted data register for 3-byte data write only
#define URT1_TDAT3_TDAT3                            URT1->TDAT3.MBIT.TDAT3          //[23..0] UART transmitted data register for 3-byte data write only
#define URT2_TDAT3_TDAT3                            URT2->TDAT3.MBIT.TDAT3          //[23..0] UART transmitted data register for 3-byte data write only
#define URT3_TDAT3_TDAT3                            URT3->TDAT3.MBIT.TDAT3          //[23..0] UART transmitted data register for 3-byte data write only

///@}
/**
 ******************************************************************************
 * @name        URT_SBUF  [register's definitions]
 *              Offset[0x3C]  URT data shift buffer register
 ******************************************************************************
 */
///@{
#define URT0_SBUF                                   URT0->SBUF.W                    /*!< Offset[0x3C]  URT0 data shift buffer register (0x5200003C) */
#define URT1_SBUF                                   URT1->SBUF.W                    /*!< Offset[0x3C]  URT1 data shift buffer register (0x5201003C) */
#define URT2_SBUF                                   URT2->SBUF.W                    /*!< Offset[0x3C]  URT2 data shift buffer register (0x5202003C) */
#define URT3_SBUF                                   URT3->SBUF.W                    /*!< Offset[0x3C]  URT3 data shift buffer register (0x5203003C) */

/* Bit fields of URT_SBUF */
#define URT0_SBUF_TSBUF                             URT0->SBUF.MBIT.TSBUF           //[15..8] UART TX data shift buffer register.
#define URT1_SBUF_TSBUF                             URT1->SBUF.MBIT.TSBUF           //[15..8] UART TX data shift buffer register.
#define URT2_SBUF_TSBUF                             URT2->SBUF.MBIT.TSBUF           //[15..8] UART TX data shift buffer register.
#define URT3_SBUF_TSBUF                             URT3->SBUF.MBIT.TSBUF           //[15..8] UART TX data shift buffer register.

#define URT0_SBUF_RSBUF                             URT0->SBUF.MBIT.RSBUF           //[7..0] UART RX data shift buffer register.
#define URT1_SBUF_RSBUF                             URT1->SBUF.MBIT.RSBUF           //[7..0] UART RX data shift buffer register.
#define URT2_SBUF_RSBUF                             URT2->SBUF.MBIT.RSBUF           //[7..0] UART RX data shift buffer register.
#define URT3_SBUF_RSBUF                             URT3->SBUF.MBIT.RSBUF           //[7..0] UART RX data shift buffer register.

///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT  [register's definitions]
 *              Offset[0x40]  URT timeout control register
 ******************************************************************************
 */
///@{
#define URT0_TMOUT                                  URT0->TMOUT.W                   /*!< Offset[0x40]  URT0 timeout control register (0x52000040) */
#define URT1_TMOUT                                  URT1->TMOUT.W                   /*!< Offset[0x40]  URT1 timeout control register (0x52010040) */
#define URT2_TMOUT                                  URT2->TMOUT.W                   /*!< Offset[0x40]  URT2 timeout control register (0x52020040) */
#define URT3_TMOUT                                  URT3->TMOUT.W                   /*!< Offset[0x40]  URT3 timeout control register (0x52030040) */

/* Bit fields of URT_TMOUT */
#define URT0_TMOUT_CALTMO_TH                        URT0->TMOUT.MBIT.CALTMO_TH      //[31..28] UART calibration timeout detect threshold value for TMO counter value comparison
#define URT1_TMOUT_CALTMO_TH                        URT1->TMOUT.MBIT.CALTMO_TH      //[31..28] UART calibration timeout detect threshold value for TMO counter value comparison
#define URT2_TMOUT_CALTMO_TH                        URT2->TMOUT.MBIT.CALTMO_TH      //[31..28] UART calibration timeout detect threshold value for TMO counter value comparison
#define URT3_TMOUT_CALTMO_TH                        URT3->TMOUT.MBIT.CALTMO_TH      //[31..28] UART calibration timeout detect threshold value for TMO counter value comparison

#define URT0_TMOUT_BKTMO_TH                         URT0->TMOUT.MBIT.BKTMO_TH       //[27..24] UART receive Break timeout detect threshold value by using receive bit time
#define URT1_TMOUT_BKTMO_TH                         URT1->TMOUT.MBIT.BKTMO_TH       //[27..24] UART receive Break timeout detect threshold value by using receive bit time
#define URT2_TMOUT_BKTMO_TH                         URT2->TMOUT.MBIT.BKTMO_TH       //[27..24] UART receive Break timeout detect threshold value by using receive bit time
#define URT3_TMOUT_BKTMO_TH                         URT3->TMOUT.MBIT.BKTMO_TH       //[27..24] UART receive Break timeout detect threshold value by using receive bit time

#define URT0_TMOUT_RXTMO_TH                         URT0->TMOUT.MBIT.RXTMO_TH       //[23..16] UART RX data buffer timeout detect threshold value by using receive bit time
#define URT1_TMOUT_RXTMO_TH                         URT1->TMOUT.MBIT.RXTMO_TH       //[23..16] UART RX data buffer timeout detect threshold value by using receive bit time
#define URT2_TMOUT_RXTMO_TH                         URT2->TMOUT.MBIT.RXTMO_TH       //[23..16] UART RX data buffer timeout detect threshold value by using receive bit time
#define URT3_TMOUT_RXTMO_TH                         URT3->TMOUT.MBIT.RXTMO_TH       //[23..16] UART RX data buffer timeout detect threshold value by using receive bit time

#define URT0_TMOUT_TMO_LCK                          URT0->TMOUT.MBIT.TMO_LCK        //[15] UART timeout timer timeout signal initial state control
#define URT1_TMOUT_TMO_LCK                          URT1->TMOUT.MBIT.TMO_LCK        //[15] UART timeout timer timeout signal initial state control
#define URT2_TMOUT_TMO_LCK                          URT2->TMOUT.MBIT.TMO_LCK        //[15] UART timeout timer timeout signal initial state control
#define URT3_TMOUT_TMO_LCK                          URT3->TMOUT.MBIT.TMO_LCK        //[15] UART timeout timer timeout signal initial state control

#define URT0_TMOUT_TMO_STA                          URT0->TMOUT.MBIT.TMO_STA        //[14] UART timeout timer timeout signal initial state
#define URT1_TMOUT_TMO_STA                          URT1->TMOUT.MBIT.TMO_STA        //[14] UART timeout timer timeout signal initial state
#define URT2_TMOUT_TMO_STA                          URT2->TMOUT.MBIT.TMO_STA        //[14] UART timeout timer timeout signal initial state
#define URT3_TMOUT_TMO_STA                          URT3->TMOUT.MBIT.TMO_STA        //[14] UART timeout timer timeout signal initial state

#define URT0_TMOUT_TMO_CKS                          URT0->TMOUT.MBIT.TMO_CKS        //[10..8] UART timeout timer clock source select
#define URT1_TMOUT_TMO_CKS                          URT1->TMOUT.MBIT.TMO_CKS        //[10..8] UART timeout timer clock source select
#define URT2_TMOUT_TMO_CKS                          URT2->TMOUT.MBIT.TMO_CKS        //[10..8] UART timeout timer clock source select
#define URT3_TMOUT_TMO_CKS                          URT3->TMOUT.MBIT.TMO_CKS        //[10..8] UART timeout timer clock source select

#define URT0_TMOUT_CALTMO_EN                        URT0->TMOUT.MBIT.CALTMO_EN      //[7] UART Calibration timeout detection enable bit
#define URT1_TMOUT_CALTMO_EN                        URT1->TMOUT.MBIT.CALTMO_EN      //[7] UART Calibration timeout detection enable bit
#define URT2_TMOUT_CALTMO_EN                        URT2->TMOUT.MBIT.CALTMO_EN      //[7] UART Calibration timeout detection enable bit
#define URT3_TMOUT_CALTMO_EN                        URT3->TMOUT.MBIT.CALTMO_EN      //[7] UART Calibration timeout detection enable bit

#define URT0_TMOUT_BKTMO_EN                         URT0->TMOUT.MBIT.BKTMO_EN       //[6] UART Break timeout detection enable bit
#define URT1_TMOUT_BKTMO_EN                         URT1->TMOUT.MBIT.BKTMO_EN       //[6] UART Break timeout detection enable bit
#define URT2_TMOUT_BKTMO_EN                         URT2->TMOUT.MBIT.BKTMO_EN       //[6] UART Break timeout detection enable bit
#define URT3_TMOUT_BKTMO_EN                         URT3->TMOUT.MBIT.BKTMO_EN       //[6] UART Break timeout detection enable bit

#define URT0_TMOUT_RXTMO_EN                         URT0->TMOUT.MBIT.RXTMO_EN       //[5] UART RX timeout enable bit for shadow buffer data loading into URTx_RDAT
#define URT1_TMOUT_RXTMO_EN                         URT1->TMOUT.MBIT.RXTMO_EN       //[5] UART RX timeout enable bit for shadow buffer data loading into URTx_RDAT
#define URT2_TMOUT_RXTMO_EN                         URT2->TMOUT.MBIT.RXTMO_EN       //[5] UART RX timeout enable bit for shadow buffer data loading into URTx_RDAT
#define URT3_TMOUT_RXTMO_EN                         URT3->TMOUT.MBIT.RXTMO_EN       //[5] UART RX timeout enable bit for shadow buffer data loading into URTx_RDAT

#define URT0_TMOUT_IDTMO_EN                         URT0->TMOUT.MBIT.IDTMO_EN       //[4] UART Idle timeout detection enable bit
#define URT1_TMOUT_IDTMO_EN                         URT1->TMOUT.MBIT.IDTMO_EN       //[4] UART Idle timeout detection enable bit
#define URT2_TMOUT_IDTMO_EN                         URT2->TMOUT.MBIT.IDTMO_EN       //[4] UART Idle timeout detection enable bit
#define URT3_TMOUT_IDTMO_EN                         URT3->TMOUT.MBIT.IDTMO_EN       //[4] UART Idle timeout detection enable bit

#define URT0_TMOUT_TMO_MDS                          URT0->TMOUT.MBIT.TMO_MDS        //[3..2] UART timeout timer mode select
#define URT1_TMOUT_TMO_MDS                          URT1->TMOUT.MBIT.TMO_MDS        //[3..2] UART timeout timer mode select
#define URT2_TMOUT_TMO_MDS                          URT2->TMOUT.MBIT.TMO_MDS        //[3..2] UART timeout timer mode select
#define URT3_TMOUT_TMO_MDS                          URT3->TMOUT.MBIT.TMO_MDS        //[3..2] UART timeout timer mode select

#define URT0_TMOUT_TMO_RST                          URT0->TMOUT.MBIT.TMO_RST        //[1] UART timeout timer force reset enable. (set by software and clear by hardware)
#define URT1_TMOUT_TMO_RST                          URT1->TMOUT.MBIT.TMO_RST        //[1] UART timeout timer force reset enable. (set by software and clear by hardware)
#define URT2_TMOUT_TMO_RST                          URT2->TMOUT.MBIT.TMO_RST        //[1] UART timeout timer force reset enable. (set by software and clear by hardware)
#define URT3_TMOUT_TMO_RST                          URT3->TMOUT.MBIT.TMO_RST        //[1] UART timeout timer force reset enable. (set by software and clear by hardware)

#define URT0_TMOUT_TMO_EN                           URT0->TMOUT.MBIT.TMO_EN         //[0] UART timeout timer enable.
#define URT1_TMOUT_TMO_EN                           URT1->TMOUT.MBIT.TMO_EN         //[0] UART timeout timer enable.
#define URT2_TMOUT_TMO_EN                           URT2->TMOUT.MBIT.TMO_EN         //[0] UART timeout timer enable.
#define URT3_TMOUT_TMO_EN                           URT3->TMOUT.MBIT.TMO_EN         //[0] UART timeout timer enable.

///@}
/**
 ******************************************************************************
 * @name        URT_TMOUT2  [register's definitions]
 *              Offset[0x44]  URT timeout control register 2
 ******************************************************************************
 */
///@{
#define URT0_TMOUT2                                 URT0->TMOUT2.W                  /*!< Offset[0x44]  URT0 timeout control register 2 (0x52000044) */
#define URT1_TMOUT2                                 URT1->TMOUT2.W                  /*!< Offset[0x44]  URT1 timeout control register 2 (0x52010044) */
#define URT2_TMOUT2                                 URT2->TMOUT2.W                  /*!< Offset[0x44]  URT2 timeout control register 2 (0x52020044) */
#define URT3_TMOUT2                                 URT3->TMOUT2.W                  /*!< Offset[0x44]  URT3 timeout control register 2 (0x52030044) */

/* Bit fields of URT_TMOUT2 */
#define URT0_TMOUT2_TMO_CNT                         URT0->TMOUT2.MBIT.TMO_CNT       //[31..16] UART timeout counter value.
#define URT1_TMOUT2_TMO_CNT                         URT1->TMOUT2.MBIT.TMO_CNT       //[31..16] UART timeout counter value.
#define URT2_TMOUT2_TMO_CNT                         URT2->TMOUT2.MBIT.TMO_CNT       //[31..16] UART timeout counter value.
#define URT3_TMOUT2_TMO_CNT                         URT3->TMOUT2.MBIT.TMO_CNT       //[31..16] UART timeout counter value.

#define URT0_TMOUT2_IDTMO_TH                        URT0->TMOUT2.MBIT.IDTMO_TH      //[15..0] UART receive idle timeout detect threshold value by using receive bit time
#define URT1_TMOUT2_IDTMO_TH                        URT1->TMOUT2.MBIT.IDTMO_TH      //[15..0] UART receive idle timeout detect threshold value by using receive bit time
#define URT2_TMOUT2_IDTMO_TH                        URT2->TMOUT2.MBIT.IDTMO_TH      //[15..0] UART receive idle timeout detect threshold value by using receive bit time
#define URT3_TMOUT2_IDTMO_TH                        URT3->TMOUT2.MBIT.IDTMO_TH      //[15..0] UART receive idle timeout detect threshold value by using receive bit time

///@}
/**
 ******************************************************************************
 * @name        URT_SC  [register's definitions]
 *              Offset[0x48]  URT SmartCard control register
 ******************************************************************************
 */
///@{
#define URT0_SC                                     URT0->SC.W                      /*!< Offset[0x48]  URT0 SmartCard control register (0x52000048) */
#define URT1_SC                                     URT1->SC.W                      /*!< Offset[0x48]  URT1 SmartCard control register (0x52010048) */
#define URT2_SC                                     URT2->SC.W                      /*!< Offset[0x48]  URT2 SmartCard control register (0x52020048) */
#define URT3_SC                                     URT3->SC.W                      /*!< Offset[0x48]  URT3 SmartCard control register (0x52030048) */

/* Bit fields of URT_SC */
#define URT0_SC_RXE_NUM                             URT0->SC.MBIT.RXE_NUM           //[14..12] UART RX parity error detect and NACK transmission retry maximum number
#define URT1_SC_RXE_NUM                             URT1->SC.MBIT.RXE_NUM           //[14..12] UART RX parity error detect and NACK transmission retry maximum number
#define URT2_SC_RXE_NUM                             URT2->SC.MBIT.RXE_NUM           //[14..12] UART RX parity error detect and NACK transmission retry maximum number
#define URT3_SC_RXE_NUM                             URT3->SC.MBIT.RXE_NUM           //[14..12] UART RX parity error detect and NACK transmission retry maximum number

#define URT0_SC_TXE_NUM                             URT0->SC.MBIT.TXE_NUM           //[10..8] UART TX error detect and data resend maximum number
#define URT1_SC_TXE_NUM                             URT1->SC.MBIT.TXE_NUM           //[10..8] UART TX error detect and data resend maximum number
#define URT2_SC_TXE_NUM                             URT2->SC.MBIT.TXE_NUM           //[10..8] UART TX error detect and data resend maximum number
#define URT3_SC_TXE_NUM                             URT3->SC.MBIT.TXE_NUM           //[10..8] UART TX error detect and data resend maximum number

#define URT0_SC_RXE_LEN                             URT0->SC.MBIT.RXE_LEN           //[4] UART RX parity error detect and NACK transmission 
#define URT1_SC_RXE_LEN                             URT1->SC.MBIT.RXE_LEN           //[4] UART RX parity error detect and NACK transmission 
#define URT2_SC_RXE_LEN                             URT2->SC.MBIT.RXE_LEN           //[4] UART RX parity error detect and NACK transmission 
#define URT3_SC_RXE_LEN                             URT3->SC.MBIT.RXE_LEN           //[4] UART RX parity error detect and NACK transmission 

#define URT0_SC_TXE_MDS                             URT0->SC.MBIT.TXE_MDS           //[3..2] UART TX error detect mode select
#define URT1_SC_TXE_MDS                             URT1->SC.MBIT.TXE_MDS           //[3..2] UART TX error detect mode select
#define URT2_SC_TXE_MDS                             URT2->SC.MBIT.TXE_MDS           //[3..2] UART TX error detect mode select
#define URT3_SC_TXE_MDS                             URT3->SC.MBIT.TXE_MDS           //[3..2] UART TX error detect mode select

#define URT0_SC_RXE_MDS                             URT0->SC.MBIT.RXE_MDS           //[1..0] UART RX parity error detect control mode select
#define URT1_SC_RXE_MDS                             URT1->SC.MBIT.RXE_MDS           //[1..0] UART RX parity error detect control mode select
#define URT2_SC_RXE_MDS                             URT2->SC.MBIT.RXE_MDS           //[1..0] UART RX parity error detect control mode select
#define URT3_SC_RXE_MDS                             URT3->SC.MBIT.RXE_MDS           //[1..0] UART RX parity error detect control mode select

///@}
/**
 ******************************************************************************
 * @name        URT_SADR  [register's definitions]
 *              Offset[0x4C]  URT slave address detect register
 ******************************************************************************
 */
///@{
#define URT0_SADR                                   URT0->SADR.W                    /*!< Offset[0x4C]  URT0 slave address detect register (0x5200004C) */
#define URT1_SADR                                   URT1->SADR.W                    /*!< Offset[0x4C]  URT1 slave address detect register (0x5201004C) */
#define URT2_SADR                                   URT2->SADR.W                    /*!< Offset[0x4C]  URT2 slave address detect register (0x5202004C) */
#define URT3_SADR                                   URT3->SADR.W                    /*!< Offset[0x4C]  URT3 slave address detect register (0x5203004C) */

/* Bit fields of URT_SADR */
#define URT0_SADR_SA_MSK                            URT0->SADR.MBIT.SA_MSK          //[15..8] UART multi-processor slave address mask register
#define URT1_SADR_SA_MSK                            URT1->SADR.MBIT.SA_MSK          //[15..8] UART multi-processor slave address mask register
#define URT2_SADR_SA_MSK                            URT2->SADR.MBIT.SA_MSK          //[15..8] UART multi-processor slave address mask register
#define URT3_SADR_SA_MSK                            URT3->SADR.MBIT.SA_MSK          //[15..8] UART multi-processor slave address mask register

#define URT0_SADR_SA_RX                             URT0->SADR.MBIT.SA_RX           //[7..0] UART multi-processor mode received slave address
#define URT1_SADR_SA_RX                             URT1->SADR.MBIT.SA_RX           //[7..0] UART multi-processor mode received slave address
#define URT2_SADR_SA_RX                             URT2->SADR.MBIT.SA_RX           //[7..0] UART multi-processor mode received slave address
#define URT3_SADR_SA_RX                             URT3->SADR.MBIT.SA_RX           //[7..0] UART multi-processor mode received slave address

///@}
/**
 ******************************************************************************
 * @name        URT_CAL  [register's definitions]
 *              Offset[0x50]  URT calibration control register
 ******************************************************************************
 */
///@{
#define URT0_CAL                                    URT0->CAL.W                     /*!< Offset[0x50]  URT0 calibration control register (0x52000050) */
#define URT1_CAL                                    URT1->CAL.W                     /*!< Offset[0x50]  URT1 calibration control register (0x52010050) */
#define URT2_CAL                                    URT2->CAL.W                     /*!< Offset[0x50]  URT2 calibration control register (0x52020050) */
#define URT3_CAL                                    URT3->CAL.W                     /*!< Offset[0x50]  URT3 calibration control register (0x52030050) */

/* Bit fields of URT_CAL */
#define URT0_CAL_CALC_HE                            URT0->CAL.MBIT.CALC_HE          //[7] UART auto baud-rate calibration complete data receive hold enable
#define URT1_CAL_CALC_HE                            URT1->CAL.MBIT.CALC_HE          //[7] UART auto baud-rate calibration complete data receive hold enable
#define URT2_CAL_CALC_HE                            URT2->CAL.MBIT.CALC_HE          //[7] UART auto baud-rate calibration complete data receive hold enable
#define URT3_CAL_CALC_HE                            URT3->CAL.MBIT.CALC_HE          //[7] UART auto baud-rate calibration complete data receive hold enable

#define URT0_CAL_CAL_MDS                            URT0->CAL.MBIT.CAL_MDS          //[3..2] UART auto baud-rate calibration mode select.
#define URT1_CAL_CAL_MDS                            URT1->CAL.MBIT.CAL_MDS          //[3..2] UART auto baud-rate calibration mode select.
#define URT2_CAL_CAL_MDS                            URT2->CAL.MBIT.CAL_MDS          //[3..2] UART auto baud-rate calibration mode select.
#define URT3_CAL_CAL_MDS                            URT3->CAL.MBIT.CAL_MDS          //[3..2] UART auto baud-rate calibration mode select.

#define URT0_CAL_CAL_AUTO                           URT0->CAL.MBIT.CAL_AUTO         //[1] UART Break detection and auto baud-rate calibration enable
#define URT1_CAL_CAL_AUTO                           URT1->CAL.MBIT.CAL_AUTO         //[1] UART Break detection and auto baud-rate calibration enable
#define URT2_CAL_CAL_AUTO                           URT2->CAL.MBIT.CAL_AUTO         //[1] UART Break detection and auto baud-rate calibration enable
#define URT3_CAL_CAL_AUTO                           URT3->CAL.MBIT.CAL_AUTO         //[1] UART Break detection and auto baud-rate calibration enable

#define URT0_CAL_CAL_EN                             URT0->CAL.MBIT.CAL_EN           //[0] UART baud-rate calibration enable
#define URT1_CAL_CAL_EN                             URT1->CAL.MBIT.CAL_EN           //[0] UART baud-rate calibration enable
#define URT2_CAL_CAL_EN                             URT2->CAL.MBIT.CAL_EN           //[0] UART baud-rate calibration enable
#define URT3_CAL_CAL_EN                             URT3->CAL.MBIT.CAL_EN           //[0] UART baud-rate calibration enable

///@}
/**
 ******************************************************************************
 * @name        URT_IRDA  [register's definitions]
 *              Offset[0x54]  URT IrDA control register
 ******************************************************************************
 */
///@{
#define URT0_IRDA                                   URT0->IRDA.W                    /*!< Offset[0x54]  URT0 IrDA control register (0x52000054) */
#define URT1_IRDA                                   URT1->IRDA.W                    /*!< Offset[0x54]  URT1 IrDA control register (0x52010054) */
#define URT2_IRDA                                   URT2->IRDA.W                    /*!< Offset[0x54]  URT2 IrDA control register (0x52020054) */
#define URT3_IRDA                                   URT3->IRDA.W                    /*!< Offset[0x54]  URT3 IrDA control register (0x52030054) */

/* Bit fields of URT_IRDA */
#define URT0_IRDA_IR_PW                             URT0->IRDA.MBIT.IR_PW           //[11..8] UART IrDA output pulse width select
#define URT1_IRDA_IR_PW                             URT1->IRDA.MBIT.IR_PW           //[11..8] UART IrDA output pulse width select
#define URT2_IRDA_IR_PW                             URT2->IRDA.MBIT.IR_PW           //[11..8] UART IrDA output pulse width select
#define URT3_IRDA_IR_PW                             URT3->IRDA.MBIT.IR_PW           //[11..8] UART IrDA output pulse width select

#define URT0_IRDA_IR_EN                             URT0->IRDA.MBIT.IR_EN           //[0] UART IrDA data format enable
#define URT1_IRDA_IR_EN                             URT1->IRDA.MBIT.IR_EN           //[0] UART IrDA data format enable
#define URT2_IRDA_IR_EN                             URT2->IRDA.MBIT.IR_EN           //[0] UART IrDA data format enable
#define URT3_IRDA_IR_EN                             URT3->IRDA.MBIT.IR_EN           //[0] UART IrDA data format enable

///@}
/**
 ******************************************************************************
 * @name        URT_HFC  [register's definitions]
 *              Offset[0x58]  URT hardware flow control register
 ******************************************************************************
 */
///@{
#define URT0_HFC                                    URT0->HFC.W                     /*!< Offset[0x58]  URT0 hardware flow control register (0x52000058) */
#define URT1_HFC                                    URT1->HFC.W                     /*!< Offset[0x58]  URT1 hardware flow control register (0x52010058) */
#define URT2_HFC                                    URT2->HFC.W                     /*!< Offset[0x58]  URT2 hardware flow control register (0x52020058) */
#define URT3_HFC                                    URT3->HFC.W                     /*!< Offset[0x58]  URT3 hardware flow control register (0x52030058) */

/* Bit fields of URT_HFC */
#define URT0_HFC_RTS_OUT                            URT0->HFC.MBIT.RTS_OUT          //[4] URTx_RTS output control data bit. This bit is no effect when URTx_RTS_EN is set.
#define URT1_HFC_RTS_OUT                            URT1->HFC.MBIT.RTS_OUT          //[4] URTx_RTS output control data bit. This bit is no effect when URTx_RTS_EN is set.
#define URT2_HFC_RTS_OUT                            URT2->HFC.MBIT.RTS_OUT          //[4] URTx_RTS output control data bit. This bit is no effect when URTx_RTS_EN is set.
#define URT3_HFC_RTS_OUT                            URT3->HFC.MBIT.RTS_OUT          //[4] URTx_RTS output control data bit. This bit is no effect when URTx_RTS_EN is set.

#define URT0_HFC_RTS_INV                            URT0->HFC.MBIT.RTS_INV          //[3] URTx_RTS output inverse enable
#define URT1_HFC_RTS_INV                            URT1->HFC.MBIT.RTS_INV          //[3] URTx_RTS output inverse enable
#define URT2_HFC_RTS_INV                            URT2->HFC.MBIT.RTS_INV          //[3] URTx_RTS output inverse enable
#define URT3_HFC_RTS_INV                            URT3->HFC.MBIT.RTS_INV          //[3] URTx_RTS output inverse enable

#define URT0_HFC_CTS_INV                            URT0->HFC.MBIT.CTS_INV          //[2] URTx_CTS input inverse enable.
#define URT1_HFC_CTS_INV                            URT1->HFC.MBIT.CTS_INV          //[2] URTx_CTS input inverse enable.
#define URT2_HFC_CTS_INV                            URT2->HFC.MBIT.CTS_INV          //[2] URTx_CTS input inverse enable.
#define URT3_HFC_CTS_INV                            URT3->HFC.MBIT.CTS_INV          //[2] URTx_CTS input inverse enable.

#define URT0_HFC_RTS_EN                             URT0->HFC.MBIT.RTS_EN           //[1] UART RTS hardware flow control enable
#define URT1_HFC_RTS_EN                             URT1->HFC.MBIT.RTS_EN           //[1] UART RTS hardware flow control enable
#define URT2_HFC_RTS_EN                             URT2->HFC.MBIT.RTS_EN           //[1] UART RTS hardware flow control enable
#define URT3_HFC_RTS_EN                             URT3->HFC.MBIT.RTS_EN           //[1] UART RTS hardware flow control enable

#define URT0_HFC_CTS_EN                             URT0->HFC.MBIT.CTS_EN           //[0] UART CTS hardware flow control enable
#define URT1_HFC_CTS_EN                             URT1->HFC.MBIT.CTS_EN           //[0] UART CTS hardware flow control enable
#define URT2_HFC_CTS_EN                             URT2->HFC.MBIT.CTS_EN           //[0] UART CTS hardware flow control enable
#define URT3_HFC_CTS_EN                             URT3->HFC.MBIT.CTS_EN           //[0] UART CTS hardware flow control enable

///@}
/**
 ******************************************************************************
 * @name        URT_MUTE  [register's definitions]
 *              Offset[0x5C]  URT mute control register
 ******************************************************************************
 */
///@{
#define URT0_MUTE                                   URT0->MUTE.W                    /*!< Offset[0x5C]  URT0 mute control register (0x5200005C) */
#define URT1_MUTE                                   URT1->MUTE.W                    /*!< Offset[0x5C]  URT1 mute control register (0x5201005C) */
#define URT2_MUTE                                   URT2->MUTE.W                    /*!< Offset[0x5C]  URT2 mute control register (0x5202005C) */
#define URT3_MUTE                                   URT3->MUTE.W                    /*!< Offset[0x5C]  URT3 mute control register (0x5203005C) */

/* Bit fields of URT_MUTE */
#define URT0_MUTE_MUTE_AEX2                         URT0->MUTE.MBIT.MUTE_AEX2       //[18] UART auto exit mute mode and receive data by  idle line detection enable bit
#define URT1_MUTE_MUTE_AEX2                         URT1->MUTE.MBIT.MUTE_AEX2       //[18] UART auto exit mute mode and receive data by  idle line detection enable bit
#define URT2_MUTE_MUTE_AEX2                         URT2->MUTE.MBIT.MUTE_AEX2       //[18] UART auto exit mute mode and receive data by  idle line detection enable bit
#define URT3_MUTE_MUTE_AEX2                         URT3->MUTE.MBIT.MUTE_AEX2       //[18] UART auto exit mute mode and receive data by  idle line detection enable bit

#define URT0_MUTE_MUTE_AEX1                         URT0->MUTE.MBIT.MUTE_AEX1       //[17] UART auto exit mute mode and receive data by Break condition detection enable bit
#define URT1_MUTE_MUTE_AEX1                         URT1->MUTE.MBIT.MUTE_AEX1       //[17] UART auto exit mute mode and receive data by Break condition detection enable bit
#define URT2_MUTE_MUTE_AEX1                         URT2->MUTE.MBIT.MUTE_AEX1       //[17] UART auto exit mute mode and receive data by Break condition detection enable bit
#define URT3_MUTE_MUTE_AEX1                         URT3->MUTE.MBIT.MUTE_AEX1       //[17] UART auto exit mute mode and receive data by Break condition detection enable bit

#define URT0_MUTE_MUTE_AEX0                         URT0->MUTE.MBIT.MUTE_AEX0       //[16] UART auto exit mute mode and receive data by multi-processor slave address matched co
#define URT1_MUTE_MUTE_AEX0                         URT1->MUTE.MBIT.MUTE_AEX0       //[16] UART auto exit mute mode and receive data by multi-processor slave address matched co
#define URT2_MUTE_MUTE_AEX0                         URT2->MUTE.MBIT.MUTE_AEX0       //[16] UART auto exit mute mode and receive data by multi-processor slave address matched co
#define URT3_MUTE_MUTE_AEX0                         URT3->MUTE.MBIT.MUTE_AEX0       //[16] UART auto exit mute mode and receive data by multi-processor slave address matched co

#define URT0_MUTE_MUTE_AEN1                         URT0->MUTE.MBIT.MUTE_AEN1       //[9] UART mute mode auto enter by idle line detection enable bit
#define URT1_MUTE_MUTE_AEN1                         URT1->MUTE.MBIT.MUTE_AEN1       //[9] UART mute mode auto enter by idle line detection enable bit
#define URT2_MUTE_MUTE_AEN1                         URT2->MUTE.MBIT.MUTE_AEN1       //[9] UART mute mode auto enter by idle line detection enable bit
#define URT3_MUTE_MUTE_AEN1                         URT3->MUTE.MBIT.MUTE_AEN1       //[9] UART mute mode auto enter by idle line detection enable bit

#define URT0_MUTE_MUTE_AEN0                         URT0->MUTE.MBIT.MUTE_AEN0       //[8] UART mute mode auto enter by multi-processor slave address unmatched condition enable
#define URT1_MUTE_MUTE_AEN0                         URT1->MUTE.MBIT.MUTE_AEN0       //[8] UART mute mode auto enter by multi-processor slave address unmatched condition enable
#define URT2_MUTE_MUTE_AEN0                         URT2->MUTE.MBIT.MUTE_AEN0       //[8] UART mute mode auto enter by multi-processor slave address unmatched condition enable
#define URT3_MUTE_MUTE_AEN0                         URT3->MUTE.MBIT.MUTE_AEN0       //[8] UART mute mode auto enter by multi-processor slave address unmatched condition enable

#define URT0_MUTE_MUTE_EN                           URT0->MUTE.MBIT.MUTE_EN         //[0] UART mute mode enable
#define URT1_MUTE_MUTE_EN                           URT1->MUTE.MBIT.MUTE_EN         //[0] UART mute mode enable
#define URT2_MUTE_MUTE_EN                           URT2->MUTE.MBIT.MUTE_EN         //[0] UART mute mode enable
#define URT3_MUTE_MUTE_EN                           URT3->MUTE.MBIT.MUTE_EN         //[0] UART mute mode enable

///@}

/*----------------------------------------------------------------------------*/
/* @module      SPI (SPI Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        SPI_STA  [register's definitions]
 *              Offset[0x00]  SPI status register
 ******************************************************************************
 */
///@{
#define SPI0_STA                                    SPI0->STA.W                     /*!< Offset[0x00]  SPI0 status register (0x53000000) */

/* Bit fields of SPI_STA */
#define SPI0_STA_RNUM                               SPI0->STA.MBIT.RNUM             //[26..24] SPI received data byte number when data shadow buffer last transfer to SPI0_RDAT regi

#define SPI0_STA_TX_LVL                             SPI0->STA.MBIT.TX_LVL           //[22..20] SPI data buffer transmission remained level indications.

#define SPI0_STA_RX_LVL                             SPI0->STA.MBIT.RX_LVL           //[18..16] SPI data buffer received level indications.

#define SPI0_STA_TUDRF                              SPI0->STA.MBIT.TUDRF            //[11] SPI slave mode transmit underrun flag

#define SPI0_STA_ROVRF                              SPI0->STA.MBIT.ROVRF            //[10] SPI receive overrun flag

#define SPI0_STA_WEF                                SPI0->STA.MBIT.WEF              //[9] SPI slave mode write error flag

#define SPI0_STA_MODF                               SPI0->STA.MBIT.MODF             //[8] SPI mode detect fault flag. (set by hardware and clear by software writing 1)

#define SPI0_STA_TXF                                SPI0->STA.MBIT.TXF              //[7] SPI transmit data register empty flag 

#define SPI0_STA_RXF                                SPI0->STA.MBIT.RXF              //[6] SPI receive data register not empty

#define SPI0_STA_RXDF                               SPI0->STA.MBIT.RXDF             //[5] SPI received data byte number is different from previous received data byte number fo

#define SPI0_STA_TCF                                SPI0->STA.MBIT.TCF              //[4] SPI transmission complete flag

#define SPI0_STA_IDLF                               SPI0->STA.MBIT.IDLF             //[3] SPI slave mode NSS idle detect flag

#define SPI0_STA_BUSYF                              SPI0->STA.MBIT.BUSYF            //[0] SPI data transfer busy flag.

///@}
/**
 ******************************************************************************
 * @name        SPI_INT  [register's definitions]
 *              Offset[0x04]  SPI interrupt enable register
 ******************************************************************************
 */
///@{
#define SPI0_INT                                    SPI0->INT.W                     /*!< Offset[0x04]  SPI0 interrupt enable register (0x53000004) */

/* Bit fields of SPI_INT */
#define SPI0_INT_TUDR_IE                            SPI0->INT.MBIT.TUDR_IE          //[11] SPI TX buffer transmit underrun interrupt enable.

#define SPI0_INT_ROVR_IE                            SPI0->INT.MBIT.ROVR_IE          //[10] SPI RX buffer receive overrun interrupt enable.

#define SPI0_INT_WE_IE                              SPI0->INT.MBIT.WE_IE            //[9] SPI slave mode write error interrupt enable.

#define SPI0_INT_MODF_IE                            SPI0->INT.MBIT.MODF_IE          //[8] SPI mode detect fault interrupt enable.

#define SPI0_INT_TX_IE                              SPI0->INT.MBIT.TX_IE            //[7] SPI TX buffer underflow the threshold SPI0_TX_TH Interrupt enable.

#define SPI0_INT_RX_IE                              SPI0->INT.MBIT.RX_IE            //[6] SPI Receive data register not empty interrupt enable.

#define SPI0_INT_TC_IE                              SPI0->INT.MBIT.TC_IE            //[4] SPI transmission complete interrupt enable

#define SPI0_INT_IDL_IE                             SPI0->INT.MBIT.IDL_IE           //[3] SPI slave mode NSS idle detect interrupt enable

#define SPI0_INT_IEA                                SPI0->INT.MBIT.IEA              //[0] SPI interrupt all enable

///@}
/**
 ******************************************************************************
 * @name        SPI_CLK  [register's definitions]
 *              Offset[0x08]  SPI clock source register
 ******************************************************************************
 */
///@{
#define SPI0_CLK                                    SPI0->CLK.W                     /*!< Offset[0x08]  SPI0 clock source register (0x53000008) */

/* Bit fields of SPI_CLK */
#define SPI0_CLK_CK_PDIV                            SPI0->CLK.MBIT.CK_PDIV          //[13..12] SPI process clock CK_SPI0_PR input divider. 

#define SPI0_CLK_CK_PSC                             SPI0->CLK.MBIT.CK_PSC           //[10..8] SPI internal clock CK_SPI0_INT prescaler

#define SPI0_CLK_CK_DIV                             SPI0->CLK.MBIT.CK_DIV           //[5..4] SPI internal clock CK_SPI0_INT input divider.

#define SPI0_CLK_CK_SEL                             SPI0->CLK.MBIT.CK_SEL           //[3..2] SPI internal clock CK_SPI0 source select.

///@}
/**
 ******************************************************************************
 * @name        SPI_CR0  [register's definitions]
 *              Offset[0x10]  SPI control register 0
 ******************************************************************************
 */
///@{
#define SPI0_CR0                                    SPI0->CR0.W                     /*!< Offset[0x10]  SPI0 control register 0 (0x53000010) */

/* Bit fields of SPI_CR0 */
#define SPI0_CR0_DMA_TXEN                           SPI0->CR0.MBIT.DMA_TXEN         //[31] Direct memory access enable to transmit

#define SPI0_CR0_DMA_RXEN                           SPI0->CR0.MBIT.DMA_RXEN         //[30] Direct memory access enable to receive

#define SPI0_CR0_LBM_EN                             SPI0->CR0.MBIT.LBM_EN           //[19] Loop back mode enable bit

#define SPI0_CR0_MODF_SEL                           SPI0->CR0.MBIT.MODF_SEL         //[15] SPI function select when master mode fault detect.

#define SPI0_CR0_NSS_PEN                            SPI0->CR0.MBIT.NSS_PEN          //[14] SPI single master mode NSS pulse enable

#define SPI0_CR0_NSSI_INV                           SPI0->CR0.MBIT.NSSI_INV         //[13] SPI NSS input signal inverse enable.

#define SPI0_CR0_NSSO_INV                           SPI0->CR0.MBIT.NSSO_INV         //[12] SPI NSS output signal inverse enable

#define SPI0_CR0_NSS_SWEN                           SPI0->CR0.MBIT.NSS_SWEN         //[11] SPI NSS signal input/output use software control bit enable

#define SPI0_CR0_NSSI_SEL                           SPI0->CR0.MBIT.NSSI_SEL         //[10] SPI pin select for NSS input signal

#define SPI0_CR0_NSSI_EN                            SPI0->CR0.MBIT.NSSI_EN          //[9] SPI_NSS signal input function enable

#define SPI0_CR0_NSSO_EN                            SPI0->CR0.MBIT.NSSO_EN          //[8] SPI_NSS signal output function enable.

#define SPI0_CR0_IO_SWP                             SPI0->CR0.MBIT.IO_SWP           //[7] SPI I/O SPI_MOSI,SPI_MISO signals swap enable.

#define SPI0_CR0_MDS                                SPI0->CR0.MBIT.MDS              //[5..4] SPI operation mode select.

#define SPI0_CR0_LSB_EN                             SPI0->CR0.MBIT.LSB_EN           //[3] SPI data order Lsb first enable. When disables , the Msb bit will be the first bit.

#define SPI0_CR0_CPHA                               SPI0->CR0.MBIT.CPHA             //[2] SPI clock phase select

#define SPI0_CR0_CPOL                               SPI0->CR0.MBIT.CPOL             //[1] SPI clock polarity select. It is used to select the SPI clock level in idle state.

#define SPI0_CR0_EN                                 SPI0->CR0.MBIT.EN               //[0] SPI function enable bit.

///@}
/**
 ******************************************************************************
 * @name        SPI_CR1  [register's definitions]
 *              Offset[0x14]  SPI control register 1
 ******************************************************************************
 */
///@{
#define SPI0_CR1                                    SPI0->CR1.W                     /*!< Offset[0x14]  SPI0 control register 1 (0x53000014) */

/* Bit fields of SPI_CR1 */
#define SPI0_CR1_TDAT_CLR                           SPI0->CR1.MBIT.TDAT_CLR         //[1] SPI transmitted data clear enable

#define SPI0_CR1_RDAT_CLR                           SPI0->CR1.MBIT.RDAT_CLR         //[0] SPI received data clear enable

///@}
/**
 ******************************************************************************
 * @name        SPI_CR2  [register's definitions]
 *              Offset[0x18]  SPI control register 2
 ******************************************************************************
 */
///@{
#define SPI0_CR2                                    SPI0->CR2.W                     /*!< Offset[0x18]  SPI0 control register 2 (0x53000018) */

/* Bit fields of SPI_CR2 */
#define SPI0_CR2_CKO_MUX                            SPI0->CR2.MBIT.CKO_MUX          //[30..28] SPI0_CLK output signal select.

#define SPI0_CR2_NSS_SWI                            SPI0->CR2.MBIT.NSS_SWI          //[25] SPI NSS signal input control and status bit

#define SPI0_CR2_NSS_SWO                            SPI0->CR2.MBIT.NSS_SWO          //[24] SPI NSS signal software output control bit when SPI0_NSS_SWEN is enable

#define SPI0_CR2_DSIZE                              SPI0->CR2.MBIT.DSIZE            //[20..16] SPI transfer data frame bit size from 4-bit to 32-bit

#define SPI0_CR2_RX_TH                              SPI0->CR2.MBIT.RX_TH            //[9..8] SPI received data buffer high threshold for slave mode

#define SPI0_CR2_TX_DIS                             SPI0->CR2.MBIT.TX_DIS           //[7] SPI data line output disable

#define SPI0_CR2_DAT_LINE                           SPI0->CR2.MBIT.DAT_LINE         //[6..4] SPI0 data line number select

#define SPI0_CR2_COPY_EN                            SPI0->CR2.MBIT.COPY_EN          //[3] SPI data transfer copy mode enable

#define SPI0_CR2_BDIR_OE                            SPI0->CR2.MBIT.BDIR_OE          //[2] SPI data line Bidirectional output enable

///@}
/**
 ******************************************************************************
 * @name        SPI_RDAT  [register's definitions]
 *              Offset[0x30]  SPI data receive register
 ******************************************************************************
 */
///@{
#define SPI0_RDAT                                   SPI0->RDAT.W                    /*!< Offset[0x30]  SPI0 data receive register (0x53000030) */

/* Bit fields of SPI_RDAT */
#define SPI0_RDAT_RDAT                              SPI0->RDAT.MBIT.RDAT            //[31..0] SPI received data register

///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT  [register's definitions]
 *              Offset[0x34]  SPI data transmit register
 ******************************************************************************
 */
///@{
#define SPI0_TDAT                                   SPI0->TDAT.W                    /*!< Offset[0x34]  SPI0 data transmit register (0x53000034) */

/* Bit fields of SPI_TDAT */
#define SPI0_TDAT_TDAT                              SPI0->TDAT.MBIT.TDAT            //[31..0] SPI transmitted data register

///@}
/**
 ******************************************************************************
 * @name        SPI_TDAT3  [register's definitions]
 *              Offset[0x38]  SPI TX data 3-byte register
 ******************************************************************************
 */
///@{
#define SPI0_TDAT3                                  SPI0->TDAT3.W                   /*!< Offset[0x38]  SPI0 TX data 3-byte register (0x53000038) */

/* Bit fields of SPI_TDAT3 */
#define SPI0_TDAT3_TDAT3                            SPI0->TDAT3.MBIT.TDAT3          //[23..0] SPI transmitted data register for 3-byte data write only

///@}

/*----------------------------------------------------------------------------*/
/* @module      TM (Timer36 Control)                                          */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        TM_STA  [register's definitions]
 *              Offset[0x00]  TM Timer status register
 ******************************************************************************
 */
///@{
#define TM00_STA                                    TM00->STA.W                     /*!< Offset[0x00]  TM00 Timer status register (0x55000000) */
#define TM01_STA                                    TM01->STA.W                     /*!< Offset[0x00]  TM01 Timer status register (0x55010000) */
#define TM10_STA                                    TM10->STA.W                     /*!< Offset[0x00]  TM10 Timer status register (0x55800000) */
#define TM16_STA                                    TM16->STA.W                     /*!< Offset[0x00]  TM16 Timer status register (0x55860000) */
#define TM20_STA                                    TM20->STA.W                     /*!< Offset[0x00]  TM20 Timer status register (0x56000000) */
#define TM26_STA                                    TM26->STA.W                     /*!< Offset[0x00]  TM26 Timer status register (0x56060000) */
#define TM36_STA                                    TM36->STA.W                     /*!< Offset[0x00]  TM36 Timer status register (0x56860000) */

/* Bit fields of TM_STA */
#define TM26_STA_QPEF                               TM26->STA.MBIT.QPEF             //[19] Main Timer QEI phase state transition error detect flag.
#define TM36_STA_QPEF                               TM36->STA.MBIT.QPEF             //[19] Main Timer QEI phase state transition error detect flag.

#define TM26_STA_IDXF                               TM26->STA.MBIT.IDXF             //[18] Main Timer QEI external index signal input active detect and internal timer reset fla
#define TM36_STA_IDXF                               TM36->STA.MBIT.IDXF             //[18] Main Timer QEI external index signal input active detect and internal timer reset fla

#define TM26_STA_DIRCF                              TM26->STA.MBIT.DIRCF            //[16] Main Timer up/down counting direction change flag.
#define TM36_STA_DIRCF                              TM36->STA.MBIT.DIRCF            //[16] Main Timer up/down counting direction change flag.

#define TM36_STA_CF3B                               TM36->STA.MBIT.CF3B             //[15] Timer IC3 falling edge flag/OC3 event sub flag

#define TM36_STA_CF2B                               TM36->STA.MBIT.CF2B             //[14] Timer IC2 falling edge flag/OC2 event sub flag

#define TM20_STA_CF1B                               TM20->STA.MBIT.CF1B             //[13] Timer IC1 falling edge flag/OC1 event sub flag
#define TM26_STA_CF1B                               TM26->STA.MBIT.CF1B             //[13] Timer IC1 falling edge flag/OC1 event sub flag
#define TM36_STA_CF1B                               TM36->STA.MBIT.CF1B             //[13] Timer IC1 falling edge flag/OC1 event sub flag

#define TM20_STA_CF0B                               TM20->STA.MBIT.CF0B             //[12] Timer IC0 falling edge flag/OC0 event sub flag
#define TM26_STA_CF0B                               TM26->STA.MBIT.CF0B             //[12] Timer IC0 falling edge flag/OC0 event sub flag
#define TM36_STA_CF0B                               TM36->STA.MBIT.CF0B             //[12] Timer IC0 falling edge flag/OC0 event sub flag

#define TM36_STA_CF3A                               TM36->STA.MBIT.CF3A             //[11] Timer IC3 rising edge flag/OC3 event main flag

#define TM36_STA_CF2A                               TM36->STA.MBIT.CF2A             //[10] Timer IC2 rising edge flag/OC2 event main flag

#define TM20_STA_CF1A                               TM20->STA.MBIT.CF1A             //[9] Timer IC1 rising edge flag/OC1 event main flag
#define TM26_STA_CF1A                               TM26->STA.MBIT.CF1A             //[9] Timer IC1 rising edge flag/OC1 event main flag
#define TM36_STA_CF1A                               TM36->STA.MBIT.CF1A             //[9] Timer IC1 rising edge flag/OC1 event main flag

#define TM20_STA_CF0A                               TM20->STA.MBIT.CF0A             //[8] Timer IC0 rising edge flag/OC0 event main flag
#define TM26_STA_CF0A                               TM26->STA.MBIT.CF0A             //[8] Timer IC0 rising edge flag/OC0 event main flag
#define TM36_STA_CF0A                               TM36->STA.MBIT.CF0A             //[8] Timer IC0 rising edge flag/OC0 event main flag

#define TM00_STA_TUF2                               TM00->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM01_STA_TUF2                               TM01->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM10_STA_TUF2                               TM10->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM16_STA_TUF2                               TM16->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM20_STA_TUF2                               TM20->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM26_STA_TUF2                               TM26->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM36_STA_TUF2                               TM36->STA.MBIT.TUF2             //[7] 2nd Timer underflow flag. (set by hardware and clear by software writing 1)

#define TM00_STA_TUF                                TM00->STA.MBIT.TUF              //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM01_STA_TUF                                TM01->STA.MBIT.TUF              //[6] Main Timer underflow flag.(set by hardware and clear by software writing 1)
#define TM10_STA_TUF                                TM10->STA.MBIT.TUF              //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM16_STA_TUF                                TM16->STA.MBIT.TUF              //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM26_STA_TUF                                TM26->STA.MBIT.TUF              //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)
#define TM36_STA_TUF                                TM36->STA.MBIT.TUF              //[6] Main Timer underflow flag. (set by hardware and clear by software writing 1)

#define TM00_STA_TOF2                               TM00->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM01_STA_TOF2                               TM01->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM10_STA_TOF2                               TM10->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM16_STA_TOF2                               TM16->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM20_STA_TOF2                               TM20->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM26_STA_TOF2                               TM26->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM36_STA_TOF2                               TM36->STA.MBIT.TOF2             //[5] 2nd Timer overflow flag. (set by hardware and clear by software writing 1)

#define TM00_STA_TOF                                TM00->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM01_STA_TOF                                TM01->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM10_STA_TOF                                TM10->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM16_STA_TOF                                TM16->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM20_STA_TOF                                TM20->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM26_STA_TOF                                TM26->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)
#define TM36_STA_TOF                                TM36->STA.MBIT.TOF              //[4] Main Timer overflow flag. (set by hardware and clear by software writing 1)

#define TM00_STA_EXF                                TM00->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM01_STA_EXF                                TM01->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM10_STA_EXF                                TM10->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM16_STA_EXF                                TM16->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM20_STA_EXF                                TM20->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM26_STA_EXF                                TM26->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)
#define TM36_STA_EXF                                TM36->STA.MBIT.EXF              //[3] Timer external trigger flag. (set by hardware and clear by software writing 1)

#define TM36_STA_BKF                                TM36->STA.MBIT.BKF              //[2] Timer break input flag. (set by hardware and clear by software writing 1)

#define TM16_STA_DIRF                               TM16->STA.MBIT.DIRF             //[0] Main Timer up/down counting flag.
#define TM26_STA_DIRF                               TM26->STA.MBIT.DIRF             //[0] Main Timer up/down counting flag.
#define TM36_STA_DIRF                               TM36->STA.MBIT.DIRF             //[0] Main Timer up/down counting flag.

///@}
/**
 ******************************************************************************
 * @name        TM_INT  [register's definitions]
 *              Offset[0x04]  TM Timer interrupt enable register
 ******************************************************************************
 */
///@{
#define TM00_INT                                    TM00->INT.W                     /*!< Offset[0x04]  TM00 Timer interrupt enable register (0x55000004) */
#define TM01_INT                                    TM01->INT.W                     /*!< Offset[0x04]  TM01 Timer interrupt enable register (0x55010004) */
#define TM10_INT                                    TM10->INT.W                     /*!< Offset[0x04]  TM10 Timer interrupt enable register (0x55800004) */
#define TM16_INT                                    TM16->INT.W                     /*!< Offset[0x04]  TM16 Timer interrupt enable register (0x55860004) */
#define TM20_INT                                    TM20->INT.W                     /*!< Offset[0x04]  TM20 Timer interrupt enable register (0x56000004) */
#define TM26_INT                                    TM26->INT.W                     /*!< Offset[0x04]  TM26 Timer interrupt enable register (0x56060004) */
#define TM36_INT                                    TM36->INT.W                     /*!< Offset[0x04]  TM36 Timer interrupt enable register (0x56860004) */

/* Bit fields of TM_INT */
#define TM26_INT_QPE_IE                             TM26->INT.MBIT.QPE_IE           //[19] Main Timer QEI phase state transition error detect interrupt enable.
#define TM36_INT_QPE_IE                             TM36->INT.MBIT.QPE_IE           //[19] Main Timer QEI phase state transition error detect interrupt enable.

#define TM26_INT_IDX_IE                             TM26->INT.MBIT.IDX_IE           //[18] Main Timer QEI external index signal input active detect interrupt enable.
#define TM36_INT_IDX_IE                             TM36->INT.MBIT.IDX_IE           //[18] Main Timer QEI external index signal input active detect interrupt enable.

#define TM26_INT_DIRC_IE                            TM26->INT.MBIT.DIRC_IE          //[16] Main Timer up/down counting direction change interrupt enable.
#define TM36_INT_DIRC_IE                            TM36->INT.MBIT.DIRC_IE          //[16] Main Timer up/down counting direction change interrupt enable.

#define TM36_INT_CC3_IE                             TM36->INT.MBIT.CC3_IE           //[11] Timer IC3/OC3 interrupt enable.

#define TM36_INT_CC2_IE                             TM36->INT.MBIT.CC2_IE           //[10] Timer IC2/OC2 interrupt enable.

#define TM20_INT_CC1_IE                             TM20->INT.MBIT.CC1_IE           //[9] Timer IC1/OC1 interrupt enable.
#define TM26_INT_CC1_IE                             TM26->INT.MBIT.CC1_IE           //[9] Timer IC1/OC1 interrupt enable.
#define TM36_INT_CC1_IE                             TM36->INT.MBIT.CC1_IE           //[9] Timer IC1/OC1 interrupt enable.

#define TM20_INT_CC0_IE                             TM20->INT.MBIT.CC0_IE           //[8] Timer IC0/OC0 interrupt enable.
#define TM26_INT_CC0_IE                             TM26->INT.MBIT.CC0_IE           //[8] Timer IC0/OC0 interrupt enable.
#define TM36_INT_CC0_IE                             TM36->INT.MBIT.CC0_IE           //[8] Timer IC0/OC0 interrupt enable.

#define TM00_INT_TIE2                               TM00->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM01_INT_TIE2                               TM01->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM10_INT_TIE2                               TM10->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM16_INT_TIE2                               TM16->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM20_INT_TIE2                               TM20->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM26_INT_TIE2                               TM26->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.
#define TM36_INT_TIE2                               TM36->INT.MBIT.TIE2             //[5] 2nd Timer overflow/underflow interrupt enable.

#define TM00_INT_TIE                                TM00->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM01_INT_TIE                                TM01->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM10_INT_TIE                                TM10->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM16_INT_TIE                                TM16->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM20_INT_TIE                                TM20->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM26_INT_TIE                                TM26->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.
#define TM36_INT_TIE                                TM36->INT.MBIT.TIE              //[4] Timer overflow/underflow interrupt enable.

#define TM00_INT_EXIE                               TM00->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM01_INT_EXIE                               TM01->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM10_INT_EXIE                               TM10->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM16_INT_EXIE                               TM16->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM20_INT_EXIE                               TM20->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM26_INT_EXIE                               TM26->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.
#define TM36_INT_EXIE                               TM36->INT.MBIT.EXIE             //[3] Timer external trigger interrupt enable.

#define TM36_INT_BKIE                               TM36->INT.MBIT.BKIE             //[2] Timer break input interrupt enable.

#define TM00_INT_IEA                                TM00->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM01_INT_IEA                                TM01->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM10_INT_IEA                                TM10->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM16_INT_IEA                                TM16->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM20_INT_IEA                                TM20->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM26_INT_IEA                                TM26->INT.MBIT.IEA              //[0] Timer interrupt all enable
#define TM36_INT_IEA                                TM36->INT.MBIT.IEA              //[0] Timer interrupt all enable

///@}
/**
 ******************************************************************************
 * @name        TM_CLK  [register's definitions]
 *              Offset[0x08]  TM Timer clock source register
 ******************************************************************************
 */
///@{
#define TM00_CLK                                    TM00->CLK.W                     /*!< Offset[0x08]  TM00 Timer clock source register (0x55000008) */
#define TM01_CLK                                    TM01->CLK.W                     /*!< Offset[0x08]  TM01 Timer clock source register (0x55010008) */
#define TM10_CLK                                    TM10->CLK.W                     /*!< Offset[0x08]  TM10 Timer clock source register (0x55800008) */
#define TM16_CLK                                    TM16->CLK.W                     /*!< Offset[0x08]  TM16 Timer clock source register (0x55860008) */
#define TM20_CLK                                    TM20->CLK.W                     /*!< Offset[0x08]  TM20 Timer clock source register (0x56000008) */
#define TM26_CLK                                    TM26->CLK.W                     /*!< Offset[0x08]  TM26 Timer clock source register (0x56060008) */
#define TM36_CLK                                    TM36->CLK.W                     /*!< Offset[0x08]  TM36 Timer clock source register (0x56860008) */

/* Bit fields of TM_CLK */
#define TM36_CLK_DTG_DIV                            TM36->CLK.MBIT.DTG_DIV          //[17..16] Timer internal dead time clock CK_DTG divider.

#define TM00_CLK_CKI_DIV                            TM00->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM00_INT input divider.
#define TM01_CLK_CKI_DIV                            TM01->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM01_INT input divider.
#define TM10_CLK_CKI_DIV                            TM10->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM10_INT input divider.
#define TM16_CLK_CKI_DIV                            TM16->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM16_INT input divider.
#define TM20_CLK_CKI_DIV                            TM20->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM20_INT input divider.
#define TM26_CLK_CKI_DIV                            TM26->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM26_INT input divider.
#define TM36_CLK_CKI_DIV                            TM36->CLK.MBIT.CKI_DIV          //[13..12] Timer internal clock CK_TM36_INT input divider.

#define TM00_CLK_CKI_SEL                            TM00->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM00_INT source select.
#define TM01_CLK_CKI_SEL                            TM01->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM01_INT source select.
#define TM10_CLK_CKI_SEL                            TM10->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM10 source select.
#define TM16_CLK_CKI_SEL                            TM16->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM16 source select.
#define TM20_CLK_CKI_SEL                            TM20->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM20 source select.
#define TM26_CLK_CKI_SEL                            TM26->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM26 source select.
#define TM36_CLK_CKI_SEL                            TM36->CLK.MBIT.CKI_SEL          //[9..8] Timer input clock CK_TM36 source select.

#define TM00_CLK_CKS2_SEL                           TM00->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM01_CLK_CKS2_SEL                           TM01->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM10_CLK_CKS2_SEL                           TM10->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM16_CLK_CKS2_SEL                           TM16->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM20_CLK_CKS2_SEL                           TM20->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM26_CLK_CKS2_SEL                           TM26->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.
#define TM36_CLK_CKS2_SEL                           TM36->CLK.MBIT.CKS2_SEL         //[7] Counter/Timer CK_TC2 clock source select.

#define TM00_CLK_CKS_SEL                            TM00->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM01_CLK_CKS_SEL                            TM01->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM10_CLK_CKS_SEL                            TM10->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM16_CLK_CKS_SEL                            TM16->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM20_CLK_CKS_SEL                            TM20->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM26_CLK_CKS_SEL                            TM26->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.
#define TM36_CLK_CKS_SEL                            TM36->CLK.MBIT.CKS_SEL          //[6] Counter/Timer CK_TC clock source select.

#define TM00_CLK_CKE_SEL                            TM00->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM01_CLK_CKE_SEL                            TM01->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM10_CLK_CKE_SEL                            TM10->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM16_CLK_CKE_SEL                            TM16->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM20_CLK_CKE_SEL                            TM20->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM26_CLK_CKE_SEL                            TM26->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.
#define TM36_CLK_CKE_SEL                            TM36->CLK.MBIT.CKE_SEL          //[5..4] Timer internal clock CK_EXT source select.

///@}
/**
 ******************************************************************************
 * @name        TM_TRG  [register's definitions]
 *              Offset[0x0C]  TM Timer trigger control register
 ******************************************************************************
 */
///@{
#define TM00_TRG                                    TM00->TRG.W                     /*!< Offset[0x0C]  TM00 Timer trigger control register (0x5500000C) */
#define TM01_TRG                                    TM01->TRG.W                     /*!< Offset[0x0C]  TM01 Timer trigger control register (0x5501000C) */
#define TM10_TRG                                    TM10->TRG.W                     /*!< Offset[0x0C]  TM10 Timer trigger control register (0x5580000C) */
#define TM16_TRG                                    TM16->TRG.W                     /*!< Offset[0x0C]  TM16 Timer trigger control register (0x5586000C) */
#define TM20_TRG                                    TM20->TRG.W                     /*!< Offset[0x0C]  TM20 Timer trigger control register (0x5600000C) */
#define TM26_TRG                                    TM26->TRG.W                     /*!< Offset[0x0C]  TM26 Timer trigger control register (0x5606000C) */
#define TM36_TRG                                    TM36->TRG.W                     /*!< Offset[0x0C]  TM36 Timer trigger control register (0x5686000C) */

/* Bit fields of TM_TRG */
#define TM00_TRG_GT2_SW                             TM00->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM01_TRG_GT2_SW                             TM01->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM10_TRG_GT2_SW                             TM10->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM16_TRG_GT2_SW                             TM16->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM20_TRG_GT2_SW                             TM20->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM26_TRG_GT2_SW                             TM26->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.
#define TM36_TRG_GT2_SW                             TM36->TRG.MBIT.GT2_SW           //[31] 2nd Timer clock gating software enable bit.

#define TM00_TRG_GT_SW                              TM00->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM01_TRG_GT_SW                              TM01->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM10_TRG_GT_SW                              TM10->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM16_TRG_GT_SW                              TM16->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM20_TRG_GT_SW                              TM20->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM26_TRG_GT_SW                              TM26->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.
#define TM36_TRG_GT_SW                              TM36->TRG.MBIT.GT_SW            //[30] Timer clock gating software enable bit.

#define TM00_TRG_RST2_SW                            TM00->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM01_TRG_RST2_SW                            TM01->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM10_TRG_RST2_SW                            TM10->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM16_TRG_RST2_SW                            TM16->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM20_TRG_RST2_SW                            TM20->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM26_TRG_RST2_SW                            TM26->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.
#define TM36_TRG_RST2_SW                            TM36->TRG.MBIT.RST2_SW          //[29] 2nd Timer reset software enable bit.

#define TM00_TRG_RST_SW                             TM00->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM01_TRG_RST_SW                             TM01->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM10_TRG_RST_SW                             TM10->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM16_TRG_RST_SW                             TM16->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM20_TRG_RST_SW                             TM20->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM26_TRG_RST_SW                             TM26->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.
#define TM36_TRG_RST_SW                             TM36->TRG.MBIT.RST_SW           //[28] Timer reset software enable bit.

#define TM00_TRG_TRGO_INV                           TM00->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM01_TRG_TRGO_INV                           TM01->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM10_TRG_TRGO_INV                           TM10->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM16_TRG_TRGO_INV                           TM16->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM20_TRG_TRGO_INV                           TM20->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM26_TRG_TRGO_INV                           TM26->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.
#define TM36_TRG_TRGO_INV                           TM36->TRG.MBIT.TRGO_INV         //[25] Timer TRGO output inverse enable bit.

#define TM00_TRG_TRGO_SW                            TM00->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM01_TRG_TRGO_SW                            TM01->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM10_TRG_TRGO_SW                            TM10->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM16_TRG_TRGO_SW                            TM16->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM20_TRG_TRGO_SW                            TM20->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM26_TRG_TRGO_SW                            TM26->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.
#define TM36_TRG_TRGO_SW                            TM36->TRG.MBIT.TRGO_SW          //[24] Timer TRGO software control data bit.

#define TM00_TRG_UEV_SEL                            TM00->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM00_TRGO
#define TM01_TRG_UEV_SEL                            TM01->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM01_TRGO
#define TM10_TRG_UEV_SEL                            TM10->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM10_TRGO
#define TM16_TRG_UEV_SEL                            TM16->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM16_TRGO
#define TM20_TRG_UEV_SEL                            TM20->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM20_TRGO
#define TM26_TRG_UEV_SEL                            TM26->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM26_TRGO
#define TM36_TRG_UEV_SEL                            TM36->TRG.MBIT.UEV_SEL          //[23..22] Timer UEV output select bits for TM36_TRGO

#define TM26_TRG_IDX_MDS                            TM26->TRG.MBIT.IDX_MDS          //[21..20] Main Timer QEI external index signal input reset timer transition state select.
#define TM36_TRG_IDX_MDS                            TM36->TRG.MBIT.IDX_MDS          //[21..20] Main Timer QEI external index signal input reset timer transition state select.

#define TM26_TRG_IDX_EN                             TM26->TRG.MBIT.IDX_EN           //[19] Main Timer QEI external index signal input enable
#define TM36_TRG_IDX_EN                             TM36->TRG.MBIT.IDX_EN           //[19] Main Timer QEI external index signal input enable

#define TM26_TRG_QEI_MDS                            TM26->TRG.MBIT.QEI_MDS          //[18..16] Main Timer quadrature encoder interface
#define TM36_TRG_QEI_MDS                            TM36->TRG.MBIT.QEI_MDS          //[18..16] Main Timer quadrature encoder interface

#define TM00_TRG_TRGO_MDS                           TM00->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM01_TRG_TRGO_MDS                           TM01->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM10_TRG_TRGO_MDS                           TM10->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM16_TRG_TRGO_MDS                           TM16->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM20_TRG_TRGO_MDS                           TM20->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM26_TRG_TRGO_MDS                           TM26->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select
#define TM36_TRG_TRGO_MDS                           TM36->TRG.MBIT.TRGO_MDS         //[15..12] Timer trigger output mode select

#define TM00_TRG_ITR_MUX                            TM00->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM01_TRG_ITR_MUX                            TM01->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM10_TRG_ITR_MUX                            TM10->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM16_TRG_ITR_MUX                            TM16->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM20_TRG_ITR_MUX                            TM20->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM26_TRG_ITR_MUX                            TM26->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select
#define TM36_TRG_ITR_MUX                            TM36->TRG.MBIT.ITR_MUX          //[10..8] Timer internal trigger source select

#define TM00_TRG_TRG_MUX                            TM00->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM01_TRG_TRG_MUX                            TM01->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM10_TRG_TRG_MUX                            TM10->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM16_TRG_TRG_MUX                            TM16->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM20_TRG_TRG_MUX                            TM20->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM26_TRG_TRG_MUX                            TM26->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.
#define TM36_TRG_TRG_MUX                            TM36->TRG.MBIT.TRG_MUX          //[7..6] Timer trigger source TRGI select.

#define TM00_TRG_TRGI2_MDS                          TM00->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM01_TRG_TRGI2_MDS                          TM01->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM10_TRG_TRGI2_MDS                          TM10->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM16_TRG_TRGI2_MDS                          TM16->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM20_TRG_TRGI2_MDS                          TM20->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM26_TRG_TRGI2_MDS                          TM26->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select
#define TM36_TRG_TRGI2_MDS                          TM36->TRG.MBIT.TRGI2_MDS        //[5..3] 2nd Timer trigger input mode select

#define TM00_TRG_TRGI_MDS                           TM00->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM01_TRG_TRGI_MDS                           TM01->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM10_TRG_TRGI_MDS                           TM10->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM16_TRG_TRGI_MDS                           TM16->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM20_TRG_TRGI_MDS                           TM20->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM26_TRG_TRGI_MDS                           TM26->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select
#define TM36_TRG_TRGI_MDS                           TM36->TRG.MBIT.TRGI_MDS         //[2..0] Timer trigger input mode select

///@}
/**
 ******************************************************************************
 * @name        TM_CR0  [register's definitions]
 *              Offset[0x10]  TM Timer control register 0
 ******************************************************************************
 */
///@{
#define TM00_CR0                                    TM00->CR0.W                     /*!< Offset[0x10]  TM00 Timer control register 0 (0x55000010) */
#define TM01_CR0                                    TM01->CR0.W                     /*!< Offset[0x10]  TM01 Timer control register 0 (0x55010010) */
#define TM10_CR0                                    TM10->CR0.W                     /*!< Offset[0x10]  TM10 Timer control register 0 (0x55800010) */
#define TM16_CR0                                    TM16->CR0.W                     /*!< Offset[0x10]  TM16 Timer control register 0 (0x55860010) */
#define TM20_CR0                                    TM20->CR0.W                     /*!< Offset[0x10]  TM20 Timer control register 0 (0x56000010) */
#define TM26_CR0                                    TM26->CR0.W                     /*!< Offset[0x10]  TM26 Timer control register 0 (0x56060010) */
#define TM36_CR0                                    TM36->CR0.W                     /*!< Offset[0x10]  TM36 Timer control register 0 (0x56860010) */

/* Bit fields of TM_CR0 */
#define TM00_CR0_UEX_EN                             TM00->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM01_CR0_UEX_EN                             TM01->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM10_CR0_UEX_EN                             TM10->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM16_CR0_UEX_EN                             TM16->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM20_CR0_UEX_EN                             TM20->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM26_CR0_UEX_EN                             TM26->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.
#define TM36_CR0_UEX_EN                             TM36->CR0.MBIT.UEX_EN           //[15] Timer external trigger update event enable.

#define TM00_CR0_USW_EN                             TM00->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM01_CR0_USW_EN                             TM01->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM10_CR0_USW_EN                             TM10->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM16_CR0_USW_EN                             TM16->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM20_CR0_USW_EN                             TM20->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM26_CR0_USW_EN                             TM26->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)
#define TM36_CR0_USW_EN                             TM36->CR0.MBIT.USW_EN           //[14] Timer software update event generation enable.  (automatically clear by hardware)

#define TM26_CR0_DIR_INV                            TM26->CR0.MBIT.DIR_INV          //[13] Main Timer counting direction inverted enable.
#define TM36_CR0_DIR_INV                            TM36->CR0.MBIT.DIR_INV          //[13] Main Timer counting direction inverted enable.

#define TM00_CR0_UEV_DIS                            TM00->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM01_CR0_UEV_DIS                            TM01->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM10_CR0_UEV_DIS                            TM10->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM16_CR0_UEV_DIS                            TM16->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM20_CR0_UEV_DIS                            TM20->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM26_CR0_UEV_DIS                            TM26->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer
#define TM36_CR0_UEV_DIS                            TM36->CR0.MBIT.UEV_DIS          //[12] Update event generation disable for main Timer

#define TM00_CR0_EX_INV                             TM00->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM01_CR0_EX_INV                             TM01->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM10_CR0_EX_INV                             TM10->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM16_CR0_EX_INV                             TM16->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM20_CR0_EX_INV                             TM20->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM26_CR0_EX_INV                             TM26->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.
#define TM36_CR0_EX_INV                             TM36->CR0.MBIT.EX_INV           //[11] Timer external trigger input inverted enable.

#define TM00_CR0_EX_EN                              TM00->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM01_CR0_EX_EN                              TM01->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM10_CR0_EX_EN                              TM10->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM16_CR0_EX_EN                              TM16->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM20_CR0_EX_EN                              TM20->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM26_CR0_EX_EN                              TM26->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.
#define TM36_CR0_EX_EN                              TM36->CR0.MBIT.EX_EN            //[10] Timer external trigger event enable.

#define TM00_CR0_ASTOP_EN                           TM00->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM01_CR0_ASTOP_EN                           TM01->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM10_CR0_ASTOP_EN                           TM10->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM16_CR0_ASTOP_EN                           TM16->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM20_CR0_ASTOP_EN                           TM20->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM26_CR0_ASTOP_EN                           TM26->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable
#define TM36_CR0_ASTOP_EN                           TM36->CR0.MBIT.ASTOP_EN         //[8] Timer auto stop mode enable

#define TM00_CR0_DIR2                               TM00->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM01_CR0_DIR2                               TM01->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM10_CR0_DIR2                               TM10->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM16_CR0_DIR2                               TM16->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM20_CR0_DIR2                               TM20->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM26_CR0_DIR2                               TM26->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.
#define TM36_CR0_DIR2                               TM36->CR0.MBIT.DIR2             //[7] 2nd Timer counting direction bit.

#define TM10_CR0_DIR                                TM10->CR0.MBIT.DIR              //[6] Main Timer counting direction bit.
#define TM16_CR0_DIR                                TM16->CR0.MBIT.DIR              //[6] Main Timer counting direction bit.
#define TM26_CR0_DIR                                TM26->CR0.MBIT.DIR              //[6] Main Timer counting direction bit.
#define TM36_CR0_DIR                                TM36->CR0.MBIT.DIR              //[6] Main/2nd Timer counting direction bit

#define TM00_CR0_MDS                                TM00->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM01_CR0_MDS                                TM01->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM10_CR0_MDS                                TM10->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM16_CR0_MDS                                TM16->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM20_CR0_MDS                                TM20->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM26_CR0_MDS                                TM26->CR0.MBIT.MDS              //[5..4] Timer operation mode select
#define TM36_CR0_MDS                                TM36->CR0.MBIT.MDS              //[5..4] Timer operation mode select

#define TM00_CR0_EN2                                TM00->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM01_CR0_EN2                                TM01->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM10_CR0_EN2                                TM10->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM16_CR0_EN2                                TM16->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM20_CR0_EN2                                TM20->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM26_CR0_EN2                                TM26->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.
#define TM36_CR0_EN2                                TM36->CR0.MBIT.EN2              //[1] 2nd Timer/Counter enable bit.

#define TM00_CR0_EN                                 TM00->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM01_CR0_EN                                 TM01->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM10_CR0_EN                                 TM10->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM16_CR0_EN                                 TM16->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM20_CR0_EN                                 TM20->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM26_CR0_EN                                 TM26->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.
#define TM36_CR0_EN                                 TM36->CR0.MBIT.EN               //[0] Main Timer/Counter enable bit.

///@}
/**
 ******************************************************************************
 * @name        TM_CR1  [register's definitions]
 *              Offset[0x14]  TM Timer control register 1
 ******************************************************************************
 */
///@{
#define TM20_CR1                                    TM20->CR1.W                     /*!< Offset[0x14]  TM20 Timer control register 1 (0x56000014) */
#define TM26_CR1                                    TM26->CR1.W                     /*!< Offset[0x14]  TM26 Timer control register 1 (0x56060014) */
#define TM36_CR1                                    TM36->CR1.W                     /*!< Offset[0x14]  TM36 Timer control register 1 (0x56860014) */

/* Bit fields of TM_CR1 */
#define TM36_CR1_CC3B_SEN                           TM36->CR1.MBIT.CC3B_SEN         //[15] Timer channel 3 software IC/OC event-B generation enable

#define TM36_CR1_CC2B_SEN                           TM36->CR1.MBIT.CC2B_SEN         //[14] Timer channel 2 software IC/OC event-B generation enable

#define TM20_CR1_CC1B_SEN                           TM20->CR1.MBIT.CC1B_SEN         //[13] Timer channel 1 software IC/OC event-B generation enable
#define TM26_CR1_CC1B_SEN                           TM26->CR1.MBIT.CC1B_SEN         //[13] Timer channel 1 software IC/OC event-B generation enable
#define TM36_CR1_CC1B_SEN                           TM36->CR1.MBIT.CC1B_SEN         //[13] Timer channel 1 software IC/OC event-B generation enable

#define TM20_CR1_CC0B_SEN                           TM20->CR1.MBIT.CC0B_SEN         //[12] Timer channel 0 software IC/OC event-B generation enable
#define TM26_CR1_CC0B_SEN                           TM26->CR1.MBIT.CC0B_SEN         //[12] Timer channel 0 software IC/OC event-B generation enable
#define TM36_CR1_CC0B_SEN                           TM36->CR1.MBIT.CC0B_SEN         //[12] Timer channel 0 software IC/OC event-B generation enable

#define TM36_CR1_CC3A_SEN                           TM36->CR1.MBIT.CC3A_SEN         //[11] Timer channel 3 software IC/OC event-A generation enable

#define TM36_CR1_CC2A_SEN                           TM36->CR1.MBIT.CC2A_SEN         //[10] Timer channel 2 software IC/OC event-A generation enable

#define TM20_CR1_CC1A_SEN                           TM20->CR1.MBIT.CC1A_SEN         //[9] Timer channel 1 software IC/OC event-A generation enable
#define TM26_CR1_CC1A_SEN                           TM26->CR1.MBIT.CC1A_SEN         //[9] Timer channel 1 software IC/OC event-A generation enable
#define TM36_CR1_CC1A_SEN                           TM36->CR1.MBIT.CC1A_SEN         //[9] Timer channel 1 software IC/OC event-A generation enable

#define TM20_CR1_CC0A_SEN                           TM20->CR1.MBIT.CC0A_SEN         //[8] Timer channel 0 software IC/OC event-A generation enable
#define TM26_CR1_CC0A_SEN                           TM26->CR1.MBIT.CC0A_SEN         //[8] Timer channel 0 software IC/OC event-A generation enable
#define TM36_CR1_CC0A_SEN                           TM36->CR1.MBIT.CC0A_SEN         //[8] Timer channel 0 software IC/OC event-A generation enable

#define TM36_CR1_OVR3_MDS                           TM36->CR1.MBIT.OVR3_MDS         //[3] Timer channel 3 capture data buffer overrun mode select

#define TM36_CR1_OVR2_MDS                           TM36->CR1.MBIT.OVR2_MDS         //[2] Timer channel 2 capture data buffer overrun mode select

#define TM20_CR1_OVR1_MDS                           TM20->CR1.MBIT.OVR1_MDS         //[1] Timer channel 1 capture data buffer overrun mode select
#define TM26_CR1_OVR1_MDS                           TM26->CR1.MBIT.OVR1_MDS         //[1] Timer channel 1 capture data buffer overrun mode select
#define TM36_CR1_OVR1_MDS                           TM36->CR1.MBIT.OVR1_MDS         //[1] Timer channel 1 capture data buffer overrun mode select

#define TM20_CR1_OVR0_MDS                           TM20->CR1.MBIT.OVR0_MDS         //[0] Timer channel 0 capture data buffer overrun mode select
#define TM26_CR1_OVR0_MDS                           TM26->CR1.MBIT.OVR0_MDS         //[0] Timer channel 0 capture data buffer overrun mode select
#define TM36_CR1_OVR0_MDS                           TM36->CR1.MBIT.OVR0_MDS         //[0] Timer channel 0 capture data buffer overrun mode select

///@}
/**
 ******************************************************************************
 * @name        TM_CKO  [register's definitions]
 *              Offset[0x18]  TM Timer CKO control register
 ******************************************************************************
 */
///@{
#define TM00_CKO                                    TM00->CKO.W                     /*!< Offset[0x18]  TM00 Timer CKO control register (0x55000018) */
#define TM01_CKO                                    TM01->CKO.W                     /*!< Offset[0x18]  TM01 Timer CKO control register (0x55010018) */
#define TM10_CKO                                    TM10->CKO.W                     /*!< Offset[0x18]  TM10 Timer CKO control register (0x55800018) */
#define TM16_CKO                                    TM16->CKO.W                     /*!< Offset[0x18]  TM16 Timer CKO control register (0x55860018) */
#define TM20_CKO                                    TM20->CKO.W                     /*!< Offset[0x18]  TM20 Timer CKO control register (0x56000018) */
#define TM26_CKO                                    TM26->CKO.W                     /*!< Offset[0x18]  TM26 Timer CKO control register (0x56060018) */
#define TM36_CKO                                    TM36->CKO.W                     /*!< Offset[0x18]  TM36 Timer CKO control register (0x56860018) */

/* Bit fields of TM_CKO */
#define TM00_CKO_CKO_LCK                            TM00->CKO.MBIT.CKO_LCK          //[3] TM00_CKO_STA  register write access protected control
#define TM01_CKO_CKO_LCK                            TM01->CKO.MBIT.CKO_LCK          //[3] TM01_CKO_STA  register write access protected control
#define TM10_CKO_CKO_LCK                            TM10->CKO.MBIT.CKO_LCK          //[3] TM10_CKO_STA  register write access protected control
#define TM16_CKO_CKO_LCK                            TM16->CKO.MBIT.CKO_LCK          //[3] TM16_CKO_STA  register write access protected control
#define TM20_CKO_CKO_LCK                            TM20->CKO.MBIT.CKO_LCK          //[3] TM20_CKO_STA  register write access protected control
#define TM26_CKO_CKO_LCK                            TM26->CKO.MBIT.CKO_LCK          //[3] TM26_CKO_STA  register write access protected control
#define TM36_CKO_CKO_LCK                            TM36->CKO.MBIT.CKO_LCK          //[3] TM36_CKO_STA  register write access protected control

#define TM00_CKO_CKO_STA                            TM00->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM01_CKO_CKO_STA                            TM01->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM10_CKO_CKO_STA                            TM10->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM16_CKO_CKO_STA                            TM16->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM20_CKO_CKO_STA                            TM20->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM26_CKO_CKO_STA                            TM26->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state
#define TM36_CKO_CKO_STA                            TM36->CKO.MBIT.CKO_STA          //[2] Timer CKO output signal initial state

#define TM00_CKO_CKO_SEL                            TM00->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM01_CKO_CKO_SEL                            TM01->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM10_CKO_CKO_SEL                            TM10->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM16_CKO_CKO_SEL                            TM16->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM20_CKO_CKO_SEL                            TM20->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM26_CKO_CKO_SEL                            TM26->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.
#define TM36_CKO_CKO_SEL                            TM36->CKO.MBIT.CKO_SEL          //[1] Timer overflow as CKO output source select.

#define TM00_CKO_CKO_EN                             TM00->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM01_CKO_CKO_EN                             TM01->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM10_CKO_CKO_EN                             TM10->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM16_CKO_CKO_EN                             TM16->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM20_CKO_CKO_EN                             TM20->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM26_CKO_CKO_EN                             TM26->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.
#define TM36_CKO_CKO_EN                             TM36->CKO.MBIT.CKO_EN           //[0] Timer overflow as CKO output enable.

///@}
/**
 ******************************************************************************
 * @name        TM_CNT  [register's definitions]
 *              Offset[0x20]  TM Timer main counter register
 ******************************************************************************
 */
///@{
#define TM00_CNT                                    TM00->CNT.W                     /*!< Offset[0x20]  TM00 Timer main counter register (0x55000020) */
#define TM01_CNT                                    TM01->CNT.W                     /*!< Offset[0x20]  TM01 Timer main counter register (0x55010020) */
#define TM10_CNT                                    TM10->CNT.W                     /*!< Offset[0x20]  TM10 Timer main counter register (0x55800020) */
#define TM16_CNT                                    TM16->CNT.W                     /*!< Offset[0x20]  TM16 Timer main counter register (0x55860020) */
#define TM20_CNT                                    TM20->CNT.W                     /*!< Offset[0x20]  TM20 Timer main counter register (0x56000020) */
#define TM26_CNT                                    TM26->CNT.W                     /*!< Offset[0x20]  TM26 Timer main counter register (0x56060020) */
#define TM36_CNT                                    TM36->CNT.W                     /*!< Offset[0x20]  TM36 Timer main counter register (0x56860020) */

/* Bit fields of TM_CNT */
#define TM00_CNT_CNT                                TM00->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM01_CNT_CNT                                TM01->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM10_CNT_CNT                                TM10->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM16_CNT_CNT                                TM16->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM20_CNT_CNT                                TM20->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM26_CNT_CNT                                TM26->CNT.MBIT.CNT              //[15..0] Main timer/counter register.
#define TM36_CNT_CNT                                TM36->CNT.MBIT.CNT              //[15..0] Main timer/counter register.

///@}
/**
 ******************************************************************************
 * @name        TM_ARR  [register's definitions]
 *              Offset[0x24]  TM Timer main counter auto-reload value register
 ******************************************************************************
 */
///@{
#define TM00_ARR                                    TM00->ARR.W                     /*!< Offset[0x24]  TM00 Timer main counter auto-reload value register (0x55000024) */
#define TM01_ARR                                    TM01->ARR.W                     /*!< Offset[0x24]  TM01 Timer main counter auto-reload value register (0x55010024) */
#define TM10_ARR                                    TM10->ARR.W                     /*!< Offset[0x24]  TM10 Timer main counter auto-reload value register (0x55800024) */
#define TM16_ARR                                    TM16->ARR.W                     /*!< Offset[0x24]  TM16 Timer main counter auto-reload value register (0x55860024) */
#define TM20_ARR                                    TM20->ARR.W                     /*!< Offset[0x24]  TM20 Timer main counter auto-reload value register (0x56000024) */
#define TM26_ARR                                    TM26->ARR.W                     /*!< Offset[0x24]  TM26 Timer main counter auto-reload value register (0x56060024) */
#define TM36_ARR                                    TM36->ARR.W                     /*!< Offset[0x24]  TM36 Timer main counter auto-reload value register (0x56860024) */

/* Bit fields of TM_ARR */
#define TM00_ARR_ARR                                TM00->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register
#define TM01_ARR_ARR                                TM01->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register
#define TM10_ARR_ARR                                TM10->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register
#define TM16_ARR_ARR                                TM16->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register
#define TM20_ARR_ARR                                TM20->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register.
#define TM26_ARR_ARR                                TM26->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register.
#define TM36_ARR_ARR                                TM36->ARR.MBIT.ARR              //[15..0] Main timer/counter auto-reload value register.

///@}
/**
 ******************************************************************************
 * @name        TM_PSCNT  [register's definitions]
 *              Offset[0x28]  TM Timer prescaler register
 ******************************************************************************
 */
///@{
#define TM00_PSCNT                                  TM00->PSCNT.W                   /*!< Offset[0x28]  TM00 Timer prescaler register (0x55000028) */
#define TM01_PSCNT                                  TM01->PSCNT.W                   /*!< Offset[0x28]  TM01 Timer prescaler register (0x55010028) */
#define TM10_PSCNT                                  TM10->PSCNT.W                   /*!< Offset[0x28]  TM10 Timer prescaler register (0x55800028) */
#define TM16_PSCNT                                  TM16->PSCNT.W                   /*!< Offset[0x28]  TM16 Timer prescaler register (0x55860028) */
#define TM20_PSCNT                                  TM20->PSCNT.W                   /*!< Offset[0x28]  TM20 Timer prescaler register (0x56000028) */
#define TM26_PSCNT                                  TM26->PSCNT.W                   /*!< Offset[0x28]  TM26 Timer prescaler register (0x56060028) */
#define TM36_PSCNT                                  TM36->PSCNT.W                   /*!< Offset[0x28]  TM36 Timer prescaler register (0x56860028) */

/* Bit fields of TM_PSCNT */
#define TM00_PSCNT_CNTA                             TM00->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM01_PSCNT_CNTA                             TM01->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM10_PSCNT_CNTA                             TM10->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM16_PSCNT_CNTA                             TM16->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM20_PSCNT_CNTA                             TM20->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM26_PSCNT_CNTA                             TM26->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register
#define TM36_PSCNT_CNTA                             TM36->PSCNT.MBIT.CNTA           //[31..16] Main timer/counter alias register

#define TM00_PSCNT_PSCNT                            TM00->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM01_PSCNT_PSCNT                            TM01->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM10_PSCNT_PSCNT                            TM10->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM16_PSCNT_PSCNT                            TM16->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM20_PSCNT_PSCNT                            TM20->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM26_PSCNT_PSCNT                            TM26->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register
#define TM36_PSCNT_PSCNT                            TM36->PSCNT.MBIT.PSCNT          //[15..0] Timer prescaler or 2nd  timer/counter register

///@}
/**
 ******************************************************************************
 * @name        TM_PSARR  [register's definitions]
 *              Offset[0x2C]  TM Timer prescaler auto-reload register
 ******************************************************************************
 */
///@{
#define TM00_PSARR                                  TM00->PSARR.W                   /*!< Offset[0x2C]  TM00 Timer prescaler auto-reload register (0x5500002C) */
#define TM01_PSARR                                  TM01->PSARR.W                   /*!< Offset[0x2C]  TM01 Timer prescaler auto-reload register (0x5501002C) */
#define TM10_PSARR                                  TM10->PSARR.W                   /*!< Offset[0x2C]  TM10 Timer prescaler auto-reload register (0x5580002C) */
#define TM16_PSARR                                  TM16->PSARR.W                   /*!< Offset[0x2C]  TM16 Timer prescaler auto-reload register (0x5586002C) */
#define TM20_PSARR                                  TM20->PSARR.W                   /*!< Offset[0x2C]  TM20 Timer prescaler auto-reload register (0x5600002C) */
#define TM26_PSARR                                  TM26->PSARR.W                   /*!< Offset[0x2C]  TM26 Timer prescaler auto-reload register (0x5606002C) */
#define TM36_PSARR                                  TM36->PSARR.W                   /*!< Offset[0x2C]  TM36 Timer prescaler auto-reload register (0x5686002C) */

/* Bit fields of TM_PSARR */
#define TM00_PSARR_PSARR                            TM00->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM01_PSARR_PSARR                            TM01->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM10_PSARR_PSARR                            TM10->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM16_PSARR_PSARR                            TM16->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM20_PSARR_PSARR                            TM20->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM26_PSARR_PSARR                            TM26->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register
#define TM36_PSARR_PSARR                            TM36->PSARR.MBIT.PSARR          //[15..0] Timer prescaler or 2nd timer/counter auto-reload value register

///@}
/**
 ******************************************************************************
 * @name        TM_CCMDS  [register's definitions]
 *              Offset[0x30]  TM Timer capture and compare mode select register
 ******************************************************************************
 */
///@{
#define TM20_CCMDS                                  TM20->CCMDS.W                   /*!< Offset[0x30]  TM20 Timer capture and compare mode select register (0x56000030) */
#define TM26_CCMDS                                  TM26->CCMDS.W                   /*!< Offset[0x30]  TM26 Timer capture and compare mode select register (0x56060030) */
#define TM36_CCMDS                                  TM36->CCMDS.W                   /*!< Offset[0x30]  TM36 Timer capture and compare mode select register (0x56860030) */

/* Bit fields of TM_CCMDS */
#define TM36_CCMDS_DMA_CC3E                         TM36->CCMDS.MBIT.DMA_CC3E       //[27] Direct memory access enable for IC3.

#define TM36_CCMDS_DMA_CC2E                         TM36->CCMDS.MBIT.DMA_CC2E       //[26] Direct memory access enable for OC2.

#define TM36_CCMDS_DMA_CC1E                         TM36->CCMDS.MBIT.DMA_CC1E       //[25] Direct memory access enable for OC1.

#define TM36_CCMDS_DMA_CC0E                         TM36->CCMDS.MBIT.DMA_CC0E       //[24] Direct memory access enable for OC0.

#define TM36_CCMDS_DMA_OMDS                         TM36->CCMDS.MBIT.DMA_OMDS       //[23] Timer output DMA request mode select

#define TM20_CCMDS_OC_LCK                           TM20->CCMDS.MBIT.OC_LCK         //[16] Timer output compare reload function lock enable bit for all channel
#define TM26_CCMDS_OC_LCK                           TM26->CCMDS.MBIT.OC_LCK         //[16] Timer output compare reload function lock enable bit for all channel
#define TM36_CCMDS_OC_LCK                           TM36->CCMDS.MBIT.OC_LCK         //[16] Timer output compare reload function lock enable bit for all channel

#define TM36_CCMDS_CC3_MDS                          TM36->CCMDS.MBIT.CC3_MDS        //[14..12] Timer channel 3 capture and compare mode select. 

#define TM36_CCMDS_CC2_MDS                          TM36->CCMDS.MBIT.CC2_MDS        //[10..8] Timer channel 2 capture and compare mode select. 

#define TM20_CCMDS_CC1_MDS                          TM20->CCMDS.MBIT.CC1_MDS        //[6..4] Timer channel 1 capture and compare mode select. 
#define TM26_CCMDS_CC1_MDS                          TM26->CCMDS.MBIT.CC1_MDS        //[6..4] Timer channel 1 capture and compare mode select. 
#define TM36_CCMDS_CC1_MDS                          TM36->CCMDS.MBIT.CC1_MDS        //[6..4] Timer channel 1 capture and compare mode select. 

#define TM20_CCMDS_CC0_MDS                          TM20->CCMDS.MBIT.CC0_MDS        //[2..0] Timer channel 0 capture and compare mode select.
#define TM26_CCMDS_CC0_MDS                          TM26->CCMDS.MBIT.CC0_MDS        //[2..0] Timer channel 0 capture and compare mode select.
#define TM36_CCMDS_CC0_MDS                          TM36->CCMDS.MBIT.CC0_MDS        //[2..0] Timer channel 0 capture and compare mode select.

///@}
/**
 ******************************************************************************
 * @name        TM_ICCR  [register's definitions]
 *              Offset[0x34]  TM Timer input capture control register
 ******************************************************************************
 */
///@{
#define TM20_ICCR                                   TM20->ICCR.W                    /*!< Offset[0x34]  TM20 Timer input capture control register (0x56000034) */
#define TM26_ICCR                                   TM26->ICCR.W                    /*!< Offset[0x34]  TM26 Timer input capture control register (0x56060034) */
#define TM36_ICCR                                   TM36->ICCR.W                    /*!< Offset[0x34]  TM36 Timer input capture control register (0x56860034) */

/* Bit fields of TM_ICCR */
#define TM36_ICCR_IC3_TRGS                          TM36->ICCR.MBIT.IC3_TRGS        //[23..22] Timer channel 3 input trigger edge select.

#define TM36_ICCR_IC2_TRGS                          TM36->ICCR.MBIT.IC2_TRGS        //[21..20] Timer channel 2 input trigger edge select.

#define TM20_ICCR_IC1_TRGS                          TM20->ICCR.MBIT.IC1_TRGS        //[19..18] Timer channel 1 input trigger edge select. 
#define TM26_ICCR_IC1_TRGS                          TM26->ICCR.MBIT.IC1_TRGS        //[19..18] Timer channel 1 input trigger edge select. 
#define TM36_ICCR_IC1_TRGS                          TM36->ICCR.MBIT.IC1_TRGS        //[19..18] Timer channel 1 input trigger edge select. 

#define TM20_ICCR_IC0_TRGS                          TM20->ICCR.MBIT.IC0_TRGS        //[17..16] Timer channel 0 input trigger edge select.
#define TM26_ICCR_IC0_TRGS                          TM26->ICCR.MBIT.IC0_TRGS        //[17..16] Timer channel 0 input trigger edge select.
#define TM36_ICCR_IC0_TRGS                          TM36->ICCR.MBIT.IC0_TRGS        //[17..16] Timer channel 0 input trigger edge select.

#define TM36_ICCR_IC3_MUX                           TM36->ICCR.MBIT.IC3_MUX         //[13..12] Timer channel 3 input Mux select for input capture.

#define TM36_ICCR_IC2_MUX                           TM36->ICCR.MBIT.IC2_MUX         //[9..8] Timer channel 2 input Mux select for input capture.

#define TM20_ICCR_IC1_MUX                           TM20->ICCR.MBIT.IC1_MUX         //[5..4] Timer channel 1 input Mux select for input capture.
#define TM26_ICCR_IC1_MUX                           TM26->ICCR.MBIT.IC1_MUX         //[5..4] Timer channel 1 input Mux select for input capture.
#define TM36_ICCR_IC1_MUX                           TM36->ICCR.MBIT.IC1_MUX         //[5..4] Timer channel 1 input Mux select for input capture.

#define TM20_ICCR_IC0_MUX                           TM20->ICCR.MBIT.IC0_MUX         //[1..0] Timer channel 0 input Mux select for input capture.
#define TM26_ICCR_IC0_MUX                           TM26->ICCR.MBIT.IC0_MUX         //[1..0] Timer channel 0 input Mux select for input capture.
#define TM36_ICCR_IC0_MUX                           TM36->ICCR.MBIT.IC0_MUX         //[1..0] Timer channel 0 input Mux select for input capture.

///@}
/**
 ******************************************************************************
 * @name        TM_OSCR  [register's definitions]
 *              Offset[0x38]  TM Timer output compare state register
 ******************************************************************************
 */
///@{
#define TM20_OSCR                                   TM20->OSCR.W                    /*!< Offset[0x38]  TM20 Timer output compare state register (0x56000038) */
#define TM26_OSCR                                   TM26->OSCR.W                    /*!< Offset[0x38]  TM26 Timer output compare state register (0x56060038) */
#define TM36_OSCR                                   TM36->OSCR.W                    /*!< Offset[0x38]  TM36 Timer output compare state register (0x56860038) */

/* Bit fields of TM_OSCR */
#define TM36_OSCR_OS3H_LCK                          TM36->OSCR.MBIT.OS3H_LCK        //[15] TM36_OS3H_STA register write access protected control

#define TM36_OSCR_OS2H_LCK                          TM36->OSCR.MBIT.OS2H_LCK        //[14] TM36_OS2H_STA register write access protected control

#define TM20_OSCR_OS1H_LCK                          TM20->OSCR.MBIT.OS1H_LCK        //[13] TM20_OS1H_STA register write access protected control
#define TM26_OSCR_OS1H_LCK                          TM26->OSCR.MBIT.OS1H_LCK        //[13] TM26_OS1H_STA register write access protected control
#define TM36_OSCR_OS1H_LCK                          TM36->OSCR.MBIT.OS1H_LCK        //[13] TM36_OS1H_STA register write access protected control

#define TM20_OSCR_OS0H_LCK                          TM20->OSCR.MBIT.OS0H_LCK        //[12] TM20_OS0H_STA register write access protected control
#define TM26_OSCR_OS0H_LCK                          TM26->OSCR.MBIT.OS0H_LCK        //[12] TM26_OS0H_STA register write access protected control
#define TM36_OSCR_OS0H_LCK                          TM36->OSCR.MBIT.OS0H_LCK        //[12] TM36_OS0H_STA register write access protected control

#define TM36_OSCR_OS3H_STA                          TM36->OSCR.MBIT.OS3H_STA        //[11] Timer channel 3 OC compare-H output signal initial state for two 8-Bit comparator mod

#define TM36_OSCR_OS2H_STA                          TM36->OSCR.MBIT.OS2H_STA        //[10] Timer channel 2 OC compare-H output signal initial state for two 8-Bit comparator mod

#define TM20_OSCR_OS1H_STA                          TM20->OSCR.MBIT.OS1H_STA        //[9] Timer channel 1 OC compare-H output signal initial state for two 8-Bit comparator mod
#define TM26_OSCR_OS1H_STA                          TM26->OSCR.MBIT.OS1H_STA        //[9] Timer channel 1 OC compare-H output signal initial state for two 8-Bit comparator mod
#define TM36_OSCR_OS1H_STA                          TM36->OSCR.MBIT.OS1H_STA        //[9] Timer channel 1 OC compare-H output signal initial state for two 8-Bit comparator mod

#define TM20_OSCR_OS0H_STA                          TM20->OSCR.MBIT.OS0H_STA        //[8] Timer channel 0 OC compare-H output signal initial state for two 8-Bit comparator mod
#define TM26_OSCR_OS0H_STA                          TM26->OSCR.MBIT.OS0H_STA        //[8] Timer channel 0 OC compare-H output signal initial state for two 8-Bit comparator mod
#define TM36_OSCR_OS0H_STA                          TM36->OSCR.MBIT.OS0H_STA        //[8] Timer channel 0 OC compare-H output signal initial state for two 8-Bit comparator mod

#define TM36_OSCR_OS3_LCK                           TM36->OSCR.MBIT.OS3_LCK         //[7] TM36_OS3_STA register write access protected control

#define TM36_OSCR_OS2_LCK                           TM36->OSCR.MBIT.OS2_LCK         //[6] TM36_OS2_STA register write access protected control

#define TM20_OSCR_OS1_LCK                           TM20->OSCR.MBIT.OS1_LCK         //[5] TM20_OS1_STA register write access protected control
#define TM26_OSCR_OS1_LCK                           TM26->OSCR.MBIT.OS1_LCK         //[5] TM26_OS1_STA register write access protected control
#define TM36_OSCR_OS1_LCK                           TM36->OSCR.MBIT.OS1_LCK         //[5] TM36_OS1_STA register write access protected control

#define TM20_OSCR_OS0_LCK                           TM20->OSCR.MBIT.OS0_LCK         //[4] TM20_OS0_STA register write access protected control
#define TM26_OSCR_OS0_LCK                           TM26->OSCR.MBIT.OS0_LCK         //[4] TM26_OS0_STA register write access protected control
#define TM36_OSCR_OS0_LCK                           TM36->OSCR.MBIT.OS0_LCK         //[4] TM36_OS0_STA register write access protected control

#define TM36_OSCR_OS3_STA                           TM36->OSCR.MBIT.OS3_STA         //[3] Timer channel 3 OC compare/compare-L output signal initial state.

#define TM36_OSCR_OS2_STA                           TM36->OSCR.MBIT.OS2_STA         //[2] Timer channel 2 OC compare/compare-L output signal initial state.

#define TM20_OSCR_OS1_STA                           TM20->OSCR.MBIT.OS1_STA         //[1] Timer channel 1 OC compare/compare-L output signal initial state.
#define TM26_OSCR_OS1_STA                           TM26->OSCR.MBIT.OS1_STA         //[1] Timer channel 1 OC compare/compare-L output signal initial state.
#define TM36_OSCR_OS1_STA                           TM36->OSCR.MBIT.OS1_STA         //[1] Timer channel 1 OC compare/compare-L output signal initial state.

#define TM20_OSCR_OS0_STA                           TM20->OSCR.MBIT.OS0_STA         //[0] Timer channel 0 OC compare/compare-L output signal initial state.
#define TM26_OSCR_OS0_STA                           TM26->OSCR.MBIT.OS0_STA         //[0] Timer channel 0 OC compare/compare-L output signal initial state.
#define TM36_OSCR_OS0_STA                           TM36->OSCR.MBIT.OS0_STA         //[0] Timer channel 0 OC compare/compare-L output signal initial state.

///@}
/**
 ******************************************************************************
 * @name        TM_OCCR0  [register's definitions]
 *              Offset[0x3C]  TM Timer output compare control register 0
 ******************************************************************************
 */
///@{
#define TM20_OCCR0                                  TM20->OCCR0.W                   /*!< Offset[0x3C]  TM20 Timer output compare control register 0 (0x5600003C) */
#define TM26_OCCR0                                  TM26->OCCR0.W                   /*!< Offset[0x3C]  TM26 Timer output compare control register 0 (0x5606003C) */
#define TM36_OCCR0                                  TM36->OCCR0.W                   /*!< Offset[0x3C]  TM36 Timer output compare control register 0 (0x5686003C) */

/* Bit fields of TM_OCCR0 */
#define TM36_OCCR0_OC2N_OE                          TM36->OCCR0.MBIT.OC2N_OE        //[24] Timer channel 2 OC2N (complement) line output enable.

#define TM20_OCCR0_OC1N_OE                          TM20->OCCR0.MBIT.OC1N_OE        //[20] Timer channel 1 OC1N (complement) line output enable.
#define TM26_OCCR0_OC1N_OE                          TM26->OCCR0.MBIT.OC1N_OE        //[20] Timer channel 1 OC1N (complement) line output enable.
#define TM36_OCCR0_OC1N_OE                          TM36->OCCR0.MBIT.OC1N_OE        //[20] Timer channel 1 OC1N (complement) line output enable.

#define TM20_OCCR0_OC0N_OE                          TM20->OCCR0.MBIT.OC0N_OE        //[16] Timer channel 0 OC0N (complement) line output enable.
#define TM26_OCCR0_OC0N_OE                          TM26->OCCR0.MBIT.OC0N_OE        //[16] Timer channel 0 OC0N (complement) line output enable.
#define TM36_OCCR0_OC0N_OE                          TM36->OCCR0.MBIT.OC0N_OE        //[16] Timer channel 0 OC0N (complement) line output enable.

#define TM36_OCCR0_OC3_OE                           TM36->OCCR0.MBIT.OC3_OE         //[12] Timer channel 3 OC line output enable.

#define TM36_OCCR0_OC2_OE                           TM36->OCCR0.MBIT.OC2_OE         //[8] Timer channel 2 OC line output enable.

#define TM20_OCCR0_OC1_OE2                          TM20->OCCR0.MBIT.OC1_OE2        //[6] Timer channel 1 OC line-2 output enable.
#define TM26_OCCR0_OC1_OE2                          TM26->OCCR0.MBIT.OC1_OE2        //[6] Timer channel 1 OC line-2 output enable.
#define TM36_OCCR0_OC1_OE2                          TM36->OCCR0.MBIT.OC1_OE2        //[6] Timer channel 1 OC line-2 output enable.

#define TM20_OCCR0_OC1_OE1                          TM20->OCCR0.MBIT.OC1_OE1        //[5] Timer channel 1 OC line-1 output enable.
#define TM26_OCCR0_OC1_OE1                          TM26->OCCR0.MBIT.OC1_OE1        //[5] Timer channel 1 OC line-1 output enable.
#define TM36_OCCR0_OC1_OE1                          TM36->OCCR0.MBIT.OC1_OE1        //[5] Timer channel 1 OC line-1 output enable.

#define TM20_OCCR0_OC1_OE0                          TM20->OCCR0.MBIT.OC1_OE0        //[4] Timer channel 1 OC line-0 output enable.
#define TM26_OCCR0_OC1_OE0                          TM26->OCCR0.MBIT.OC1_OE0        //[4] Timer channel 1 OC line-0 output enable.
#define TM36_OCCR0_OC1_OE0                          TM36->OCCR0.MBIT.OC1_OE0        //[4] Timer channel 1 OC line-0 output enable.

#define TM20_OCCR0_OC0_OE2                          TM20->OCCR0.MBIT.OC0_OE2        //[2] Timer channel 0 OC line-2 output enable.
#define TM26_OCCR0_OC0_OE2                          TM26->OCCR0.MBIT.OC0_OE2        //[2] Timer channel 0 OC line-2 output enable.
#define TM36_OCCR0_OC0_OE2                          TM36->OCCR0.MBIT.OC0_OE2        //[2] Timer channel 0 OC line-2 output enable.

#define TM20_OCCR0_OC0_OE1                          TM20->OCCR0.MBIT.OC0_OE1        //[1] Timer channel 0 OC line-1 output enable.
#define TM26_OCCR0_OC0_OE1                          TM26->OCCR0.MBIT.OC0_OE1        //[1] Timer channel 0 OC line-1 output enable.
#define TM36_OCCR0_OC0_OE1                          TM36->OCCR0.MBIT.OC0_OE1        //[1] Timer channel 0 OC line-1 output enable.

#define TM20_OCCR0_OC0_OE0                          TM20->OCCR0.MBIT.OC0_OE0        //[0] Timer channel 0 OC line-0 output enable.
#define TM26_OCCR0_OC0_OE0                          TM26->OCCR0.MBIT.OC0_OE0        //[0] Timer channel 0 OC line-0 output enable.
#define TM36_OCCR0_OC0_OE0                          TM36->OCCR0.MBIT.OC0_OE0        //[0] Timer channel 0 OC line-0 output enable.

///@}
/**
 ******************************************************************************
 * @name        TM_OCCR1  [register's definitions]
 *              Offset[0x40]  TM Timer output compare control register 1
 ******************************************************************************
 */
///@{
#define TM20_OCCR1                                  TM20->OCCR1.W                   /*!< Offset[0x40]  TM20 Timer output compare control register 1 (0x56000040) */
#define TM26_OCCR1                                  TM26->OCCR1.W                   /*!< Offset[0x40]  TM26 Timer output compare control register 1 (0x56060040) */
#define TM36_OCCR1                                  TM36->OCCR1.W                   /*!< Offset[0x40]  TM36 Timer output compare control register 1 (0x56860040) */

/* Bit fields of TM_OCCR1 */
#define TM20_OCCR1_POE_SW                           TM20->OCCR1.MBIT.POE_SW         //[28] Timer output enable registers preload software enable bit
#define TM26_OCCR1_POE_SW                           TM26->OCCR1.MBIT.POE_SW         //[28] Timer output enable registers preload software enable bit
#define TM36_OCCR1_POE_SW                           TM36->OCCR1.MBIT.POE_SW         //[28] Timer output enable registers preload software enable bit

#define TM20_OCCR1_POE_EN2                          TM20->OCCR1.MBIT.POE_EN2        //[26] Timer OC preload enable bit for output enable preload register control
#define TM26_OCCR1_POE_EN2                          TM26->OCCR1.MBIT.POE_EN2        //[26] Timer OC preload enable bit for output enable preload register control
#define TM36_OCCR1_POE_EN2                          TM36->OCCR1.MBIT.POE_EN2        //[26] Timer OC preload enable bit for output enable preload register control

#define TM20_OCCR1_POE_EN1                          TM20->OCCR1.MBIT.POE_EN1        //[25] Timer OC preload enable bit for output enable preload register control
#define TM26_OCCR1_POE_EN1                          TM26->OCCR1.MBIT.POE_EN1        //[25] Timer OC preload enable bit for output enable preload register control
#define TM36_OCCR1_POE_EN1                          TM36->OCCR1.MBIT.POE_EN1        //[25] Timer OC preload enable bit for output enable preload register control

#define TM20_OCCR1_POE_EN0                          TM20->OCCR1.MBIT.POE_EN0        //[24] Timer OC preload enable bit for output enable preload register control
#define TM26_OCCR1_POE_EN0                          TM26->OCCR1.MBIT.POE_EN0        //[24] Timer OC preload enable bit for output enable preload register control
#define TM36_OCCR1_POE_EN0                          TM36->OCCR1.MBIT.POE_EN0        //[24] Timer OC preload enable bit for output enable preload register control

#define TM20_OCCR1_OC1_POE2                         TM20->OCCR1.MBIT.OC1_POE2       //[22] Timer channel 1 OC line-2 output enable preload register bit
#define TM26_OCCR1_OC1_POE2                         TM26->OCCR1.MBIT.OC1_POE2       //[22] Timer channel 1 OC line-2 output enable preload register bit
#define TM36_OCCR1_OC1_POE2                         TM36->OCCR1.MBIT.OC1_POE2       //[22] Timer channel 1 OC line-2 output enable preload register bit

#define TM20_OCCR1_OC1_POE1                         TM20->OCCR1.MBIT.OC1_POE1       //[21] Timer channel 1 OC line-1 output enable preload register bit
#define TM26_OCCR1_OC1_POE1                         TM26->OCCR1.MBIT.OC1_POE1       //[21] Timer channel 1 OC line-1 output enable preload register bit
#define TM36_OCCR1_OC1_POE1                         TM36->OCCR1.MBIT.OC1_POE1       //[21] Timer channel 1 OC line-1 output enable preload register bit

#define TM20_OCCR1_OC1_POE0                         TM20->OCCR1.MBIT.OC1_POE0       //[20] Timer channel 1 OC line-0 output enable preload register bit
#define TM26_OCCR1_OC1_POE0                         TM26->OCCR1.MBIT.OC1_POE0       //[20] Timer channel 1 OC line-0 output enable preload register bit
#define TM36_OCCR1_OC1_POE0                         TM36->OCCR1.MBIT.OC1_POE0       //[20] Timer channel 1 OC line-0 output enable preload register bit

#define TM20_OCCR1_OC0_POE2                         TM20->OCCR1.MBIT.OC0_POE2       //[18] Timer channel 0 OC line-2 output enable preload register bit
#define TM26_OCCR1_OC0_POE2                         TM26->OCCR1.MBIT.OC0_POE2       //[18] Timer channel 0 OC line-2 output enable preload register bit
#define TM36_OCCR1_OC0_POE2                         TM36->OCCR1.MBIT.OC0_POE2       //[18] Timer channel 0 OC line-2 output enable preload register bit

#define TM20_OCCR1_OC0_POE1                         TM20->OCCR1.MBIT.OC0_POE1       //[17] Timer channel 0 OC line-1 output enable preload register bit
#define TM26_OCCR1_OC0_POE1                         TM26->OCCR1.MBIT.OC0_POE1       //[17] Timer channel 0 OC line-0 output enable preload register bit
#define TM36_OCCR1_OC0_POE1                         TM36->OCCR1.MBIT.OC0_POE1       //[17] Timer channel 0 OC line-1 output enable preload register bit

#define TM20_OCCR1_OC0_POE0                         TM20->OCCR1.MBIT.OC0_POE0       //[16] Timer channel 0 OC line-0 output enable preload register bit
#define TM26_OCCR1_OC0_POE0                         TM26->OCCR1.MBIT.OC0_POE0       //[16] Timer channel 0 OC line-1 output enable preload register bit
#define TM36_OCCR1_OC0_POE0                         TM36->OCCR1.MBIT.OC0_POE0       //[16] Timer channel 0 OC line-0 output enable preload register bit

#define TM36_OCCR1_OC2N_INV                         TM36->OCCR1.MBIT.OC2N_INV       //[10] Timer channel 2 complement output inverse enable.

#define TM20_OCCR1_OC1N_INV                         TM20->OCCR1.MBIT.OC1N_INV       //[9] Timer channel 1 complement output inverse enable.
#define TM26_OCCR1_OC1N_INV                         TM26->OCCR1.MBIT.OC1N_INV       //[9] Timer channel 1 complement output inverse enable.
#define TM36_OCCR1_OC1N_INV                         TM36->OCCR1.MBIT.OC1N_INV       //[9] Timer channel 1 complement output inverse enable.

#define TM20_OCCR1_OC0N_INV                         TM20->OCCR1.MBIT.OC0N_INV       //[8] Timer channel 0 complement output inverse enable.
#define TM26_OCCR1_OC0N_INV                         TM26->OCCR1.MBIT.OC0N_INV       //[8] Timer channel 0 complement output inverse enable.
#define TM36_OCCR1_OC0N_INV                         TM36->OCCR1.MBIT.OC0N_INV       //[8] Timer channel 0 complement output inverse enable.

#define TM36_OCCR1_OC3H_INV                         TM36->OCCR1.MBIT.OC3H_INV       //[7] Timer channel 3 output inverse enable.

#define TM36_OCCR1_OC2H_INV                         TM36->OCCR1.MBIT.OC2H_INV       //[6] Timer channel 2 output inverse enable.

#define TM20_OCCR1_OC1H_INV                         TM20->OCCR1.MBIT.OC1H_INV       //[5] Timer channel 1 output inverse enable.
#define TM26_OCCR1_OC1H_INV                         TM26->OCCR1.MBIT.OC1H_INV       //[5] Timer channel 1 output inverse enable.
#define TM36_OCCR1_OC1H_INV                         TM36->OCCR1.MBIT.OC1H_INV       //[5] Timer channel 1 output inverse enable.

#define TM20_OCCR1_OC0H_INV                         TM20->OCCR1.MBIT.OC0H_INV       //[4] Timer channel 0 output inverse enable.
#define TM26_OCCR1_OC0H_INV                         TM26->OCCR1.MBIT.OC0H_INV       //[4] Timer channel 0 output inverse enable.
#define TM36_OCCR1_OC0H_INV                         TM36->OCCR1.MBIT.OC0H_INV       //[4] Timer channel 0 output inverse enable.

#define TM36_OCCR1_OC3_INV                          TM36->OCCR1.MBIT.OC3_INV        //[3] Timer channel 3 output inverse enable.

#define TM36_OCCR1_OC2_INV                          TM36->OCCR1.MBIT.OC2_INV        //[2] Timer channel 2 output inverse enable.

#define TM20_OCCR1_OC1_INV                          TM20->OCCR1.MBIT.OC1_INV        //[1] Timer channel 1 output inverse enable.
#define TM26_OCCR1_OC1_INV                          TM26->OCCR1.MBIT.OC1_INV        //[1] Timer channel 1 output inverse enable.
#define TM36_OCCR1_OC1_INV                          TM36->OCCR1.MBIT.OC1_INV        //[1] Timer channel 1 output inverse enable.

#define TM20_OCCR1_OC0_INV                          TM20->OCCR1.MBIT.OC0_INV        //[0] Timer channel 0 output inverse enable.
#define TM26_OCCR1_OC0_INV                          TM26->OCCR1.MBIT.OC0_INV        //[0] Timer channel 0 output inverse enable.
#define TM36_OCCR1_OC0_INV                          TM36->OCCR1.MBIT.OC0_INV        //[0] Timer channel 0 output inverse enable.

///@}
/**
 ******************************************************************************
 * @name        TM_PWM  [register's definitions]
 *              Offset[0x44]  TM Timer PWM and DTG control register
 ******************************************************************************
 */
///@{
#define TM20_PWM                                    TM20->PWM.W                     /*!< Offset[0x44]  TM20 Timer PWM and DTG control register (0x56000044) */
#define TM26_PWM                                    TM26->PWM.W                     /*!< Offset[0x44]  TM26 Timer PWM and DTG control register (0x56060044) */
#define TM36_PWM                                    TM36->PWM.W                     /*!< Offset[0x44]  TM36 Timer PWM and DTG control register (0x56860044) */

/* Bit fields of TM_PWM */
#define TM36_PWM_DTG_DY                             TM36->PWM.MBIT.DTG_DY           //[15..8] Timer output DTG dead-time delay(CK_DTG clock time base) for all channels

#define TM20_PWM_PWM_MDS                            TM20->PWM.MBIT.PWM_MDS          //[1..0] Timer OC0/1/2/3 PWM mode select.
#define TM26_PWM_PWM_MDS                            TM26->PWM.MBIT.PWM_MDS          //[1..0] Timer OC0/1/2/3 PWM mode select.
#define TM36_PWM_PWM_MDS                            TM36->PWM.MBIT.PWM_MDS          //[1..0] Timer OC0/1/2/3 PWM mode select.

///@}
/**
 ******************************************************************************
 * @name        TM_BS  [register's definitions]
 *              Offset[0x48]  TM Timer break and stop control register
 ******************************************************************************
 */
///@{
#define TM20_BS                                     TM20->BS.W                      /*!< Offset[0x48]  TM20 Timer stop control register (0x56000048) */
#define TM26_BS                                     TM26->BS.W                      /*!< Offset[0x48]  TM26 Timer stop control register (0x56060048) */
#define TM36_BS                                     TM36->BS.W                      /*!< Offset[0x48]  TM36 Timer break and stop control register (0x56860048) */

/* Bit fields of TM_BS */
#define TM36_BS_STP2N_STA                           TM36->BS.MBIT.STP2N_STA         //[30] Timer BK input active or stop condition output OC2N state select.

#define TM20_BS_STP1N_STA                           TM20->BS.MBIT.STP1N_STA         //[29] Timer BK input active or stop condition output OC1N state select.
#define TM26_BS_STP1N_STA                           TM26->BS.MBIT.STP1N_STA         //[29] Timer BK input active or stop condition output OC1N state select.
#define TM36_BS_STP1N_STA                           TM36->BS.MBIT.STP1N_STA         //[29] Timer BK input active or stop condition output OC1N state select.

#define TM20_BS_STP0N_STA                           TM20->BS.MBIT.STP0N_STA         //[28] Timer BK input active or stop condition output OC0N state select.
#define TM26_BS_STP0N_STA                           TM26->BS.MBIT.STP0N_STA         //[28] Timer BK input active or stop condition output OC0N state select.
#define TM36_BS_STP0N_STA                           TM36->BS.MBIT.STP0N_STA         //[28] Timer BK input active or stop condition output OC0N state select.

#define TM36_BS_STP3_STA                            TM36->BS.MBIT.STP3_STA          //[27] Timer BK input active or stop condition output OC3 state select.

#define TM36_BS_STP2_STA                            TM36->BS.MBIT.STP2_STA          //[26] Timer BK input active or stop condition output OC2 state select.

#define TM20_BS_STP1_STA                            TM20->BS.MBIT.STP1_STA          //[25] Timer BK input active or stop condition output OC1 state select.
#define TM26_BS_STP1_STA                            TM26->BS.MBIT.STP1_STA          //[25] Timer BK input active or stop condition output OC1 state select.
#define TM36_BS_STP1_STA                            TM36->BS.MBIT.STP1_STA          //[25] Timer BK input active or stop condition output OC1 state select.

#define TM20_BS_STP0_STA                            TM20->BS.MBIT.STP0_STA          //[24] Timer BK input active or stop condition output OC0 state select.
#define TM26_BS_STP0_STA                            TM26->BS.MBIT.STP0_STA          //[24] Timer BK input active or stop condition output OC0 state select.
#define TM36_BS_STP0_STA                            TM36->BS.MBIT.STP0_STA          //[24] Timer BK input active or stop condition output OC0 state select.

#define TM36_BS_BK3_CTL                             TM36->BS.MBIT.BK3_CTL           //[23] Timer OC3 output switch control when break event happened

#define TM36_BS_BK2_CTL                             TM36->BS.MBIT.BK2_CTL           //[22] Timer OC2 output switch control when break event happened

#define TM36_BS_BK1_CTL                             TM36->BS.MBIT.BK1_CTL           //[21] Timer OC1 output switch control when break event happened

#define TM36_BS_BK0_CTL                             TM36->BS.MBIT.BK0_CTL           //[20] Timer OC0 output switch control when break event happened

#define TM36_BS_BKI_EN2                             TM36->BS.MBIT.BKI_EN2           //[18] Timer Break internal input channels' enable bit

#define TM36_BS_BKI_EN1                             TM36->BS.MBIT.BKI_EN1           //[17] Timer Break internal input channels' enable bit

#define TM36_BS_BKI_EN0                             TM36->BS.MBIT.BKI_EN0           //[16] Timer Break internal input channels' enable bit

#define TM36_BS_BKE_EN7                             TM36->BS.MBIT.BKE_EN7           //[15] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN6                             TM36->BS.MBIT.BKE_EN6           //[14] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN5                             TM36->BS.MBIT.BKE_EN5           //[13] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN4                             TM36->BS.MBIT.BKE_EN4           //[12] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN3                             TM36->BS.MBIT.BKE_EN3           //[11] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN2                             TM36->BS.MBIT.BKE_EN2           //[10] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN1                             TM36->BS.MBIT.BKE_EN1           //[9] Timer Break external input channels' enable bit

#define TM36_BS_BKE_EN0                             TM36->BS.MBIT.BKE_EN0           //[8] Timer Break external input channels' enable bit

#define TM36_BS_BKSW_EN                             TM36->BS.MBIT.BKSW_EN           //[7] Timer software break input generation enable.

#define TM36_BS_BK_MDS                              TM36->BS.MBIT.BK_MDS            //[4] Timer break event input control mode select.

#define TM36_BS_BK_EN3                              TM36->BS.MBIT.BK_EN3            //[3] Timer Break Input enable for OC3. (output state stop or reset)

#define TM36_BS_BK_EN                               TM36->BS.MBIT.BK_EN             //[0] Timer Break Input enable for OC[2:0]. (output state stop or reset)

///@}
/**
 ******************************************************************************
 * @name        TM_CC0A  [register's definitions]
 *              Offset[0x50]  TM Timer capture and compare register 0A
 ******************************************************************************
 */
///@{
#define TM20_CC0A                                   TM20->CC0A.W                    /*!< Offset[0x50]  TM20 Timer capture and compare register 0A (0x56000050) */
#define TM26_CC0A                                   TM26->CC0A.W                    /*!< Offset[0x50]  TM26 Timer capture and compare register 0A (0x56060050) */
#define TM36_CC0A                                   TM36->CC0A.W                    /*!< Offset[0x50]  TM36 Timer capture and compare register 0A (0x56860050) */

/* Bit fields of TM_CC0A */
#define TM20_CC0A_CC0A                              TM20->CC0A.MBIT.CC0A            //[15..0] TM20 Timer capture and compare register 0A for channel 0
#define TM26_CC0A_CC0A                              TM26->CC0A.MBIT.CC0A            //[15..0] TM26 Timer capture and compare register 0A for channel 0
#define TM36_CC0A_CC0A                              TM36->CC0A.MBIT.CC0A            //[15..0] TM36 Timer capture and compare register 0A for channel 0

///@}
/**
 ******************************************************************************
 * @name        TM_CC0B  [register's definitions]
 *              Offset[0x54]  TM Timer capture and compare register 0B
 ******************************************************************************
 */
///@{
#define TM20_CC0B                                   TM20->CC0B.W                    /*!< Offset[0x54]  TM20 Timer capture and compare register 0B (0x56000054) */
#define TM26_CC0B                                   TM26->CC0B.W                    /*!< Offset[0x54]  TM26 Timer capture and compare register 0B (0x56060054) */
#define TM36_CC0B                                   TM36->CC0B.W                    /*!< Offset[0x54]  TM36 Timer capture and compare register 0B (0x56860054) */

/* Bit fields of TM_CC0B */
#define TM20_CC0B_CC0B                              TM20->CC0B.MBIT.CC0B            //[15..0] TM20 Timer capture and compare register 0B for channel 0
#define TM26_CC0B_CC0B                              TM26->CC0B.MBIT.CC0B            //[15..0] TM26 Timer capture and compare register 0B for channel 0
#define TM36_CC0B_CC0B                              TM36->CC0B.MBIT.CC0B            //[15..0] TM36 Timer capture and compare register 0B for channel 0

///@}
/**
 ******************************************************************************
 * @name        TM_CC1A  [register's definitions]
 *              Offset[0x58]  TM Timer capture and compare register 1A
 ******************************************************************************
 */
///@{
#define TM20_CC1A                                   TM20->CC1A.W                    /*!< Offset[0x58]  TM20 Timer capture and compare register 1A (0x56000058) */
#define TM26_CC1A                                   TM26->CC1A.W                    /*!< Offset[0x58]  TM26 Timer capture and compare register 1A (0x56060058) */
#define TM36_CC1A                                   TM36->CC1A.W                    /*!< Offset[0x58]  TM36 Timer capture and compare register 1A (0x56860058) */

/* Bit fields of TM_CC1A */
#define TM20_CC1A_CC1A                              TM20->CC1A.MBIT.CC1A            //[15..0] TM20 Timer capture and compare register 1A for channel 1
#define TM26_CC1A_CC1A                              TM26->CC1A.MBIT.CC1A            //[15..0] TM26 Timer capture and compare register 1A for channel 1
#define TM36_CC1A_CC1A                              TM36->CC1A.MBIT.CC1A            //[15..0] TM36 Timer capture and compare register 1A for channel 1

///@}
/**
 ******************************************************************************
 * @name        TM_CC1B  [register's definitions]
 *              Offset[0x5c]  TM Timer capture and compare register 1B
 ******************************************************************************
 */
///@{
#define TM20_CC1B                                   TM20->CC1B.W                    /*!< Offset[0x5c]  TM20 Timer capture and compare register 1B (0x5600005C) */
#define TM26_CC1B                                   TM26->CC1B.W                    /*!< Offset[0x5c]  TM26 Timer capture and compare register 1B (0x5606005C) */
#define TM36_CC1B                                   TM36->CC1B.W                    /*!< Offset[0x5c]  TM36 Timer capture and compare register 1B (0x5686005C) */

/* Bit fields of TM_CC1B */
#define TM20_CC1B_CC1B                              TM20->CC1B.MBIT.CC1B            //[15..0] Timer TM20 capture and compare register 1B for channel 1
#define TM26_CC1B_CC1B                              TM26->CC1B.MBIT.CC1B            //[15..0] Timer TM26 capture and compare register 1B for channel 1
#define TM36_CC1B_CC1B                              TM36->CC1B.MBIT.CC1B            //[15..0] TM36 Timer capture and compare register 1B for channel 1

///@}
/**
 ******************************************************************************
 * @name        TM_CC2A  [register's definitions]
 *              Offset[0x60]  TM Timer capture and compare register 2A
 ******************************************************************************
 */
///@{
#define TM36_CC2A                                   TM36->CC2A.W                    /*!< Offset[0x60]  TM36 Timer capture and compare register 2A (0x56860060) */

/* Bit fields of TM_CC2A */
#define TM36_CC2A_CC2A                              TM36->CC2A.MBIT.CC2A            //[15..0] TM36 Timer capture and compare register 2A for channel 2

///@}
/**
 ******************************************************************************
 * @name        TM_CC2B  [register's definitions]
 *              Offset[0x64]  TM Timer capture and compare register 2B
 ******************************************************************************
 */
///@{
#define TM36_CC2B                                   TM36->CC2B.W                    /*!< Offset[0x64]  TM36 Timer capture and compare register 2B (0x56860064) */

/* Bit fields of TM_CC2B */
#define TM36_CC2B_CC2B                              TM36->CC2B.MBIT.CC2B            //[15..0] TM36 Timer capture and compare register 2B for channel 2

///@}
/**
 ******************************************************************************
 * @name        TM_CC3A  [register's definitions]
 *              Offset[0x68]  TM Timer capture and compare register 3A
 ******************************************************************************
 */
///@{
#define TM36_CC3A                                   TM36->CC3A.W                    /*!< Offset[0x68]  TM36 Timer capture and compare register 3A (0x56860068) */

/* Bit fields of TM_CC3A */
#define TM36_CC3A_CC3A                              TM36->CC3A.MBIT.CC3A            //[15..0] TM36 Timer capture and compare register 3A for channel 3

///@}
/**
 ******************************************************************************
 * @name        TM_CC3B  [register's definitions]
 *              Offset[0x6c]  TM Timer capture and compare register 3B
 ******************************************************************************
 */
///@{
#define TM36_CC3B                                   TM36->CC3B.W                    /*!< Offset[0x6c]  TM36 Timer capture and compare register 3B (0x5686006C) */

/* Bit fields of TM_CC3B */
#define TM36_CC3B_CC3B                              TM36->CC3B.MBIT.CC3B            //[15..0] Timer TM36 capture and compare register 3B for channel 3

///@}

/*----------------------------------------------------------------------------*/
/* @module      ADC (ADC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        ADC_STA  [register's definitions]
 *              Offset[0x00]  ADC status register
 ******************************************************************************
 */
///@{
#define ADC0_STA                                    ADC0->STA.W                     /*!< Offset[0x00]  ADC0 status register (0x5B000000) */

/* Bit fields of ADC_STA */
#define ADC0_STA_PHS                                ADC0->STA.MBIT.PHS              //[25] ADC0 sampling phase cycle status bit.

#define ADC0_STA_POF                                ADC0->STA.MBIT.POF              //[24] ADC0 PGA offset calibration status bit.

#define ADC0_STA_SUMOVRF                            ADC0->STA.MBIT.SUMOVRF          //[15] ADC0 data sum-0,1,2  register overrun flag

#define ADC0_STA_SUMCF                              ADC0->STA.MBIT.SUMCF            //[14] ADC0 data sum-0,1,2  accumulation complete flag

#define ADC0_STA_SUMOF                              ADC0->STA.MBIT.SUMOF            //[13] ADC0 data sum-0,1,2 accumulation overflow or underflow flag

#define ADC0_STA_SUMUF                              ADC0->STA.MBIT.SUMUF            //[12] ADC0 data sum-0,1,2 accumulation underflow flag

#define ADC0_STA_WDHF                               ADC0->STA.MBIT.WDHF             //[10] ADC0 voltage window detect outside high event flag

#define ADC0_STA_WDIF                               ADC0->STA.MBIT.WDIF             //[9] ADC0 voltage window detect inside event flag

#define ADC0_STA_WDLF                               ADC0->STA.MBIT.WDLF             //[8] ADC0 voltage window detect outside low event flag

#define ADC0_STA_OVRF                               ADC0->STA.MBIT.OVRF             //[7] ADC0 conversion overrun event flag

#define ADC0_STA_ESCNVF                             ADC0->STA.MBIT.ESCNVF           //[5] ADC0 channel scan conversion end flag

#define ADC0_STA_E1CNVF                             ADC0->STA.MBIT.E1CNVF           //[3] ADC0 one-time conversion end flag

#define ADC0_STA_ESMPF                              ADC0->STA.MBIT.ESMPF            //[2] ADC0 sampling end flag

///@}
/**
 ******************************************************************************
 * @name        ADC_INT  [register's definitions]
 *              Offset[0x04]  ADC interrupt enable register
 ******************************************************************************
 */
///@{
#define ADC0_INT                                    ADC0->INT.W                     /*!< Offset[0x04]  ADC0 interrupt enable register (0x5B000004) */

/* Bit fields of ADC_INT */
#define ADC0_INT_SUMOVR_IE                          ADC0->INT.MBIT.SUMOVR_IE        //[15] ADC0 data sum-0,1,2  overrun event interrupt enable.

#define ADC0_INT_SUMC_IE                            ADC0->INT.MBIT.SUMC_IE          //[14] ADC0 data sum-0,1,2  accumulation complete interrupt enable.

#define ADC0_INT_SUMO_IE                            ADC0->INT.MBIT.SUMO_IE          //[13] ADC0 data sum-0,1,2  accumulation overflow or underflow interrupt enable.

#define ADC0_INT_WDH_IE                             ADC0->INT.MBIT.WDH_IE           //[10] ADC0 voltage window detect outside high event interrupt enable.

#define ADC0_INT_WDI_IE                             ADC0->INT.MBIT.WDI_IE           //[9] ADC0 voltage window detect inside event interrupt enable.

#define ADC0_INT_WDL_IE                             ADC0->INT.MBIT.WDL_IE           //[8] ADC0 voltage window detect outside low event interrupt enable.

#define ADC0_INT_OVR_IE                             ADC0->INT.MBIT.OVR_IE           //[7] ADC0 conversion overrun event interrupt enable.

#define ADC0_INT_ESCNV_IE                           ADC0->INT.MBIT.ESCNV_IE         //[5] ADC0 channel scan conversion end interrupt enable.

#define ADC0_INT_E1CNV_IE                           ADC0->INT.MBIT.E1CNV_IE         //[3] ADC0 one-time conversion end interrupt enable.

#define ADC0_INT_ESMP_IE                            ADC0->INT.MBIT.ESMP_IE          //[2] ADC0 sampling end interrupt enable.

#define ADC0_INT_IEA                                ADC0->INT.MBIT.IEA              //[0] ADC0 interrupt all enable

///@}
/**
 ******************************************************************************
 * @name        ADC_CLK  [register's definitions]
 *              Offset[0x08]  ADC clock source register
 ******************************************************************************
 */
///@{
#define ADC0_CLK                                    ADC0->CLK.W                     /*!< Offset[0x08]  ADC0 clock source register (0x5B000008) */

/* Bit fields of ADC_CLK */
#define ADC0_CLK_CK_DIV2                            ADC0->CLK.MBIT.CK_DIV2          //[11..10] ADC0 input clock CK_PLL divider.

#define ADC0_CLK_CK_SEL2                            ADC0->CLK.MBIT.CK_SEL2          //[9..8] ADC0 internal sampling clock CK_ADC0_INT source select.

#define ADC0_CLK_CK_DIV                             ADC0->CLK.MBIT.CK_DIV           //[5..4] ADC0 internal clock CK_ADC0_INT input divider.

///@}
/**
 ******************************************************************************
 * @name        ADC_WINDTH  [register's definitions]
 *              Offset[0x0C]  ADC window detect threshold register
 ******************************************************************************
 */
///@{
#define ADC0_WINDTH                                 ADC0->WINDTH.W                  /*!< Offset[0x0C]  ADC0 window detect threshold register (0x5B00000C) */

/* Bit fields of ADC_WINDTH */
#define ADC0_WINDTH_WIND_HT                         ADC0->WINDTH.MBIT.WIND_HT       //[27..16] ADC0 voltage window detect higher threshold

#define ADC0_WINDTH_WIND_LT                         ADC0->WINDTH.MBIT.WIND_LT       //[11..0] ADC0 Voltage window detect lower threshold

///@}
/**
 ******************************************************************************
 * @name        ADC_CR0  [register's definitions]
 *              Offset[0x10]  ADC control register 0
 ******************************************************************************
 */
///@{
#define ADC0_CR0                                    ADC0->CR0.W                     /*!< Offset[0x10]  ADC0 control register 0 (0x5B000010) */

/* Bit fields of ADC_CR0 */
#define ADC0_CR0_DMA_EN                             ADC0->CR0.MBIT.DMA_EN           //[31] Direct memory access enable

#define ADC0_CR0_SMP_SEL                            ADC0->CR0.MBIT.SMP_SEL          //[23..16] ADC0 sampling time select from 0T clock to 255T clocks. Value 0 indicates 0T clock.

#define ADC0_CR0_LIM_MDS                            ADC0->CR0.MBIT.LIM_MDS          //[15..14] ADC0 output code spike limit function select

#define ADC0_CR0_CODE_FMT                           ADC0->CR0.MBIT.CODE_FMT         //[8] ADC0 data code output format select

#define ADC0_CR0_RES_SEL                            ADC0->CR0.MBIT.RES_SEL          //[7..6] ADC0 data resolution select. register.

#define ADC0_CR0_DTEST_EN                           ADC0->CR0.MBIT.DTEST_EN         //[5] ADC digital test mode enable for internal using

#define ADC0_CR0_MDS                                ADC0->CR0.MBIT.MDS              //[3] ADC0 conversion mode select

#define ADC0_CR0_WAIT_EN                            ADC0->CR0.MBIT.WAIT_EN          //[2] Wait conversion mode enable for low CPU frequency .

#define ADC0_CR0_AUTOFF_EN                          ADC0->CR0.MBIT.AUTOFF_EN        //[1] Auto-off mode enable

#define ADC0_CR0_EN                                 ADC0->CR0.MBIT.EN               //[0] ADC power-on enable bit.

///@}
/**
 ******************************************************************************
 * @name        ADC_CR1  [register's definitions]
 *              Offset[0x14]  ADC control register 1
 ******************************************************************************
 */
///@{
#define ADC0_CR1                                    ADC0->CR1.W                     /*!< Offset[0x14]  ADC0 control register 1 (0x5B000014) */

/* Bit fields of ADC_CR1 */
#define ADC0_CR1_DOS_VAL                            ADC0->CR1.MBIT.DOS_VAL          //[28..24] ADC adjusted 2s complement value of digital offset adjuster.

#define ADC0_CR1_SUM_NUM                            ADC0->CR1.MBIT.SUM_NUM          //[22..16] ADC0 data sum accumulation data number

#define ADC0_CR1_SUM_MDS                            ADC0->CR1.MBIT.SUM_MDS          //[10] ADC0 data accumulation sum channel mode select

#define ADC0_CR1_SOVR_MDS                           ADC0->CR1.MBIT.SOVR_MDS         //[9] ADC0 data sum overrun mode select.

#define ADC0_CR1_OVR_MDS                            ADC0->CR1.MBIT.OVR_MDS          //[8] ADC0 data buffer overrun mode select.

#define ADC0_CR1_OUT_SEL                            ADC0->CR1.MBIT.OUT_SEL          //[5..4] ADC0_OUT output signal select.

#define ADC0_CR1_ALIGN_SEL                          ADC0->CR1.MBIT.ALIGN_SEL        //[3] ADC0 data alignment select.

#define ADC0_CR1_WIND_MDS                           ADC0->CR1.MBIT.WIND_MDS         //[1] ADC0 Voltage window detect and output code spike limit function channel mode select.

#define ADC0_CR1_WIND_EN                            ADC0->CR1.MBIT.WIND_EN          //[0] ADC0 Voltage window detect enable bit.

///@}
/**
 ******************************************************************************
 * @name        ADC_MSK  [register's definitions]
 *              Offset[0x1C]  ADC channel mask register
 ******************************************************************************
 */
///@{
#define ADC0_MSK                                    ADC0->MSK.W                     /*!< Offset[0x1C]  ADC0 channel mask register (0x5B00001C) */

/* Bit fields of ADC_MSK */
#define ADC0_MSK_SUM2_MUX                           ADC0->MSK.MBIT.SUM2_MUX         //[27..24] ADC0 input channel selection for ADC0 data sum-2 function.

#define ADC0_MSK_SUM1_MUX                           ADC0->MSK.MBIT.SUM1_MUX         //[23..20] ADC0 input channel selection for ADC0 data sum-1 function.

#define ADC0_MSK_SUM0_MUX                           ADC0->MSK.MBIT.SUM0_MUX         //[19..16] Analog input channel selection for ADC0 data sum-0 function.

#define ADC0_MSK_CH_MSK15                           ADC0->MSK.MBIT.CH_MSK15         //[15] ADC0 channel-15 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK14                           ADC0->MSK.MBIT.CH_MSK14         //[14] ADC0 channel-14 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK13                           ADC0->MSK.MBIT.CH_MSK13         //[13] ADC0 channel-13 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK12                           ADC0->MSK.MBIT.CH_MSK12         //[12] ADC0 channel-12 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK11                           ADC0->MSK.MBIT.CH_MSK11         //[11] ADC0 channel-11 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK10                           ADC0->MSK.MBIT.CH_MSK10         //[10] ADC0 channel-10 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK9                            ADC0->MSK.MBIT.CH_MSK9          //[9] ADC0 channel-9 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK8                            ADC0->MSK.MBIT.CH_MSK8          //[8] ADC0 channel-8 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK7                            ADC0->MSK.MBIT.CH_MSK7          //[7] ADC0 channel-7 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK6                            ADC0->MSK.MBIT.CH_MSK6          //[6] ADC0 channel-6 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK5                            ADC0->MSK.MBIT.CH_MSK5          //[5] ADC0 channel-5 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK4                            ADC0->MSK.MBIT.CH_MSK4          //[4] ADC0 channel-4 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK3                            ADC0->MSK.MBIT.CH_MSK3          //[3] ADC0 channel-3 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK2                            ADC0->MSK.MBIT.CH_MSK2          //[2] ADC0 channel-2 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK1                            ADC0->MSK.MBIT.CH_MSK1          //[1] ADC0 channel-1 selection mask for sequence channel scan

#define ADC0_MSK_CH_MSK0                            ADC0->MSK.MBIT.CH_MSK0          //[0] ADC0 channel-0 selection mask for sequence channel scan

///@}
/**
 ******************************************************************************
 * @name        ADC_START  [register's definitions]
 *              Offset[0x20]  ADC start conversion register
 ******************************************************************************
 */
///@{
#define ADC0_START                                  ADC0->START.W                   /*!< Offset[0x20]  ADC0 start conversion register (0x5B000020) */

/* Bit fields of ADC_START */
#define ADC0_START_CONV_MDS                         ADC0->START.MBIT.CONV_MDS       //[25..24] ADC0 conversion mode select.

#define ADC0_START_TRG_SEL                          ADC0->START.MBIT.TRG_SEL        //[21..20] ADC0 start trigger selection

#define ADC0_START_TRG_CONT                         ADC0->START.MBIT.TRG_CONT       //[19] ADC0 start trigger continuous control enable

#define ADC0_START_START_SEL                        ADC0->START.MBIT.START_SEL      //[18..16] ADC0 start control source select.

#define ADC0_START_CH_SEL                           ADC0->START.MBIT.CH_SEL         //[12] ADC0 input channel Mux external or internal channel selection

#define ADC0_START_CH_MUX                           ADC0->START.MBIT.CH_MUX         //[11..8] ADC0 input channel Mux selection

#define ADC0_START_HOLD                             ADC0->START.MBIT.HOLD           //[1] ADC0 hold conversion command.

#define ADC0_START_START                            ADC0->START.MBIT.START          //[0] ADC0 start conversion command. (set by software and clear by hardware)

///@}
/**
 ******************************************************************************
 * @name        ADC_ANA  [register's definitions]
 *              Offset[0x24]  ADC analog control register
 ******************************************************************************
 */
///@{
#define ADC0_ANA                                    ADC0->ANA.W                     /*!< Offset[0x24]  ADC0 analog control register (0x5B000024) */

/* Bit fields of ADC_ANA */
#define ADC0_ANA_BUF_BIAS                           ADC0->ANA.MBIT.BUF_BIAS         //[12] ADC0 input buffer bias current control.

#define ADC0_ANA_PGAOUT_EN                          ADC0->ANA.MBIT.PGAOUT_EN        //[7] ADC0 PGA voltage output enable

#define ADC0_ANA_PGA_EN                             ADC0->ANA.MBIT.PGA_EN           //[2] ADC0 input buffer and PGA enable bit.

///@}
/**
 ******************************************************************************
 * @name        ADC_CAL  [register's definitions]
 *              Offset[0x28]  ADC calibration control register
 ******************************************************************************
 */
///@{
#define ADC0_CAL                                    ADC0->CAL.W                     /*!< Offset[0x28]  ADC0 calibration control register (0x5B000028) */

/* Bit fields of ADC_CAL */
#define ADC0_CAL_REFT                               ADC0->CAL.MBIT.REFT             //[29..24] ADC0 reference voltage top level setting.

#define ADC0_CAL_REFM                               ADC0->CAL.MBIT.REFM             //[21..16] ADC0 reference voltage middle level setting.

#define ADC0_CAL_REFB                               ADC0->CAL.MBIT.REFB             //[13..8] ADC0 reference voltage bottom level setting.

#define ADC0_CAL_CAL_POFFT                          ADC0->CAL.MBIT.CAL_POFFT        //[3] ADC0 PGA offset calibration function enable.

#define ADC0_CAL_CAL_AZEN                           ADC0->CAL.MBIT.CAL_AZEN         //[2] ADC0 calibration auto-zero function enable.

///@}
/**
 ******************************************************************************
 * @name        ADC_GAIN  [register's definitions]
 *              Offset[0x2C]  ADC gain control register
 ******************************************************************************
 */
///@{
#define ADC0_GAIN                                   ADC0->GAIN.W                    /*!< Offset[0x2C]  ADC0 gain control register (0x5B00002C) */

/* Bit fields of ADC_GAIN */
#define ADC0_GAIN_OFFT_PGA                          ADC0->GAIN.MBIT.OFFT_PGA        //[21..16] ADC0 input PGA offset adjust bits.

#define ADC0_GAIN_GAIN_PGA                          ADC0->GAIN.MBIT.GAIN_PGA        //[5..0] ADC input PGA gain adjust bits

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM0  [register's definitions]
 *              Offset[0x30]  ADC accumulator sum result register 0
 ******************************************************************************
 */
///@{
#define ADC0_SUM0                                   ADC0->SUM0.W                    /*!< Offset[0x30]  ADC0 accumulator sum result register 0 (0x5B000030) */

/* Bit fields of ADC_SUM0 */
#define ADC0_SUM0_SUM0_OVRF                         ADC0->SUM0.MBIT.SUM0_OVRF       //[23] ADC0 data sum register-0 overwrite/overrun indication status bit

#define ADC0_SUM0_SUM0_CF                           ADC0->SUM0.MBIT.SUM0_CF         //[22] ADC0 data sum-0 accumulation complete indication status bit

#define ADC0_SUM0_SUM0_OF                           ADC0->SUM0.MBIT.SUM0_OF         //[21] ADC0 data sum-0 accumulation overflow indication status bit

#define ADC0_SUM0_SUM0_UF                           ADC0->SUM0.MBIT.SUM0_UF         //[20] ADC0 data sum-0 accumulation underflow indication status bit

#define ADC0_SUM0_SUM0_DAT                          ADC0->SUM0.MBIT.SUM0_DAT        //[15..0] ADC0 data accumulator sum-0 result.

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM1  [register's definitions]
 *              Offset[0x34]  ADC accumulator sum result register 1
 ******************************************************************************
 */
///@{
#define ADC0_SUM1                                   ADC0->SUM1.W                    /*!< Offset[0x34]  ADC0 accumulator sum result register 1 (0x5B000034) */

/* Bit fields of ADC_SUM1 */
#define ADC0_SUM1_SUM1_OVRF                         ADC0->SUM1.MBIT.SUM1_OVRF       //[23] ADC0 data sum register-1 overwrite/overrun indication status bit

#define ADC0_SUM1_SUM1_CF                           ADC0->SUM1.MBIT.SUM1_CF         //[22] ADC0 data sum-1 accumulation complete indication status bit

#define ADC0_SUM1_SUM1_OF                           ADC0->SUM1.MBIT.SUM1_OF         //[21] ADC0 data sum-1 accumulation overflow indication status bit

#define ADC0_SUM1_SUM1_UF                           ADC0->SUM1.MBIT.SUM1_UF         //[20] ADC0 data sum-1 accumulation underflow indication status bit

#define ADC0_SUM1_SUM1_DAT                          ADC0->SUM1.MBIT.SUM1_DAT        //[15..0] ADC0 data accumulator sum-1 result

///@}
/**
 ******************************************************************************
 * @name        ADC_SUM2  [register's definitions]
 *              Offset[0x38]  ADC accumulator sum result register 2
 ******************************************************************************
 */
///@{
#define ADC0_SUM2                                   ADC0->SUM2.W                    /*!< Offset[0x38]  ADC0 accumulator sum result register 2 (0x5B000038) */

/* Bit fields of ADC_SUM2 */
#define ADC0_SUM2_SUM2_OVRF                         ADC0->SUM2.MBIT.SUM2_OVRF       //[23] ADC0 data sum register-1 overwrite/overrun indication status bit

#define ADC0_SUM2_SUM2_CF                           ADC0->SUM2.MBIT.SUM2_CF         //[22] ADC0 data sum-2 accumulation complete indication status bit

#define ADC0_SUM2_SUM2_OF                           ADC0->SUM2.MBIT.SUM2_OF         //[21] ADC0 data sum-2 accumulation overflow indication status bit

#define ADC0_SUM2_SUM2_UF                           ADC0->SUM2.MBIT.SUM2_UF         //[20] ADC0 data sum-2 accumulation underflow indication status bit

#define ADC0_SUM2_SUM2_DAT                          ADC0->SUM2.MBIT.SUM2_DAT        //[15..0] ADC0 data accumulator sum-2 result

///@}
/**
 ******************************************************************************
 * @name        ADC_TCAL  [register's definitions]
 *              Offset[0x3C]  ADC Temperature Sensor calibration register
 ******************************************************************************
 */
///@{
#define ADC0_TCAL                                   ADC0->TCAL.W                    /*!< Offset[0x3C]  ADC0 Temperature Sensor calibration register (0x5B00003C) */

/* Bit fields of ADC_TCAL */
#define ADC0_TCAL_TCAL1                             ADC0->TCAL.MBIT.TCAL1           //[27..16] Temperature Sensor calibration ADC value 1.

#define ADC0_TCAL_TCAL0                             ADC0->TCAL.MBIT.TCAL0           //[11..0] Temperature Sensor calibration ADC value 0.

///@}
/**
 ******************************************************************************
 * @name        ADC_DAT0  [register's definitions]
 *              Offset[0x40]  ADC conversion data register 0
 ******************************************************************************
 */
///@{
#define ADC0_DAT0                                   ADC0->DAT0.W                    /*!< Offset[0x40]  ADC0 conversion data register 0 (0x5B000040) */

/* Bit fields of ADC_DAT0 */
#define ADC0_DAT0_DAT0_CH                           ADC0->DAT0.MBIT.DAT0_CH         //[31..28] ADC0 data conversion channel number

#define ADC0_DAT0_DAT0_OVRF                         ADC0->DAT0.MBIT.DAT0_OVRF       //[23] ADC0 conversion data register-0 overwrite/overrun indication status bit

#define ADC0_DAT0_DAT0_CF                           ADC0->DAT0.MBIT.DAT0_CF         //[22] ADC0 conversion data-0 complete in 1-time and data ready status bit

#define ADC0_DAT0_DAT0_WDHF                         ADC0->DAT0.MBIT.DAT0_WDHF       //[18] ADC0 voltage window detect outside high event flag

#define ADC0_DAT0_DAT0_WDIF                         ADC0->DAT0.MBIT.DAT0_WDIF       //[17] ADC0 voltage window detect inside event flag

#define ADC0_DAT0_DAT0_WDLF                         ADC0->DAT0.MBIT.DAT0_WDLF       //[16] ADC0 voltage window detect outside low event flag

#define ADC0_DAT0_DAT0                              ADC0->DAT0.MBIT.DAT0            //[15..0] ADC0 conversion data-0

///@}

/*----------------------------------------------------------------------------*/
/* @module      CMP (Analog Comparator)                                       */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CMP_STA  [register's definitions]
 *              Offset[0x00]  CMP Analog comparator status register (0x5C000000)
 ******************************************************************************
 */
///@{
#define CMP_STA                                     CMP->STA.W                      /*!< Offset[0x00]  CMP Analog comparator status register (0x5C000000) */

/* Bit fields of CMP_STA */
#define CMP_STA_AC3_FF                              CMP->STA.MBIT.AC3_FF            //[15] Analog comparator CMP3 falling edge interrupt flag
#define CMP_STA_AC3_RF                              CMP->STA.MBIT.AC3_RF            //[14] Analog comparator CMP3 rising edge interrupt flag
#define CMP_STA_AC3_S                               CMP->STA.MBIT.AC3_S             //[12] Analog comparator CMP3 result status
#define CMP_STA_AC2_FF                              CMP->STA.MBIT.AC2_FF            //[11] Analog comparator CMP2 falling edge interrupt flag
#define CMP_STA_AC2_RF                              CMP->STA.MBIT.AC2_RF            //[10] Analog comparator CMP2 rising edge interrupt flag
#define CMP_STA_AC2_S                               CMP->STA.MBIT.AC2_S             //[8] Analog comparator CMP2 result status
#define CMP_STA_AC1_FF                              CMP->STA.MBIT.AC1_FF            //[7] Analog comparator CMP1 falling edge interrupt flag
#define CMP_STA_AC1_RF                              CMP->STA.MBIT.AC1_RF            //[6] Analog comparator CMP1 rising edge interrupt flag
#define CMP_STA_AC1_S                               CMP->STA.MBIT.AC1_S             //[4] Analog comparator CMP1 result status
#define CMP_STA_AC0_FF                              CMP->STA.MBIT.AC0_FF            //[3] Analog comparator CMP0 falling edge interrupt flag
#define CMP_STA_AC0_RF                              CMP->STA.MBIT.AC0_RF            //[2] Analog comparator CMP0 rising edge interrupt flag
#define CMP_STA_AC0_S                               CMP->STA.MBIT.AC0_S             //[0] Analog comparator CMP0 result status
///@}
/**
 ******************************************************************************
 * @name        CMP_INT  [register's definitions]
 *              Offset[0x04]  CMP Analog comparator interrupt enable register (0x5C000004)
 ******************************************************************************
 */
///@{
#define CMP_INT                                     CMP->INT.W                      /*!< Offset[0x04]  CMP Analog comparator interrupt enable register (0x5C000004) */

/* Bit fields of CMP_INT */
#define CMP_INT_AC3_FIE                             CMP->INT.MBIT.AC3_FIE           //[15] Analog comparator CMP3 falling edge interrupt enable.
#define CMP_INT_AC3_RIE                             CMP->INT.MBIT.AC3_RIE           //[14] Analog comparator CMP3 rising edge interrupt enable.
#define CMP_INT_AC2_FIE                             CMP->INT.MBIT.AC2_FIE           //[11] Analog comparator CMP2 falling edge interrupt enable.
#define CMP_INT_AC2_RIE                             CMP->INT.MBIT.AC2_RIE           //[10] Analog comparator CMP2 rising edge interrupt enable.
#define CMP_INT_AC1_FIE                             CMP->INT.MBIT.AC1_FIE           //[7] Analog comparator CMP1 falling edge interrupt enable.
#define CMP_INT_AC1_RIE                             CMP->INT.MBIT.AC1_RIE           //[6] Analog comparator CMP1 rising edge interrupt enable.
#define CMP_INT_AC0_FIE                             CMP->INT.MBIT.AC0_FIE           //[3] Analog comparator CMP0 falling edge interrupt enable.
#define CMP_INT_AC0_RIE                             CMP->INT.MBIT.AC0_RIE           //[2] Analog comparator CMP0 rising edge interrupt enable.
#define CMP_INT_IEA                                 CMP->INT.MBIT.IEA               //[0] Analog comparator interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        CMP_ANA  [register's definitions]
 *              Offset[0x0C]  CMP Analog comparator analog control register (0x5C00000C)
 ******************************************************************************
 */
///@{
#define CMP_ANA                                     CMP->ANA.W                      /*!< Offset[0x0C]  CMP Analog comparator analog control register (0x5C00000C) */

/* Bit fields of CMP_ANA */
#define CMP_ANA_IVREF2_RS                           CMP->ANA.MBIT.IVREF2_RS         //[15..10] Analog comparator 2nd internal reference (R-ladder) voltage select
#define CMP_ANA_IVREF2_EN                           CMP->ANA.MBIT.IVREF2_EN         //[8] Comparator CMP1 power-on enable bit.
#define CMP_ANA_IVREF_RS                            CMP->ANA.MBIT.IVREF_RS          //[7..2] Analog comparator main internal reference (R-ladder) voltage select
#define CMP_ANA_IVREF_EN                            CMP->ANA.MBIT.IVREF_EN          //[0] Comparator CMP0 power-on enable bit.
///@}
/**
 ******************************************************************************
 * @name        CMP_CR0  [register's definitions]
 *              Offset[0x10]  CMP Analog comparator-0 control register (0x5C000010)
 ******************************************************************************
 */
///@{
#define CMP_CR0                                     CMP->CR0.W                      /*!< Offset[0x10]  CMP Analog comparator-0 control register (0x5C000010) */

/* Bit fields of CMP_CR0 */
#define CMP_CR0_AC0_FDIV                            CMP->CR0.MBIT.AC0_FDIV          //[21..20] CMP0 analog comparator output synchronized filter divider.
#define CMP_CR0_AC0_FSEL                            CMP->CR0.MBIT.AC0_FSEL          //[19..18] CMP0 analog comparator output signal select with synchronized filter
#define CMP_CR0_AC0_PINV                            CMP->CR0.MBIT.AC0_PINV          //[17] CMP0 output to pins' signal inverse enable.
#define CMP_CR0_AC0_INV                             CMP->CR0.MBIT.AC0_INV           //[16] CMP0 analog comparator output signal polarity select.
#define CMP_CR0_AC0_NMUX                            CMP->CR0.MBIT.AC0_NMUX          //[14..12] CMP0 Analog input negative channel selection.
#define CMP_CR0_AC0_PMUX                            CMP->CR0.MBIT.AC0_PMUX          //[10..8] CMP0 Analog input positive channel selection.
#define CMP_CR0_AC0_RES                             CMP->CR0.MBIT.AC0_RES           //[3] CMP0 compare response time select.
#define CMP_CR0_AC0_EN                              CMP->CR0.MBIT.AC0_EN            //[0] Analog comparator CMP0 power-on enable bit
///@}
/**
 ******************************************************************************
 * @name        CMP_CR1  [register's definitions]
 *              Offset[0x14]  CMP Analog comparator-1 control register (0x5C000014)
 ******************************************************************************
 */
///@{
#define CMP_CR1                                     CMP->CR1.W                      /*!< Offset[0x14]  CMP Analog comparator-1 control register (0x5C000014) */

/* Bit fields of CMP_CR1 */
#define CMP_CR1_AC1_FDIV                            CMP->CR1.MBIT.AC1_FDIV          //[21..20] CMP1 analog comparator output synchronized filter divider.
#define CMP_CR1_AC1_FSEL                            CMP->CR1.MBIT.AC1_FSEL          //[19..18] CMP1 analog comparator output signal select with synchronized filter
#define CMP_CR1_AC1_PINV                            CMP->CR1.MBIT.AC1_PINV          //[17] CMP1 output to pins' signal inverse enable.
#define CMP_CR1_AC1_INV                             CMP->CR1.MBIT.AC1_INV           //[16] CMP1 analog comparator output signal polarity select.
#define CMP_CR1_AC1_NMUX                            CMP->CR1.MBIT.AC1_NMUX          //[14..12] CMP1 Analog input negative channel selection.
#define CMP_CR1_AC1_PMUX                            CMP->CR1.MBIT.AC1_PMUX          //[10..8] CMP1 Analog input positive channel selection.
#define CMP_CR1_AC1_RES                             CMP->CR1.MBIT.AC1_RES           //[3] CMP1 compare response time select.
#define CMP_CR1_AC1_EN                              CMP->CR1.MBIT.AC1_EN            //[0] Analog comparator CMP1 power-on enable bit
///@}
/**
 ******************************************************************************
 * @name        CMP_CR2  [register's definitions]
 *              Offset[0x18]  CMP Analog comparator-2 control register (0x5C000018)
 ******************************************************************************
 */
///@{
#define CMP_CR2                                     CMP->CR2.W                      /*!< Offset[0x18]  CMP Analog comparator-2 control register (0x5C000018) */

/* Bit fields of CMP_CR2 */
#define CMP_CR2_AC2_FDIV                            CMP->CR2.MBIT.AC2_FDIV          //[21..20] CMP2 analog comparator output synchronized filter divider.
#define CMP_CR2_AC2_FSEL                            CMP->CR2.MBIT.AC2_FSEL          //[19..18] CMP2 analog comparator output signal select with synchronized filter
#define CMP_CR2_AC2_PINV                            CMP->CR2.MBIT.AC2_PINV          //[17] CMP2 output to pins' signal inverse enable.
#define CMP_CR2_AC2_INV                             CMP->CR2.MBIT.AC2_INV           //[16] CMP2 analog comparator output signal polarity select.
#define CMP_CR2_AC2_NMUX                            CMP->CR2.MBIT.AC2_NMUX          //[14..12] CMP2 Analog input negative channel selection.
#define CMP_CR2_AC2_PMUX                            CMP->CR2.MBIT.AC2_PMUX          //[10..8] CMP2 Analog input positive channel selection.
#define CMP_CR2_AC2_RES                             CMP->CR2.MBIT.AC2_RES           //[3] CMP2 compare response time select.
#define CMP_CR2_AC2_EN                              CMP->CR2.MBIT.AC2_EN            //[0] Analog comparator CMP2 power-on enable bit
///@}
/**
 ******************************************************************************
 * @name        CMP_CR3  [register's definitions]
 *              Offset[0x1C]  CMP Analog comparator-3 control register (0x5C00001C)
 ******************************************************************************
 */
///@{
#define CMP_CR3                                     CMP->CR3.W                      /*!< Offset[0x1C]  CMP Analog comparator-3 control register (0x5C00001C) */

/* Bit fields of CMP_CR3 */
#define CMP_CR3_AC3_FDIV                            CMP->CR3.MBIT.AC3_FDIV          //[21..20] CMP3 analog comparator output synchronized filter divider.
#define CMP_CR3_AC3_FSEL                            CMP->CR3.MBIT.AC3_FSEL          //[19..18] CMP3 analog comparator output signal select with synchronized filter
#define CMP_CR3_AC3_PINV                            CMP->CR3.MBIT.AC3_PINV          //[17] CMP3 output to pins' signal inverse enable.
#define CMP_CR3_AC3_INV                             CMP->CR3.MBIT.AC3_INV           //[16] CMP3 analog comparator output signal polarity select.
#define CMP_CR3_AC3_NMUX                            CMP->CR3.MBIT.AC3_NMUX          //[14..12] CMP3 Analog input negative channel selection.
#define CMP_CR3_AC3_PMUX                            CMP->CR3.MBIT.AC3_PMUX          //[10..8] CMP3 Analog input positive channel selection.
#define CMP_CR3_AC3_RES                             CMP->CR3.MBIT.AC3_RES           //[3] CMP3 compare response time select.
#define CMP_CR3_AC3_EN                              CMP->CR3.MBIT.AC3_EN            //[0] Analog comparator CMP3 power-on enable bit
///@}

/*----------------------------------------------------------------------------*/
/* @module      DAC (DAC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        DAC_STA  [register's definitions]
 *              Offset[0x00]  DAC status register (0x5C080000)
 ******************************************************************************
 */
///@{
#define DAC_STA                                     DAC->STA.W                      /*!< Offset[0x00]  DAC status register (0x5C080000) */

/* Bit fields of DAC_STA */
#define DAC_STA_UDR0F                               DAC->STA.MBIT.UDR0F             //[7] DAC-0 conversion underrun event flag
#define DAC_STA_RDY0F                               DAC->STA.MBIT.RDY0F             //[1] DAC-0 ready flag to update new data to data register
///@}
/**
 ******************************************************************************
 * @name        DAC_INT  [register's definitions]
 *              Offset[0x04]  DAC interrupt enable register (0x5C080004)
 ******************************************************************************
 */
///@{
#define DAC_INT                                     DAC->INT.W                      /*!< Offset[0x04]  DAC interrupt enable register (0x5C080004) */

/* Bit fields of DAC_INT */
#define DAC_INT_UDR0_IE                             DAC->INT.MBIT.UDR0_IE           //[7] DAC-0 conversion underrun event interrupt enable.
#define DAC_INT_RDY0_IE                             DAC->INT.MBIT.RDY0_IE           //[1] DAC-0 ready to update new data to data register interrupt enable.
#define DAC_INT_IEA                                 DAC->INT.MBIT.IEA               //[0] DAC interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        DAC_CR0  [register's definitions]
 *              Offset[0x10]  DAC control register 0 (0x5C080010)
 ******************************************************************************
 */
///@{
#define DAC_CR0                                     DAC->CR0.W                      /*!< Offset[0x10]  DAC control register 0 (0x5C080010) */

/* Bit fields of DAC_CR0 */
#define DAC_CR0_DMA_EN                              DAC->CR0.MBIT.DMA_EN            //[31] Direct memory access enable to transmit
#define DAC_CR0_TRG0_SEL                            DAC->CR0.MBIT.TRG0_SEL          //[13..12] DAC-0 start trigger selection
#define DAC_CR0_START0_SEL                          DAC->CR0.MBIT.START0_SEL        //[10..8] DAC-0 start trigger control source select
#define DAC_CR0_RES0_SEL                            DAC->CR0.MBIT.RES0_SEL          //[6] DAC-0 data resolution select
#define DAC_CR0_ALIGN0_SEL                          DAC->CR0.MBIT.ALIGN0_SEL        //[4] DAC-0 data alignment select.
#define DAC_CR0_CMOD0_SEL                           DAC->CR0.MBIT.CMOD0_SEL         //[3..2] DAC-0 output current mode select.
#define DAC_CR0_DA0_EN                              DAC->CR0.MBIT.DA0_EN            //[0] DAC-0 power-on enable bit.
///@}
/**
 ******************************************************************************
 * @name        DAC_DAT0  [register's definitions]
 *              Offset[0x20]  DAC conversion data register 0 (0x5C080020)
 ******************************************************************************
 */
///@{
#define DAC_DAT0                                    DAC->DAT0.W                     /*!< Offset[0x20]  DAC conversion data register 0 (0x5C080020) */

/* Bit fields of DAC_DAT0 */
#define DAC_DAT0_DAT0                               DAC->DAT0.MBIT.DAT0             //[15..0] DAC-0 conversion data register
///@}
/**
 ******************************************************************************
 * @name        DAC_DOR0  [register's definitions]
 *              Offset[0x28]  DAC conversion output register 0 (0x5C080028)
 ******************************************************************************
 */
///@{
#define DAC_DOR0                                    DAC->DOR0.W                     /*!< Offset[0x28]  DAC conversion output register 0 (0x5C080028) */

/* Bit fields of DAC_DOR0 */
#define DAC_DOR0_DOR0                               DAC->DOR0.MBIT.DOR0             //[15..0] DAC-0 conversion output register
///@}

/*----------------------------------------------------------------------------*/
/* @module      IWDT (IWDT Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        IWDT_STA  [register's definitions]
 *              Offset[0x00]  IWDT status register (0x5D000000)
 ******************************************************************************
 */
///@{
#define IWDT_STA                                    IWDT->STA.W                     /*!< Offset[0x00]  IWDT status register (0x5D000000) */

/* Bit fields of IWDT_STA */
#define IWDT_STA_EW1F                               IWDT->STA.MBIT.EW1F             //[3] IWDT early wakeup-1 flag
#define IWDT_STA_EW0F                               IWDT->STA.MBIT.EW0F             //[2] IWDT early wakeup-0 flag
#define IWDT_STA_TF                                 IWDT->STA.MBIT.TF               //[1] IWDT timer timeout interrupt flag. (set by hardware and clear by software writing 1)
///@}
/**
 ******************************************************************************
 * @name        IWDT_INT  [register's definitions]
 *              Offset[0x04]  IWDT interrupt enable register (0x5D000004)
 ******************************************************************************
 */
///@{
#define IWDT_INT                                    IWDT->INT.W                     /*!< Offset[0x04]  IWDT interrupt enable register (0x5D000004) */

/* Bit fields of IWDT_INT */
#define IWDT_INT_EW1_IE                             IWDT->INT.MBIT.EW1_IE           //[3] IWDT early wakeup-1 interrupt enable.
#define IWDT_INT_EW0_IE                             IWDT->INT.MBIT.EW0_IE           //[2] IWDT early wakeup-0 interrupt enable.
#define IWDT_INT_TIE                                IWDT->INT.MBIT.TIE              //[1] IWDT timer timeout interrupt enable.
///@}
/**
 ******************************************************************************
 * @name        IWDT_CLK  [register's definitions]
 *              Offset[0x08]  IWDT clock source register (0x5D000008)
 ******************************************************************************
 */
///@{
#define IWDT_CLK                                    IWDT->CLK.W                     /*!< Offset[0x08]  IWDT clock source register (0x5D000008) */

/* Bit fields of IWDT_CLK */
#define IWDT_CLK_CK_DIV                             IWDT->CLK.MBIT.CK_DIV           //[7..4] IWDT internal clock CK_IWDT_INT input divider
///@}
/**
 ******************************************************************************
 * @name        IWDT_KEY  [register's definitions]
 *              Offset[0x0C]  IWDT write protected Key register (0x5D00000C)
 ******************************************************************************
 */
///@{
#define IWDT_KEY                                    IWDT->KEY.W                     /*!< Offset[0x0C]  IWDT write protected Key register (0x5D00000C) */

/* Bit fields of IWDT_KEY */
#define IWDT_KEY_LOCK                               IWDT->KEY.MBIT.LOCK             //[31..16] IWDT lock register
#define IWDT_KEY_KEY                                IWDT->KEY.MBIT.KEY              //[15..0] IWDT key register and counter reload enable control
///@}
/**
 ******************************************************************************
 * @name        IWDT_CR0  [register's definitions]
 *              Offset[0x10]  IWDT control register 0 (0x5D000010)
 ******************************************************************************
 */
///@{
#define IWDT_CR0                                    IWDT->CR0.W                     /*!< Offset[0x10]  IWDT control register 0 (0x5D000010) */

/* Bit fields of IWDT_CR0 */
#define IWDT_CR0_EW1_WPEN                           IWDT->CR0.MBIT.EW1_WPEN         //[11] IWDT detect IWDT_EW1F flag wakeup from STOP mode enable bit.
#define IWDT_CR0_EW0_WPEN                           IWDT->CR0.MBIT.EW0_WPEN         //[10] IWDT detect IWDT_EW0F flag wakeup from STOP mode enable bit.
#define IWDT_CR0_TF_WPEN                            IWDT->CR0.MBIT.TF_WPEN          //[8] IWDT detect IWDT_TF flag wakeup from STOP mode enable bit.
#define IWDT_CR0_EN                                 IWDT->CR0.MBIT.EN               //[0] IWDT function enable bit
///@}
/**
 ******************************************************************************
 * @name        IWDT_CNT  [register's definitions]
 *              Offset[0x18]  IWDT counter register (0x5D000018)
 ******************************************************************************
 */
///@{
#define IWDT_CNT                                    IWDT->CNT.W                     /*!< Offset[0x18]  IWDT counter register (0x5D000018) */

/* Bit fields of IWDT_CNT */
#define IWDT_CNT_CNT                                IWDT->CNT.MBIT.CNT              //[7..0] IWDT counter value register.
///@}

/*----------------------------------------------------------------------------*/
/* @module      WWDT (WWDT Control)                                           */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        WWDT_STA  [register's definitions]
 *              Offset[0x00]  WWDT status register (0x5D010000)
 ******************************************************************************
 */
///@{
#define WWDT_STA                                    WWDT->STA.W                     /*!< Offset[0x00]  WWDT status register (0x5D010000) */

/* Bit fields of WWDT_STA */
#define WWDT_STA_WRNF                               WWDT->STA.MBIT.WRNF             //[3] WWDT counter warning flag
#define WWDT_STA_WINF                               WWDT->STA.MBIT.WINF             //[2] WWDT counter refreshing and value over the window compare threshold condition flag
#define WWDT_STA_TF                                 WWDT->STA.MBIT.TF               //[1] WWDT timer timeout interrupt flag. (set by hardware and clear by software writing 1)
///@}
/**
 ******************************************************************************
 * @name        WWDT_INT  [register's definitions]
 *              Offset[0x04]  WWDT interrupt enable register (0x5D010004)
 ******************************************************************************
 */
///@{
#define WWDT_INT                                    WWDT->INT.W                     /*!< Offset[0x04]  WWDT interrupt enable register (0x5D010004) */

/* Bit fields of WWDT_INT */
#define WWDT_INT_WRN_IE                             WWDT->INT.MBIT.WRN_IE           //[3] WWDT counter warning interrupt enable.
#define WWDT_INT_WIN_IE                             WWDT->INT.MBIT.WIN_IE           //[2] WWDT counter refreshing and value over the window compare threshold condition interru
#define WWDT_INT_TIE                                WWDT->INT.MBIT.TIE              //[1] WWDT timer timeout interrupt enable.
///@}
/**
 ******************************************************************************
 * @name        WWDT_CLK  [register's definitions]
 *              Offset[0x08]  WWDT clock source register (0x5D010008)
 ******************************************************************************
 */
///@{
#define WWDT_CLK                                    WWDT->CLK.W                     /*!< Offset[0x08]  WWDT clock source register (0x5D010008) */

/* Bit fields of WWDT_CLK */
#define WWDT_CLK_CK_PDIV                            WWDT->CLK.MBIT.CK_PDIV          //[8] WWDT internal clock CK_WWDT_INT pre-divider value.
#define WWDT_CLK_CK_DIV                             WWDT->CLK.MBIT.CK_DIV           //[6..4] WWDT internal clock CK_WWDT_INT input divider.
#define WWDT_CLK_CK_SEL                             WWDT->CLK.MBIT.CK_SEL           //[2] WWDT input clock CK_WWDT source select.
///@}
/**
 ******************************************************************************
 * @name        WWDT_KEY  [register's definitions]
 *              Offset[0x0C]  WWDT write protected Key register (0x5D01000C)
 ******************************************************************************
 */
///@{
#define WWDT_KEY                                    WWDT->KEY.W                     /*!< Offset[0x0C]  WWDT write protected Key register (0x5D01000C) */

/* Bit fields of WWDT_KEY */
#define WWDT_KEY_KEY                                WWDT->KEY.MBIT.KEY              //[15..0] WWDT key register and counter reload enable control
///@}
/**
 ******************************************************************************
 * @name        WWDT_CR0  [register's definitions]
 *              Offset[0x10]  WWDT control register 0 (0x5D010010)
 ******************************************************************************
 */
///@{
#define WWDT_CR0                                    WWDT->CR0.W                     /*!< Offset[0x10]  WWDT control register 0 (0x5D010010) */

/* Bit fields of WWDT_CR0 */
#define WWDT_CR0_RSTW_EN                            WWDT->CR0.MBIT.RSTW_EN          //[5] WWDT reload counter out of window reset generation enable bit.
#define WWDT_CR0_RSTF_EN                            WWDT->CR0.MBIT.RSTF_EN          //[4] WWDT timer underflow reset generation enable bit.
#define WWDT_CR0_EN                                 WWDT->CR0.MBIT.EN               //[0] WWDT function enable bit. When disables, WWDT_CNT will keep the counter value.
///@}
/**
 ******************************************************************************
 * @name        WWDT_CNT  [register's definitions]
 *              Offset[0x18]  WWDT counter register (0x5D010018)
 ******************************************************************************
 */
///@{
#define WWDT_CNT                                    WWDT->CNT.W                     /*!< Offset[0x18]  WWDT counter register (0x5D010018) */

/* Bit fields of WWDT_CNT */
#define WWDT_CNT_CNT                                WWDT->CNT.MBIT.CNT              //[9..0] WWDT counter value register.
///@}
/**
 ******************************************************************************
 * @name        WWDT_RLR  [register's definitions]
 *              Offset[0x1C]  WWDT reload register (0x5D01001C)
 ******************************************************************************
 */
///@{
#define WWDT_RLR                                    WWDT->RLR.W                     /*!< Offset[0x1C]  WWDT reload register (0x5D01001C) */

/* Bit fields of WWDT_RLR */
#define WWDT_RLR_RLR                                WWDT->RLR.MBIT.RLR              //[9..0] WWDT counter reload register.
///@}
/**
 ******************************************************************************
 * @name        WWDT_WIN  [register's definitions]
 *              Offset[0x20]  WWDT window compare register (0x5D010020)
 ******************************************************************************
 */
///@{
#define WWDT_WIN                                    WWDT->WIN.W                     /*!< Offset[0x20]  WWDT window compare register (0x5D010020) */

/* Bit fields of WWDT_WIN */
#define WWDT_WIN_WIN                                WWDT->WIN.MBIT.WIN              //[9..0] WWDT window compare threshold register.
///@}
/**
 ******************************************************************************
 * @name        WWDT_WRN  [register's definitions]
 *              Offset[0x24]  WWDT warning compare register (0x5D010024)
 ******************************************************************************
 */
///@{
#define WWDT_WRN                                    WWDT->WRN.W                     /*!< Offset[0x24]  WWDT warning compare register (0x5D010024) */

/* Bit fields of WWDT_WRN */
#define WWDT_WRN_WRN                                WWDT->WRN.MBIT.WRN              //[9..0] WWDT warning interrupt compare threshold register.
///@}

/*----------------------------------------------------------------------------*/
/* @module      RTC (RTC Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        RTC_STA  [register's definitions]
 *              Offset[0x00]  RTC status register (0x5D040000)
 ******************************************************************************
 */
///@{
#define RTC_STA                                     RTC->STA.W                      /*!< Offset[0x00]  RTC status register (0x5D040000) */

/* Bit fields of RTC_STA */
#define RTC_STA_RCRF                                RTC->STA.MBIT.RCRF              //[5] RTC reload or capture flag
#define RTC_STA_TOF                                 RTC->STA.MBIT.TOF               //[4] RTC timer overflow interrupt flag. (set by hardware and clear by software writing 1)
#define RTC_STA_TSF                                 RTC->STA.MBIT.TSF               //[3] RTC time stamp interrupt flag. (set by hardware and clear by software writing 1)
#define RTC_STA_PCF                                 RTC->STA.MBIT.PCF               //[2] RTC periodic interrupt flag. (set by hardware and clear by software writing 1)
#define RTC_STA_ALMF                                RTC->STA.MBIT.ALMF              //[1] RTC alarm matched interrupt flag. (set by hardware and clear by software writing 1)
///@}
/**
 ******************************************************************************
 * @name        RTC_INT  [register's definitions]
 *              Offset[0x04]  RTC interrupt enable register (0x5D040004)
 ******************************************************************************
 */
///@{
#define RTC_INT                                     RTC->INT.W                      /*!< Offset[0x04]  RTC interrupt enable register (0x5D040004) */

/* Bit fields of RTC_INT */
#define RTC_INT_RCR_IE                              RTC->INT.MBIT.RCR_IE            //[5] RTC_RCR register reload finished, software capture finished or RTC_ALM register value
#define RTC_INT_TIE                                 RTC->INT.MBIT.TIE               //[4] RTC timer overflow interrupt enable.
#define RTC_INT_TS_IE                               RTC->INT.MBIT.TS_IE             //[3] RTC time stamp interrupt enable.
#define RTC_INT_PC_IE                               RTC->INT.MBIT.PC_IE             //[2] RTC periodic interrupt enable.
#define RTC_INT_ALM_IE                              RTC->INT.MBIT.ALM_IE            //[1] RTC alarm matched interrupt enable.
#define RTC_INT_IEA                                 RTC->INT.MBIT.IEA               //[0] RTC interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        RTC_CLK  [register's definitions]
 *              Offset[0x08]  RTC clock source register (0x5D040008)
 ******************************************************************************
 */
///@{
#define RTC_CLK                                     RTC->CLK.W                      /*!< Offset[0x08]  RTC clock source register (0x5D040008) */

/* Bit fields of RTC_CLK */
#define RTC_CLK_CK_PDIV                             RTC->CLK.MBIT.CK_PDIV           //[7] RTC internal clock CK_RTC_INT input pre-divider
#define RTC_CLK_CK_DIV                              RTC->CLK.MBIT.CK_DIV            //[5..4] RTC internal clock CK_RTC_INT input divider
#define RTC_CLK_CK_SEL                              RTC->CLK.MBIT.CK_SEL            //[3..2] RTC input clock CK_RTC source select.
///@}
/**
 ******************************************************************************
 * @name        RTC_KEY  [register's definitions]
 *              Offset[0x0C]  RTC write protected Key register (0x5D04000C)
 ******************************************************************************
 */
///@{
#define RTC_KEY                                     RTC->KEY.W                      /*!< Offset[0x0C]  RTC write protected Key register (0x5D04000C) */

/* Bit fields of RTC_KEY */
#define RTC_KEY_LOCK                                RTC->KEY.MBIT.LOCK              //[31..16] RTC lock register
#define RTC_KEY_KEY                                 RTC->KEY.MBIT.KEY               //[15..0] RTC key register
///@}
/**
 ******************************************************************************
 * @name        RTC_CR0  [register's definitions]
 *              Offset[0x10]  RTC control register 0 (0x5D040010)
 ******************************************************************************
 */
///@{
#define RTC_CR0                                     RTC->CR0.W                      /*!< Offset[0x10]  RTC control register 0 (0x5D040010) */

/* Bit fields of RTC_CR0 */
#define RTC_CR0_TF_WPEN                             RTC->CR0.MBIT.TF_WPEN           //[19] RTC detect RTC_TOF flag wakeup from STOP mode enable bit.
#define RTC_CR0_PC_WPEN                             RTC->CR0.MBIT.PC_WPEN           //[17] RTC detect RTC_PCF flag wakeup from STOP mode enable bit.
#define RTC_CR0_ALM_WPEN                            RTC->CR0.MBIT.ALM_WPEN          //[16] RTC detect RTC_ALMF flag wakeup from STOP mode enable bit.
#define RTC_CR0_OUT_LCK                             RTC->CR0.MBIT.OUT_LCK           //[15] RTC_OUT output signal initial state control
#define RTC_CR0_OUT_STA                             RTC->CR0.MBIT.OUT_STA           //[14] RTC_OUT output signal initial state
#define RTC_CR0_TS_TRGS                             RTC->CR0.MBIT.TS_TRGS           //[13..12] RTC time stamp trigger edge select.
#define RTC_CR0_OUT_SEL                             RTC->CR0.MBIT.OUT_SEL           //[9..8] RTC output signal select
#define RTC_CR0_RCR_MDS                             RTC->CR0.MBIT.RCR_MDS           //[5..4] RTC timer reload or capture control mode select
#define RTC_CR0_ALM_EN                              RTC->CR0.MBIT.ALM_EN            //[1] RTC Alarm enable bit
#define RTC_CR0_EN                                  RTC->CR0.MBIT.EN                //[0] RTC function enable bit.
///@}
/**
 ******************************************************************************
 * @name        RTC_CR1  [register's definitions]
 *              Offset[0x14]  RTC control register 1 (0x5D040014)
 ******************************************************************************
 */
///@{
#define RTC_CR1                                     RTC->CR1.W                      /*!< Offset[0x14]  RTC control register 1 (0x5D040014) */

/* Bit fields of RTC_CR1 */
#define RTC_CR1_RC_START                            RTC->CR1.MBIT.RC_START          //[0] RTC timer counter reload and software capture start enable
///@}
/**
 ******************************************************************************
 * @name        RTC_RLR  [register's definitions]
 *              Offset[0x18]  RTC reload register (0x5D040018)
 ******************************************************************************
 */
///@{
#define RTC_RLR                                     RTC->RLR.W                      /*!< Offset[0x18]  RTC reload register (0x5D040018) */

/* Bit fields of RTC_RLR */
#define RTC_RLR_RLR                                 RTC->RLR.MBIT.RLR               //[31..0] RTC counter reload register. The value 0xFFFFFFFF is invalid.
///@}
/**
 ******************************************************************************
 * @name        RTC_ALM  [register's definitions]
 *              Offset[0x1C]  RTC alarm compare register (0x5D04001C)
 ******************************************************************************
 */
///@{
#define RTC_ALM                                     RTC->ALM.W                      /*!< Offset[0x1C]  RTC alarm compare register (0x5D04001C) */

/* Bit fields of RTC_ALM */
#define RTC_ALM_ALM                                 RTC->ALM.MBIT.ALM               //[31..0] RTC alarm compared value register
///@}
/**
 ******************************************************************************
 * @name        RTC_CAP  [register's definitions]
 *              Offset[0x20]  RTC capture register (0x5D040020)
 ******************************************************************************
 */
///@{
#define RTC_CAP                                     RTC->CAP.W                      /*!< Offset[0x20]  RTC capture register (0x5D040020) */

/* Bit fields of RTC_CAP */
#define RTC_CAP_CAP                                 RTC->CAP.MBIT.CAP               //[31..0] RTC counter capture register
///@}

/*----------------------------------------------------------------------------*/
/* @module      APB (APB Control)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        APB_STA  [register's definitions]
 *              Offset[0x00]  APB status register (0x5F000000)
 ******************************************************************************
 */
///@{
#define APB_STA                                     APB->STA.W                      /*!< Offset[0x00]  APB status register (0x5F000000) */

/* Bit fields of APB_STA */
#define APB_STA_OBM1_SW                             APB->STA.MBIT.OBM1_SW           //[25] OBM-1 break switching signal status.
#define APB_STA_OBM1_OUT                            APB->STA.MBIT.OBM1_OUT          //[17] OBM-1 output signal status.
#define APB_STA_OBM1F                               APB->STA.MBIT.OBM1F             //[9] OBM-1 break trigger event detect flag
///@}
/**
 ******************************************************************************
 * @name        APB_INT  [register's definitions]
 *              Offset[0x04]  APB interrupt enable register (0x5F000004)
 ******************************************************************************
 */
///@{
#define APB_INT                                     APB->INT.W                      /*!< Offset[0x04]  APB interrupt enable register (0x5F000004) */

/* Bit fields of APB_INT */
#define APB_INT_OBM1_IE                             APB->INT.MBIT.OBM1_IE           //[9] OBM-1 break trigger event detect interrupt enable.
#define APB_INT_IEA                                 APB->INT.MBIT.IEA               //[0] APB interrupt all enable
///@}
/**
 ******************************************************************************
 * @name        APB_CR0  [register's definitions]
 *              Offset[0x10]  APB global control register 0 (0x5F000010)
 ******************************************************************************
 */
///@{
#define APB_CR0                                     APB->CR0.W                      /*!< Offset[0x10]  APB global control register 0 (0x5F000010) */

/* Bit fields of APB_CR0 */
#define APB_CR0_IRDAT_MUX                           APB->CR0.MBIT.IRDAT_MUX         //[14..12] IR data envelope signal source select.
#define APB_CR0_IRCLK_MUX                           APB->CR0.MBIT.IRCLK_MUX         //[10..8] IR carrier clock source select.
#define APB_CR0_IRDAT_INV                           APB->CR0.MBIT.IRDAT_INV         //[5] IR data envelope signal inverse enable bit.
#define APB_CR0_IRCLK_INV                           APB->CR0.MBIT.IRCLK_INV         //[4] IR clock signal inverse enable bit.
///@}
/**
 ******************************************************************************
 * @name        APB_CR1  [register's definitions]
 *              Offset[0x14]  APB global control register 1 (0x5F000014)
 ******************************************************************************
 */
///@{
#define APB_CR1                                     APB->CR1.W                      /*!< Offset[0x14]  APB global control register 1 (0x5F000014) */

/* Bit fields of APB_CR1 */
#define APB_CR1_TM36_EN2                            APB->CR1.MBIT.TM36_EN2          //[31] TM36 2nd Timer/Counter enable bit.
#define APB_CR1_TM26_EN2                            APB->CR1.MBIT.TM26_EN2          //[27] TM26 2nd Timer/Counter enable bit.
#define APB_CR1_TM20_EN2                            APB->CR1.MBIT.TM20_EN2          //[24] TM20 2nd Timer/Counter enable bit.
#define APB_CR1_TM16_EN2                            APB->CR1.MBIT.TM16_EN2          //[23] TM16 2nd Timer/Counter enable bit.
#define APB_CR1_TM10_EN2                            APB->CR1.MBIT.TM10_EN2          //[20] TM10 2nd Timer/Counter enable bit.
#define APB_CR1_TM01_EN2                            APB->CR1.MBIT.TM01_EN2          //[17] TM01 2nd Timer/Counter enable bit.
#define APB_CR1_TM00_EN2                            APB->CR1.MBIT.TM00_EN2          //[16] TM00 2nd Timer/Counter enable bit.
#define APB_CR1_TM36_EN                             APB->CR1.MBIT.TM36_EN           //[15] TM36 main Timer/Counter enable bit.
#define APB_CR1_TM26_EN                             APB->CR1.MBIT.TM26_EN           //[11] TM26 main Timer/Counter enable bit.
#define APB_CR1_TM20_EN                             APB->CR1.MBIT.TM20_EN           //[8] TM20 main Timer/Counter enable bit.
#define APB_CR1_TM16_EN                             APB->CR1.MBIT.TM16_EN           //[7] TM16 main Timer/Counter enable bit.
#define APB_CR1_TM10_EN                             APB->CR1.MBIT.TM10_EN           //[4] TM10 main Timer/Counter enable bit.
#define APB_CR1_TM01_EN                             APB->CR1.MBIT.TM01_EN           //[1] TM01 main Timer/Counter enable bit.
#define APB_CR1_TM00_EN                             APB->CR1.MBIT.TM00_EN           //[0] TM00 main Timer/Counter enable bit.
///@}
/**
 ******************************************************************************
 * @name        APB_CR2  [register's definitions]
 *              Offset[0x18]  APB global control register 2 (0x5F000018)
 ******************************************************************************
 */
///@{
#define APB_CR2                                     APB->CR2.W                      /*!< Offset[0x18]  APB global control register 2 (0x5F000018) */

/* Bit fields of APB_CR2 */
#define APB_CR2_ITR7_MUX                            APB->CR2.MBIT.ITR7_MUX          //[7..4] Timer internal common trigger source ITR7 source select
#define APB_CR2_ITR6_MUX                            APB->CR2.MBIT.ITR6_MUX          //[2..0] Timer internal common trigger source ITR6 source select
///@}
/**
 ******************************************************************************
 * @name        APB_OBM10  [register's definitions]
 *              Offset[0x28]  APB OBM1 control register-0 (0x5F000028)
 ******************************************************************************
 */
///@{
#define APB_OBM10                                   APB->OBM10.W                    /*!< Offset[0x28]  APB OBM1 control register-0 (0x5F000028) */

/* Bit fields of APB_OBM10 */
#define APB_OBM10_OBM1_BKS2                         APB->OBM10.MBIT.OBM1_BKS2       //[27..24] OBM1 break signal source channel-2 select.
#define APB_OBM10_OBM1_BKS1                         APB->OBM10.MBIT.OBM1_BKS1       //[23..20] OBM1 break signal source channel-1 select.
#define APB_OBM10_OBM1_BKS0                         APB->OBM10.MBIT.OBM1_BKS0       //[19..16] OBM1 break signal source channel-0 select.
#define APB_OBM10_OBM1_BKN2                         APB->OBM10.MBIT.OBM1_BKN2       //[10] OBM1 break source-2 signal inverse enable bit.
#define APB_OBM10_OBM1_BKN1                         APB->OBM10.MBIT.OBM1_BKN1       //[9] OBM1 break source-1 signal inverse enable bit.
#define APB_OBM10_OBM1_BKN0                         APB->OBM10.MBIT.OBM1_BKN0       //[8] OBM1 break source-0 signal inverse enable bit.
#define APB_OBM10_OBM1_LCK                          APB->OBM10.MBIT.OBM1_LCK        //[5] OBM1 break switching signal initial state write control
#define APB_OBM10_OBM1_STA                          APB->OBM10.MBIT.OBM1_STA        //[4] OBM1 break switching signal initial state
#define APB_OBM10_OBM1_MDS                          APB->OBM10.MBIT.OBM1_MDS        //[1..0] OBM1 break operation mode select
///@}
/**
 ******************************************************************************
 * @name        APB_OBM11  [register's definitions]
 *              Offset[0x2C]  APB OBM1 control register-1 (0x5F00002C)
 ******************************************************************************
 */
///@{
#define APB_OBM11                                   APB->OBM11.W                    /*!< Offset[0x2C]  APB OBM1 control register-1 (0x5F00002C) */

/* Bit fields of APB_OBM11 */
#define APB_OBM11_OBM1_MUX1                         APB->OBM11.MBIT.OBM1_MUX1       //[23..20] OBM1 output source channel-1 signal select.
#define APB_OBM11_OBM1_MUX0                         APB->OBM11.MBIT.OBM1_MUX0       //[19..16] OBM1 output source channel-0 signal select.
#define APB_OBM11_OBM1_FCKS                         APB->OBM11.MBIT.OBM1_FCKS       //[5..4] OBM1 output deglitch filter clock source select
#define APB_OBM11_OBM1_POL                          APB->OBM11.MBIT.OBM1_POL        //[2] OBM1 output signal inverse enable bit.
#define APB_OBM11_OBM1_INV1                         APB->OBM11.MBIT.OBM1_INV1       //[1] OBM1 source channel-1 signal inverse enable bit.
#define APB_OBM11_OBM1_INV0                         APB->OBM11.MBIT.OBM1_INV0       //[0] OBM1 source channel-0 signal inverse enable bit.
///@}

/*----------------------------------------------------------------------------*/
/* @module      CPU (CPU PPB SCS)                                             */
/*----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @name        CPU_SYST_CSR  [register's definitions]
 *              Offset[0x10]  CPU SysTick Control and Status Register (0xE000E010)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CSR                                CPU->SYST_CSR.W                 /*!< Offset[0x10]  CPU SysTick Control and Status Register (0xE000E010) */

/* Bit fields of CPU_SYST_CSR */
#define CPU_SYST_CSR_COUNTFLAG                      CPU->SYST_CSR.MBIT.COUNTFLAG    //[16] Returns 1 if timer counted to 0 since the last read of this register.
#define CPU_SYST_CSR_CLKSOURCE                      CPU->SYST_CSR.MBIT.CLKSOURCE    //[2] Selects the SysTick timer clock source.
#define CPU_SYST_CSR_TICKINT                        CPU->SYST_CSR.MBIT.TICKINT      //[1] Enables SysTick exception request:
#define CPU_SYST_CSR_ENCNT                          CPU->SYST_CSR.MBIT.ENCNT        //[0] Enables the counter:
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_RVR  [register's definitions]
 *              Offset[0x14]  CPU SysTick Reload Value Register (0xE000E014)
 ******************************************************************************
 */
///@{
#define CPU_SYST_RVR                                CPU->SYST_RVR.W                 /*!< Offset[0x14]  CPU SysTick Reload Value Register (0xE000E014) */

/* Bit fields of CPU_SYST_RVR */
#define CPU_SYST_RVR_RELOAD                         CPU->SYST_RVR.MBIT.RELOAD       //[23..0] Value to load into the SYST_CVR when the counter is enabled and when it reaches 0.
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CVR  [register's definitions]
 *              Offset[0x18]  CPU SysTick Current Value Register (0xE000E018)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CVR                                CPU->SYST_CVR.W                 /*!< Offset[0x18]  CPU SysTick Current Value Register (0xE000E018) */

/* Bit fields of CPU_SYST_CVR */
#define CPU_SYST_CVR_CURRENT                        CPU->SYST_CVR.MBIT.CURRENT      //[23..0] Reads return the current value of the SysTick counter.
///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CALIB  [register's definitions]
 *              Offset[0x1C]  CPU SysTick Calibration Value Register (0xE000E01C)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CALIB                              CPU->SYST_CALIB.W               /*!< Offset[0x1C]  CPU SysTick Calibration Value Register (0xE000E01C) */

/* Bit fields of CPU_SYST_CALIB */
#define CPU_SYST_CALIB_NOREF                        CPU->SYST_CALIB.MBIT.NOREF      //[31] Indicates whether the device provides a reference clock to the processor:
#define CPU_SYST_CALIB_SKEW                         CPU->SYST_CALIB.MBIT.SKEW       //[30] Indicates whether the TENMS value is exact:
#define CPU_SYST_CALIB_TENMS                        CPU->SYST_CALIB.MBIT.TENMS      //[23..0] Reload value for 10ms (100Hz) timing, subject to system clock skew errors
///@}
/**
 ******************************************************************************
 * @name        CPU_ISER  [register's definitions]
 *              Offset[0x100]  CPU Interrupt Set-enable Register (0xE000E100)
 ******************************************************************************
 */
///@{
#define CPU_ISER                                    CPU->ISER.W                     /*!< Offset[0x100]  CPU Interrupt Set-enable Register (0xE000E100) */

/* Bit fields of CPU_ISER */
#define CPU_ISER_SETENA                             CPU->ISER.MBIT.SETENA           //[31..0] Interrupt set-enable bits.
///@}
/**
 ******************************************************************************
 * @name        CPU_ICER  [register's definitions]
 *              Offset[0x180]  CPU Interrupt Clear-enable Register (0xE000E180)
 ******************************************************************************
 */
///@{
#define CPU_ICER                                    CPU->ICER.W                     /*!< Offset[0x180]  CPU Interrupt Clear-enable Register (0xE000E180) */

/* Bit fields of CPU_ICER */
#define CPU_ICER_CLRENA                             CPU->ICER.MBIT.CLRENA           //[31..0] Interrupt clear-enable bits.
///@}
/**
 ******************************************************************************
 * @name        CPU_ISPR  [register's definitions]
 *              Offset[0x200]  CPU Interrupt Set-pending Register (0xE000E200)
 ******************************************************************************
 */
///@{
#define CPU_ISPR                                    CPU->ISPR.W                     /*!< Offset[0x200]  CPU Interrupt Set-pending Register (0xE000E200) */

/* Bit fields of CPU_ISPR */
#define CPU_ISPR_SETPEND                            CPU->ISPR.MBIT.SETPEND          //[31..0] Interrupt set-pending bits.
///@}
/**
 ******************************************************************************
 * @name        CPU_ICPR  [register's definitions]
 *              Offset[0x280]  CPU Interrupt Clear-pending Register (0xE000E280)
 ******************************************************************************
 */
///@{
#define CPU_ICPR                                    CPU->ICPR.W                     /*!< Offset[0x280]  CPU Interrupt Clear-pending Register (0xE000E280) */

/* Bit fields of CPU_ICPR */
#define CPU_ICPR_CLRPEND                            CPU->ICPR.MBIT.CLRPEND          //[31..0] Interrupt clear-pending bits.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR0  [register's definitions]
 *              Offset[0x400]  CPU Interrupt Priority Registers 0 (0xE000E400)
 ******************************************************************************
 */
///@{
#define CPU_IPR0                                    CPU->IPR0.W                     /*!< Offset[0x400]  CPU Interrupt Priority Registers 0 (0xE000E400) */

/* Bit fields of CPU_IPR0 */
#define CPU_IPR0_PRI_3                              CPU->IPR0.MBIT.PRI_3            //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR0_PRI_2                              CPU->IPR0.MBIT.PRI_2            //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR0_PRI_1                              CPU->IPR0.MBIT.PRI_1            //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR0_PRI_0                              CPU->IPR0.MBIT.PRI_0            //[7..6] Each priority field holds a priority value, 0-3
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR1  [register's definitions]
 *              Offset[0x404]  CPU Interrupt Priority Registers 1 (0xE000E404)
 ******************************************************************************
 */
///@{
#define CPU_IPR1                                    CPU->IPR1.W                     /*!< Offset[0x404]  CPU Interrupt Priority Registers 1 (0xE000E404) */

/* Bit fields of CPU_IPR1 */
#define CPU_IPR1_PRI_7                              CPU->IPR1.MBIT.PRI_7            //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR1_PRI_6                              CPU->IPR1.MBIT.PRI_6            //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR1_PRI_5                              CPU->IPR1.MBIT.PRI_5            //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR1_PRI_4                              CPU->IPR1.MBIT.PRI_4            //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR2  [register's definitions]
 *              Offset[0x408]  CPU Interrupt Priority Registers 2 (0xE000E408)
 ******************************************************************************
 */
///@{
#define CPU_IPR2                                    CPU->IPR2.W                     /*!< Offset[0x408]  CPU Interrupt Priority Registers 2 (0xE000E408) */

/* Bit fields of CPU_IPR2 */
#define CPU_IPR2_PRI_11                             CPU->IPR2.MBIT.PRI_11           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR2_PRI_10                             CPU->IPR2.MBIT.PRI_10           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR2_PRI_9                              CPU->IPR2.MBIT.PRI_9            //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR2_PRI_8                              CPU->IPR2.MBIT.PRI_8            //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR3  [register's definitions]
 *              Offset[0x40C]  CPU Interrupt Priority Registers 3 (0xE000E40C)
 ******************************************************************************
 */
///@{
#define CPU_IPR3                                    CPU->IPR3.W                     /*!< Offset[0x40C]  CPU Interrupt Priority Registers 3 (0xE000E40C) */

/* Bit fields of CPU_IPR3 */
#define CPU_IPR3_PRI_15                             CPU->IPR3.MBIT.PRI_15           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR3_PRI_14                             CPU->IPR3.MBIT.PRI_14           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR3_PRI_13                             CPU->IPR3.MBIT.PRI_13           //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR3_PRI_12                             CPU->IPR3.MBIT.PRI_12           //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR4  [register's definitions]
 *              Offset[0x410]  CPU Interrupt Priority Registers 4 (0xE000E410)
 ******************************************************************************
 */
///@{
#define CPU_IPR4                                    CPU->IPR4.W                     /*!< Offset[0x410]  CPU Interrupt Priority Registers 4 (0xE000E410) */

/* Bit fields of CPU_IPR4 */
#define CPU_IPR4_PRI_19                             CPU->IPR4.MBIT.PRI_19           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR4_PRI_18                             CPU->IPR4.MBIT.PRI_18           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR4_PRI_17                             CPU->IPR4.MBIT.PRI_17           //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR4_PRI_16                             CPU->IPR4.MBIT.PRI_16           //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR5  [register's definitions]
 *              Offset[0x414]  CPU Interrupt Priority Registers 5 (0xE000E414)
 ******************************************************************************
 */
///@{
#define CPU_IPR5                                    CPU->IPR5.W                     /*!< Offset[0x414]  CPU Interrupt Priority Registers 5 (0xE000E414) */

/* Bit fields of CPU_IPR5 */
#define CPU_IPR5_PRI_23                             CPU->IPR5.MBIT.PRI_23           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR5_PRI_22                             CPU->IPR5.MBIT.PRI_22           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR5_PRI_21                             CPU->IPR5.MBIT.PRI_21           //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR5_PRI_20                             CPU->IPR5.MBIT.PRI_20           //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR6  [register's definitions]
 *              Offset[0x418]  CPU Interrupt Priority Registers 6 (0xE000E418)
 ******************************************************************************
 */
///@{
#define CPU_IPR6                                    CPU->IPR6.W                     /*!< Offset[0x418]  CPU Interrupt Priority Registers 6 (0xE000E418) */

/* Bit fields of CPU_IPR6 */
#define CPU_IPR6_PRI_27                             CPU->IPR6.MBIT.PRI_27           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR6_PRI_26                             CPU->IPR6.MBIT.PRI_26           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR6_PRI_25                             CPU->IPR6.MBIT.PRI_25           //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR6_PRI_24                             CPU->IPR6.MBIT.PRI_24           //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_IPR7  [register's definitions]
 *              Offset[0x41C]  CPU Interrupt Priority Registers 7 (0xE000E41C)
 ******************************************************************************
 */
///@{
#define CPU_IPR7                                    CPU->IPR7.W                     /*!< Offset[0x41C]  CPU Interrupt Priority Registers 7 (0xE000E41C) */

/* Bit fields of CPU_IPR7 */
#define CPU_IPR7_PRI_31                             CPU->IPR7.MBIT.PRI_31           //[31..30] Refer to CPU_PRI_0.
#define CPU_IPR7_PRI_30                             CPU->IPR7.MBIT.PRI_30           //[23..22] Refer to CPU_PRI_0.
#define CPU_IPR7_PRI_29                             CPU->IPR7.MBIT.PRI_29           //[15..14] Refer to CPU_PRI_0.
#define CPU_IPR7_PRI_28                             CPU->IPR7.MBIT.PRI_28           //[7..6] Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_CPUID  [register's definitions]
 *              Offset[0xD00]  CPU ID Register (0xE000ED00)
 ******************************************************************************
 */
///@{
#define CPU_CPUID                                   CPU->CPUID.W                    /*!< Offset[0xD00]  CPU ID Register (0xE000ED00) */

/* Bit fields of CPU_CPUID */
#define CPU_CPUID_IMPLEMENTER                       CPU->CPUID.MBIT.IMPLEMENTER     //[31..24] Implementer code:
#define CPU_CPUID_VARIANT                           CPU->CPUID.MBIT.VARIANT         //[23..20] Variant number, the r value in the rnpn product revision identifier:
#define CPU_CPUID_CONSTANT                          CPU->CPUID.MBIT.CONSTANT        //[19..16] Constant that defines the architecture of the processor:
#define CPU_CPUID_PARTNO                            CPU->CPUID.MBIT.PARTNO          //[15..4] Part number of the processor:
#define CPU_CPUID_REVISION                          CPU->CPUID.MBIT.REVISION        //[3..0] Revision number, the p value in the rnpn product revision identifier:
///@}
/**
 ******************************************************************************
 * @name        CPU_ICSR  [register's definitions]
 *              Offset[0xD04]  CPU Interrupt Control and State Register (0xE000ED04)
 ******************************************************************************
 */
///@{
#define CPU_ICSR                                    CPU->ICSR.W                     /*!< Offset[0xD04]  CPU Interrupt Control and State Register (0xE000ED04) */

/* Bit fields of CPU_ICSR */
#define CPU_ICSR_NMIPENDSET                         CPU->ICSR.MBIT.NMIPENDSET       //[31] NMI set-pending bit.
#define CPU_ICSR_PENDSVSET                          CPU->ICSR.MBIT.PENDSVSET        //[28] PendSV set-pending bit.
#define CPU_ICSR_PENDSVCLR                          CPU->ICSR.MBIT.PENDSVCLR        //[27] PendSV clear-pending bit.
#define CPU_ICSR_PENDSTSET                          CPU->ICSR.MBIT.PENDSTSET        //[26] SysTick exception set-pending bit.
#define CPU_ICSR_PENDSTCLR                          CPU->ICSR.MBIT.PENDSTCLR        //[25] SysTick exception clear-pending bit.
#define CPU_ICSR_ISRPENDING                         CPU->ICSR.MBIT.ISRPENDING       //[22] Interrupt pending flag, excluding NMI and Faults:
#define CPU_ICSR_VECTPENDING                        CPU->ICSR.MBIT.VECTPENDING      //[17..12] Indicates the exception number of the highest priority pending enabled exception:
#define CPU_ICSR_VECTACTIVE                         CPU->ICSR.MBIT.VECTACTIVE       //[5..0] Contains the active exception number:
///@}
/**
 ******************************************************************************
 * @name        CPU_AIRCR  [register's definitions]
 *              Offset[0xD0C]  CPU Application Interrupt and Reset Control Register (0xE000ED0C)
 ******************************************************************************
 */
///@{
#define CPU_AIRCR                                   CPU->AIRCR.W                    /*!< Offset[0xD0C]  CPU Application Interrupt and Reset Control Register (0xE000ED0C) */

/* Bit fields of CPU_AIRCR */
#define CPU_AIRCR_VECTKEY                           CPU->AIRCR.MBIT.VECTKEY         //[31..16] Register key:
#define CPU_AIRCR_ENDIANESS                         CPU->AIRCR.MBIT.ENDIANESS       //[15] Data endianness implemented:
#define CPU_AIRCR_SYSRESETREQ                       CPU->AIRCR.MBIT.SYSRESETREQ     //[2] System reset request:
#define CPU_AIRCR_VECTCLRACTIVE                     CPU->AIRCR.MBIT.VECTCLRACTIVE   //[1] Reserved for debug use
///@}
/**
 ******************************************************************************
 * @name        CPU_SCR  [register's definitions]
 *              Offset[0xD10]  CPU System Control Register (0xE000ED10)
 ******************************************************************************
 */
///@{
#define CPU_SCR                                     CPU->SCR.W                      /*!< Offset[0xD10]  CPU System Control Register (0xE000ED10) */

/* Bit fields of CPU_SCR */
#define CPU_SCR_SEVONPEND                           CPU->SCR.MBIT.SEVONPEND         //[4] Send Event on Pending bit:
#define CPU_SCR_SLEEPDEEP                           CPU->SCR.MBIT.SLEEPDEEP         //[2] Controls whether the processor uses sleep or deep sleep as its low power mode:
#define CPU_SCR_SLEEPONEXIT                         CPU->SCR.MBIT.SLEEPONEXIT       //[1] Indicates sleep-on-exit when returning from Handler mode to Thread mode:
///@}
/**
 ******************************************************************************
 * @name        CPU_CCR  [register's definitions]
 *              Offset[0xD14]  CPU Configuration and Control Register (0xE000ED14)
 ******************************************************************************
 */
///@{
#define CPU_CCR                                     CPU->CCR.W                      /*!< Offset[0xD14]  CPU Configuration and Control Register (0xE000ED14) */

/* Bit fields of CPU_CCR */
#define CPU_CCR_STKALIGN                            CPU->CCR.MBIT.STKALIGN          //[9] Always reads as one, indicates 8-byte stack alignment on exception entry
#define CPU_CCR_UNALIGN_TRP                         CPU->CCR.MBIT.UNALIGN_TRP       //[3] Always reads as one, indicates that all unaligned accesses generate a HardFault.
///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR2  [register's definitions]
 *              Offset[0xD1C]  CPU System Handler Priority Register 2 (0xE000ED1C)
 ******************************************************************************
 */
///@{
#define CPU_SHPR2                                   CPU->SHPR2.W                    /*!< Offset[0xD1C]  CPU System Handler Priority Register 2 (0xE000ED1C) */

/* Bit fields of CPU_SHPR2 */
#define CPU_SHPR2_PRI_11                            CPU->SHPR2.MBIT.PRI_11          //[31..30] Priority of system handler 11, SVCall. Refer to CPU_PRI_0.
///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR3  [register's definitions]
 *              Offset[0xD20]  CPU System Handler Priority Register 3 (0xE000ED20)
 ******************************************************************************
 */
///@{
#define CPU_SHPR3                                   CPU->SHPR3.W                    /*!< Offset[0xD20]  CPU System Handler Priority Register 3 (0xE000ED20) */

/* Bit fields of CPU_SHPR3 */
#define CPU_SHPR3_PRI_15                            CPU->SHPR3.MBIT.PRI_15          //[31..30] Priority of system handler 15, SysTick exception. Refer to CPU_PRI_0.
#define CPU_SHPR3_PRI_14                            CPU->SHPR3.MBIT.PRI_14          //[23..22] Priority of system handler 14, PendSV. Refer to CPU_PRI_0.
///@}

#endif  // ___RegPointer_H

/*----------------------------------------------------------------------------*/
/*                     End of file MG32__RegPointer.h                     */
/*----------------------------------------------------------------------------*/
