/**
  ******************************************************************************
 *
 * @file        Sample_MID_RST.c
 *
 * @brief       RST check reset flag ans configure reset sample code
 *
 * @par         Project
 *              MG32
 * @version     V2.42
 * @date        2021/09/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */
 

/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_MID.h"
#include "MG32_RST_MID.h"
#include "MG32_SYS_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_RST (void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       RST sample code.
 * @details     1.Set software warm reset and trigger software reset
 *    \n        2.Set software cold reset and trigger software reset
 *    \n        3.Clear software warm reset and cold reset
 *    \n        4.Force reset ADC0
 * @return      None
 *******************************************************************************
 */
void Sample_MID_RST (void)
{
    // Unprotect RST module register write
    MID_UnProtectModuleReg(RSTmodule);
    // ------------------------------------------------------------------------
    // 1.Set software warm reset and trigger reset
    // ------------------------------------------------------------------------
    // When POR reset happened
    if(__DRV_RST_GET_FLAG(RST_FLAG_PORF))
    {
        // Clear CRF, WRF and PORF
        __DRV_RST_CLEAR_FLAG(RST_FLAG_CRF | RST_FLAG_WRF | RST_FLAG_PORF);
        
        // Set software reset and trigger software reset
        __DRV_RST_SW_WARM_RESET_ENABLE();
        __DRV_RST_SW_COLD_RESET_DISABLE();
        
        // Trigger software reset
        __DRV_RST_TRIGGER_SWRESET();
    }
    
    // ------------------------------------------------------------------------
    // 2.Set software cold reset and trigger reset
    // ------------------------------------------------------------------------
    // After software warm reset
    if(__DRV_RST_GET_FLAG(RST_FLAG_SWF) && (__DRV_RST_GET_FLAG(RST_FLAG_CRF) != 0))
    {
        // Clear CRF, WRF and PORF
        __DRV_RST_CLEAR_FLAG(RST_FLAG_CRF | RST_FLAG_WRF | RST_FLAG_PORF);
        
        // Set software reset and trigger software reset
        __DRV_RST_SW_WARM_RESET_DISABLE();
        __DRV_RST_SW_COLD_RESET_ENABLE();
        
        // Trigger software reset
        __DRV_RST_TRIGGER_SWRESET();
    }
    
    // ------------------------------------------------------------------------
    // 3.Clear software warm reset and cold reset
    // ------------------------------------------------------------------------
    // After software cold reset
    if(__DRV_RST_GET_FLAG(RST_FLAG_CRF | RST_FLAG_SWF))
    {
        __DRV_RST_SW_WARM_RESET_DISABLE();
        __DRV_RST_SW_COLD_RESET_DISABLE();
    }
    
    // ------------------------------------------------------------------------
    // 4.Force reset ADC0
    // ------------------------------------------------------------------------
    // Force reset ADC0
    __DRV_RST_ADC0_FORCE_RESET();       
    __DRV_RST_ADC0_RELEASE_RESET();
    
    // Protect RST module register write
    MID_ProtectModuleReg(RSTmodule);
}



