/**
 ******************************************************************************
 *
 * @file        Sample_MID_EMB_LCD.c
 *
 * @brief       EMB connect interface I80 16Bits ILI9341 LCD Display Module
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */

/* Wizard menu ---------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include <stdlib.h>
#include "MG32_MID.h"
#include "MG32_EMB_MID.h"

/* External vairables --------------------------------------------------------*/

//=============================================================================
//常用ASCII表
//偏移量32 
//ASCII字符集: !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~
//PC2LCD2002取模方式設置：陰碼+逐列式+順向+C51格式
//總共：3個字符集（12*12、16*16和24*24），用戶可以自行新增其他分辨率的字符集。
//每個字符所占用的字節數為:(size/8+((size%8)?1:0))*(size/2),其中size:是字庫生成時的點陣大小(12/16/24...)

////12*12 ASCII字符集點陣
//const unsigned char asc2_0705[95][5]={

//};


//12*12 ASCII字符集點陣
/**
 *******************************************************************************
 * @brief       Font 12x12
 *******************************************************************************
 */
const static unsigned char asc2_1206[95][12]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*" ",0*/
{0x00,0x00,0x00,0x00,0x3F,0x40,0x00,0x00,0x00,0x00,0x00,0x00},/*"!",1*/
{0x00,0x00,0x30,0x00,0x40,0x00,0x30,0x00,0x40,0x00,0x00,0x00},/*""",2*/
{0x09,0x00,0x0B,0xC0,0x3D,0x00,0x0B,0xC0,0x3D,0x00,0x09,0x00},/*"#",3*/
{0x18,0xC0,0x24,0x40,0x7F,0xE0,0x22,0x40,0x31,0x80,0x00,0x00},/*"$",4*/
{0x18,0x00,0x24,0xC0,0x1B,0x00,0x0D,0x80,0x32,0x40,0x01,0x80},/*"%",5*/
{0x03,0x80,0x1C,0x40,0x27,0x40,0x1C,0x80,0x07,0x40,0x00,0x40},/*"&",6*/
{0x10,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",7*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x20,0x40,0x40,0x20},/*"(",8*/
{0x00,0x00,0x40,0x20,0x20,0x40,0x1F,0x80,0x00,0x00,0x00,0x00},/*")",9*/
{0x09,0x00,0x06,0x00,0x1F,0x80,0x06,0x00,0x09,0x00,0x00,0x00},/*"*",10*/
{0x04,0x00,0x04,0x00,0x3F,0x80,0x04,0x00,0x04,0x00,0x00,0x00},/*"+",11*/
{0x00,0x10,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*",",12*/
{0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x00,0x00},/*"-",13*/
{0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*".",14*/
{0x00,0x20,0x01,0xC0,0x06,0x00,0x38,0x00,0x40,0x00,0x00,0x00},/*"/",15*/
{0x1F,0x80,0x20,0x40,0x20,0x40,0x20,0x40,0x1F,0x80,0x00,0x00},/*"0",16*/
{0x00,0x00,0x10,0x40,0x3F,0xC0,0x00,0x40,0x00,0x00,0x00,0x00},/*"1",17*/
{0x18,0xC0,0x21,0x40,0x22,0x40,0x24,0x40,0x18,0x40,0x00,0x00},/*"2",18*/
{0x10,0x80,0x20,0x40,0x24,0x40,0x24,0x40,0x1B,0x80,0x00,0x00},/*"3",19*/
{0x02,0x00,0x0D,0x00,0x11,0x00,0x3F,0xC0,0x01,0x40,0x00,0x00},/*"4",20*/
{0x3C,0x80,0x24,0x40,0x24,0x40,0x24,0x40,0x23,0x80,0x00,0x00},/*"5",21*/
{0x1F,0x80,0x24,0x40,0x24,0x40,0x34,0x40,0x03,0x80,0x00,0x00},/*"6",22*/
{0x30,0x00,0x20,0x00,0x27,0xC0,0x38,0x00,0x20,0x00,0x00,0x00},/*"7",23*/
{0x1B,0x80,0x24,0x40,0x24,0x40,0x24,0x40,0x1B,0x80,0x00,0x00},/*"8",24*/
{0x1C,0x00,0x22,0xC0,0x22,0x40,0x22,0x40,0x1F,0x80,0x00,0x00},/*"9",25*/
{0x00,0x00,0x00,0x00,0x08,0x40,0x00,0x00,0x00,0x00,0x00,0x00},/*":",26*/
{0x00,0x00,0x00,0x00,0x04,0x60,0x00,0x00,0x00,0x00,0x00,0x00},/*";",27*/
{0x00,0x00,0x04,0x00,0x0A,0x00,0x11,0x00,0x20,0x80,0x40,0x40},/*"<",28*/
{0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x00,0x00},/*"=",29*/
{0x00,0x00,0x40,0x40,0x20,0x80,0x11,0x00,0x0A,0x00,0x04,0x00},/*">",30*/
{0x18,0x00,0x20,0x00,0x23,0x40,0x24,0x00,0x18,0x00,0x00,0x00},/*"?",31*/
{0x1F,0x80,0x20,0x40,0x27,0x40,0x29,0x40,0x1F,0x40,0x00,0x00},/*"@",32*/
{0x00,0x40,0x07,0xC0,0x39,0x00,0x0F,0x00,0x01,0xC0,0x00,0x40},/*"A",33*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x24,0x40,0x1B,0x80,0x00,0x00},/*"B",34*/
{0x1F,0x80,0x20,0x40,0x20,0x40,0x20,0x40,0x30,0x80,0x00,0x00},/*"C",35*/
{0x20,0x40,0x3F,0xC0,0x20,0x40,0x20,0x40,0x1F,0x80,0x00,0x00},/*"D",36*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x2E,0x40,0x30,0xC0,0x00,0x00},/*"E",37*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x2E,0x00,0x30,0x00,0x00,0x00},/*"F",38*/
{0x0F,0x00,0x10,0x80,0x20,0x40,0x22,0x40,0x33,0x80,0x02,0x00},/*"G",39*/
{0x20,0x40,0x3F,0xC0,0x04,0x00,0x04,0x00,0x3F,0xC0,0x20,0x40},/*"H",40*/
{0x20,0x40,0x20,0x40,0x3F,0xC0,0x20,0x40,0x20,0x40,0x00,0x00},/*"I",41*/
{0x00,0x60,0x20,0x20,0x20,0x20,0x3F,0xC0,0x20,0x00,0x20,0x00},/*"J",42*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x0B,0x00,0x30,0xC0,0x20,0x40},/*"K",43*/
{0x20,0x40,0x3F,0xC0,0x20,0x40,0x00,0x40,0x00,0x40,0x00,0xC0},/*"L",44*/
{0x3F,0xC0,0x3C,0x00,0x03,0xC0,0x3C,0x00,0x3F,0xC0,0x00,0x00},/*"M",45*/
{0x20,0x40,0x3F,0xC0,0x0C,0x40,0x23,0x00,0x3F,0xC0,0x20,0x00},/*"N",46*/
{0x1F,0x80,0x20,0x40,0x20,0x40,0x20,0x40,0x1F,0x80,0x00,0x00},/*"O",47*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x24,0x00,0x18,0x00,0x00,0x00},/*"P",48*/
{0x1F,0x80,0x21,0x40,0x21,0x40,0x20,0xE0,0x1F,0xA0,0x00,0x00},/*"Q",49*/
{0x20,0x40,0x3F,0xC0,0x24,0x40,0x26,0x00,0x19,0xC0,0x00,0x40},/*"R",50*/
{0x18,0xC0,0x24,0x40,0x24,0x40,0x22,0x40,0x31,0x80,0x00,0x00},/*"S",51*/
{0x30,0x00,0x20,0x40,0x3F,0xC0,0x20,0x40,0x30,0x00,0x00,0x00},/*"T",52*/
{0x20,0x00,0x3F,0x80,0x00,0x40,0x00,0x40,0x3F,0x80,0x20,0x00},/*"U",53*/
{0x20,0x00,0x3E,0x00,0x01,0xC0,0x07,0x00,0x38,0x00,0x20,0x00},/*"V",54*/
{0x38,0x00,0x07,0xC0,0x3C,0x00,0x07,0xC0,0x38,0x00,0x00,0x00},/*"W",55*/
{0x20,0x40,0x39,0xC0,0x06,0x00,0x39,0xC0,0x20,0x40,0x00,0x00},/*"X",56*/
{0x20,0x00,0x38,0x40,0x07,0xC0,0x38,0x40,0x20,0x00,0x00,0x00},/*"Y",57*/
{0x30,0x40,0x21,0xC0,0x26,0x40,0x38,0x40,0x20,0xC0,0x00,0x00},/*"Z",58*/
{0x00,0x00,0x00,0x00,0x7F,0xE0,0x40,0x20,0x40,0x20,0x00,0x00},/*"[",59*/
{0x00,0x00,0x70,0x00,0x0C,0x00,0x03,0x80,0x00,0x40,0x00,0x00},/*"\",60*/
{0x00,0x00,0x40,0x20,0x40,0x20,0x7F,0xE0,0x00,0x00,0x00,0x00},/*"]",61*/
{0x00,0x00,0x20,0x00,0x40,0x00,0x20,0x00,0x00,0x00,0x00,0x00},/*"^",62*/
{0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10},/*"_",63*/
{0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",64*/
{0x00,0x00,0x02,0x80,0x05,0x40,0x05,0x40,0x03,0xC0,0x00,0x40},/*"a",65*/
{0x20,0x00,0x3F,0xC0,0x04,0x40,0x04,0x40,0x03,0x80,0x00,0x00},/*"b",66*/
{0x00,0x00,0x03,0x80,0x04,0x40,0x04,0x40,0x06,0x40,0x00,0x00},/*"c",67*/
{0x00,0x00,0x03,0x80,0x04,0x40,0x24,0x40,0x3F,0xC0,0x00,0x40},/*"d",68*/
{0x00,0x00,0x03,0x80,0x05,0x40,0x05,0x40,0x03,0x40,0x00,0x00},/*"e",69*/
{0x00,0x00,0x04,0x40,0x1F,0xC0,0x24,0x40,0x24,0x40,0x20,0x00},/*"f",70*/
{0x00,0x00,0x02,0xE0,0x05,0x50,0x05,0x50,0x06,0x50,0x04,0x20},/*"g",71*/
{0x20,0x40,0x3F,0xC0,0x04,0x40,0x04,0x00,0x03,0xC0,0x00,0x40},/*"h",72*/
{0x00,0x00,0x04,0x40,0x27,0xC0,0x00,0x40,0x00,0x00,0x00,0x00},/*"i",73*/
{0x00,0x10,0x00,0x10,0x04,0x10,0x27,0xE0,0x00,0x00,0x00,0x00},/*"j",74*/
{0x20,0x40,0x3F,0xC0,0x01,0x40,0x07,0x00,0x04,0xC0,0x04,0x40},/*"k",75*/
{0x20,0x40,0x20,0x40,0x3F,0xC0,0x00,0x40,0x00,0x40,0x00,0x00},/*"l",76*/
{0x07,0xC0,0x04,0x00,0x07,0xC0,0x04,0x00,0x03,0xC0,0x00,0x00},/*"m",77*/
{0x04,0x40,0x07,0xC0,0x04,0x40,0x04,0x00,0x03,0xC0,0x00,0x40},/*"n",78*/
{0x00,0x00,0x03,0x80,0x04,0x40,0x04,0x40,0x03,0x80,0x00,0x00},/*"o",79*/
{0x04,0x10,0x07,0xF0,0x04,0x50,0x04,0x40,0x03,0x80,0x00,0x00},/*"p",80*/
{0x00,0x00,0x03,0x80,0x04,0x40,0x04,0x50,0x07,0xF0,0x00,0x10},/*"q",81*/
{0x04,0x40,0x07,0xC0,0x02,0x40,0x04,0x00,0x04,0x00,0x00,0x00},/*"r",82*/
{0x00,0x00,0x06,0x40,0x05,0x40,0x05,0x40,0x04,0xC0,0x00,0x00},/*"s",83*/
{0x00,0x00,0x04,0x00,0x1F,0x80,0x04,0x40,0x00,0x40,0x00,0x00},/*"t",84*/
{0x04,0x00,0x07,0x80,0x00,0x40,0x04,0x40,0x07,0xC0,0x00,0x40},/*"u",85*/
{0x04,0x00,0x07,0x00,0x04,0xC0,0x01,0x80,0x06,0x00,0x04,0x00},/*"v",86*/
{0x06,0x00,0x01,0xC0,0x07,0x00,0x01,0xC0,0x06,0x00,0x00,0x00},/*"w",87*/
{0x04,0x40,0x06,0xC0,0x01,0x00,0x06,0xC0,0x04,0x40,0x00,0x00},/*"x",88*/
{0x04,0x10,0x07,0x10,0x04,0xE0,0x01,0x80,0x06,0x00,0x04,0x00},/*"y",89*/
{0x00,0x00,0x04,0x40,0x05,0xC0,0x06,0x40,0x04,0x40,0x00,0x00},/*"z",90*/
{0x00,0x00,0x00,0x00,0x04,0x00,0x7B,0xE0,0x40,0x20,0x00,0x00},/*"{",91*/
{0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00},/*"|",92*/
{0x00,0x00,0x40,0x20,0x7B,0xE0,0x04,0x00,0x00,0x00,0x00,0x00},/*"}",93*/
{0x40,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x40,0x00},/*"~",94*/
};

//16*16 ASCII字符集點陣
/**
 *******************************************************************************
 * @brief       Font 16x16
 *******************************************************************************
 */
const static unsigned char asc2_1608[95][16]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*" ",0*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xCC,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00},/*"!",1*/
{0x00,0x00,0x08,0x00,0x30,0x00,0x60,0x00,0x08,0x00,0x30,0x00,0x60,0x00,0x00,0x00},/*""",2*/
{0x02,0x20,0x03,0xFC,0x1E,0x20,0x02,0x20,0x03,0xFC,0x1E,0x20,0x02,0x20,0x00,0x00},/*"#",3*/
{0x00,0x00,0x0E,0x18,0x11,0x04,0x3F,0xFF,0x10,0x84,0x0C,0x78,0x00,0x00,0x00,0x00},/*"$",4*/
{0x0F,0x00,0x10,0x84,0x0F,0x38,0x00,0xC0,0x07,0x78,0x18,0x84,0x00,0x78,0x00,0x00},/*"%",5*/
{0x00,0x78,0x0F,0x84,0x10,0xC4,0x11,0x24,0x0E,0x98,0x00,0xE4,0x00,0x84,0x00,0x08},/*"&",6*/
{0x08,0x00,0x68,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",7*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x18,0x18,0x20,0x04,0x40,0x02,0x00,0x00},/*"(",8*/
{0x00,0x00,0x40,0x02,0x20,0x04,0x18,0x18,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},/*")",9*/
{0x02,0x40,0x02,0x40,0x01,0x80,0x0F,0xF0,0x01,0x80,0x02,0x40,0x02,0x40,0x00,0x00},/*"*",10*/
{0x00,0x80,0x00,0x80,0x00,0x80,0x0F,0xF8,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00},/*"+",11*/
{0x00,0x01,0x00,0x0D,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*",",12*/
{0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},/*"-",13*/
{0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*".",14*/
{0x00,0x00,0x00,0x06,0x00,0x18,0x00,0x60,0x01,0x80,0x06,0x00,0x18,0x00,0x20,0x00},/*"/",15*/
{0x00,0x00,0x07,0xF0,0x08,0x08,0x10,0x04,0x10,0x04,0x08,0x08,0x07,0xF0,0x00,0x00},/*"0",16*/
{0x00,0x00,0x08,0x04,0x08,0x04,0x1F,0xFC,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00},/*"1",17*/
{0x00,0x00,0x0E,0x0C,0x10,0x14,0x10,0x24,0x10,0x44,0x11,0x84,0x0E,0x0C,0x00,0x00},/*"2",18*/
{0x00,0x00,0x0C,0x18,0x10,0x04,0x11,0x04,0x11,0x04,0x12,0x88,0x0C,0x70,0x00,0x00},/*"3",19*/
{0x00,0x00,0x00,0xE0,0x03,0x20,0x04,0x24,0x08,0x24,0x1F,0xFC,0x00,0x24,0x00,0x00},/*"4",20*/
{0x00,0x00,0x1F,0x98,0x10,0x84,0x11,0x04,0x11,0x04,0x10,0x88,0x10,0x70,0x00,0x00},/*"5",21*/
{0x00,0x00,0x07,0xF0,0x08,0x88,0x11,0x04,0x11,0x04,0x18,0x88,0x00,0x70,0x00,0x00},/*"6",22*/
{0x00,0x00,0x1C,0x00,0x10,0x00,0x10,0xFC,0x13,0x00,0x1C,0x00,0x10,0x00,0x00,0x00},/*"7",23*/
{0x00,0x00,0x0E,0x38,0x11,0x44,0x10,0x84,0x10,0x84,0x11,0x44,0x0E,0x38,0x00,0x00},/*"8",24*/
{0x00,0x00,0x07,0x00,0x08,0x8C,0x10,0x44,0x10,0x44,0x08,0x88,0x07,0xF0,0x00,0x00},/*"9",25*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0C,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00},/*":",26*/
{0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*";",27*/
{0x00,0x00,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x00,0x00},/*"<",28*/
{0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x00,0x00},/*"=",29*/
{0x00,0x00,0x10,0x04,0x08,0x08,0x04,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x00,0x00},/*">",30*/
{0x00,0x00,0x0E,0x00,0x12,0x00,0x10,0x0C,0x10,0x6C,0x10,0x80,0x0F,0x00,0x00,0x00},/*"?",31*/
{0x03,0xE0,0x0C,0x18,0x13,0xE4,0x14,0x24,0x17,0xC4,0x08,0x28,0x07,0xD0,0x00,0x00},/*"@",32*/
{0x00,0x04,0x00,0x3C,0x03,0xC4,0x1C,0x40,0x07,0x40,0x00,0xE4,0x00,0x1C,0x00,0x04},/*"A",33*/
{0x10,0x04,0x1F,0xFC,0x11,0x04,0x11,0x04,0x11,0x04,0x0E,0x88,0x00,0x70,0x00,0x00},/*"B",34*/
{0x03,0xE0,0x0C,0x18,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x1C,0x10,0x00,0x00},/*"C",35*/
{0x10,0x04,0x1F,0xFC,0x10,0x04,0x10,0x04,0x10,0x04,0x08,0x08,0x07,0xF0,0x00,0x00},/*"D",36*/
{0x10,0x04,0x1F,0xFC,0x11,0x04,0x11,0x04,0x17,0xC4,0x10,0x04,0x08,0x18,0x00,0x00},/*"E",37*/
{0x10,0x04,0x1F,0xFC,0x11,0x04,0x11,0x00,0x17,0xC0,0x10,0x00,0x08,0x00,0x00,0x00},/*"F",38*/
{0x03,0xE0,0x0C,0x18,0x10,0x04,0x10,0x04,0x10,0x44,0x1C,0x78,0x00,0x40,0x00,0x00},/*"G",39*/
{0x10,0x04,0x1F,0xFC,0x10,0x84,0x00,0x80,0x00,0x80,0x10,0x84,0x1F,0xFC,0x10,0x04},/*"H",40*/
{0x00,0x00,0x10,0x04,0x10,0x04,0x1F,0xFC,0x10,0x04,0x10,0x04,0x00,0x00,0x00,0x00},/*"I",41*/
{0x00,0x03,0x00,0x01,0x10,0x01,0x10,0x01,0x1F,0xFE,0x10,0x00,0x10,0x00,0x00,0x00},/*"J",42*/
{0x10,0x04,0x1F,0xFC,0x11,0x04,0x03,0x80,0x14,0x64,0x18,0x1C,0x10,0x04,0x00,0x00},/*"K",43*/
{0x10,0x04,0x1F,0xFC,0x10,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0C,0x00,0x00},/*"L",44*/
{0x10,0x04,0x1F,0xFC,0x1F,0x00,0x00,0xFC,0x1F,0x00,0x1F,0xFC,0x10,0x04,0x00,0x00},/*"M",45*/
{0x10,0x04,0x1F,0xFC,0x0C,0x04,0x03,0x00,0x00,0xE0,0x10,0x18,0x1F,0xFC,0x10,0x00},/*"N",46*/
{0x07,0xF0,0x08,0x08,0x10,0x04,0x10,0x04,0x10,0x04,0x08,0x08,0x07,0xF0,0x00,0x00},/*"O",47*/
{0x10,0x04,0x1F,0xFC,0x10,0x84,0x10,0x80,0x10,0x80,0x10,0x80,0x0F,0x00,0x00,0x00},/*"P",48*/
{0x07,0xF0,0x08,0x18,0x10,0x24,0x10,0x24,0x10,0x1C,0x08,0x0A,0x07,0xF2,0x00,0x00},/*"Q",49*/
{0x10,0x04,0x1F,0xFC,0x11,0x04,0x11,0x00,0x11,0xC0,0x11,0x30,0x0E,0x0C,0x00,0x04},/*"R",50*/
{0x00,0x00,0x0E,0x1C,0x11,0x04,0x10,0x84,0x10,0x84,0x10,0x44,0x1C,0x38,0x00,0x00},/*"S",51*/
{0x18,0x00,0x10,0x00,0x10,0x04,0x1F,0xFC,0x10,0x04,0x10,0x00,0x18,0x00,0x00,0x00},/*"T",52*/
{0x10,0x00,0x1F,0xF8,0x10,0x04,0x00,0x04,0x00,0x04,0x10,0x04,0x1F,0xF8,0x10,0x00},/*"U",53*/
{0x10,0x00,0x1E,0x00,0x11,0xE0,0x00,0x1C,0x00,0x70,0x13,0x80,0x1C,0x00,0x10,0x00},/*"V",54*/
{0x1F,0xC0,0x10,0x3C,0x00,0xE0,0x1F,0x00,0x00,0xE0,0x10,0x3C,0x1F,0xC0,0x00,0x00},/*"W",55*/
{0x10,0x04,0x18,0x0C,0x16,0x34,0x01,0xC0,0x01,0xC0,0x16,0x34,0x18,0x0C,0x10,0x04},/*"X",56*/
{0x10,0x00,0x1C,0x00,0x13,0x04,0x00,0xFC,0x13,0x04,0x1C,0x00,0x10,0x00,0x00,0x00},/*"Y",57*/
{0x08,0x04,0x10,0x1C,0x10,0x64,0x10,0x84,0x13,0x04,0x1C,0x04,0x10,0x18,0x00,0x00},/*"Z",58*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFE,0x40,0x02,0x40,0x02,0x40,0x02,0x00,0x00},/*"[",59*/
{0x00,0x00,0x30,0x00,0x0C,0x00,0x03,0x80,0x00,0x60,0x00,0x1C,0x00,0x03,0x00,0x00},/*"\",60*/
{0x00,0x00,0x40,0x02,0x40,0x02,0x40,0x02,0x7F,0xFE,0x00,0x00,0x00,0x00,0x00,0x00},/*"]",61*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x00,0x00},/*"^",62*/
{0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01},/*"_",63*/
{0x00,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",64*/
{0x00,0x00,0x00,0x98,0x01,0x24,0x01,0x44,0x01,0x44,0x01,0x44,0x00,0xFC,0x00,0x04},/*"a",65*/
{0x10,0x00,0x1F,0xFC,0x00,0x88,0x01,0x04,0x01,0x04,0x00,0x88,0x00,0x70,0x00,0x00},/*"b",66*/
{0x00,0x00,0x00,0x70,0x00,0x88,0x01,0x04,0x01,0x04,0x01,0x04,0x00,0x88,0x00,0x00},/*"c",67*/
{0x00,0x00,0x00,0x70,0x00,0x88,0x01,0x04,0x01,0x04,0x11,0x08,0x1F,0xFC,0x00,0x04},/*"d",68*/
{0x00,0x00,0x00,0xF8,0x01,0x44,0x01,0x44,0x01,0x44,0x01,0x44,0x00,0xC8,0x00,0x00},/*"e",69*/
{0x00,0x00,0x01,0x04,0x01,0x04,0x0F,0xFC,0x11,0x04,0x11,0x04,0x11,0x00,0x18,0x00},/*"f",70*/
{0x00,0x00,0x00,0xD6,0x01,0x29,0x01,0x29,0x01,0x29,0x01,0xC9,0x01,0x06,0x00,0x00},/*"g",71*/
{0x10,0x04,0x1F,0xFC,0x00,0x84,0x01,0x00,0x01,0x00,0x01,0x04,0x00,0xFC,0x00,0x04},/*"h",72*/
{0x00,0x00,0x01,0x04,0x19,0x04,0x19,0xFC,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00},/*"i",73*/
{0x00,0x00,0x00,0x03,0x00,0x01,0x01,0x01,0x19,0x01,0x19,0xFE,0x00,0x00,0x00,0x00},/*"j",74*/
{0x10,0x04,0x1F,0xFC,0x00,0x24,0x00,0x40,0x01,0xB4,0x01,0x0C,0x01,0x04,0x00,0x00},/*"k",75*/
{0x00,0x00,0x10,0x04,0x10,0x04,0x1F,0xFC,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00},/*"l",76*/
{0x01,0x04,0x01,0xFC,0x01,0x04,0x01,0x00,0x01,0xFC,0x01,0x04,0x01,0x00,0x00,0xFC},/*"m",77*/
{0x01,0x04,0x01,0xFC,0x00,0x84,0x01,0x00,0x01,0x00,0x01,0x04,0x00,0xFC,0x00,0x04},/*"n",78*/
{0x00,0x00,0x00,0xF8,0x01,0x04,0x01,0x04,0x01,0x04,0x01,0x04,0x00,0xF8,0x00,0x00},/*"o",79*/
{0x01,0x01,0x01,0xFF,0x00,0x85,0x01,0x04,0x01,0x04,0x00,0x88,0x00,0x70,0x00,0x00},/*"p",80*/
{0x00,0x00,0x00,0x70,0x00,0x88,0x01,0x04,0x01,0x04,0x01,0x05,0x01,0xFF,0x00,0x01},/*"q",81*/
{0x01,0x04,0x01,0x04,0x01,0xFC,0x00,0x84,0x01,0x04,0x01,0x00,0x01,0x80,0x00,0x00},/*"r",82*/
{0x00,0x00,0x00,0xCC,0x01,0x24,0x01,0x24,0x01,0x24,0x01,0x24,0x01,0x98,0x00,0x00},/*"s",83*/
{0x00,0x00,0x01,0x00,0x01,0x00,0x07,0xF8,0x01,0x04,0x01,0x04,0x00,0x00,0x00,0x00},/*"t",84*/
{0x01,0x00,0x01,0xF8,0x00,0x04,0x00,0x04,0x00,0x04,0x01,0x08,0x01,0xFC,0x00,0x04},/*"u",85*/
{0x01,0x00,0x01,0x80,0x01,0x70,0x00,0x0C,0x00,0x10,0x01,0x60,0x01,0x80,0x01,0x00},/*"v",86*/
{0x01,0xF0,0x01,0x0C,0x00,0x30,0x01,0xC0,0x00,0x30,0x01,0x0C,0x01,0xF0,0x01,0x00},/*"w",87*/
{0x00,0x00,0x01,0x04,0x01,0x8C,0x00,0x74,0x01,0x70,0x01,0x8C,0x01,0x04,0x00,0x00},/*"x",88*/
{0x01,0x01,0x01,0x81,0x01,0x71,0x00,0x0E,0x00,0x18,0x01,0x60,0x01,0x80,0x01,0x00},/*"y",89*/
{0x00,0x00,0x01,0x84,0x01,0x0C,0x01,0x34,0x01,0x44,0x01,0x84,0x01,0x0C,0x00,0x00},/*"z",90*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x3E,0xFC,0x40,0x02,0x40,0x02},/*"{",91*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00},/*"|",92*/
{0x00,0x00,0x40,0x02,0x40,0x02,0x3E,0xFC,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"}",93*/
{0x00,0x00,0x60,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00},/*"~",94*/
};

//24*24 ASICII字符集點陣
/**
 *******************************************************************************
 * @brief       Font 24x24
 *******************************************************************************
 */
const static unsigned char asc2_2412[95][36]={
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*" ",0*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x80,0x38,0x0F,0xFE,0x38,0x0F,0x80,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"!",1*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x06,0x00,0x00,0x0C,0x00,0x00,0x38,0x00,0x00,0x31,0x00,0x00,0x06,0x00,0x00,0x0C,0x00,0x00,0x38,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00},/*""",2*/
{0x00,0x00,0x00,0x00,0x61,0x80,0x00,0x67,0xF8,0x07,0xF9,0x80,0x00,0x61,0x80,0x00,0x61,0x80,0x00,0x61,0x80,0x00,0x61,0x80,0x00,0x67,0xF8,0x07,0xF9,0x80,0x00,0x61,0x80,0x00,0x00,0x00},/*"#",3*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0xE0,0x03,0xE0,0xF0,0x06,0x30,0x08,0x04,0x18,0x08,0x1F,0xFF,0xFE,0x04,0x0E,0x08,0x07,0x87,0xF0,0x03,0x81,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},/*"$",4*/
{0x01,0xF0,0x00,0x06,0x0C,0x00,0x04,0x04,0x08,0x06,0x0C,0x70,0x01,0xF9,0xC0,0x00,0x0E,0x00,0x00,0x3B,0xE0,0x00,0xEC,0x18,0x07,0x08,0x08,0x04,0x0C,0x18,0x00,0x03,0xE0,0x00,0x00,0x00},/*"%",5*/
{0x00,0x01,0xE0,0x00,0x07,0xF0,0x03,0xF8,0x18,0x04,0x1C,0x08,0x04,0x17,0x08,0x07,0xE1,0xD0,0x03,0xC0,0xE0,0x00,0x23,0xB0,0x00,0x3C,0x08,0x00,0x20,0x08,0x00,0x00,0x10,0x00,0x00,0x00},/*"&",6*/
{0x00,0x00,0x00,0x01,0x00,0x00,0x31,0x00,0x00,0x32,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",7*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x01,0xFF,0xC0,0x07,0x80,0xF0,0x0C,0x00,0x18,0x10,0x00,0x04,0x20,0x00,0x02,0x00,0x00,0x00},/*"(",8*/
{0x00,0x00,0x00,0x20,0x00,0x02,0x10,0x00,0x04,0x0C,0x00,0x18,0x07,0x80,0xF0,0x01,0xFF,0xC0,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*")",9*/
{0x00,0x00,0x00,0x00,0x42,0x00,0x00,0x66,0x00,0x00,0x66,0x00,0x00,0x3C,0x00,0x00,0x18,0x00,0x03,0xFF,0xC0,0x00,0x18,0x00,0x00,0x3C,0x00,0x00,0x66,0x00,0x00,0x66,0x00,0x00,0x42,0x00},/*"*",10*/
{0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x01,0xFF,0xC0,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00},/*"+",11*/
{0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x31,0x00,0x00,0x32,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*",",12*/
{0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00},/*"-",13*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*".",14*/
{0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x1C,0x00,0x00,0x70,0x00,0x01,0x80,0x00,0x0E,0x00,0x00,0x38,0x00,0x00,0xC0,0x00,0x07,0x00,0x00,0x1C,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00},/*"/",15*/
{0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0xFF,0xE0,0x03,0x80,0x70,0x06,0x00,0x18,0x04,0x00,0x08,0x04,0x00,0x08,0x06,0x00,0x18,0x03,0x80,0x70,0x01,0xFF,0xE0,0x00,0x7F,0x80,0x00,0x00,0x00},/*"0",16*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x08,0x01,0x00,0x08,0x01,0x00,0x08,0x03,0xFF,0xF8,0x07,0xFF,0xF8,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00},/*"1",17*/
{0x00,0x00,0x00,0x01,0xC0,0x38,0x02,0xC0,0x58,0x04,0x00,0x98,0x04,0x01,0x18,0x04,0x02,0x18,0x04,0x04,0x18,0x06,0x1C,0x18,0x03,0xF8,0x18,0x01,0xE0,0xF8,0x00,0x00,0x00,0x00,0x00,0x00},/*"2",18*/
{0x00,0x00,0x00,0x01,0xC0,0xE0,0x03,0xC0,0xF0,0x04,0x00,0x08,0x04,0x08,0x08,0x04,0x08,0x08,0x06,0x18,0x08,0x03,0xF4,0x18,0x01,0xE7,0xF0,0x00,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},/*"3",19*/
{0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x0D,0x00,0x00,0x11,0x00,0x00,0x61,0x00,0x00,0x81,0x08,0x03,0x01,0x08,0x07,0xFF,0xF8,0x0F,0xFF,0xF8,0x00,0x01,0x08,0x00,0x01,0x08,0x00,0x00,0x00},/*"4",20*/
{0x00,0x00,0x00,0x00,0x00,0xE0,0x07,0xFC,0xD0,0x06,0x08,0x08,0x06,0x10,0x08,0x06,0x10,0x08,0x06,0x10,0x08,0x06,0x18,0x38,0x06,0x0F,0xF0,0x06,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00},/*"5",21*/
{0x00,0x00,0x00,0x00,0x3F,0x80,0x01,0xFF,0xE0,0x03,0x84,0x30,0x02,0x08,0x18,0x04,0x10,0x08,0x04,0x10,0x08,0x04,0x10,0x08,0x07,0x18,0x10,0x03,0x0F,0xF0,0x00,0x07,0xC0,0x00,0x00,0x00},/*"6",22*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x00,0x07,0x00,0x00,0x06,0x00,0x00,0x06,0x00,0xF8,0x06,0x07,0xF8,0x06,0x18,0x00,0x06,0xE0,0x00,0x07,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00},/*"7",23*/
{0x00,0x00,0x00,0x01,0xE1,0xE0,0x03,0xF7,0xF0,0x06,0x34,0x10,0x04,0x18,0x08,0x04,0x18,0x08,0x04,0x0C,0x08,0x04,0x0C,0x08,0x06,0x16,0x18,0x03,0xF3,0xF0,0x01,0xC1,0xE0,0x00,0x00,0x00},/*"8",24*/
{0x00,0x00,0x00,0x00,0xF8,0x00,0x03,0xFC,0x30,0x03,0x06,0x38,0x04,0x02,0x08,0x04,0x02,0x08,0x04,0x02,0x08,0x04,0x04,0x10,0x03,0x08,0xF0,0x01,0xFF,0xC0,0x00,0x7F,0x00,0x00,0x00,0x00},/*"9",25*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x70,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*":",26*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x1A,0x00,0x30,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*";",27*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x14,0x00,0x00,0x22,0x00,0x00,0x41,0x00,0x00,0x80,0x80,0x01,0x00,0x40,0x02,0x00,0x20,0x04,0x00,0x10,0x08,0x00,0x08,0x00,0x00,0x00},/*"<",28*/
{0x00,0x00,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x21,0x00,0x00,0x00,0x00},/*"=",29*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x04,0x00,0x10,0x02,0x00,0x20,0x01,0x00,0x40,0x00,0x80,0x80,0x00,0x41,0x00,0x00,0x22,0x00,0x00,0x14,0x00,0x00,0x08,0x00,0x00,0x00,0x00},/*">",30*/
{0x00,0x00,0x00,0x03,0xC0,0x00,0x04,0xC0,0x00,0x04,0x00,0x00,0x08,0x00,0x38,0x08,0x0F,0x38,0x08,0x08,0x38,0x08,0x10,0x00,0x0C,0x30,0x00,0x07,0xE0,0x00,0x03,0xC0,0x00,0x00,0x00,0x00},/*"?",31*/
{0x00,0x00,0x00,0x00,0x3F,0x80,0x00,0xFF,0xE0,0x03,0x80,0x70,0x02,0x0F,0x10,0x06,0x70,0x88,0x04,0xC0,0x88,0x04,0x83,0x08,0x04,0x7F,0x88,0x02,0xC0,0x90,0x03,0x01,0x20,0x00,0xFE,0x40},/*"@",32*/
{0x00,0x00,0x08,0x00,0x00,0x18,0x00,0x01,0xF8,0x00,0x3E,0x08,0x01,0xC2,0x00,0x07,0x02,0x00,0x07,0xE2,0x00,0x00,0xFE,0x00,0x00,0x1F,0xC8,0x00,0x01,0xF8,0x00,0x00,0x38,0x00,0x00,0x08},/*"A",33*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x08,0x08,0x04,0x08,0x08,0x04,0x08,0x08,0x04,0x08,0x08,0x06,0x18,0x08,0x03,0xF4,0x18,0x01,0xE7,0xF0,0x00,0x01,0xE0,0x00,0x00,0x00},/*"B",34*/
{0x00,0x00,0x00,0x00,0x3F,0x80,0x01,0xFF,0xE0,0x03,0x80,0x70,0x02,0x00,0x18,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x10,0x06,0x00,0x20,0x07,0x80,0xC0,0x00,0x00,0x00},/*"C",35*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x18,0x02,0x00,0x10,0x03,0x80,0x70,0x01,0xFF,0xE0,0x00,0x7F,0x80,0x00,0x00,0x00},/*"D",36*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x08,0x08,0x04,0x08,0x08,0x04,0x08,0x08,0x04,0x08,0x08,0x04,0x3E,0x08,0x04,0x00,0x08,0x06,0x00,0x18,0x01,0x00,0x60,0x00,0x00,0x00},/*"E",37*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x08,0x08,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x3E,0x00,0x06,0x00,0x00,0x06,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x00},/*"F",38*/
{0x00,0x00,0x00,0x00,0x3F,0x80,0x01,0xFF,0xE0,0x03,0x80,0x70,0x06,0x00,0x18,0x04,0x00,0x08,0x04,0x02,0x08,0x04,0x02,0x08,0x02,0x03,0xF0,0x07,0x83,0xF0,0x00,0x02,0x00,0x00,0x02,0x00},/*"G",39*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x08,0x08,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x04,0x08,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08},/*"H",40*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00},/*"I",41*/
{0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x07,0x00,0x00,0x01,0x04,0x00,0x01,0x04,0x00,0x01,0x04,0x00,0x03,0x07,0xFF,0xFE,0x07,0xFF,0xFC,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00},/*"J",42*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x0C,0x08,0x00,0x18,0x00,0x00,0x3E,0x00,0x04,0xC7,0x80,0x05,0x03,0xC8,0x06,0x00,0xF8,0x04,0x00,0x38,0x04,0x00,0x18,0x00,0x00,0x08},/*"K",43*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x18,0x00,0x00,0x60,0x00,0x00,0x00},/*"L",44*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0x80,0x08,0x07,0xFC,0x00,0x00,0x7F,0xC0,0x00,0x03,0xF8,0x00,0x07,0xC0,0x00,0x78,0x00,0x07,0x80,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08},/*"M",45*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0x00,0x08,0x03,0xC0,0x00,0x00,0xE0,0x00,0x00,0x38,0x00,0x00,0x1E,0x00,0x00,0x07,0x00,0x00,0x01,0xC0,0x04,0x00,0xF0,0x07,0xFF,0xF8,0x04,0x00,0x00},/*"N",46*/
{0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0xFF,0xE0,0x03,0x80,0x70,0x06,0x00,0x18,0x04,0x00,0x08,0x04,0x00,0x08,0x06,0x00,0x18,0x03,0x00,0x30,0x01,0xFF,0xE0,0x00,0x7F,0x80,0x00,0x00,0x00},/*"O",47*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x04,0x08,0x04,0x04,0x00,0x04,0x04,0x00,0x04,0x04,0x00,0x04,0x04,0x00,0x06,0x0C,0x00,0x03,0xF8,0x00,0x01,0xF0,0x00,0x00,0x00,0x00},/*"P",48*/
{0x00,0x00,0x00,0x00,0x7F,0x80,0x01,0xFF,0xE0,0x03,0x80,0x70,0x06,0x00,0x88,0x04,0x00,0x88,0x04,0x00,0xC8,0x06,0x00,0x3C,0x03,0x00,0x3E,0x01,0xFF,0xE6,0x00,0x7F,0x84,0x00,0x00,0x00},/*"Q",49*/
{0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x08,0x08,0x04,0x08,0x00,0x04,0x0C,0x00,0x04,0x0F,0x00,0x04,0x0B,0xC0,0x06,0x10,0xF0,0x03,0xF0,0x38,0x01,0xE0,0x08,0x00,0x00,0x08},/*"R",50*/
{0x00,0x00,0x00,0x01,0xE0,0xF8,0x03,0xF0,0x30,0x06,0x30,0x10,0x04,0x18,0x08,0x04,0x18,0x08,0x04,0x0C,0x08,0x04,0x0C,0x08,0x02,0x06,0x18,0x02,0x07,0xF0,0x07,0x81,0xE0,0x00,0x00,0x00},/*"S",51*/
{0x01,0x80,0x00,0x06,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x08,0x07,0xFF,0xF8,0x07,0xFF,0xF8,0x04,0x00,0x08,0x04,0x00,0x00,0x04,0x00,0x00,0x06,0x00,0x00,0x01,0x80,0x00},/*"T",52*/
{0x04,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xF0,0x04,0x00,0x18,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x04,0x00,0x10,0x07,0xFF,0xE0,0x04,0x00,0x00},/*"U",53*/
{0x04,0x00,0x00,0x06,0x00,0x00,0x07,0xE0,0x00,0x07,0xFE,0x00,0x04,0x1F,0xE0,0x00,0x01,0xF8,0x00,0x00,0x38,0x00,0x01,0xE0,0x04,0x3E,0x00,0x07,0xC0,0x00,0x06,0x00,0x00,0x04,0x00,0x00},/*"V",54*/
{0x04,0x00,0x00,0x07,0xE0,0x00,0x07,0xFF,0xC0,0x04,0x1F,0xF8,0x00,0x07,0xC0,0x07,0xF8,0x00,0x07,0xFF,0x80,0x04,0x3F,0xF8,0x00,0x07,0xC0,0x04,0xF8,0x00,0x07,0x00,0x00,0x04,0x00,0x00},/*"W",55*/
{0x00,0x00,0x00,0x04,0x00,0x08,0x06,0x00,0x18,0x07,0xC0,0x78,0x05,0xF1,0xC8,0x00,0x3E,0x00,0x00,0x1F,0x80,0x04,0x63,0xE8,0x07,0x80,0xF8,0x06,0x00,0x18,0x04,0x00,0x08,0x00,0x00,0x00},/*"X",56*/
{0x04,0x00,0x00,0x06,0x00,0x00,0x07,0x80,0x00,0x07,0xE0,0x08,0x04,0x7C,0x08,0x00,0x1F,0xF8,0x00,0x07,0xF8,0x00,0x18,0x08,0x04,0xE0,0x08,0x07,0x00,0x00,0x06,0x00,0x00,0x04,0x00,0x00},/*"Y",57*/
{0x00,0x00,0x00,0x01,0x00,0x08,0x06,0x00,0x38,0x04,0x00,0xF8,0x04,0x03,0xE8,0x04,0x0F,0x08,0x04,0x7C,0x08,0x05,0xF0,0x08,0x07,0xC0,0x08,0x07,0x00,0x18,0x04,0x00,0x60,0x00,0x00,0x00},/*"Z",58*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xFE,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x00,0x00,0x00},/*"[",59*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x07,0x00,0x00,0x00,0xC0,0x00,0x00,0x38,0x00,0x00,0x06,0x00,0x00,0x01,0xC0,0x00,0x00,0x30,0x00,0x00,0x0E,0x00,0x00,0x01,0x00,0x00,0x00},/*"\",60*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x20,0x00,0x02,0x3F,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"]",61*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x10,0x00,0x00,0x30,0x00,0x00,0x20,0x00,0x00,0x30,0x00,0x00,0x10,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"^",62*/
{0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01},/*"_",63*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",64*/
{0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x19,0xF8,0x00,0x1B,0x18,0x00,0x22,0x08,0x00,0x26,0x08,0x00,0x24,0x08,0x00,0x24,0x10,0x00,0x3F,0xF8,0x00,0x1F,0xF8,0x00,0x00,0x08,0x00,0x00,0x18},/*"a",65*/
{0x00,0x00,0x00,0x04,0x00,0x00,0x07,0xFF,0xF8,0x0F,0xFF,0xF0,0x00,0x18,0x18,0x00,0x10,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x30,0x18,0x00,0x1F,0xF0,0x00,0x0F,0xC0,0x00,0x00,0x00},/*"b",66*/
{0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x1F,0xF0,0x00,0x18,0x30,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x3C,0x08,0x00,0x1C,0x10,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00},/*"c",67*/
{0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x1F,0xF0,0x00,0x38,0x18,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x04,0x10,0x10,0x07,0xFF,0xF8,0x0F,0xFF,0xF0,0x00,0x00,0x10,0x00,0x00,0x00},/*"d",68*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x1F,0xF0,0x00,0x12,0x30,0x00,0x22,0x18,0x00,0x22,0x08,0x00,0x22,0x08,0x00,0x32,0x08,0x00,0x1E,0x10,0x00,0x0E,0x20,0x00,0x00,0x00},/*"e",69*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x20,0x08,0x00,0x20,0x08,0x01,0xFF,0xF8,0x03,0xFF,0xF8,0x06,0x20,0x08,0x04,0x20,0x08,0x04,0x20,0x08,0x07,0x20,0x00,0x03,0x00,0x00,0x00,0x00,0x00},/*"f",70*/
{0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x0E,0x6E,0x00,0x1F,0xF3,0x00,0x31,0xB1,0x00,0x20,0xB1,0x00,0x20,0xB1,0x00,0x31,0x91,0x00,0x1F,0x13,0x00,0x2E,0x1E,0x00,0x20,0x0E,0x00,0x30,0x00},/*"g",71*/
{0x00,0x00,0x00,0x04,0x00,0x08,0x07,0xFF,0xF8,0x0F,0xFF,0xF8,0x00,0x10,0x08,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x20,0x08,0x00,0x3F,0xF8,0x00,0x1F,0xF8,0x00,0x00,0x08,0x00,0x00,0x00},/*"h",72*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x06,0x3F,0xF8,0x06,0x3F,0xF8,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00},/*"i",73*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x20,0x01,0x00,0x20,0x01,0x00,0x20,0x03,0x06,0x3F,0xFE,0x06,0x3F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"j",74*/
{0x00,0x00,0x00,0x04,0x00,0x08,0x07,0xFF,0xF8,0x0F,0xFF,0xF8,0x00,0x01,0x88,0x00,0x03,0x00,0x00,0x2F,0xC0,0x00,0x38,0xF8,0x00,0x20,0x38,0x00,0x20,0x08,0x00,0x00,0x08,0x00,0x00,0x00},/*"k",75*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x07,0xFF,0xF8,0x0F,0xFF,0xF8,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00},/*"l",76*/
{0x00,0x20,0x08,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x10,0x08,0x00,0x20,0x00,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x10,0x08,0x00,0x20,0x00,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x00,0x08},/*"m",77*/
{0x00,0x00,0x00,0x00,0x20,0x08,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x10,0x08,0x00,0x10,0x00,0x00,0x20,0x00,0x00,0x20,0x08,0x00,0x3F,0xF8,0x00,0x1F,0xF8,0x00,0x00,0x08,0x00,0x00,0x00},/*"n",78*/
{0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x0F,0xF0,0x00,0x18,0x30,0x00,0x30,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x30,0x08,0x00,0x18,0x30,0x00,0x0F,0xF0,0x00,0x07,0xC0,0x00,0x00,0x00},/*"o",79*/
{0x00,0x00,0x00,0x00,0x20,0x01,0x00,0x3F,0xFF,0x00,0x3F,0xFF,0x00,0x10,0x11,0x00,0x20,0x09,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x30,0x38,0x00,0x1F,0xF0,0x00,0x0F,0xC0,0x00,0x00,0x00},/*"p",80*/
{0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x1F,0xF0,0x00,0x38,0x18,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x09,0x00,0x10,0x11,0x00,0x1F,0xFF,0x00,0x3F,0xFF,0x00,0x00,0x01,0x00,0x00,0x00},/*"q",81*/
{0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x3F,0xF8,0x00,0x3F,0xF8,0x00,0x08,0x08,0x00,0x10,0x08,0x00,0x20,0x08,0x00,0x20,0x00,0x00,0x30,0x00,0x00,0x30,0x00,0x00,0x00,0x00},/*"r",82*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x78,0x00,0x1E,0x18,0x00,0x33,0x08,0x00,0x23,0x08,0x00,0x21,0x08,0x00,0x21,0x88,0x00,0x21,0x98,0x00,0x30,0xF0,0x00,0x38,0x60,0x00,0x00,0x00},/*"s",83*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0xFF,0xF0,0x03,0xFF,0xF8,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00},/*"t",84*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x3F,0xF0,0x00,0x7F,0xF8,0x00,0x00,0x18,0x00,0x00,0x08,0x00,0x00,0x08,0x00,0x20,0x10,0x00,0x3F,0xF8,0x00,0x7F,0xF0,0x00,0x00,0x10,0x00,0x00,0x00},/*"u",85*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x30,0x00,0x00,0x3C,0x00,0x00,0x3F,0x80,0x00,0x23,0xF0,0x00,0x00,0x78,0x00,0x00,0x70,0x00,0x23,0x80,0x00,0x3C,0x00,0x00,0x30,0x00,0x00,0x20,0x00},/*"v",86*/
{0x00,0x20,0x00,0x00,0x3C,0x00,0x00,0x3F,0xE0,0x00,0x23,0xF8,0x00,0x00,0xE0,0x00,0x27,0x00,0x00,0x3E,0x00,0x00,0x3F,0xE0,0x00,0x21,0xF8,0x00,0x01,0xE0,0x00,0x3E,0x00,0x00,0x20,0x00},/*"w",87*/
{0x00,0x00,0x00,0x00,0x20,0x08,0x00,0x20,0x08,0x00,0x38,0x38,0x00,0x3E,0x68,0x00,0x27,0x80,0x00,0x03,0xC8,0x00,0x2C,0xF8,0x00,0x38,0x38,0x00,0x20,0x18,0x00,0x20,0x08,0x00,0x00,0x00},/*"x",88*/
{0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x30,0x03,0x00,0x3C,0x01,0x00,0x3F,0x83,0x00,0x23,0xEC,0x00,0x00,0x70,0x00,0x23,0x80,0x00,0x3C,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x00,0x00},/*"y",89*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x08,0x00,0x20,0x38,0x00,0x20,0xF8,0x00,0x23,0xE8,0x00,0x2F,0x88,0x00,0x3E,0x08,0x00,0x38,0x08,0x00,0x20,0x18,0x00,0x00,0x70,0x00,0x00,0x00},/*"z",90*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x14,0x00,0x1F,0xF7,0xFC,0x30,0x00,0x06,0x20,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00},/*"{",91*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"|",92*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x02,0x30,0x00,0x06,0x1F,0xF7,0xFC,0x00,0x14,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"}",93*/
{0x00,0x00,0x00,0x18,0x00,0x00,0x60,0x00,0x00,0x40,0x00,0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x10,0x00,0x00,0x08,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x0C,0x00,0x00,0x10,0x00,0x00},/*"~",94*/
};

/**
 *******************************************************************************
 * @brief       Logo 
 *******************************************************************************
 */
//#pragma pack(push)
//#pragma pack(4)
const static uint8_t gLogoX[47040] = {
0xE4,0xE8,0xE0,0xFF,0xE0,0x07,0xFF,0x07,0x1F,0x00,0x1F,0xF8,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xE0,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3E,0xEF,0x9C,0xD6,
0x7B,0xD6,0x5B,0xCE,0x9C,0xD6,0x3E,0xE7,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x1D,0xE7,0xFA,0xC5,0x17,0xA5,0x55,0x8C,0xF4,0x83,0xB3,0x7B,
0xB3,0x7B,0x14,0x8C,0xB7,0x9C,0xD9,0xBD,0x3E,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x92,0x94,0x6D,0x6B,0x8E,0x73,
0x8E,0x73,0x0C,0x63,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0x07,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x1D,0xE7,0xF7,0xA4,0xF2,0x6A,0x6E,0x39,0x8C,0x20,0x0B,0x10,0x0B,0x10,0x0B,0x10,
0x0C,0x10,0x0C,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x10,0x6C,0x20,0x6E,0x39,0x33,0x73,
0x58,0xB5,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3E,0xEF,0xD7,0xA4,0xF2,0x6A,
0x0E,0x31,0x2B,0x18,0x0B,0x10,0x0C,0x10,0x2C,0x18,0x2C,0x18,0x4C,0x18,0x4C,0x18,
0x4D,0x18,0x4C,0x18,0x2C,0x18,0x0C,0x10,0x0B,0x10,0x4C,0x18,0x30,0x52,0x38,0xAD,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x41,0x08,0x21,0x00,0x41,0x08,
0x41,0x08,0x00,0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x1F,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1A,0xC6,0x12,0x6B,0x8C,0x20,
0x0B,0x10,0x2C,0x18,0x4D,0x18,0x8D,0x20,0x8D,0x20,0x8D,0x20,0x6D,0x20,0x2C,0x18,
0x2C,0x18,0x2C,0x18,0x4D,0x18,0x8D,0x20,0xAD,0x28,0x8D,0x20,0x8D,0x20,0x4D,0x18,
0x0C,0x10,0x0B,0x10,0xF0,0x49,0xFA,0xC5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xBC,0xDE,0x94,0x7B,0xCD,0x28,0x0B,0x10,0x2C,0x18,0x6D,0x18,
0x8D,0x20,0x8D,0x20,0x6D,0x20,0x4C,0x18,0x2C,0x18,0x0C,0x10,0x0C,0x10,0x0C,0x18,
0x4C,0x18,0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x6D,0x20,0x0C,0x10,
0x2B,0x18,0x15,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x82,0x10,0xC3,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x1F,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x7E,0xF7,0x94,0x7B,0x6C,0x18,0x0B,0x10,0x4D,0x18,0x8D,0x20,
0xAD,0x28,0xAD,0x28,0x8D,0x20,0x2C,0x18,0x0B,0x10,0xED,0x30,0xD2,0x6A,0x56,0x94,
0xF7,0xA4,0x76,0x94,0x33,0x73,0x6C,0x20,0x2C,0x18,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0x6D,0x20,0x0B,0x10,0x2E,0x31,0xFD,0xE6,0xFF,0xFF,0xFF,0xFF,
0xF7,0xA4,0x0D,0x31,0x0B,0x10,0x4D,0x18,0x8D,0x20,0xAD,0x28,0xAD,0x28,0x6D,0x20,
0x0C,0x10,0x2C,0x18,0x50,0x5A,0x36,0x8C,0x79,0xB5,0x1A,0xC6,0x5A,0xCE,0x99,0xBD,
0x35,0x8C,0x6E,0x39,0x0B,0x10,0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0x8D,0x20,0x2C,0x18,0xAC,0x20,0x3D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,0x00,0x00,0x82,0x10,0x82,0x10,
0x41,0x08,0xAB,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFD,0xE6,0x30,0x52,0x0B,0x08,0x4C,0x18,0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0x6D,0x20,0x0B,0x10,0xED,0x28,0x96,0x9C,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x56,0x94,0x0B,0x10,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x10,0x74,0x7B,0x8C,0x20,
0x0C,0x10,0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0x0B,0x08,0x91,0x5A,
0x3B,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xDC,0xDE,0xCD,0x28,0x6D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x10,0xDD,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x7B,0x21,0x00,0xA2,0x10,0xA2,0x10,
0x21,0x00,0xD3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0xEF,0x10,0x4A,
0x0B,0x08,0x6D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x6D,0x20,0x0B,0x10,
0xCF,0x49,0x7B,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x99,0xB5,0x0B,0x10,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0x8D,0x20,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0x6D,0x20,0x0B,0x10,0x33,0x73,0xDF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCD,0x28,0x8D,0x20,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x53,0x73,0x0B,0x08,0x6D,0x20,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x10,0x6E,0x39,0x9C,0xD6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD2,0x62,0x4D,0x18,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0x8D,0x20,0x0B,0x10,0xEF,0x49,0x9F,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDC,0xDE,0x0B,0x10,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0x71,0x5A,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFA,0xC5,0x6C,0x18,0x2C,0x18,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0x4B,0x18,0x58,0xAD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0xEF,0x0B,0x10,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0x6D,0x20,0x2B,0x18,0xB9,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0D,0x31,0x8D,0x20,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x0A,0x08,0x9E,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x4D,0x6B,0x4D,0x6B,0x4D,0x6B,0x2C,0x63,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0x30,0x84,
0x24,0x21,0x00,0x00,0x00,0x00,0x82,0x10,0xEB,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x10,0x84,0x25,0x21,0x21,0x00,0x00,0x00,0x82,0x10,0xEC,0x5A,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x72,0x8C,0xE7,0x39,0x82,0x10,0x00,0x00,0x00,0x00,0x62,0x08,0xE8,0x39,
0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x08,0x42,0x62,0x08,0x00,0x00,
0x41,0x08,0x08,0x42,0x38,0xC6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0x5A,0x2D,0x63,
0x2D,0x63,0x0C,0x63,0xD3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x5D,0xEF,0xCF,0x7B,0x86,0x31,0x62,0x08,0x00,0x00,0x00,0x00,0x61,0x08,0x65,0x29,
0x8E,0x73,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x7B,0x2C,0x63,
0x4D,0x6B,0x0C,0x63,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF7,0xBD,0x0C,0x63,0x4D,0x6B,0x4D,0x6B,0xEB,0x5A,0x5D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x0C,0x63,0x4D,0x6B,0x4D,0x6B,
0xEB,0x5A,0xF7,0xBD,0xFF,0xFF,0x7D,0xEF,0xEB,0x5A,0x4D,0x6B,0x4D,0x6B,0x2C,0x63,
0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2D,0x63,0x4D,0x6B,0x4D,0x6B,0x2C,0x63,
0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x8A,0x52,0xA2,0x10,0x00,0x00,0x00,0x00,
0x04,0x21,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF2,0x6A,0x0B,0x10,0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0x0B,0x10,0x50,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6E,0x39,
0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x0C,0x10,
0xCF,0x49,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x33,0x73,0x4D,0x18,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x2C,0x18,0x55,0x94,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x41,0x08,0x41,0x08,0x00,0x00,0xEF,0x7B,0x59,0xCE,0x00,0x00,0x20,0x00,
0x62,0x08,0x82,0x10,0xA2,0x10,0x82,0x10,0x21,0x00,0x41,0x08,0xFF,0xFF,0xFF,0xFF,
0xB2,0x94,0x00,0x00,0x20,0x00,0x62,0x08,0x82,0x10,0xA2,0x10,0x82,0x10,0x21,0x00,
0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x51,0x8C,
0x00,0x00,0x20,0x00,0x61,0x08,0x82,0x10,0x82,0x10,0xA2,0x10,0x82,0x10,0x61,0x08,
0x00,0x00,0x25,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0xE4,0x18,0x00,0x00,0x61,0x08,0x82,0x10,0xA2,0x10,
0x82,0x10,0x61,0x08,0x00,0x00,0xEB,0x5A,0xFF,0xFF,0xBA,0xD6,0x00,0x00,0x41,0x08,
0x41,0x08,0x00,0x00,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2D,0x63,
0x00,0x00,0x21,0x00,0x62,0x08,0x82,0x10,0x82,0x10,0xA2,0x10,0x82,0x10,0x62,0x08,
0x21,0x00,0x00,0x00,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x29,0x42,0x00,0x00,
0x41,0x08,0x00,0x00,0x08,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC3,0x18,0x20,0x00,0x41,0x08,0x41,0x08,0x00,0x00,0x9A,0xD6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x20,0x00,0x21,0x00,0x41,0x08,0x21,0x00,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x00,0x00,0x41,0x08,0x41,0x08,0x00,0x00,
0xEB,0x5A,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0x00,0x00,0x41,0x08,0x41,0x08,0x00,0x00,
0x4D,0x6B,0xFF,0xFF,0x86,0x31,0x00,0x00,0x41,0x08,0x82,0x10,0xA2,0x10,0x82,0x10,
0x62,0x08,0x00,0x00,0x69,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x7E,0xF7,0xCD,0x28,0x2C,0x18,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,
0x8D,0x20,0x0B,0x08,0xF7,0xA4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x94,0x7B,
0x4D,0x18,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x20,0x0B,0x08,0xB4,0x83,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x56,0x94,0x2C,0x18,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x6D,0x20,0x30,0x52,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x28,0x42,0x00,0x00,0x62,0x08,0x41,0x08,
0x41,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x20,0x00,0x30,0x84,0xAF,0x73,
0x00,0x00,0x62,0x08,0x41,0x08,0x21,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x21,0x00,0x2C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x00,0x00,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x41,0x08,0x21,0x00,0x41,0x08,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x41,0x08,0xA2,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBA,0xD6,0x00,0x00,0x62,0x08,0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,
0x21,0x00,0x41,0x08,0xA2,0x10,0x00,0x00,0xAE,0x73,0x55,0xAD,0x20,0x00,0xA2,0x10,
0xA2,0x10,0x00,0x00,0xDB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC7,0x39,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,0x21,0x00,0x41,0x08,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x00,0x00,0x59,0xCE,0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x41,0x08,
0xA2,0x10,0x62,0x08,0x65,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF7,0xBD,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x38,0xC6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x51,0x8C,0xFF,0xFF,0xFF,0xFF,0x8E,0x73,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,
0x0C,0x63,0x41,0x08,0x61,0x08,0x61,0x08,0x21,0x00,0x41,0x08,0xA2,0x10,0xA2,0x10,
0xA2,0x10,0xA2,0x10,0x00,0x00,0x96,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1A,0xC6,
0x0B,0x10,0x6D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x6D,0x20,
0x4B,0x18,0xFD,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x97,0x9C,
0x2C,0x18,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x08,0x99,0xB5,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0x9C,0x2C,0x18,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x8D,0x20,0xCD,0x28,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,
0x21,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0x21,0x00,0x82,0x10,0xCF,0x7B,
0x10,0x84,0x62,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,
0x20,0x00,0xE3,0x18,0xF0,0x7B,0x30,0x84,0xA2,0x10,0x82,0x10,0xA2,0x10,0xA2,0x10,
0x82,0x10,0xA3,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x4A,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x00,0x00,0xAB,0x52,0x51,0x8C,0x6D,0x6B,0x21,0x00,0x62,0x08,
0xA2,0x10,0xA2,0x10,0x20,0x00,0x6D,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0x62,0x08,0x00,0x00,0x6D,0x6B,
0xB3,0x94,0xAB,0x52,0x00,0x00,0x82,0x10,0x41,0x08,0x86,0x31,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x00,0x00,0x2C,0x63,0x51,0x8C,0xAE,0x73,0x62,0x08,0x82,0x10,
0xA2,0x10,0xA2,0x10,0x62,0x08,0x86,0x31,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x20,0x00,
0xA2,0x10,0x82,0x10,0x82,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x65,0x29,0x62,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xB6,0xB5,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA2,0x10,0x82,0x10,0xA2,0x10,0x82,0x10,0x21,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x86,0x31,0x62,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0xEF,0x7B,0x21,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x61,0x08,0x62,0x08,0x00,0x00,0x29,0x42,0x71,0x8C,0x0C,0x63,0x00,0x00,0xA2,0x10,
0xA2,0x10,0xA2,0x10,0x41,0x08,0x69,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0x9C,0x0B,0x08,
0x8D,0x20,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0xCD,0x28,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xAD,
0x2C,0x18,0xAD,0x28,0xAD,0x28,0x8D,0x20,0x0B,0x10,0x7B,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x36,0x8C,0x4C,0x18,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x20,0x4B,0x18,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,
0x61,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xEC,0x5A,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x0C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x82,0x10,0x61,0x08,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x82,0x10,0x82,0x10,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA2,0x10,
0x82,0x10,0xA2,0x10,0x82,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x28,0x42,0x41,0x08,0xA2,0x10,0xA2,0x10,0x62,0x08,0xA3,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x00,0x00,0xA2,0x10,0x82,0x10,0xA2,0x10,0xA2,0x10,
0x62,0x08,0x86,0x31,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x41,0x08,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,
0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x34,0xA5,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x71,0x8C,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x21,0x00,0x82,0x10,0xA2,0x10,0x82,0x10,0x20,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x61,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x61,0x08,0x82,0x10,0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x72,0x8C,0x21,0x00,
0xA2,0x10,0xA2,0x10,0x62,0x08,0x45,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD4,0x83,0x0B,0x08,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0x4D,0x18,0x6E,0x39,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x18,0xAD,
0x2C,0x18,0xAD,0x28,0x8D,0x20,0x0B,0x10,0x3E,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x33,0x73,0x4D,0x18,0xAD,0x28,
0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x28,0xAD,0x20,0x4B,0x18,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x21,0x00,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x41,0x08,0x28,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x61,0x08,0x08,0x42,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x62,0x08,0x45,0x29,0xFF,0xFF,0xFF,0xFF,0x21,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x18,0xC6,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x00,0x00,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8E,0x73,0x41,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x41,0x08,0x8E,0x73,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x79,0xCE,0xD7,0xBD,0x14,0xA5,
0x10,0x84,0x76,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA7,0x31,
0x62,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x00,0x00,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE8,0x39,
0x61,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x20,0x00,0xD3,0x9C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x24,0x21,0x62,0x08,0xA2,0x10,0x82,0x10,0x20,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0xA7,0x31,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x61,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,
0x62,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x61,0x08,0xE8,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x13,0x6B,0x0A,0x00,0x2C,0x18,0x4C,0x18,
0x4C,0x18,0x4C,0x18,0x4C,0x18,0x2C,0x18,0x0C,0x10,0x6E,0x39,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x15,0x8C,
0x0B,0x08,0x2C,0x18,0x0B,0x10,0x3D,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2E,0x31,0x0C,0x10,0x4C,0x18,
0x4C,0x18,0x4C,0x18,0x4C,0x18,0x4C,0x18,0x4C,0x18,0x2C,0x18,0x8C,0x20,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x00,0x00,
0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x59,0xCE,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x41,0x08,0xEC,0x5A,0xFF,0xFF,0x14,0xA5,0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,
0xEC,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x20,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0x6E,0x6B,
0x41,0x08,0xA2,0x10,0xA2,0x10,0x41,0x08,0x8E,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x82,0x10,
0x82,0x10,0xA2,0x10,0x82,0x10,0xA3,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x00,0x00,0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x62,0x08,0xA2,0x10,0xA2,0x10,0x21,0x00,0x51,0x8C,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x71,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x20,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0xAE,0x73,
0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x41,0x08,0x4D,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1D,0xE7,0x15,0x8C,0xB7,0x9C,0xB7,0x9C,0xB7,0x9C,
0xB7,0x9C,0xB7,0x9C,0xB7,0x9C,0x97,0x9C,0x15,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFA,0xC5,
0x97,0x9C,0x15,0x8C,0xDC,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x56,0x94,0xB7,0x9C,0xB7,0x9C,
0xB7,0x9C,0xB7,0x9C,0xB7,0x9C,0xB7,0x9C,0xB7,0x9C,0x97,0x9C,0xF8,0xA4,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x76,0xAD,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x61,0x08,0x49,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x92,0x94,0x20,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,0x49,0x4A,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,0x21,0x00,0xA2,0x10,0xA2,0x10,
0x20,0x00,0xB2,0x94,0xFF,0xFF,0x08,0x42,0x61,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x21,0x00,0xEF,0x7B,0xFF,0xFF,0xFF,0xFF,0xC3,0x18,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x3C,0xE7,0x18,0xC6,0x14,0xA5,0x30,0x84,0xEB,0x5A,0x04,0x21,0x62,0x08,
0xA2,0x10,0xA2,0x10,0x41,0x08,0x8A,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA2,0x10,
0x82,0x10,0xA2,0x10,0x00,0x00,0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,0x8A,0x52,0x41,0x08,
0xA2,0x10,0x61,0x08,0xAB,0x52,0x61,0x08,0xA2,0x10,0x21,0x00,0xCF,0x7B,0xFF,0xFF,
0xFF,0xFF,0xA7,0x31,0x61,0x08,0xA2,0x10,0x82,0x10,0x20,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x0C,0x63,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0xB6,0xB5,
0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0x45,0x29,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,0x41,0x08,
0xA2,0x10,0xA2,0x10,0x00,0x00,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF7,0xA4,0x73,0x7B,0xF4,0x8B,0xF4,0x8B,0xF4,0x8B,0xF4,0x8B,
0xF4,0x8B,0xF4,0x8B,0xD4,0x83,0x14,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD4,0x83,
0x32,0x73,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9C,0xD6,0x93,0x7B,0xF4,0x8B,0xF4,0x83,
0xF4,0x8B,0xF4,0x8B,0xF4,0x8B,0xF4,0x8B,0xF4,0x8B,0xB4,0x7B,0x19,0xC6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8E,0x73,0x41,0x08,
0xA2,0x10,0xA2,0x10,0x20,0x00,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xAA,0x52,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0x55,0xAD,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x61,0x08,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x9A,0xD6,0xFF,0xFF,0x62,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,
0xC3,0x18,0xA3,0x10,0xA3,0x10,0xA3,0x10,0xA3,0x10,0xA3,0x10,0xA3,0x10,0xC3,0x18,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x21,0x00,0x30,0x84,0xFF,0xFF,0xDF,0xFF,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x82,0x10,0xC3,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,
0x61,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x4D,0x6B,0x04,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x21,0x00,0x41,0x08,0x82,0x10,0xA2,0x10,
0xA2,0x10,0xA2,0x10,0x20,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x66,0x29,
0x62,0x08,0xA2,0x10,0x20,0x00,0xB3,0x94,0xFF,0xFF,0xBE,0xF7,0x00,0x00,0xA2,0x10,
0x82,0x10,0x21,0x00,0xBE,0xF7,0x00,0x00,0xA2,0x10,0x41,0x08,0x6D,0x6B,0xFF,0xFF,
0xDB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x72,0x8C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x24,0x21,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x9E,0xF7,
0xFF,0xFF,0xFF,0xFF,0x6D,0x6B,0x41,0x08,0xA2,0x10,0xA2,0x10,0x21,0x00,0x71,0x8C,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x39,0x62,0x08,
0xA2,0x10,0xA2,0x10,0x00,0x00,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x99,0xBD,0x0A,0x00,0x2C,0x18,0x2C,0x18,0x2C,0x18,0x2C,0x18,0x2C,0x18,
0x2C,0x18,0x0C,0x18,0x0A,0x00,0xDD,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5E,0xEF,0x08,0x00,
0xF5,0x83,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x91,0x5A,0x0C,0x10,0x2C,0x18,0x2C,0x18,
0x2C,0x18,0x2C,0x18,0x2C,0x18,0x2C,0x18,0x2C,0x18,0x0A,0x00,0xFD,0xE6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x86,0x31,0x62,0x08,
0xA2,0x10,0xA2,0x10,0x00,0x00,0x1B,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC3,0x18,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xBE,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x62,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x82,0x10,0x82,0x10,0x82,0x10,0x82,0x10,0x82,0x10,0x82,0x10,0x82,0x10,0x82,0x10,
0xA2,0x10,0xA2,0x10,0xA2,0x10,0x20,0x00,0xB2,0x94,0xFF,0xFF,0xBA,0xD6,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x41,0x08,0x0C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,
0x08,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,0x00,0x00,0x41,0x08,0x82,0x10,
0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,0x21,0x00,0x00,0x00,0x82,0x10,0xA2,0x10,
0xA2,0x10,0xA2,0x10,0x00,0x00,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8A,0x52,
0x41,0x08,0xA2,0x10,0x41,0x08,0xCF,0x7B,0xFF,0xFF,0x2C,0x63,0x41,0x08,0xA2,0x10,
0x21,0x00,0xAE,0x73,0xFF,0xFF,0x00,0x00,0xA2,0x10,0x41,0x08,0xEB,0x5A,0xFF,0xFF,
0x69,0x4A,0x41,0x08,0xA2,0x10,0x82,0x10,0x21,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x82,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x86,0x31,0x62,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0xBA,0xD6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x20,0x00,0x82,0x10,
0xA2,0x10,0x82,0x10,0x21,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x5D,0xEF,0xCC,0x28,0x8F,0x41,0x8F,0x41,0x8F,0x41,0x8F,0x41,0x8F,0x41,0x8F,0x41,
0x8F,0x41,0x0E,0x31,0x58,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0x9C,0x50,0x52,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0D,0x31,0x8F,0x41,0x8F,0x41,0x8F,0x41,
0x8F,0x41,0x8F,0x41,0x8F,0x41,0x8F,0x41,0x6F,0x39,0x71,0x5A,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0xA2,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,
0x25,0x21,0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x61,0x08,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF7,0xBD,0xFF,0xFF,0x18,0xC6,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x41,0x08,0xEF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x51,0x8C,0x21,0x00,0xA2,0x10,0xA2,0x10,0x21,0x00,
0x10,0x84,0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x21,0x00,0x00,0x00,0x25,0x21,0x0C,0x63,0x71,0x8C,0x9A,0xD6,0x65,0x29,0x82,0x10,
0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,
0x41,0x08,0xA2,0x10,0x41,0x08,0xEB,0x5A,0xFF,0xFF,0x00,0x00,0xA2,0x10,0x82,0x10,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x21,0x00,0x82,0x10,0x61,0x08,0xAA,0x52,0xFF,0xFF,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x79,0xCE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,0x29,0x42,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x21,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x62,0x08,0x66,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x5B,0xCE,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,
0xDD,0xDE,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9B,0xD6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5E,0xEF,0xFD,0xE6,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,
0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0x1D,0xE7,0xBC,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x62,0x08,0xA7,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x18,0xC6,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,0x8A,0x52,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,
0x2D,0x63,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,0xEB,0x5A,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x41,0x08,0x8E,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x04,0x21,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x17,0xC6,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x24,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,
0x20,0x00,0xA2,0x10,0x62,0x08,0x69,0x4A,0x92,0x94,0x21,0x00,0xA2,0x10,0x41,0x08,
0x4D,0x6B,0xFF,0xFF,0xFF,0xFF,0x82,0x10,0x82,0x10,0x61,0x08,0xAA,0x52,0xAF,0x73,
0x41,0x08,0xA2,0x10,0x82,0x10,0x21,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x92,0x94,0x20,0x00,0xA2,0x10,0xA2,0x10,0x21,0x00,0x30,0x84,0xFF,0xFF,
0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0xC7,0x39,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x41,0x08,0x6D,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8E,0x41,
0x0B,0x08,0x0B,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x10,
0x09,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x15,0x8C,0x96,0x9C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAC,0x28,0x0B,0x08,0x0B,0x10,0x0B,0x10,0x0B,0x10,
0x0B,0x10,0x0B,0x10,0x0B,0x10,0x0B,0x08,0xEC,0x28,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0x9C,0x20,0x00,0xA2,0x10,
0xA2,0x10,0x41,0x08,0xAE,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x10,0x84,0x21,0x00,0xA2,0x10,0xA2,0x10,0x20,0x00,0x72,0x8C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8E,0x73,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0x41,0x08,0x82,0x10,0xA2,0x10,0x61,0x08,0x28,0x42,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x00,0x00,
0xA2,0x10,0xA2,0x10,0x62,0x08,0xA6,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0x00,0x00,0xA2,0x10,0xA2,0x10,0x21,0x00,0x30,0x84,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x41,0x08,0xEB,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x18,0xC6,
0x00,0x00,0xA2,0x10,0x82,0x10,0x45,0x29,0xA3,0x10,0x82,0x10,0xA2,0x10,0x00,0x00,
0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0x45,0x29,0x82,0x10,0x82,0x10,0x65,0x29,0x82,0x10,
0xA2,0x10,0xA2,0x10,0x00,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x8A,0x52,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0x18,0xC6,0xFF,0xFF,
0xFF,0xFF,0xF3,0x9C,0x20,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0xCF,0x7B,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4D,0x6B,0x41,0x08,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0x83,0x0B,0x08,
0x8D,0x18,0x8D,0x20,0x8D,0x18,0x8D,0x18,0x8D,0x18,0x8D,0x20,0x8D,0x18,0x0B,0x10,
0x99,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCE,0x41,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xD9,0xBD,0x0B,0x08,0x8D,0x18,0x8D,0x18,0x8D,0x18,0x8D,0x18,
0x8D,0x18,0x8D,0x18,0x8D,0x18,0x0A,0x08,0xBC,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0C,0x63,0x41,0x08,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x96,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x29,0x42,0x61,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x86,0x31,0x62,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,
0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xC7,0x39,0x61,0x08,0xA2,0x10,0x82,0x10,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0x82,0x10,
0x69,0x4A,0xEF,0x7B,0x75,0xAD,0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x00,0x00,
0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0xC3,0x18,
0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x00,0x00,0xA2,0x10,0xA2,0x10,0x00,0x00,0x38,0xC6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA6,0x31,0x62,0x08,0xA2,0x10,
0xA2,0x10,0x20,0x00,0xD3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x82,0x10,0xA2,0x10,0x41,0x08,0xEB,0x5A,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x39,0x62,0x08,0xA2,0x10,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC3,0x18,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xEC,0x5A,0x41,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0xB6,0xB5,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x65,0x29,0x62,0x08,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x9E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x04,0x21,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x61,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x21,0x00,0x82,0x10,0xA2,0x10,0x82,0x10,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,
0x28,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x04,0x21,0x41,0x08,
0x61,0x08,0x21,0x00,0x00,0x00,0x39,0xC6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE3,0x18,
0x82,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,
0xD3,0x9C,0x00,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x41,0x08,0xAA,0x52,
0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0xAB,0x52,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0x5A,0x00,0x00,0xA2,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x7D,0xEF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAA,0x52,0x41,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xDF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0xC3,0x18,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x24,0x21,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xBE,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x82,0x10,0xA2,0x10,
0x82,0x10,0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x28,0xD2,0x40,0xD0,0x80,0xD0,
0x80,0xD0,0x80,0xD0,0x80,0xD0,0x80,0xD0,0x80,0xD0,0x60,0xD0,0x00,0xC8,0xD6,0xED,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0xC2,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x95,0xED,0x00,0xC8,0x60,0xD0,0x80,0xD0,0x80,0xD0,0x80,0xD0,0x80,0xD0,
0x80,0xD0,0x60,0xD0,0x20,0xC0,0x7D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x82,0x10,0x82,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x24,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0xC7,0x39,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x04,0x21,0x61,0x08,0xA2,0x10,0xA2,0x10,
0x21,0x00,0x04,0x21,0xD3,0x9C,0x96,0xB5,0xCF,0x7B,0x41,0x08,0x61,0x08,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x4D,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,
0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x82,0x10,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x20,0x00,0x92,0x94,
0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x20,0x00,
0xA7,0x31,0xF0,0x7B,0x0C,0x63,0x61,0x08,0x21,0x00,0x82,0x10,0xA2,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xA2,0x10,0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x41,0x08,0x8A,0x52,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6D,0x6B,0x41,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x82,0x10,0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF7,0xBD,0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0xAB,0x52,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x61,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x61,0x08,0xE7,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x99,0xEE,0x00,0xB8,0xA1,0xC8,0xA1,0xC0,
0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,0x60,0xC0,0x85,0xC1,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0xC2,0x58,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x81,0xB8,0x81,0xC8,0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,0xA1,0xC0,
0xA1,0xC0,0x20,0xC0,0x95,0xED,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xCE,0x00,0x00,0xA2,0x10,0xA2,0x10,
0x61,0x08,0x29,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xB5,
0x00,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0x0C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,0x20,0x00,0xA2,0x10,0xA2,0x10,0x41,0x08,0xCF,0x7B,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x00,0x00,0x62,0x08,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x20,0x00,0x00,0x00,0x41,0x08,0x82,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x08,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC7,0x39,0x00,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x21,0x00,0xE3,0x18,0x45,0x29,0x82,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xBA,0xD6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE8,0x39,0x41,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x62,0x08,0x41,0x08,0x41,0x08,0x82,0x10,0x20,0x00,0xE4,0x18,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x00,0x00,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x86,0x31,0x62,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x3D,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,0x21,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,
0x00,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x10,0x84,0x21,0x00,0xA2,0x10,0xA2,0x10,0x20,0x00,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,
0x79,0xCE,0x00,0x00,0xA2,0x10,0xA2,0x10,0x61,0x08,0x49,0x4A,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x20,0x00,0xA2,0x10,0xA2,0x10,
0x21,0x00,0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x51,0x8C,0x00,0x00,0x61,0x08,0x61,0x08,
0x00,0x00,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6E,0x6B,
0x00,0x00,0x61,0x08,0x61,0x08,0x00,0x00,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xCB,0x5A,0x00,0x00,0x61,0x08,0x61,0x08,0x00,0x00,0xB6,0xB5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0xC3,0x18,0x00,0x00,
0x62,0x08,0xA2,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x82,0x10,0x41,0x08,0x00,0x00,
0xAE,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xEB,0x5A,0x00,0x00,0x20,0x00,0x41,0x08,0x41,0x08,0x00,0x00,0x00,0x00,
0xEB,0x5A,0xFF,0xFF,0x20,0x00,0xA2,0x10,0xA2,0x10,0x82,0x10,0x21,0x00,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x41,0x08,0x21,0x00,0x82,0x10,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x41,0x08,0x00,0x00,0xB6,0xB5,0xEF,0x7B,0x00,0x00,0x61,0x08,
0x61,0x08,0x00,0x00,0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x8A,0x52,0x00,0x00,0x61,0x08,0x61,0x08,0x20,0x00,0x28,0x42,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB3,0x94,0x00,0x00,0x61,0x08,0x61,0x08,0x41,0x08,
0x41,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xC7,0x39,0x20,0x00,0x61,0x08,0x62,0x08,0x00,0x00,0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,
0x51,0x8C,0x00,0x00,0x61,0x08,0x61,0x08,0x00,0x00,0x30,0x84,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAA,0x52,0x00,0x00,0x61,0x08,0x61,0x08,
0x00,0x00,0xD6,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x60,0xB8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,
0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0x40,0xB8,0xDE,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x60,0xC0,0x91,0xDC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xF6,
0x20,0xC0,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0xA1,0xC8,0x80,0xC8,
0x03,0xB9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAF,0x73,0xE7,0x39,0x28,0x42,0x28,0x42,
0xA6,0x31,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0C,0x63,
0xE8,0x39,0x28,0x42,0x28,0x42,0x86,0x31,0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x8A,0x52,0x08,0x42,0x28,0x42,0x28,0x42,0x86,0x31,0x9E,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x14,0xA5,
0x86,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x10,0x4D,0x6B,0x7D,0xEF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x92,0x94,0x6D,0x6B,0xAE,0x73,0x34,0xA5,0xFF,0xFF,
0xFF,0xFF,0x1C,0xE7,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0xA7,0x31,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0x5A,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xEC,0x5A,0xBE,0xF7,0xFF,0xFF,0xD7,0xBD,0xA7,0x31,0x28,0x42,
0x28,0x42,0xA7,0x31,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xB2,0x94,0xC7,0x39,0x28,0x42,0x28,0x42,0xA6,0x31,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xBD,0xA7,0x31,0x28,0x42,0x28,0x42,0xC7,0x39,
0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x08,0x42,0x08,0x42,0x28,0x42,0x08,0x42,0x86,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xAE,0x73,0xE7,0x39,0x28,0x42,0x28,0x42,0xA6,0x31,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6A,0x4A,0x08,0x42,0x28,0x42,0x08,0x42,
0xA6,0x31,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xEE,0x64,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,
0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0xC6,0xD1,0xEB,0xD2,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x0B,0xCB,0x23,0xC9,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC6,0xC1,
0xC6,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0xE6,0xD1,0x64,0xC9,
0x7D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0xF3,0x9C,0x9A,0xD6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xD3,0x9C,0x20,0x00,0xA2,0x10,0xA2,0x10,0x21,0x00,0x51,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,
0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xF7,0x1B,0xF7,0x1C,0xF7,0x3C,0xF7,0x3C,0xF7,
0x3C,0xF7,0x1C,0xF7,0x1C,0xF7,0x1C,0xF7,0xFB,0xF6,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x99,0xF6,0xDA,0xF6,0x5D,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xEE,0x1B,0xF7,
0x3C,0xF7,0x3C,0xF7,0x3C,0xF7,0x1C,0xF7,0x3C,0xF7,0x1C,0xF7,0xBA,0xEE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x00,0x00,0x00,0x00,
0x00,0x00,0x21,0x00,0x24,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x65,0x29,0x62,0x08,0xA2,0x10,0xA2,0x10,0x00,0x00,0x1C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x64,0xD1,0x60,0xD0,0x81,0xD0,0x81,0xD0,0x81,0xD0,
0x81,0xD0,0x81,0xD0,0x81,0xD0,0x81,0xD0,0x00,0xC8,0xF7,0xED,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0xDC,
0x20,0xD0,0x20,0xD0,0x4C,0xDB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA9,0xD2,0x40,0xD0,0x81,0xD0,
0x81,0xD0,0x81,0xD0,0x81,0xD0,0x81,0xD0,0x80,0xD0,0x00,0xC0,0x75,0xED,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x39,0xC6,0x00,0x00,0xA2,0x10,
0xA2,0x10,0x82,0x10,0x00,0x00,0x38,0xC6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x10,0x84,0x00,0x00,0xA2,0x10,0xA2,0x10,0x62,0x08,0x45,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0xC8,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x81,0xC8,0x7D,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x30,0xDC,0x80,0xD0,
0x23,0xD9,0xA1,0xD0,0x95,0xED,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0B,0xD3,0xA1,0xD0,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x03,0xD9,0x60,0xC8,0xF7,0xED,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x82,0x10,
0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0x08,0x42,0x4D,0x6B,0xCB,0x5A,0xC3,0x18,
0x20,0x00,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x81,0xC0,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xA1,0xC8,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCE,0xDB,0x80,0xD0,0x23,0xD9,
0x23,0xD9,0x81,0xD0,0xBA,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAA,0xD2,0xA1,0xD0,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x02,0xD9,0x60,0xC8,0x58,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x71,0x8C,0x00,0x00,
0x82,0x10,0xA2,0x10,0xA2,0x10,0xA2,0x10,0x61,0x08,0x41,0x08,0x41,0x08,0x82,0x10,
0xA2,0x10,0xA2,0x10,0x82,0x10,0x00,0x00,0x2C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0x81,0xC8,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xA1,0xC8,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0xD2,0x80,0xD0,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x80,0xD0,0x5C,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC6,0xC9,0xA1,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0xE2,0xD8,0xC2,0xC8,0x1C,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x71,0x8C,
0x00,0x00,0x00,0x00,0x41,0x08,0x62,0x08,0x82,0x10,0x82,0x10,0x82,0x10,0x62,0x08,
0x41,0x08,0x00,0x00,0x00,0x00,0x92,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA1,0xC8,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x81,0xC8,0x5C,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE6,0xC9,0xA1,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x80,0xD0,0x5C,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF7,0xED,0xA1,0xC8,0xE2,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0xA1,0xD0,0xC6,0xC9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x35,0xA5,0x0C,0x63,0xA6,0x31,0x04,0x21,0xA2,0x10,0x04,0x19,0xA7,0x31,
0xEC,0x5A,0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x44,0xD1,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xA1,0xD0,0xD6,0xED,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x99,0xF6,0xA1,0xC8,0xE2,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x81,0xD0,0x99,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0xDB,
0x40,0xD0,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x02,0xD9,0x60,0xC8,
0xCE,0xDB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0xDB,0xC2,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xC2,0xD8,0x4C,0xDB,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x30,0xDC,0x60,0xC8,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0xA1,0xD0,0xD2,0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xFF,0xE6,0xC9,0xA1,0xD0,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xA1,0xD8,0x03,0xC9,0x58,0xEE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDA,0xEE,0x79,0xEE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xE5,
0x9E,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xF6,0x60,0xC8,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x03,0xD9,0xC1,0xC8,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1B,0xF7,0xC6,0xC9,
0x81,0xD0,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x02,0xD9,0xA5,0xC9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x91,0xE4,0x81,0xC8,0xE2,0xD8,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0xE2,0xD8,0x60,0xC8,0xAD,0xDB,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0xC9,0x2B,0xDB,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x17,0xEE,0x00,0xB0,
0x7D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0xD2,0xA1,0xD8,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xC2,0xD8,0x0B,0xD3,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0x6D,0xDB,0x80,0xC8,0xE2,0xD8,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x81,0xD0,0x34,0xE5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xB6,0xED,0x44,0xC9,0xA1,0xD0,0x03,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0xE2,0xD8,0x60,0xD0,0x07,0xD2,0x1B,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xF6,0xDB,0xEE,0xBA,0xF6,
0x54,0xDD,0xFF,0xFF,0x1C,0xF7,0x34,0xDD,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xED,
0x13,0xDD,0x1C,0xF7,0xFF,0xFF,0xFF,0xFF,0x40,0xC8,0xB6,0xED,0xFF,0xFF,0xD6,0xED,
0xFB,0xEE,0xFF,0xFF,0x99,0xF6,0xF3,0xDC,0x1C,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBA,0xF6,0x9A,0xF6,0xFF,0xFF,0xFF,0xFF,0x99,0xF6,0x79,0xEE,0xFF,0xFF,
0xDB,0xF6,0xF3,0xDC,0x58,0xEE,0xFF,0xFF,0xFF,0xFF,0x5D,0xF7,0x17,0xEE,0xFF,0xFF,
0xFF,0xFF,0xF7,0xE5,0x5D,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xE5,0xFF,0xFF,
0xFF,0xFF,0x38,0xEE,0x3C,0xF7,0xFF,0xFF,0x99,0xEE,0xDB,0xEE,0x3C,0xF7,0x79,0xEE,
0xFF,0xFF,0x59,0xEE,0x9E,0xF7,0x38,0xEE,0x75,0xE5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x65,0xC9,0xC1,0xD8,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x81,0xD0,0xAE,0xDB,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xDB,0xF6,0x4C,0xDB,0xA1,0xC8,0xC1,0xD8,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x03,0xD9,0xE2,0xD8,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x03,0xD9,0x81,0xC8,0x75,0xE5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xD2,0xE4,0x44,0xC9,0x81,0xD0,0x02,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xE2,0xD8,
0x60,0xD0,0xA6,0xC9,0x38,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0xD2,0x60,0xC8,0xEA,0xD2,
0xA1,0xD0,0xA5,0xD1,0x89,0xCA,0x03,0xD1,0x07,0xCA,0xFF,0xFF,0xE7,0xB9,0x23,0xC9,
0x0B,0xDB,0x00,0xC0,0x3C,0xF7,0xBA,0xF6,0x00,0xC0,0x3C,0xF7,0x02,0xC9,0xA5,0xC9,
0xFF,0xFF,0x6D,0xDB,0xA1,0xC8,0x0B,0xDB,0x00,0xC0,0x9A,0xF6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x8D,0xD3,0x03,0xC9,0xFF,0xFF,0x7D,0xFF,0x00,0xC0,0x17,0xEE,0x50,0xE4,
0x00,0xC0,0xA9,0xDA,0x60,0xC8,0x6C,0xD3,0xFF,0xFF,0x6D,0xDB,0xE2,0xC8,0xFF,0xFF,
0xFB,0xF6,0x00,0xC0,0x9A,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xC0,0xFB,0xF6,
0x3C,0xF7,0x00,0xC8,0x91,0xE4,0xFF,0xFF,0x00,0xC0,0x58,0xEE,0x68,0xD2,0x27,0xD2,
0xFF,0xFF,0x20,0xC0,0x03,0xC9,0xEB,0xD2,0x20,0xC8,0xEF,0xDB,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0xCA,0x60,0xD0,
0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xA1,0xD0,
0x64,0xC9,0xF3,0xE4,0xFB,0xF6,0xDF,0xFF,0xFF,0xFF,0x9E,0xFF,0x1B,0xF7,0xB6,0xE5,
0xCE,0xDB,0x64,0xC9,0x80,0xD0,0xC2,0xD8,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x03,0xD9,
0xE2,0xD8,0x80,0xD0,0x23,0xC9,0x2C,0xDB,0x60,0xC8,0xE2,0xD8,0x23,0xD9,0x23,0xD9,
0x23,0xD9,0x23,0xD9,0x23,0xD9,0x03,0xD9,0x81,0xD0,0x07,0xD2,0x54,0xE5,0x3C,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xFF,0x99,0xEE,0xB2,0xE4,0x68,0xD2,0xA1,0xC8,
0xA1,0xD0,0x02,0xD9,0x23,0xD9,0x23,0xD9,0x03,0xD9,0xC1,0xD8,0x60,0xC8,0x28,0xD2,
0x38,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x81,0xC8,0xAD,0xDB,0xFF,0xFF,
0xC6,0xC9,0x48,0xD2,0xFF,0xFF,0xEB,0xDA,0x48,0xDA,0xFF,0xFF,0x9D,0xFF,0x1C,0xF7,
0x58,0xF6,0x20,0xC8,0xBA,0xF6,0x14,0xE5,0xC1,0xD8,0x23,0xD1,0x68,0xD2,0xFF,0xFF,
0xDA,0xF6,0x00,0xC0,0xBA,0xFE,0xFF,0xFF,0x07,0xDA,0x6D,0xD3,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x95,0xED,0x60,0xC8,0xFF,0xFF,0xA9,0xD2,0x07,0xD2,0xDF,0xFF,0x00,0xC0,
0x95,0xED,0xFF,0xFF,0xB6,0xED,0x20,0xC8,0xFF,0xFF,0xC6,0xD1,0x4C,0xDB,0xFF,0xFF,
0x34,0xE5,0x20,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA1,0xC8,0x9A,0xEE,
0x0B,0xDB,0x81,0xD0,0xB2,0xEC,0x30,0xE4,0x85,0xC9,0xFF,0xFF,0xC2,0xC8,0xD2,0xE4,
0x5C,0xF7,0x00,0xD0,0xD6,0xED,0xFF,0xFF,0x64,0xD1,0xCE,0xE3,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xE5,
0x03,0xC9,0x80,0xD0,0xC2,0xD8,0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,
0x02,0xD9,0xA1,0xD8,0x80,0xD0,0xA1,0xC8,0xA1,0xC8,0x81,0xC8,0x80,0xD0,0xA1,0xD0,
0xC2,0xD8,0x02,0xD9,0x03,0xD9,0x02,0xD9,0xC2,0xD8,0xA1,0xD8,0x80,0xD0,0xA1,0xC0,
0xCA,0xDA,0xD6,0xED,0xFF,0xFF,0xFF,0xFF,0x1C,0xF7,0x89,0xD2,0x60,0xC8,0xC1,0xD8,
0x03,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0x23,0xD9,0xE2,0xD8,0xA1,0xD8,0x80,0xD0,
0xA1,0xC8,0xC2,0xC0,0xA1,0xC8,0x81,0xC8,0x80,0xD0,0xA1,0xD8,0xE2,0xD8,0x03,0xD9,
0x23,0xD9,0x03,0xD9,0xE2,0xD8,0x80,0xD0,0xC2,0xC8,0xEF,0xDB,0x7D,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5D,0xF7,0x00,0xC8,0x99,0xEE,0xFF,0xFF,
0x00,0xC8,0x75,0xED,0xFF,0xFF,0xE2,0xC8,0x71,0xDC,0xDB,0xF6,0x60,0xB8,0x27,0xD2,
0xA9,0xDA,0x60,0xD0,0xFF,0xFF,0x2C,0xD3,0x60,0xD0,0xC6,0xD9,0x85,0xC9,0xFF,0xFF,
0xD2,0xE4,0x81,0xD0,0x27,0xCA,0xE6,0xC9,0x28,0xDA,0xD2,0xDC,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFB,0xFE,0x20,0xC8,0x99,0xF6,0x00,0xC0,0x5D,0xFF,0x96,0xED,0x00,0xC8,
0xFF,0xFF,0xFF,0xFF,0x55,0xED,0x40,0xC8,0xFF,0xFF,0x60,0xC8,0x54,0xE5,0xFF,0xFF,
0x2B,0xDB,0xA5,0xD1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE6,0xD1,0x50,0xEC,
0xA1,0xC0,0xB2,0xE4,0x8D,0xE3,0x80,0xC8,0x59,0xF6,0xDF,0xFF,0x00,0xC8,0xDA,0xF6,
0x54,0xE5,0x20,0xC0,0xFF,0xFF,0xFF,0xFF,0x20,0xC0,0x95,0xE5,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xF7,0xED,0x0B,0xDB,0x03,0xC9,0x80,0xD0,0x81,0xD0,0xA1,0xD8,0xC1,0xD0,
0xC2,0xD8,0xC2,0xD8,0xC2,0xD8,0xC2,0xD8,0xC1,0xD8,0xA1,0xD8,0xA1,0xD8,0x81,0xD0,
0x80,0xD0,0x81,0xC8,0xC2,0xC0,0xA5,0xD1,0x2C,0xDB,0xF3,0xDC,0xBA,0xF6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xFF,0x2F,0xDC,
0x44,0xC9,0x60,0xD0,0xA1,0xD8,0xE2,0xD8,0x02,0xD9,0x03,0xD9,0x03,0xD9,0x23,0xD9,
0x03,0xD9,0x03,0xD9,0x03,0xD9,0x03,0xD9,0x03,0xD9,0x02,0xD9,0xE2,0xD8,0xA1,0xD8,
0x80,0xD0,0xC2,0xC8,0xEB,0xDA,0xF7,0xED,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xED,0x00,0xC8,0xFF,0xFF,0xDA,0xF6,
0x00,0xC0,0x3C,0xF7,0xDF,0xFF,0x00,0xC8,0x9A,0xF6,0x2B,0xDB,0x07,0xDA,0xFF,0xFF,
0xEA,0xD2,0x23,0xC9,0xFF,0xFF,0x03,0xD1,0xCE,0xE3,0xFF,0xFF,0x00,0xC0,0x5D,0xFF,
0x38,0xEE,0x00,0xC8,0xFF,0xFF,0xFF,0xFF,0x8D,0xD3,0xBF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x81,0xC8,0xA5,0xD1,0x2B,0xDB,0xFF,0xFF,0x79,0xF6,0x00,0xC8,
0x58,0xF6,0xFF,0xFF,0xE3,0xC8,0xAA,0xD2,0xDF,0xFF,0x00,0xC8,0xDA,0xFE,0x3C,0xFF,
0x40,0xC8,0xAE,0xDB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0xD3,0x40,0xD0,
0x50,0xE4,0xF7,0xF5,0x40,0xD0,0xE6,0xC9,0xFF,0xFF,0xB6,0xED,0x00,0xC0,0xFF,0xFF,
0x2B,0xDB,0xE6,0xD1,0xFF,0xFF,0x99,0xF6,0x00,0xC8,0x5D,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xFF,0x38,0xEE,0xF3,0xDC,0x30,0xE4,
0x8D,0xDB,0x4C,0xDB,0x0B,0xDB,0x6C,0xDB,0xAE,0xDB,0x50,0xE4,0xF3,0xDC,0xD6,0xED,
0x9A,0xF6,0x9D,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x3C,0xF7,0x13,0xE5,0x0B,0xDB,0x85,0xC9,0xE2,0xC8,0xA1,0xD0,0x60,0xD0,
0x80,0xD0,0x80,0xD0,0x80,0xD0,0xA1,0xD0,0xE2,0xC8,0x85,0xC9,0xEA,0xDA,0xB1,0xDC,
0x9A,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0xD3,0x44,0xC1,0xFF,0xFF,0xD2,0xDC,
0x60,0xB8,0xFF,0xFF,0xF7,0xE5,0x00,0xB0,0xFF,0xFF,0x38,0xEE,0x40,0xC0,0xC2,0xB8,
0x48,0xD2,0xC6,0xC1,0xFF,0xFF,0x00,0xB0,0x17,0xEE,0xFF,0xFF,0x03,0xC1,0x0F,0xD4,
0xFF,0xFF,0x6D,0xDB,0x40,0xB8,0x40,0xB8,0xCE,0xDB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC6,0xD1,0x60,0xC8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0xDB,
0x20,0xB8,0x00,0xB8,0x48,0xD2,0xFF,0xFF,0xFF,0xFF,0x44,0xC9,0x60,0xB8,0xCA,0xD2,
0x81,0xB8,0x95,0xE5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x50,0xDC,0x40,0xB8,
0xFF,0xFF,0x38,0xEE,0x00,0xB8,0x58,0xEE,0xFF,0xFF,0xAE,0xD3,0x44,0xC1,0xFF,0xFF,
0x23,0xB9,0xCE,0xD3,0xFF,0xFF,0x91,0xD4,0xA1,0xB8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0x3C,0xF7,
0x1B,0xF7,0xFB,0xF6,0x5C,0xF7,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x3C,0xFF,0x60,0xC8,0x91,0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF3,0xDC,0x00,0xC0,0x27,0xCA,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x24,0x29,0x00,0x00,0x4D,0x6B,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0xD2,0x9C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xCE,0x00,0x00,0xC2,0x18,0x20,0x08,0xA6,0x39,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xBE,0xF7,0x00,0x00,0x00,0x00,0xC6,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x08,0x00,0x00,0xE3,0x20,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xEB,0x62,0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xB5,0x20,0x08,0xC2,0x18,0xC2,0x18,0x00,0x00,
0x96,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,
0x81,0x10,0xA2,0x18,0xC2,0x18,0x61,0x10,0xA2,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x71,0x94,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0x00,0x00,0xC2,0x18,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x61,0x10,0xC2,0x18,0x81,0x10,
0xA2,0x18,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xA2,0x18,0x81,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x20,0x08,0xC2,0x18,0xC2,0x18,0x20,0x08,
0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xB5,0x20,0x08,
0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x20,0x08,0x92,0x94,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xCA,0x5A,0x00,0x00,0x00,0x00,0x4D,0x6B,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF7,0xC5,0x00,0x00,0xC2,0x18,0x41,0x10,0xCB,0x5A,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0xA6,0x31,
0xC3,0x20,0x50,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8D,0x73,0x20,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xA2,0x18,0x00,0x00,0x50,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x28,0x42,0x81,0x10,0xC2,0x18,0x20,0x08,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD2,0x9C,0x40,0x10,0xC2,0x18,0xA2,0x18,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0xA6,0x39,0x00,0x00,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x08,0xF3,0xA4,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x61,0x10,0xA2,0x18,0xC2,0x18,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xEF,0x83,0x61,0x10,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x52,0x40,0x08,
0xA2,0x18,0x00,0x00,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xCA,0x5A,0x00,0x08,0xC2,0x18,0xA2,0x18,0x61,0x10,0x61,0x10,
0xA2,0x18,0xC2,0x18,0x40,0x08,0x40,0x08,0xF3,0xA4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xAE,0x7B,0x20,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0x14,0xA5,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0B,0x63,0x81,0x10,0xC2,0x18,0x40,0x08,0x96,0xB5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x65,0x31,0x00,0x00,0x82,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x00,0x00,0xA2,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x00,0x00,0x5D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x4D,0x6B,0x61,0x10,0xC2,0x18,0xC2,0x18,0x00,0x00,0x1C,0xE7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x65,0x31,0xA2,0x18,
0xC2,0x18,0xA2,0x18,0x03,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x59,0xCE,0xC2,0x18,0x41,0x10,0xC2,0x18,0x81,0x10,0xC2,0x18,0x30,0x84,0x4C,0x6B,
0x40,0x08,0x40,0x08,0xC2,0x18,0xA2,0x18,0x20,0x08,0xE3,0x20,0x1C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAA,0x52,
0x00,0x08,0xC2,0x18,0xC2,0x18,0x61,0x10,0x61,0x10,0xC2,0x18,0x00,0x08,0x24,0x29,
0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0xFB,0xDE,0x59,0xCE,0x18,0xC6,
0x95,0xB5,0x34,0xAD,0x55,0xAD,0xC2,0x18,0xA2,0x18,0xC2,0x18,0x03,0x21,0x92,0x94,
0xCE,0x7B,0xAE,0x7B,0xAE,0x73,0xAE,0x7B,0xCF,0x7B,0xEF,0x83,0x10,0x84,0x30,0x8C,
0xB2,0x94,0x34,0xA5,0xB6,0xB5,0x59,0xCE,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xD6,
0x2C,0x6B,0x40,0x08,0x20,0x08,0xA2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0xA2,0x18,0x44,0x29,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x00,0x00,0x7D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x2C,0x6B,0x61,0x10,0xC2,0x18,0xC2,0x18,0x00,0x00,0xDB,0xDE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x81,0x18,
0xC2,0x18,0xC2,0x18,0x41,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0xA6,0x39,
0x00,0x00,0xA2,0x18,0xC2,0x18,0x61,0x10,0x24,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x71,0x94,0x40,0x08,0x61,0x10,0xC2,0x18,0xA2,0x18,0x00,0x00,0x59,0xCE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,0xA2,0x18,0x61,0x10,
0xC2,0x18,0xA2,0x18,0x20,0x08,0x51,0x8C,0x0F,0x84,0x00,0x00,0x81,0x10,0xA2,0x18,
0x20,0x08,0x82,0x10,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x54,0xAD,0xE3,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x08,
0x20,0x08,0x40,0x08,0x40,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,
0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x40,0x10,0x40,0x08,0x20,0x08,0x00,0x08,0x00,0x00,0x00,0x08,0xC7,0x41,0xDB,0xDE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0x00,0x00,
0x20,0x08,0x40,0x10,0x40,0x08,0x00,0x00,0x20,0x08,0x44,0x29,0x28,0x4A,0xA2,0x18,
0xC2,0x18,0x82,0x18,0x08,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBE,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x00,0x08,0xBE,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x4C,0x6B,0x61,0x10,0xC2,0x18,0xC2,0x18,0x00,0x08,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0x5A,0x81,0x10,
0xC2,0x18,0xA2,0x18,0xE3,0x20,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x18,0xC6,0xC6,0x39,0x61,0x10,0x20,0x08,0xA2,0x18,
0xC2,0x18,0xC2,0x18,0x61,0x10,0x44,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCB,0x5A,0x00,0x00,0xA2,0x18,0xA2,0x18,0x81,0x10,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4D,0x6B,0x00,0x00,0xA2,0x18,0xC2,0x18,
0xA2,0x18,0x00,0x00,0xDB,0xDE,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0xA6,0x39,0x20,0x08,
0xC2,0x18,0xA2,0x18,0x40,0x08,0x00,0x08,0x69,0x52,0xB6,0xBD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x5D,0xEF,0x00,0x00,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xA2,0x18,0x82,0x18,0x81,0x10,0x81,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x61,0x10,0x81,0x10,0x82,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,
0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x83,
0x2C,0x6B,0xEF,0x7B,0xF3,0xA4,0x79,0xCE,0xFF,0xFF,0xFF,0xFF,0x95,0xB5,0x40,0x08,
0xC2,0x18,0x81,0x10,0x48,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x40,0x08,0x00,0x00,
0x20,0x08,0xF7,0xC5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBE,0xF7,0x00,0x00,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x6D,0x73,0x61,0x10,0xC2,0x18,0x82,0x18,0xC7,0x39,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x61,0x10,
0xC2,0x18,0x81,0x18,0x08,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0x81,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x20,0x08,0x07,0x42,0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x28,0x4A,0x75,0xB5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x18,0xC6,0x40,0x10,0x00,0x00,0x41,0x10,
0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0x41,0x10,0x41,0x10,0xC2,0x18,0xC2,0x18,0x81,0x10,
0x40,0x08,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8D,0x73,
0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x20,0x08,0x20,0x08,0xC6,0x39,
0x30,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x1C,0xE7,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0x61,0x10,
0x24,0x29,0xE7,0x41,0x48,0x4A,0xAA,0x5A,0x0C,0x63,0x6D,0x73,0x8E,0x73,0xAE,0x7B,
0xCE,0x7B,0xEF,0x7B,0x0F,0x84,0x0F,0x84,0xEF,0x83,0xEF,0x7B,0xCF,0x7B,0xCE,0x7B,
0x8E,0x73,0x0B,0x63,0x07,0x42,0x20,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x61,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xAD,0x40,0x08,
0xC2,0x18,0x81,0x10,0x69,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0xA2,0x18,0xC2,0x18,
0xA2,0x18,0x00,0x00,0xE7,0x41,0x38,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBE,0xF7,0x00,0x00,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x0F,0x84,0x61,0x10,0xC2,0x18,0x61,0x10,0x8D,0x73,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x51,0x8C,0x61,0x10,
0xC2,0x18,0x61,0x10,0x6D,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x00,0x00,0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0xCE,0x7B,0x00,0x00,0x81,0x10,0x00,0x00,
0x96,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0xA4,0x9E,0xF7,
0xFF,0xFF,0xE7,0x41,0x20,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x20,0x08,0x85,0x31,
0xFF,0xFF,0xFF,0xFF,0x08,0x42,0x03,0x21,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xEF,0x83,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x82,0x18,
0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xE3,0x20,0xA2,0x18,0xC2,0x18,0x81,0x10,0x48,0x4A,0xBE,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x82,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x44,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x20,0x08,
0xC2,0x18,0x81,0x10,0x89,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,0x40,0x08,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x81,0x18,0x00,0x08,0x61,0x10,0x30,0x8C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBE,0xF7,0x00,0x00,0xC2,0x18,0xC2,0x18,0x40,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xCE,0x2C,0x6B,0x48,0x4A,
0x4D,0x6B,0x14,0xA5,0x4D,0x6B,0x81,0x10,0xC2,0x18,0x61,0x10,0x71,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x40,0x08,
0xC2,0x18,0x61,0x10,0x71,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x49,0x4A,0x00,0x08,0xA2,0x18,0x20,0x08,0x81,0x10,
0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0x41,0x81,0x10,0xC2,0x18,0x61,0x10,
0x0C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xC3,0x20,0x81,0x10,0xA2,0x18,0x61,0x10,0x00,0x00,0x50,0x8C,0xFF,0xFF,
0xFF,0xFF,0x0C,0x63,0x20,0x08,0xA2,0x18,0x00,0x00,0x18,0xC6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xEF,0x83,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,
0xA2,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xAE,0x73,0x61,0x10,0xC2,0x18,0x40,0x08,0x96,0xB5,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x65,0x31,0xA2,0x18,0xC2,0x18,0x20,0x08,
0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x20,0x08,
0xC2,0x18,0x81,0x10,0xCA,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x00,0x00,0x20,0x08,0x40,0x08,
0x40,0x08,0x40,0x08,0x40,0x10,0x61,0x10,0x61,0x10,0x00,0x00,0x14,0xA5,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xC2,0x18,0xC2,0x18,0x41,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xDE,0x24,0x29,0x00,0x00,0x61,0x10,0x81,0x10,
0x61,0x10,0x40,0x08,0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,0x00,0x00,
0x20,0x08,0x40,0x08,0xAA,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0x85,0x31,
0x20,0x08,0x41,0x10,0x44,0x29,0x89,0x52,0xCB,0x5A,0x4D,0x6B,0x69,0x52,0x82,0x18,
0xC2,0x18,0x82,0x18,0x49,0x4A,0xCF,0x7B,0xCE,0x7B,0xCF,0x7B,0xEF,0x7B,0x0F,0x84,
0x10,0x84,0x30,0x8C,0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0xC3,0x20,0x71,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xAD,0x20,0x08,0xC2,0x18,0x20,0x08,
0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFB,0xDE,0x82,0x18,0x61,0x10,0x4C,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x4C,0x6B,0x61,0x10,0xC2,0x18,0x00,0x00,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x00,0x00,0x40,0x08,0x40,0x08,0x00,0x00,0x44,0x29,
0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0x00,0x08,0xC2,0x18,0xA2,0x18,0xE7,0x41,0x8D,0x73,0x92,0x94,
0x34,0xA5,0x96,0xB5,0xF7,0xBD,0x18,0xC6,0x38,0xC6,0x38,0xC6,0x18,0xC6,0xF7,0xC5,
0xD7,0xBD,0xB6,0xB5,0x75,0xB5,0x55,0xAD,0x34,0xA5,0x14,0xA5,0xD3,0x9C,0xB2,0x9C,
0x71,0x94,0x10,0x84,0xAE,0x7B,0x2C,0x6B,0x81,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x59,0xCE,0x20,0x08,
0xC2,0x18,0x81,0x10,0x4C,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x54,0xAD,0x34,0xA5,
0x14,0xA5,0xF3,0x9C,0x92,0x94,0xEF,0x83,0x2C,0x6B,0xEF,0x83,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xC2,0x18,0xC2,0x18,0x81,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x00,0x00,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x81,0x10,0x61,0x10,0x00,0x00,0xBA,0xD6,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0x82,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x81,0x10,0x81,0x10,0x61,0x10,0x82,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x82,0x18,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x61,0x10,0x61,0x10,0x00,0x00,0x65,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC2,0x18,0xA2,0x18,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x58,0xCE,0x00,0x08,0xA2,0x18,0x65,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB2,0x94,0xB2,0x9C,0xFB,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x20,0x08,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x41,0x10,
0x40,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,
0x20,0x08,0x20,0x08,0x20,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x10,
0x41,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0xC2,0x18,0xC2,0x18,0x61,0x10,0xAE,0x7B,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x8E,0x73,
0xAE,0x7B,0x8E,0x73,0x0B,0x63,0x69,0x52,0xA6,0x39,0x65,0x31,0x44,0x29,0xA2,0x18,
0xC2,0x18,0xA2,0x18,0x44,0x29,0x8A,0x52,0xAA,0x5A,0x6D,0x73,0x51,0x8C,0x9A,0xD6,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xC2,0x18,0xA2,0x18,0xC2,0x18,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x28,0x4A,0x20,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0xA2,0x18,0x61,0x10,0x81,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,0xE3,0x20,
0x49,0x4A,0x4C,0x6B,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0x89,0x52,0x61,0x10,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,
0x82,0x18,0xA2,0x18,0x61,0x10,0x61,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x71,0x94,0x20,0x08,0x61,0x10,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x08,0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x65,0x31,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,
0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0xFB,0xDE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0x4A,0x00,0x00,0x61,0x10,
0x61,0x10,0x61,0x10,0x81,0x10,0x81,0x10,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x81,0x10,0x81,0x10,0x61,0x10,0x41,0x10,0x00,0x00,
0xCA,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xC2,0x18,0xA2,0x18,0xE3,0x18,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x61,0x10,0x61,0x10,0x40,0x08,0x00,0x00,0x00,0x08,0xA2,0x18,
0xA6,0x39,0x0B,0x63,0xAA,0x5A,0x81,0x18,0xC2,0x18,0x40,0x08,0xB6,0xBD,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0x00,0x00,0x40,0x08,
0x20,0x08,0x00,0x00,0x00,0x00,0x41,0x10,0x81,0x10,0x03,0x21,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xA2,0x18,0xC2,0x18,0x03,0x21,0x45,0x31,0x65,0x31,0x86,0x31,0xA6,0x39,
0x85,0x31,0x65,0x31,0x89,0x52,0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC7,0x39,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFB,0xDE,0x03,0x21,0x82,0x10,0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x85,0x31,0x20,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x4D,0x6B,0x61,0x10,0xC2,0x18,0xC2,0x18,0x00,0x08,0x00,0x00,
0x00,0x08,0x20,0x08,0x40,0x08,0x41,0x10,0x61,0x10,0x81,0x10,0xA2,0x18,0xE3,0x20,
0x03,0x21,0x24,0x29,0x24,0x29,0x24,0x29,0x03,0x21,0x03,0x21,0xC2,0x18,0x82,0x10,
0x61,0x10,0x20,0x08,0x00,0x00,0xA2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x00,0x00,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x82,0x18,0x82,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x20,0x08,
0x20,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0x79,0xCE,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x9E,0xF7,0x00,0x00,0xC2,0x18,0xA2,0x18,0xE3,0x20,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x18,0xC6,0x89,0x52,0xEB,0x62,0xD2,0x9C,0xDB,0xDE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x40,0x08,0xC2,0x18,0x20,0x08,0xD7,0xBD,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x54,0xAD,
0xD7,0xBD,0x1C,0xE7,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x20,0x08,
0xC2,0x18,0x40,0x08,0xB6,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x24,0x29,0x61,0x10,0xA2,0x18,0x00,0x00,0x71,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x54,0xAD,0x40,0x08,0xC2,0x18,0x82,0x18,0xDB,0xDE,0x3C,0xE7,
0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x85,0x31,0xA2,0x18,0x81,0x10,0xEB,0x62,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC6,0x39,0x81,0x10,0xC2,0x18,0xA2,0x18,
0x81,0x10,0x40,0x08,0x00,0x00,0x20,0x08,0x04,0x29,0x07,0x42,0x49,0x4A,0x82,0x18,
0xC2,0x18,0xA2,0x18,0x08,0x42,0x30,0x8C,0xCF,0x7B,0x8D,0x73,0x4D,0x6B,0x51,0x8C,
0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x52,0x00,0x00,0x00,0x00,
0x65,0x31,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x03,0x21,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,0xC2,0x18,0x20,0x08,0xF7,0xBD,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x20,0x08,
0xC2,0x18,0x40,0x08,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xCE,
0x20,0x08,0x2C,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x61,0x10,0xA2,0x18,0xC2,0x18,0xA2,0x18,0x03,0x21,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x00,0x00,0xC2,0x18,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x40,0x08,0xC2,0x18,0x40,0x08,0xF3,0xA4,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0x6B,0x00,0x00,0x00,0x00,0x61,0x10,
0xCB,0x5A,0x13,0xA5,0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x20,0x08,
0xC2,0x18,0x61,0x10,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6D,0x73,0x20,0x08,0xC2,0x18,0xC2,0x18,
0xA2,0x18,0x20,0x08,0x00,0x00,0x45,0x31,0xCA,0x5A,0xDB,0xDE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x03,0x21,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,0xC2,0x18,0x20,0x08,0x18,0xC6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,
0xC2,0x18,0x40,0x08,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x42,
0x61,0x10,0x00,0x00,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x40,0x08,0xC2,0x18,0x41,0x10,0x71,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xB2,0x94,0x40,0x08,0xC2,0x18,0x00,0x00,0xFB,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0xDB,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x85,0x31,0xA2,0x18,
0xC2,0x18,0x61,0x10,0xEF,0x83,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x21,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x40,0x08,0x00,0x00,0x7D,0xEF,0xFF,0xFF,
0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x24,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x54,0xAD,0x40,0x08,0xC2,0x18,0x20,0x08,0x38,0xC6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB2,0x9C,0x40,0x08,
0xC2,0x18,0x40,0x08,0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x20,0x08,
0xC2,0x18,0x81,0x10,0x28,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xA6,0x39,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x42,0x82,0x18,0xC2,0x18,0x40,0x08,0xE7,0x41,
0x48,0x4A,0xE7,0x41,0x65,0x31,0xE3,0x20,0xA2,0x18,0x40,0x08,0x20,0x08,0x20,0x08,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x08,0x61,0x10,0xA2,0x18,
0xC2,0x18,0x81,0x10,0x40,0x08,0xC2,0x18,0xA2,0x18,0x82,0x18,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xCE,0x00,0x00,0xC2,0x18,
0xC2,0x18,0x61,0x10,0x71,0x94,0x92,0x94,0x89,0x52,0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x52,0x00,0x00,0x40,0x08,0x20,0x08,
0x00,0x00,0x00,0x00,0x00,0x00,0xA2,0x18,0x45,0x29,0xAE,0x7B,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x5D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x24,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x55,0xAD,0x20,0x08,0xC2,0x18,0x20,0x08,0x9A,0xD6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,
0xC2,0x18,0x20,0x08,0xD7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0x6B,0x61,0x10,
0xC2,0x18,0xC2,0x18,0x03,0x21,0xE7,0x41,0xA6,0x39,0xA6,0x39,0xA6,0x39,0xE7,0x41,
0x03,0x21,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC3,0x20,0x65,0x31,0x24,0x29,0x24,0x29,
0x03,0x21,0x03,0x21,0x04,0x21,0x24,0x29,0x45,0x29,0xA6,0x39,0x28,0x4A,0x0B,0x63,
0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,0x20,0x08,0xC2,0x18,0xC2,0x18,0x82,0x18,
0x81,0x10,0x82,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x40,0x08,0xEF,0x83,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x65,0x31,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0x61,0x10,0x71,0x94,0x75,0xAD,0x00,0x00,0x00,0x00,0x48,0x4A,0xDF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x13,0xA5,0x79,0xCE,
0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x5D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x44,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xD6,0xBD,0x20,0x08,0xC2,0x18,0x61,0x10,0x10,0x84,0x8E,0x73,
0x8A,0x52,0x86,0x31,0x18,0xC6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xEF,0x7B,0x00,0x00,0x00,0x00,0xE3,0x20,0x48,0x4A,0x69,0x52,0x82,0x18,
0xC2,0x18,0x61,0x10,0xAE,0x7B,0x10,0x84,0x8E,0x73,0xCE,0x7B,0xB2,0x9C,0xBE,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4C,0x6B,0x00,0x08,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0x82,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,
0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0x81,0x10,0x00,0x00,
0x50,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x20,0x08,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x61,0x10,0x20,0x08,0x00,0x08,0x00,0x08,0x20,0x08,0x61,0x10,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x20,0x08,0x00,0x08,0x20,0x08,0x40,0x10,
0x81,0x10,0xA2,0x18,0xA2,0x18,0x61,0x10,0x61,0x10,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x54,0xAD,0x00,0x08,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x61,0x10,0x30,0x8C,0xFF,0xFF,0xA2,0x18,0xA2,0x18,0x61,0x10,0x00,0x00,
0x58,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x5D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x44,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xBE,0xF7,0xB6,0xB5,0x69,0x52,0x81,0x10,0xC2,0x18,0xC2,0x18,0x61,0x10,0x61,0x10,
0x61,0x10,0x00,0x00,0x50,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x07,0x42,0x20,0x08,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x81,0x18,0x82,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,0x40,0x08,0x00,0x00,
0x51,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0x50,0x8C,0x81,0x10,0x41,0x10,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0x82,0x18,0x81,0x10,0x61,0x10,0x61,0x10,
0x82,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x61,0x10,0x81,0x10,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,
0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xB5,0x00,0x00,0x00,0x00,0x04,0x29,
0xCF,0x7B,0xB6,0xB5,0xDB,0xDE,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xE7,0x41,0x82,0x18,
0xC2,0x18,0x81,0x10,0x69,0x52,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x58,0xCE,0x91,0x94,
0x28,0x4A,0xA2,0x18,0x81,0x10,0x69,0x52,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x59,0xCE,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x61,0x10,0x30,0x8C,0xFF,0xFF,0x0F,0x84,0x61,0x10,0xC2,0x18,0xA2,0x18,
0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7D,0xEF,0x00,0x00,0xC2,0x18,0xA2,0x18,0x44,0x29,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0xC6,0x39,0x61,0x10,
0x00,0x00,0x20,0x08,0x81,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,
0x00,0x00,0x8D,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,
0x00,0x08,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x81,0x10,0x61,0x10,0x40,0x10,0x20,0x08,
0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0x00,0x00,0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x92,0x94,
0xE7,0x41,0x82,0x18,0x00,0x08,0x41,0x10,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,
0x20,0x08,0x61,0x10,0xC3,0x20,0x65,0x31,0xE7,0x41,0xAA,0x5A,0x8D,0x73,0x71,0x8C,
0x69,0x52,0x81,0x10,0xC2,0x18,0x81,0x10,0xAA,0x5A,0x30,0x8C,0xCE,0x7B,0x8D,0x73,
0x0B,0x63,0x28,0x4A,0x65,0x31,0x61,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0xB2,0x94,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xDE,0xBA,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8D,0x73,0x61,0x10,
0xC2,0x18,0x61,0x10,0x8D,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0B,0x63,
0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0x00,0x00,0xC2,0x18,0xC2,0x18,0x81,0x10,0xC2,0x18,
0xC2,0x18,0x41,0x10,0x51,0x8C,0xFF,0xFF,0xFB,0xDE,0x00,0x00,0xC2,0x18,0xC2,0x18,
0x20,0x08,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x3C,0xEF,0x1C,0xE7,0xDB,0xDE,0xFB,0xDE,
0x5C,0xEF,0xDB,0xDE,0x20,0x08,0xC2,0x18,0xA2,0x18,0x65,0x31,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0x24,0x29,0x00,0x08,0x81,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x24,0x29,0xCE,0x7B,
0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0x6B,
0x00,0x00,0x00,0x00,0x20,0x08,0x24,0x29,0x28,0x4A,0x8D,0x73,0x92,0x94,0x96,0xB5,
0x59,0xCE,0x3C,0xE7,0xBE,0xF7,0xFF,0xFF,0x0B,0x63,0x61,0x10,0xC2,0x18,0xC2,0x18,
0x00,0x00,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,0x00,0x00,
0x81,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0xEB,0x62,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x10,0x84,0x61,0x10,0xC2,0x18,0x40,0x08,0xF3,0xA4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x30,0x8C,0x61,0x10,
0xC2,0x18,0x61,0x10,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0xE3,0x20,0x40,0x08,
0x00,0x00,0xAE,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0x00,0x00,0xA2,0x18,0xC2,0x18,0x00,0x08,0xD2,0x9C,0x61,0x10,
0xC2,0x18,0x41,0x10,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xA2,0x18,0x81,0x10,0xC2,0x18,
0x00,0x00,0x55,0xAD,0xFF,0xFF,0xBE,0xF7,0x71,0x8C,0xAA,0x5A,0xC7,0x39,0x24,0x29,
0xC2,0x18,0x61,0x10,0x00,0x08,0x20,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,
0x00,0x08,0x40,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x4C,0x6B,0x50,0x8C,
0xB6,0xB5,0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x61,0x10,0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x61,0x10,0x20,0x08,0xC2,0x18,0xC2,0x18,0x00,0x08,0x1C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x9A,0xD6,0x1B,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0xA4,0x40,0x10,0xC2,0x18,0x82,0x18,
0xA6,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xCE,0x00,0x00,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x81,0x10,0x20,0x08,0x00,0x08,0xF3,0xA4,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x30,0x8C,0x41,0x10,0xC2,0x18,0x40,0x08,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xCE,0xE3,0x20,0x00,0x00,
0x89,0x52,0xD2,0x9C,0x9A,0xD6,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x40,0x08,
0xC2,0x18,0x41,0x10,0x91,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0xEB,0x62,0x00,0x00,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0x00,0x00,0xD7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x34,0xAD,0x00,0x00,0xC2,0x18,0xC2,0x18,0x61,0x10,0xAA,0x5A,0xDF,0xFF,0x00,0x08,
0xC2,0x18,0x41,0x10,0x71,0x94,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x24,0x29,0x00,0x00,
0xC6,0x39,0xFF,0xFF,0x30,0x84,0x00,0x00,0x40,0x08,0x81,0x10,0x82,0x18,0xA2,0x18,
0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,0x41,0x10,
0x20,0x08,0x00,0x00,0x00,0x00,0x86,0x39,0x6D,0x73,0x75,0xAD,0x7D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x86,0x31,0x81,0x10,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x40,0x08,
0x40,0x08,0x30,0x8C,0xF7,0xBD,0x40,0x08,0xC2,0x18,0x00,0x08,0xBA,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x21,0xA2,0x18,0xC2,0x18,0x00,0x00,
0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x84,
0x00,0x00,0x00,0x00,0x61,0x10,0x28,0x4A,0x13,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x71,0x8C,0x41,0x10,0xC2,0x18,0x40,0x08,0xF3,0xA4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB2,0x9C,0x00,0x00,0xA2,0x18,0xC2,0x18,
0x81,0x10,0x40,0x10,0x00,0x08,0x00,0x00,0x20,0x08,0x20,0x08,0x61,0x10,0x04,0x21,
0x8A,0x52,0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x40,0x08,
0xC2,0x18,0x40,0x08,0xD2,0x9C,0xFF,0xFF,0xFF,0xFF,0x18,0xC6,0xCA,0x5A,0xD3,0x9C,
0xFF,0xFF,0xB6,0xB5,0xA6,0x39,0x00,0x00,0x61,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x82,0x18,0x65,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEB,0x62,
0x00,0x00,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xFF,0xFF,0xFB,0xE6,0x00,0x08,
0xC2,0x18,0x41,0x10,0x71,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0x61,0x10,0x20,0x08,0x00,0x00,0x20,0x08,0x61,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x20,0x08,0x20,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x40,0x08,0x00,0x00,0x45,0x29,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBA,0xD6,0x00,0x00,0xC2,0x18,0xA2,0x18,0x20,0x08,0x81,0x10,0xB2,0x94,
0xFF,0xFF,0xFF,0xFF,0x38,0xCE,0x20,0x08,0xC2,0x18,0x00,0x00,0xFB,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xBD,0x20,0x08,
0x00,0x00,0x00,0x00,0xA2,0x18,0xEF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x30,0x8C,0x20,0x08,0xC2,0x18,0x61,0x10,0x69,0x52,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xDF,0xFF,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x13,0xA5,0x40,0x08,0xC2,0x18,0x40,0x08,0x96,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xCE,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,0xA2,0x18,
0x81,0x10,0x00,0x00,0x49,0x4A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xAD,0x40,0x08,
0xC2,0x18,0x40,0x08,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xC2,0x18,0x40,0x10,0x40,0x08,
0x40,0x08,0x20,0x08,0x82,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,
0x81,0x10,0x00,0x00,0x69,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x03,0x21,0x40,0x10,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0x5D,0xEF,0xFF,0xFF,0xDB,0xDE,0x00,0x08,
0xC2,0x18,0x41,0x10,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xCB,0x5A,0x61,0x10,0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0xC3,0x20,
0x8E,0x73,0xB6,0xBD,0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x5D,0xEF,0x00,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x20,0x08,0x40,0x08,
0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x20,0x08,0x89,0x52,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xBE,0xFF,0x00,0x00,0x00,0x00,0x03,0x21,0x54,0xAD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x20,0x08,0xC2,0x18,0x00,0x00,0x1C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x61,0x10,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x41,0x10,0x00,0x00,0x8D,0x73,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x00,0x00,0xC2,0x18,0xA2,0x18,0x20,0x08,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0xF3,0xA4,
0x8E,0x73,0xCB,0x5A,0x08,0x42,0xC6,0x39,0x86,0x31,0x65,0x31,0x85,0x31,0xC6,0x39,
0x45,0x29,0xA2,0x18,0xC2,0x18,0xA2,0x18,0x65,0x31,0xE7,0x41,0xC7,0x39,0xC7,0x39,
0xC7,0x39,0xC7,0x39,0xA6,0x39,0xC7,0x39,0x89,0x52,0x30,0x8C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0B,0x63,0x00,0x00,0x61,0x10,0x40,0x08,0x00,0x08,
0x00,0x08,0x40,0x08,0x81,0x10,0xE3,0x20,0xE3,0x20,0x40,0x10,0x61,0x10,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x00,0x00,0x1C,0xE7,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,
0xC2,0x18,0x20,0x08,0x54,0xAD,0xFF,0xFF,0xFF,0xFF,0x69,0x52,0x81,0x10,0xC2,0x18,
0xC2,0x18,0xA2,0x18,0x40,0x08,0x40,0x08,0x61,0x10,0xC2,0x18,0x24,0x29,0xA6,0x39,
0x48,0x4A,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x83,0x00,0x00,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,0x20,0x08,
0xC2,0x18,0x41,0x10,0x51,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x4D,0x6B,0x00,0x00,0x40,0x10,0x00,0x00,0x28,0x4A,0x9A,0xD6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xA2,0x18,0xE3,0x20,0xFF,0xFF,0xB2,0x94,
0xA2,0x18,0x20,0x08,0x81,0x10,0xA2,0x18,0x81,0x10,0x00,0x00,0xCA,0x5A,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF7,0xC5,0x20,0x08,0xC2,0x18,0x00,0x00,0x3C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0xA6,0x39,
0x20,0x08,0x00,0x08,0x61,0x10,0xA2,0x18,0xC2,0x18,0x61,0x10,0x00,0x00,0x8E,0x73,
0xFF,0xFF,0xBE,0xF7,0x00,0x08,0xA2,0x18,0xC2,0x18,0x00,0x00,0x9A,0xD6,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,0x00,0x00,0x20,0x08,
0x61,0x10,0x81,0x10,0x81,0x18,0x82,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,
0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x82,0x18,0x82,0x18,0x82,0x18,
0x82,0x18,0x82,0x18,0xA2,0x18,0x82,0x18,0x81,0x10,0x20,0x08,0x82,0x10,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0xCE,0x7B,0x8D,0x73,0xD3,0x9C,0x59,0xCE,
0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6D,0x73,0x61,0x10,
0xC2,0x18,0xC2,0x18,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF3,0xA4,0x40,0x08,
0xC2,0x18,0x20,0x08,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0x79,0xD6,0x00,0x00,0xC2,0x18,
0xA2,0x18,0x24,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x4A,0x00,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x00,0x00,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0x20,0x08,
0xC2,0x18,0x61,0x10,0x51,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x8E,0x73,0x30,0x84,0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x81,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x34,0xAD,0x28,0x4A,0xE3,0x20,0xE7,0x41,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xD7,0xBD,0x20,0x08,0xC2,0x18,0x00,0x00,0x5D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0xAE,0x7B,0xC3,0x18,0x00,0x00,0x81,0x10,0xC2,0x18,0x41,0x10,
0x81,0x10,0xE3,0x20,0xA2,0x18,0xC2,0x18,0x00,0x00,0xF3,0x9C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0x40,0x08,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x82,0x18,0x81,0x10,0x81,0x10,0x81,0x10,
0x82,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x61,0x10,0x61,0x10,0x61,0x10,
0x61,0x10,0x81,0x10,0x81,0x10,0x81,0x10,0x81,0x10,0x61,0x10,0x20,0x08,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x71,0x94,0x61,0x10,
0xC2,0x18,0x61,0x10,0xEB,0x62,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x40,0x08,
0xC2,0x18,0x20,0x08,0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x69,0x52,0x61,0x10,
0xC2,0x18,0x00,0x00,0xFB,0xE6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xB2,0x94,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,
0x00,0x00,0x95,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0x20,0x08,
0xC2,0x18,0x61,0x10,0x30,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x61,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x40,0x08,0xC2,0x18,0x00,0x00,0x7D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x99,0xD6,0x28,0x4A,0x41,0x10,0xC2,0x18,
0xA2,0x18,0xA2,0x18,0xC2,0x18,0x41,0x10,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x40,0x08,0x24,0x29,0xE7,0x41,0x49,0x4A,0xCB,0x5A,0x2C,0x6B,
0x08,0x42,0x82,0x18,0xC2,0x18,0x81,0x10,0xAA,0x52,0xCF,0x7B,0x8D,0x73,0x6D,0x73,
0x4C,0x6B,0xEB,0x62,0xAA,0x5A,0x49,0x4A,0x48,0x4A,0x2C,0x6B,0xFB,0xDE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0x20,0x08,0xC2,0x18,
0xA2,0x18,0x00,0x08,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x92,0x94,0x40,0x10,
0xC2,0x18,0x20,0x08,0x75,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x61,0x10,
0xA2,0x18,0xA2,0x18,0x45,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x4D,0x6B,0x00,0x08,0xA2,0x18,0x81,0x10,0x00,0x00,0x65,0x31,
0x3C,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0xD6,0x20,0x08,
0xC2,0x18,0x61,0x10,0x30,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x41,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x30,0x84,0x61,0x10,0xC2,0x18,0x00,0x00,0x9E,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x28,0x4A,0xA2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0xAA,0x5A,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xD6,
0x9A,0xD6,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xF3,0x9C,0x40,0x10,0xC2,0x18,0x40,0x08,0x75,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x82,0x10,0xA2,0x18,0xC2,0x18,
0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,0x61,0x10,
0xC2,0x18,0x20,0x08,0x75,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,
0x00,0x00,0xC2,0x18,0x61,0x10,0x44,0x29,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8A,0x52,0xC2,0x18,0x8A,0x52,0x38,0xCE,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x59,0xCE,0x20,0x08,
0xC2,0x18,0x61,0x10,0x10,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x40,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x0B,0x63,0x81,0x10,0xC2,0x18,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x41,0x10,0x81,0x10,0xC2,0x18,
0xC2,0x18,0x61,0x10,0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0x2C,0x6B,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x71,0x94,0x41,0x10,0xC2,0x18,0x40,0x08,0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x61,0x10,0x81,0x18,0xC2,0x18,0x00,0x00,
0x0F,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0x83,0x61,0x10,
0xC2,0x18,0x20,0x08,0x55,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xD6,0xBD,0x00,0x00,0xC2,0x18,0x81,0x10,0x20,0x08,0x96,0xB5,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x38,0xC6,0x20,0x08,
0xC2,0x18,0x61,0x10,0xEF,0x83,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0x18,0xA2,0x18,0xC2,0x18,0x40,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x92,0x94,0x61,0x10,0x20,0x08,0xA2,0x18,0xC2,0x18,0xA2,0x18,
0x00,0x00,0xCF,0x7B,0x20,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,0x00,0x00,
0x30,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xAE,0x7B,0x61,0x10,0xC2,0x18,0x40,0x08,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xF3,0x9C,0x00,0x00,0xA2,0x18,0xC2,0x18,0x20,0x08,0xAA,0x5A,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x6D,0x73,0x61,0x10,
0xC2,0x18,0x20,0x08,0x34,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xB2,0x94,0x00,0x00,0xC2,0x18,0xC2,0x18,0x00,0x00,0xC6,0x39,0x5D,0xEF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xBD,0x20,0x08,
0xC2,0x18,0x61,0x10,0xCE,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x38,0xC6,0x00,0x08,0xC2,0x18,0xA2,0x18,0x65,0x31,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x17,0xC6,
0xCB,0x5A,0x00,0x08,0x40,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x40,0x08,
0xBA,0xDE,0xFF,0xFF,0x9E,0xF7,0xC2,0x18,0x61,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0x40,0x08,0x40,0x08,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xCE,0x7B,0x61,0x10,0xC2,0x18,0x40,0x08,0xB6,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x17,0xC6,0x24,0x29,0x20,0x08,0xC2,0x18,0xC2,0x18,0x20,0x08,0x89,0x52,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0B,0x63,0x61,0x10,
0xC2,0x18,0x40,0x08,0x34,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x0F,0x84,0x00,0x00,0xC2,0x18,0xC2,0x18,0x81,0x18,0x00,0x00,
0xEB,0x62,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD6,0xBD,0x20,0x08,
0xC2,0x18,0x61,0x10,0xAE,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x20,0x08,0xC2,0x18,0xC2,0x18,0x20,0x08,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xB6,0xBD,0x40,0x08,0xC2,0x18,0xC2,0x18,0x61,0x10,0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0xB2,0x9C,0xAE,0x73,0xE7,0x41,0x20,0x08,0x00,0x08,
0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x08,0xC7,0x39,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x85,0x31,0x41,0x10,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x40,0x08,0x61,0x10,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0x1C,0xE7,0x79,0xCE,0xF7,0xC5,0x95,0xB5,0x96,0xB5,
0xCA,0x5A,0x81,0x10,0xC2,0x18,0x81,0x10,0x2C,0x6B,0x71,0x8C,0x30,0x84,0x51,0x8C,
0xB2,0x9C,0x34,0xA5,0xD7,0xBD,0x9A,0xD6,0x3C,0xE7,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xEF,0x51,0x8C,0xE3,0x20,
0x00,0x00,0xA2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0x2C,0x6B,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAA,0x5A,0x81,0x10,
0xC2,0x18,0x40,0x08,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0x61,0x10,0x00,0x00,0x89,0x52,0x9A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB6,0xB5,0x20,0x08,
0xC2,0x18,0x61,0x10,0x6D,0x73,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x40,0x08,0xC2,0x18,0xC2,0x18,0x00,0x08,0xDF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xD6,0xE7,0x41,
0x00,0x00,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x0B,0x63,0x00,0x00,0x40,0x08,0x61,0x10,0x82,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0x71,0x94,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x42,0x40,0x08,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x20,0x08,0x41,0x10,0x30,0x8C,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x58,0xCE,0x95,0xB5,
0x75,0xAD,0x34,0xA5,0xB2,0x9C,0x0F,0x84,0x4D,0x6B,0xAA,0x5A,0xC7,0x39,0x44,0x29,
0xC2,0x18,0x40,0x08,0x20,0x08,0x00,0x00,0x00,0x08,0x20,0x08,0x20,0x08,0x40,0x08,
0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,0x41,0x10,0x61,0x10,0x41,0x10,
0x40,0x10,0x40,0x08,0x20,0x08,0x00,0x00,0x00,0x00,0x20,0x08,0x40,0x08,0xE3,0x20,
0x85,0x31,0x89,0x52,0x6D,0x73,0x71,0x94,0x75,0xAD,0xBA,0xD6,0x9E,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x79,0xCE,0x34,0xA5,
0x75,0xB5,0x55,0xAD,0xB2,0x94,0x4C,0x6B,0x03,0x21,0x00,0x00,0x41,0x10,0xA2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x00,0x00,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x89,0x52,0x81,0x10,
0xC2,0x18,0x40,0x08,0xF3,0xA4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x73,0x00,0x00,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0xC3,0x18,0x6D,0x73,0xD7,0xBD,0x7D,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x75,0xAD,0x20,0x08,
0xC2,0x18,0x61,0x10,0x4D,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x61,0x10,0xC2,0x18,0xC2,0x18,0x00,0x00,0x9E,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7D,0xF7,0xF3,0xA4,0x45,0x29,0x00,0x00,0x81,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x40,0x08,0x2C,0x6B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xAE,0x7B,0x41,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xA2,0x18,0x00,0x00,0xC6,0x39,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x28,0x4A,0x40,0x08,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x40,0x08,0x20,0x08,
0x8E,0x73,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0xA2,0x18,0x00,0x00,0x20,0x08,
0x20,0x08,0x40,0x08,0x40,0x08,0x61,0x10,0x61,0x10,0x81,0x10,0x82,0x18,0xA2,0x18,
0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0xA2,0x18,
0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,
0xA2,0x18,0x81,0x10,0x61,0x10,0x40,0x10,0x20,0x08,0x00,0x08,0x00,0x00,0x20,0x08,
0x24,0x29,0x49,0x4A,0x6D,0x73,0x92,0x94,0x9E,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDB,0xDE,0x00,0x00,0x40,0x08,
0x20,0x08,0x40,0x08,0x40,0x10,0x61,0x10,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x40,0x08,0xC2,0x18,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCB,0x5A,0x81,0x10,
0xC2,0x18,0x40,0x08,0xD3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCE,0x7B,0x00,0x00,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x20,0x08,0x00,0x00,
0x20,0x08,0x20,0x08,0xC2,0x18,0x58,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x34,0xA5,0x40,0x08,
0xC2,0x18,0x81,0x10,0x0B,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x82,0x18,0xA2,0x18,0xC2,0x18,0x00,0x00,0x7D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x34,0xAD,0xE3,0x20,0x00,0x00,0x40,0x08,0xA2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x61,0x10,0xE3,0x20,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xDF,0xFF,0x00,0x00,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x81,0x10,
0x00,0x00,0x85,0x31,0x59,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x07,0x42,
0x40,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0x61,0x10,0x00,0x00,0x28,0x4A,0x38,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x20,0x08,0x82,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,
0x40,0x08,0x20,0x08,0x00,0x00,0x00,0x00,0x20,0x08,0x61,0x10,0x04,0x21,0x45,0x31,
0x85,0x31,0xA6,0x39,0x65,0x31,0x24,0x29,0x03,0x21,0xA2,0x18,0x20,0x08,0x00,0x08,
0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x08,0x41,0x10,0x81,0x10,0xA2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xA2,0x18,0x81,0x10,0x61,0x10,0x00,0x00,0xCA,0x5A,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1B,0xE7,0x00,0x00,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,
0x00,0x00,0xCF,0x7B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAE,0x7B,0x61,0x10,
0xC2,0x18,0x40,0x08,0x14,0xA5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x10,0x84,0x00,0x00,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x81,0x10,0x00,0x00,0x1B,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x40,0x08,
0xC2,0x18,0x81,0x10,0x8A,0x52,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xA2,0x18,0xA2,0x18,0xC2,0x18,0x00,0x00,0x5D,0xEF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x71,0x8C,0x00,0x00,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0x20,0x08,0x65,0x31,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x59,0xCE,0x40,0x08,0x00,0x00,0x00,0x00,0x40,0x08,0xCB,0x5A,
0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xA6,0x39,0x40,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x81,0x10,0x00,0x00,0xA6,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x2C,0x6B,0x61,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x20,0x08,0x00,0x00,0x86,0x39,0x8D,0x73,
0xF3,0x9C,0x59,0xCE,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x7D,0xEF,0xDB,0xDE,0xB6,0xB5,0x71,0x94,0xEB,0x62,0x04,0x29,0x00,0x00,
0x20,0x08,0x61,0x10,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0x00,0x00,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x24,0x29,0x82,0x18,
0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,0x00,0x00,0xEB,0x62,
0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x13,0xA5,0x40,0x08,
0xC2,0x18,0x20,0x08,0xD7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD2,0x9C,
0x00,0x00,0x82,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x61,0x10,
0x00,0x00,0x24,0x29,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB2,0x94,0x40,0x08,
0xC2,0x18,0x61,0x10,0x0C,0x63,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xC3,0x20,0xA2,0x18,0xC2,0x18,0x00,0x00,0x3C,0xE7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x04,0x29,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0x61,0x10,
0x00,0x00,0x71,0x8C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x07,0x42,0x00,0x08,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xA2,0x18,0x00,0x00,0xA6,0x39,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x21,0xA2,0x18,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0x81,0x10,0x00,0x00,0xE3,0x20,0xCE,0x7B,0x59,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xB6,0xBD,0x2C,0x63,0x81,0x10,0x00,0x08,0x81,0x10,0xC2,0x18,0xC2,0x18,0xC2,0x18,
0xC2,0x18,0xC2,0x18,0x00,0x00,0xF7,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0xE7,0x00,0x00,
0x40,0x08,0x61,0x10,0x61,0x10,0x00,0x00,0x61,0x10,0xAE,0x7B,0xDF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x5D,0xEF,0x00,0x00,
0xC2,0x18,0x00,0x00,0x9E,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xDB,0xDE,0xA6,0x39,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x00,0xC2,0x18,0x0B,0x63,
0x99,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x96,0xB5,0x00,0x08,
0xC2,0x18,0x20,0x08,0xD3,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x45,0x31,0x82,0x18,0xC2,0x18,0x00,0x00,0x9E,0xF7,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x0B,0x63,0x40,0x08,0xC2,0x18,0xC2,0x18,0xA2,0x18,0x40,0x08,0x20,0x08,0x6D,0x6B,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x91,0x94,0x20,0x08,0x20,0x08,0x61,0x10,0x81,0x10,0x61,0x10,
0x00,0x00,0x44,0x29,0xD6,0xBD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0C,0x63,0x00,0x00,0x61,0x10,0x40,0x08,0x00,0x00,
0x69,0x52,0xBA,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x59,0xCE,0xAA,0x52,0x00,0x00,0x40,0x08,0x81,0x10,
0x61,0x10,0x00,0x00,0x54,0xAD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,
0x0F,0x84,0x2C,0x6B,0x30,0x84,0x59,0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE3,0x20,
0x00,0x00,0xA6,0x39,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0x9E,0xF7,0x38,0xCE,0x38,0xCE,0x7D,0xEF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x40,0x08,
0x40,0x08,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xCF,0x7B,0x00,0x08,0x81,0x10,0x61,0x10,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0x24,0x29,0x00,0x00,0x00,0x08,0x24,0x29,0xB2,0x9C,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x14,0xA5,0x2C,0x6B,0xAA,0x5A,0xEF,0x7B,
0xBA,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD3,0x9C,0x0C,0x63,0x71,0x94,0xBE,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x51,0x8C,0x48,0x4A,
0x4C,0x6B,0x5D,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x1C,0xE7,
0x6D,0x73,0xDF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xF7,
0x2C,0x6B,0xFB,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x28,0x4A,0xC2,0x18,0x59,0xCE,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xBE,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
};
//#pragma pack(pop)

/* Exported variables --------------------------------------------------------*/
//LCD
#define POINT_COLOR     0xFFFFU
#define BACK_COLOR      0x0000U

static GPIO_InitTypeDef mGPIO;
static EMB_HandleTypeDef mEMB;

/* Exported function- --------------------------------------------------------*/
void LCD_Init(void);                                                                        // Initial
void LCD_DisplayOn(void);                                                                   // Display ON
void LCD_DisplayOff(void);                                                                  // Display OFF
void LCD_Clear(uint16_t Color);                                                             // Clear
void LCD_ColorBar_1(void);
void LCD_ColorBar_2(void);
void LCD_GrayBar_1(void);
void LCD_SetCursor(uint16_t Xpos, uint16_t Ypos);                                           // Set Cursor
void LCD_DrawPoint(uint16_t x, uint16_t y, uint16_t Color);
void LCD_Fast_DrawPoint(uint16_t x, uint16_t y, uint16_t color);
uint16_t LCD_ReadPoint(uint16_t x, uint16_t y);
void LCD_Draw_Circle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t Color);
uint32_t LCD_Pow(uint8_t m, uint8_t n);
void LCD_DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);
void LCD_DrawRectangle(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color);
void LCD_Fill(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, uint16_t color);
void LCD_Color_Fill(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, const uint8_t *color);
void LCD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint8_t mode, uint16_t Color);
void LCD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint16_t Color);
void LCD_ShowxNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint8_t mode, uint16_t Color);
void LCD_ShowString(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint8_t size, uint8_t *p);

void LCD_Random_Text(void);
void LCD_Random_Line(void);
void LCD_Random_Rectangle(void);
void LCD_Random_Fill(void);
void LCD_Random_Circle(void);
void LCD_Random_Geometry(void);

uint16_t LCD_BGR2RGB(uint16_t BGRData);

void Sample_MID_EMB_I80_LCD_16Bits(void);


/* Private typedef -----------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief       LCD Module parameters
 *******************************************************************************
 */
typedef struct  
{
    __IO uint16_t    id;            /*!< LCD ID */
    __IO uint16_t    width;         /*!< LCD width pixels */
    __IO uint16_t    height;        /*!< LCD height pixels */
    __IO uint16_t    setxcmd;       /*!< X-axes Register */
    __IO uint16_t    setycmd;       /*!< Y-axes Register */
    __IO uint16_t    wramcmd;       /*!< GRAM Register */
    __IO uint8_t     dir;           /*!< screen：0，Vertical screen */
                                    /*           1，Horizontal screen */
    __IO uint8_t     Reserve;       /*                                */
}_lcd_dev;

/* Private define ------------------------------------------------------------*/
#define EMB_CR1_MAD_SWAP_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MAD_SWAP_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MAD_SWAP_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MAD_SWAP_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_MAD_SWAP_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */

//----------------- LCD Pinout define -----------------------------------------
#define CLKOUT_ICKO_Pin         GPIO_Pin_0
#define CLKOUT_ICKO_Mode        GPIO_MODE_PUSHPULL_O
#define CLKOUT_ICKO_AFS         1
#define CLKOUT_ICKO_Port        IOMC

#define LCD_RSTN_Pin            GPIO_Pin_4
#define LCD_RSTN_Mode           GPIO_MODE_PUSHPULL_O
#define LCD_RSTN_AFS            0
#define LCD_RSTN_Port           IOMB

#define LCD1st_D0_Pin           GPIO_Pin_12
#define LCD1st_D1_Pin           GPIO_Pin_11
#define LCD1st_D2_Pin           GPIO_Pin_10
#define LCD1st_D3_Pin           GPIO_Pin_9
#define LCD1st_D4_Pin           GPIO_Pin_8
#define LCD1st_D5_Pin           GPIO_Pin_3
#define LCD1st_D6_Pin           GPIO_Pin_2
#define LCD1st_D7_Pin           GPIO_Pin_1
#define LCD1st_D0_7_Mode        GPIO_MODE_DIGITAL_I
#define LCD1st_D0_7_AFS         8
#define LCD1st_D0_7_Port        IOMC

#define LCD1st_D8_Pin           GPIO_Pin_15
#define LCD1st_D9_Pin           GPIO_Pin_14
#define LCD1st_D10_Pin          GPIO_Pin_13
#define LCD1st_D11_Pin          GPIO_Pin_12
#define LCD1st_D12_Pin          GPIO_Pin_11
#define LCD1st_D13_Pin          GPIO_Pin_10
#define LCD1st_D14_Pin          GPIO_Pin_9
#define LCD1st_D15_Pin          GPIO_Pin_8
#define LCD1st_D8_15_Mode       GPIO_MODE_DIGITAL_I
#define LCD1st_D8_15_AFS        8
#define LCD1st_D8_15_Port       IOMB

#define LCD1st_RD_Pin           GPIO_Pin_5
#define LCD1st_WR_Pin           GPIO_Pin_6
#define LCD1st_CS_Pin           GPIO_Pin_7
#define LCD1st_CTL_Mode         GPIO_MODE_PUSHPULL_O
#define LCD1st_CTL_AFS          8
#define LCD1st_CTL_Port         IOMB

#define LCD1st_RS_Pin           GPIO_Pin_7
#define LCD1st_RS_Mode          GPIO_MODE_PUSHPULL_O
#define LCD1st_RS_AFS           0
#define LCD1st_RS_Port          IOMC

#define LCD1st_BL_Pin           GPIO_Pin_8
#define LCD1st_BL_Mode          GPIO_MODE_PUSHPULL_O
#define LCD1st_BL_AFS           0
#define LCD1st_BL_Port          IOME

#define LCD_LED PCout(10)

#define __LCD_BACKLIGHT_on()    GPIOE->SC.W = PX_SC_SET8_mask_w
#define __LCD_BACKLIGHT_off()   GPIOE->SC.W = PX_SC_CLR8_mask_w

#define __LCD_RESET_high()      GPIOB->SC.W = PX_SC_SET4_mask_w
#define __LCD_RESET_low()       GPIOB->SC.W = PX_SC_CLR4_mask_w

#define __LCD_CS_SET()    __NOP()                                   // Chip Select
#define __LCD_CS_CLR()    __NOP()

#define __LCD_RS_SET()    GPIOC->SC.W = PX_SC_SET7_mask_w           // Data / Register
#define __LCD_RS_CLR()    GPIOC->SC.W = PX_SC_CLR7_mask_w

#define __LCD_WR_SET()    __NOP()                                   // Write
#define __LCD_WR_CLR()    __NOP()

#define __LCD_RD_SET()    __NOP()                                   // Read
#define __LCD_RD_CLR()    __NOP()

//PB0~15 Data Bus
#define __DATAOUT(x) *(uint16_t *)0x60000000 = (x)                  // Data Output
#define __DATAIN()   *(uint16_t *)0x60000000                        // Data Input

// LCD Display scan direction
#define L2R_U2D  0 // From left to right, top to bottom
#define L2R_D2U  1 // From left to right, from bottom to top
#define R2L_U2D  2 // From Right to left, top to bottom
#define R2L_D2U  3 // From Right to left, bottom to top

#define U2D_L2R  4 // From Top to bottom, left to right
#define U2D_R2L  5 // From Top to bottom, Right to left
#define D2U_L2R  6 // From bottom to top, left to right
#define D2U_R2L  7 // From bottom to top, Right to left

#define DFT_SCAN_DIR  L2R_U2D  // default scan direction

// Color define
#define WHITE               0xFFFF
#define BLACK               0x0000

#define BLUE                0x001F  
#define BRED                0XF81F
#define GRED                0XFFE0
#define GBLUE               0X07FF
#define RED                 0xF800
#define MAGENTA             0xF81F
#define YELLOW              0xFFE0
#define GREEN               0x07E0
#define CYAN                0x7FFF
#define BROWN               0XBC40
#define BRRED               0XFC07
#define GRAY                0X8430
//GUI Color

#define DARKBLUE            0X01CF
#define LIGHTBLUE           0X7D7C
#define GRAYBLUE            0X5458
//The above three colors are the colors of the panel
 
#define LIGHTGREEN          0X841F
#define LGRAY               0XC618 // Form background color

#define LGRAYBLUE           0XA651 //Middle layer color
#define LBBLUE              0X2B12 //Select the inverse color of the item

//9320/9325 LCD Register
#define R0             0x00
#define R1             0x01
#define R2             0x02
#define R3             0x03
#define R4             0x04
#define R5             0x05
#define R6             0x06
#define R7             0x07
#define R8             0x08
#define R9             0x09
#define R10            0x0A
#define R12            0x0C
#define R13            0x0D
#define R14            0x0E
#define R15            0x0F
#define R16            0x10
#define R17            0x11
#define R18            0x12
#define R19            0x13
#define R20            0x14
#define R21            0x15
#define R22            0x16
#define R23            0x17
#define R24            0x18
#define R25            0x19
#define R26            0x1A
#define R27            0x1B
#define R28            0x1C
#define R29            0x1D
#define R30            0x1E
#define R31            0x1F
#define R32            0x20
#define R33            0x21
#define R34            0x22
#define R36            0x24
#define R37            0x25
#define R40            0x28
#define R41            0x29
#define R43            0x2B
#define R45            0x2D
#define R48            0x30
#define R49            0x31
#define R50            0x32
#define R51            0x33
#define R52            0x34
#define R53            0x35
#define R54            0x36
#define R55            0x37
#define R56            0x38
#define R57            0x39
#define R59            0x3B
#define R60            0x3C
#define R61            0x3D
#define R62            0x3E
#define R63            0x3F
#define R64            0x40
#define R65            0x41
#define R66            0x42
#define R67            0x43
#define R68            0x44
#define R69            0x45
#define R70            0x46
#define R71            0x47
#define R72            0x48
#define R73            0x49
#define R74            0x4A
#define R75            0x4B
#define R76            0x4C
#define R77            0x4D
#define R78            0x4E
#define R79            0x4F
#define R80            0x50
#define R81            0x51
#define R82            0x52
#define R83            0x53
#define R96            0x60
#define R97            0x61
#define R106           0x6A
#define R118           0x76
#define R128           0x80
#define R129           0x81
#define R130           0x82
#define R131           0x83
#define R132           0x84
#define R133           0x85
#define R134           0x86
#define R135           0x87
#define R136           0x88
#define R137           0x89
#define R139           0x8B
#define R140           0x8C
#define R141           0x8D
#define R143           0x8F
#define R144           0x90
#define R145           0x91
#define R146           0x92
#define R147           0x93
#define R148           0x94
#define R149           0x95
#define R150           0x96
#define R151           0x97
#define R152           0x98
#define R153           0x99
#define R154           0x9A
#define R157           0x9D
#define R192           0xC0
#define R193           0xC1
#define R229           0xE5

/* Private macro -------------------------------------------------------------*/
// Write Data Macro 
#define LCD_WR_DATA(data)   __LCD_CS_CLR(); \
                            __LCD_RS_SET(); \
                            __DATAOUT(data); \
                            __LCD_WR_CLR(); \
                            __LCD_WR_SET(); \
                            __LCD_CS_SET()

/* Private function prototypes -----------------------------------------------*/
void delay_us(uint32_t uDelay);
uint16_t DataReverse(uint16_t InData);
void LCD_WR_REG(uint16_t Register);
void LCD_WR_DATAX(uint16_t Data);
uint16_t LCD_RD_DATA(void);
void LCD_WriteReg(uint16_t LCD_Reg, uint16_t LCD_RegValue);
uint16_t LCD_ReadReg(uint16_t LCD_Reg);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteRAM(uint16_t RGB_Code);
void LCD_Scan_Dir(uint8_t dir);                                 // Set screen scan direction
void LCD_Display_Dir(uint8_t dir);                              // Set Display module direction
void LCD_Set_Window(uint16_t sx,uint16_t sy, uint16_t width, uint16_t height);  // Setting window

void LCD_ChipInit_1505(void);
void LCD_ChipInit_5310(void);
void LCD_ChipInit_5408(void);
void LCD_ChipInit_5510(void);
void LCD_ChipInit_6804(void);
void LCD_ChipInit_9320(void);
void LCD_ChipInit_9325(void);
void LCD_ChipInit_9328(void);
void LCD_ChipInit_9331(void);
void LCD_ChipInit_9341(void);
void LCD_ChipInit_B505(void);
void LCD_ChipInit_C505(void);
void LCD_ChipInit_8989(void);
void LCD_ChipInit_4531(void);
void LCD_ChipInit_4535(void);

// Manage important LCD parameters
// default is portrait
static _lcd_dev lcddev;

/* Private variables ---------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       EMB to I80 LCD 16-Bits I/F
 * @details
 *    \n        1.Initial Systick
 *    \n        2.Initial GPIO
 *    \n        3.Initial EMB I80 16Bits
 *    \n        4.Initial LCD Module
 *    \n        5.Show Logo and Text.
 *    \n        6.Show Logo
 *    \n        7.Show Bray Bar
 *    \n        8.Show Color Bar
 *    \n        9.Show Text and Fill
 *    \n        10.Show Draw(Line / Rectangle / Circle / Text)
 * @return      None
 *******************************************************************************
 */
void Sample_MID_EMB_I80_LCD_16Bits(void)
{
    uint32_t lCount = 5;

// 1.Initial Systick
    MID_InitTick(MID_CSC_GetCK_AHBFreq());

// 2.Initial GPIO
  // ICKO
    mGPIO.Pin           = CLKOUT_ICKO_Pin;
    mGPIO.Alternate     = CLKOUT_ICKO_AFS;
    mGPIO.Mode          = GPIO_MODE_PUSHPULL_O;
    mGPIO.Pull          = GPIO_NOPULLUP;
    mGPIO.Speed         = GPIO_SPEED_HIGH;
    mGPIO.Inverse       = GPIO_INVERSE_DISABLE;
    mGPIO.OUTDrive      = GPIO_OUTDRIVE_LEVEL0;
    mGPIO.FilterDivider = GPIO_FILTERDIVIDER_BYPASS;
    MID_GPIO_Init(CLKOUT_ICKO_Port, &mGPIO);

  // LCD 
    // LCD BL
    mGPIO.Pin           = LCD1st_BL_Pin;
    mGPIO.Alternate     = LCD1st_BL_AFS;
    mGPIO.Mode          = LCD1st_BL_Mode;
    MID_GPIO_Init(LCD1st_BL_Port, &mGPIO);

    // LCD RSTN
    mGPIO.Pin           = LCD_RSTN_Pin;
    mGPIO.Alternate     = LCD_RSTN_AFS;
    mGPIO.Mode          = LCD_RSTN_Mode;
    MID_GPIO_Init(LCD_RSTN_Port, &mGPIO);

  // LCD 1st use EMB
    // DB0[0:7] DIN
    mGPIO.Pin           = (LCD1st_D0_Pin | LCD1st_D1_Pin | LCD1st_D2_Pin | LCD1st_D3_Pin | LCD1st_D4_Pin | LCD1st_D5_Pin | LCD1st_D6_Pin | LCD1st_D7_Pin);
    mGPIO.Alternate     = LCD1st_D0_7_AFS;
    mGPIO.Mode          = LCD1st_D0_7_Mode;
    MID_GPIO_Init(LCD1st_D0_7_Port, &mGPIO);

    // DB[8:15] DIN
    mGPIO.Pin           = (LCD1st_D8_Pin | LCD1st_D9_Pin | LCD1st_D10_Pin | LCD1st_D11_Pin | LCD1st_D12_Pin | LCD1st_D13_Pin | LCD1st_D14_Pin | LCD1st_D15_Pin);
    mGPIO.Alternate     = LCD1st_D8_15_AFS;
    mGPIO.Mode          = LCD1st_D8_15_Mode;
    MID_GPIO_Init(LCD1st_D8_15_Port, &mGPIO);

    // MCS, MRD, MWR
    mGPIO.Pin           = (LCD1st_RD_Pin | LCD1st_WR_Pin | LCD1st_CS_Pin);
    mGPIO.Alternate     = LCD1st_CTL_AFS;
    mGPIO.Mode          = LCD1st_CTL_Mode;
    MID_GPIO_Init(LCD1st_CTL_Port, &mGPIO);

    // RS / DC
    mGPIO.Pin           = LCD1st_RS_Pin;
    mGPIO.Alternate     = LCD1st_RS_AFS;
    mGPIO.Mode          = LCD1st_RS_Mode;
    MID_GPIO_Init(LCD1st_RS_Port, &mGPIO);

  // 3.Initial EMB I80 16Bits
    mEMB.Instance = EMB;
    mEMB.Init.DeviceAccess = EMB_DEVICE_ACCESS_ASYNCHRONOUS;
    mEMB.Init.WriteSignal = EMB_WRITE_SIGNAL_TOGGLE;
    mEMB.Init.ReadSignal = EMB_READ_SIGNAL_TOGGLE;
    mEMB.Init.DataAddressMux = EMB_DATA_ADDRESS_MUX_DISABLE;
    mEMB.Init.DataAddressMuxMode = EMB_DATA_ADDRESS_MULTIPLEX_1ALE;
    mEMB.Init.AddressRange = EMB_ADDRESS_RANGE_16BIT;
    mEMB.Init.WriteAccess = EMC_WRITE_ACCESS_ENABLE;
  #if defined(MG32_3RD)
    mEMB.Init.DeviceDataWidth = EMB_DEVICE_DATA_BUS_WIDTH_16;
    mEMB.Init.AddressMAM1 = EMB_ADDRESS_MAM1_SIGNAL_DISABLE;
    mEMB.Init.WriteByteAccess = EMB_WRITE_BYTE_ACCESS_DISABLE;
    mEMB.Extended.MADBusByteSwap = EMB_MAD_BYTE_SWAP_DISABLE;
    mEMB.Extended.MADBusReverse = EMB_MAD_REVERSE_DISABLE;
  #endif
    mEMB.Extended.MABusReverse = EMB_MA_REVERSE_DISABLE;
    mEMB.Extended.MCLK_Inverse = EMB_MCLK_INVERSE_DISABLE;
    mEMB.Extended.MALE2_Inverse = EMB_MALE2_INVERSE_DISABLE;
    mEMB.Extended.MALE_Inverse = EMB_MALE_INVERSE_DISABLE;
    mEMB.Extended.MCE_Inverse = EMB_MCE_INVERSE_DISABLE;
    mEMB.CLKPrescaler = 1;
    mEMB.AddressSetupTime = 0;
    mEMB.AddressPulseTime = 1;
    mEMB.AddressHoldTime = 0;
    mEMB.DataSetupTime = 1;
    mEMB.DataAccessTime = 3;
    mEMB.DataHoldTime = 1;
    mEMB.IdleTime = 0;
    EMB_Init(&mEMB);

  // 4.Initial LCD Module
    LCD_Init();

    __LCD_BACKLIGHT_off();

  // 5.Show Logo and Text.
    LCD_Color_Fill(0, 0, 239, 98, gLogoX);

    LCD_ShowString(0, 110, lcddev.width, 24, GBLUE, 24, (uint8_t *)"megawin Company");
    LCD_ShowString(0, 134, lcddev.width, 24, BRED, 24, (uint8_t *)"arm Cortex-M0 Series");
    LCD_ShowString(0, 158, lcddev.width, 24, YELLOW, 24, (uint8_t *)"Product MG32F02A");
    LCD_ShowString(0, 182, lcddev.width, 24, BLUE, 24, (uint8_t *)"2018/02/17");

    LCD_ShowString(0, 218, lcddev.width, 16, WHITE, 16, (uint8_t *)"megawin Company");
    LCD_ShowString(0, 234, lcddev.width, 16, WHITE, 16, (uint8_t *)"arm Cortex M0 Series");
    LCD_ShowString(0, 250, lcddev.width, 16, WHITE, 16, (uint8_t *)"Product MG32F02A");
    LCD_ShowString(0, 266, lcddev.width, 16, WHITE, 16, (uint8_t *)"2018/02/17");

    LCD_ShowString(0, 290, lcddev.width, 12, WHITE, 12, (uint8_t *)"megawin MG32F02A");
    LCD_ShowString(0, 302, lcddev.width, 12, WHITE, 12, (uint8_t *)"arm Cortex M0 Series");
    //LCD_ShowString(0, 314, lcddev.width, 12, WHITE, 12, (uint8_t *)"Product MG32F02A");
    //LCD_ShowString(0, 298, lcddev.width, 12, WHITE, 12, (uint8_t *)"2018/02/17");
    __LCD_BACKLIGHT_on();
    MID_Delay(3000);

    do{
        LCD_Clear(BLACK);

  // 6.Show Logo
        LCD_Color_Fill(0, 110, 239, 208, gLogoX);
        MID_Delay(3000);

  // 7. Show Bray Bar
        LCD_GrayBar_1();
        MID_Delay(3000);

  // 8. Show Color Bar
        LCD_ColorBar_1();
        MID_Delay(3000);

        LCD_ColorBar_2();
        MID_Delay(3000);

  // 9. Show Text and Fill
        LCD_Fill(0, 0, 119, 79, BLACK);
        LCD_ShowString(8, 16, 119, 16, WHITE, 16, (uint8_t *)"Date");
        LCD_ShowString(8, 32, 119, 16, WHITE, 16, (uint8_t *)"2020/08/07");

        LCD_Fill(120, 0, 239, 79, WHITE);
        LCD_ShowString(128, 16, 119, 16, BLACK, 16, (uint8_t *)"Time");
        LCD_ShowString(128, 32, 119, 16, BLACK, 16, (uint8_t *)"12:00:00 PM");

        LCD_Fill(0, 80, 119, 159, RED);
        LCD_ShowString(8, 96, 119, 16, (GREEN | BLUE), 16, (uint8_t *)"Tempture");
        LCD_ShowString(8, 112, 119, 16, (GREEN | BLUE), 16, (uint8_t *)"25C");

        LCD_Fill(120, 80, 239, 159, (RED | BLUE));
        LCD_ShowString(128, 96, 119, 16, GREEN, 16, (uint8_t *)"Humidity");
        LCD_ShowString(128, 112, 119, 16, GREEN, 16, (uint8_t *)"80%");

        LCD_Fill(0, 160, 119, 239, BLUE);
        LCD_ShowString(8, 176, 119, 16, (GREEN | RED), 16, (uint8_t *)"PM2.5");
        LCD_ShowString(8, 192, 119, 16, (GREEN | RED), 16, (uint8_t *)"15");

        LCD_Fill(120, 160, 239, 239, (GREEN | BLUE));
        LCD_Fill(0, 240, 119, 319, GREEN);
        LCD_Fill(120, 240, 239, 319, (GREEN | RED));
        MID_Delay(3000);

  // 10. Show Draw
        LCD_Random_Line();
        MID_Delay(2000); // Delay 2Sec

        LCD_Random_Rectangle();
        MID_Delay(2000); // Delay 2Sec

        LCD_Random_Circle();
        MID_Delay(2000); // Delay 2Sec

        LCD_Random_Geometry();
        MID_Delay(2000); // Delay 2Sec

        LCD_Random_Text();
        MID_Delay(2000); // Delay 2Sec
    }while(--lCount != 0);
}

/**
 *******************************************************************************
 * @brief       This function provides accurate delay (in microseconds).
 * @param       uDelay : specifies the delay time length, in microseconds.
 *      
 * @return      None
 *******************************************************************************
 */
void delay_us(uint32_t uDelay)
{
    (void)uDelay;
}

/**
 *******************************************************************************
 * @brief       Data Reverse 16-Bits
 * @param       InData : Input Data.
 *      
 * @return      uint16_t Reverse Data 
 *******************************************************************************
 */
uint16_t DataReverse(uint16_t InData)
{
    uint16_t t, t2;

    t2 = InData;
    t = 0;
    t |= (t2 & 0x0001); // Bit0

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit1

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit2

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit3

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit4

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit5

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit6

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit7

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit8

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit9

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit10

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit11

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit12

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit13

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit14

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit15

    return t;
}

/**
 *******************************************************************************
 * @brief       Select LCD Module Control Register
 * @param       Register : LCD Module Control Register
 * @return      None 
 *******************************************************************************
 */
void LCD_WR_REG(uint16_t Register)
{ 
    __LCD_CS_CLR();
    __LCD_RS_CLR(); // Select write register
    __DATAOUT(Register);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    __LCD_CS_SET();
}

/**
 *******************************************************************************
 * @brief       Write LCD Module Data
 * @param       Data : Write Data
 * @return      None 
 *******************************************************************************
 */
void LCD_WR_DATAX(uint16_t Data)
{
    __LCD_CS_CLR();
    __LCD_RS_SET();
    __DATAOUT(Data);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    __LCD_CS_SET();
}

/**
 *******************************************************************************
 * @brief       Read LCD Module Data
 * @return      uint16_t : Data Value
 *******************************************************************************
 */
uint16_t LCD_RD_DATA(void)
{
    uint16_t t;
    __LCD_CS_CLR();
    __LCD_RS_SET();
                                        // Non-dummy Read with Register
    __LCD_RD_CLR();
    if(lcddev.id == 0X8989)delay_us(2); //FOR 8989, Delay 2us
    t = __DATAIN();  
    __LCD_RD_SET();
    __LCD_CS_SET();

  #if defined(MG32_1ST)
    if((EMB->CR1.B[1] & EMB_CR1_MAD_SWAP_mask_b1) == 0)
        return t;
    else
        return DataReverse(t);
  #else
        return t;
  #endif
}

/**
 *******************************************************************************
 * @brief       Write Data to LCD Module Register
 * @param       LCD_Reg : LCD Module Control Register
 * @param       LCD_RegValue : Write Value
 * @return      None 
 *******************************************************************************
 */
void LCD_WriteReg(uint16_t LCD_Reg, uint16_t LCD_RegValue)
{
    //LCD_WR_REG(LCD_Reg);
    __LCD_CS_CLR(); 
    __LCD_RS_CLR(); // Select write register
    __DATAOUT(LCD_Reg); 
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    //__LCD_CS_SET(); 

    //LCD_WR_DATA(LCD_RegValue);
    //__LCD_CS_CLR();
    __LCD_RS_SET();
    __DATAOUT(LCD_RegValue);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    __LCD_CS_SET();
}

/**
 *******************************************************************************
 * @brief       Read Data from LCD Module Register
 * @param       LCD_Reg : LCD Module Control Register
 * @return      uint16_t
 *******************************************************************************
 */
uint16_t LCD_ReadReg(uint16_t LCD_Reg)
{
    uint16_t lTemp;
    //LCD_WR_REG(LCD_Reg);
    __LCD_CS_CLR(); 
    __LCD_RS_CLR(); // Select write register
    __DATAOUT(LCD_Reg); 
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    //__LCD_CS_SET(); 

    //__LCD_CS_CLR();
    __LCD_RS_SET(); // Select Read Data
                    // Non-dummy Read with Register
    __LCD_RD_CLR();
    if(lcddev.id == 0X8989) delay_us(2);    // FOR 8989, Delay 2us
    lTemp = __DATAIN();  
    __LCD_RD_SET();
    __LCD_CS_SET(); 
    return lTemp;
}


/**
 *******************************************************************************
 * @brief       Select LCD Module Control Register to GRAM
 * @return      None
 *******************************************************************************
 */
// Select to GRAM
void LCD_WriteRAM_Prepare(void)
{
    LCD_WR_REG(lcddev.wramcmd);
}

/**
 *******************************************************************************
 * @brief       Write Data to LCD Module GRAM
 * @param       RGB_Code : Color Data Value 
 * @return      None
 *******************************************************************************
 */
void LCD_WriteRAM(uint16_t RGB_Code)
{
    LCD_WR_DATA(RGB_Code);  //  Write 16Bits GRAM
}

/**
 *******************************************************************************
 * @brief       Color format BGR comver to RGB
 *              GRAM Data fromat transfor, for ILI93xx Series Read GRAM Data.
 * @param       BGRData : BGR format Data Value
 * @return      uint16_t RGB
 *******************************************************************************
 */
uint16_t LCD_BGR2RGB(uint16_t BGRData)
{
    uint16_t r, g, b, rgb;
    b = (BGRData >> 0)&0x1fu;
    g = (BGRData >> 5)&0x3fu;
    r = (BGRData >> 11)&0x1fu;
    rgb = ((uint16_t)(b << 11u)) | ((uint16_t)(g << 5u)) | ((uint16_t)(r << 0u));
    return(rgb);
}

/**
 *******************************************************************************
 * @brief       Read Point Color Value
 * @param       x : X-axes
 * @param       y : Y-axes
 * @return      Color : Point Color Value
 *******************************************************************************
 */
uint16_t LCD_ReadPoint(uint16_t x, uint16_t y)
{
    uint16_t r = 0, g = 0, b = 0;
    if(x >= lcddev.width||y >= lcddev.height)return 0; // Range Check
    LCD_SetCursor(x, y);
    if(lcddev.id == 0X9341||lcddev.id == 0X6804||lcddev.id == 0X5310) LCD_WR_REG(0X2E);    //9341/6804/5310 Select Write GRAM Space
    else if(lcddev.id == 0X5510) LCD_WR_REG(0X2E00);//5510 Select Write GRAM Space
    else LCD_WR_REG(R34);                           //Other Chip Select Write GRAM Space

    __LCD_CS_CLR();
    __LCD_RS_SET();
                    // Read Data (First read GRAM, must dummy Read)
    __LCD_RD_CLR();
    delay_us(1);    // delay 1us
    __LCD_RD_SET();
    //dummy READ
    __LCD_RD_CLR();
    delay_us(1);    // delay 1us
    r = __DATAIN();
    __LCD_RD_SET();
    if(lcddev.id == 0X9341 || lcddev.id == 0X5310 || lcddev.id == 0X5510)   //9341/NT35310/NT35510 Read it out twice.
    {
        __LCD_RD_CLR();
        b = __DATAIN(); // Read blue color value 
        __LCD_RD_SET();
        g = r&0XFF;     // ILI9341
        g <<= 8;
    }else if(lcddev.id == 0X6804)
    {
        __LCD_RD_CLR();
        __LCD_RD_SET();
        r = __DATAIN();//6804
    }
    __LCD_CS_SET();
    if(lcddev.id == 0X9325 || lcddev.id == 0X4535 || lcddev.id == 0X4531 || lcddev.id == 0X8989 || lcddev.id == 0XB505) return r;  //這幾種IC直接返回顏色值
    else if(lcddev.id == 0X9341 || lcddev.id == 0X5310 || lcddev.id == 0X5510) return (((uint16_t)((r >> 11) << 11))|((uint16_t)((g >> 10) << 5))|((uint16_t)(b >> 11)));//ILI9341/NT35310/NT35510需要公式轉換一下
    else return LCD_BGR2RGB(r); // Other chip
}

/**
 *******************************************************************************
 * @brief       LCD Display ON
 * @return      None
 *******************************************************************************
 */
void LCD_DisplayOn(void)
{
    if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)LCD_WR_REG(0X29);
    else if(lcddev.id==0X5510)LCD_WR_REG(0X2900);
    else LCD_WriteReg(R7,0x0173);
}

/**
 *******************************************************************************
 * @brief       LCD Display OFF
 * @return      None
 *******************************************************************************
 */
void LCD_DisplayOff(void)
{
    if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)LCD_WR_REG(0X28);
    else if(lcddev.id==0X5510)LCD_WR_REG(0X2800);
    else LCD_WriteReg(R7, 0x0);
}

/**
 *******************************************************************************
 * @brief       Set : Cursor
 * @param       Xpos : X-axes
 * @param       Ypos : Y-axes
 * @return      None
 *******************************************************************************
 */
void LCD_SetCursor(uint16_t Xpos, uint16_t Ypos)
{
    if(lcddev.id==0X9341||lcddev.id==0X5310)
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_DATA(Ypos&0XFF);
    }else if(lcddev.id==0X6804)
    {
        if(lcddev.dir==1)Xpos=lcddev.width-1-Xpos; // on Horizontal screen
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_DATA(Ypos&0XFF);
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_REG(lcddev.setxcmd+1); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_REG(lcddev.setycmd+1); 
        LCD_WR_DATA(Ypos&0XFF);
    }else
    {
        if(lcddev.dir==1)Xpos=lcddev.width-1-Xpos; // Change X-axes and Y-axes, for Horizontal or Vertical screen
        LCD_WriteReg(lcddev.setxcmd, Xpos);
        LCD_WriteReg(lcddev.setycmd, Ypos);
    }
}


/**
 *******************************************************************************
 * @brief       Set LCD automatic scan direction
 * @param       Dir : 0~7
 *      @arg        L2R_U2D : From left to right, top to bottom.
 *      @arg        L2R_D2U : From left to right, bottom to top.
 *      @arg        R2L_U2D : From right to left, top to bottom.
 *      @arg        R2L_D2U : From right to left, bottom to top.
 *      @arg        U2D_L2R : From top to bottom, left to right.
 *      @arg        U2D_R2L : From top to bottom, right to left.
 *      @arg        D2U_L2R : From bottom to top, left to right.
 *      @arg        D2U_R2L : From bottom to top, right to left.
 * @return      None
 *******************************************************************************
 */
void LCD_Scan_Dir(uint8_t Dir)
{
    uint16_t regval=0;
    uint16_t dirreg=0;
    uint16_t temp;  
    if(lcddev.dir==1&&lcddev.id!=0x6804)// 6804 Horizontal screen Not change scan direction
    {
        switch(Dir) // change direction
        {
            case 0:Dir=6;break;
            case 1:Dir=7;break;
            case 2:Dir=4;break;
            case 3:Dir=5;break;
            case 4:Dir=1;break;
            case 5:Dir=0;break;
            case 6:Dir=3;break;
            case 7:Dir=2;break;	     
        }
    }
    if(lcddev.id==0x9341||lcddev.id==0X6804||lcddev.id==0X5310||lcddev.id==0X5510)//9341/6804/5310/5510
    {
        switch(Dir)
        {
            case L2R_U2D: // From left to right, top to bottom.
                regval|=(0<<7)|(0<<6)|(0<<5); 
                break;
            case L2R_D2U: // From left to right, bottom to top.
                regval|=(1<<7)|(0<<6)|(0<<5); 
                break;
            case R2L_U2D: // From right to left, top to bottom.
                regval|=(0<<7)|(1<<6)|(0<<5); 
                break;
            case R2L_D2U: // From right to left, bottom to top.
                regval|=(1<<7)|(1<<6)|(0<<5); 
                break;
            case U2D_L2R: // From top to bottom, left to right.
                regval|=(0<<7)|(0<<6)|(1<<5); 
                break;
            case U2D_R2L: // From top to bottom, right to left.
                regval|=(0<<7)|(1<<6)|(1<<5); 
                break;
            case D2U_L2R: // From bottom to top, left to right.
                regval|=(1<<7)|(0<<6)|(1<<5); 
                break;
            case D2U_R2L: // From bottom to top, right to left.
                regval|=(1<<7)|(1<<6)|(1<<5); 
                break;
        }
        if(lcddev.id==0X5510)dirreg=0X3600;
        else dirreg=0X36;
        if((lcddev.id!=0X5310)&&(lcddev.id!=0X5510))regval|=0X08; // 5310/5510 Not chang BGR
        if(lcddev.id==0X6804)regval|=0x02; //6804 BIT6 and 9341 reversed
        LCD_WriteReg(dirreg,regval);
        if(regval&0X20)
        {
            if(lcddev.width<lcddev.height) // Change X,Y
            {
                temp=lcddev.width;
                lcddev.width=lcddev.height;
                lcddev.height=temp;
            }
        }else  
        {
            if(lcddev.width>lcddev.height) // Change X,Y
            {
                temp=lcddev.width;
                lcddev.width=lcddev.height;
                lcddev.height=temp;
            }
        }  
        if(lcddev.id==0X5510)
        {
            LCD_WR_REG(lcddev.setxcmd);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setxcmd+1);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setxcmd+2);LCD_WR_DATA((lcddev.width-1)>>8); 
            LCD_WR_REG(lcddev.setxcmd+3);LCD_WR_DATA((lcddev.width-1)&0XFF); 
            LCD_WR_REG(lcddev.setycmd);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setycmd+1);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setycmd+2);LCD_WR_DATA((lcddev.height-1)>>8); 
            LCD_WR_REG(lcddev.setycmd+3);LCD_WR_DATA((lcddev.height-1)&0XFF);
        }else
        {
            LCD_WR_REG(lcddev.setxcmd); 
            LCD_WR_DATA(0);LCD_WR_DATA(0);
            LCD_WR_DATA((lcddev.width-1)>>8);LCD_WR_DATA((lcddev.width-1)&0XFF);
            LCD_WR_REG(lcddev.setycmd); 
            LCD_WR_DATA(0);LCD_WR_DATA(0);
            LCD_WR_DATA((lcddev.height-1)>>8);LCD_WR_DATA((lcddev.height-1)&0XFF);  
        }
    }else 
    {
        switch(Dir)
        {
            case L2R_U2D:
                regval|=(1<<5)|(1<<4)|(0<<3); 
                break;
            case L2R_D2U:
                regval|=(0<<5)|(1<<4)|(0<<3); 
                break;
            case R2L_U2D:
                regval|=(1<<5)|(0<<4)|(0<<3);
                break;
            case R2L_D2U:
                regval|=(0<<5)|(0<<4)|(0<<3); 
                break;
            case U2D_L2R:
                regval|=(1<<5)|(1<<4)|(1<<3); 
                break;
            case U2D_R2L:
                regval|=(1<<5)|(0<<4)|(1<<3); 
                break;
            case D2U_L2R:
                regval|=(0<<5)|(1<<4)|(1<<3); 
                break;
            case D2U_R2L:
                regval|=(0<<5)|(0<<4)|(1<<3); 
                break;
        }
        if(lcddev.id == 0x8989) //8989 IC
        {
            dirreg = 0X11;
            regval |= 0X6040; //65K
        }else // Other Chip
        {
            dirreg = 0X03;
            regval |= 1 << 12;  
        }
        LCD_WriteReg(dirreg,regval);
    }
}


/**
 *******************************************************************************
 * @brief       Draw Point on Display 
 * @param       x X-axes
 * @param       y Y-axes
 * @param       Color : Color value
 * @return      None
 *******************************************************************************
 */
void LCD_DrawPoint(uint16_t x, uint16_t y, uint16_t Color)
{
    LCD_SetCursor(x,y);
    LCD_WriteRAM_Prepare();     // Write GRAM
    LCD_WR_DATA(Color); 
}


/**
 *******************************************************************************
 * @brief       Fast Draw Point on Display
 * @param       x X-axes
 * @param       y Y-axes
 * @param       color : Color value
 * @return      None
 *******************************************************************************
 */
void LCD_Fast_DrawPoint(uint16_t x,uint16_t y,uint16_t color)
{
    if(lcddev.id==0X9341||lcddev.id==0X5310)
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(x>>8); 
        LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(y>>8); 
        LCD_WR_DATA(y&0XFF);
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd);LCD_WR_DATA(x>>8);
        LCD_WR_REG(lcddev.setxcmd+1);LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd);LCD_WR_DATA(y>>8);
        LCD_WR_REG(lcddev.setycmd+1);LCD_WR_DATA(y&0XFF); 
    }else if(lcddev.id==0X6804)
    {
        if(lcddev.dir==1)x=lcddev.width-1-x; // Horizontal screen
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(x>>8); 
        LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(y>>8); 
        LCD_WR_DATA(y&0XFF);
    }else
    {
        if(lcddev.dir==1)x=lcddev.width-1-x; // Change X-axes and Y-axes, for Horizontal or Vertical screen
        LCD_WriteReg(lcddev.setxcmd,x);
        LCD_WriteReg(lcddev.setycmd,y);
    }
    __LCD_CS_CLR(); 
    __LCD_RS_CLR();
    __DATAOUT(lcddev.wramcmd);              // Select GRAM Register
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    __LCD_CS_SET(); 
    LCD_WR_DATA(color);                     // Write Data to GRAM Space
}


/**
 *******************************************************************************
 * @brief       Set LCD display direction 
 * @param       Dir
*      @arg        0: Vertical screen
*      @arg        1: Horizontal screen
 * @return      None
 *******************************************************************************
 */
void LCD_Display_Dir(uint8_t Dir)
{
    if(Dir == 0)        // Vertical screen
    {
        lcddev.dir=0;   // Vertical screen
        lcddev.width=240;
        lcddev.height=320;
        if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2A;
            lcddev.setycmd=0X2B;
            if(lcddev.id==0X6804||lcddev.id==0X5310)
            {
                lcddev.width=320;
                lcddev.height=480;
            }
        }else if(lcddev.id==0X8989)
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=0X4E;
            lcddev.setycmd=0X4F;  
        }else if(lcddev.id==0x5510)
        {
            lcddev.wramcmd=0X2C00;
            lcddev.setxcmd=0X2A00;
            lcddev.setycmd=0X2B00; 
            lcddev.width=480;
            lcddev.height=800;
        }else
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=R32;
            lcddev.setycmd=R33;  
        }
    }else               // Horizontal screen
    {
        lcddev.dir=1;   // Horizontal screen
        lcddev.width=320;
        lcddev.height=240;
        if(lcddev.id==0X9341||lcddev.id==0X5310)
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2A;
            lcddev.setycmd=0X2B;
        }else if(lcddev.id==0X6804)
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2B;
            lcddev.setycmd=0X2A; 
        }else if(lcddev.id==0X8989)
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=0X4F;
            lcddev.setycmd=0X4E;
        }else if(lcddev.id==0x5510)
        {
            lcddev.wramcmd=0X2C00;
            lcddev.setxcmd=0X2A00;
            lcddev.setycmd=0X2B00; 
            lcddev.width=800;
            lcddev.height=480;
        }else
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=R33;
            lcddev.setycmd=R32;  
        }
        if(lcddev.id==0X6804||lcddev.id==0X5310)
        {
            lcddev.width=480;
            lcddev.height=320;
        }
    } 
    LCD_Scan_Dir(DFT_SCAN_DIR);     // default scan direction
}


/**
 *******************************************************************************
 * @brief       Set Windows
 * @param       sx : windows Start X-axes
 * @param       sy : windows Start Y-axes
 * @param       width : windows width
 * @param       height : windows height
 * @return      Color : Color Value
 * @note        6804 Not Support
 *******************************************************************************
 */
void LCD_Set_Window(uint16_t sx, uint16_t sy, uint16_t width, uint16_t height)
{   
    uint8_t hsareg,heareg,vsareg,veareg;
    uint16_t hsaval,heaval,vsaval,veaval; 
    width=sx+width-1;
    height=sy+height-1;
    if(lcddev.id==0X9341||lcddev.id==0X5310||lcddev.id==0X6804)//6804 Not Support
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(sx>>8); 
        LCD_WR_DATA(sx&0XFF);
        LCD_WR_DATA(width>>8); 
        LCD_WR_DATA(width&0XFF);  
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(sy>>8); 
        LCD_WR_DATA(sy&0XFF); 
        LCD_WR_DATA(height>>8); 
        LCD_WR_DATA(height&0XFF); 
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd); LCD_WR_DATA(sx>>8);
        LCD_WR_REG(lcddev.setxcmd+1); LCD_WR_DATA(sx&0XFF);
        LCD_WR_REG(lcddev.setxcmd+2); LCD_WR_DATA(width>>8);
        LCD_WR_REG(lcddev.setxcmd+3); LCD_WR_DATA(width&0XFF);
        LCD_WR_REG(lcddev.setycmd); LCD_WR_DATA(sy>>8);
        LCD_WR_REG(lcddev.setycmd+1); LCD_WR_DATA(sy&0XFF);
        LCD_WR_REG(lcddev.setycmd+2); LCD_WR_DATA(height>>8);
        LCD_WR_REG(lcddev.setycmd+3); LCD_WR_DATA(height&0XFF);
    }else   // Other chip
    {
        if(lcddev.dir==1) // Horizontal screen
        {
            // Windows Value
            hsaval=sy;
            heaval=height;
            vsaval=lcddev.width-width-1;
            veaval=lcddev.width-sx-1;
        }else
        { 
            hsaval=sx;
            heaval=width;
            vsaval=sy;
            veaval=height;
        }
        if(lcddev.id==0X8989) //8989 IC
        {
            hsareg=0X44;heareg=0X44; // Window Horizontal direction register (1289 only one control Register)
            hsaval|=(heaval<<8); // Read Reister Address.
            heaval=hsaval;
            vsareg=0X45;veareg=0X46; // Window Vertical direction register
        }else  // Other Chip
        {
            hsareg=0X50;heareg=0X51;// Window Horizontal direction register.
            vsareg=0X52;veareg=0X53;// Window Vertical direction register.
        }
        // Set register value
        LCD_WriteReg(hsareg,hsaval);
        LCD_WriteReg(heareg,heaval);
        LCD_WriteReg(vsareg,vsaval);
        LCD_WriteReg(veareg,veaval);
        LCD_SetCursor(sx,sy); // Set Cursor
    }
}

/**
 *******************************************************************************
 * @brief       1505 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_1505(void)
{
    // second release on 3/5  ,luminance is acceptable,water wave appear during camera preview
    LCD_WriteReg(0x0007,0x0000);
    MID_Delay(50); 
    LCD_WriteReg(0x0012,0x011C);//0x011A   why need to set several times?
    LCD_WriteReg(0x00A4,0x0001);//NVM
    LCD_WriteReg(0x0008,0x000F);
    LCD_WriteReg(0x000A,0x0008);
    LCD_WriteReg(0x000D,0x0008);
    //Gamma correction
    LCD_WriteReg(0x0030,0x0707);
    LCD_WriteReg(0x0031,0x0007); //0x0707
    LCD_WriteReg(0x0032,0x0603); 
    LCD_WriteReg(0x0033,0x0700); 
    LCD_WriteReg(0x0034,0x0202); 
    LCD_WriteReg(0x0035,0x0002); //?0x0606
    LCD_WriteReg(0x0036,0x1F0F);
    LCD_WriteReg(0x0037,0x0707); //0x0f0f  0x0105
    LCD_WriteReg(0x0038,0x0000); 
    LCD_WriteReg(0x0039,0x0000); 
    LCD_WriteReg(0x003A,0x0707); 
    LCD_WriteReg(0x003B,0x0000); //0x0303
    LCD_WriteReg(0x003C,0x0007); //?0x0707
    LCD_WriteReg(0x003D,0x0000); //0x1313//0x1f08
    MID_Delay(50); 
    LCD_WriteReg(0x0007,0x0001);
    LCD_WriteReg(0x0017,0x0001);//Power-ON
    MID_Delay(50); 
    // Power configuration
    LCD_WriteReg(0x0010,0x17A0); 
    LCD_WriteReg(0x0011,0x0217);//reference voltage VC[2:0]   Vciout = 1.00*Vcivl
    LCD_WriteReg(0x0012,0x011E);//0x011c  //Vreg1out = Vcilvl*1.80   is it the same as Vgama1out ?
    LCD_WriteReg(0x0013,0x0F00);//VDV[4:0]-->VCOM Amplitude VcomL = VcomH - Vcom Ampl
    LCD_WriteReg(0x002A,0x0000);  
    LCD_WriteReg(0x0029,0x000A);//0x0001F  Vcomh = VCM1[4:0]*Vreg1out    gate source voltage??
    LCD_WriteReg(0x0012,0x013E);// 0x013C  power supply on
    //Coordinates Control//
    LCD_WriteReg(0x0050,0x0000);//0x0e00
    LCD_WriteReg(0x0051,0x00EF); 
    LCD_WriteReg(0x0052,0x0000); 
    LCD_WriteReg(0x0053,0x013F); 
    //Pannel Image Control//
    LCD_WriteReg(0x0060,0x2700); 
    LCD_WriteReg(0x0061,0x0001); 
    LCD_WriteReg(0x006A,0x0000); 
    LCD_WriteReg(0x0080,0x0000); 
    //Partial Image Control//
    LCD_WriteReg(0x0081,0x0000); 
    LCD_WriteReg(0x0082,0x0000); 
    LCD_WriteReg(0x0083,0x0000); 
    LCD_WriteReg(0x0084,0x0000); 
    LCD_WriteReg(0x0085,0x0000); 
    //Panel Interface Control//
    LCD_WriteReg(0x0090,0x0013);//0x0010 frenqucy
    LCD_WriteReg(0x0092,0x0300); 
    LCD_WriteReg(0x0093,0x0005); 
    LCD_WriteReg(0x0095,0x0000); 
    LCD_WriteReg(0x0097,0x0000); 
    LCD_WriteReg(0x0098,0x0000); 
   
    LCD_WriteReg(0x0001,0x0100); 
    LCD_WriteReg(0x0002,0x0700); 
    LCD_WriteReg(0x0003,0x1038);//Scan direction, From Top to bottom, left to right
    LCD_WriteReg(0x0004,0x0000); 
    LCD_WriteReg(0x000C,0x0000); 
    LCD_WriteReg(0x000F,0x0000); 
    LCD_WriteReg(0x0020,0x0000); 
    LCD_WriteReg(0x0021,0x0000); 
    LCD_WriteReg(0x0007,0x0021); 
    MID_Delay(20);
    LCD_WriteReg(0x0007,0x0061); 
    MID_Delay(20);
    LCD_WriteReg(0x0007,0x0173); 
    MID_Delay(20);
}

/**
 *******************************************************************************
 * @brief       5310 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_5310(void)
{
    LCD_WR_REG(0xED);
    LCD_WR_DATAX(0x01);
    LCD_WR_DATAX(0xFE);

    LCD_WR_REG(0xEE);
    LCD_WR_DATAX(0xDE);
    LCD_WR_DATAX(0x21);

    LCD_WR_REG(0xF1);
    LCD_WR_DATAX(0x01);
    LCD_WR_REG(0xDF);
    LCD_WR_DATAX(0x10);

    //VCOMvoltage//
    LCD_WR_REG(0xC4);
    LCD_WR_DATAX(0x8F);     //5f

    LCD_WR_REG(0xC6);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xE2);
    LCD_WR_DATAX(0xE2);
    LCD_WR_DATAX(0xE2);
    LCD_WR_REG(0xBF);
    LCD_WR_DATAX(0xAA);

    LCD_WR_REG(0xB0);
    LCD_WR_DATAX(0x0D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x0D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x11);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x19);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x21);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x5D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x5D);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB1);
    LCD_WR_DATAX(0x80);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x8B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x96);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x02);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x03);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB4);
    LCD_WR_DATAX(0x8B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x96);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA1);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB5);
    LCD_WR_DATAX(0x02);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x03);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x04);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB6);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3F);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x5E);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x64);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x8C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xAC);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDC);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x70);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x90);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xEB);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDC);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xB8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xBA);
    LCD_WR_DATAX(0x24);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC1);
    LCD_WR_DATAX(0x20);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x54);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xFF);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC2);
    LCD_WR_DATAX(0x0A);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x04);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC3);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3A);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x39);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x37);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x36);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x32);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2F);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x29);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x26);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x24);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x24);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x23);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x36);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x32);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2F);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x29);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x26);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x24);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x24);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x23);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC4);
    LCD_WR_DATAX(0x62);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x05);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x84);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF0);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x18);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA4);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x18);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x50);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x0C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x17);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x95);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xE6);
    LCD_WR_DATAX(0x00);
   
    LCD_WR_REG(0xC5);
    LCD_WR_DATAX(0x32);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x65);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x76);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC6);
    LCD_WR_DATAX(0x20);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x17);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x01);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC9);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE0);
    LCD_WR_DATAX(0x16);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x1C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x21);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x36);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x46);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x52);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x64);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x7A);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x8B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB9);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC4);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xCA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD9);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xE0);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE1);
    LCD_WR_DATAX(0x16);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x1C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x22);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x36);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x45);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x52);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x64);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x7A);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x8B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB9);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC4);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xCA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xE0);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE2);
    LCD_WR_DATAX(0x05);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x0B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x1B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x34);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x4F);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x61);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x79);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x97);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA6);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD1);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD6);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDD);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);
    LCD_WR_REG(0xE3);
    LCD_WR_DATAX(0x05);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x1C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x33);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x50);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x62);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x78);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x97);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA6);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC7);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD1);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD5);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDD);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE4);
    LCD_WR_DATAX(0x01);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x01);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x02);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x2A);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x4B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x5D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x74);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x84);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x93);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xBE);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC4);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xCD);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDD);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);
    LCD_WR_REG(0xE5);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x02);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x29);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x4B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x5D);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x74);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x84);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x93);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xA2);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xB3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xBE);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC4);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xCD);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xD3);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xDC);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xF3);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE6);
    LCD_WR_DATAX(0x11);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x34);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x56);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x76);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x77);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x66);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xBB);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x66);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x45);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x43);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE7);
    LCD_WR_DATAX(0x32);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x76);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x66);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x67);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x67);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x87);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xBB);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x77);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x56);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x23); 
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x33);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x45);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE8);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x87);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x77);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x66);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x88);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xAA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xBB);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x99);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x66);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x44);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x55);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xE9);
    LCD_WR_DATAX(0xAA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0x00);
    LCD_WR_DATAX(0xAA);

    LCD_WR_REG(0xCF);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xF0);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x50);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xF3);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xF9);
    LCD_WR_DATAX(0x06);
    LCD_WR_DATAX(0x10);
    LCD_WR_DATAX(0x29);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0x3A);
    LCD_WR_DATAX(0x55);	//66

    LCD_WR_REG(0x11);
    MID_Delay(100);
    LCD_WR_REG(0x29);
    LCD_WR_REG(0x35);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0x51);
    LCD_WR_DATAX(0xFF);
    LCD_WR_REG(0x53);
    LCD_WR_DATAX(0x2C);
    LCD_WR_REG(0x55);
    LCD_WR_DATAX(0x82);
    LCD_WR_REG(0x2c); 
}

/**
 *******************************************************************************
 * @brief       5408 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_5408(void)
{
    LCD_WriteReg(0x01,0x0100);
    LCD_WriteReg(0x02,0x0700); // LCD Driving Waveform Contral 
    LCD_WriteReg(0x03,0x1030); // Entry Mode Setting   
                               // Point auto Increase From left to right, top to bottom.
                               // Normal Mode(Window Mode disable)
                               // RGB format
                               // 8-bus settings for 2 transmissions of 16-bit data
    LCD_WriteReg(0x04,0x0000); // Scalling Control register
    LCD_WriteReg(0x08,0x0207); // Display Control 2
    LCD_WriteReg(0x09,0x0000); // Display Control 3
    LCD_WriteReg(0x0A,0x0000); // Frame Cycle Control
    LCD_WriteReg(0x0C,0x0000); // External Display Interface Control 1 
    LCD_WriteReg(0x0D,0x0000); // Frame Maker Position
    LCD_WriteReg(0x0F,0x0000); // External Display Interface Control 2 
    MID_Delay(20);

    // TFT LCD color image display method 14
    LCD_WriteReg(0x10,0x16B0); //0x14B0 //Power Control 1
    LCD_WriteReg(0x11,0x0001); //0x0007 //Power Control 2
    LCD_WriteReg(0x17,0x0001); //0x0000 //Power Control 3
    LCD_WriteReg(0x12,0x0138); //0x013B //Power Control 4
    LCD_WriteReg(0x13,0x0800); //0x0800 //Power Control 5
    LCD_WriteReg(0x29,0x0009); //NVM read data 2
    LCD_WriteReg(0x2a,0x0009); //NVM read data 3
    LCD_WriteReg(0xa4,0x0000);	 
    LCD_WriteReg(0x50,0x0000); //Set the X axis start column of the operation window
    LCD_WriteReg(0x51,0x00EF); //Set the X-axis end column of the operation window
    LCD_WriteReg(0x52,0x0000); //Set the Y axis start column of the operation window
    LCD_WriteReg(0x53,0x013F); //Set the Y-axis end column of the operation window
    LCD_WriteReg(0x60,0x2700); //Driver Output Control

    //Set the number of points on the screen and the start line of scanning
    LCD_WriteReg(0x61,0x0001); //Driver Output Control
    LCD_WriteReg(0x6A,0x0000); //Vertical Scroll Control
    LCD_WriteReg(0x80,0x0000); //Display Position – Partial Display 1
    LCD_WriteReg(0x81,0x0000); //RAM Address Start – Partial Display 1
    LCD_WriteReg(0x82,0x0000); //RAM address End - Partial Display 1
    LCD_WriteReg(0x83,0x0000); //Display Position – Partial Display 2
    LCD_WriteReg(0x84,0x0000); //RAM Address Start – Partial Display 2
    LCD_WriteReg(0x85,0x0000); //RAM address End – Partail Display2
    LCD_WriteReg(0x90,0x0013); //Frame Cycle Control
    LCD_WriteReg(0x92,0x0000);  //Panel Interface Control 2
    LCD_WriteReg(0x93,0x0003); //Panel Interface control 3
    LCD_WriteReg(0x95,0x0110);  //Frame Cycle Control
    LCD_WriteReg(0x07,0x0173);  
    MID_Delay(50);
}

/**
 *******************************************************************************
 * @brief       5510 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_5510(void)
{
    LCD_WriteReg(0xF000,0x55);
    LCD_WriteReg(0xF001,0xAA);
    LCD_WriteReg(0xF002,0x52);
    LCD_WriteReg(0xF003,0x08);
    LCD_WriteReg(0xF004,0x01);
    //AVDD Set AVDD 5.2V
    LCD_WriteReg(0xB000,0x0D);
    LCD_WriteReg(0xB001,0x0D);
    LCD_WriteReg(0xB002,0x0D);
    //AVDD ratio
    LCD_WriteReg(0xB600,0x34);
    LCD_WriteReg(0xB601,0x34);
    LCD_WriteReg(0xB602,0x34);
    //AVEE -5.2V
    LCD_WriteReg(0xB100,0x0D);
    LCD_WriteReg(0xB101,0x0D);
    LCD_WriteReg(0xB102,0x0D);
    //AVEE ratio
    LCD_WriteReg(0xB700,0x34);
    LCD_WriteReg(0xB701,0x34);
    LCD_WriteReg(0xB702,0x34);
    //VCL -2.5V
    LCD_WriteReg(0xB200,0x00);
    LCD_WriteReg(0xB201,0x00);
    LCD_WriteReg(0xB202,0x00);
    //VCL ratio
    LCD_WriteReg(0xB800,0x24);
    LCD_WriteReg(0xB801,0x24);
    LCD_WriteReg(0xB802,0x24);
    //VGH 15V (Free pump)
    LCD_WriteReg(0xBF00,0x01);
    LCD_WriteReg(0xB300,0x0F);
    LCD_WriteReg(0xB301,0x0F);
    LCD_WriteReg(0xB302,0x0F);
    //VGH ratio
    LCD_WriteReg(0xB900,0x34);
    LCD_WriteReg(0xB901,0x34);
    LCD_WriteReg(0xB902,0x34);
    //VGL_REG -10V
    LCD_WriteReg(0xB500,0x08);
    LCD_WriteReg(0xB501,0x08);
    LCD_WriteReg(0xB502,0x08);
    LCD_WriteReg(0xC200,0x03);
    //VGLX ratio
    LCD_WriteReg(0xBA00,0x24);
    LCD_WriteReg(0xBA01,0x24);
    LCD_WriteReg(0xBA02,0x24);
    //VGMP/VGSP 4.5V/0V
    LCD_WriteReg(0xBC00,0x00);
    LCD_WriteReg(0xBC01,0x78);
    LCD_WriteReg(0xBC02,0x00);
    //VGMN/VGSN -4.5V/0V
    LCD_WriteReg(0xBD00,0x00);
    LCD_WriteReg(0xBD01,0x78);
    LCD_WriteReg(0xBD02,0x00);
    //VCOM
    LCD_WriteReg(0xBE00,0x00);
    LCD_WriteReg(0xBE01,0x64);
    //Gamma Setting
    LCD_WriteReg(0xD100,0x00);
    LCD_WriteReg(0xD101,0x33);
    LCD_WriteReg(0xD102,0x00);
    LCD_WriteReg(0xD103,0x34);
    LCD_WriteReg(0xD104,0x00);
    LCD_WriteReg(0xD105,0x3A);
    LCD_WriteReg(0xD106,0x00);
    LCD_WriteReg(0xD107,0x4A);
    LCD_WriteReg(0xD108,0x00);
    LCD_WriteReg(0xD109,0x5C);
    LCD_WriteReg(0xD10A,0x00);
    LCD_WriteReg(0xD10B,0x81);
    LCD_WriteReg(0xD10C,0x00);
    LCD_WriteReg(0xD10D,0xA6);
    LCD_WriteReg(0xD10E,0x00);
    LCD_WriteReg(0xD10F,0xE5);
    LCD_WriteReg(0xD110,0x01);
    LCD_WriteReg(0xD111,0x13);
    LCD_WriteReg(0xD112,0x01);
    LCD_WriteReg(0xD113,0x54);
    LCD_WriteReg(0xD114,0x01);
    LCD_WriteReg(0xD115,0x82);
    LCD_WriteReg(0xD116,0x01);
    LCD_WriteReg(0xD117,0xCA);
    LCD_WriteReg(0xD118,0x02);
    LCD_WriteReg(0xD119,0x00);
    LCD_WriteReg(0xD11A,0x02);
    LCD_WriteReg(0xD11B,0x01);
    LCD_WriteReg(0xD11C,0x02);
    LCD_WriteReg(0xD11D,0x34);
    LCD_WriteReg(0xD11E,0x02);
    LCD_WriteReg(0xD11F,0x67);
    LCD_WriteReg(0xD120,0x02);
    LCD_WriteReg(0xD121,0x84);
    LCD_WriteReg(0xD122,0x02);
    LCD_WriteReg(0xD123,0xA4);
    LCD_WriteReg(0xD124,0x02);
    LCD_WriteReg(0xD125,0xB7);
    LCD_WriteReg(0xD126,0x02);
    LCD_WriteReg(0xD127,0xCF);
    LCD_WriteReg(0xD128,0x02);
    LCD_WriteReg(0xD129,0xDE);
    LCD_WriteReg(0xD12A,0x02);
    LCD_WriteReg(0xD12B,0xF2);
    LCD_WriteReg(0xD12C,0x02);
    LCD_WriteReg(0xD12D,0xFE);
    LCD_WriteReg(0xD12E,0x03);
    LCD_WriteReg(0xD12F,0x10);
    LCD_WriteReg(0xD130,0x03);
    LCD_WriteReg(0xD131,0x33);
    LCD_WriteReg(0xD132,0x03);
    LCD_WriteReg(0xD133,0x6D);
    LCD_WriteReg(0xD200,0x00);
    LCD_WriteReg(0xD201,0x33);
    LCD_WriteReg(0xD202,0x00);
    LCD_WriteReg(0xD203,0x34);
    LCD_WriteReg(0xD204,0x00);
    LCD_WriteReg(0xD205,0x3A);
    LCD_WriteReg(0xD206,0x00);
    LCD_WriteReg(0xD207,0x4A);
    LCD_WriteReg(0xD208,0x00);
    LCD_WriteReg(0xD209,0x5C);
    LCD_WriteReg(0xD20A,0x00);
    
    LCD_WriteReg(0xD20B,0x81);
    LCD_WriteReg(0xD20C,0x00);
    LCD_WriteReg(0xD20D,0xA6);
    LCD_WriteReg(0xD20E,0x00);
    LCD_WriteReg(0xD20F,0xE5);
    LCD_WriteReg(0xD210,0x01);
    LCD_WriteReg(0xD211,0x13);
    LCD_WriteReg(0xD212,0x01);
    LCD_WriteReg(0xD213,0x54);
    LCD_WriteReg(0xD214,0x01);
    LCD_WriteReg(0xD215,0x82);
    LCD_WriteReg(0xD216,0x01);
    LCD_WriteReg(0xD217,0xCA);
    LCD_WriteReg(0xD218,0x02);
    LCD_WriteReg(0xD219,0x00);
    LCD_WriteReg(0xD21A,0x02);
    LCD_WriteReg(0xD21B,0x01);
    LCD_WriteReg(0xD21C,0x02);
    LCD_WriteReg(0xD21D,0x34);
    LCD_WriteReg(0xD21E,0x02);
    LCD_WriteReg(0xD21F,0x67);
    LCD_WriteReg(0xD220,0x02);
    LCD_WriteReg(0xD221,0x84);
    LCD_WriteReg(0xD222,0x02);
    LCD_WriteReg(0xD223,0xA4);
    LCD_WriteReg(0xD224,0x02);
    LCD_WriteReg(0xD225,0xB7);
    LCD_WriteReg(0xD226,0x02);
    LCD_WriteReg(0xD227,0xCF);
    LCD_WriteReg(0xD228,0x02);
    LCD_WriteReg(0xD229,0xDE);
    LCD_WriteReg(0xD22A,0x02);
    LCD_WriteReg(0xD22B,0xF2);
    LCD_WriteReg(0xD22C,0x02);
    LCD_WriteReg(0xD22D,0xFE);
    LCD_WriteReg(0xD22E,0x03);
    LCD_WriteReg(0xD22F,0x10);
    LCD_WriteReg(0xD230,0x03);
    LCD_WriteReg(0xD231,0x33);
    LCD_WriteReg(0xD232,0x03);
    LCD_WriteReg(0xD233,0x6D);
    LCD_WriteReg(0xD300,0x00);
    LCD_WriteReg(0xD301,0x33);
    LCD_WriteReg(0xD302,0x00);
    LCD_WriteReg(0xD303,0x34);
    LCD_WriteReg(0xD304,0x00);
    LCD_WriteReg(0xD305,0x3A);
    LCD_WriteReg(0xD306,0x00);
    LCD_WriteReg(0xD307,0x4A);
    LCD_WriteReg(0xD308,0x00);
    LCD_WriteReg(0xD309,0x5C);
    LCD_WriteReg(0xD30A,0x00);
    
    LCD_WriteReg(0xD30B,0x81);
    LCD_WriteReg(0xD30C,0x00);
    LCD_WriteReg(0xD30D,0xA6);
    LCD_WriteReg(0xD30E,0x00);
    LCD_WriteReg(0xD30F,0xE5);
    LCD_WriteReg(0xD310,0x01);
    LCD_WriteReg(0xD311,0x13);
    LCD_WriteReg(0xD312,0x01);
    LCD_WriteReg(0xD313,0x54);
    LCD_WriteReg(0xD314,0x01);
    LCD_WriteReg(0xD315,0x82);
    LCD_WriteReg(0xD316,0x01);
    LCD_WriteReg(0xD317,0xCA);
    LCD_WriteReg(0xD318,0x02);
    LCD_WriteReg(0xD319,0x00);
    LCD_WriteReg(0xD31A,0x02);
    LCD_WriteReg(0xD31B,0x01);
    LCD_WriteReg(0xD31C,0x02);
    LCD_WriteReg(0xD31D,0x34);
    LCD_WriteReg(0xD31E,0x02);
    LCD_WriteReg(0xD31F,0x67);
    LCD_WriteReg(0xD320,0x02);
    LCD_WriteReg(0xD321,0x84);
    LCD_WriteReg(0xD322,0x02);
    LCD_WriteReg(0xD323,0xA4);
    LCD_WriteReg(0xD324,0x02);
    LCD_WriteReg(0xD325,0xB7);
    LCD_WriteReg(0xD326,0x02);
    LCD_WriteReg(0xD327,0xCF);
    LCD_WriteReg(0xD328,0x02);
    LCD_WriteReg(0xD329,0xDE);
    LCD_WriteReg(0xD32A,0x02);
    LCD_WriteReg(0xD32B,0xF2);
    LCD_WriteReg(0xD32C,0x02);
    LCD_WriteReg(0xD32D,0xFE);
    LCD_WriteReg(0xD32E,0x03);
    LCD_WriteReg(0xD32F,0x10);
    LCD_WriteReg(0xD330,0x03);
    LCD_WriteReg(0xD331,0x33);
    LCD_WriteReg(0xD332,0x03);
    LCD_WriteReg(0xD333,0x6D);
    LCD_WriteReg(0xD400,0x00);
    LCD_WriteReg(0xD401,0x33);
    LCD_WriteReg(0xD402,0x00);
    LCD_WriteReg(0xD403,0x34);
    LCD_WriteReg(0xD404,0x00);
    LCD_WriteReg(0xD405,0x3A);
    LCD_WriteReg(0xD406,0x00);
    LCD_WriteReg(0xD407,0x4A);
    LCD_WriteReg(0xD408,0x00);
    LCD_WriteReg(0xD409,0x5C);
    LCD_WriteReg(0xD40A,0x00);
    LCD_WriteReg(0xD40B,0x81);
    
    LCD_WriteReg(0xD40C,0x00);
    LCD_WriteReg(0xD40D,0xA6);
    LCD_WriteReg(0xD40E,0x00);
    LCD_WriteReg(0xD40F,0xE5);
    LCD_WriteReg(0xD410,0x01);
    LCD_WriteReg(0xD411,0x13);
    LCD_WriteReg(0xD412,0x01);
    LCD_WriteReg(0xD413,0x54);
    LCD_WriteReg(0xD414,0x01);
    LCD_WriteReg(0xD415,0x82);
    LCD_WriteReg(0xD416,0x01);
    LCD_WriteReg(0xD417,0xCA);
    LCD_WriteReg(0xD418,0x02);
    LCD_WriteReg(0xD419,0x00);
    LCD_WriteReg(0xD41A,0x02);
    LCD_WriteReg(0xD41B,0x01);
    LCD_WriteReg(0xD41C,0x02);
    LCD_WriteReg(0xD41D,0x34);
    LCD_WriteReg(0xD41E,0x02);
    LCD_WriteReg(0xD41F,0x67);
    LCD_WriteReg(0xD420,0x02);
    LCD_WriteReg(0xD421,0x84);
    LCD_WriteReg(0xD422,0x02);
    LCD_WriteReg(0xD423,0xA4);
    LCD_WriteReg(0xD424,0x02);
    LCD_WriteReg(0xD425,0xB7);
    LCD_WriteReg(0xD426,0x02);
    LCD_WriteReg(0xD427,0xCF);
    LCD_WriteReg(0xD428,0x02);
    LCD_WriteReg(0xD429,0xDE);
    LCD_WriteReg(0xD42A,0x02);
    LCD_WriteReg(0xD42B,0xF2);
    LCD_WriteReg(0xD42C,0x02);
    LCD_WriteReg(0xD42D,0xFE);
    LCD_WriteReg(0xD42E,0x03);
    LCD_WriteReg(0xD42F,0x10);
    LCD_WriteReg(0xD430,0x03);
    LCD_WriteReg(0xD431,0x33);
    LCD_WriteReg(0xD432,0x03);
    LCD_WriteReg(0xD433,0x6D);
    LCD_WriteReg(0xD500,0x00);
    LCD_WriteReg(0xD501,0x33);
    LCD_WriteReg(0xD502,0x00);
    LCD_WriteReg(0xD503,0x34);
    LCD_WriteReg(0xD504,0x00);
    LCD_WriteReg(0xD505,0x3A);
    LCD_WriteReg(0xD506,0x00);
    LCD_WriteReg(0xD507,0x4A);
    LCD_WriteReg(0xD508,0x00);
    LCD_WriteReg(0xD509,0x5C);
    LCD_WriteReg(0xD50A,0x00);
    LCD_WriteReg(0xD50B,0x81);
    
    LCD_WriteReg(0xD50C,0x00);
    LCD_WriteReg(0xD50D,0xA6);
    LCD_WriteReg(0xD50E,0x00);
    LCD_WriteReg(0xD50F,0xE5);
    LCD_WriteReg(0xD510,0x01);
    LCD_WriteReg(0xD511,0x13);
    LCD_WriteReg(0xD512,0x01);
    LCD_WriteReg(0xD513,0x54);
    LCD_WriteReg(0xD514,0x01);
    LCD_WriteReg(0xD515,0x82);
    LCD_WriteReg(0xD516,0x01);
    LCD_WriteReg(0xD517,0xCA);
    LCD_WriteReg(0xD518,0x02);
    LCD_WriteReg(0xD519,0x00);
    LCD_WriteReg(0xD51A,0x02);
    LCD_WriteReg(0xD51B,0x01);
    LCD_WriteReg(0xD51C,0x02);
    LCD_WriteReg(0xD51D,0x34);
    LCD_WriteReg(0xD51E,0x02);
    LCD_WriteReg(0xD51F,0x67);
    LCD_WriteReg(0xD520,0x02);
    LCD_WriteReg(0xD521,0x84);
    LCD_WriteReg(0xD522,0x02);
    LCD_WriteReg(0xD523,0xA4);
    LCD_WriteReg(0xD524,0x02);
    LCD_WriteReg(0xD525,0xB7);
    LCD_WriteReg(0xD526,0x02);
    LCD_WriteReg(0xD527,0xCF);
    LCD_WriteReg(0xD528,0x02);
    LCD_WriteReg(0xD529,0xDE);
    LCD_WriteReg(0xD52A,0x02);
    LCD_WriteReg(0xD52B,0xF2);
    LCD_WriteReg(0xD52C,0x02);
    LCD_WriteReg(0xD52D,0xFE);
    LCD_WriteReg(0xD52E,0x03);
    LCD_WriteReg(0xD52F,0x10);
    LCD_WriteReg(0xD530,0x03);
    LCD_WriteReg(0xD531,0x33);
    LCD_WriteReg(0xD532,0x03);
    LCD_WriteReg(0xD533,0x6D);
    LCD_WriteReg(0xD600,0x00);
    LCD_WriteReg(0xD601,0x33);
    LCD_WriteReg(0xD602,0x00);
    LCD_WriteReg(0xD603,0x34);
    LCD_WriteReg(0xD604,0x00);
    LCD_WriteReg(0xD605,0x3A);
    LCD_WriteReg(0xD606,0x00);
    LCD_WriteReg(0xD607,0x4A);
    LCD_WriteReg(0xD608,0x00);
    LCD_WriteReg(0xD609,0x5C);
    LCD_WriteReg(0xD60A,0x00);
    LCD_WriteReg(0xD60B,0x81);
    
    LCD_WriteReg(0xD60C,0x00);
    LCD_WriteReg(0xD60D,0xA6);
    LCD_WriteReg(0xD60E,0x00);
    LCD_WriteReg(0xD60F,0xE5);
    LCD_WriteReg(0xD610,0x01);
    LCD_WriteReg(0xD611,0x13);
    LCD_WriteReg(0xD612,0x01);
    LCD_WriteReg(0xD613,0x54);
    LCD_WriteReg(0xD614,0x01);
    LCD_WriteReg(0xD615,0x82);
    LCD_WriteReg(0xD616,0x01);
    LCD_WriteReg(0xD617,0xCA);
    LCD_WriteReg(0xD618,0x02);
    LCD_WriteReg(0xD619,0x00);
    LCD_WriteReg(0xD61A,0x02);
    LCD_WriteReg(0xD61B,0x01);
    LCD_WriteReg(0xD61C,0x02);
    LCD_WriteReg(0xD61D,0x34);
    LCD_WriteReg(0xD61E,0x02);
    LCD_WriteReg(0xD61F,0x67);
    LCD_WriteReg(0xD620,0x02);
    LCD_WriteReg(0xD621,0x84);
    LCD_WriteReg(0xD622,0x02);
    LCD_WriteReg(0xD623,0xA4);
    LCD_WriteReg(0xD624,0x02);
    LCD_WriteReg(0xD625,0xB7);
    LCD_WriteReg(0xD626,0x02);
    LCD_WriteReg(0xD627,0xCF);
    LCD_WriteReg(0xD628,0x02);
    LCD_WriteReg(0xD629,0xDE);
    LCD_WriteReg(0xD62A,0x02);
    LCD_WriteReg(0xD62B,0xF2);
    LCD_WriteReg(0xD62C,0x02);
    LCD_WriteReg(0xD62D,0xFE);
    LCD_WriteReg(0xD62E,0x03);
    LCD_WriteReg(0xD62F,0x10);
    LCD_WriteReg(0xD630,0x03);
    LCD_WriteReg(0xD631,0x33);
    LCD_WriteReg(0xD632,0x03);
    LCD_WriteReg(0xD633,0x6D);
    //LV2 Page 0 enable
    LCD_WriteReg(0xF000,0x55);
    LCD_WriteReg(0xF001,0xAA);
    LCD_WriteReg(0xF002,0x52);
    LCD_WriteReg(0xF003,0x08);
    LCD_WriteReg(0xF004,0x00);
    //Display control
    LCD_WriteReg(0xB100, 0xCC);
    LCD_WriteReg(0xB101, 0x00);
    //Source hold time
    LCD_WriteReg(0xB600,0x05);
    //Gate EQ control
    LCD_WriteReg(0xB700,0x70);
    LCD_WriteReg(0xB701,0x70);
    //Source EQ control (Mode 2)
    LCD_WriteReg(0xB800,0x01);
    LCD_WriteReg(0xB801,0x03);
    LCD_WriteReg(0xB802,0x03);
    LCD_WriteReg(0xB803,0x03);
    //Inversion mode (2-dot)
    LCD_WriteReg(0xBC00,0x02);
    LCD_WriteReg(0xBC01,0x00);
    LCD_WriteReg(0xBC02,0x00);
    //Timing control 4H w/ 4-delay
    LCD_WriteReg(0xC900,0xD0);
    LCD_WriteReg(0xC901,0x02);
    LCD_WriteReg(0xC902,0x50);
    LCD_WriteReg(0xC903,0x50);
    LCD_WriteReg(0xC904,0x50);
    LCD_WriteReg(0x3500,0x00);
    LCD_WriteReg(0x3A00,0x55);  //16-bit/pixel
    LCD_WR_REG(0x1100);
    delay_us(120);
    LCD_WR_REG(0x2900);
}

/**
 *******************************************************************************
 * @brief       SC6804A Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_6804(void)
{
    LCD_WR_REG(0X11);
    MID_Delay(20);
    LCD_WR_REG(0XD0);//VCI1  VCL  VGH  VGL DDVDH VREG1OUT power amplitude setting
    LCD_WR_DATAX(0X07); 
    LCD_WR_DATAX(0X42); 
    LCD_WR_DATAX(0X1D); 
    LCD_WR_REG(0XD1);//VCOMH VCOM_AC amplitude setting
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X1a);
    LCD_WR_DATAX(0X09); 
    LCD_WR_REG(0XD2);//Operational Amplifier Circuit Constant Current Adjust , charge pump frequency setting
    LCD_WR_DATAX(0X01);
    LCD_WR_DATAX(0X22);
    LCD_WR_REG(0XC0);//REV SM GS 
    LCD_WR_DATAX(0X10);
    LCD_WR_DATAX(0X3B);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X02);
    LCD_WR_DATAX(0X11);
    LCD_WR_REG(0XC5);// Frame rate setting = 72HZ  when setting 0x03
    LCD_WR_DATAX(0X03);
    LCD_WR_REG(0XC8);//Gamma setting
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X25);
    LCD_WR_DATAX(0X21);
    LCD_WR_DATAX(0X05);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X0a);
    LCD_WR_DATAX(0X65);
    LCD_WR_DATAX(0X25);
    LCD_WR_DATAX(0X77);
    LCD_WR_DATAX(0X50);
    LCD_WR_DATAX(0X0f);
    LCD_WR_DATAX(0X00);
    LCD_WR_REG(0XF8);
    LCD_WR_DATAX(0X01);
    LCD_WR_REG(0XFE);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X02);
    LCD_WR_REG(0X20);//Exit invert mode
    LCD_WR_REG(0X36);
    LCD_WR_DATAX(0X08);// default value 0x0a
    LCD_WR_REG(0X3A);
    LCD_WR_DATAX(0X55);// 16Bits Mode
    LCD_WR_REG(0X2B);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X01);
    LCD_WR_DATAX(0X3F);
    LCD_WR_REG(0X2A);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X00);
    LCD_WR_DATAX(0X01);
    LCD_WR_DATAX(0XDF);
    MID_Delay(120);
    LCD_WR_REG(0X29);
}

/**
 *******************************************************************************
 * @brief       ILI9320 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_9320(void)
{
    LCD_WriteReg(0x00,0x0000);
    LCD_WriteReg(0x01,0x0100);          //Driver Output Contral.
    LCD_WriteReg(0x02,0x0700);          //LCD Driver Waveform Contral.
    LCD_WriteReg(0x03,0x1030);          //Entry Mode Set.
    //LCD_WriteReg(0x03,0x1018);        //Entry Mode Set.
    
    LCD_WriteReg(0x04,0x0000);          //Scalling Contral.
    LCD_WriteReg(0x08,0x0202);          //Display Contral 2.(0x0207)
    LCD_WriteReg(0x09,0x0000);          //Display Contral 3.(0x0000)
    LCD_WriteReg(0x0a,0x0000);          //Frame Cycle Contal.(0x0000)
    LCD_WriteReg(0x0c,(1<<0));          //Extern Display Interface Contral 1.(0x0000)
    LCD_WriteReg(0x0d,0x0000);          //Frame Maker Position.
    LCD_WriteReg(0x0f,0x0000);          //Extern Display Interface Contral 2.
    MID_Delay(50); 
    LCD_WriteReg(0x07,0x0101);          //Display Contral.
    MID_Delay(50);
    LCD_WriteReg(0x10,(1<<12)|(0<<8)|(1<<7)|(1<<6)|(0<<4));     //Power Control 1.(0x16b0)
    LCD_WriteReg(0x11,0x0007);          //Power Control 2.(0x0001)
    LCD_WriteReg(0x12,(1<<8)|(1<<4)|(0<<0));    //Power Control 3.(0x0138)
    LCD_WriteReg(0x13,0x0b00);          //Power Control 4.
    LCD_WriteReg(0x29,0x0000);          //Power Control 7.
    
    LCD_WriteReg(0x2b,(1<<14)|(1<<4));
    LCD_WriteReg(0x50,0);               //Set X Star
    //Horizontal GRAM end position      //Set X End.
    LCD_WriteReg(0x51,239);             //Set Y Star
    LCD_WriteReg(0x52,0);               //Set Y End.t.
    LCD_WriteReg(0x53,319);             //
    
    LCD_WriteReg(0x60,0x2700);          //Driver Output Control.
    LCD_WriteReg(0x61,0x0001);          //Driver Output Control.
    LCD_WriteReg(0x6a,0x0000);          //Vertical Srcoll Control.
    
    LCD_WriteReg(0x80,0x0000);          //Display Position? Partial Display 1.
    LCD_WriteReg(0x81,0x0000);          //RAM Address Start? Partial Display 1.
    LCD_WriteReg(0x82,0x0000);          //RAM Address End-Partial Display 1.
    LCD_WriteReg(0x83,0x0000);          //Displsy Position? Partial Display 2.
    LCD_WriteReg(0x84,0x0000);          //RAM Address Start? Partial Display 2.
    LCD_WriteReg(0x85,0x0000);          //RAM Address End? Partial Display 2.
    
    LCD_WriteReg(0x90,(0<<7)|(16<<0));  //Frame Cycle Contral.(0x0013)
    LCD_WriteReg(0x92,0x0000);          //Panel Interface Contral 2.(0x0000)
    LCD_WriteReg(0x93,0x0001);          //Panel Interface Contral 3.
    LCD_WriteReg(0x95,0x0110);          //Frame Cycle Contral.(0x0110)
    LCD_WriteReg(0x97,(0<<8));          //
    LCD_WriteReg(0x98,0x0000);          //Frame Cycle Contral.
    LCD_WriteReg(0x07,0x0173);          //(0x0173)
}

/**
 *******************************************************************************
 * @brief       ILI9325 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_9325(void)
{
//************* Start Initial Sequence **********//
    LCD_WriteReg(0x00E5, 0x78F0);       // Set uint16_ternal timing
    LCD_WriteReg(0x0001, 0x0000);       // set SS and SM bit
    LCD_WriteReg(0x0002, 0x0700);       // set 1 line inversion
    LCD_WriteReg(0x0003, 0x1030);       // ColorBar OK, Location OK
    //LCD_WriteReg(0x0003, 0x5030);       // set GRAM write direction and BGR=1.
    LCD_WriteReg(0x0004, 0x0000);       // Resize register
    LCD_WriteReg(0x0008, 0x0202);       // Ver1. set the back porch and front porch
    //LCD_WriteReg(0x0008, 0x0404);       // Ver1. set the back porch and front porch
    LCD_WriteReg(0x0009, 0x0000);
    // LCD_WriteReg(0x0009, 0x000F);      // set non-display area refresh cycle ISC[3:0]
    LCD_WriteReg(0x000A, 0x0000);       // FMARK function
    LCD_WriteReg(0x000C, 0x0000);       // RGB uint16_terface setting
    LCD_WriteReg(0x000D, 0x0000);       // Frame marker Position
    LCD_WriteReg(0x000F, 0x0000);       // RGB uint16_terface polarity

//************* power on sequence VGHVGL ****************//
    LCD_WriteReg(0x0010, 0x0000);       // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0007);       // DC1[2:0], DC0[2:0], VC[2:0]
    LCD_WriteReg(0x0012, 0x0000);       // VREG1OUT voltage
    LCD_WriteReg(0x0013, 0x0000);       // VDV[4:0] for VCOM amplitude
    LCD_WriteReg(0x0007, 0x0000);       // Dis-charge capacitor power voltage
    //vgh 
    LCD_WriteReg(0x0010, 0x1690);       // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0227);       // R11h=0x0221 at VCI=3.3V, DC1[2:0], DC0[2:0], VC[2:0]
    // LCD_WriteReg(0x0011, 0x0037);      // R11h=0x0221 at VCI=3.3V, DC1[2:0], DC0[2:0], VC[2:0]
    //delayms(100);
    //vregiout 
    LCD_WriteReg(0x0012, 0x009D);       // 0x001b
    //LCD_WriteReg(0x0012, 0x013A);       // External reference voltage = Vci;
    //delayms(100); 
    //vom amplitude
    LCD_WriteReg(0x0013,0x1900);
    //LCD_WriteReg(0x0013, 0x1600);       // R13=0F00 when R12=009E;VDV[4:0] for VCOM amplitude  
    //delayms(100); 
    //vom H
    LCD_WriteReg(0x0029,0x0025);
    //LCD_WriteReg(0x0029, 0x000C);       // R29=0019 when R12=009E;VCM[5:0] for VCOMH 
    LCD_WriteReg(0x002B,0x000D);
    //LCD_WriteReg(0x0020, 0x0000);       // GRAM horizontal Address  
    //LCD_WriteReg(0x0021, 0x0000);       // GRAM Vertical Address 

//************* Adjust the Gamma Curve ****************//
    LCD_WriteReg(0x0030,0x0007);
    LCD_WriteReg(0x0031,0x0303);
    LCD_WriteReg(0x0032,0x0003);// 0006
    LCD_WriteReg(0x0035,0x0206);
    LCD_WriteReg(0x0036,0x0008);
    LCD_WriteReg(0x0037,0x0406); 
    LCD_WriteReg(0x0038,0x0304);//0200
    LCD_WriteReg(0x0039,0x0007); 
    LCD_WriteReg(0x003C,0x0602);// 0504
    LCD_WriteReg(0x003D,0x0008); 

//************* Set GRAM area ****************// 
    LCD_WriteReg(0x0050,0x0000);        // Horizontal GRAM Start Address  
    LCD_WriteReg(0x0051,0x00EF);        // Horizontal GRAM End Address 
    LCD_WriteReg(0x0052,0x0000);        // Vertical GRAM Start Address
    LCD_WriteReg(0x0053,0x013F);        // Vertical GRAM Start Address  
    LCD_WriteReg(0x0060,0x2700);        // Gate Scan Line  
    LCD_WriteReg(0x0061,0x0001);        // NDL,VLE, REV  
    LCD_WriteReg(0x006A,0x0000);        // set scrolling line  

//************* Partial Display Control ****************//
    LCD_WriteReg(0x0080,0x0000); 
    LCD_WriteReg(0x0081,0x0000); 
    LCD_WriteReg(0x0082,0x0000); 
    LCD_WriteReg(0x0083,0x0000); 
    LCD_WriteReg(0x0084,0x0000); 
    LCD_WriteReg(0x0085,0x0000);

//************* Panel Control ****************//
    LCD_WriteReg(0x0090,0x0010); 
    LCD_WriteReg(0x0092,0x0600); 
    
    LCD_WriteReg(0x0007,0x0133);        // 262K color and display ON
    LCD_WriteReg(0x00,0x0022);          //
}

/**
 *******************************************************************************
 * @brief       ILI9328 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_9328(void)
{
    LCD_WriteReg(0x00EC,0x108F);// internal timeing
    LCD_WriteReg(0x00EF,0x1234);// ADD
    //LCD_WriteReg(0x00e7,0x0010);
    //LCD_WriteReg(0x0000,0x0001);//Turn on internal clock
    LCD_WriteReg(0x0001,0x0000);
    //LCD_WriteReg(0x0001,0x0100);
    LCD_WriteReg(0x0002,0x0700);//Power on
    //LCD_WriteReg(0x0003,(1<<3)|(1<<4) ); 	//65K  RGB
    //DRIVE TABLE(寄存器 03H)
    //BIT3=AM BIT4:5=ID0:1
    //AM ID0 ID1   FUNCATION
    // 0  0   0    R->L D->U
    // 1  0   0    D->U R->L
    // 0  1   0    L->R D->U
    // 1  1   0    D->U L->R
    // 0  0   1    R->L U->D
    // 1  0   1    U->D R->L
    // 0  1   1    L->R U->D Use this normally.
    // 1  1   1    U->D L->R
    LCD_WriteReg(0x0003,(1<<12)|(3<<4)|(0<<3) );//65K
    LCD_WriteReg(0x0004,0x0000);
    LCD_WriteReg(0x0008,0x0202);
    LCD_WriteReg(0x0009,0x0000);
    LCD_WriteReg(0x000a,0x0000);//display setting
    LCD_WriteReg(0x000c,0x0001);//display setting
    LCD_WriteReg(0x000d,0x0000);//0f3c
    LCD_WriteReg(0x000f,0x0000);
    //Power configuration
    LCD_WriteReg(0x0010,0x0000);
    LCD_WriteReg(0x0011,0x0007);
    LCD_WriteReg(0x0012,0x0000);
    LCD_WriteReg(0x0013,0x0000);
    LCD_WriteReg(0x0007,0x0001);
    MID_Delay(50); 
    LCD_WriteReg(0x0010,0x1490);
    LCD_WriteReg(0x0011,0x0227);
    MID_Delay(50); 
    LCD_WriteReg(0x0012,0x008A);
    MID_Delay(50); 
    LCD_WriteReg(0x0013,0x1a00);
    LCD_WriteReg(0x0029,0x0006);
    LCD_WriteReg(0x002b,0x000d);
    MID_Delay(50); 
    LCD_WriteReg(0x0020,0x0000);
    LCD_WriteReg(0x0021,0x0000);
    MID_Delay(50); 
    //Gamma correction
    LCD_WriteReg(0x0030,0x0000);
    LCD_WriteReg(0x0031,0x0604);
    LCD_WriteReg(0x0032,0x0305);
    LCD_WriteReg(0x0035,0x0000);
    LCD_WriteReg(0x0036,0x0C09);
    LCD_WriteReg(0x0037,0x0204);
    LCD_WriteReg(0x0038,0x0301);
    LCD_WriteReg(0x0039,0x0707);
    LCD_WriteReg(0x003c,0x0000);
    LCD_WriteReg(0x003d,0x0a0a);
    MID_Delay(50); 
    LCD_WriteReg(0x0050,0x0000); //Horizontal GRAM start position
    LCD_WriteReg(0x0051,0x00ef); //Horizontal GRAM end position
    LCD_WriteReg(0x0052,0x0000); //Vertical GRAM start position
    LCD_WriteReg(0x0053,0x013f); //Vertical GRAM end position

    LCD_WriteReg(0x0060,0x2700);
    //LCD_WriteReg(0x0060,0xA700);
    LCD_WriteReg(0x0061,0x0001); 
    LCD_WriteReg(0x006a,0x0000);
    LCD_WriteReg(0x0080,0x0000);
    LCD_WriteReg(0x0081,0x0000);
    LCD_WriteReg(0x0082,0x0000);
    LCD_WriteReg(0x0083,0x0000);
    LCD_WriteReg(0x0084,0x0000);
    LCD_WriteReg(0x0085,0x0000);

    LCD_WriteReg(0x0090,0x0010);
    LCD_WriteReg(0x0092,0x0600);
    //Turn on display settings    
    LCD_WriteReg(0x0007,0x0133);
}

/**
 *******************************************************************************
 * @brief       ILI9331 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_9331(void)
{
    LCD_WriteReg(0x00E7, 0x1014);
    LCD_WriteReg(0x0001, 0x0100); // set SS and SM bit
    LCD_WriteReg(0x0002, 0x0200); // set 1 line inversion
    LCD_WriteReg(0x0003,(1<<12)|(3<<4)|(1<<3));//65K    
    //LCD_WriteReg(0x0003, 0x1030); // set GRAM write direction and BGR=1.
    LCD_WriteReg(0x0008, 0x0202); // set the back porch and front porch
    LCD_WriteReg(0x0009, 0x0000); // set non-display area refresh cycle ISC[3:0]
    LCD_WriteReg(0x000A, 0x0000); // FMARK function
    LCD_WriteReg(0x000C, 0x0000); // RGB interface setting
    LCD_WriteReg(0x000D, 0x0000); // Frame marker Position
    LCD_WriteReg(0x000F, 0x0000); // RGB interface polarity
    //*************Power On sequence ****************//
    LCD_WriteReg(0x0010, 0x0000); // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0007); // DC1[2:0], DC0[2:0], VC[2:0]
    LCD_WriteReg(0x0012, 0x0000); // VREG1OUT voltage
    LCD_WriteReg(0x0013, 0x0000); // VDV[4:0] for VCOM amplitude
    MID_Delay(200); // Dis-charge capacitor power voltage
    LCD_WriteReg(0x0010, 0x1690); // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0227); // DC1[2:0], DC0[2:0], VC[2:0]
    MID_Delay(50); // Delay 50ms
    LCD_WriteReg(0x0012, 0x000C); // Internal reference voltage= Vci;
    MID_Delay(50); // Delay 50ms
    LCD_WriteReg(0x0013, 0x0800); // Set VDV[4:0] for VCOM amplitude
    LCD_WriteReg(0x0029, 0x0011); // Set VCM[5:0] for VCOMH
    LCD_WriteReg(0x002B, 0x000B); // Set Frame Rate
    MID_Delay(50); // Delay 50ms
    LCD_WriteReg(0x0020, 0x0000); // GRAM horizontal Address
    LCD_WriteReg(0x0021, 0x013f); // GRAM Vertical Address
    // ----------- Adjust the Gamma Curve ----------//
    LCD_WriteReg(0x0030, 0x0000);
    LCD_WriteReg(0x0031, 0x0106);
    LCD_WriteReg(0x0032, 0x0000);
    LCD_WriteReg(0x0035, 0x0204);
    LCD_WriteReg(0x0036, 0x160A);
    LCD_WriteReg(0x0037, 0x0707);
    LCD_WriteReg(0x0038, 0x0106);
    LCD_WriteReg(0x0039, 0x0707);
    LCD_WriteReg(0x003C, 0x0402);
    LCD_WriteReg(0x003D, 0x0C0F);
    //------------------ Set GRAM area ---------------//
    LCD_WriteReg(0x0050, 0x0000); // Horizontal GRAM Start Address
    LCD_WriteReg(0x0051, 0x00EF); // Horizontal GRAM End Address
    LCD_WriteReg(0x0052, 0x0000); // Vertical GRAM Start Address
    LCD_WriteReg(0x0053, 0x013F); // Vertical GRAM Start Address
    LCD_WriteReg(0x0060, 0x2700); // Gate Scan Line
    LCD_WriteReg(0x0061, 0x0001); // NDL,VLE, REV 
    LCD_WriteReg(0x006A, 0x0000); // set scrolling line
    //-------------- Partial Display Control ---------//
    LCD_WriteReg(0x0080, 0x0000);
    LCD_WriteReg(0x0081, 0x0000);
    LCD_WriteReg(0x0082, 0x0000);
    LCD_WriteReg(0x0083, 0x0000);
    LCD_WriteReg(0x0084, 0x0000);
    LCD_WriteReg(0x0085, 0x0000);
    //-------------- Panel Control -------------------//
    LCD_WriteReg(0x0090, 0x0010);
    LCD_WriteReg(0x0092, 0x0600);
    LCD_WriteReg(0x0007, 0x0133); // 262K color and display ON
}

/**
 *******************************************************************************
 * @brief       ILI9341 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_9341(void)
{
    LCD_WR_REG(0xCF);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xC1);
    LCD_WR_DATAX(0X30);

    LCD_WR_REG(0xED);
    LCD_WR_DATAX(0x64);
    LCD_WR_DATAX(0x03);
    LCD_WR_DATAX(0X12);
    LCD_WR_DATAX(0X81);

    LCD_WR_REG(0xE8);
    LCD_WR_DATAX(0x85);
    LCD_WR_DATAX(0x10);
    LCD_WR_DATAX(0x7A);

    LCD_WR_REG(0xCB);
    LCD_WR_DATAX(0x39);
    LCD_WR_DATAX(0x2C);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x34);
    LCD_WR_DATAX(0x02);

    LCD_WR_REG(0xF7);
    LCD_WR_DATAX(0x20);

    LCD_WR_REG(0xEA);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0xC0);           //Power control
    LCD_WR_DATAX(0x1B);         //VRH[5:0]

    LCD_WR_REG(0xC1);           //Power control
    LCD_WR_DATAX(0x01);         //SAP[2:0];BT[3:0]

    LCD_WR_REG(0xC5);           //VCM control
    LCD_WR_DATAX(0x30);         //3F
    LCD_WR_DATAX(0x30);         //3C

    LCD_WR_REG(0xC7);           //VCM control2
    LCD_WR_DATAX(0XB7);

    LCD_WR_REG(0x36);           // Memory Access Control
    LCD_WR_DATAX(0x48);

    LCD_WR_REG(0x3A);
    LCD_WR_DATAX(0x55);

    LCD_WR_REG(0xB1);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x1A);

    if((EMB->CR1.W & EMB_CR1_MAD_SWAP_enable_w) == 0)
    {
        LCD_WR_REG(0xB6);       // Display Function Control
        LCD_WR_DATAX(0x0A);
        LCD_WR_DATAX(0xA2);
    }
    else
    {
        LCD_WR_REG(0xB6);       // Display Function Control
        LCD_WR_DATAX(0x0A);
        LCD_WR_DATAX(0xC2);
    }
    LCD_WR_REG(0xF2);           // 3Gamma Function Disable
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0x26);           //Gamma curve selected
    LCD_WR_DATAX(0x01);

    LCD_WR_REG(0xE0);           //Set Gamma
    LCD_WR_DATAX(0x0F);
    LCD_WR_DATAX(0x2A);
    LCD_WR_DATAX(0x28);
    LCD_WR_DATAX(0x08);
    LCD_WR_DATAX(0x0E);
    LCD_WR_DATAX(0x08);
    LCD_WR_DATAX(0x54);
    LCD_WR_DATAX(0XA9);
    LCD_WR_DATAX(0x43);
    LCD_WR_DATAX(0x0A);
    LCD_WR_DATAX(0x0F);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);

    LCD_WR_REG(0XE1);           //Set Gamma
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x15);
    LCD_WR_DATAX(0x17);
    LCD_WR_DATAX(0x07);
    LCD_WR_DATAX(0x11);
    LCD_WR_DATAX(0x06);
    LCD_WR_DATAX(0x2B);
    LCD_WR_DATAX(0x56);
    LCD_WR_DATAX(0x3C);
    LCD_WR_DATAX(0x05);
    LCD_WR_DATAX(0x10);
    LCD_WR_DATAX(0x0F);
    LCD_WR_DATAX(0x3F);
    LCD_WR_DATAX(0x3F);
    LCD_WR_DATAX(0x0F);

    LCD_WR_REG(0x2B);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x01);
    LCD_WR_DATAX(0x3f);

    LCD_WR_REG(0x2A); 
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0x00);
    LCD_WR_DATAX(0xef);

    LCD_WR_REG(0x11);           //Exit Sleep
    MID_Delay(120);
    LCD_WR_REG(0x29);           //display on
}

/**
 *******************************************************************************
 * @brief       B505 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_B505(void)
{
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    
    LCD_WriteReg(0x00a4,0x0001);
    MID_Delay(20);
    LCD_WriteReg(0x0060,0x2700);
    LCD_WriteReg(0x0008,0x0202);
    
    LCD_WriteReg(0x0030,0x0214);
    LCD_WriteReg(0x0031,0x3715);
    LCD_WriteReg(0x0032,0x0604);
    LCD_WriteReg(0x0033,0x0e16);
    LCD_WriteReg(0x0034,0x2211);
    LCD_WriteReg(0x0035,0x1500);
    LCD_WriteReg(0x0036,0x8507);
    LCD_WriteReg(0x0037,0x1407);
    LCD_WriteReg(0x0038,0x1403);
    LCD_WriteReg(0x0039,0x0020);
    
    LCD_WriteReg(0x0090,0x001a);
    LCD_WriteReg(0x0010,0x0000);
    LCD_WriteReg(0x0011,0x0007);
    LCD_WriteReg(0x0012,0x0000);
    LCD_WriteReg(0x0013,0x0000);
    MID_Delay(20);
    
    LCD_WriteReg(0x0010,0x0730);
    LCD_WriteReg(0x0011,0x0137);
    MID_Delay(20);
    
    LCD_WriteReg(0x0012,0x01b8);
    MID_Delay(20);
    
    LCD_WriteReg(0x0013,0x0f00);
    LCD_WriteReg(0x002a,0x0080);
    LCD_WriteReg(0x0029,0x0048);
    MID_Delay(20);
    
    LCD_WriteReg(0x0001,0x0100);
    LCD_WriteReg(0x0002,0x0700);
    LCD_WriteReg(0x0003,0x1038);//Scan direction from Top to bottom, left to right.
    LCD_WriteReg(0x0008,0x0202);
    LCD_WriteReg(0x000a,0x0000);
    LCD_WriteReg(0x000c,0x0000);
    LCD_WriteReg(0x000d,0x0000);
    LCD_WriteReg(0x000e,0x0030);
    LCD_WriteReg(0x0050,0x0000);
    LCD_WriteReg(0x0051,0x00ef);
    LCD_WriteReg(0x0052,0x0000);
    LCD_WriteReg(0x0053,0x013f);
    LCD_WriteReg(0x0060,0x2700);
    LCD_WriteReg(0x0061,0x0001);
    LCD_WriteReg(0x006a,0x0000);
    //LCD_WriteReg(0x0080,0x0000);
    //LCD_WriteReg(0x0081,0x0000);
    LCD_WriteReg(0x0090,0X0011);
    LCD_WriteReg(0x0092,0x0600);
    LCD_WriteReg(0x0093,0x0402);
    LCD_WriteReg(0x0094,0x0002);
    MID_Delay(20);
    
    LCD_WriteReg(0x0007,0x0001);
    MID_Delay(20);
    LCD_WriteReg(0x0007,0x0061);
    LCD_WriteReg(0x0007,0x0173);
    
    LCD_WriteReg(0x0020,0x0000);
    LCD_WriteReg(0x0021,0x0000);
    LCD_WriteReg(0x00,0x22);
}

/**
 *******************************************************************************
 * @brief       C505 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_C505(void)
{
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    MID_Delay(20);
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
    LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x00a4,0x0001);
    MID_Delay(20);
    LCD_WriteReg(0x0060,0x2700);
    LCD_WriteReg(0x0008,0x0806);
    
    LCD_WriteReg(0x0030,0x0703);//gamma setting
    LCD_WriteReg(0x0031,0x0001);
    LCD_WriteReg(0x0032,0x0004);
    LCD_WriteReg(0x0033,0x0102);
    LCD_WriteReg(0x0034,0x0300);
    LCD_WriteReg(0x0035,0x0103);
    LCD_WriteReg(0x0036,0x001F);
    LCD_WriteReg(0x0037,0x0703);
    LCD_WriteReg(0x0038,0x0001);
    LCD_WriteReg(0x0039,0x0004);
    
    LCD_WriteReg(0x0090, 0x0015);   //80Hz
    LCD_WriteReg(0x0010, 0X0410);   //BT,AP
    LCD_WriteReg(0x0011,0x0247);    //DC1,DC0,VC
    LCD_WriteReg(0x0012, 0x01BC);
    LCD_WriteReg(0x0013, 0x0e00);
    MID_Delay(120);
    LCD_WriteReg(0x0001, 0x0100);
    LCD_WriteReg(0x0002, 0x0200);
    LCD_WriteReg(0x0003, 0x1030);
    
    LCD_WriteReg(0x000A, 0x0008);
    LCD_WriteReg(0x000C, 0x0000);
    
    LCD_WriteReg(0x000E, 0x0020);
    LCD_WriteReg(0x000F, 0x0000);
    LCD_WriteReg(0x0020, 0x0000);   //H Start
    LCD_WriteReg(0x0021, 0x0000);   //V Start
    LCD_WriteReg(0x002A,0x003D);    //vcom2
    MID_Delay(20);
    LCD_WriteReg(0x0029, 0x002d);
    LCD_WriteReg(0x0050, 0x0000);
    LCD_WriteReg(0x0051, 0xD0EF);
    LCD_WriteReg(0x0052, 0x0000);
    LCD_WriteReg(0x0053, 0x013F);
    LCD_WriteReg(0x0061, 0x0000);
    LCD_WriteReg(0x006A, 0x0000);
    LCD_WriteReg(0x0092,0x0300); 

    LCD_WriteReg(0x0093, 0x0005);
    LCD_WriteReg(0x0007, 0x0100);
}

/**
 *******************************************************************************
 * @brief       8989 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_8989(void)
{
    LCD_WriteReg(0x0000,0x0001); // Turn on the crystal oscillator
    LCD_WriteReg(0x0003,0xA8A4); // 0xA8A4
    LCD_WriteReg(0x000C,0x0000);    
    LCD_WriteReg(0x000D,0x080C);   
    LCD_WriteReg(0x000E,0x2B00);    
    LCD_WriteReg(0x001E,0x00B0);    
    LCD_WriteReg(0x0001,0x2B3F); // output control 320*240  0x6B3F
    LCD_WriteReg(0x0002,0x0600);
    LCD_WriteReg(0x0010,0x0000);  
    LCD_WriteReg(0x0011,0x6078); // define Color fromat 16bits(565) Horizontal screen 0x6058
    LCD_WriteReg(0x0005,0x0000);  
    LCD_WriteReg(0x0006,0x0000);  
    LCD_WriteReg(0x0016,0xEF1C);  
    LCD_WriteReg(0x0017,0x0003);  
    LCD_WriteReg(0x0007,0x0233); // 0x0233
    LCD_WriteReg(0x000B,0x0000);  
    LCD_WriteReg(0x000F,0x0000); // Scan start address
    LCD_WriteReg(0x0041,0x0000);  
    LCD_WriteReg(0x0042,0x0000);  
    LCD_WriteReg(0x0048,0x0000);  
    LCD_WriteReg(0x0049,0x013F);  
    LCD_WriteReg(0x004A,0x0000);  
    LCD_WriteReg(0x004B,0x0000);  
    LCD_WriteReg(0x0044,0xEF00);  
    LCD_WriteReg(0x0045,0x0000);  
    LCD_WriteReg(0x0046,0x013F);  
    LCD_WriteReg(0x0030,0x0707);  
    LCD_WriteReg(0x0031,0x0204);  
    LCD_WriteReg(0x0032,0x0204);  
    LCD_WriteReg(0x0033,0x0502);  
    LCD_WriteReg(0x0034,0x0507);  
    LCD_WriteReg(0x0035,0x0204);  
    LCD_WriteReg(0x0036,0x0204);  
    LCD_WriteReg(0x0037,0x0502);  
    LCD_WriteReg(0x003A,0x0302);  
    LCD_WriteReg(0x003B,0x0302);  
    LCD_WriteReg(0x0023,0x0000);  
    LCD_WriteReg(0x0024,0x0000);  
    LCD_WriteReg(0x0025,0x8000);  
    LCD_WriteReg(0x004f,0);        // Line start address 0
    LCD_WriteReg(0x004e,0);        // Column start address 0
}

/**
 *******************************************************************************
 * @brief       LGDP4531 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_4531(void)
{
    LCD_WriteReg(0X00,0X0001);
    MID_Delay(10);   
    LCD_WriteReg(0X10,0X1628);
    LCD_WriteReg(0X12,0X000e); // 0x0006
    LCD_WriteReg(0X13,0X0A39);
    MID_Delay(10);   
    LCD_WriteReg(0X11,0X0040);
    LCD_WriteReg(0X15,0X0050);
    MID_Delay(10);   
    LCD_WriteReg(0X12,0X001e); // 16
    MID_Delay(10);   
    LCD_WriteReg(0X10,0X1620);
    LCD_WriteReg(0X13,0X2A39);   
    MID_Delay(10);   
    LCD_WriteReg(0X01,0X0100);   
    LCD_WriteReg(0X02,0X0300);   
    LCD_WriteReg(0X03,0X1038); // Change direction
    LCD_WriteReg(0X08,0X0202);   
    LCD_WriteReg(0X0A,0X0008);   
    LCD_WriteReg(0X30,0X0000);   
    LCD_WriteReg(0X31,0X0402);   
    LCD_WriteReg(0X32,0X0106);   
    LCD_WriteReg(0X33,0X0503);   
    LCD_WriteReg(0X34,0X0104);   
    LCD_WriteReg(0X35,0X0301);   
    LCD_WriteReg(0X36,0X0707);   
    LCD_WriteReg(0X37,0X0305);   
    LCD_WriteReg(0X38,0X0208);   
    LCD_WriteReg(0X39,0X0F0B);   
    LCD_WriteReg(0X41,0X0002);   
    LCD_WriteReg(0X60,0X2700);   
    LCD_WriteReg(0X61,0X0001);   
    LCD_WriteReg(0X90,0X0210);   
    LCD_WriteReg(0X92,0X010A);   
    LCD_WriteReg(0X93,0X0004);   
    LCD_WriteReg(0XA0,0X0100);   
    LCD_WriteReg(0X07,0X0001);   
    LCD_WriteReg(0X07,0X0021);   
    LCD_WriteReg(0X07,0X0023);   
    LCD_WriteReg(0X07,0X0033);   
    LCD_WriteReg(0X07,0X0133);   
    LCD_WriteReg(0XA0,0X0000); 
}

/**
 *******************************************************************************
 * @brief       LGDP4535 Chip Inital.
 * @return      None
 *******************************************************************************
 */
void LCD_ChipInit_4535(void)
{
    LCD_WriteReg(0X15,0X0030);   
    LCD_WriteReg(0X9A,0X0010);   
    LCD_WriteReg(0X11,0X0020);   
    LCD_WriteReg(0X10,0X3428);   
    LCD_WriteReg(0X12,0X0002);//16    
    LCD_WriteReg(0X13,0X1038);   
    MID_Delay(40);   
    LCD_WriteReg(0X12,0X0012);//16    
    MID_Delay(40);   
    LCD_WriteReg(0X10,0X3420);   
    LCD_WriteReg(0X13,0X3038);   
    MID_Delay(70);   
    LCD_WriteReg(0X30,0X0000);   
    LCD_WriteReg(0X31,0X0402);   
    LCD_WriteReg(0X32,0X0307);   
    LCD_WriteReg(0X33,0X0304);   
    LCD_WriteReg(0X34,0X0004);   
    LCD_WriteReg(0X35,0X0401);   
    LCD_WriteReg(0X36,0X0707);   
    LCD_WriteReg(0X37,0X0305);   
    LCD_WriteReg(0X38,0X0610);   
    LCD_WriteReg(0X39,0X0610); 
    
    LCD_WriteReg(0X01,0X0100);   
    LCD_WriteReg(0X02,0X0300);   
    LCD_WriteReg(0X03,0X1030); // Change direction
    LCD_WriteReg(0X08,0X0808);   
    LCD_WriteReg(0X0A,0X0008);   
    LCD_WriteReg(0X60,0X2700);   
    LCD_WriteReg(0X61,0X0001);   
    LCD_WriteReg(0X90,0X013E);   
    LCD_WriteReg(0X92,0X0100);   
    LCD_WriteReg(0X93,0X0100);   
    LCD_WriteReg(0XA0,0X3000);   
    LCD_WriteReg(0XA3,0X0010);   
    LCD_WriteReg(0X07,0X0001);   
    LCD_WriteReg(0X07,0X0021);   
    LCD_WriteReg(0X07,0X0023);   
    LCD_WriteReg(0X07,0X0033);   
    LCD_WriteReg(0X07,0X0133);   
}


/**
 *******************************************************************************
 * @brief       LCD Module Initial
 * @return      None
 *******************************************************************************
 */
void LCD_Init(void)
{
    uint16_t lTemp16;

    lcddev.id = 0x0000;
    __LCD_RESET_low();
    MID_Delay(2);       // delay 2 ms
    __LCD_RESET_high();
    MID_Delay(50);      // delay 50 ms

//    MID_Delay(50); // delay 50 ms
//    LCD_WriteReg(0x0000, 0x0001);
//    LCD_WriteReg(0x0001,0x0001);
//    MID_Delay(50); // delay 50 ms

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9320))
//    {
//        lcddev.id = 0x9320;
//    }

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x04C9))
//    {
//        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
//        lcddev.id = 0x9320;
//    }

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9325))
//    {
//        lcddev.id = 0x9325;
//    }

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0xA4C9))
//    {
//        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
//        lcddev.id = 0x9325;
//    }

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9328))
//    {
//        lcddev.id = 0x9328;
//    }

//    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x14C9))
//    {
//        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
//        lcddev.id = 0x9328;
//    }

//    if(lcddev.id == 0)
//    {
//        LCD_WR_REG(0xD3); // Select Register  
//        LCD_RD_DATA();              //dummy read 
//        LCD_RD_DATA();              //Read 0x00
//        if(LCD_RD_DATA() == 0x4141)
//            lcddev.id = 0x9341;
//    }

    if(lcddev.id == 0)
    {
        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
        LCD_WR_REG(0xD3); // Select Register  
        lTemp16 = LCD_RD_DATA();      //dummy read 
        lTemp16 = LCD_RD_DATA();      //Read 0x00
        lTemp16 = (uint16_t)(LCD_RD_DATA() << 8);
        lTemp16 |= LCD_RD_DATA();
        if(lTemp16 == 0x9341)
            lcddev.id = 0x9341;
//        else
//            EMB->CR1.W &= ~EMB_CR1_MAD_SWAP_mask_w;
    }

//    if(lcddev.id == 0)
//    {
//        LCD_WR_REG(0XDA00);
//        LCD_RD_DATA();        // read 0X00
//        LCD_WR_REG(0XDB00);
//        lcddev.id=LCD_RD_DATA();// read 0X80
//        lcddev.id<<=8;
//        LCD_WR_REG(0XDC00);
//        lcddev.id|=LCD_RD_DATA();// read 0X00
//        if(lcddev.id==0x8000)
//          lcddev.id=0x5510;//NT35510 read ID is 8000H
//    }

//  lcddev.id = LCD_ReadReg(0x0000);
//  if(lcddev.id<0XFF||lcddev.id==0XFFFF||lcddev.id==0X9300)
//  {
//        __LCD_CS_CLR(); 
//        __LCD_RS_CLR(); // Select Register  
//        __DATAOUT(0xD3); 
//        __LCD_WR_CLR(); 
//        __LCD_WR_SET(); 
//        __LCD_CS_SET();        

//        lcddev.id=LCD_RD_DATA();                // dummy read
//        lcddev.id=LCD_RD_DATA();                // Read 0x00

//        lcddev.id=LCD_RD_DATA();                // read 0x93
//        lcddev.id<<=8;
//        lcddev.id|=LCD_RD_DATA();               // read 0x41
//        if(lcddev.id == 0x4141)
//            lcddev.id = 0x9341; 
//
//            if(lcddev.id!=0X9341)               // not 0x9341, Try run 6804
//            {
//                LCD_WR_REG(0XBF);
//                LCD_RD_DATA();                  // dummy read
//                LCD_RD_DATA();                  // read 0X01
//                LCD_RD_DATA();                  // read 0XD0
//                lcddev.id=LCD_RD_DATA();        // read 0X68 
//                lcddev.id<<=8;
//                lcddev.id|=LCD_RD_DATA();       // read 0X04

//                if(lcddev.id! = 0X6804)         // not 6804, Try run NT35310
//                {
//                    LCD_WR_REG(0XD4);
//                    LCD_RD_DATA();              // dummy read
//                    LCD_RD_DATA();              // read 0X01
//                    lcddev.id=LCD_RD_DATA();    // read 0X53
//                    lcddev.id<<=8;
//                    lcddev.id|=LCD_RD_DATA();   // read 0X10

//                    if(lcddev.id!=0X5310)       // not NT35310, Try run NT35510
//                    {
//                        LCD_WR_REG(0XDA00);
//                        LCD_RD_DATA();          // read 0X00
//                        LCD_WR_REG(0XDB00);
//                        lcddev.id=LCD_RD_DATA();// read 0X80
//                        lcddev.id<<=8;
//                        LCD_WR_REG(0XDC00);
//                        lcddev.id|=LCD_RD_DATA();// read 0X00

//                        if(lcddev.id==0x8000)
//                              lcddev.id=0x5510;//NT35510 read ID is 0x8000H.
//                    }
//                }
//            }
//        }

    //EMB->CLK.W = (7 << EMB_CLK_CK_PSC_shift_w);

    //printf("  LCD ID:%x\r\n",lcddev.id); //打印LCD ID  

//    if(lcddev.id==0x5510)
//    {
//        LCD_ChipInit_5510();
//    }else if(lcddev.id==0x9320)// Test OK.
//    {
//        LCD_ChipInit_9320();
//    }else if(lcddev.id==0x9325)//9325
//    {
//        LCD_ChipInit_9325();
//    }else if(lcddev.id==0x9328)//ILI9328   OK
//    {
//        LCD_ChipInit_9328();
//    }else if(lcddev.id==0X9331)//OK |/|/|
//    {
//        LCD_ChipInit_9331();
//    }else if(lcddev.id==0X9341) //9341 Initial
//    {
        LCD_ChipInit_9341();
//    }
    LCD_Display_Dir(0);     // default Vertical screen.
    __LCD_BACKLIGHT_on();   // Backlight ON

    LCD_Clear(BLACK);
}


/**
 *******************************************************************************
 * @brief       Clear and Color fill
 * @param       color : fill Color
 * @return      None
 *******************************************************************************
 */
void LCD_Clear(uint16_t color)
{
    uint32_t index=0;
    uint32_t totalpoint;

    __LCD_BACKLIGHT_off();              // Backlight OFF

    totalpoint = lcddev.width;
    totalpoint *= lcddev.height;
    if((lcddev.id==0X6804)&&(lcddev.dir==1)) // for 6804 Horizontal screen 
    {
        lcddev.dir=0;
        lcddev.setxcmd = 0X2A;
        lcddev.setycmd = 0X2B;
        LCD_SetCursor(0x00,0x0000);     // Set Cursor
        lcddev.dir=1;
        lcddev.setxcmd = 0X2B;
        lcddev.setycmd = 0X2A;
    }else LCD_SetCursor(0x00,0x0000);   // Set Cursor
    LCD_WriteRAM_Prepare();             // Select to GRAM Space

    __LCD_CS_CLR();
    __LCD_RS_SET();
    for(index = 0; index < totalpoint; index++)
    {
        __DATAOUT(color);
        __LCD_WR_CLR();
        __LCD_WR_SET();
    }
    __LCD_CS_SET();
    __LCD_BACKLIGHT_on();               // Backlight ON
}

/**
 *******************************************************************************
 * @brief       Color Bar
 * @return      None
 *******************************************************************************
 */
void LCD_ColorBar_1(void)
{
    uint16_t ColorBar_1[] = {0xFFFF, 0x001F, 0xF800, 0xF81F, 0x07E0, 0x07FF, 0xFFE0, 0x0000,};
    uint16_t i, j, lColorTemp, lColorCount;  
    uint32_t totalpoint;

//  __LCD_BACKLIGHT_off();                  // Backlight OFF

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;
    if((lcddev.id==0X6804)&&(lcddev.dir==1))
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);         // Set Cursor
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);       // Set Cursor
    LCD_WriteRAM_Prepare();                 // Select to GRAM Space
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

    lColorCount = 0;

    __LCD_CS_CLR();\
    __LCD_RS_SET();\
    do{
        lColorTemp = ColorBar_1[lColorCount];
        i = (uint16_t)(lcddev.height / 8);
        do{
            j = lcddev.width;
            do{
                __DATAOUT(lColorTemp);
                __LCD_WR_CLR();
                __LCD_WR_SET();
            }while(-- j != 0);
        }while(-- i != 0);
    }while(++ lColorCount != 0x0008);
    __LCD_CS_SET();\
//  __LCD_BACKLIGHT_on();              // Backlight ON
}



/**
 *******************************************************************************
 * @brief       Color Bar 2
 * @return      None
 *******************************************************************************
 */
void LCD_ColorBar_2(void)
{
    float lColorInt = 0;
    float lColorScreen;
//  uint32_t index=0;      
    uint32_t totalpoint;
    uint16_t i, j, lColorTemp;

//  __LCD_BACKLIGHT_off();                  // Backlight OFF

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;
    if((lcddev.id==0X6804)&&(lcddev.dir==1))
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);         // Set Cursor
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);       // Set Cursor
    LCD_WriteRAM_Prepare();                 // Select to GRAM Space
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

//    lColorCount = 0;

    __LCD_CS_CLR();\
    __LCD_RS_SET();\

//    lColorTemp = 0xF800;
//    j = lcddev.width;
//    do{
//            __DATAOUT(lColorTemp);
//            __LCD_WR_CLR();
//            __LCD_WR_SET();
//    }while(-- j != 0);

    // B = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0xF800;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0xF800 + (uint16_t)lColorInt;
    }while(-- i != 0);

    // R = 255 ~ 0;
    lColorInt = 0;
    lColorTemp = 0xF81F;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0xF81F - ((uint16_t)(((uint16_t)lColorInt) << 11));
    }while(-- i != 0);

    // G = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 64 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x001F;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0x001FU + ((uint16_t)(((uint16_t)lColorInt) << 5));
    }while(-- i != 0);

    // B = 255 ~ 0;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x7FF;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0x7FF - ((uint16_t)lColorInt);
    }while(-- i != 0);

    // R = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x07E0;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = ((uint16_t)0x07E0U) + ((uint16_t)(((uint16_t)lColorInt) << 11));
    }while(-- i != 0);

    // B = 255 ~ 0;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 64 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0xFFE0;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = (uint16_t)(0xFFE0U - ((uint16_t)(((uint16_t)lColorInt) << 5U)));
    }while(-- i != 0);

//    lColorTemp = 0xF800;
//    j = lcddev.width;
//    do{
//            __DATAOUT(lColorTemp);
//            __LCD_WR_CLR();
//            __LCD_WR_SET();
//    }while(-- j != 0);

    __LCD_CS_SET();\
//  __LCD_BACKLIGHT_on();               // Backlight ON
}

/**
 *******************************************************************************
 * @brief       Show Gray Bar
 * @return      None
 *******************************************************************************
 */
void LCD_GrayBar_1(void)
{
    uint16_t GrayBar_1[] = {0xFFFF, 0xEF7D, 0xDEFB, 0xCE79, 0xBDF7, 0xAD75, 0x9CF3, 0x8C71,
                            0x7BEF, 0x6B6D, 0x5AEB, 0x4A69, 0x39E7, 0x2965, 0x18E3, 0x0000};
    uint32_t totalpoint;
    uint16_t i, j, lColorTemp, lColorCount;

//  __LCD_BACKLIGHT_off();                      // Backlight OFF

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;
    if((lcddev.id==0X6804)&&(lcddev.dir==1))
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);             // Set Cursor
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);           // Set Cursor
    LCD_WriteRAM_Prepare();                     // Select to GRAM Space
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

    lColorCount = 0;

    __LCD_CS_CLR();
    __LCD_RS_SET();
    do{
        lColorTemp = GrayBar_1[lColorCount];
        i = (uint16_t)(lcddev.height / 16);
        do{
            j = lcddev.width;
            do{
                __DATAOUT(lColorTemp);
                __LCD_WR_CLR();
                __LCD_WR_SET();
            }while(-- j != 0);
        }while(-- i != 0);
    }while(++ lColorCount != 0x0010);
    __LCD_CS_SET();
//    __LCD_BACKLIGHT_on();               // Backlight ON
}



/**
 *******************************************************************************
 * @brief       Fill the specified area with the specified color
 * @param       sx : Start X-axes
 * @param       sy : Start Y-axes
 * @param       ex : end X-axes
 * @param       ey : end Y-axes
 * @param       color : Fill color
 * @return      None
 * @note        Area size (xend-xsta+1)*(yend-ysta+1)
 *******************************************************************************
 */
void LCD_Fill(uint16_t sx,uint16_t sy,uint16_t ex,uint16_t ey,uint16_t color)
{          
    uint16_t i,j;
    uint16_t xlen=0;
    uint16_t temp;
    if((lcddev.id==0X6804)&&(lcddev.dir==1))
    {
        temp=sx;
        sx=sy;
        sy=lcddev.width-ex-1;
        ex=ey;
        ey=lcddev.width-temp-1;
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_Fill(sx,sy,ex,ey,color);
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else
    {
        xlen=ex-sx+1;
        for(i=sy;i<=ey;i++)
        {
            LCD_SetCursor(sx,i);
            LCD_WriteRAM_Prepare();
            for(j=0;j<xlen;j++) LCD_WR_DATA(color);
        }
    }
}

/**
 *******************************************************************************
 * @brief       Rectangle Fill Color
 * @param       sx : Start X-axes
 * @param       sy : Start Y-axes
 * @param       ex : end X-axes
 * @param       ey : end Y-axes
 * @param       color : Fill Color
 * @return      None
 * @note        Area size (ex-sx+1)*(ey-sy+1)
 *******************************************************************************
 */
void LCD_Color_Fill(uint16_t sx, uint16_t sy, uint16_t ex, uint16_t ey, const uint8_t *color)
{
    uint16_t height, width;
    uint16_t i, j;
    uint16_t lColor, lpColorIndex;

    width  = ex - sx + 1;            // Wigth
    height = ey - sy + 1;            // height
    for(i = 0; i < height; i ++)
    {
        LCD_SetCursor(sx, sy + i);
        LCD_WriteRAM_Prepare();

        for(j = 0; j < width; j ++)
        {
            lpColorIndex = (((i * width) + j) * 2);
            lColor = (uint16_t)(color[lpColorIndex + 1] << 8);
            lColor |= color[lpColorIndex];
            LCD_WR_DATA(lColor);
        }
    }
}


/**
 *******************************************************************************
 * @brief       Draw Line
 * @param       x1 : Start X-axes
 * @param       y1 : Start Y-axes
 * @param       x2 : end X-axes
 * @param       y2 : end Y-axes
 * @param       Color : Line Color
 * @return      None
 * @note        Area size (ex-sx+1)*(ey-sy+1)
 *******************************************************************************
 */
void LCD_DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color)
{
    uint16_t t; 
    int xerr = 0, yerr = 0, delta_x, delta_y, distance; 
    int incx, incy, uRow, uCol; 

    delta_x = x2 - x1; // Coordinate increment 
    delta_y = y2 - y1; 
    uRow = x1; 
    uCol = y1; 

    if(delta_x > 0) incx = 1; // Set single step direction 
    else if(delta_x == 0) incx = 0; // Vertical line
    else {incx = -1; delta_x = -delta_x;} 

    if(delta_y > 0) incy = 1; 
    else if(delta_y == 0) incy = 0;// Horizontal line
    else{incy = -1; delta_y = -delta_y;} 

    if(delta_x > delta_y) distance = delta_x; // Select basic incremental axis
    else distance = delta_y; 

    for(t = 0; t <= distance + 1; t ++ ) // Line drawing output
    {  
        LCD_DrawPoint((uint16_t)uRow, (uint16_t)uCol, Color); // Draw a point
        xerr += delta_x ; 
        yerr += delta_y ; 
        if(xerr > distance)
        { 
            xerr -= distance; 
            uRow += incx; 
        } 
        if(yerr > distance) 
        { 
            yerr -= distance; 
            uCol += incy; 
        } 
    }  
}

/**
 *******************************************************************************
 * @brief       Draw Rectangle
 * @param       x1 : Start X-axes
 * @param       y1 : Start Y-axes
 * @param       x2 : end X-axes
 * @param       y2 : end Y-axes
 * @param       Color : Rectangle Color
 * @return      None
 * @note        (sx,sy),(ex,ey): coordinates
 *******************************************************************************
 */
void LCD_DrawRectangle(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color)
{
    LCD_DrawLine(x1, y1, x2, y1, Color);
    LCD_DrawLine(x1, y1, x1, y2, Color);
    LCD_DrawLine(x1, y2, x2, y2, Color);
    LCD_DrawLine(x2, y1, x2, y2, Color);
}

/**
 *******************************************************************************
 * @brief       Draw Circle
 * @param       x0 : Center of circle X-axes
 * @param       y0 : Center of circle Y-axes
 * @param       r : Radius
 * @param       Color : Circle Color
 * @return      None
 * @note        (x0, y0) : Center
 *******************************************************************************
 */
void LCD_Draw_Circle(uint16_t x0, uint16_t y0, uint16_t r, uint16_t Color)
{
    int a, b;
    int di;
    a = 0; b = r;
    di = 3 - (r << 1);
    while(a <= b)
    {
        LCD_DrawPoint((uint16_t)(x0 - b), (uint16_t)(y0 - a), Color);             //3
        LCD_DrawPoint((uint16_t)(x0 + b), (uint16_t)(y0 - a), Color);             //0
        LCD_DrawPoint((uint16_t)(x0 - a), (uint16_t)(y0 + b), Color);             //1
        LCD_DrawPoint((uint16_t)(x0 - b), (uint16_t)(y0 - a), Color);             //7
        LCD_DrawPoint((uint16_t)(x0 - a), (uint16_t)(y0 - b), Color);             //2
        LCD_DrawPoint((uint16_t)(x0 + b), (uint16_t)(y0 + a), Color);             //4
        LCD_DrawPoint((uint16_t)(x0 + a), (uint16_t)(y0 - b), Color);             //5
        LCD_DrawPoint((uint16_t)(x0 + a), (uint16_t)(y0 + b), Color);             //6 
        LCD_DrawPoint((uint16_t)(x0 - b), (uint16_t)(y0 + a), Color);
        a++;
        // Use Bresenham algorithm to draw a circle
        if(di < 0)di += 4 * a + 6;
        else
        {
            di += 10 + 4 *(a - b);
            b --;
        } 
        LCD_DrawPoint((uint16_t)(x0 + a), (uint16_t)(y0 + b), Color);
    }
}

/**
 *******************************************************************************
 * @brief       m to the power of n.
 * @param       m : 
 * @param       n : 
 * @return      uint32_t m^n
 *******************************************************************************
 */
uint32_t LCD_Pow(uint8_t m, uint8_t n)
{
    uint32_t result = 1;
    while(n--)result *= m;
    return result;
}

/**
 *******************************************************************************
 * @brief       Print Number
 * @param       x : Start X-axes
 * @param       y : Start Y-axes
 * @param       num : Number value(0~4294967295)
 * @param       len : Number of digits
 * @param       size : Font size
 * @param       Color : Number Color
 * @return      None
 * @note        High is 0, no display.
 *******************************************************************************
 */
void LCD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint16_t Color)
{
    uint8_t t,temp;
    uint8_t enshow=0;
    for(t=0;t<len;t++)
    {
        temp=(num / LCD_Pow(10, len-t-1))%10;
        if(enshow == 0 && t < (len-1))
        {
            if(temp==0)
            {
                LCD_ShowChar(x + (size / 2) * t, y, ' ', size, 0, Color);
                continue;
            }else enshow=1; 
            
        }
        LCD_ShowChar(x + (size / 2) * t, y, temp + '0', size, 0, Color); 
    }
}


/**
 *******************************************************************************
 * @brief       Print Number
 * @param       x : Start X-axes
 * @param       y : Start Y-axes
 * @param       num : Number value(0~4294967295)
 * @param       len : Number of digits
 * @param       size : Font size
 * @param       mode : overlay
 *      @arg        bit7 is 0 Don't fill.
 *      @arg        bit7 is 1 Fill.
 *      @arg        bit0 is 0 No overlay.
 *      @arg        bit0 is 1 overlay.
 * @param       Color : Number Color
 * @return      None
 * @note        High is 0 display.
 *******************************************************************************
 */
void LCD_ShowxNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint8_t mode, uint16_t Color)
{
    uint8_t t, temp;
    uint8_t enshow = 0;
    for(t = 0 ; t < len ; t++)
    {
        temp = (num / LCD_Pow(10, len - t - 1)) % 10;
        if(enshow == 0 && t < (len - 1))
        {
            if(temp == 0)
            {
                if(mode & 0X80) LCD_ShowChar(x + (size / 2) * t, y, '0', size, mode & 0X01, Color);
                else LCD_ShowChar(x + (size / 2) * t, y, ' ', size, mode & 0X01, Color);
                continue;
            }else enshow = 1;
        }
        LCD_ShowChar(x + (size / 2) * t, y, temp + '0', size, mode & 0X01, Color); 
    }
}

/**
 *******************************************************************************
 * @brief       Print one char
 * @param       x : Start X-axes
 * @param       y : Start Y-axes
 * @param       num : ASCII Number " "--->"~"
 * @param       size : Font size
 * @param       mode
 *      @arg        0:No overlay
 *      @arg        1:overlay
 * @param       Color : Font Color
 * @return      None
 *******************************************************************************
 */
void LCD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint8_t mode, uint16_t Color)
{
    uint8_t temp, t1, t;
    uint16_t y0 = y;
    uint8_t csize=(size / 8 + ((size%8) ? 1 : 0))*(size / 2);

    num=num-' '; // Get offset value
    for(t = 0 ; t < csize ; t++)
    {   
        if(size == 12)temp = asc2_1206[num][t];         // use 1206 font
        else if(size == 16) temp = asc2_1608[num][t];   // use 1608 font
        else if(size == 24) temp = asc2_2412[num][t];   // use 2412 font
        else return;                                    // does not exist
        for(t1=0;t1<8;t1++)
        {
            if(temp&0x80)LCD_Fast_DrawPoint(x, y, Color);
            else if(mode==0)LCD_Fast_DrawPoint(x, y, BACK_COLOR);
            temp<<=1;
            y++;
            if(x>=lcddev.width)return;              // Over area
            if((y-y0)==size)
            {
                y=y0;
                x++;
                if(x>=lcddev.width)return;          // Over area
                break;
            }
        }
    }
}

/**
 *******************************************************************************
 * @brief       Print String
 * @param       x : Start X-axes
 * @param       y : Start Y-axes
 * @param       width : Displayable width range
 * @param       height : Displayable height range
 * @param       Color : String Color
 * @param       size : Font size
 * @param       Str : String start address
 * @return      None
 *******************************************************************************
 */
void LCD_ShowString(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint8_t size, uint8_t *Str)
{
    uint16_t x0 = x;
    width += x;
    height += y;
    while((*Str <= '~') && (*Str >= ' ')) // Confirm whether it is an illegal character.
    {
        if(x >= width){x = x0; y += size;}
        if(y >= height)break;
        LCD_ShowChar(x, y, *Str, size, 1, Color);
        x += size/2;
        Str ++;
    }
}



//int fputc(int ch, FILE* f)
//{
//    static uint16_t x = 0, y = 0; //
//    uint8_t string[32];          //
//    static uint8_t flag = 0;      //
//    static uint8_t tmp[2];       //

//    if(ch == '\n')   //換行
//    {
//        y += 16;
//        return ch;
//    }

//    if(ch == '\r')   //換行
//    {
//        x = 0;
//        return ch;
//    }

//    if(ch & 0x80)   //
//    {
//        if(flag == 0) //
//        {
//            flag= 1;    //
//            tmp[0] = ch; //
//            return ch;   //
//        }
//        else
//        {
//            flag= 0;
//            tmp[1] = ch;
//            if(x> lcddev.width - 16)  //
//            {
//                x = 0;          //
//                y += 16;        //
//            }
//            if(y> lcddev.height - 16)  //
//            {
//                return ch;       //
//            }
//            string = Get_Chinese(tmp);
//            LCD_Chinese_One(x, y, string, color);
//            x +=16;
//            return ch;
//        }
//    }
//    else
//    {
//        if(x > lcddev.width - 8) //
//        {
//            x =0;          //
//            y +=16;        //
//        }
//        if(y > lcddev.height - 16) //
//        {
//            return ch;       //
//        }
//        string = Get_Ascii(ch);  //
//        LCD_Ascii_One(x, y,string, color); //
//        x += 8;               //
//        return ch;
//    }
//}

//=============================================================================
/**
 *******************************************************************************
 * @brief       Random show string
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Text(void)
{   uint16_t lCount = 50;
    LCD_Clear(0xE71C);
    LCD_ShowString(0, 80, lcddev.width, 24, 0x001F, 24, (uint8_t *)"Megawin Company");
    LCD_ShowString(0, 104, lcddev.width, 24, 0x33E0, 24, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(0, 128, lcddev.width, 24, 0xF100, 24, (uint8_t *)"Product MG32F02A");
    MID_Delay(1000);
    do{
        LCD_ShowString((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), lcddev.width, 24, (uint16_t)(rand() % 0xFFFF), 24, (uint8_t *)"Megawin Company");
        LCD_ShowString((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), lcddev.width, 24, (uint16_t)(rand() % 0xFFFF), 24, (uint8_t *)"ARM Cortex-M0 Series");
        LCD_ShowString((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), lcddev.width, 24, (uint16_t)(rand() % 0xFFFF), 24, (uint8_t *)"Product MG32F02A");
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Line
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Line(void)
{
    uint16_t lCount = 500;
    LCD_Clear(BLACK);
    do{
        LCD_DrawLine((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Rectangle
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Rectangle(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_DrawRectangle((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Random
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Fill(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_Fill((uint16_t)(rand() % 120), (uint16_t)(rand() % 160), (uint16_t)(rand() % 120), (uint16_t)(rand() % 160), (uint16_t)(rand() % 0xFFFF));
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Circle
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Circle(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_Draw_Circle((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
    }while(-- lCount != 0);
}

/**
 *******************************************************************************
 * @brief       Random show Geometry
 * @return      None
 *******************************************************************************
 */
void LCD_Random_Geometry(void)
{
    uint16_t lCount = 100;
    LCD_Clear(BLACK);
    do{
        LCD_DrawLine((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
        LCD_DrawRectangle((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
        LCD_Draw_Circle((uint16_t)(rand() % 240), (uint16_t)(rand() % 320), (uint8_t)(rand() % 320), (uint16_t)(rand() % 0xFFFF));
    }while(-- lCount != 0);
}

//=============================================================================

