


/**
 ******************************************************************************
 *
 * @file        Sample_URT0_SPISlaveMode_TxRx.c
 * @brief       The demo UART0'S initial to SPI slave mode sample C file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2021/01/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *  
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_URT_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define URTX        URT0
#define URTX_IRQn   URT0_IRQn

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_URT0_SPISlaveMode_Init(void);


/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	   Sample URT0 initial
 * @details     1. Set CSC initial.
 *     \n       2. Set GPIO initial.
 *     \n       3. Set RX/TX oversampling sampling clock source
 *     \n       4. Set data character.
 *     \n       5. Set URT0 mode.
 *     \n       6. Set Data line.
 * @return      
 * @exception   No
 * @note

 *******************************************************************************
 */
void Sample_URT0_SPISlaveMode_Init(void)
{
    
    PIN_InitTypeDef  URT_GPIO;
    URT_Data_TypeDef URT_DataCharacter;
    uint8_t          URT_InitDataTmp = 0;

    /*
    Set CSC init:
        MG32_CSC_Init.h(Configuration Wizard) - 
            *Select CK_HS Source                             = CK_IHRCO
            *Configure PLL: (  CK_PLLO = ( ( CK_HS / 2 ) * 16 ) / 2                  // If CK_HS = 12MHz CK_PLLO is 48MHz
                - Select PLL Input Clock Source              = CK_HS
                - Select CK_PLLI Divider                     = CK_HSx / 2
                - Select CK_PLL MultiplicationX Factor       = 16
                - Select CK_PLLO Divider                     = CK_PLL / 2
            *Select CK_MAIN Source                           = CK_PLLO
            *Select APB Prescaler                            = CK_MAIN / 1
            *Select AHB Prescaler                            = CK_APB / 2
            *Enable URT0 and Select URT0_PR source = CK_APB in "Configure Peripheral ON Mode Clock".
            *Enable URT0 in "Configure Peripheral SLEEP Mode Clock" if want to run URT0 in SLEEP mode.
    */ 
 
    /*
        To Inital GPIO can use GPIO Wizard opition or using the following code. 
    */
    URT_GPIO.PINX_Mode				 = PINX_Mode_PushPull_O;           // The Pin is push-pull mode
    URT_GPIO.PINX_PUResistant        = PINX_PUResistant_Enable;        // The pull-up resister enable
    URT_GPIO.PINX_Speed              = PINX_Speed_High;                // The pin output high speed mode enable.
    URT_GPIO.PINX_OUTDrive           = PINX_OUTDrive_Level0;           // The pin output drive strength is Level0 ( Drive strength-full)
    URT_GPIO.PINX_FilterDivider      = PINX_FilterDivider_Bypass;      // The pin input deglitch filter clock divider select.
    URT_GPIO.PINX_Inverse            = PINX_Inverse_Disable;           // The pin input inverse disable.
    URT_GPIO.PINX_Alternate_Function = 3;                              // The pin alternate function is MISO ( URTn_TX).
    GPIO_PinMode_Config(PINB(8),&URT_GPIO);                            // The MISO pin is PB8
    
    URT_GPIO.PINX_Mode				 = PINX_Mode_Digital_I;            // The Pin is digital input mode
    URT_GPIO.PINX_Alternate_Function = 3;                              // The pin alternate function is MOSI ( URTn_RX).
    GPIO_PinMode_Config(PINB(9),&URT_GPIO);                            // The MOSI pin is PB9
    
    URT_GPIO.PINX_Alternate_Function = 11;                             // The pin alternate function is CLK ( URTn_CLK).
    GPIO_PinMode_Config(PINB(11),&URT_GPIO);                           // The CLK pin is PB9
    
    URT_GPIO.PINX_Alternate_Function = 3;                              // The pin alternate function is NSS( URTn_NSS).
    GPIO_PinMode_Config(PINB(10),&URT_GPIO);                           // The NSS pin is PB10
 
    /*
        Set Sample Clock
    */
    //---TX/RX Clock---//
    URT_TXClockSource_Select(URTX,URT_TXClock_EXT);                   //TX clock from URT_CLK    
    URT_RXClockSource_Select(URTX,URT_RXClock_EXT);                   //RX clock from URT_CLK
    URT_TXOverSamplingSampleNumber_Select(URTX, 2);	                  //Set TX oversampling time is 3 time
    URT_RXOverSamplingSampleNumber_Select(URTX, 2);	                  //Set RX oversampling time is 3 time
    URT_RXOverSamplingMode_Select(URTX, URT_RXSMP_1TIME);
    URT_TX_Cmd(URTX, ENABLE);	                                      //Enable TX
    URT_RX_Cmd(URTX, ENABLE);	                                      //Enable RX
 
    /*
        Set Mode
    */
    // Set data character
    URT_DataCharacter.URT_TX_DataLength  = URT_DataLength_8;          // Set TX data bit is 8 bitS.
    URT_DataCharacter.URT_RX_DataLength  = URT_DataLength_8;          // Set RX data bit is 8 bitS.
    URT_DataCharacter.URT_TX_DataOrder   = URT_DataTyped_MSB;         // Set TX data order is MSB.
    URT_DataCharacter.URT_RX_DataOrder   = URT_DataTyped_MSB;         // Set RX data order is MSB.
    URT_DataCharacter.URT_TX_Parity      = URT_Parity_No;             // Set TX parity bit disable. (Set the parmaeter because the parameter can't undfine parmater).  
    URT_DataCharacter.URT_RX_Parity      = URT_Parity_No;             // Set RX parity bit disable. (Set the parmaeter because the parameter can't undfine parmater). 
    URT_DataCharacter.URT_TX_StopBits    = URT_StopBits_1_0;          // Set TX Stop bit is 1 bit   (Set the parmaeter because the parameter can't undfine parmater). 
    URT_DataCharacter.URT_RX_StopBits    = URT_StopBits_1_0;          // Set RX Stop bit is 1 bit   (Set the parmaeter because the parameter can't undfine parmater).       
    URT_DataCharacter.URT_TX_DataInverse = DISABLE;                   // Set TX data inverse disable.
    URT_DataCharacter.URT_RX_DataInverse = DISABLE;                   // Set RX data inverse disable.
    URT_DataCharacter_Config(URTX, &URT_DataCharacter);
    
    // Set Mode ( SPI Slave Mode)
    URT_Mode_Select(URTX,URT_SYNC_mode);                              // Set SYNC mode                                           
    URT_SYNCMode_Select( URTX, URT_SYNC_SLAVE);                       // Set Slave mode
    URT_CPHAMode_Select(URTX,URT_CPHA0_LeadEdge);                     // Set CPHA = 0
    URT_CPOLMode_Select(URTX,URT_CPOL0_Low);                          // Set CPOL = 0
    URT_NssInput_Cmd(URTX,ENABLE);                                    // Enable NSS input function
    URT_CLKSignal_Cmd(URTX,DISABLE);                                  // URT_CLK output disable.
  
    //Buffer inital.
    URT_RXShadowBufferThreshold_Select(URTX,URT_RXTH_1BYTE);          // RX shadow buffer is 1 byte.
    
    //Data line inital
    URT_DataLine_Select(URTX, URT_DataLine_2);                        // Set Data lien is two line ( MISO / MOSI)
    
    //Enable URT RX / TX
    URT_TX_Cmd(URTX,ENABLE);                                          // Enable URT TX Function
    URT_RX_Cmd(URTX,ENABLE);                                          // Enable URT RX Function
    URT_Cmd(URTX,ENABLE);                                             // Enable URT Function
 
    /*
        Configure ASB Channel0 interrupt
    */
//    URT_IT_Config( URTX , ( URT_IT_TC | URT_IT_TX | URT_IT_RX) , ENABLE); // Enable TXF & TCF & RXF interrupt of ASB Channel0. 
//                                                                          //     * TIE  : The interrupt is ASB channeln transmit data threshold low flag.
//                                                                          //     * TCIE : The interrupt is ASB channeln transmission complete 
//    URT_ITEA_Cmd( URTX, ENABLE);                                          // Enable URTX interrupt.
//    NVIC_EnableIRQ(URTX_IRQn);                                            // Enables URTn interrupt in the NVIC interrupt controller.
     
    /*
        The sample is that Transmit data and receive data by polling flag.
    */
      
    URT_SetTXData( URTX , 1, 0x55);                                         // Send 0x55 
    while( (URT_GetITAllFlagStatus( URTX) & (URT_IT_TC | URT_IT_RX)) == 0); // Wait transmit complete and 
    URT_InitDataTmp = (uint8_t)URT_GetRXData(URTX);                         // Read Data can auto clear URT_RXF or direct clear URT_RXF if only transmit data. 
     
    URT_ClearITFlag(URTX,URT_IT_TC);                                        // It can clear URT_TCF in last byte becasue hardware auto clear URT_TCF in write TDAT.
    
 
 
}
 
 
