
/**
 ******************************************************************************
 *
 * @file        stdio_fput_fget_to_URT0.C
 * @brief       Output data by UART module. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/06/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "stdio.h"
#include "string.h"
#include "Mx92G8z_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
volatile uint8_t gURT0_First = 0;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/




int fputc(int ch, FILE *f)
{
    if(gURT0_First == 0)
        gURT0_First = 1;
    else
        while(URT_GetITSingleFlagStatus(URT0, URT_IT_TC) == DRV_UnHappened);
    
    URT_ClearITFlag(URT0, URT_IT_TC);
    URT_SetTXData(URT0, 1, ch);
    return ch;
}



int fgetc(FILE *f)
{
    int ch;
    while(URT0->STA.MBIT.RXF == 0);
    ch = UART_RXData1BYTE_Read(URT0);
    return ch;
}

