
#include "LCD.h"
#include "Font.h"
#define EMB_CR1_MAD_SWAP_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MAD_SWAP_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MAD_SWAP_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MAD_SWAP_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_MAD_SWAP_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
//#include "usart.h"
//#include "delay.h"
//////////////////////////////////////////////////////////////////////////////////
//本程序只供學習使用，未經作者許可，不得用於其它任何用途
//ALIENTEK戰艦STM32開發板
//2.4寸/2.8寸/3.5寸/4.3寸 TFT液晶驅動
//支持驅動IC型號包括:ILI9341/ILI9325/RM68042/RM68021/ILI9320/ILI9328/LGDP4531/LGDP4535/
//                  SPFD5408/SSD1289/1505/B505/C505/NT35310/NT35510等
//正點原子@ALIENTEK
//技術論壇:www.openedv.com
//修改日期:2014/7/10
//版本：V2.6
//版權所有，盜版必究。
//Copyright(C) 廣州市星翼電子科技有限公司 2009-2019
//All rights reserved
//********************************************************************************
//V1.2修改說明
//支持了SPFD5408的驅動,另外把液晶ID直接打印成HEX格式.方便查看LCD驅動IC.
//V1.3
//加入了快速IO的支持
//修改了背光控制的極性（適用於V1.8及以後的開發板版本）
//對於1.8版本之前(不包括1.8)的液晶模塊,請修改LCD_Init函數的LCD_LED=1;為LCD_LED=1;
//V1.4
//修改了LCD_ShowChar函數，使用畫點功能畫字符。
//加入了橫豎屏顯示的支持
//V1.5 20110730
//1,修改了B505液晶讀顏色有誤的bug.
//2,修改了快速IO及橫豎屏的設置方式.
//V1.6 20111116
//1,加入對LGDP4535液晶的驅動支持
//V1.7 20120713
//1,增加LCD_RD_DATA函數
//2,增加對ILI9341的支持
//3,增加ILI9325的獨立驅動代碼
//4,增加LCD_Scan_Dir函數(慎重使用)
//6,另外修改了部分原來的函數,以適應9341的操作
//V1.8 20120905
//1,加入LCD重要參數設置結構體lcddev
//2,加入LCD_Display_Dir函數,支持在線橫豎屏切換
//V1.9 20120911
//1,新增RM68042驅動（ID:6804），但是6804不支持橫屏顯示！！原因：改變掃描方式，
//導致6804坐標設置失效，試過很多方法都不行，暫時無解。
//V2.0 20120924
//在不硬件覆位的情況下,ILI9341的ID讀取會被誤讀成9300,修改LCD_Init,將無法識別
//的情況（讀到ID為9300/非法ID）,強制指定驅動IC為ILI9341，執行9341的初始化。
//V2.1 20120930
//修正ILI9325讀顏色的bug。
//V2.2 20121007
//修正LCD_Scan_Dir的bug。
//V2.3 20130120
//新增6804支持橫屏顯示
//V2.4 20131120
//1,新增NT35310（ID:5310）驅動器的支持
//2,新增LCD_Set_Window函數,用於設置窗口,對快速填充,比較有用,但是該函數在橫屏時,不支持6804.
//V2.5 20140211
//1,新增NT35510（ID:5510）驅動器的支持
//V2.6 20140710
//1,修正LCD_Scan_Dir橫屏時設置的掃描方式顯示不全的bug.
//////////////////////////////////////////////////////////////////////////////////


//LCD的畫筆顏色和背景色	    
uint16_t POINT_COLOR=0xFFFF;    //畫筆顏色
uint16_t BACK_COLOR=0x0000;     //背景色 

//管理LCD重要參數
//默認為豎屏
_lcd_dev lcddev;


#define delay_ms Delay
//void delay_ms(uint32_t DelayCount)
//{
//    

//}

/**
 *******************************************************************************
 * @brief       This function provides accurate delay (in microseconds).
 * @param       uDelay specifies the delay time length, in microseconds.
 *      
 * @return      None
 *******************************************************************************
 */
void delay_us(uint32_t DelayCount)
{
    

}

/**
 *******************************************************************************
 * @brief       Data Reverse 16-Bits
 * @param       InData Input Data.
 *      
 * @return      uint16_t Reverse Data 
 *******************************************************************************
 */
uint16_t DataReverse(uint16_t InData)
{
    uint16_t t, t2;

    t2 = InData;
    t = 0;
    t |= (t2 & 0x0001); // Bit0

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit1

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit2

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit3

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit4

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit5

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit6

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit7

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit8

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit9

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit10

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit11

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit12

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit13

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit14

    t <<= 1;
    t2 >>= 1;
    t |= (t2 & 0x0001); // Bit15

    return t;
}



//撖怠?摮?賣
//data:撖??典?
void LCD_WR_REG(uint16_t data)
{ 
    __LCD_CS_CLR(); 
    __LCD_RS_CLR();//撖怠?  
    __DATAOUT(data); 
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    __LCD_CS_SET();   
}



//撖急???
//?臭誑?蹂誨LCD_WR_DATAX摰??踵???蝛粹?.
//data:撖??典?
void LCD_WR_DATAX(uint16_t data)
{
    __LCD_CS_CLR();
    __LCD_RS_SET();
    __DATAOUT(data);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    __LCD_CS_SET();
}



//霈LCD?豢?
//餈???霈?啁???
uint16_t LCD_RD_DATA(void)
{
    uint16_t t;
    __LCD_CS_CLR();
    __LCD_RS_SET();
                //霈???霈撖??冽?,銝虫??閬?2甈?
    __LCD_RD_CLR();
    if(lcddev.id==0X8989)delay_us(2);//FOR 8989,撱嗆?2us
    t=__DATAIN();  
    __LCD_RD_SET();
    __LCD_CS_SET();

    if((EMB->CR1.B[1] & EMB_CR1_MAD_SWAP_mask_b1) == 0)
        return t;
    else
        return DataReverse(t);
}



/**
 *******************************************************************************
 * @brief       Write Data to LCD Module Register 寫數據至寄存器
 * @param       LCD_Reg LCD Module Control Register 寄存器編號
 * @param       LCD_RegValue Write Value            要寫入的值
 * @return      None 
 *******************************************************************************
 */
void LCD_WriteReg(uint16_t LCD_Reg,uint16_t LCD_RegValue)
{
    //LCD_WR_REG(LCD_Reg);
    __LCD_CS_CLR(); 
    __LCD_RS_CLR();//撖怠?  
    __DATAOUT(LCD_Reg); 
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    //__LCD_CS_SET(); 

    //LCD_WR_DATA(LCD_RegValue);
    //__LCD_CS_CLR();
    __LCD_RS_SET();
    __DATAOUT(LCD_RegValue);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    __LCD_CS_SET();
}



/**
 *******************************************************************************
 * @brief       Read Data from LCD Module Register 讀寄存器
 * @param       LCD_Reg LCD Module Control Register 寄存器編號
 * @return      uint16_t 讀到的值
 *******************************************************************************
 */
uint16_t LCD_ReadReg(uint16_t LCD_Reg)
{
    uint16_t lTemp;
    //LCD_WR_REG(LCD_Reg);  //寫入要讀的寄存器號
    __LCD_CS_CLR();
    __LCD_RS_CLR();         //寫地址
    __DATAOUT(LCD_Reg);
    __LCD_WR_CLR();
    __LCD_WR_SET();
    //__LCD_CS_SET();

    //__LCD_CS_CLR();
    __LCD_RS_SET();
                //讀取數據(讀寄存器時,並不需要讀2次)
    __LCD_RD_CLR();
    if(lcddev.id==0X8989)delay_us(2);//FOR 8989,延時2us
    lTemp = __DATAIN();  
    __LCD_RD_SET();
    __LCD_CS_SET(); 
    return lTemp;
}



//??撖亮RAM
void LCD_WriteRAM_Prepare(void)
{
    LCD_WR_REG(lcddev.wramcmd);
}



//LCD撖亮RAM
//RGB_Code:憿??
void LCD_WriteRAM(uint16_t RGB_Code)
{
    LCD_WR_DATA(RGB_Code);//寫十六位GRAM
}



/**
 *******************************************************************************
 * @brief       Color format BGR comver to RGB
 *              從ILI93xx讀出的數據為GBR格式，而我們寫入的時候為RGB格式。
 * @param       BGRData BGR format Data Value BGR格式的顏色值
 * @return      uint16_t RGB格式的顏色值
 *******************************************************************************
 */
uint16_t LCD_BGR2RGB(uint16_t c)
{
    uint16_t  r,g,b,rgb;   
    b=(c>>0)&0x1f;
    g=(c>>5)&0x3f;
    r=(c>>11)&0x1f;	 
    rgb=(b<<11)+(g<<5)+(r<<0);
    return(rgb);
}



/**
 *******************************************************************************
 * @brief       Read Point Color Value 讀取個某點的顏色值
 * @param       x X-axes 坐標
 * @param       y Y-axes 坐標
 * @return      Color Value 此點的顏色
 *******************************************************************************
 */
uint16_t LCD_ReadPoint(uint16_t x,uint16_t y)
{
    uint16_t r, g, b;
    if(x >= lcddev.width || y >= lcddev.height)
        return 0;                   //超過了範圍,直接返回
    LCD_SetCursor(x,y);
    if(lcddev.id == 0X9341 || lcddev.id == 0X6804 || lcddev.id == 0X5310)
        LCD_WR_REG(0X2E);           //9341/6804/5310發送讀GRAM指令
    else if(lcddev.id==0X5510)
        LCD_WR_REG(0X2E00);         //5510 發送讀GRAM指令
    else 
        LCD_WR_REG(R34);            //其他IC發送讀GRAM指令

    __LCD_CS_CLR();	    
    __LCD_RS_SET();
    
    //讀取數據(讀GRAM時,第一次為假讀)
    __LCD_RD_CLR();	
    delay_us(1);                    //延時1us
    __LCD_RD_SET();
    
    //dummy READ
    __LCD_RD_CLR();
    delay_us(1);                    //延時1us
    r=__DATAIN();  	                //實際坐標顏色
    __LCD_RD_SET();
    if(lcddev.id==0X9341||lcddev.id==0X5310||lcddev.id==0X5510)     //9341/NT35310/NT35510要分2次讀出
    {
        __LCD_RD_CLR();
        b=__DATAIN();               //讀取藍色值
        __LCD_RD_SET();
        g=r&0XFF;                   //對於9341,第一次讀取的是RG的值,R在前,G在後,各占8位
        g<<=8;
    }else if(lcddev.id==0X6804)
    {
        __LCD_RD_CLR();
        __LCD_RD_SET();
        r=__DATAIN();               //6804第二次讀取的才是真實值 
    }
    __LCD_CS_SET();
    if(lcddev.id == 0X9325 || lcddev.id == 0X4535 || lcddev.id == 0X4531 || lcddev.id == 0X8989 || lcddev.id == 0XB505)
        return r;                   //這幾種IC直接返回顏色值
    else if(lcddev.id == 0X9341 || lcddev.id == 0X5310 || lcddev.id == 0X5510)
        return (((r >> 11) << 11) | ((g >> 10) << 5) | (b >> 11));//ILI9341/NT35310/NT35510需要公式轉換一下
    else 
        return LCD_BGR2RGB(r);      //其他IC
}



/**
 *******************************************************************************
 * @brief       LCD Display ON LCD開啟顯示
 * @return      None
 *******************************************************************************
 */
void LCD_DisplayOn(void)
{
    if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)LCD_WR_REG(0X29);    //開啟顯示
    else if(lcddev.id==0X5510)LCD_WR_REG(0X2900);   //開啟顯示
    else LCD_WriteReg(R7,0x0173);                   //開啟顯示
}



/**
 *******************************************************************************
 * @brief       LCD Display OFF LCD關閉顯示
 * @return      None
 *******************************************************************************
 */
void LCD_DisplayOff(void)
{
    if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)LCD_WR_REG(0X28);	//??憿舐內
    else if(lcddev.id==0X5510)LCD_WR_REG(0X2800);	//??憿舐內
    else LCD_WriteReg(R7, 0x0);//??憿舐內 
}



/**
 *******************************************************************************
 * @brief       Set Cursor 設置光標位置
 * @param       Xpos X-axes 坐標
 * @param       Ypos Y-axes 坐標
 * @return      None
 *******************************************************************************
 */
void LCD_SetCursor(uint16_t Xpos, uint16_t Ypos)
{
    if(lcddev.id==0X9341||lcddev.id==0X5310)
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_DATA(Ypos&0XFF);
    }else if(lcddev.id==0X6804)
    {
        if(lcddev.dir==1)Xpos=lcddev.width-1-Xpos;//璈怠?????
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_DATA(Ypos&0XFF);
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(Xpos>>8); 
        LCD_WR_REG(lcddev.setxcmd+1); 
        LCD_WR_DATA(Xpos&0XFF);	 
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(Ypos>>8); 
        LCD_WR_REG(lcddev.setycmd+1); 
        LCD_WR_DATA(Ypos&0XFF);
    }else
    {
        if(lcddev.dir==1)Xpos=lcddev.width-1-Xpos;//璈怠??嗅祕撠望隤輯?x,y??
        LCD_WriteReg(lcddev.setxcmd, Xpos);
        LCD_WriteReg(lcddev.setycmd, Ypos);
    }
}



/**
 *******************************************************************************
 * @brief       Set LCD automatic scan direction 設置LCD的自動掃描方向
 * @param       Dir 0~7,代表8個方向(具體定義見lcd.h)
 *      @arg        L2R_U2D : From left to right, top to bottom.
 *      @arg        L2R_D2U : From left to right, bottom to top.
 *      @arg        R2L_U2D : From right to left, top to bottom.
 *      @arg        R2L_D2U : From right to left, bottom to top.
 *      @arg        U2D_L2R : From top to bottom, left to right.
 *      @arg        U2D_R2L : From top to bottom, right to left.
 *      @arg        D2U_L2R : From bottom to top, left to right.
 *      @arg        D2U_R2L : From bottom to top, right to left.
 * @return      None
 * @note        其他函數可能會受到此函數設置的影響(尤其是9341/6804這兩個奇葩),
 *              一般設置為L2R_U2D即可,如果設置為其他掃描方式,可能導致顯示不正常.
 *              9320/9325/9328/4531/4535/1505/b505/8989/5408/9341/5310/5510等IC已經實際測試
 *******************************************************************************
 */	   	   
void LCD_Scan_Dir(uint8_t dir)
{
    uint16_t regval=0;
    uint16_t dirreg=0;
    uint16_t temp;  
    if(lcddev.dir==1&&lcddev.id!=0X6804)//橫屏時，對6804不改變掃描方向！
    {
        switch(dir)//方向轉換
        {
            case 0:dir=6;break;
            case 1:dir=7;break;
            case 2:dir=4;break;
            case 3:dir=5;break;
            case 4:dir=1;break;
            case 5:dir=0;break;
            case 6:dir=3;break;
            case 7:dir=2;break;	     
        }
    }
    if(lcddev.id==0x9341||lcddev.id==0X6804||lcddev.id==0X5310||lcddev.id==0X5510)//9341/6804/5310/5510,很特殊
    {
        switch(dir)
        {
            case L2R_U2D://從左到右,從上到下
                regval|=(0<<7)|(0<<6)|(0<<5); 
                break;
            case L2R_D2U://從左到右,從下到上
                regval|=(1<<7)|(0<<6)|(0<<5); 
                break;
            case R2L_U2D://從右到左,從上到下
                regval|=(0<<7)|(1<<6)|(0<<5); 
                break;
            case R2L_D2U://從右到左,從下到上
                regval|=(1<<7)|(1<<6)|(0<<5); 
                break;	 
            case U2D_L2R://從上到下,從左到右
                regval|=(0<<7)|(0<<6)|(1<<5); 
                break;
            case U2D_R2L://從上到下,從右到左
                regval|=(0<<7)|(1<<6)|(1<<5); 
                break;
            case D2U_L2R://從下到上,從左到右
                regval|=(1<<7)|(0<<6)|(1<<5); 
                break;
            case D2U_R2L://從下到上,從右到左
                regval|=(1<<7)|(1<<6)|(1<<5); 
                break;	 
        }
        if(lcddev.id==0X5510)dirreg=0X3600;
        else dirreg=0X36;
        if((lcddev.id!=0X5310)&&(lcddev.id!=0X5510))regval|=0X08;//5310/5510不需要BGR
        if(lcddev.id==0X6804)regval|=0x02;//6804的BIT6和9341的反了
        LCD_WriteReg(dirreg,regval);
        if(regval&0X20)
        {
            if(lcddev.width<lcddev.height)//交換X,Y
            {
                temp=lcddev.width;
                lcddev.width=lcddev.height;
                lcddev.height=temp;
            }
        }else  
        {
            if(lcddev.width>lcddev.height)//交換X,Y
            {
                temp=lcddev.width;
                lcddev.width=lcddev.height;
                lcddev.height=temp;
            }
        }  
        if(lcddev.id==0X5510)
        {
            LCD_WR_REG(lcddev.setxcmd);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setxcmd+1);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setxcmd+2);LCD_WR_DATA((lcddev.width-1)>>8); 
            LCD_WR_REG(lcddev.setxcmd+3);LCD_WR_DATA((lcddev.width-1)&0XFF); 
            LCD_WR_REG(lcddev.setycmd);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setycmd+1);LCD_WR_DATA(0); 
            LCD_WR_REG(lcddev.setycmd+2);LCD_WR_DATA((lcddev.height-1)>>8); 
            LCD_WR_REG(lcddev.setycmd+3);LCD_WR_DATA((lcddev.height-1)&0XFF);
        }else
        {
            LCD_WR_REG(lcddev.setxcmd); 
            LCD_WR_DATA(0);LCD_WR_DATA(0);
            LCD_WR_DATA((lcddev.width-1)>>8);LCD_WR_DATA((lcddev.width-1)&0XFF);
            LCD_WR_REG(lcddev.setycmd); 
            LCD_WR_DATA(0);LCD_WR_DATA(0);
            LCD_WR_DATA((lcddev.height-1)>>8);LCD_WR_DATA((lcddev.height-1)&0XFF);  
        }
    }else 
    {
        switch(dir)
        {
            case L2R_U2D:   //從左到右,從上到下
                regval|=(1<<5)|(1<<4)|(0<<3); 
                break;
            case L2R_D2U:   //從左到右,從下到上
                regval|=(0<<5)|(1<<4)|(0<<3); 
                break;
            case R2L_U2D:   //從右到左,從上到下
                regval|=(1<<5)|(0<<4)|(0<<3);
                break;
            case R2L_D2U:   //從右到左,從下到上
                regval|=(0<<5)|(0<<4)|(0<<3); 
                break;	 
            case U2D_L2R:   //從上到下,從左到右
                regval|=(1<<5)|(1<<4)|(1<<3); 
                break;
            case U2D_R2L:   //從上到下,從右到左
                regval|=(1<<5)|(0<<4)|(1<<3); 
                break;
            case D2U_L2R:   //從下到上,從左到右
                regval|=(0<<5)|(1<<4)|(1<<3); 
                break;
            case D2U_R2L:   //從下到上,從右到左
                regval|=(0<<5)|(0<<4)|(1<<3); 
                break;	 
        }
        if(lcddev.id==0x8989)//8989 IC
        {
            dirreg=0X11;
            regval|=0X6040;	//65K   
        }else               //其他驅動IC        
        {
            dirreg=0X03;
            regval|=1<<12;  
        }
        LCD_WriteReg(dirreg, regval);
    }
}



/**
 *******************************************************************************
 * @brief       Draw Point on Display 畫點
 * @param       x X-axes 坐標
 * @param       y Y-axes 坐標
 * @param       Color Value 此點的顏色
 * @return      None
 *******************************************************************************
 */
void LCD_DrawPoint(uint16_t x,uint16_t y, uint16_t Color)
{
    LCD_SetCursor(x,y);                     //設置光標位置
    LCD_WriteRAM_Prepare();                 //開始寫入GRAM
    LCD_WR_DATA(Color); 
}



/**
 *******************************************************************************
 * @brief       Fast Draw Point on Display 畫點
 * @param       x X-axes 坐標
 * @param       y Y-axes 坐標
 * @param       Color Value 此點的顏色
 * @return      None
 *******************************************************************************
 */
void LCD_Fast_DrawPoint(uint16_t x,uint16_t y,uint16_t color)
{
    if(lcddev.id==0X9341||lcddev.id==0X5310)
    {
        LCD_WR_REG(lcddev.setxcmd);
        LCD_WR_DATA(x>>8); 
        LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd);
        LCD_WR_DATA(y>>8); 
        LCD_WR_DATA(y&0XFF);
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd);LCD_WR_DATA(x>>8);
        LCD_WR_REG(lcddev.setxcmd+1);LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd);LCD_WR_DATA(y>>8);
        LCD_WR_REG(lcddev.setycmd+1);LCD_WR_DATA(y&0XFF);
    }else if(lcddev.id==0X6804)
    {
        if(lcddev.dir==1)x=lcddev.width-1-x;            //橫屏時處理
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(x>>8); 
        LCD_WR_DATA(x&0XFF);
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(y>>8); 
        LCD_WR_DATA(y&0XFF);
    }else
    {
        if(lcddev.dir==1)x=lcddev.width-1-x;            //橫屏其實就是調轉x,y坐標
        LCD_WriteReg(lcddev.setxcmd,x);
        LCD_WriteReg(lcddev.setycmd,y);
    }
    __LCD_CS_CLR(); 
    __LCD_RS_CLR();
    __DATAOUT(lcddev.wramcmd);                          //寫指令 選至GRAM
    __LCD_WR_CLR(); 
    __LCD_WR_SET(); 
    __LCD_CS_SET(); 
    LCD_WR_DATA(color);                                 //寫數據
}



/**
 *******************************************************************************
 * @brief       Set LCD display direction
 * @param       Dir
*      @arg        0: Vertical screen 豎屏
*      @arg        1: Horizontal screen 橫屏
 * @return      None
 *******************************************************************************
 */
void LCD_Display_Dir(uint8_t dir)
{
    if(dir==0)                  //豎屏
    {
        lcddev.dir=0;           //豎屏
        lcddev.width=240;
        lcddev.height=320;
        if(lcddev.id==0X9341||lcddev.id==0X6804||lcddev.id==0X5310)
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2A;
            lcddev.setycmd=0X2B;
            if(lcddev.id==0X6804||lcddev.id==0X5310)
            {
                lcddev.width=320;
                lcddev.height=480;
            }
        }else if(lcddev.id==0X8989)
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=0X4E;
            lcddev.setycmd=0X4F;  
        }else if(lcddev.id==0x5510)
        {
            lcddev.wramcmd=0X2C00;
            lcddev.setxcmd=0X2A00;
            lcddev.setycmd=0X2B00; 
            lcddev.width=480;
            lcddev.height=800;
        }else
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=R32;
            lcddev.setycmd=R33;  
        }
    }else                   //橫屏
    {
        lcddev.dir=1;       //橫屏
        lcddev.width=320;
        lcddev.height=240;
        if(lcddev.id==0X9341||lcddev.id==0X5310)
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2A;
            lcddev.setycmd=0X2B;  	 
        }else if(lcddev.id==0X6804)	 
        {
            lcddev.wramcmd=0X2C;
            lcddev.setxcmd=0X2B;
            lcddev.setycmd=0X2A; 
        }else if(lcddev.id==0X8989)
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=0X4F;
            lcddev.setycmd=0X4E;   
        }else if(lcddev.id==0x5510)
        {
            lcddev.wramcmd=0X2C00;
            lcddev.setxcmd=0X2A00;
            lcddev.setycmd=0X2B00; 
            lcddev.width=800;
            lcddev.height=480;
        }else
        {
            lcddev.wramcmd=R34;
            lcddev.setxcmd=R33;
            lcddev.setycmd=R32;  
        }
        if(lcddev.id==0X6804||lcddev.id==0X5310)
        { 	 
            lcddev.width=480;
            lcddev.height=320;
        }
    } 
    LCD_Scan_Dir(DFT_SCAN_DIR);     //默認掃描方向
}



/**
 *******************************************************************************
 * @brief       Set Windows 設置窗口,並自動設置畫點坐標到窗口左上角(sx,sy).
 * @param       sx windows Start X-axes 窗口起始坐標(左上角)
 * @param       sy windows Start Y-axes 窗口起始坐標(左上角)
 * @param       width windows width 窗體大小
 * @param       height windows height 窗體大小
 * @return      None
 * @note        68042,橫屏時不支持窗口設置!! 
 *******************************************************************************
 */
void LCD_Set_Window(uint16_t sx,uint16_t sy,uint16_t width,uint16_t height)
{
    uint8_t hsareg,heareg,vsareg,veareg;
    uint16_t hsaval,heaval,vsaval,veaval; 
    width=sx+width-1;
    height=sy+height-1;
    if(lcddev.id==0X9341||lcddev.id==0X5310||lcddev.id==0X6804)//6804橫屏不支持??
    {
        LCD_WR_REG(lcddev.setxcmd); 
        LCD_WR_DATA(sx>>8); 
        LCD_WR_DATA(sx&0XFF);	 
        LCD_WR_DATA(width>>8); 
        LCD_WR_DATA(width&0XFF);  
        LCD_WR_REG(lcddev.setycmd); 
        LCD_WR_DATA(sy>>8); 
        LCD_WR_DATA(sy&0XFF); 
        LCD_WR_DATA(height>>8); 
        LCD_WR_DATA(height&0XFF); 
    }else if(lcddev.id==0X5510)
    {
        LCD_WR_REG(lcddev.setxcmd);LCD_WR_DATA(sx>>8);  
        LCD_WR_REG(lcddev.setxcmd+1);LCD_WR_DATA(sx&0XFF);	  
        LCD_WR_REG(lcddev.setxcmd+2);LCD_WR_DATA(width>>8);   
        LCD_WR_REG(lcddev.setxcmd+3);LCD_WR_DATA(width&0XFF);   
        LCD_WR_REG(lcddev.setycmd);LCD_WR_DATA(sy>>8);   
        LCD_WR_REG(lcddev.setycmd+1);LCD_WR_DATA(sy&0XFF);  
        LCD_WR_REG(lcddev.setycmd+2);LCD_WR_DATA(height>>8);   
        LCD_WR_REG(lcddev.setycmd+3);LCD_WR_DATA(height&0XFF);  
    }else	//其他驅動IC
    {
        if(lcddev.dir==1)//橫屏
        {
            //窗口值
            hsaval=sy;
            heaval=height;
            vsaval=lcddev.width-width-1;
            veaval=lcddev.width-sx-1;
        }else
        { 
            hsaval=sx;
            heaval=width;
            vsaval=sy;
            veaval=height;
        }
        if(lcddev.id==0X8989)//8989 IC
        {
            hsareg=0X44;heareg=0X44;    //水平方向窗口寄存器 (1289的由一個寄存器控制)
            hsaval|=(heaval<<8);        //得到寄存器值.
            heaval=hsaval;
            vsareg=0X45;veareg=0X46;    //垂直方向窗口寄存器
        }else                           //其他驅動IC
        {
            hsareg=0X50;heareg=0X51;    //水平方向窗口寄存器
            vsareg=0X52;veareg=0X53;    //垂直方向窗口寄存器
        }
        //設置寄存器值
        LCD_WriteReg(hsareg,hsaval);
        LCD_WriteReg(heareg,heaval);
        LCD_WriteReg(vsareg,vsaval);
        LCD_WriteReg(veareg,veaval);
        LCD_SetCursor(sx,sy);           //設置光標位置
    }
}



/**
 *******************************************************************************
 * @brief       LCD Initial 初始化lcd
 * @return      None
 * @note        本函數占用較大flash,用戶可以根據自己的實際情況,刪掉未用到的LCD初始化代碼.以節省空間.
 *******************************************************************************
 */
void LCD_Init(void)
{
    //uint16_t ltemp;
    // EMB Config
    EMB->CR0.W &= (~EMB_CR0_EN_mask_w);

    EMB->CLK.W = (1 << EMB_CLK_CK_PSC_shift_w);
    EMB->CR0.W = ((uint32_t)0x00000100) |   //EMB_CR0_BUS_DSIZE_16_bit_w |
                 EMB_CR0_WEN_mask_w |
                 ((uint32_t)0x00000004) |   // EMB_CR0_BW_EN_mask_w
                 //EMB_CR0_SYNC_EN_mask_w |
                 //EMB_CR0_BUS_MDS_multiplex_w |
                 EMB_CR0_BUS_MDS_separated_w |
                 //EMB_CR0_ADR_TWO_mask_w |
                 //EMB_CR0_ADR_SEL_16bit_w |
                 //EMB_CR0_ADR_SEL_24bit_w |
                 //EMB_CR0_ADR_SEL_30bit_w |
                 //EMB_CR0_ALE2_MDS_ale_w |
                 //EMB_CR0_ALE2_MDS_ale2_w |
                 //EMB_CR0_OE_CTL_mask_w |
                 //EMB_CR0_WE_CTL_mask_w |
                 //EMB_CR0_DMA_EN_mask_w |
                 0;

    EMB->CR1.W = //EMB_CR1_CE_INV_mask_w |
                 //EMB_CR1_ALE_INV_mask_w |
                 //EMB_CR1_ALE2_INV_mask_w |
                 //EMB_CR1_CLK_INV_mask_w |
                 //EMB_CR1_MA_SWAP_mask_w |
                 //EMB_CR1_MAD_SWAP_mask_w |
                 //EMB_CR1_MAD_BSWAP_mask_w |
                 //EMB_CR1_MAM1_SEL_no_w |
                 //EMB_CR1_MAM1_SEL_mad15_w |
                 //EMB_CR1_MAM1_SEL_bw1_w |
                 //EMB_CR1_MAM1_SEL_ale2_w |
                 EMB_CR1_CE_SWEN_mask_w |       // LCD CS >> PB7 AFS8 MCE
                 EMB_CR1_CE_SWO_mask_w |
                 EMB_CR1_ALE_SWEN_mask_w |      // LCD RSTN >> PB4 AFS8 MALE
                 EMB_CR1_ALE_SWO_mask_w |
                 //EMB_CR1_ALE2_SWEN_mask_w |
                 //EMB_CR1_ALE2_SWO_mask_w |
                 EMB_CR1_BW0_SWEN_mask_w |      // LCD RS >> PC7 AFS8 MBW1
                 //EMB_CR1_BW0_SWO_mask_w |
                 //EMB_CR1_BW1_SWEN_mask_w |
                 //EMB_CR1_BW1_SWO_mask_w |
                 //EMB_CR1_OE_MUX_oe_w |
                 //EMB_CR1_OE_MUX_tm10_w |
                 //EMB_CR1_OE_MUX_tm16_w |
                 //EMB_CR1_OE_MUX_tm20_w |
                 //EMB_CR1_WE_MUX_we_w |
                 //EMB_CR1_WE_MUX_tm10_w |
                 //EMB_CR1_WE_MUX_tm16_w |
                 //EMB_CR1_WE_MUX_tm20_w |
                 0;

    EMB->CR2.W = //EMB_CR2_ALES_mask_w |
                 //(3 << EMB_CR2_ALEW_shift_w) |
                 //EMB_CR2_ALEH_mask_w |
                 EMB_CR2_ACCS_mask_w |
                 (2 << 16) |
                 //EMB_CR2_ACCH_mask_w |
                 //(1 << 24) |
                 0;

    EMB->CR0.W |= EMB_CR0_EN_mask_w;
    lcddev.id = 0x0000;
    delay_ms(50); // delay 50 ms
    LCD_WriteReg(0x0000,0x0001);
    //LCD_WriteReg(0x0001,0x0001);
    delay_ms(50); // delay 50 ms

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9320))
    {
        lcddev.id = 0x9320;
    }

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x04C9))
    {
        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
        lcddev.id = 0x9320;
    }

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9325))
    {
        lcddev.id = 0x9325;
    }

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0xA4C9))
    {
        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
        lcddev.id = 0x9325;
    }

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x9328))
    {
        lcddev.id = 0x9328;
    }

    if((lcddev.id == 0) && (LCD_ReadReg(0x0000) == 0x14C9))
    {
        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
        lcddev.id = 0x9328;
    }

    if(lcddev.id == 0)
    {
        __LCD_CS_CLR(); 
        __LCD_RS_CLR();//撖怠?  
        __DATAOUT(0xD3); 
        __LCD_WR_CLR(); 
        __LCD_WR_SET(); 
        __LCD_CS_SET();
        
        LCD_RD_DATA();      //dummy read 
        LCD_RD_DATA();      //Read 0x00
        if(LCD_RD_DATA() == 0x4141)
            lcddev.id = 0x9341;
    }

    if(lcddev.id == 0)
    {
        EMB->CR1.W |= EMB_CR1_MAD_SWAP_enable_w;
        __LCD_CS_CLR(); 
        __LCD_RS_CLR();//撖怠?  
        __DATAOUT(0xD3); 
        __LCD_WR_CLR(); 
        __LCD_WR_SET(); 
        __LCD_CS_SET();
        
        LCD_RD_DATA();      //dummy read 
        LCD_RD_DATA();      //Read 0x00
        if(LCD_RD_DATA() == 0x0041)
            lcddev.id = 0x9341;
        else
            EMB->CR1.W &= ~EMB_CR1_MAD_SWAP_mask_w;
    }

    if(lcddev.id == 0)
    {
//        LCD_WR_REG(0XDA00);
//        LCD_RD_DATA();                //霈??X00
//        LCD_WR_REG(0XDB00);
//        lcddev.id=LCD_RD_DATA();      //霈??X80
//        lcddev.id<<=8;
//        LCD_WR_REG(0XDC00);
//        lcddev.id|=LCD_RD_DATA();     //霈??X00
//        if(lcddev.id==0x8000)
            lcddev.id=0x5510;           //NT35510霈??ID??000H,?箸靘踹????撥?嗉身蝵桃5510
    }

//  lcddev.id = LCD_ReadReg(0x0000);
//if(lcddev.id<0XFF||lcddev.id==0XFFFF||lcddev.id==0X9300)//霈?衰D銝迤蝣??啣?lcddev.id==0X9300?斗嚗???341?冽鋡怨?雿???銝?鋡怨???300
//    {
//        //?岫9341 ID????

//        __LCD_CS_CLR(); 
//        __LCD_RS_CLR();//撖怠?  
//        __DATAOUT(0xD3); 
//        __LCD_WR_CLR(); 
//        __LCD_WR_SET(); 
//        __LCD_CS_SET();        

//        lcddev.id=LCD_RD_DATA();          //dummy read
//        lcddev.id=LCD_RD_DATA();          //Read 0x00

//        lcddev.id=LCD_RD_DATA();          //霈??3
//        lcddev.id<<=8;
//        lcddev.id|=LCD_RD_DATA();         //霈??1
//        if(lcddev.id == 0x4141)
//            lcddev.id = 0x9341; 
//
//        if(lcddev.id!=0X9341)             //??341,?岫?臭???804
//        {
//            LCD_WR_REG(0XBF);
//            LCD_RD_DATA();                        //dummy read
//            LCD_RD_DATA();                        //霈??X01
//            LCD_RD_DATA();                        //霈??XD0
//            lcddev.id=LCD_RD_DATA();              //??霈??X68 
//            lcddev.id<<=8;
//            lcddev.id|=LCD_RD_DATA();             //??霈??X04
//            if(lcddev.id!=0X6804)                 //銋???804,?岫???臭??烤T35310
//            {
//                  LCD_WR_REG(0XD4);
//                  LCD_RD_DATA();                  //dummy read
//                  LCD_RD_DATA();                  //霈??X01
//                  lcddev.id=LCD_RD_DATA();        //霈??X53
//                  lcddev.id<<=8;
//                  lcddev.id|=LCD_RD_DATA();       //??霈??X10
//                  if(lcddev.id!=0X5310)           //銋??烤T35310,?岫???臭??烤T35510
//                  {
//                      LCD_WR_REG(0XDA00);
//                      LCD_RD_DATA();              //霈??X00
//                      LCD_WR_REG(0XDB00);
//                      lcddev.id=LCD_RD_DATA();    //霈??X80
//                      lcddev.id<<=8;
//                      LCD_WR_REG(0XDC00);
//                      lcddev.id|=LCD_RD_DATA();   //霈??X00
//                      if(lcddev.id==0x8000)
//                      lcddev.id=0x5510;           //NT35510霈??ID??000H,?箸靘踹????撥?嗉身蝵桃5510
//                }
//            }
//        }
//    }
    EMB->CLK.W = (0 << EMB_CLK_CK_PSC_shift_w);
    printf("  LCD ID:%x\r\n",lcddev.id); //?LCD ID  
    if(lcddev.id==0X9341)   //9341????
    {
        LCD_WR_REG(0xCF);  
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0xC1); 
        LCD_WR_DATAX(0X30); 
        LCD_WR_REG(0xED);  
        LCD_WR_DATAX(0x64); 
        LCD_WR_DATAX(0x03); 
        LCD_WR_DATAX(0X12); 
        LCD_WR_DATAX(0X81); 
        LCD_WR_REG(0xE8);  
        LCD_WR_DATAX(0x85); 
        LCD_WR_DATAX(0x10); 
        LCD_WR_DATAX(0x7A); 
        LCD_WR_REG(0xCB);  
        LCD_WR_DATAX(0x39); 
        LCD_WR_DATAX(0x2C); 
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x34); 
        LCD_WR_DATAX(0x02); 
        LCD_WR_REG(0xF7);  
        LCD_WR_DATAX(0x20); 
        LCD_WR_REG(0xEA);  
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x00); 
        LCD_WR_REG(0xC0);    //Power control 
        LCD_WR_DATAX(0x1B);   //VRH[5:0] 
        LCD_WR_REG(0xC1);    //Power control 
        LCD_WR_DATAX(0x01);   //SAP[2:0];BT[3:0] 
        LCD_WR_REG(0xC5);    //VCM control 
        LCD_WR_DATAX(0x30); //3F
        LCD_WR_DATAX(0x30); //3C
        LCD_WR_REG(0xC7);    //VCM control2 
        LCD_WR_DATAX(0XB7); 
        LCD_WR_REG(0x36);    // Memory Access Control 
        LCD_WR_DATAX(0x48); 
        LCD_WR_REG(0x3A);   
        LCD_WR_DATAX(0x55); 
        LCD_WR_REG(0xB1);   
        LCD_WR_DATAX(0x00);   
        LCD_WR_DATAX(0x1A);
        if((EMB->CR1.W & EMB_CR1_MAD_SWAP_enable_w) == 0)
        {
            LCD_WR_REG(0xB6);    // Display Function Control 
            LCD_WR_DATAX(0x0A);
            LCD_WR_DATAX(0xA2);
        }
        else
        {
            LCD_WR_REG(0xB6);    // Display Function Control 
            LCD_WR_DATAX(0x0A);
            LCD_WR_DATAX(0xC2);
        }
        LCD_WR_REG(0xF2);    // 3Gamma Function Disable 
        LCD_WR_DATAX(0x00); 
        LCD_WR_REG(0x26);    //Gamma curve selected 
        LCD_WR_DATAX(0x01); 
        LCD_WR_REG(0xE0);    //Set Gamma 
        LCD_WR_DATAX(0x0F); 
        LCD_WR_DATAX(0x2A); 
        LCD_WR_DATAX(0x28); 
        LCD_WR_DATAX(0x08); 
        LCD_WR_DATAX(0x0E); 
        LCD_WR_DATAX(0x08); 
        LCD_WR_DATAX(0x54); 
        LCD_WR_DATAX(0XA9); 
        LCD_WR_DATAX(0x43); 
        LCD_WR_DATAX(0x0A); 
        LCD_WR_DATAX(0x0F); 
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x00);
        LCD_WR_REG(0XE1);    //Set Gamma 
        LCD_WR_DATAX(0x00); 
        LCD_WR_DATAX(0x15); 
        LCD_WR_DATAX(0x17); 
        LCD_WR_DATAX(0x07); 
        LCD_WR_DATAX(0x11); 
        LCD_WR_DATAX(0x06); 
        LCD_WR_DATAX(0x2B); 
        LCD_WR_DATAX(0x56); 
        LCD_WR_DATAX(0x3C); 
        LCD_WR_DATAX(0x05); 
        LCD_WR_DATAX(0x10); 
        LCD_WR_DATAX(0x0F); 
        LCD_WR_DATAX(0x3F); 
        LCD_WR_DATAX(0x3F); 
        LCD_WR_DATAX(0x0F); 
        LCD_WR_REG(0x2B); 
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x01);
        LCD_WR_DATAX(0x3f);
        LCD_WR_REG(0x2A); 
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xef);
        LCD_WR_REG(0x11); //Exit Sleep
        delay_ms(120);
        LCD_WR_REG(0x29); //display on
    }else if(lcddev.id==0x6804) //6804????
    {
        LCD_WR_REG(0X11);
        delay_ms(20);
        LCD_WR_REG(0XD0);//VCI1  VCL  VGH  VGL DDVDH VREG1OUT power amplitude setting
        LCD_WR_DATAX(0X07); 
        LCD_WR_DATAX(0X42); 
        LCD_WR_DATAX(0X1D); 
        LCD_WR_REG(0XD1);//VCOMH VCOM_AC amplitude setting
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X1a);
        LCD_WR_DATAX(0X09); 
        LCD_WR_REG(0XD2);//Operational Amplifier Circuit Constant Current Adjust , charge pump frequency setting
        LCD_WR_DATAX(0X01);
        LCD_WR_DATAX(0X22);
        LCD_WR_REG(0XC0);//REV SM GS 
        LCD_WR_DATAX(0X10);
        LCD_WR_DATAX(0X3B);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X02);
        LCD_WR_DATAX(0X11);
        
        LCD_WR_REG(0XC5);// Frame rate setting = 72HZ  when setting 0x03
        LCD_WR_DATAX(0X03);

        LCD_WR_REG(0XC8);//Gamma setting
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X25);
        LCD_WR_DATAX(0X21);
        LCD_WR_DATAX(0X05);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X0a);
        LCD_WR_DATAX(0X65);
        LCD_WR_DATAX(0X25);
        LCD_WR_DATAX(0X77);
        LCD_WR_DATAX(0X50);
        LCD_WR_DATAX(0X0f);
        LCD_WR_DATAX(0X00);

        LCD_WR_REG(0XF8);
        LCD_WR_DATAX(0X01);

        LCD_WR_REG(0XFE);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X02);

        LCD_WR_REG(0X20);//Exit invert mode

        LCD_WR_REG(0X36);
        LCD_WR_DATAX(0X08);//原來是a

        LCD_WR_REG(0X3A);
        LCD_WR_DATAX(0X55);//16位模式
        LCD_WR_REG(0X2B);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X01);
        LCD_WR_DATAX(0X3F);

        LCD_WR_REG(0X2A);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X00);
        LCD_WR_DATAX(0X01);
        LCD_WR_DATAX(0XDF);
        delay_ms(120);
        LCD_WR_REG(0X29); 	 
    }else if(lcddev.id==0x5310)
    {
        LCD_WR_REG(0xED);
        LCD_WR_DATAX(0x01);
        LCD_WR_DATAX(0xFE);

        LCD_WR_REG(0xEE);
        LCD_WR_DATAX(0xDE);
        LCD_WR_DATAX(0x21);

        LCD_WR_REG(0xF1);
        LCD_WR_DATAX(0x01);
        LCD_WR_REG(0xDF);
        LCD_WR_DATAX(0x10);

        //VCOMvoltage//
        LCD_WR_REG(0xC4);
        LCD_WR_DATAX(0x8F); //5f

        LCD_WR_REG(0xC6);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xE2);
        LCD_WR_DATAX(0xE2);
        LCD_WR_DATAX(0xE2);
        LCD_WR_REG(0xBF);
        LCD_WR_DATAX(0xAA);

        LCD_WR_REG(0xB0);
        LCD_WR_DATAX(0x0D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x0D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x11);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x19);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x21);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x5D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x5D);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB1);
        LCD_WR_DATAX(0x80);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x8B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x96);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x02);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x03);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB4);
        LCD_WR_DATAX(0x8B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x96);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA1);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB5);
        LCD_WR_DATAX(0x02);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x03);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x04);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB6);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3F);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x5E);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x64);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x8C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xAC);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDC);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x70);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x90);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xEB);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDC);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xB8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xBA);
        LCD_WR_DATAX(0x24);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC1);
        LCD_WR_DATAX(0x20);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x54);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xFF);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC2);
        LCD_WR_DATAX(0x0A);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x04);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC3);
        LCD_WR_DATAX(0x3C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3A);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x39);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x37);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x36);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x32);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2F);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x29);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x26);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x24);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x24);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x23);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x36);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x32);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2F);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x29);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x26);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x24);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x24);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x23);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC4);
        LCD_WR_DATAX(0x62);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x05);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x84);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF0);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x18);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA4);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x18);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x50);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x0C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x17);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x95);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xE6);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC5);
        LCD_WR_DATAX(0x32);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x65);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x76);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC6);
        LCD_WR_DATAX(0x20);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x17);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x01);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xC9);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE0);
        LCD_WR_DATAX(0x16);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x1C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x21);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x36);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x46);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x52);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x64);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x7A);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x8B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB9);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC4);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xCA);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD9);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xE0);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE1);
        LCD_WR_DATAX(0x16);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x1C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x22);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x36);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x45);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x52);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x64);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x7A);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x8B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB9);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC4);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xCA);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xE0);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE2);
        LCD_WR_DATAX(0x05);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x0B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x1B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x34);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x4F);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x61);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x79);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x97);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA6);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD1);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD6);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDD);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);
        LCD_WR_REG(0xE3);
        LCD_WR_DATAX(0x05);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x1C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x33);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x50);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x62);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x78);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x97);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA6);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC7);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD1);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD5);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDD);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE4);
        LCD_WR_DATAX(0x01);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x01);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x02);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x2A);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x4B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x5D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x74);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x84);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x93);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xBE);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC4);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xCD);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDD);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);
        LCD_WR_REG(0xE5);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x02);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x29);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x3C);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x4B);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x5D);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x74);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x84);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x93);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xA2);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xB3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xBE);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xC4);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xCD);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xD3);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xDC);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xF3);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE6);
        LCD_WR_DATAX(0x11);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x34);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x56);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x76);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x77);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x66);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xBB);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x66);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x45);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x43);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE7);
        LCD_WR_DATAX(0x32);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x76);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x66);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x67);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x67);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x87);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xBB);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x77);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x56);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x23); 
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x33);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x45);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE8);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x87);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x77);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x66);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x88);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xAA);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0xBB);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x99);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x66);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x44);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x55);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xE9);
        LCD_WR_DATAX(0xAA);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0x00);
        LCD_WR_DATAX(0xAA);

        LCD_WR_REG(0xCF);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xF0);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x50);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xF3);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0xF9);
        LCD_WR_DATAX(0x06);
        LCD_WR_DATAX(0x10);
        LCD_WR_DATAX(0x29);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0x3A);
        LCD_WR_DATAX(0x55);	//66

        LCD_WR_REG(0x11);
        delay_ms(100);
        LCD_WR_REG(0x29);
        LCD_WR_REG(0x35);
        LCD_WR_DATAX(0x00);

        LCD_WR_REG(0x51);
        LCD_WR_DATAX(0xFF);
        LCD_WR_REG(0x53);
        LCD_WR_DATAX(0x2C);
        LCD_WR_REG(0x55);
        LCD_WR_DATAX(0x82);
        LCD_WR_REG(0x2c); 
    }else if(lcddev.id==0x5510)
    {
        LCD_WriteReg(0xF000,0x55);
        LCD_WriteReg(0xF001,0xAA);
        LCD_WriteReg(0xF002,0x52);
        LCD_WriteReg(0xF003,0x08);
        LCD_WriteReg(0xF004,0x01);
        //AVDD Set AVDD 5.2V
        LCD_WriteReg(0xB000,0x0D);
        LCD_WriteReg(0xB001,0x0D);
        LCD_WriteReg(0xB002,0x0D);
        //AVDD ratio
        LCD_WriteReg(0xB600,0x34);
        LCD_WriteReg(0xB601,0x34);
        LCD_WriteReg(0xB602,0x34);
        //AVEE -5.2V
        LCD_WriteReg(0xB100,0x0D);
        LCD_WriteReg(0xB101,0x0D);
        LCD_WriteReg(0xB102,0x0D);
        //AVEE ratio
        LCD_WriteReg(0xB700,0x34);
        LCD_WriteReg(0xB701,0x34);
        LCD_WriteReg(0xB702,0x34);
        //VCL -2.5V
        LCD_WriteReg(0xB200,0x00);
        LCD_WriteReg(0xB201,0x00);
        LCD_WriteReg(0xB202,0x00);
        //VCL ratio
        LCD_WriteReg(0xB800,0x24);
        LCD_WriteReg(0xB801,0x24);
        LCD_WriteReg(0xB802,0x24);
        //VGH 15V (Free pump)
        LCD_WriteReg(0xBF00,0x01);
        LCD_WriteReg(0xB300,0x0F);
        LCD_WriteReg(0xB301,0x0F);
        LCD_WriteReg(0xB302,0x0F);
        //VGH ratio
        LCD_WriteReg(0xB900,0x34);
        LCD_WriteReg(0xB901,0x34);
        LCD_WriteReg(0xB902,0x34);
        //VGL_REG -10V
        LCD_WriteReg(0xB500,0x08);
        LCD_WriteReg(0xB501,0x08);
        LCD_WriteReg(0xB502,0x08);
        LCD_WriteReg(0xC200,0x03);
        //VGLX ratio
        LCD_WriteReg(0xBA00,0x24);
        LCD_WriteReg(0xBA01,0x24);
        LCD_WriteReg(0xBA02,0x24);
        //VGMP/VGSP 4.5V/0V
        LCD_WriteReg(0xBC00,0x00);
        LCD_WriteReg(0xBC01,0x78);
        LCD_WriteReg(0xBC02,0x00);
        //VGMN/VGSN -4.5V/0V
        LCD_WriteReg(0xBD00,0x00);
        LCD_WriteReg(0xBD01,0x78);
        LCD_WriteReg(0xBD02,0x00);
        //VCOM
        LCD_WriteReg(0xBE00,0x00);
        LCD_WriteReg(0xBE01,0x64);
        //Gamma Setting
        LCD_WriteReg(0xD100,0x00);
        LCD_WriteReg(0xD101,0x33);
        LCD_WriteReg(0xD102,0x00);
        LCD_WriteReg(0xD103,0x34);
        LCD_WriteReg(0xD104,0x00);
        LCD_WriteReg(0xD105,0x3A);
        LCD_WriteReg(0xD106,0x00);
        LCD_WriteReg(0xD107,0x4A);
        LCD_WriteReg(0xD108,0x00);
        LCD_WriteReg(0xD109,0x5C);
        LCD_WriteReg(0xD10A,0x00);
        LCD_WriteReg(0xD10B,0x81);
        LCD_WriteReg(0xD10C,0x00);
        LCD_WriteReg(0xD10D,0xA6);
        LCD_WriteReg(0xD10E,0x00);
        LCD_WriteReg(0xD10F,0xE5);
        LCD_WriteReg(0xD110,0x01);
        LCD_WriteReg(0xD111,0x13);
        LCD_WriteReg(0xD112,0x01);
        LCD_WriteReg(0xD113,0x54);
        LCD_WriteReg(0xD114,0x01);
        LCD_WriteReg(0xD115,0x82);
        LCD_WriteReg(0xD116,0x01);
        LCD_WriteReg(0xD117,0xCA);
        LCD_WriteReg(0xD118,0x02);
        LCD_WriteReg(0xD119,0x00);
        LCD_WriteReg(0xD11A,0x02);
        LCD_WriteReg(0xD11B,0x01);
        LCD_WriteReg(0xD11C,0x02);
        LCD_WriteReg(0xD11D,0x34);
        LCD_WriteReg(0xD11E,0x02);
        LCD_WriteReg(0xD11F,0x67);
        LCD_WriteReg(0xD120,0x02);
        LCD_WriteReg(0xD121,0x84);
        LCD_WriteReg(0xD122,0x02);
        LCD_WriteReg(0xD123,0xA4);
        LCD_WriteReg(0xD124,0x02);
        LCD_WriteReg(0xD125,0xB7);
        LCD_WriteReg(0xD126,0x02);
        LCD_WriteReg(0xD127,0xCF);
        LCD_WriteReg(0xD128,0x02);
        LCD_WriteReg(0xD129,0xDE);
        LCD_WriteReg(0xD12A,0x02);
        LCD_WriteReg(0xD12B,0xF2);
        LCD_WriteReg(0xD12C,0x02);
        LCD_WriteReg(0xD12D,0xFE);
        LCD_WriteReg(0xD12E,0x03);
        LCD_WriteReg(0xD12F,0x10);
        LCD_WriteReg(0xD130,0x03);
        LCD_WriteReg(0xD131,0x33);
        LCD_WriteReg(0xD132,0x03);
        LCD_WriteReg(0xD133,0x6D);
        LCD_WriteReg(0xD200,0x00);
        LCD_WriteReg(0xD201,0x33);
        LCD_WriteReg(0xD202,0x00);
        LCD_WriteReg(0xD203,0x34);
        LCD_WriteReg(0xD204,0x00);
        LCD_WriteReg(0xD205,0x3A);
        LCD_WriteReg(0xD206,0x00);
        LCD_WriteReg(0xD207,0x4A);
        LCD_WriteReg(0xD208,0x00);
        LCD_WriteReg(0xD209,0x5C);
        LCD_WriteReg(0xD20A,0x00);

        LCD_WriteReg(0xD20B,0x81);
        LCD_WriteReg(0xD20C,0x00);
        LCD_WriteReg(0xD20D,0xA6);
        LCD_WriteReg(0xD20E,0x00);
        LCD_WriteReg(0xD20F,0xE5);
        LCD_WriteReg(0xD210,0x01);
        LCD_WriteReg(0xD211,0x13);
        LCD_WriteReg(0xD212,0x01);
        LCD_WriteReg(0xD213,0x54);
        LCD_WriteReg(0xD214,0x01);
        LCD_WriteReg(0xD215,0x82);
        LCD_WriteReg(0xD216,0x01);
        LCD_WriteReg(0xD217,0xCA);
        LCD_WriteReg(0xD218,0x02);
        LCD_WriteReg(0xD219,0x00);
        LCD_WriteReg(0xD21A,0x02);
        LCD_WriteReg(0xD21B,0x01);
        LCD_WriteReg(0xD21C,0x02);
        LCD_WriteReg(0xD21D,0x34);
        LCD_WriteReg(0xD21E,0x02);
        LCD_WriteReg(0xD21F,0x67);
        LCD_WriteReg(0xD220,0x02);
        LCD_WriteReg(0xD221,0x84);
        LCD_WriteReg(0xD222,0x02);
        LCD_WriteReg(0xD223,0xA4);
        LCD_WriteReg(0xD224,0x02);
        LCD_WriteReg(0xD225,0xB7);
        LCD_WriteReg(0xD226,0x02);
        LCD_WriteReg(0xD227,0xCF);
        LCD_WriteReg(0xD228,0x02);
        LCD_WriteReg(0xD229,0xDE);
        LCD_WriteReg(0xD22A,0x02);
        LCD_WriteReg(0xD22B,0xF2);
        LCD_WriteReg(0xD22C,0x02);
        LCD_WriteReg(0xD22D,0xFE);
        LCD_WriteReg(0xD22E,0x03);
        LCD_WriteReg(0xD22F,0x10);
        LCD_WriteReg(0xD230,0x03);
        LCD_WriteReg(0xD231,0x33);
        LCD_WriteReg(0xD232,0x03);
        LCD_WriteReg(0xD233,0x6D);
        LCD_WriteReg(0xD300,0x00);
        LCD_WriteReg(0xD301,0x33);
        LCD_WriteReg(0xD302,0x00);
        LCD_WriteReg(0xD303,0x34);
        LCD_WriteReg(0xD304,0x00);
        LCD_WriteReg(0xD305,0x3A);
        LCD_WriteReg(0xD306,0x00);
        LCD_WriteReg(0xD307,0x4A);
        LCD_WriteReg(0xD308,0x00);
        LCD_WriteReg(0xD309,0x5C);
        LCD_WriteReg(0xD30A,0x00);

        LCD_WriteReg(0xD30B,0x81);
        LCD_WriteReg(0xD30C,0x00);
        LCD_WriteReg(0xD30D,0xA6);
        LCD_WriteReg(0xD30E,0x00);
        LCD_WriteReg(0xD30F,0xE5);
        LCD_WriteReg(0xD310,0x01);
        LCD_WriteReg(0xD311,0x13);
        LCD_WriteReg(0xD312,0x01);
        LCD_WriteReg(0xD313,0x54);
        LCD_WriteReg(0xD314,0x01);
        LCD_WriteReg(0xD315,0x82);
        LCD_WriteReg(0xD316,0x01);
        LCD_WriteReg(0xD317,0xCA);
        LCD_WriteReg(0xD318,0x02);
        LCD_WriteReg(0xD319,0x00);
        LCD_WriteReg(0xD31A,0x02);
        LCD_WriteReg(0xD31B,0x01);
        LCD_WriteReg(0xD31C,0x02);
        LCD_WriteReg(0xD31D,0x34);
        LCD_WriteReg(0xD31E,0x02);
        LCD_WriteReg(0xD31F,0x67);
        LCD_WriteReg(0xD320,0x02);
        LCD_WriteReg(0xD321,0x84);
        LCD_WriteReg(0xD322,0x02);
        LCD_WriteReg(0xD323,0xA4);
        LCD_WriteReg(0xD324,0x02);
        LCD_WriteReg(0xD325,0xB7);
        LCD_WriteReg(0xD326,0x02);
        LCD_WriteReg(0xD327,0xCF);
        LCD_WriteReg(0xD328,0x02);
        LCD_WriteReg(0xD329,0xDE);
        LCD_WriteReg(0xD32A,0x02);
        LCD_WriteReg(0xD32B,0xF2);
        LCD_WriteReg(0xD32C,0x02);
        LCD_WriteReg(0xD32D,0xFE);
        LCD_WriteReg(0xD32E,0x03);
        LCD_WriteReg(0xD32F,0x10);
        LCD_WriteReg(0xD330,0x03);
        LCD_WriteReg(0xD331,0x33);
        LCD_WriteReg(0xD332,0x03);
        LCD_WriteReg(0xD333,0x6D);
        LCD_WriteReg(0xD400,0x00);
        LCD_WriteReg(0xD401,0x33);
        LCD_WriteReg(0xD402,0x00);
        LCD_WriteReg(0xD403,0x34);
        LCD_WriteReg(0xD404,0x00);
        LCD_WriteReg(0xD405,0x3A);
        LCD_WriteReg(0xD406,0x00);
        LCD_WriteReg(0xD407,0x4A);
        LCD_WriteReg(0xD408,0x00);
        LCD_WriteReg(0xD409,0x5C);
        LCD_WriteReg(0xD40A,0x00);
        LCD_WriteReg(0xD40B,0x81);

        LCD_WriteReg(0xD40C,0x00);
        LCD_WriteReg(0xD40D,0xA6);
        LCD_WriteReg(0xD40E,0x00);
        LCD_WriteReg(0xD40F,0xE5);
        LCD_WriteReg(0xD410,0x01);
        LCD_WriteReg(0xD411,0x13);
        LCD_WriteReg(0xD412,0x01);
        LCD_WriteReg(0xD413,0x54);
        LCD_WriteReg(0xD414,0x01);
        LCD_WriteReg(0xD415,0x82);
        LCD_WriteReg(0xD416,0x01);
        LCD_WriteReg(0xD417,0xCA);
        LCD_WriteReg(0xD418,0x02);
        LCD_WriteReg(0xD419,0x00);
        LCD_WriteReg(0xD41A,0x02);
        LCD_WriteReg(0xD41B,0x01);
        LCD_WriteReg(0xD41C,0x02);
        LCD_WriteReg(0xD41D,0x34);
        LCD_WriteReg(0xD41E,0x02);
        LCD_WriteReg(0xD41F,0x67);
        LCD_WriteReg(0xD420,0x02);
        LCD_WriteReg(0xD421,0x84);
        LCD_WriteReg(0xD422,0x02);
        LCD_WriteReg(0xD423,0xA4);
        LCD_WriteReg(0xD424,0x02);
        LCD_WriteReg(0xD425,0xB7);
        LCD_WriteReg(0xD426,0x02);
        LCD_WriteReg(0xD427,0xCF);
        LCD_WriteReg(0xD428,0x02);
        LCD_WriteReg(0xD429,0xDE);
        LCD_WriteReg(0xD42A,0x02);
        LCD_WriteReg(0xD42B,0xF2);
        LCD_WriteReg(0xD42C,0x02);
        LCD_WriteReg(0xD42D,0xFE);
        LCD_WriteReg(0xD42E,0x03);
        LCD_WriteReg(0xD42F,0x10);
        LCD_WriteReg(0xD430,0x03);
        LCD_WriteReg(0xD431,0x33);
        LCD_WriteReg(0xD432,0x03);
        LCD_WriteReg(0xD433,0x6D);
        LCD_WriteReg(0xD500,0x00);
        LCD_WriteReg(0xD501,0x33);
        LCD_WriteReg(0xD502,0x00);
        LCD_WriteReg(0xD503,0x34);
        LCD_WriteReg(0xD504,0x00);
        LCD_WriteReg(0xD505,0x3A);
        LCD_WriteReg(0xD506,0x00);
        LCD_WriteReg(0xD507,0x4A);
        LCD_WriteReg(0xD508,0x00);
        LCD_WriteReg(0xD509,0x5C);
        LCD_WriteReg(0xD50A,0x00);
        LCD_WriteReg(0xD50B,0x81);

        LCD_WriteReg(0xD50C,0x00);
        LCD_WriteReg(0xD50D,0xA6);
        LCD_WriteReg(0xD50E,0x00);
        LCD_WriteReg(0xD50F,0xE5);
        LCD_WriteReg(0xD510,0x01);
        LCD_WriteReg(0xD511,0x13);
        LCD_WriteReg(0xD512,0x01);
        LCD_WriteReg(0xD513,0x54);
        LCD_WriteReg(0xD514,0x01);
        LCD_WriteReg(0xD515,0x82);
        LCD_WriteReg(0xD516,0x01);
        LCD_WriteReg(0xD517,0xCA);
        LCD_WriteReg(0xD518,0x02);
        LCD_WriteReg(0xD519,0x00);
        LCD_WriteReg(0xD51A,0x02);
        LCD_WriteReg(0xD51B,0x01);
        LCD_WriteReg(0xD51C,0x02);
        LCD_WriteReg(0xD51D,0x34);
        LCD_WriteReg(0xD51E,0x02);
        LCD_WriteReg(0xD51F,0x67);
        LCD_WriteReg(0xD520,0x02);
        LCD_WriteReg(0xD521,0x84);
        LCD_WriteReg(0xD522,0x02);
        LCD_WriteReg(0xD523,0xA4);
        LCD_WriteReg(0xD524,0x02);
        LCD_WriteReg(0xD525,0xB7);
        LCD_WriteReg(0xD526,0x02);
        LCD_WriteReg(0xD527,0xCF);
        LCD_WriteReg(0xD528,0x02);
        LCD_WriteReg(0xD529,0xDE);
        LCD_WriteReg(0xD52A,0x02);
        LCD_WriteReg(0xD52B,0xF2);
        LCD_WriteReg(0xD52C,0x02);
        LCD_WriteReg(0xD52D,0xFE);
        LCD_WriteReg(0xD52E,0x03);
        LCD_WriteReg(0xD52F,0x10);
        LCD_WriteReg(0xD530,0x03);
        LCD_WriteReg(0xD531,0x33);
        LCD_WriteReg(0xD532,0x03);
        LCD_WriteReg(0xD533,0x6D);
        LCD_WriteReg(0xD600,0x00);
        LCD_WriteReg(0xD601,0x33);
        LCD_WriteReg(0xD602,0x00);
        LCD_WriteReg(0xD603,0x34);
        LCD_WriteReg(0xD604,0x00);
        LCD_WriteReg(0xD605,0x3A);
        LCD_WriteReg(0xD606,0x00);
        LCD_WriteReg(0xD607,0x4A);
        LCD_WriteReg(0xD608,0x00);
        LCD_WriteReg(0xD609,0x5C);
        LCD_WriteReg(0xD60A,0x00);
        LCD_WriteReg(0xD60B,0x81);

        LCD_WriteReg(0xD60C,0x00);
        LCD_WriteReg(0xD60D,0xA6);
        LCD_WriteReg(0xD60E,0x00);
        LCD_WriteReg(0xD60F,0xE5);
        LCD_WriteReg(0xD610,0x01);
        LCD_WriteReg(0xD611,0x13);
        LCD_WriteReg(0xD612,0x01);
        LCD_WriteReg(0xD613,0x54);
        LCD_WriteReg(0xD614,0x01);
        LCD_WriteReg(0xD615,0x82);
        LCD_WriteReg(0xD616,0x01);
        LCD_WriteReg(0xD617,0xCA);
        LCD_WriteReg(0xD618,0x02);
        LCD_WriteReg(0xD619,0x00);
        LCD_WriteReg(0xD61A,0x02);
        LCD_WriteReg(0xD61B,0x01);
        LCD_WriteReg(0xD61C,0x02);
        LCD_WriteReg(0xD61D,0x34);
        LCD_WriteReg(0xD61E,0x02);
        LCD_WriteReg(0xD61F,0x67);
        LCD_WriteReg(0xD620,0x02);
        LCD_WriteReg(0xD621,0x84);
        LCD_WriteReg(0xD622,0x02);
        LCD_WriteReg(0xD623,0xA4);
        LCD_WriteReg(0xD624,0x02);
        LCD_WriteReg(0xD625,0xB7);
        LCD_WriteReg(0xD626,0x02);
        LCD_WriteReg(0xD627,0xCF);
        LCD_WriteReg(0xD628,0x02);
        LCD_WriteReg(0xD629,0xDE);
        LCD_WriteReg(0xD62A,0x02);
        LCD_WriteReg(0xD62B,0xF2);
        LCD_WriteReg(0xD62C,0x02);
        LCD_WriteReg(0xD62D,0xFE);
        LCD_WriteReg(0xD62E,0x03);
        LCD_WriteReg(0xD62F,0x10);
        LCD_WriteReg(0xD630,0x03);
        LCD_WriteReg(0xD631,0x33);
        LCD_WriteReg(0xD632,0x03);
        LCD_WriteReg(0xD633,0x6D);
        //LV2 Page 0 enable
        LCD_WriteReg(0xF000,0x55);
        LCD_WriteReg(0xF001,0xAA);
        LCD_WriteReg(0xF002,0x52);
        LCD_WriteReg(0xF003,0x08);
        LCD_WriteReg(0xF004,0x00);
        //Display control
        LCD_WriteReg(0xB100, 0xCC);
        LCD_WriteReg(0xB101, 0x00);
        //Source hold time
        LCD_WriteReg(0xB600,0x05);
        //Gate EQ control
        LCD_WriteReg(0xB700,0x70);
        LCD_WriteReg(0xB701,0x70);
        //Source EQ control (Mode 2)
        LCD_WriteReg(0xB800,0x01);
        LCD_WriteReg(0xB801,0x03);
        LCD_WriteReg(0xB802,0x03);
        LCD_WriteReg(0xB803,0x03);
        //Inversion mode (2-dot)
        LCD_WriteReg(0xBC00,0x02);
        LCD_WriteReg(0xBC01,0x00);
        LCD_WriteReg(0xBC02,0x00);
        //Timing control 4H w/ 4-delay
        LCD_WriteReg(0xC900,0xD0);
        LCD_WriteReg(0xC901,0x02);
        LCD_WriteReg(0xC902,0x50);
        LCD_WriteReg(0xC903,0x50);
        LCD_WriteReg(0xC904,0x50);
        LCD_WriteReg(0x3500,0x00);
        LCD_WriteReg(0x3A00,0x55);  //16-bit/pixel
        LCD_WR_REG(0x1100);
        delay_us(120);
        LCD_WR_REG(0x2900);
//  }else if(lcddev.id==0x9325)//9325
//  {
//    __LCD_Reset_DISABLE();  
//    delay_ms(1);         // Delay 1ms  
//    __LCD_Reset_ENABLE();  
//    delay_ms(20);        // Delay 10ms // This Delay time is necessary  
//    __LCD_Reset_DISABLE();  
//    delay_ms(20);        // Delay 50 ms

////************* Start Initial Sequence **********//
//    LCD_WriteReg(0x00E5, 0x8000); // Set uint16_ternal timing  
//    LCD_WriteReg(0x0000, 0x0001); // Set uint16_ternal timing  
//    LCD_WriteReg(0x0001, 0x0100); // set SS and SM bit  
//    LCD_WriteReg(0x0002, 0x0700); // set 1 line inversion  

////    LCD_WriteReg(0x0003, 0x1030); // 
////    LCD_WriteReg(0x0003, 0x1030); // ColorBar OK
////    LCD_WriteReg(0x0003, 0x1030); // Location OK  

//    LCD_WriteReg(0x0003, 0x5030); // set GRAM write direction and BGR=1.  
//    LCD_WriteReg(0x0004, 0x0000); // Resize register  
//    LCD_WriteReg(0x0008, 0x0404); // Ver1. set the back porch and front porch  
//    LCD_WriteReg(0x0009, 0x000F); // set non-display area refresh cycle ISC[3:0]  
//    LCD_WriteReg(0x000A, 0x0000); // FMARK function  
//    //Ili9320_CtrlWrite(0x000C, 0x0001); // RGB uint16_terface setting  
//    LCD_WriteReg(0x000C, 0x0000); // RGB uint16_terface setting  
//    LCD_WriteReg(0x000D, 0x0000); // Frame marker Position  
//    LCD_WriteReg(0x000F, 0x0000); // RGB uint16_terface polarity  
////*************Power On sequence ****************//  
//    LCD_WriteReg(0x0010, 0x0000); // SAP, BT[3:0], AP, DSTB, SLP, STB  
//    LCD_WriteReg(0x0011, 0x0007); // DC1[2:0], DC0[2:0], VC[2:0]  
//    LCD_WriteReg(0x0012, 0x0000); // VREG1OUT voltage  
//    LCD_WriteReg(0x0013, 0x0000); // VDV[4:0] for VCOM amplitude  
//    delay_ms(200);              // Dis-charge capacitor power voltage  
//    LCD_WriteReg(0x0010, 0x17B0); // SAP, BT[3:0], AP, DSTB, SLP, STB  
//    LCD_WriteReg(0x0011, 0x0037); // R11h=0x0221 at VCI=3.3V, DC1[2:0], DC0[2:0], VC[2:0]  
//    delay_ms(50);               // Delay 50ms  
//    LCD_WriteReg(0x0012, 0x013A); // External reference voltage= Vci;  
//    delay_ms(50);               // Delay 50ms  
//    LCD_WriteReg(0x0013, 0x1600); // R13=0F00 when R12=009E;VDV[4:0] for VCOM amplitude  
//    LCD_WriteReg(0x0029, 0x000C); // R29=0019 when R12=009E;VCM[5:0] for VCOMH 
//    delay_ms(50);               // Delay 50ms  
//    LCD_WriteReg(0x0020, 0x0000); // GRAM horizontal Address  
//    LCD_WriteReg(0x0021, 0x0000); // GRAM Vertical Address  

//// ----------- Adjust the Gamma Curve ----------//  
//    LCD_WriteReg(0x0030, 0x0504);  
//    LCD_WriteReg(0x0031, 0x0703);  
//    LCD_WriteReg(0x0032, 0x0702);  
//    LCD_WriteReg(0x0035, 0x0101);  
//    LCD_WriteReg(0x0036, 0x0A1F);  
//    LCD_WriteReg(0x0037, 0x0504);  
//    LCD_WriteReg(0x0038, 0x0003);  
//    LCD_WriteReg(0x0039, 0x0706);  
//    LCD_WriteReg(0x003C, 0x0707);  
//    LCD_WriteReg(0x003D, 0x091F);  
////------------------ Set GRAM area ---------------//  
//    LCD_WriteReg(0x0050, 0x0000); // Horizontal GRAM Start Address  
//    LCD_WriteReg(0x0051, 0x00EF); // Horizontal GRAM End Address  
//    LCD_WriteReg(0x0052, 0x0000); // Vertical GRAM Start Address  
//    LCD_WriteReg(0x0053, 0x013F); // Vertical GRAM Start Address  
//    LCD_WriteReg(0x0060, 0x2700); // Gate Scan Line  
//    LCD_WriteReg(0x0061, 0x0001); // NDL,VLE, REV  
//    LCD_WriteReg(0x006A, 0x0000); // set scrolling line  
////-------------- Partial Display Control ---------//  
//    LCD_WriteReg(0x0080, 0x0000);  
//    LCD_WriteReg(0x0081, 0x0000);  
//    LCD_WriteReg(0x0082, 0x0000);  
//    LCD_WriteReg(0x0083, 0x0000);  
//    LCD_WriteReg(0x0084, 0x0000);  
//    LCD_WriteReg(0x0085, 0x0000);  
////-------------- Panel Control -------------------//  
//    LCD_WriteReg(0x0090, 0x0010);  
//    //LCD_WriteReg(0x0092, 0x0700);  
//    LCD_WriteReg(0x0092, 0x0000);  
//    LCD_WriteReg(0x0093, 0x0003);  
//    LCD_WriteReg(0x0095, 0x0110);  
//    LCD_WriteReg(0x0097, 0x0000);  
//    LCD_WriteReg(0x0098, 0x0000);  
//    LCD_WriteReg(0x0007, 0x0021); // 262K color and display ON
//    delay_ms(50);               // Delay 50ms 
//    LCD_WriteReg(0x0007, 0x0173); // 262K color and display ON

//    printf("        LCD Status is 0x%4X\n\r", Ili9320_ReadStatus());
//    lTemp16 = 0;
//    do{
//        printf("LCD Index is 0x%X, Value is 0x%X\n\r", lTemp16, Ili9320_CtrlRead(lTemp16, 4));
//    }while(++ lTemp16 < 0xFF);

    }else if(lcddev.id==0x9325)//9325
    {
        LCD_WriteReg(0x00E5,0x78F0); 
        LCD_WriteReg(0x0001,0x0000); 
        LCD_WriteReg(0x0002,0x0700); 
        LCD_WriteReg(0x0003,0x1030); 
        LCD_WriteReg(0x0004,0x0000); 
        LCD_WriteReg(0x0008,0x0202);  
        LCD_WriteReg(0x0009,0x0000);
        LCD_WriteReg(0x000A,0x0000); 
        LCD_WriteReg(0x000C,0x0000); 
        LCD_WriteReg(0x000D,0x0000);
        LCD_WriteReg(0x000F,0x0000);
        //power on sequence VGHVGL
        LCD_WriteReg(0x0010,0x0000);   
        LCD_WriteReg(0x0011,0x0007);  
        LCD_WriteReg(0x0012,0x0000);  
        LCD_WriteReg(0x0013,0x0000); 
        LCD_WriteReg(0x0007,0x0000); 
        //vgh 
        LCD_WriteReg(0x0010,0x1690);   
        LCD_WriteReg(0x0011,0x0227);
        //delayms(100);
        //vregiout 
        LCD_WriteReg(0x0012,0x009D); //0x001b
        //delayms(100); 
        //vom amplitude
        LCD_WriteReg(0x0013,0x1900);
        //delayms(100); 
        //vom H
        LCD_WriteReg(0x0029,0x0025); 
        LCD_WriteReg(0x002B,0x000D); 
        //gamma
        LCD_WriteReg(0x0030,0x0007);
        LCD_WriteReg(0x0031,0x0303);
        LCD_WriteReg(0x0032,0x0003);// 0006
        LCD_WriteReg(0x0035,0x0206);
        LCD_WriteReg(0x0036,0x0008);
        LCD_WriteReg(0x0037,0x0406); 
        LCD_WriteReg(0x0038,0x0304);//0200
        LCD_WriteReg(0x0039,0x0007); 
        LCD_WriteReg(0x003C,0x0602);// 0504
        LCD_WriteReg(0x003D,0x0008); 
        //ram
        LCD_WriteReg(0x0050,0x0000); 
        LCD_WriteReg(0x0051,0x00EF);
        LCD_WriteReg(0x0052,0x0000); 
        LCD_WriteReg(0x0053,0x013F);  
        LCD_WriteReg(0x0060,0x2700); 
        LCD_WriteReg(0x0061,0x0001); 
        LCD_WriteReg(0x006A,0x0000); 
        //
        LCD_WriteReg(0x0080,0x0000); 
        LCD_WriteReg(0x0081,0x0000); 
        LCD_WriteReg(0x0082,0x0000); 
        LCD_WriteReg(0x0083,0x0000); 
        LCD_WriteReg(0x0084,0x0000); 
        LCD_WriteReg(0x0085,0x0000); 
        //
        LCD_WriteReg(0x0090,0x0010); 
        LCD_WriteReg(0x0092,0x0600); 
        
        LCD_WriteReg(0x0007,0x0133);
        LCD_WriteReg(0x00,0x0022);//
    }else if(lcddev.id==0x9328)//ILI9328   OK  
    {
        LCD_WriteReg(0x00EC,0x108F);// internal timeing      
        LCD_WriteReg(0x00EF,0x1234);// ADD        
        //LCD_WriteReg(0x00e7,0x0010);      
        //LCD_WriteReg(0x0000,0x0001);//開啟內部時鐘
        LCD_WriteReg(0x0001,0x0000);     
        LCD_WriteReg(0x0002,0x0700);//電源開啟
        //LCD_WriteReg(0x0003,(1<<3)|(1<<4) ); 	//65K  RGB
        //DRIVE TABLE(寄存器 03H)
        //BIT3=AM BIT4:5=ID0:1
        //AM ID0 ID1   FUNCATION
        // 0  0   0	   R->L D->U
        // 1  0   0	   D->U	R->L
        // 0  1   0	   L->R D->U
        // 1  1   0    D->U	L->R
        // 0  0   1	   R->L U->D
        // 1  0   1    U->D	R->L
        // 0  1   1    L->R U->D    正常就用這個?
        // 1  1   1	   U->D	L->R
        LCD_WriteReg(0x0003,(1<<12)|(3<<4)|(0<<3) );//65K
        LCD_WriteReg(0x0004,0x0000);
        LCD_WriteReg(0x0008,0x0202);
        LCD_WriteReg(0x0009,0x0000);
        LCD_WriteReg(0x000a,0x0000);//display setting
        LCD_WriteReg(0x000c,0x0001);//display setting
        LCD_WriteReg(0x000d,0x0000);//0f3c
        LCD_WriteReg(0x000f,0x0000);
        //電源配置
        LCD_WriteReg(0x0010,0x0000);
        LCD_WriteReg(0x0011,0x0007);
        LCD_WriteReg(0x0012,0x0000);
        LCD_WriteReg(0x0013,0x0000);
        LCD_WriteReg(0x0007,0x0001);
        delay_ms(50); 
        LCD_WriteReg(0x0010,0x1490);
        LCD_WriteReg(0x0011,0x0227);
        delay_ms(50); 
        LCD_WriteReg(0x0012,0x008A);
        delay_ms(50); 
        LCD_WriteReg(0x0013,0x1a00);
        LCD_WriteReg(0x0029,0x0006);
        LCD_WriteReg(0x002b,0x000d);
        delay_ms(50); 
        LCD_WriteReg(0x0020,0x0000);
        LCD_WriteReg(0x0021,0x0000);
        delay_ms(50); 
        //伽馬校正
        LCD_WriteReg(0x0030,0x0000); 
        LCD_WriteReg(0x0031,0x0604);   
        LCD_WriteReg(0x0032,0x0305);
        LCD_WriteReg(0x0035,0x0000);
        LCD_WriteReg(0x0036,0x0C09); 
        LCD_WriteReg(0x0037,0x0204);
        LCD_WriteReg(0x0038,0x0301);        
        LCD_WriteReg(0x0039,0x0707);     
        LCD_WriteReg(0x003c,0x0000);
        LCD_WriteReg(0x003d,0x0a0a);
        delay_ms(50); 
        LCD_WriteReg(0x0050,0x0000); //水平GRAM起始位置
        LCD_WriteReg(0x0051,0x00ef); //水平GRAM終止位置
        LCD_WriteReg(0x0052,0x0000); //垂直GRAM起始位置
        LCD_WriteReg(0x0053,0x013f); //垂直GRAM終止位置

        LCD_WriteReg(0x0060,0x2700);
        LCD_WriteReg(0x0061,0x0001);
        LCD_WriteReg(0x006a,0x0000);
        LCD_WriteReg(0x0080,0x0000);
        LCD_WriteReg(0x0081,0x0000);
        LCD_WriteReg(0x0082,0x0000);
        LCD_WriteReg(0x0083,0x0000);
        LCD_WriteReg(0x0084,0x0000);
        LCD_WriteReg(0x0085,0x0000);

        LCD_WriteReg(0x0090,0x0010);
        LCD_WriteReg(0x0092,0x0600);
        //開啟顯示設置
        LCD_WriteReg(0x0007,0x0133);
    }else if(lcddev.id==0x9325)//9325
    {
        LCD_WriteReg(0x00E5,0x78F0);
        LCD_WriteReg(0x0001,0x0100);
        LCD_WriteReg(0x0002,0x0700);
        LCD_WriteReg(0x0003,0x1030);
        LCD_WriteReg(0x0004,0x0000);
        LCD_WriteReg(0x0008,0x0202);
        LCD_WriteReg(0x0009,0x0000);
        LCD_WriteReg(0x000A,0x0000);
        LCD_WriteReg(0x000C,0x0000);
        LCD_WriteReg(0x000D,0x0000);
        LCD_WriteReg(0x000F,0x0000);
        //power on sequence VGHVGL
        LCD_WriteReg(0x0010,0x0000);
        LCD_WriteReg(0x0011,0x0007);
        LCD_WriteReg(0x0012,0x0000);
        LCD_WriteReg(0x0013,0x0000);
        LCD_WriteReg(0x0007,0x0000);
        //vgh 
        LCD_WriteReg(0x0010,0x1690);
        LCD_WriteReg(0x0011,0x0227);
        //delayms(100);
        //vregiout 
        LCD_WriteReg(0x0012,0x009D);                //0x001b
        //delayms(100); 
        //vom amplitude
        LCD_WriteReg(0x0013,0x1900);
        //delayms(100); 
        //vom H
        LCD_WriteReg(0x0029,0x0025); 
        LCD_WriteReg(0x002B,0x000D); 
        //gamma
        LCD_WriteReg(0x0030,0x0007);
        LCD_WriteReg(0x0031,0x0303);
        LCD_WriteReg(0x0032,0x0003);                // 0006
        LCD_WriteReg(0x0035,0x0206);
        LCD_WriteReg(0x0036,0x0008);
        LCD_WriteReg(0x0037,0x0406); 
        LCD_WriteReg(0x0038,0x0304);                //0200
        LCD_WriteReg(0x0039,0x0007); 
        LCD_WriteReg(0x003C,0x0602);                // 0504
        LCD_WriteReg(0x003D,0x0008); 
        //ram
        LCD_WriteReg(0x0050,0x0000); 
        LCD_WriteReg(0x0051,0x00EF);
        LCD_WriteReg(0x0052,0x0000); 
        LCD_WriteReg(0x0053,0x013F);  
        LCD_WriteReg(0x0060,0xA700); 
        LCD_WriteReg(0x0061,0x0001); 
        LCD_WriteReg(0x006A,0x0000); 
        //
        LCD_WriteReg(0x0080,0x0000); 
        LCD_WriteReg(0x0081,0x0000); 
        LCD_WriteReg(0x0082,0x0000); 
        LCD_WriteReg(0x0083,0x0000); 
        LCD_WriteReg(0x0084,0x0000); 
        LCD_WriteReg(0x0085,0x0000); 
        //
        LCD_WriteReg(0x0090,0x0010); 
        LCD_WriteReg(0x0092,0x0600); 
        
        LCD_WriteReg(0x0007,0x0133);
        LCD_WriteReg(0x00,0x0022);//
    }else if(lcddev.id==0x9328)                     //ILI9328   OK  
    {
        LCD_WriteReg(0x00EC,0x108F);                // internal timeing
        LCD_WriteReg(0x00EF,0x1234);                // ADD
        //LCD_WriteReg(0x00e7,0x0010);
        //LCD_WriteReg(0x0000,0x0001);              //開啟內部時鐘
        LCD_WriteReg(0x0001,0x0100);
        LCD_WriteReg(0x0002,0x0700);                //電源開啟
        //LCD_WriteReg(0x0003,(1<<3)|(1<<4) );      //65K  RGB
        //DRIVE TABLE(寄存器 03H)
        //BIT3=AM BIT4:5=ID0:1
        //AM ID0 ID1   FUNCATION
        // 0  0   0    R->L D->U
        // 1  0   0    D->U R->L
        // 0  1   0    L->R D->U
        // 1  1   0    D->U L->R
        // 0  0   1    R->L U->D
        // 1  0   1    U->D R->L
        // 0  1   1    L->R U->D                    正常就用這個.
        // 1  1   1    U->D L->R
        LCD_WriteReg(0x0003,(1<<12)|(3<<4)|(0<<3) );//65K    
        LCD_WriteReg(0x0004,0x0000);
        LCD_WriteReg(0x0008,0x0202);
        LCD_WriteReg(0x0009,0x0000);
        LCD_WriteReg(0x000a,0x0000);//display setting
        LCD_WriteReg(0x000c,0x0001);//display setting
        LCD_WriteReg(0x000d,0x0000);//0f3c
        LCD_WriteReg(0x000f,0x0000);
        //電源配置
        LCD_WriteReg(0x0010,0x0000);
        LCD_WriteReg(0x0011,0x0007);
        LCD_WriteReg(0x0012,0x0000);
        LCD_WriteReg(0x0013,0x0000);
        LCD_WriteReg(0x0007,0x0001);
        delay_ms(50); 
        LCD_WriteReg(0x0010,0x1490);
        LCD_WriteReg(0x0011,0x0227);
        delay_ms(50); 
        LCD_WriteReg(0x0012,0x008A);
        delay_ms(50); 
        LCD_WriteReg(0x0013,0x1a00);
        LCD_WriteReg(0x0029,0x0006);
        LCD_WriteReg(0x002b,0x000d);
        delay_ms(50); 
        LCD_WriteReg(0x0020,0x0000);
        LCD_WriteReg(0x0021,0x0000);
        delay_ms(50); 
        //伽馬校正
        LCD_WriteReg(0x0030,0x0000);
        LCD_WriteReg(0x0031,0x0604);
        LCD_WriteReg(0x0032,0x0305);
        LCD_WriteReg(0x0035,0x0000);
        LCD_WriteReg(0x0036,0x0C09);
        LCD_WriteReg(0x0037,0x0204);
        LCD_WriteReg(0x0038,0x0301);
        LCD_WriteReg(0x0039,0x0707);
        LCD_WriteReg(0x003c,0x0000);
        LCD_WriteReg(0x003d,0x0a0a);
        delay_ms(50); 
        LCD_WriteReg(0x0050,0x0000);        //水平GRAM起始位置
        LCD_WriteReg(0x0051,0x00ef);        //水平GRAM終止位置
        LCD_WriteReg(0x0052,0x0000);        //垂直GRAM起始位置
        LCD_WriteReg(0x0053,0x013f);        //垂直GRAM終止位置

         LCD_WriteReg(0x0060,0xa700);
        LCD_WriteReg(0x0061,0x0001);
        LCD_WriteReg(0x006a,0x0000);
        LCD_WriteReg(0x0080,0x0000);
        LCD_WriteReg(0x0081,0x0000);
        LCD_WriteReg(0x0082,0x0000);
        LCD_WriteReg(0x0083,0x0000);
        LCD_WriteReg(0x0084,0x0000);
        LCD_WriteReg(0x0085,0x0000);

        LCD_WriteReg(0x0090,0x0010);     
        LCD_WriteReg(0x0092,0x0600);  
        //開啟顯示設置
        LCD_WriteReg(0x0007,0x0133); 
    }else if(lcddev.id==0x9320)             //皜祈岫OK.
    {
        LCD_WriteReg(0x00,0x0000);
        LCD_WriteReg(0x01,0x0100);          //Driver Output Contral.
        LCD_WriteReg(0x02,0x0700);          //LCD Driver Waveform Contral.
        LCD_WriteReg(0x03,0x1030);          //Entry Mode Set.
        //LCD_WriteReg(0x03,0x1018);        //Entry Mode Set.

        LCD_WriteReg(0x04,0x0000);          //Scalling Contral.
        LCD_WriteReg(0x08,0x0202);          //Display Contral 2.(0x0207)
        LCD_WriteReg(0x09,0x0000);          //Display Contral 3.(0x0000)
        LCD_WriteReg(0x0a,0x0000);          //Frame Cycle Contal.(0x0000)
        LCD_WriteReg(0x0c,(1<<0));          //Extern Display Interface Contral 1.(0x0000)
        LCD_WriteReg(0x0d,0x0000);          //Frame Maker Position.
        LCD_WriteReg(0x0f,0x0000);          //Extern Display Interface Contral 2.
        delay_ms(50); 
        LCD_WriteReg(0x07,0x0101);          //Display Contral.
        delay_ms(50);
        LCD_WriteReg(0x10,(1<<12)|(0<<8)|(1<<7)|(1<<6)|(0<<4));	//Power Control 1.(0x16b0)
        LCD_WriteReg(0x11,0x0007);          //Power Control 2.(0x0001)
        LCD_WriteReg(0x12,(1<<8)|(1<<4)|(0<<0));        //Power Control 3.(0x0138)
        LCD_WriteReg(0x13,0x0b00);          //Power Control 4.
        LCD_WriteReg(0x29,0x0000);          //Power Control 7.

        LCD_WriteReg(0x2b,(1<<14)|(1<<4));
        LCD_WriteReg(0x50,0);               //Set X Star
        //水平GRAM終止位置Set X End.
        LCD_WriteReg(0x51,239);             //Set Y Star
        LCD_WriteReg(0x52,0);               //Set Y End.t.
        LCD_WriteReg(0x53,319);

        LCD_WriteReg(0x60,0x2700);          //Driver Output Control.
        LCD_WriteReg(0x61,0x0001);          //Driver Output Control.
        LCD_WriteReg(0x6a,0x0000);          //Vertical Srcoll Control.

        LCD_WriteReg(0x80,0x0000);          //Display Position? Partial Display 1.
        LCD_WriteReg(0x81,0x0000);          //RAM Address Start? Partial Display 1.
        LCD_WriteReg(0x82,0x0000);          //RAM Address End-Partial Display 1.
        LCD_WriteReg(0x83,0x0000);          //Displsy Position? Partial Display 2.
        LCD_WriteReg(0x84,0x0000);          //RAM Address Start? Partial Display 2.
        LCD_WriteReg(0x85,0x0000);          //RAM Address End? Partial Display 2.

        LCD_WriteReg(0x90,(0<<7)|(16<<0));  //Frame Cycle Contral.(0x0013)
        LCD_WriteReg(0x92,0x0000);          //Panel Interface Contral 2.(0x0000)
        LCD_WriteReg(0x93,0x0001);          //Panel Interface Contral 3.
        LCD_WriteReg(0x95,0x0110);          //Frame Cycle Contral.(0x0110)
        LCD_WriteReg(0x97,(0<<8));          //
        LCD_WriteReg(0x98,0x0000);          //Frame Cycle Contral.
        LCD_WriteReg(0x07,0x0173);          //(0x0173)
    }else if(lcddev.id==0X9331)             //OK |/|/|
    {
        LCD_WriteReg(0x00E7, 0x1014);
        LCD_WriteReg(0x0001, 0x0100);       // set SS and SM bit
        LCD_WriteReg(0x0002, 0x0200);       // set 1 line inversion
        LCD_WriteReg(0x0003,(1<<12)|(3<<4)|(1<<3));//65K
        //LCD_WriteReg(0x0003, 0x1030);     // set GRAM write direction and BGR=1.
        LCD_WriteReg(0x0008, 0x0202);       // set the back porch and front porch
        LCD_WriteReg(0x0009, 0x0000);       // set non-display area refresh cycle ISC[3:0]
        LCD_WriteReg(0x000A, 0x0000);       // FMARK function
        LCD_WriteReg(0x000C, 0x0000);       // RGB interface setting
        LCD_WriteReg(0x000D, 0x0000);       // Frame marker Position
        LCD_WriteReg(0x000F, 0x0000);       // RGB interface polarity
        //*************Power On sequence ****************//
        LCD_WriteReg(0x0010, 0x0000);       // SAP, BT[3:0], AP, DSTB, SLP, STB
        LCD_WriteReg(0x0011, 0x0007);       // DC1[2:0], DC0[2:0], VC[2:0]
        LCD_WriteReg(0x0012, 0x0000);       // VREG1OUT voltage
        LCD_WriteReg(0x0013, 0x0000);       // VDV[4:0] for VCOM amplitude
        delay_ms(200); // Dis-charge capacitor power voltage
        LCD_WriteReg(0x0010, 0x1690);       // SAP, BT[3:0], AP, DSTB, SLP, STB
        LCD_WriteReg(0x0011, 0x0227);       // DC1[2:0], DC0[2:0], VC[2:0]
        delay_ms(50); // Delay 50ms
        LCD_WriteReg(0x0012, 0x000C);       // Internal reference voltage= Vci;
        delay_ms(50); // Delay 50ms
        LCD_WriteReg(0x0013, 0x0800);       // Set VDV[4:0] for VCOM amplitude
        LCD_WriteReg(0x0029, 0x0011);       // Set VCM[5:0] for VCOMH
        LCD_WriteReg(0x002B, 0x000B);       // Set Frame Rate
        delay_ms(50); // Delay 50ms
        LCD_WriteReg(0x0020, 0x0000);       // GRAM horizontal Address
        LCD_WriteReg(0x0021, 0x013f);       // GRAM Vertical Address
        // ----------- Adjust the Gamma Curve ----------//
        LCD_WriteReg(0x0030, 0x0000);
        LCD_WriteReg(0x0031, 0x0106);
        LCD_WriteReg(0x0032, 0x0000);
        LCD_WriteReg(0x0035, 0x0204);
        LCD_WriteReg(0x0036, 0x160A);
        LCD_WriteReg(0x0037, 0x0707);
        LCD_WriteReg(0x0038, 0x0106);
        LCD_WriteReg(0x0039, 0x0707);
        LCD_WriteReg(0x003C, 0x0402);
        LCD_WriteReg(0x003D, 0x0C0F);
        //------------------ Set GRAM area ---------------//
        LCD_WriteReg(0x0050, 0x0000);       // Horizontal GRAM Start Address
        LCD_WriteReg(0x0051, 0x00EF);       // Horizontal GRAM End Address
        LCD_WriteReg(0x0052, 0x0000);       // Vertical GRAM Start Address
        LCD_WriteReg(0x0053, 0x013F);       // Vertical GRAM Start Address
        LCD_WriteReg(0x0060, 0x2700);       // Gate Scan Line
        LCD_WriteReg(0x0061, 0x0001);       // NDL,VLE, REV 
        LCD_WriteReg(0x006A, 0x0000);       // set scrolling line
        //-------------- Partial Display Control ---------//
        LCD_WriteReg(0x0080, 0x0000);
        LCD_WriteReg(0x0081, 0x0000);
        LCD_WriteReg(0x0082, 0x0000);
        LCD_WriteReg(0x0083, 0x0000);
        LCD_WriteReg(0x0084, 0x0000);
        LCD_WriteReg(0x0085, 0x0000);
        //-------------- Panel Control -------------------//
        LCD_WriteReg(0x0090, 0x0010);
        LCD_WriteReg(0x0092, 0x0600);
        LCD_WriteReg(0x0007, 0x0133);       // 262K color and display ON
    }else if(lcddev.id==0x5408)
    {
        LCD_WriteReg(0x01,0x0100);
        LCD_WriteReg(0x02,0x0700);//LCD Driving Waveform Contral 
        LCD_WriteReg(0x03,0x1030);//Entry Mode設置
        //指針從左至右自上而下的自動增模式
        //Normal Mode(Window Mode disable)
        //RGB?澆?
        //16位數據2次傳輸的8總線設置
        LCD_WriteReg(0x04,0x0000);      //Scalling Control register
        LCD_WriteReg(0x08,0x0207);      //Display Control 2
        LCD_WriteReg(0x09,0x0000);      //Display Control 3
        LCD_WriteReg(0x0A,0x0000);      //Frame Cycle Control
        LCD_WriteReg(0x0C,0x0000);      //External Display Interface Control 1
        LCD_WriteReg(0x0D,0x0000);      //Frame Maker Position
        LCD_WriteReg(0x0F,0x0000);      //External Display Interface Control 2
        delay_ms(20);
        //TFT 液晶彩色圖像顯示方法14
        LCD_WriteReg(0x10,0x16B0);      //0x14B0 //Power Control 1
        LCD_WriteReg(0x11,0x0001);      //0x0007 //Power Control 2
        LCD_WriteReg(0x17,0x0001);      //0x0000 //Power Control 3
        LCD_WriteReg(0x12,0x0138);      //0x013B //Power Control 4
        LCD_WriteReg(0x13,0x0800);      //0x0800 //Power Control 5
        LCD_WriteReg(0x29,0x0009);      //NVM read data 2
        LCD_WriteReg(0x2a,0x0009);      //NVM read data 3
        LCD_WriteReg(0xa4,0x0000);
        LCD_WriteReg(0x50,0x0000);      //設置操作窗口的X軸開始列
        LCD_WriteReg(0x51,0x00EF);      //設置操作窗口的X軸結束列
        LCD_WriteReg(0x52,0x0000);      //設置操作窗口的Y軸開始行
        LCD_WriteReg(0x53,0x013F);      //設置操作窗口的Y軸結束行
        LCD_WriteReg(0x60,0x2700);      //Driver Output Control
        //設置屏幕的點數以及掃描的起始行
        LCD_WriteReg(0x61,0x0001);      //Driver Output Control
        LCD_WriteReg(0x6A,0x0000);      //Vertical Scroll Control
        LCD_WriteReg(0x80,0x0000);      //Display Position ??Partial Display 1
        LCD_WriteReg(0x81,0x0000);      //RAM Address Start ??Partial Display 1
        LCD_WriteReg(0x82,0x0000);      //RAM address End - Partial Display 1
        LCD_WriteReg(0x83,0x0000);      //Display Position ??Partial Display 2
        LCD_WriteReg(0x84,0x0000);      //RAM Address Start ??Partial Display 2
        LCD_WriteReg(0x85,0x0000);      //RAM address End ??Partail Display2
        LCD_WriteReg(0x90,0x0013);      //Frame Cycle Control
        LCD_WriteReg(0x92,0x0000);      //Panel Interface Control 2
        LCD_WriteReg(0x93,0x0003);      //Panel Interface control 3
        LCD_WriteReg(0x95,0x0110);      //Frame Cycle Control
        LCD_WriteReg(0x07,0x0173);
        delay_ms(50);
    }else if(lcddev.id==0x1505)//OK
    {
        // second release on 3/5  ,luminance is acceptable,water wave appear during camera preview
        LCD_WriteReg(0x0007,0x0000);
        delay_ms(50); 
        LCD_WriteReg(0x0012,0x011C);    //0x011A   why need to set several times?
        LCD_WriteReg(0x00A4,0x0001);    //NVM
        LCD_WriteReg(0x0008,0x000F);
        LCD_WriteReg(0x000A,0x0008);
        LCD_WriteReg(0x000D,0x0008);
        //伽馬校正
        LCD_WriteReg(0x0030,0x0707);
        LCD_WriteReg(0x0031,0x0007);    //0x0707
        LCD_WriteReg(0x0032,0x0603);
        LCD_WriteReg(0x0033,0x0700);
        LCD_WriteReg(0x0034,0x0202);
        LCD_WriteReg(0x0035,0x0002);    //?0x0606
        LCD_WriteReg(0x0036,0x1F0F);
        LCD_WriteReg(0x0037,0x0707);    //0x0f0f  0x0105
        LCD_WriteReg(0x0038,0x0000);
        LCD_WriteReg(0x0039,0x0000);
        LCD_WriteReg(0x003A,0x0707);
        LCD_WriteReg(0x003B,0x0000);    //0x0303
        LCD_WriteReg(0x003C,0x0007);    //?0x0707
        LCD_WriteReg(0x003D,0x0000);    //0x1313//0x1f08
        delay_ms(50); 
        LCD_WriteReg(0x0007,0x0001);
        LCD_WriteReg(0x0017,0x0001);    //開啟電源
        delay_ms(50); 
        //電源配置
        LCD_WriteReg(0x0010,0x17A0);
        LCD_WriteReg(0x0011,0x0217);    //reference voltage VC[2:0]   Vciout = 1.00*Vcivl
        LCD_WriteReg(0x0012,0x011E);    //0x011c  //Vreg1out = Vcilvl*1.80   is it the same as Vgama1out ?
        LCD_WriteReg(0x0013,0x0F00);    //VDV[4:0]-->VCOM Amplitude VcomL = VcomH - Vcom Ampl
        LCD_WriteReg(0x002A,0x0000);
        LCD_WriteReg(0x0029,0x000A);    //0x0001F  Vcomh = VCM1[4:0]*Vreg1out    gate source voltage??
        LCD_WriteReg(0x0012,0x013E);    // 0x013C  power supply on
        //Coordinates Control//
        LCD_WriteReg(0x0050,0x0000);    //0x0e00
        LCD_WriteReg(0x0051,0x00EF);
        LCD_WriteReg(0x0052,0x0000);
        LCD_WriteReg(0x0053,0x013F);
        //Pannel Image Control//
        LCD_WriteReg(0x0060,0x2700);
        LCD_WriteReg(0x0061,0x0001);
        LCD_WriteReg(0x006A,0x0000);
        LCD_WriteReg(0x0080,0x0000);
        //Partial Image Control//
        LCD_WriteReg(0x0081,0x0000);
        LCD_WriteReg(0x0082,0x0000);
        LCD_WriteReg(0x0083,0x0000);
        LCD_WriteReg(0x0084,0x0000);
        LCD_WriteReg(0x0085,0x0000);
        //Panel Interface Control//
        LCD_WriteReg(0x0090,0x0013);    //0x0010 frenqucy
        LCD_WriteReg(0x0092,0x0300);
        LCD_WriteReg(0x0093,0x0005);
        LCD_WriteReg(0x0095,0x0000);
        LCD_WriteReg(0x0097,0x0000);
        LCD_WriteReg(0x0098,0x0000);
  
        LCD_WriteReg(0x0001,0x0100);
        LCD_WriteReg(0x0002,0x0700);
        LCD_WriteReg(0x0003,0x1038);    //掃描方向 上->下  左->右 
        LCD_WriteReg(0x0004,0x0000);
        LCD_WriteReg(0x000C,0x0000);
        LCD_WriteReg(0x000F,0x0000);
        LCD_WriteReg(0x0020,0x0000);
        LCD_WriteReg(0x0021,0x0000);
        LCD_WriteReg(0x0007,0x0021);
        delay_ms(20);
        LCD_WriteReg(0x0007,0x0061);
        delay_ms(20);
        LCD_WriteReg(0x0007,0x0173);
        delay_ms(20);
    }else if(lcddev.id==0xB505)
    {
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        
        LCD_WriteReg(0x00a4,0x0001);
        delay_ms(20);
        LCD_WriteReg(0x0060,0x2700);
        LCD_WriteReg(0x0008,0x0202);
        
        LCD_WriteReg(0x0030,0x0214);
        LCD_WriteReg(0x0031,0x3715);
        LCD_WriteReg(0x0032,0x0604);
        LCD_WriteReg(0x0033,0x0e16);
        LCD_WriteReg(0x0034,0x2211);
        LCD_WriteReg(0x0035,0x1500);
        LCD_WriteReg(0x0036,0x8507);
        LCD_WriteReg(0x0037,0x1407);
        LCD_WriteReg(0x0038,0x1403);
        LCD_WriteReg(0x0039,0x0020);
        
        LCD_WriteReg(0x0090,0x001a);
        LCD_WriteReg(0x0010,0x0000);
        LCD_WriteReg(0x0011,0x0007);
        LCD_WriteReg(0x0012,0x0000);
        LCD_WriteReg(0x0013,0x0000);
        delay_ms(20);
        
        LCD_WriteReg(0x0010,0x0730);
        LCD_WriteReg(0x0011,0x0137);
        delay_ms(20);
        
        LCD_WriteReg(0x0012,0x01b8);
        delay_ms(20);
        
        LCD_WriteReg(0x0013,0x0f00);
        LCD_WriteReg(0x002a,0x0080);
        LCD_WriteReg(0x0029,0x0048);
        delay_ms(20);
        
        LCD_WriteReg(0x0001,0x0100);
        LCD_WriteReg(0x0002,0x0700);
        LCD_WriteReg(0x0003,0x1038);    //掃描方向 上->下  左->右 
        LCD_WriteReg(0x0008,0x0202);
        LCD_WriteReg(0x000a,0x0000);
        LCD_WriteReg(0x000c,0x0000);
        LCD_WriteReg(0x000d,0x0000);
        LCD_WriteReg(0x000e,0x0030);
        LCD_WriteReg(0x0050,0x0000);
        LCD_WriteReg(0x0051,0x00ef);
        LCD_WriteReg(0x0052,0x0000);
        LCD_WriteReg(0x0053,0x013f);
        LCD_WriteReg(0x0060,0x2700);
        LCD_WriteReg(0x0061,0x0001);
        LCD_WriteReg(0x006a,0x0000);
        //LCD_WriteReg(0x0080,0x0000);
        //LCD_WriteReg(0x0081,0x0000);
        LCD_WriteReg(0x0090,0X0011);
        LCD_WriteReg(0x0092,0x0600);
        LCD_WriteReg(0x0093,0x0402);
        LCD_WriteReg(0x0094,0x0002);
        delay_ms(20);
        
        LCD_WriteReg(0x0007,0x0001);
        delay_ms(20);
        LCD_WriteReg(0x0007,0x0061);
        LCD_WriteReg(0x0007,0x0173);
        
        LCD_WriteReg(0x0020,0x0000);
        LCD_WriteReg(0x0021,0x0000);
        LCD_WriteReg(0x00,0x22);  
    }else if(lcddev.id==0xC505)
    {
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        delay_ms(20);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x0000,0x0000);
        LCD_WriteReg(0x00a4,0x0001);
        delay_ms(20);
        LCD_WriteReg(0x0060,0x2700);
        LCD_WriteReg(0x0008,0x0806);
        
        LCD_WriteReg(0x0030,0x0703);    //gamma setting
        LCD_WriteReg(0x0031,0x0001);
        LCD_WriteReg(0x0032,0x0004);
        LCD_WriteReg(0x0033,0x0102);
        LCD_WriteReg(0x0034,0x0300);
        LCD_WriteReg(0x0035,0x0103);
        LCD_WriteReg(0x0036,0x001F);
        LCD_WriteReg(0x0037,0x0703);
        LCD_WriteReg(0x0038,0x0001);
        LCD_WriteReg(0x0039,0x0004);
        
        LCD_WriteReg(0x0090, 0x0015);   //80Hz
        LCD_WriteReg(0x0010, 0X0410);   //BT,AP
        LCD_WriteReg(0x0011,0x0247);    //DC1,DC0,VC
        LCD_WriteReg(0x0012, 0x01BC);
        LCD_WriteReg(0x0013, 0x0e00);
        delay_ms(120);
        LCD_WriteReg(0x0001, 0x0100);
        LCD_WriteReg(0x0002, 0x0200);
        LCD_WriteReg(0x0003, 0x1030);
        
        LCD_WriteReg(0x000A, 0x0008);
        LCD_WriteReg(0x000C, 0x0000);
        
        LCD_WriteReg(0x000E, 0x0020);
        LCD_WriteReg(0x000F, 0x0000);
        LCD_WriteReg(0x0020, 0x0000);   //H Start
        LCD_WriteReg(0x0021, 0x0000);   //V Start
        LCD_WriteReg(0x002A,0x003D);    //vcom2
        delay_ms(20);
        LCD_WriteReg(0x0029, 0x002d);
        LCD_WriteReg(0x0050, 0x0000);
        LCD_WriteReg(0x0051, 0xD0EF);
        LCD_WriteReg(0x0052, 0x0000);
        LCD_WriteReg(0x0053, 0x013F);
        LCD_WriteReg(0x0061, 0x0000);
        LCD_WriteReg(0x006A, 0x0000);
        LCD_WriteReg(0x0092,0x0300); 

        LCD_WriteReg(0x0093, 0x0005);
        LCD_WriteReg(0x0007, 0x0100);
    }else if(lcddev.id==0x8989)         //OK |/|/|
    {
        LCD_WriteReg(0x0000,0x0001);    //打開晶振
        LCD_WriteReg(0x0003,0xA8A4);    //0xA8A4
        LCD_WriteReg(0x000C,0x0000);
        LCD_WriteReg(0x000D,0x080C);
        LCD_WriteReg(0x000E,0x2B00);
        LCD_WriteReg(0x001E,0x00B0);
        LCD_WriteReg(0x0001,0x2B3F);    //驅動輸出控制320*240  0x6B3F
        LCD_WriteReg(0x0002,0x0600);
        LCD_WriteReg(0x0010,0x0000);
        LCD_WriteReg(0x0011,0x6078);    //定義數據格式  16位色     橫屏 0x6058
        LCD_WriteReg(0x0005,0x0000);
        LCD_WriteReg(0x0006,0x0000);
        LCD_WriteReg(0x0016,0xEF1C);
        LCD_WriteReg(0x0017,0x0003);
        LCD_WriteReg(0x0007,0x0233);    //0x0233
        LCD_WriteReg(0x000B,0x0000);
        LCD_WriteReg(0x000F,0x0000);    //掃描開始地址
        LCD_WriteReg(0x0041,0x0000);
        LCD_WriteReg(0x0042,0x0000);
        LCD_WriteReg(0x0048,0x0000);
        LCD_WriteReg(0x0049,0x013F);
        LCD_WriteReg(0x004A,0x0000);
        LCD_WriteReg(0x004B,0x0000);
        LCD_WriteReg(0x0044,0xEF00);
        LCD_WriteReg(0x0045,0x0000);
        LCD_WriteReg(0x0046,0x013F);
        LCD_WriteReg(0x0030,0x0707);
        LCD_WriteReg(0x0031,0x0204);
        LCD_WriteReg(0x0032,0x0204);
        LCD_WriteReg(0x0033,0x0502);
        LCD_WriteReg(0x0034,0x0507);
        LCD_WriteReg(0x0035,0x0204);
        LCD_WriteReg(0x0036,0x0204);
        LCD_WriteReg(0x0037,0x0502);
        LCD_WriteReg(0x003A,0x0302);
        LCD_WriteReg(0x003B,0x0302);
        LCD_WriteReg(0x0023,0x0000);
        LCD_WriteReg(0x0024,0x0000);
        LCD_WriteReg(0x0025,0x8000);
        LCD_WriteReg(0x004f,0);         //行首址0
        LCD_WriteReg(0x004e,0);         //列首址0
    }else if(lcddev.id==0x4531)         //OK |/|/|
    {
        LCD_WriteReg(0X00,0X0001);   
        delay_ms(10);   
        LCD_WriteReg(0X10,0X1628);   
        LCD_WriteReg(0X12,0X000e);//0x0006    
        LCD_WriteReg(0X13,0X0A39);   
        delay_ms(10);   
        LCD_WriteReg(0X11,0X0040);   
        LCD_WriteReg(0X15,0X0050);   
        delay_ms(10);   
        LCD_WriteReg(0X12,0X001e);//16    
        delay_ms(10);   
        LCD_WriteReg(0X10,0X1620);   
        LCD_WriteReg(0X13,0X2A39);   
        delay_ms(10);   
        LCD_WriteReg(0X01,0X0100);   
        LCD_WriteReg(0X02,0X0300);   
        LCD_WriteReg(0X03,0X1038);//改變方向的   
        LCD_WriteReg(0X08,0X0202);   
        LCD_WriteReg(0X0A,0X0008);   
        LCD_WriteReg(0X30,0X0000);   
        LCD_WriteReg(0X31,0X0402);   
        LCD_WriteReg(0X32,0X0106);   
        LCD_WriteReg(0X33,0X0503);   
        LCD_WriteReg(0X34,0X0104);   
        LCD_WriteReg(0X35,0X0301);   
        LCD_WriteReg(0X36,0X0707);   
        LCD_WriteReg(0X37,0X0305);   
        LCD_WriteReg(0X38,0X0208);   
        LCD_WriteReg(0X39,0X0F0B);   
        LCD_WriteReg(0X41,0X0002);   
        LCD_WriteReg(0X60,0X2700);   
        LCD_WriteReg(0X61,0X0001);   
        LCD_WriteReg(0X90,0X0210);   
        LCD_WriteReg(0X92,0X010A);   
        LCD_WriteReg(0X93,0X0004);   
        LCD_WriteReg(0XA0,0X0100);   
        LCD_WriteReg(0X07,0X0001);   
        LCD_WriteReg(0X07,0X0021);   
        LCD_WriteReg(0X07,0X0023);   
        LCD_WriteReg(0X07,0X0033);   
        LCD_WriteReg(0X07,0X0133);   
        LCD_WriteReg(0XA0,0X0000); 
    }else if(lcddev.id==0x4535)
    {
        LCD_WriteReg(0X15,0X0030);   
        LCD_WriteReg(0X9A,0X0010);   
        LCD_WriteReg(0X11,0X0020);   
        LCD_WriteReg(0X10,0X3428);   
        LCD_WriteReg(0X12,0X0002);//16
        LCD_WriteReg(0X13,0X1038);   
        delay_ms(40);   
        LCD_WriteReg(0X12,0X0012);//16
        delay_ms(40);   
        LCD_WriteReg(0X10,0X3420);   
        LCD_WriteReg(0X13,0X3038);   
        delay_ms(70);   
        LCD_WriteReg(0X30,0X0000);   
        LCD_WriteReg(0X31,0X0402);   
        LCD_WriteReg(0X32,0X0307);   
        LCD_WriteReg(0X33,0X0304);   
        LCD_WriteReg(0X34,0X0004);   
        LCD_WriteReg(0X35,0X0401);   
        LCD_WriteReg(0X36,0X0707);   
        LCD_WriteReg(0X37,0X0305);   
        LCD_WriteReg(0X38,0X0610);   
        LCD_WriteReg(0X39,0X0610); 
        
        LCD_WriteReg(0X01,0X0100);   
        LCD_WriteReg(0X02,0X0300);   
        LCD_WriteReg(0X03,0X1030);//改變方向的   
        LCD_WriteReg(0X08,0X0808);   
        LCD_WriteReg(0X0A,0X0008);   
        LCD_WriteReg(0X60,0X2700);   
        LCD_WriteReg(0X61,0X0001);   
        LCD_WriteReg(0X90,0X013E);   
        LCD_WriteReg(0X92,0X0100);   
        LCD_WriteReg(0X93,0X0100);   
        LCD_WriteReg(0XA0,0X3000);   
        LCD_WriteReg(0XA3,0X0010);   
        LCD_WriteReg(0X07,0X0001);   
        LCD_WriteReg(0X07,0X0021);   
        LCD_WriteReg(0X07,0X0023);   
        LCD_WriteReg(0X07,0X0033);   
        LCD_WriteReg(0X07,0X0133);   
    }
    LCD_Display_Dir(0);         // Exit Sleep
    __LCD_BackLight_On();       // display on
    LCD_Clear(BLACK);
}



/**
 *******************************************************************************
 * @brief       Clear 清屏函數
 * @param       Color 要清屏的填充色
 * @return      None
 *******************************************************************************
 */
void LCD_Clear(uint16_t color)
{
    uint32_t index=0;      
    uint32_t totalpoint;

    __LCD_BackLight_Off();

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;                  //得到總點數
    if((lcddev.id==0X6804)&&(lcddev.dir==1))    //6804橫屏的時候特殊處理  
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);             //設置光標位置  
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);           //設置光標位置  
    LCD_WriteRAM_Prepare();                     //開始寫入GRAM

    __LCD_CS_CLR();
    __LCD_RS_SET();
    for(index=0;index<totalpoint;index++)
    {
        __DATAOUT(color);
        __LCD_WR_CLR();
        __LCD_WR_SET();
    }
    __LCD_CS_SET();
    __LCD_BackLight_On();

}


/**
 *******************************************************************************
 * @brief       Color Bar 秀彩模式
 * @return      None
 *******************************************************************************
 */
uint16_t ColorBar_1[] = { 0xFFFF, 0x001F, 0xF800, 0xF81F, 0x07E0, 0x07FF, 0xFFE0, 0x0000};
void LCD_ColorBar_1(void)
{
    uint16_t i, j, lColorTemp, lColorCount;
    uint32_t totalpoint;

//    __LCD_BackLight_Off();

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;                  //得到總點數
    if((lcddev.id==0X6804)&&(lcddev.dir==1))    //6804橫屏的時候特殊處理  
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);             //設置光標位置 
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);           //設置光標位置 
    LCD_WriteRAM_Prepare();                     //開始寫入GRAM
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

    lColorCount = 0;

    __LCD_CS_CLR();\
    __LCD_RS_SET();\
    do{
        lColorTemp = ColorBar_1[lColorCount];
        i = (uint16_t)(lcddev.height / 8);
        do{
            j = lcddev.width;
            do{
                __DATAOUT(lColorTemp);
                __LCD_WR_CLR();
                __LCD_WR_SET();
            }while(-- j != 0);
        }while(-- i != 0);
    }while(++ lColorCount != 0x0008);
    __LCD_CS_SET();\
//    __LCD_BackLight_On();
}



/**
 *******************************************************************************
 * @brief       Color Bar 2 秀彩模式2
 * @return      None
 *******************************************************************************
 */
void LCD_ColorBar_2(void)
{
    float lColorInt = 0;
    float lColorScreen;
//    uint32_t index=0;      
    uint32_t totalpoint;
    uint16_t i, j, lColorTemp;

//    __LCD_BackLight_Off();

    totalpoint=lcddev.width;
    totalpoint*=lcddev.height;                  //得到總點數
    if((lcddev.id==0X6804)&&(lcddev.dir==1))    //6804橫屏的時候特殊處理
    {
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);             //設置光標位置
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);           //設置光標位置
    LCD_WriteRAM_Prepare();                     //開始寫入GRAM
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

//    lColorCount = 0;

    __LCD_CS_CLR();\
    __LCD_RS_SET();\

//    lColorTemp = 0xF800;
//    j = lcddev.width;
//    do{
//            __DATAOUT(lColorTemp);
//            __LCD_WR_CLR();
//            __LCD_WR_SET();
//    }while(-- j != 0);

    // B = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0xF800;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0xF800 + (uint16_t)lColorInt;
    }while(-- i != 0);

    // R = 255 ~ 0;
    lColorInt = 0;
    lColorTemp = 0xF81F;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0xF81F - (((uint16_t)lColorInt) << 11);
    }while(-- i != 0);

    // G = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 64 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x001F;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0x001F + (((uint16_t)lColorInt) << 5);
    }while(-- i != 0);

    // B = 255 ~ 0;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x7FF;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0x7FF - ((uint16_t)lColorInt);
    }while(-- i != 0);

    // R = 0 ~ 255;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 32 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0x07E0;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0x07E0 + (((uint16_t)lColorInt) << 11);
    }while(-- i != 0);

    // B = 255 ~ 0;
    lColorScreen = lcddev.height;
    lColorScreen /= 6;
    lColorScreen = 64 / lColorScreen;
    lColorInt = 0;
    lColorTemp = 0xFFE0;
    i = (uint16_t)(lcddev.height / 6);
    do{
        j = lcddev.width;
        do{
            __DATAOUT(lColorTemp);
            __LCD_WR_CLR();
            __LCD_WR_SET();
        }while(-- j != 0);
        lColorInt += lColorScreen;
        lColorTemp = 0xFFE0 - (((uint16_t)lColorInt) << 5);
    }while(-- i != 0);

//    lColorTemp = 0xF800;
//    j = lcddev.width;
//    do{
//            __DATAOUT(lColorTemp);
//            __LCD_WR_CLR();
//            __LCD_WR_SET();
//    }while(-- j != 0);

    __LCD_CS_SET();\
//	__LCD_BackLight_On();
}



/**
 *******************************************************************************
 * @brief       Show Gray Bar 對比模式
 * @return      None
 *******************************************************************************
 */
uint16_t GrayBar_1[] = {0xFFFF, 0xEF7D, 0xDEFB, 0xCE79, 0xBDF7, 0xAD75, 0x9CF3, 0x8C71,
                        0x7BEF, 0x6B6D, 0x5AEB, 0x4A69, 0x39E7, 0x2965, 0x18E3, 0x0000};
void LCD_GrayBar_1(void)
{
//    uint32_t index=0;      
    uint32_t totalpoint;
    uint16_t i, j, lColorTemp, lColorCount;

//    __LCD_BackLight_Off();

    totalpoint = lcddev.width;
    totalpoint *= lcddev.height;                        //得到總點數
    if((lcddev.id == 0X6804) && (lcddev.dir == 1))      //6804橫屏的時候特殊處理  
    {   
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_SetCursor(0x00,0x0000);                     //設置光標位置  
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else LCD_SetCursor(0x00,0x0000);                   //設置光標位置 
    LCD_WriteRAM_Prepare();                             //開始寫入GRAM
    //for(index=0;index<totalpoint;index++)LCD_WR_DATA(color);

    lColorCount = 0;

    __LCD_CS_CLR();\
    __LCD_RS_SET();\
    do{
        lColorTemp = GrayBar_1[lColorCount];
        i = (uint16_t)(lcddev.height / 16);
        do{
            j = lcddev.width;
            do{
                __DATAOUT(lColorTemp);
                __LCD_WR_CLR();
                __LCD_WR_SET();
            }while(-- j != 0);
        }while(-- i != 0);
    }while(++ lColorCount != 0x0010);
    __LCD_CS_SET();\
//    __LCD_BackLight_On();
}



//在指定區域內填充指定顏色
//區域大小:(xend-xsta+1)*(yend-ysta+1)
//xsta
//color:要填充的顏色
void LCD_Fill(uint16_t sx,uint16_t sy,uint16_t ex,uint16_t ey,uint16_t color)
{          
    uint16_t i,j;
    uint16_t xlen = 0;
    uint16_t temp;
    if((lcddev.id == 0X6804) && (lcddev.dir == 1))    //6804橫屏的時候特殊處理
    {
        temp = sx;
        sx=sy;
        sy=lcddev.width-ex-1;
        ex=ey;
        ey=lcddev.width-temp-1;
        lcddev.dir=0;
        lcddev.setxcmd=0X2A;
        lcddev.setycmd=0X2B;
        LCD_Fill(sx,sy,ex,ey,color);
        lcddev.dir=1;
        lcddev.setxcmd=0X2B;
        lcddev.setycmd=0X2A;
    }else
    {
        xlen=ex-sx+1;
        for(i=sy;i<=ey;i++)
        {
            LCD_SetCursor(sx,i);                    //設置光標位置
            LCD_WriteRAM_Prepare();                 //開始寫入GRAM
            for(j=0;j<xlen;j++)LCD_WR_DATA(color);  //設置光標位置
        }
    }
}



/**
 *******************************************************************************
 * @brief       Rectangle Fill Color 在指定區矩形域內填充指定顏色塊
 * @param       sx Start X-axes 坐標
 * @param       sy Start Y-axes 坐標
 * @param       ex end X-axes 坐標
 * @param       ey end Y-axes 坐標
 * @param       color 要填充的顏色
 * @return      None
 * @note        (sx,sy),(ex,ey):填充矩形對角坐標,區域大小為:(ex-sx+1)*(ey-sy+1)
 *******************************************************************************
 */
void LCD_Color_Fill(uint16_t sx,uint16_t sy,uint16_t ex,uint16_t ey,uint16_t *color)
{  
    uint16_t height,width;
    uint16_t i,j;
    width=ex-sx+1;                  //得到填充的寬度
    height=ey-sy+1;                 //高度
    for(i=0;i<height;i++)
    {
        LCD_SetCursor(sx,sy+i);     //設置光標位置 
        LCD_WriteRAM_Prepare();     //開始寫入GRAM
        for(j=0;j<width;j++)LCD_WR_DATA(color[i*width+j]);//寫入數據
    }
}



/**
 *******************************************************************************
 * @brief       Draw Line 畫線
 * @param       x1 Start X-axes 坐標
 * @param       y1 Start Y-axes 坐標
 * @param       x2 end X-axes 坐標
 * @param       y2 end Y-axes 坐標
 * @param       color : Line Color 要填充的顏色
 * @return      None
 * @note        (sx,sy),(ex,ey):填充矩形對角坐標,區域大小為:(ex-sx+1)*(ey-sy+1)
 *******************************************************************************
 */
void LCD_DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color)
{
    uint16_t t; 
    int xerr=0,yerr=0,delta_x,delta_y,distance; 
    int incx,incy,uRow,uCol; 
    
    delta_x=x2-x1;                          //計算坐標增量
    delta_y=y2-y1; 
    uRow=x1; 
    uCol=y1; 
    if(delta_x>0)incx=1;                    //設置單步方向
    else if(delta_x==0)incx=0;              //垂直線
    else {incx=-1;delta_x=-delta_x;} 
    if(delta_y>0)incy=1; 
    else if(delta_y==0)incy=0;              //水平線?
    else{incy=-1;delta_y=-delta_y;}
    if( delta_x>delta_y)distance=delta_x;   //選取基本增量坐標軸
    else distance=delta_y; 
    for(t=0;t<=distance+1;t++ )             //畫線輸出
    {  
        LCD_DrawPoint(uRow, uCol, Color);   //畫點
        xerr+=delta_x ; 
        yerr+=delta_y ; 
        if(xerr>distance) 
        { 
            xerr-=distance; 
            uRow+=incx; 
        } 
        if(yerr>distance) 
        { 
            yerr-=distance; 
            uCol+=incy; 
        } 
    }  
}



/**
 *******************************************************************************
 * @brief       Draw Rectangle 畫矩形
 * @param       x1 Start X-axes 坐標
 * @param       y1 Start Y-axes 坐標
 * @param       x2 end X-axes 坐標
 * @param       y2 end Y-axes 坐標
 * @param       color : Rectangle Color
 * @return      None
 * @note        (sx,sy),(ex,ey):矩形對角坐標
 *******************************************************************************
 */
void LCD_DrawRectangle(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t Color)
{
    LCD_DrawLine(x1, y1, x2, y1, Color);
    LCD_DrawLine(x1, y1, x1, y2, Color);
    LCD_DrawLine(x1, y2, x2, y2, Color);
    LCD_DrawLine(x2, y1, x2, y2, Color);
}



/**
 *******************************************************************************
 * @brief       Draw Circle 在指定位置畫一個指定大小的圓
 * @param       x0 Center of circle X-axes 坐標
 * @param       y0 Center of circle Y-axes 坐標
 * @param       r Radius 半徑
 * @param       color : Circle Color
 * @return      None
 * @note        (x0, y0):中心點
 *******************************************************************************
 */
void LCD_Draw_Circle(uint16_t x0, uint16_t y0, uint8_t r, uint16_t Color)
{
    int a,b;
    int di;
    a=0;b=r;
    di=3-(r<<1);                                //判斷下個點位置的標志
    while(a<=b)
    {
        LCD_DrawPoint(x0-b, y0-a, Color);       //3
        LCD_DrawPoint(x0+b, y0-a, Color);       //0
        LCD_DrawPoint(x0-a, y0+b, Color);       //1
        LCD_DrawPoint(x0-b, y0-a, Color);       //7
        LCD_DrawPoint(x0-a, y0-b, Color);       //2
        LCD_DrawPoint(x0+b, y0+a, Color);       //4
        LCD_DrawPoint(x0+a, y0-b, Color);       //5
        LCD_DrawPoint(x0+a, y0+b, Color);       //6
        LCD_DrawPoint(x0-b, y0+a, Color);
        a++;
        //使用Bresenham算法畫圓
        if(di<0)di +=4*a+6;
        else
        {
            di+=10+4*(a-b);
            b--;
        } 
        LCD_DrawPoint(x0+a, y0+b, Color);
    }
}



/**
 *******************************************************************************
 * @brief       Print Number 顯示數字
 * @param       x : Start X-axes 起始坐標
 * @param       y : Start Y-axes 起始坐標
 * @param       num : Number value(0~4294967295) 數值
 * @param       len : Number of digits 數字的位數
 * @param       size : Font size 字體大小
 * @param       color : Number Color 顏色
 * @return      None
 * @note        高位為0不顯示
 *******************************************************************************
 */
void LCD_ShowChar(uint16_t x, uint16_t y, uint8_t num, uint8_t size, uint8_t mode, uint16_t Color)
{
    uint8_t temp,t1,t;
    uint16_t y0=y;
    uint8_t csize=(size/8+((size%8)?1:0))*(size/2);     //得到字體一個字符對應點陣集所占的字節數
    //設置窗口
    num = num - ' ';                                    //得到偏移後的值
    for(t=0;t<csize;t++)
    {   
        if(size==12)temp=asc2_1206[num][t];             //調用1206字體
        else if(size==16)temp=asc2_1608[num][t];        //調用1608字體
        else if(size==24)temp=asc2_2412[num][t];        //調用2412字體
        else return;                                    //沒有的字庫
        for(t1=0;t1<8;t1++)
        {
            if(temp&0x80)LCD_Fast_DrawPoint(x, y, Color);
            else if(mode==0)LCD_Fast_DrawPoint(x, y, BACK_COLOR);
            temp<<=1;
            y++;
            if(x>=lcddev.width)return;                  //超區域了
            if((y-y0)==size)
            {
                y=y0;
                x++;
                if(x>=lcddev.width)return;              //超區域了
                break;
            }
        }
    }
}



/**
 *******************************************************************************
 * @brief       m to the power of n. m^n次方函數
 * @param       m : 
 * @param       n : 
 * @return      uint32_t m^n次方
 *******************************************************************************
 */
uint32_t LCD_Pow(uint8_t m,uint8_t n)
{
    uint32_t result = 1;
    while(n--)result *= m;
    return result;
}



/**
 *******************************************************************************
 * @brief       Print Number 顯示數字
 * @param       x : Start X-axes 起始坐標
 * @param       y : Start Y-axes 起始坐標
 * @param       num : Number value(0~4294967295) 數值
 * @param       len : Number of digits 數字的位數
 * @param       size : Font size 字體大小
 * @param       mode : overlay 疊加方式
 *      @arg        bit7 is 0 Don't fill.
 *      @arg        bit7 is 1 Fill.
 *      @arg        bit0 is 0 No overlay.
 *      @arg        bit0 is 1 overlay.
 * @param       color : Number Color 顏色
 * @return      None
 * @note        高位為0顯示
 *******************************************************************************
 */
void LCD_ShowNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint16_t Color)
{
    uint8_t t,temp;
    uint8_t enshow=0;
    for(t=0;t<len;t++)
    {
        temp=(num/LCD_Pow(10,len-t-1))%10;
        if(enshow==0&&t<(len-1))
        {
            if(temp==0)
            {

                LCD_ShowChar(x+(size/2)*t, y, ' ', size, 0, Color);
                continue;
            }else enshow=1; 
            
        }
        LCD_ShowChar(x+(size/2)*t, y, temp+'0', size, 0, Color); 
    }
}



/**
 *******************************************************************************
 * @brief       Print one char 在指定位置顯示一個字符
 * @param       x : Start X-axes 起始坐標
 * @param       y : Start Y-axes 起始坐標
 * @param       num : ASCII Number " "--->"~"
 * @param       size : Font size 字體大小
 * @param       mode 疊加方式
 *      @arg        0:No overlay
 *      @arg        1:overlay
 * @param       color : Font Color
 * @return      None
 *******************************************************************************
 */
void LCD_ShowxNum(uint16_t x, uint16_t y, uint32_t num, uint8_t len, uint8_t size, uint8_t mode, uint16_t Color)
{  
    uint8_t t,temp;
    uint8_t enshow=0;
    for(t=0;t<len;t++)
    {
        temp=(num/LCD_Pow(10,len-t-1))%10;
        if(enshow==0&&t<(len-1))
        {
            if(temp==0)
            {
                if(mode&0X80)LCD_ShowChar(x+(size/2)*t,y,'0',size,mode&0X01, Color);  
                else LCD_ShowChar(x+(size/2)*t,y,' ',size,mode&0X01, Color);  
                continue;
            }else enshow=1; 
            
        }
        LCD_ShowChar(x+(size/2)*t,y,temp+'0',size,mode&0X01, Color); 
    }
}



/**
 *******************************************************************************
 * @brief       Print String 顯示字符串
 * @param       x : Start X-axes 起始坐標
 * @param       y : Start Y-axes 起始坐標
 * @param       width : Displayable width range 區域寬度大小
 * @param       height : Displayable height range 區域高度大小
 * @param       Color : String Color 顏色
 * @param       size : Font size 字體大小
 * @param       p : String start address
 * @return      None
 *******************************************************************************
 */
void LCD_ShowString(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t Color, uint8_t size, uint8_t *p)
{
    uint8_t x0=x;
    width+=x;
    height+=y;
    while((*p<='~')&&(*p>=' '))//判斷是不是非法字符!
    {       
        if(x>=width){x=x0;y+=size;}
        if(y>=height)break;//退出
        LCD_ShowChar(x, y, *p, size, 1, Color);
        x+=size/2;
        p++;
    }  
}



//int fputc(int ch, FILE* f)
//{
//    static uint16_t x = 0, y = 0;             //坐標
//    uint8_t string[32];                       //讀取字模數組
//    static uint8_t flag = 0;                  //漢字第一第二字節標志
//    static uint8_t tmp[2];                    //保存漢字的兩個字節

//    if(ch == '\n')   //??
//    {
//        y += 16;
//        return ch;
//    }

//    if(ch == '\r')   //??
//    {
//        x = 0;
//        return ch;
//    }

//    if(ch & 0x80)                             //先判斷是否為中文
//    {
//        if(flag == 0)                         //中文的第一個字節還是第二個字節
//        {
//            flag= 1;                          //接下來是第二個字節
//            tmp[0] = ch;                      //記錄該字節
//            return ch;                        //按照C語言的fputc需要返回ch
//        }
//        else
//        {
//            flag= 0;
//            tmp[1] = ch;
//            if(x> lcddev.width - 16)          //判斷是否越界
//            {
//                x = 0;                        //換行處理
//                y += 16;                      //字模大小為16*16
//            }
//            if(y> lcddev.height - 16)         //行越界
//            {
//                return ch;                    //直接退出處理
//            }
//            string = Get_Chinese(tmp);
//            LCD_Chinese_One(x, y, string, color);
//            x +=16;
//            return ch;
//        }
//    }
//    else
//    {
//        if(x > lcddev.width - 8)              //X_MAX是宏定義, 該值為240
//        {
//            x =0;                             //x置零
//            y +=16;                           //y移至下一行
//        }
//        if(y > lcddev.height - 16)            //Y_MAX是宏定義, 該值是320
//        {
//            return ch;                        //直接退出
//        }
//        string = Get_Ascii(ch);               //獲取ch的字模
//        LCD_Ascii_One(x, y,string, color);    //打印字符ch
//        x += 8;                               //跳轉到下一個位置, 是否越界有上面函數判斷
//        return ch;
//    }
//}


