/**
 *******************************************************************************
 * @file        MG32_PW_Init.h
 *
 * @brief       The PW initial code h file
 *
 * MG32 remote controller
 * @version     V1.16
 * @date        2023/05/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#include "MG32.h"
#include "MG32_PW.h"


#ifndef _MG32_PW_INIT_H
/*!< _MG32_PW_INIT_H */ 
#define _MG32_PW_INIT_H


/**
******************************************************************************
*
* @struct      PW_InitConfig[]
*              PW initial configuration array
*
******************************************************************************
*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***
//  <h> Configure PW Module
//      <q.1>  Enable Internal Voltage Reference (VBUF)
//      <i> VBUF = 1.4V, for ADC.
        #define CONF_PW_CR0_IVR_EN      0 
/*      <q.4>  Enable BOD0 */  
        #define CONF_PW_CR0_BOD0_EN     0 

//      <e.5>  Enable BOD1
        #define CONF_PW_CR0_BOD1_EN     0 
//          <o.10..12> Select BOD1 Detect Voltage threshold <0=> 2.0V
//                                                          <1=> 2.4V
//                                                          <2=> 3.7V
//                                                          <3=> 4.2V
            #define CONF_PW_CR0_BOD1_TH     0 

//          <o.8..9> Select Interrupt Trigger <0=> No Interrupt
//                                            <1=> Rising Edge
//                                            <2=> Falling Edge
//                                            <3=> Dual-Edge
            #define CONF_PW_CR0_BOD1_TRGS   0 

//      </e>
//      <e.13>  Enable BOD2
//      <i> Support MG32F02A128/A064/U128/U064/V032
//      <i> BOD2 Detect Voltage threshold 1.7V   
        #define CONF_PW_CR0_BOD2_EN     0 

//          <o.14..15> Select Interrupt Trigger <0=> No Interrupt
//                                              <1=> Rising Edge
//                                              <2=> Falling Edge
//                                              <3=> Dual-Edge
            #define CONF_PW_CR0_BOD2_TRGS   0 

//      </e>
//      <o.20..21> Select Wake-Up Delay From STOP Mode <0=> Level0 (0~15us)  
//                                                     <1=> Level1 (30~45us)  
//                                                     <2=> Level2 (60~75us)  
//                                                     <3=> Level3 (120~135us)  
        #define CONF_PW_CR0_WKSTP_DSEL      0 
    
/*      <o.16..17> Select Low Power LDO <0=> LV0 (Lowest level)  */
/*                                      <1=> LV1 (the same LV2)  */
/*                                      <2=> LV2 (the same LV1)  */
/*                                      <3=> LV3 (Highest level) */
        #define CONF_PW_CR0_LDO_CTL         0 

//      <o.7> Select Core Voltage LDO When STOP Mode <0=> Normal
//                                                   <1=> Low Power
        #define CONF_PW_CR0_LDO_STP         128 

/*      <o.6> Select Core Voltage LDO When ON Mode <0=> Normal    */
/*                                                 <1=> Low Power */
        #define CONF_PW_CR0_LDO_ON          0 

//      <o.18> Wakeup Mode Select from SLEEP Mode <0=> Normal (Waiting 5 AHB clock)
//                                                <1=> Low Power
        #define CONF_PW_CR0_WKSLP_MDS       0 

//      <h> Configure Analog Module In SLEEP Mode 
//          <q.16> Comparator CMP0
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_CR1_SLP_CMP0    0 
//          <q.17> Comparator CMP1
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_CR1_SLP_CMP1    0 
//          <q.18> Comparator CMP2
//          <i> Support MG32F02A132/A072
            #define CONF_PW_CR1_SLP_CMP2    0 
//          <q.19> Comparator CMP3
//          <i> Support MG32F02A132/A072
            #define CONF_PW_CR1_SLP_CMP3    0 
//          <q.24> USB
//          <i> Support MG32F02U128/U064
            #define CONF_PW_CR1_SLP_USB     0 
//      </h>

//      <h> Configure Analog Module In STOP Mode 
/*          <q.1>  Power On  disable */
            #define CONF_PW_CR1_STP_POR     0
/*          <q.4>  BOD0  disable     */
            #define CONF_PW_CR1_STP_BOD0    0
//          <q.5>  BOD1
            #define CONF_PW_CR1_STP_BOD1    0
//          <q.6>  BOD2 
//          <i> Support MG32F02U128/U064/A128/A064/V032
            #define CONF_PW_CR1_STP_BOD2    0
//          <q.20> Comparator CMP0
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_CR1_STP_CMP0    0
//          <q.21> Comparator CMP1
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_CR1_STP_CMP1    0
//          <q.22> Comparator CMP2
//          <i> Support MG32F02A132/A072
            #define CONF_PW_CR1_STP_CMP2    0
//          <q.23> Comparator CMP3
//          <i> Support MG32F02A132/A072
            #define CONF_PW_CR1_STP_CMP3    0
//          <q.28> USB
//          <i> Support MG32F02U128/U064
            #define CONF_PW_CR1_STP_USB     0
//      </h>

//      <h> Configure Wakeup In STOP Mode
//      <i> GPIO wake-up by EXIC interrupt configured.
/*          <q.4>  BOD0  disable*/
            #define CONF_PW_WKSTP0_WKSTP_BOD0   0
//          <q.5>  BOD1
            #define CONF_PW_WKSTP0_WKSTP_BOD1   0
//          <q.6>  BOD2
//          <i> Support MG32F02U128/U064/A128/A064/V032
            #define CONF_PW_WKSTP0_WKSTP_BOD2   0
//          <q.16> Comparator CMP0
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_WKSTP0_WKSTP_CMP0   0
//          <q.17> Comparator CMP1
//          <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_PW_WKSTP0_WKSTP_CMP1   0
//          <q.18> Comparator CMP2
//          <i> Support MG32F02A132/A072
            #define CONF_PW_WKSTP0_WKSTP_CMP2   0
//          <q.19> Comparator CMP3
//          <i> Support MG32F02A132/A072
            #define CONF_PW_WKSTP0_WKSTP_CMP3   0
//          <q.24> USB
//          <i> Support MG32F02U128/U064
            #define CONF_PW_WKSTP0_WKSTP_USB    0
//          <q.5>  RTC
            #define CONF_PW_WKSTP1_WKSTP_RTC    0
//          <q.6>  IWDT
            #define CONF_PW_WKSTP1_WKSTP_IWDT   0
//          <q.8>  I2C0 (Detect Slave Address Only)
            #define CONF_PW_WKSTP1_WKSTP_I2C0   0
//          <q.9>  I2C1 (Detect Slave Address Only)
//          <i> Support MG32F02A132/A128/A072/A064/U128/U064/V032
            #define CONF_PW_WKSTP1_WKSTP_I2C1   0
//      </h>

//      <e.0> Configure Interrupt (IEA)
        #define CONF_PW_INT_IEA             0
//          <q.4>  BOD0
            #define CONF_PW_INT_BOD0_IE     0
//          <q.5>  BOD1
            #define CONF_PW_INT_BOD1_IE     0
//          <q.6>  BOD2
//          <i> Support MG32F02U128/U064/A128/A064/V032
            #define CONF_PW_INT_BOD2_IE     0
//          <q.7>  Wakeup
            #define CONF_PW_INT_WK_IE       0
//      </e>
//  </h>

#define CONF_PW_STA         0x00000000
#define CONF_PW_INT         CONF_PW_INT_IEA | CONF_PW_INT_BOD0_IE | CONF_PW_INT_BOD1_IE | CONF_PW_INT_BOD2_IE | CONF_PW_INT_WK_IE
#define CONF_PW_KEY         0x00000000
#define CONF_PW_CR0         CONF_PW_CR0_IVR_EN | CONF_PW_CR0_BOD0_EN | CONF_PW_CR0_BOD1_EN | CONF_PW_CR0_BOD1_TH | CONF_PW_CR0_BOD1_TRGS | CONF_PW_CR0_BOD2_EN | CONF_PW_CR0_BOD2_TRGS | CONF_PW_CR0_WKSTP_DSEL | CONF_PW_CR0_LDO_CTL | CONF_PW_CR0_LDO_STP | CONF_PW_CR0_LDO_ON | CONF_PW_CR0_WKSLP_MDS          
#define CONF_PW_CR1         CONF_PW_CR1_SLP_CMP0 | CONF_PW_CR1_SLP_CMP1 | CONF_PW_CR1_SLP_CMP2 | CONF_PW_CR1_SLP_CMP3 | CONF_PW_CR1_SLP_USB | CONF_PW_CR1_STP_POR | CONF_PW_CR1_STP_BOD0 | CONF_PW_CR1_STP_BOD1 | CONF_PW_CR1_STP_BOD2 | CONF_PW_CR1_STP_CMP0 | CONF_PW_CR1_STP_CMP1 | CONF_PW_CR1_STP_CMP2 | CONF_PW_CR1_STP_CMP3 | CONF_PW_CR1_STP_USB
#define CONF_PW_WKSTP0      CONF_PW_WKSTP0_WKSTP_BOD0 | CONF_PW_WKSTP0_WKSTP_BOD1 | CONF_PW_WKSTP0_WKSTP_BOD2 | CONF_PW_WKSTP0_WKSTP_CMP0 | CONF_PW_WKSTP0_WKSTP_CMP1 | CONF_PW_WKSTP0_WKSTP_CMP2 | CONF_PW_WKSTP0_WKSTP_CMP3 | CONF_PW_WKSTP0_WKSTP_USB
#define CONF_PW_WKSTP1      CONF_PW_WKSTP1_WKSTP_RTC | CONF_PW_WKSTP1_WKSTP_IWDT | CONF_PW_WKSTP1_WKSTP_I2C0 | CONF_PW_WKSTP1_WKSTP_I2C1
//*** <<< end of configuration section >>>    ***

static const unsigned int CONF_PW_InitConfig[] =
{
    CONF_PW_STA,        // PW_STA 0 not use
    CONF_PW_INT,        // PW_INT 1 not use
    CONF_PW_KEY,        // PW_KEY 2 not use
    CONF_PW_CR0,        // PW_CR0 3
    CONF_PW_CR1,        // PW_CR1 4
    CONF_PW_WKSTP0,     // PW_WKSTP0 5
    CONF_PW_WKSTP1,     // PW_WKSTP1 6
};


/**
* @name       Function announce
*             
 */
///@{  
void PW_Init (void);
///@}


#endif  // _MG32_PW_INIT_H

