/**
 ******************************************************************************
 *
 * @file        MG32_TM_Init.H
 *
 * @brief       This file is to configure TM baudrate setting.
 *              Device : MG32F02A032
 * @par         Project
 *              MG32 
 * @version     V1.03
 * @date        2023/08/30
 * @author      MG32CoGen
 * @copyright   Copyright (c) 2022 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par     Disclaimer 
 *    The Demo software is provided "AS IS"  without any warranty, either 
 *    expressed or implied, including, but not limited to, the implied warranties 
 *    of merchantability and fitness for a particular purpose.  The author will 
 *    not be liable for any special, incidental, consequential or indirect 
 *    damages due to loss of data or any other reason. 
 *    These statements agree with the world wide and local dictated laws about 
 *    authorship and violence against these laws. 
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_TM_INIT_H

#define _MG32_TM_INIT_H

#include "MG32_TM_DRV.h"
#if defined(IRQHandler_Middleware_Level_)       
    #include "MG32_TM_MID.h"
#endif

// <<< Use Configuration Wizard in Context Menu >>>

//<e0.0> Configure TM00 Module
    #define CONF_TM00_MODE                                  0x00000000
//  <h> TM00 Timer Base Recipe
//    <o0.0..7> Main counter range <0-255>
      #define CONF_TM00_CNT                                 0x00000080
//    <o0.0..7> Prescaler counter range <0-255>
      #define CONF_TM00_PSNT                                0x00000080
//    <o0.4..5> Operation mode (Up count) <0=> Cascade : 8-bit counter with 8-bit prescaler  Mode 
//                                        <1=> Separate : Separated two 8-bit counters Mode 
//                                        <2=> Full-Counter : 16-bit counter Mode
      #define CONF_TM00_CR0_MDS                             0x00000000
//    <h> Config Timer Clock Source
//      <o0.6..7> Main / Prescaler counter clock source <0=> Internal clock <3=> External Clock
        #define CONF_TM00_CLK_CKS_SEL                       0x00000000
//      <h> Internal Clock 
//        <o0.8..9> Internal Clock Source <0=> CK_TMx_PR <2=> CK_LS
          #define CONF_TM00_CLK_CKI_SEL                     0x00000000
//        <o0.12..13> Internal Clock divider <0=> DIV1 : divided by 1 <1=> DIV2 : divided by 2 
//                                           <2=> DIV4 : divided by 4 <3=> DIV8 : divided by 8
          #define CONF_TM00_CLK_CKI_DIV                     0x00000000
//      </h>      
//      <h> External Clock 
//        <o0.4..6> External Clock Source <0=> ETR (CK_ETR) <1=> ITR (CK_ITR)
          #define CONF_TM00_CLK_CKE_SEL                     0x00000000
//        <o0.8..10> ITR Select <0=> ITR0 <1=> ITR1 <2=> ITR2 <3=> ITR3 <4=> ITR4 <5=> ITR5 <6=>ITR6 <7=> ITR7
          #define CONF_TM00_TRG_ITR_MUX                     0x00000000
//      </h>      
//    </h> 
//    <h> External Trigger (EXF)
//      <o0.10..11> (1st) Accept External trigger -> Assert EXF <0=> Disable external trigger 
//                                                              <1=> Accept external trigger 
//                                                              <2=> Accept external trigger with inversion
        #define CONF_TM00_CR0_EX_EN                         0x00000000
//      <o0.15> (2nd) Update event accepts EXF <0=> Disable <1=> Enable
        #define CONF_TM00_CR0_UEX_EN                        0x00000000
//    </h>
//    <h> ClockOut Configuration
//      <q0.0> Timer overflow as CKO output enable
        #define CONF_TM00_CKO_CKO_EN                        0x00000000
//      <o0.2..3> CKO initial state <0=> Disable external trigger <2=> Output 0 <3=> Output 1
        #define CONF_TM00_CKO_CKO_STA                       0x00000000
//      <o0.1> CKO toggle event select <0=> Prescaler counter overflow <1=> Main counter overflow
        #define CONF_TM00_CKO_CKO_SEL                       0x00000000
//    </h>
//    <h> TRGI Input (TRGI)
//      <o0.6..7> (TRGI) Timer trigger source from <0=> ETR (CK_ETR) 
//                                                 <1=> ITR (CK_ITR)
        #define CONF_TM00_TRG_TRG_MUX                       0x00000000
//      <o0.0..2> (TRGI) Main counter trigger input mode <0=> No operation 
//                                                       <1=> Trigger-R (TRGI rising) 
//                                                       <2=> Reset-R (TRGI rising) 
//                                                       <3=> Gate-H (TRGI high) 
//                                                       <4=> Reset (TRGI dual edge) 
//                                                       <5=> Trigger-F (TRGI falling)
//                                                       <6=> Reset-F (TRGI falling) 
//                                                       <7=> Gate-L (TRGI low)
        #define CONF_TM00_TRG_TRGI_MDS                      0x00000000
//      <o0.3..5> (TRGI) Prescaler counter trigger input mode <0=> No operation 
//                                                            <1=> Trigger-R (TRGI rising) 
//                                                            <2=> Reset-R (TRGI rising) 
//                                                            <3=> Gate-H (TRGI high) 
//                                                            <4=> Reset (TRGI dual edge) 
//                                                            <5=> Trigger-F (TRGI falling)
//                                                            <6=> Reset-F (TRGI falling) 
//                                                            <7=> Gate-L (TRGI low)
        #define CONF_TM00_TRG_TRGI2_MDS                     0x00000000
//    </h>
//    <h> TRGO Output (TRGO)
//      <o.12..15> (TRGO) Timer trigger output mode select <0=>  RST : TMxx_RST (Main Timer Reset)     
//                                                        <1=>  EN : TMxx_EN (Main Timer Enable)      
//                                                        <2=>  UEV : TMxx_UEV (Main Timer Update event)      
//                                                        <3=>  TOF : TMxx_TOF (Main Timer overflow)      
//                                                        <4=>  TUF : TMxx_TUF (Main Timer underflow)     
//                                                        <5=>  EN2 : TMxx_EN2 (Timer-2 Enable)     
//                                                        <6=>  TOF2 :TMxx_TOF2 (Timer-2 overflow)      
//                                                        <7=>  DIR : TMxx_DIR (Main Timer direction event)     
//                                                        <8=>  UEV2 : TMxx_UEV2 (Timer-2 Update event)     
//                                                        <9=>  SW : TMxx_TRGO_SW (software control bit)      
//                                                        <14=> TRGI : TMxx_TRGI (internal TRGI signal)     
        #define CONF_TM00_TRG_TRGO_MDS                      0x00000000
//      <o0.22..23> (TRGO) Timer UEV event source select <0=> All : output all UEV pulses <1=> TOF : output timer overflow pulses <2=> UDF : output timer underflow pulses
        #define CONF_TM00_TRG_UEV_SEL                       0x00000000
//      <o0.12> UEV Function via main counter <0=> Enable <1=> Disable
//        <i> Update event is generation from counter overflow/underflow or software register forced bit.
        #define CONF_TM00_CR0_UEV_DIS                       0x00000000
//      <o0.25> (TRGO) Timer TRGO output inverse enable bit <0=> Disable <1=> Enable
        #define CONF_TM00_TRG_TRGO_INV                      0x00000000
//    </h>
//  </h>

//  <e0.0> TM00 interrupt all enable (IEA)
          #define CONF_TM00_INT_IEA                         0x00000000
//      <q0.3> Timer external trigger interrupt (EXIE)
          #define CONF_TM00_INT_EXIE                        0x00000000
//      <q0.4> Timer overflow/underflow interrupt (TIE)
          #define CONF_TM00_INT_TIE                         0x00000000
//      <q0.5> 2nd Timer overflow/underflow interrupt (TIE2)
          #define CONF_TM00_INT_TIE2                        0x00000000
//  </e>
//</e>

//<e0.0> Configure TM01 Module
    #define CONF_TM01_MODE                                  0x00000000
//  <h> TM01 Timer Base Recipe
//    <o0.0..7> Main counter range <0-255>
      #define CONF_TM01_CNT                                 0x00000080
//    <o0.0..7> Prescaler counter range <0-255>
      #define CONF_TM01_PSNT                                0x00000080
//    <o0.4..5> Operation mode (Up count) <0=> Cascade : 8-bit counter with 8-bit prescaler  Mode 
//                                        <1=> Separate : Separated two 8-bit counters Mode 
//                                        <2=> Full-Counter : 16-bit counter Mode
      #define CONF_TM01_CR0_MDS                             0x00000000
//    <h> Config Timer Clock Source
//      <o0.6..7> Main / Prescaler counter clock source <0=> Internal clock <3=> External Clock
        #define CONF_TM01_CLK_CKS_SEL                       0x00000000
//      <h> Internal Clock 
//        <o0.8..9> Internal Clock Source <0=> CK_TMx_PR <2=> CK_LS
          #define CONF_TM01_CLK_CKI_SEL                     0x00000000
//        <o0.12..13> Internal Clock divider <0=> DIV1 : divided by 1 <1=> DIV2 : divided by 2 
//                                           <2=> DIV4 : divided by 4 <3=> DIV8 : divided by 8
          #define CONF_TM01_CLK_CKI_DIV                     0x00000000
//      </h>      
//      <h> External Clock 
//        <o0.4..6> External Clock Source <0=> ETR (CK_ETR) <1=> ITR (CK_ITR)
          #define CONF_TM01_CLK_CKE_SEL                     0x00000000
//        <o0.8..10> ITR Select <0=> ITR0 <1=> ITR1 <2=> ITR2 <3=> ITR3 <4=> ITR4 <5=> ITR5 <6=>ITR6 <7=> ITR7
          #define CONF_TM01_TRG_ITR_MUX                     0x00000000
//      </h>      
//    </h> 
//    <h> External Trigger (EXF)
//      <o0.10..11> (1st) Accept External trigger -> Assert EXF <0=> Disable external trigger 
//                                                              <1=> Accept external trigger 
//                                                              <2=> Accept external trigger with inversion
        #define CONF_TM01_CR0_EX_EN                         0x00000000
//      <o0.15> (2nd) Update event accepts EXF <0=> Disable <1=> Enable
        #define CONF_TM01_CR0_UEX_EN                        0x00000000
//    </h>
//    <h> ClockOut Configuration
//      <q0.0> Timer overflow as CKO output enable
        #define CONF_TM01_CKO_CKO_EN                        0x00000000
//      <o0.2..3> CKO initial state <0=> Disable external trigger <2=> Output 0 <3=> Output 1
        #define CONF_TM01_CKO_CKO_STA                       0x00000000
//      <o0.1> CKO toggle event select <0=> Prescaler counter overflow <1=> Main counter overflow
        #define CONF_TM01_CKO_CKO_SEL                       0x00000000
//    </h>
//    <h> TRGI Input (TRGI)
//      <o0.6..7> (TRGI) Timer trigger source from <0=> ETR (CK_ETR) 
//                                                 <1=> ITR (CK_ITR)
        #define CONF_TM01_TRG_TRG_MUX                       0x00000000
//      <o0.0..2> (TRGI) Main counter trigger input mode <0=> No operation 
//                                                       <1=> Trigger-R (TRGI rising) 
//                                                       <2=> Reset-R (TRGI rising) 
//                                                       <3=> Gate-H (TRGI high) 
//                                                       <4=> Reset (TRGI dual edge) 
//                                                       <5=> Trigger-F (TRGI falling)
//                                                       <6=> Reset-F (TRGI falling) 
//                                                       <7=> Gate-L (TRGI low)
        #define CONF_TM01_TRG_TRGI_MDS                      0x00000000
//      <o0.3..5> (TRGI) Prescaler counter trigger input mode <0=> No operation 
//                                                            <1=> Trigger-R (TRGI rising) 
//                                                            <2=> Reset-R (TRGI rising) 
//                                                            <3=> Gate-H (TRGI high) 
//                                                            <4=> Reset (TRGI dual edge) 
//                                                            <5=> Trigger-F (TRGI falling)
//                                                            <6=> Reset-F (TRGI falling) 
//                                                            <7=> Gate-L (TRGI low)
        #define CONF_TM01_TRG_TRGI2_MDS                     0x00000000
//    </h>
//    <h> TRGO Output (TRGO)
//      <o.12..15> (TRGO) Timer trigger output mode select <0=>  RST : TMxx_RST (Main Timer Reset)     
//                                                        <1=>  EN : TMxx_EN (Main Timer Enable)      
//                                                        <2=>  UEV : TMxx_UEV (Main Timer Update event)      
//                                                        <3=>  TOF : TMxx_TOF (Main Timer overflow)      
//                                                        <4=>  TUF : TMxx_TUF (Main Timer underflow)     
//                                                        <5=>  EN2 : TMxx_EN2 (Timer-2 Enable)     
//                                                        <6=>  TOF2 :TMxx_TOF2 (Timer-2 overflow)      
//                                                        <7=>  DIR : TMxx_DIR (Main Timer direction event)     
//                                                        <8=>  UEV2 : TMxx_UEV2 (Timer-2 Update event)     
//                                                        <9=>  SW : TMxx_TRGO_SW (software control bit)      
//                                                        <14=> TRGI : TMxx_TRGI (internal TRGI signal)     
        #define CONF_TM01_TRG_TRGO_MDS                      0x00000000
//      <o0.22..23> (TRGO) Timer UEV event source select <0=> All : output all UEV pulses <1=> TOF : output timer overflow pulses <2=> UDF : output timer underflow pulses
        #define CONF_TM01_TRG_UEV_SEL                       0x00000000
//      <o0.12> UEV Function via main counter <0=> Enable <1=> Disable
//        <i> Update event is generation from counter overflow/underflow or software register forced bit.
        #define CONF_TM01_CR0_UEV_DIS                       0x00000000
//      <o0.25> (TRGO) Timer TRGO output inverse enable bit <0=> Disable <1=> Enable
        #define CONF_TM01_TRG_TRGO_INV                      0x00000000
//    </h>
//  </h>

//  <e0.0> TM01 interrupt all enable (IEA)
          #define CONF_TM01_INT_IEA                         0x00000000
//      <q0.3> Timer external trigger interrupt (EXIE)
          #define CONF_TM01_INT_EXIE                        0x00000000
//      <q0.4> Timer overflow/underflow interrupt (TIE)
          #define CONF_TM01_INT_TIE                         0x00000000
//      <q0.5> 2nd Timer overflow/underflow interrupt (TIE2)
          #define CONF_TM01_INT_TIE2                        0x00000000
//  </e>
//</e>

//<e0.0> Configure TM10 Module
    #define CONF_TM10_MODE                                  0x00000000
//  <h> TM10 Timer Base Recipe
//    <o0.0..15> Main counter range <0-65535>
      #define CONF_TM10_CNT                                 0x00008000
//    <o0.0..15> Prescaler counter range <0-65535>
      #define CONF_TM10_PSNT                                0x00008000
//    <o0.4..5> Operation mode (Up count) <0=> Cascade : 16-bit counter with 16-bit prescaler Mode 
//                                        <1=> Separate : Separated two 16-bit counters Mode 
//                                        <2=> Full-Counter : 32-bit counter Mode
      #define CONF_TM10_CR0_MDS                             0x00000000
//    <h> Config Timer Clock Source
//      <o0.6..7> Main / Prescaler counter clock source <0=> Internal clock <3=> External Clock
        #define CONF_TM10_CLK_CKS_SEL                       0x00000000
//      <h> Internal Clock 
//        <o0.8..9> Internal Clock Source <0=> CK_TMx_PR <2=> CK_LS
          #define CONF_TM10_CLK_CKI_SEL                     0x00000000
//        <o0.12..13> Internal Clock divider <0=> DIV1 : divided by 1 <1=> DIV2 : divided by 2 
//                                           <2=> DIV4 : divided by 4 <3=> DIV8 : divided by 8
          #define CONF_TM10_CLK_CKI_DIV                     0x00000000
//      </h>      
//      <h> External Clock 
//        <o0.4..6> External Clock Source <0=> ETR (CK_ETR) <1=> ITR (CK_ITR)
          #define CONF_TM10_CLK_CKE_SEL                     0x00000000
//        <o0.8..10> ITR Select <0=> ITR0 <1=> ITR1 <2=> ITR2 <3=> ITR3 <4=> ITR4 <5=> ITR5 <6=>ITR6 <7=> ITR7
          #define CONF_TM10_TRG_ITR_MUX                     0x00000000
//      </h>      
//    </h> 
//    <h> External Trigger (EXF)
//      <o0.10..11> (1st) Accept External trigger -> Assert EXF <0=> Disable external trigger 
//                                                              <1=> Accept external trigger 
//                                                              <2=> Accept external trigger with inversion
        #define CONF_TM10_CR0_EX_EN                         0x00000000
//      <o0.15> (2nd) Update event accepts EXF <0=> Disable <1=> Enable
        #define CONF_TM10_CR0_UEX_EN                        0x00000000
//    </h>
//    <h> ClockOut Configuration
//      <q0.0> Timer overflow as CKO output enable
        #define CONF_TM10_CKO_CKO_EN                        0x00000000
//      <o0.2..3> CKO initial state <0=> Disable external trigger <2=> Output 0 <3=> Output 1
        #define CONF_TM10_CKO_CKO_STA                       0x00000000
//      <o0.1> CKO toggle event select <0=> Prescaler counter overflow <1=> Main counter overflow
        #define CONF_TM10_CKO_CKO_SEL                       0x00000000
//    <o0.8..9> Repeatability parameter <0=> Always clock out <3=> Output once cycle (+With Trigger event to start)
      #define CONF_TM10_CR0_ASTOP_EN                        0x00000000
//    </h>
//    <h> TRGI Input (TRGI)
//      <o0.6..7> (TRGI) Timer trigger source from <0=> ETR (CK_ETR) 
//                                                 <1=> ITR (CK_ITR)
        #define CONF_TM10_TRG_TRG_MUX                       0x00000000
//      <o0.0..2> (TRGI) Main counter trigger input mode <0=> No operation 
//                                                       <1=> Trigger-R (TRGI rising) 
//                                                       <2=> Reset-R (TRGI rising) 
//                                                       <3=> Gate-H (TRGI high) 
//                                                       <4=> Reset (TRGI dual edge) 
//                                                       <5=> Trigger-F (TRGI falling)
//                                                       <6=> Reset-F (TRGI falling) 
//                                                       <7=> Gate-L (TRGI low)
        #define CONF_TM10_TRG_TRGI_MDS                      0x00000000
//      <o0.3..5> (TRGI) Prescaler counter trigger input mode <0=> No operation 
//                                                            <1=> Trigger-R (TRGI rising) 
//                                                            <2=> Reset-R (TRGI rising) 
//                                                            <3=> Gate-H (TRGI high) 
//                                                            <4=> Reset (TRGI dual edge) 
//                                                            <5=> Trigger-F (TRGI falling)
//                                                            <6=> Reset-F (TRGI falling) 
//                                                            <7=> Gate-L (TRGI low)
        #define CONF_TM10_TRG_TRGI2_MDS                     0x00000000
//    </h>
//    <h> TRGO Output (TRGO)
//      <o.12..15> (TRGO) Timer trigger output mode select <0=>  RST : TMxx_RST (Main Timer Reset)     
//                                                        <1=>  EN : TMxx_EN (Main Timer Enable)      
//                                                        <2=>  UEV : TMxx_UEV (Main Timer Update event)      
//                                                        <3=>  TOF : TMxx_TOF (Main Timer overflow)      
//                                                        <4=>  TUF : TMxx_TUF (Main Timer underflow)     
//                                                        <5=>  EN2 : TMxx_EN2 (Timer-2 Enable)     
//                                                        <6=>  TOF2 :TMxx_TOF2 (Timer-2 overflow)      
//                                                        <7=>  DIR : TMxx_DIR (Main Timer direction event)     
//                                                        <8=>  UEV2 : TMxx_UEV2 (Timer-2 Update event)     
//                                                        <9=>  SW : TMxx_TRGO_SW (software control bit)      
//                                                        <14=> TRGI : TMxx_TRGI (internal TRGI signal)     
        #define CONF_TM10_TRG_TRGO_MDS                      0x00000000
//      <o0.22..23> (TRGO) Timer UEV event source select <0=> All : output all UEV pulses <1=> TOF : output timer overflow pulses <2=> UDF : output timer underflow pulses
        #define CONF_TM10_TRG_UEV_SEL                       0x00000000
//      <o0.12> UEV Function via main counter <0=> Enable <1=> Disable
//        <i> Update event is generation from counter overflow/underflow or software register forced bit.
        #define CONF_TM10_CR0_UEV_DIS                       0x00000000
//      <o0.25> (TRGO) Timer TRGO output inverse enable bit <0=> Disable <1=> Enable
        #define CONF_TM10_TRG_TRGO_INV                      0x00000000
//    </h>
//  </h>

//  <e0.0> TM10 interrupt all enable (IEA)
          #define CONF_TM10_INT_IEA                         0x00000000
//      <q0.3> Timer external trigger interrupt (EXIE)
          #define CONF_TM10_INT_EXIE                        0x00000000
//      <q0.4> Timer overflow/underflow interrupt (TIE)
          #define CONF_TM10_INT_TIE                         0x00000000
//      <q0.5> 2nd Timer overflow/underflow interrupt (TIE2)
          #define CONF_TM10_INT_TIE2                        0x00000000
//  </e>
//</e>

//<e0.0> Configure TM16 Module
    #define CONF_TM16_MODE                                  0x00000000
//  <h> TM16 Timer Base Recipe
//    <o0.0..15> Main counter range <0-65535>
      #define CONF_TM16_CNT                                 0x00008000
//    <o0.0..15> Prescaler counter range <0-65535>
      #define CONF_TM16_PSNT                                0x00008000
//    <o0.4..5> Operation mode (Up count) <0=> Cascade : 16-bit counter with 16-bit prescaler Mode 
//                                        <1=> Separate : Separated two 16-bit counters Mode 
//                                        <2=> Full-Counter : 32-bit counter Mode
      #define CONF_TM16_CR0_MDS                             0x00000000
//    <o0.6..7> Up or down count <0=> Up count (Main and prescaler count direction) 
//                               <3=> Down count (Main & Prescaler count direction)
      #define CONF_TM16_CR0_DIR                             0x00000000
//    <h> Config Timer Clock Source
//      <o0.6..7> Main / Prescaler counter clock source <0=> Internal clock <3=> External Clock
        #define CONF_TM16_CLK_CKS_SEL                       0x00000000
//      <h> Internal Clock 
//        <o0.8..9> Internal Clock Source <0=> CK_TMx_PR <2=> CK_LS
          #define CONF_TM16_CLK_CKI_SEL                     0x00000000
//        <o0.12..13> Internal Clock divider <0=> DIV1 : divided by 1 <1=> DIV2 : divided by 2 
//                                           <2=> DIV4 : divided by 4 <3=> DIV8 : divided by 8
          #define CONF_TM16_CLK_CKI_DIV                     0x00000000
//      </h>      
//      <h> External Clock 
//        <o0.4..6> External Clock Source <0=> ETR (CK_ETR) <1=> ITR (CK_ITR)
          #define CONF_TM16_CLK_CKE_SEL                     0x00000000
//        <o0.8..10> ITR Select <0=> ITR0 <1=> ITR1 <2=> ITR2 <3=> ITR3 <4=> ITR4 <5=> ITR5 <6=>ITR6 <7=> ITR7
          #define CONF_TM16_TRG_ITR_MUX                     0x00000000
//      </h>      
//    </h> 
//    <h> External Trigger (EXF)
//      <o0.10..11> (1st) Accept External trigger -> Assert EXF <0=> Disable external trigger 
//                                                              <1=> Accept external trigger 
//                                                              <2=> Accept external trigger with inversion
        #define CONF_TM16_CR0_EX_EN                         0x00000000
//      <o0.15> (2nd) Update event accepts EXF <0=> Disable <1=> Enable
        #define CONF_TM16_CR0_UEX_EN                        0x00000000
//    </h>
//    <h> ClockOut Configuration
//      <q0.0> Timer overflow as CKO output enable
        #define CONF_TM16_CKO_CKO_EN                        0x00000000
//      <o0.2..3> CKO initial state <0=> Disable external trigger <2=> Output 0 <3=> Output 1
        #define CONF_TM16_CKO_CKO_STA                       0x00000000
//      <o0.1> CKO toggle event select <0=> Prescaler counter overflow <1=> Main counter overflow
        #define CONF_TM16_CKO_CKO_SEL                       0x00000000
//    <o0.8..9> Repeatability parameter <0=> Always clock out <3=> Output once cycle (+With Trigger event to start)
      #define CONF_TM16_CR0_ASTOP_EN                        0x00000000
//    </h>
//    <h> TRGI Input (TRGI)
//      <o0.6..7> (TRGI) Timer trigger source from <0=> ETR (CK_ETR) 
//                                                 <1=> ITR (CK_ITR)
        #define CONF_TM16_TRG_TRG_MUX                       0x00000000
//      <o0.0..2> (TRGI) Main counter trigger input mode <0=> No operation 
//                                                       <1=> Trigger-R (TRGI rising) 
//                                                       <2=> Reset-R (TRGI rising) 
//                                                       <3=> Gate-H (TRGI high) 
//                                                       <4=> Reset (TRGI dual edge) 
//                                                       <5=> Trigger-F (TRGI falling)
//                                                       <6=> Reset-F (TRGI falling) 
//                                                       <7=> Gate-L (TRGI low)
        #define CONF_TM16_TRG_TRGI_MDS                      0x00000000
//      <o0.3..5> (TRGI) Prescaler counter trigger input mode <0=> No operation 
//                                                            <1=> Trigger-R (TRGI rising) 
//                                                            <2=> Reset-R (TRGI rising) 
//                                                            <3=> Gate-H (TRGI high) 
//                                                            <4=> Reset (TRGI dual edge) 
//                                                            <5=> Trigger-F (TRGI falling)
//                                                            <6=> Reset-F (TRGI falling) 
//                                                            <7=> Gate-L (TRGI low)
        #define CONF_TM16_TRG_TRGI2_MDS                     0x00000000
//    </h>
//    <h> TRGO Output (TRGO)
//      <o.12..15> (TRGO) Timer trigger output mode select <0=>  RST : TMxx_RST (Main Timer Reset)     
//                                                        <1=>  EN : TMxx_EN (Main Timer Enable)      
//                                                        <2=>  UEV : TMxx_UEV (Main Timer Update event)      
//                                                        <3=>  TOF : TMxx_TOF (Main Timer overflow)      
//                                                        <4=>  TUF : TMxx_TUF (Main Timer underflow)     
//                                                        <5=>  EN2 : TMxx_EN2 (Timer-2 Enable)     
//                                                        <6=>  TOF2 :TMxx_TOF2 (Timer-2 overflow)      
//                                                        <7=>  DIR : TMxx_DIR (Main Timer direction event)     
//                                                        <8=>  UEV2 : TMxx_UEV2 (Timer-2 Update event)     
//                                                        <9=>  SW : TMxx_TRGO_SW (software control bit)      
//                                                        <14=> TRGI : TMxx_TRGI (internal TRGI signal)     
        #define CONF_TM16_TRG_TRGO_MDS                      0x00000000
//      <o0.22..23> (TRGO) Timer UEV event source select <0=> All : output all UEV pulses <1=> TOF : output timer overflow pulses <2=> UDF : output timer underflow pulses
        #define CONF_TM16_TRG_UEV_SEL                       0x00000000
//      <o0.12> UEV Function via main counter <0=> Enable <1=> Disable
//        <i> Update event is generation from counter overflow/underflow or software register forced bit.
        #define CONF_TM16_CR0_UEV_DIS                       0x00000000
//      <o0.25> (TRGO) Timer TRGO output inverse enable bit <0=> Disable <1=> Enable
        #define CONF_TM16_TRG_TRGO_INV                      0x00000000
//    </h>
//  </h>

//  <e0.0> TM16 interrupt all enable (IEA)
          #define CONF_TM16_INT_IEA                         0x00000000
//      <q0.3> Timer external trigger interrupt (EXIE)
          #define CONF_TM16_INT_EXIE                        0x00000000
//      <q0.4> Timer overflow/underflow interrupt (TIE)
          #define CONF_TM16_INT_TIE                         0x00000000
//      <q0.5> 2nd Timer overflow/underflow interrupt (TIE2)
          #define CONF_TM16_INT_TIE2                        0x00000000
//  </e>
//</e>

//<e0.0> Configure TM36 Module
    #define CONF_TM36_MODE                                  0x00000000
//  <h> TM36 Timer Base Recipe
//    <o0.0..15> Main counter range <0-65535>
      #define CONF_TM36_CNT                                 0x00008000
//    <o0.0..15> Prescaler counter range <0-65535>
      #define CONF_TM36_PSNT                                0x00008000
//    <o0.4..5> Operation mode (Up count) <0=> Cascade : 16-bit counter with 16-bit prescaler Mode 
//                                        <1=> Separate : Separated two 16-bit counters Mode 
//                                        <2=> Full-Counter : 32-bit counter Mode
      #define CONF_TM36_CR0_MDS                             0x00000000
//    <o0.6..7> Up or down count <0=> Up count (Main and prescaler count direction) 
//                               <3=> Down count (Main & Prescaler count direction)
      #define CONF_TM36_CR0_DIR                             0x00000000
//    <h> Config Timer Clock Source
//      <o0.6..7> Main / Prescaler counter clock source <0=> Internal clock <3=> External Clock
        #define CONF_TM36_CLK_CKS_SEL                       0x00000000
//      <h> Internal Clock 
//        <o0.8..9> Internal Clock Source <0=> CK_TMx_PR <2=> CK_LS
          #define CONF_TM36_CLK_CKI_SEL                     0x00000000
//        <o0.12..13> Internal Clock divider <0=> DIV1 : divided by 1 <1=> DIV2 : divided by 2 
//                                           <2=> DIV4 : divided by 4 <3=> DIV8 : divided by 8
          #define CONF_TM36_CLK_CKI_DIV                     0x00000000
//      </h>      
//      <h> External Clock 
//        <o0.4..6> External Clock Source <0=> ETR (CK_ETR) 
//                                        <1=> ITR (CK_ITR)
//                                        <2=> IN0 (TMxx_IN0)
//                                        <3=> IN1 (TMxx_IN1)
          #define CONF_TM36_CLK_CKE_SEL                     0x00000000
//        <o0.8..10> ITR Select <0=> ITR0 <1=> ITR1 <2=> ITR2 <3=> ITR3 <4=> ITR4 <5=> ITR5 <6=>ITR6 <7=> ITR7
          #define CONF_TM36_TRG_ITR_MUX                     0x00000000
//      </h>      
//    </h> 
//    <h> External Trigger (EXF)
//      <o0.10..11> (1st) Accept External trigger -> Assert EXF <0=> Disable external trigger 
//                                                              <1=> Accept external trigger 
//                                                              <2=> Accept external trigger with inversion
        #define CONF_TM36_CR0_EX_EN                         0x00000000
//      <o0.15> (2nd) Update event accepts EXF <0=> Disable <1=> Enable
        #define CONF_TM36_CR0_UEX_EN                        0x00000000
//    </h>
//    <h> ClockOut Configuration
//      <q0.0> Timer overflow as CKO output enable
        #define CONF_TM36_CKO_CKO_EN                        0x00000000
//      <o0.2..3> CKO initial state <0=> Disable external trigger <2=> Output 0 <3=> Output 1
        #define CONF_TM36_CKO_CKO_STA                       0x00000000
//      <o0.1> CKO toggle event select <0=> Prescaler counter overflow <1=> Main counter overflow
        #define CONF_TM36_CKO_CKO_SEL                       0x00000000
//    </h>
//    <h> TRGI Input (TRGI)
//      <o0.6..7> (TRGI) Timer trigger source from <0=> ETR (CK_ETR) 
//                                                 <1=> ITR (CK_ITR)
//                                                 <2=> IN0 (TMxx_IN0)
//                                                 <3=> IN1 (TMxx_IN1)
        #define CONF_TM36_TRG_TRG_MUX                       0x00000000
//      <o0.0..2> (TRGI) Main counter trigger input mode <0=> No operation 
//                                                       <1=> Trigger-R (TRGI rising) 
//                                                       <2=> Reset-R (TRGI rising) 
//                                                       <3=> Gate-H (TRGI high) 
//                                                       <4=> Reset (TRGI dual edge) 
//                                                       <5=> Trigger-F (TRGI falling)
//                                                       <6=> Reset-F (TRGI falling) 
//                                                       <7=> Gate-L (TRGI low)
        #define CONF_TM36_TRG_TRGI_MDS                      0x00000000
//      <o0.3..5> (TRGI) Prescaler counter trigger input mode <0=> No operation 
//                                                            <1=> Trigger-R (TRGI rising) 
//                                                            <2=> Reset-R (TRGI rising) 
//                                                            <3=> Gate-H (TRGI high) 
//                                                            <4=> Reset (TRGI dual edge) 
//                                                            <5=> Trigger-F (TRGI falling)
//                                                            <6=> Reset-F (TRGI falling) 
//                                                            <7=> Gate-L (TRGI low)
        #define CONF_TM36_TRG_TRGI2_MDS                     0x00000000
//    </h>
//    <h> TRGO Output (TRGO)
//      <o.12..15> (TRGO) Timer trigger output mode select <0=>  RST : TMxx_RST (Main Timer Reset)     
//                                                        <1=>  EN : TMxx_EN (Main Timer Enable)      
//                                                        <2=>  UEV : TMxx_UEV (Main Timer Update event)      
//                                                        <3=>  TOF : TMxx_TOF (Main Timer overflow)      
//                                                        <4=>  TUF : TMxx_TUF (Main Timer underflow)     
//                                                        <5=>  EN2 : TMxx_EN2 (Timer-2 Enable)     
//                                                        <6=>  TOF2 :TMxx_TOF2 (Timer-2 overflow)      
//                                                        <7=>  DIR : TMxx_DIR (Main Timer direction event)     
//                                                        <8=>  UEV2 : TMxx_UEV2 (Timer-2 Update event)     
//                                                        <9=>  SW : TMxx_TRGO_SW (software control bit)      
//                                                        <10=> OS0 : TMxx_OS0 (channel-0 output state signal)      
//                                                        <11=> OS1 : TMxx_OS1 (channel-1 output state signal)      
//                                                        <12=> OS2 : TMxx_OS2 (channel-2 output state signal)      
//                                                        <13=> OS3 : TMxx_OS3 (channel-3 output state signal)      
//                                                        <14=> TRGI : TMxx_TRGI (internal TRGI signal)     
        #define CONF_TM36_TRG_TRGO_MDS                      0x00000000
//      <o0.22..23> (TRGO) Timer UEV event source select <0=> All : output all UEV pulses <1=> TOF : output timer overflow pulses <2=> UDF : output timer underflow pulses
        #define CONF_TM36_TRG_UEV_SEL                       0x00000000
//      <o0.12> UEV Function via main counter <0=> Enable <1=> Disable
//        <i> Update event is generation from counter overflow/underflow or software register forced bit.
        #define CONF_TM36_CR0_UEV_DIS                       0x00000000
//      <o0.25> (TRGO) Timer TRGO output inverse enable bit <0=> Disable <1=> Enable
        #define CONF_TM36_TRG_TRGO_INV                      0x00000000
//    </h>
//    <h> QEI Control
//      <o0.16..18> QEI Mode <0=> No operation (Disable QEI)      
//                           <1=> N0POS : TMx_IN0 positive (high level up count, low level down count)      
//                           <2=> IN0NEG : TMx_IN0 negative (low level up count, high level down count)   
//                           <3=> IN0TRG : TMx_IN0 trigger (edge depending on TMx_IN1 level)      
//                           <4=> IN1TRG : TMx_IN1 trigger (edge depending on TMx_IN0 level)      
//                           <5=> BOTH : Both TMx_IN0 and TMx_IN1 edge    
        #define CONF_TM36_TRG_QEI_MDS                       0x00000000
//      <h> QEI Index Signal      
//        <q0.19> Accept IDX to reset main counter  
          #define CONF_TM36_TRG_IDX_EN                      0x00000000
//        <o0.20..21> QEI IDX reset transition state selection
//                          <0=>  1T2 : State change between 1 and 2      
//                          <1=>  2T3 : State change between 2 and 3      
//                          <2=>  3T4 : State change between 3 and 4      
//                          <3=>  4T1 : State change between 4 and 1      
          #define CONF_TM36_TRG_IDX_MDS                     0x00000000
//      </h>
//    </h>
//    <h> Channel0
//      <o0.0..2> Channel-0 function <0=> Disable
//                                   <1=> 16bit_IC (Input Capture)
//                                   <2=> 16bit_OC (Output Compare)
//                                   <3=> 8bitx2_OC (Two 8bit Compare)
//                                   <4=> 16bit_PWM (16bi PWM)
//                                   <5=> 8bitx2_PWM (Two 8bit PWMs)
//                                   <6=> 16bit_PWM_DTG (16bit PWM with DTG)      
//                                   <7=> 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)     
        #define CONF_TM36_CCMDS_CC0_MDS                     0x00000000
//      <h> Input Capture
//        <o0.0..1> Trigger Source Select <0=> TMx_InputMUX_Pin 
//                                        <1=> TMx_InputMUX_ITR (ITR) 
//                                        <2=> TMx_InputMUX_Select2 
//                                        <3=> TMx_InputMUX_Select3
          #define CONF_TM36_ICCR_IC0_MUX                    0x00000000
//        <o0.16..17> Trigger Edge Select <0=> Disable : disable capture data 
//                                        <1=> Rising edge 
//                                        <2=> Falling edge 
//                                        <3=> Dual-edge
          #define CONF_TM36_ICCR_IC0_TRGS                   0x00000000
//        <q0.0> Keep capture data
          #define CONF_TM36_CR1_OVR0_MDS                    0x00000000
//      </h>
//      <h> Output Compare / PWM Duty Cycle - Match Point
//        <o0.0..15> (OC) Output Compare - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC0A_OC                         0x00000000
//        <o0.0..15> (PWM) Duty Cycle - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC0A_PWM                        0x00000000
//      </h>
//    </h>
//    <h> Channel1
//      <o0.4..6> Channel-1 function <0=> Disable
//                                   <1=> 16bit_IC (Input Capture)
//                                   <2=> 16bit_OC (Output Compare)
//                                   <3=> 8bitx2_OC (Two 8bit Compare)
//                                   <4=> 16bit_PWM (16bi PWM)
//                                   <5=> 8bitx2_PWM (Two 8bit PWMs)
//                                   <6=> 16bit_PWM_DTG (16bit PWM with DTG)      
//                                   <7=> 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)     
        #define CONF_TM36_CCMDS_CC1_MDS                     0x00000000
//      <h> Input Capture
//        <o0.4..5> Trigger Source Select <0=> TMx_InputMUX_Pin 
//                                        <1=> TMx_InputMUX_ITR (ITR) 
//                                        <2=> TMx_InputMUX_Select2 
//                                        <3=> TMx_InputMUX_Select3
          #define CONF_TM36_ICCR_IC1_MUX                    0x00000000
//        <o0.18..19> Trigger Edge Select <0=> Disable : disable capture data 
//                                        <1=> Rising edge 
//                                        <2=> Falling edge 
//                                        <3=> Dual-edge
          #define CONF_TM36_ICCR_IC1_TRGS                   0x00000000
//        <q0.1> Keep capture data
          #define CONF_TM36_CR1_OVR1_MDS                    0x00000000
//      </h>
//      <h> Output Compare / PWM Duty Cycle - Match Point
//        <o0.0..15> (OC) Output Compare - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC1A_OC                         0x00000000
//        <o0.0..15> (PWM) Duty Cycle - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC1A_PWM                        0x00000000
//      </h>
//    </h>
//    <h> Channel2
//      <o0.8..10> Channel-2 function <0=> Disable
//                                    <1=> 16bit_IC (Input Capture)
//                                    <2=> 16bit_OC (Output Compare)
//                                    <3=> 8bitx2_OC (Two 8bit Compare)
//                                    <4=> 16bit_PWM (16bi PWM)
//                                    <5=> 8bitx2_PWM (Two 8bit PWMs)
//                                    <6=> 16bit_PWM_DTG (16bit PWM with DTG)      
//                                    <7=> 8bitx2_PWM_DTG (Two 8bit PWMs with DTG)     
        #define CONF_TM36_CCMDS_CC2_MDS                     0x00000000
//      <h> Input Capture
//        <o0.8..9> Trigger Source Select <0=> TMx_InputMUX_Pin 
//                                        <1=> TMx_InputMUX_ITR (ITR) 
//                                        <2=> TMx_InputMUX_Select2 
//                                        <3=> TMx_InputMUX_Select3
          #define CONF_TM36_ICCR_IC2_MUX                    0x00000000
//        <o0.20..21> Trigger Edge Select <0=> Disable : disable capture data 
//                                        <1=> Rising edge 
//                                        <2=> Falling edge 
//                                        <3=> Dual-edge
          #define CONF_TM36_ICCR_IC2_TRGS                   0x00000000
//        <q0.2> Keep capture data
          #define CONF_TM36_CR1_OVR2_MDS                    0x00000000
//      </h>
//      <h> Output Compare / PWM Duty Cycle - Match Point
//        <o0.0..15> (OC) Output Compare - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC2A_OC                         0x00000000
//        <o0.0..15> (PWM) Duty Cycle - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC2A_PWM                        0x00000000
//      </h>
//    </h>
//    <h> Channel3
//      <o0.12..14> Channel-3 function <0=> Disable
//                                     <1=> 16bit_IC (Input Capture)
//                                     <2=> 16bit_OC (Output Compare)
//                                     <3=> 8bitx2_OC (Two 8bit Compare)
//                                     <4=> 16bit_PWM (16bi PWM)
//                                     <5=> 8bitx2_PWM (Two 8bit PWMs)
        #define CONF_TM36_CCMDS_CC3_MDS                     0x00000000
//      <h> Input Capture
//        <o0.12..13> Trigger Source Select <0=> TMx_InputMUX_Pin 
//                                          <1=> TMx_InputMUX_ITR (ITR) 
//                                          <2=> TMx_InputMUX_Select2 
//                                          <3=> TMx_InputMUX_Select3
          #define CONF_TM36_ICCR_IC3_MUX                    0x00000000
//        <o0.22..23> Trigger Edge Select <0=> Disable : disable capture data 
//                                        <1=> Rising edge 
//                                        <2=> Falling edge 
//                                        <3=> Dual-edge
          #define CONF_TM36_ICCR_IC3_TRGS                   0x00000000
//        <q0.3> Keep capture data
          #define CONF_TM36_CR1_OVR3_MDS                    0x00000000
//      </h>
//      <h> Output Compare / PWM Duty Cycle - Match Point
//        <o0.0..15> (OC) Output Compare - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC3A_OC                         0x00000000
//        <o0.0..15> (PWM) Duty Cycle - (8birtx2 or 16bit ) Match Point <0-65535>
          #define CONF_TM36_CC3A_PWM                        0x00000000
//      </h>
//    </h>

//    <h> Align / Dead time / Break control
//        <o0.0..1> PWM align mode  <0=> Edge Left-aligned 
//                                  <1=> Center-aligned 
          #define CONF_TM36_PWM_PWM_MDS                     0x00000000
//      <h> Dead zone parameters
//        <o0.16..17> Dead zone : internal clock CK_DTG divider <0=> DIV1 : divided by 1 
//                                                              <1=> DIV2 : divided by 2 
//                                                              <2=> DIV4 : divided by 4 
//                                                              <3=> DIV8 : divided by 8
          #define CONF_TM36_CLK_DTG_DIV                     0x00000000
//        <o0.8..15> Dead zone : timer counter <0-255>
          #define CONF_TM36_PWM_DTG_DY                      0x00000000
//      </h>
//      <h> Break parameters
//        <o0.4> Break Mode Select <0=> Latch mode <1=> Cycle by cycle mode
          #define CONF_TM36_BS_BK_MDS                       0x00000000
//        <o0.20..23> Timer OC0/1/2/3 output control when break event happened 
//                                                 <0=> Stop (Fixed to stop state)
//                                                 <15=> Hold (hold the current output state)
          #define CONF_TM36_BS_BK03_CTL                     0x00000000
//        <o0.0..3> Break apply channel-x <0=>  Disable     
//                                        <1=>  Break apply Channel0/1/2      
//                                        <8=>  Break apply Channel3      
//                                        <9=>  Break apply All channel (Channel0/1/2/3)      
          #define CONF_TM36_BS_BK3_EN           9
//      </h>
//      <h> Break source enable
//        <q0.8> Enable Break signal from TM36_BK0 input
          #define CONF_TM36_BS_BKE_EN0                      0x00000000
//        <q0.9> Enable Break signal from INT_BOD1 input
          #define CONF_TM36_BS_BKE_EN1                      0x00000000
//        <q0.10> Enable Break signal from INT_PB input
          #define CONF_TM36_BS_BKE_EN2                      0x00000000
//        <q0.11> Enable Break signal from ADC0_OUT input
          #define CONF_TM36_BS_BKE_EN3                      0x00000000
//        <q0.12> Enable Break signal from CMP0_OUT input
          #define CONF_TM36_BS_BKE_EN4                      0x00000000
//        <q0.13> Enable Break signal from CMP1_OUT input
          #define CONF_TM36_BS_BKE_EN5                      0x00000000
//        <q0.16> Enable Break signal from missing clock detect(MCD) event input
          #define CONF_TM36_BS_BKI_EN0                      0x00000000
//        <q0.18> Enable Break signal from CPU LOCKUP event input
          #define CONF_TM36_BS_BKI_EN2                      0x00000000
//      </h>
          
//    </h>

//    <h> Output and Break output state
//      <h> Channel0
//        <o0.0> Channel0 Initial state (when Outpue Enable) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH0                        0x00000000
//        <o0.8> OC0H Initial state (when Outpue Enable and 8bit mode) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH0H                       0x00000000
//        <h> Channel0 Output Enable
//          <o0.0> OC00 output enable <0=> Disable (output by TMxx_BK0_STA setting) <1=> Enable 
            #define CONF_TM36_OCCR0_OC0_OE0                 0x00000000
//          <o0.1> OC01 output enable <0=> Disable (output by TMxx_BK0_STA setting) <1=> Enable   
            #define CONF_TM36_OCCR0_OC0_OE1                 0x00000000
//          <o0.2> OC02 output enable <0=> Disable (output by TMxx_BK0_STA setting) <1=> Enable
            #define CONF_TM36_OCCR0_OC0_OE2                 0x00000000
//          <o0.16> OC0N output enable  <0=> Disable (output by TMxx_BK0_STA setting) <1=> Enable
            #define CONF_TM36_OCCR0_OC0N_OE                 0x00000000
//        </h>
//        <h> Channel0 Inverse Control
//          <o0.0> Inverse OC00~OC02 <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC0_INV                 0x00000000
//          <o0.8> Inverse OC0N <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC0N_INV                0x00000000
//          <o0.4> Inverse OC0H (8bit mode) <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC0H_INV                0x00000000
//        </h>
//        <h> Break state
//          <o0.24> OC00~OC02 Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP0_STA                   0x00000000
//          <o0.28> OC0N Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP0N_STA                  0x00000000
//        </h>
//      </h>
//      <h> Channel1
//        <o0.1> Channel1 Initial state (when Outpue Enable) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH1                        0x00000000
//        <o0.9> OC1H Initial state (when Outpue Enable and 8bit mode) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH1H                       0x00000000
//        <h> Channel1 Output Enable
//          <o0.4> OC10 output enable <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable 
            #define CONF_TM36_OCCR0_OC1_OE0                 0x00000000
//          <o0.5> OC11 output enable <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable   
            #define CONF_TM36_OCCR0_OC1_OE1                 0x00000000
//          <o0.6> OC12 output enable <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable
            #define CONF_TM36_OCCR0_OC1_OE2                 0x00000000
//          <o0.20> OC1N output enable  <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable
            #define CONF_TM36_OCCR0_OC1N_OE                 0x00000000
//        </h>
//        <h> Channel1 Inverse Control
//          <o0.1> Inverse OC10~OC12 <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC1_INV                 0x00000000
//          <o0.9> Inverse OC1N <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC1N_INV                0x00000000
//          <o0.5> Inverse OC1H (8bit mode) <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC1H_INV                0x00000000
//        </h>
//        <h> Break state
//          <o0.25> OC10~OC12 Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP1_STA                   0x00000000
//          <o0.29> OC1N Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP1N_STA                  0x00000000
//        </h>
//      </h>
//      <h> Channel2
//        <o0.2> Channel2 Initial state (when Outpue Enable) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH2                        0x00000000
//        <o0.10> OC2H Initial state (when Outpue Enable and 8bit mode) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH2H                       0x00000000
//        <h> Channel2 Output Enable
//          <o0.8> OC2 output enable <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable 
            #define CONF_TM36_OCCR0_OC2_OE                  0x00000000
//          <o0.24> OC2N output enable  <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable
            #define CONF_TM36_OCCR0_OC2N_OE                 0x00000000
//        </h>
//        <h> Channel2 Inverse Control
//          <o0.2> Inverse OC2 <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC2_INV                 0x00000000
//          <o0.10> Inverse OC2N  <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC2N_INV                0x00000000
//          <o0.6> Inverse OC2H (8bit mode) <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC2H_INV                0x00000000
//        </h>
//        <h> Break state
//          <o0.26> OC2 Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP2_STA                   0x00000000
//          <o0.30> OC2N Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP2N_STA                  0x00000000
//        </h>
//      </h>
//      <h> Channel3
//        <o0.3> Channel3 Initial state (when Outpue Enable) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH3                        0x00000000
//        <o0.11> OC3H Initial state (when Outpue Enable and 8bit mode) <0=> 0 (Output 0) <1=> 1 (Output 1) 
          #define CONF_TM36_OSCR_CH3H                       0x00000000
//        <h> Channel3 Output Enable
//          <o0.12> OC3 output enable <0=> Disable (output by TMxx_BK1_STA setting) <1=> Enable 
            #define CONF_TM36_OCCR0_OC3_OE                  0x00000000
//        </h>
//        <h> Channel3 Inverse Control
//          <o0.2> Inverse OC3 <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC3_INV                 0x00000000
//          <o0.6> Inverse OC3H (8bit mode) <0=> Disable <1=> Enable
            #define CONF_TM36_OCCR1_OC3H_INV                0x00000000
//        </h>
//        <h> Break state
//          <o0.26> OC3 Break state setting <0=> 0 (Output 0) <1=> 1 (Output 1) 
            #define CONF_TM36_BS_STP3_STA                   0x00000000
//        </h>
//      </h>
//      <h> Preload function
//        <h> Preload to Timer channel 0 OC line-x
//          <q0.16> Timer channel 0 OC line-0 output enable
            #define CONF_TM36_OCCR1_OC0_POE0                0x00000000
//          <q0.17> Timer channel 0 OC line-1 output enable
            #define CONF_TM36_OCCR1_OC0_POE1                0x00000000
//          <q0.18> Timer channel 0 OC line-2 output enable
            #define CONF_TM36_OCCR1_OC0_POE2                0x00000000
//        </h>
//        <h> Preload to Timer channel 1 OC line-x
//          <q0.20> Timer channel 1 OC line-0 output enable
            #define CONF_TM36_OCCR1_OC1_POE0                0x00000000
//          <q0.21> Timer channel 1 OC line-1 output enable
            #define CONF_TM36_OCCR1_OC1_POE1                0x00000000
//          <q0.22> Timer channel 1 OC line-2 output enable
            #define CONF_TM36_OCCR1_OC1_POE2                0x00000000
//        </h>
//        <h> (Preload) Trigger source event
//          <q0.24> 3-line XOR input (TM36's IN0, IN1, IN2)
            #define CONF_TM36_OCCR1_POE_EN0                 0x00000000
//          <q0.25> INT_PB input
            #define CONF_TM36_OCCR1_POE_EN1                 0x00000000
//          <q0.26> INT_PD input
            #define CONF_TM36_OCCR1_POE_EN2                 0x00000000
//        </h>
//      </h>
//    </h>
//  </h>

//  <e0.0> TM36 interrupt all enable (IEA)
          #define CONF_TM36_INT_IEA                         0x00000000
//      <q0.2> Timer break input interrupt (BKIE)
          #define CONF_TM36_INT_BK_IE                       0x00000000
//      <q0.3> Timer external trigger interrupt (EXIE)
          #define CONF_TM36_INT_EXIE                        0x00000000
//      <q0.4> Timer overflow/underflow interrupt (TIE)
          #define CONF_TM36_INT_TIE                         0x00000000
//      <q0.5> 2nd Timer overflow/underflow interrupt (TIE2)
          #define CONF_TM36_INT_TIE2                        0x00000000
//      <q0.8> Timer IC0/OC0 interrupt (CC0_IE)
          #define CONF_TM36_INT_CC0_IE                      0x00000000
//      <q0.9> Timer IC1/OC1 interrupt (CC1_IE)
          #define CONF_TM36_INT_CC1_IE                      0x00000000
//      <q0.10> Timer IC2/OC2 interrupt (CC2_IE)
          #define CONF_TM36_INT_CC2_IE                     0x00000000
//      <q0.11> Timer IC3/OC3 interrupt (CC3_IE)
          #define CONF_TM36_INT_CC3_IE                      0x00000000
//      <q0.16> Main Timer up/down counting direction change interrupt  (DIRC_IE)
          #define CONF_TM36_INT_DIRC_IE                     0x00000000
//      <q0.18> Main Timer QEI external index signal input active detect interrupt (IDX_IE)
          #define CONF_TM36_INT_IDX_IE                      0x00000000
//      <q0.19> Main Timer QEI phase state transition error detect interrupt (QPE_IE)
          #define CONF_TM36_INT_QPE_IE                      0x00000000
//  </e>
//</e>
// <<< end of Configuration section >>>

// Combined with TMxx register bit function
// --------------------------------------------------------------------
// TM00 Module
// --------------------------------------------------------------------
#if defined(CONF_TM00_MODE)               

    // ----------------------------------------------
    #define CONF_TM00_INT   CONF_TM00_INT_IEA       |\
                            CONF_TM00_INT_EXIE      |\
                            CONF_TM00_INT_TIE       |\
                            CONF_TM00_INT_TIE2

    // ----------------------------------------------
    #define CONF_TM00_CLK   CONF_TM00_CLK_CKS_SEL   |\
                            CONF_TM00_CLK_CKI_SEL   |\
                            CONF_TM00_CLK_CKI_DIV   |\
                            CONF_TM00_CLK_CKE_SEL

    // ----------------------------------------------
    #define CONF_TM00_TRG   CONF_TM00_TRG_ITR_MUX   |\
                            CONF_TM00_TRG_TRG_MUX   |\
                            CONF_TM00_TRG_TRGI_MDS  |\
                            CONF_TM00_TRG_TRGI2_MDS |\
                            CONF_TM00_TRG_TRGO_MDS  |\
                            CONF_TM00_TRG_UEV_SEL   |\
                            CONF_TM00_TRG_TRGO_INV

    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM00_CR0_ASTOP_EN)
    #define CONF_TM00_CR0   CONF_TM00_CR0_MDS       |\
                            CONF_TM00_CR0_EX_EN     |\
                            CONF_TM00_CR0_UEV_DIS   |\
                            CONF_TM00_CR0_ASTOP_EN  |\
                            CONF_TM00_CR0_UEX_EN
    #else
    #define CONF_TM00_CR0   CONF_TM00_CR0_MDS       |\
                            CONF_TM00_CR0_EX_EN     |\
                            CONF_TM00_CR0_UEV_DIS   |\
                            CONF_TM00_CR0_UEX_EN
    #endif

    // ----------------------------------------------
    #define CONF_TM00_CKO   CONF_TM00_CKO_CKO_STA   |\
                            CONF_TM00_CKO_CKO_EN    |\
                            CONF_TM00_CKO_CKO_SEL

    // ----------------------------------------------
    // CONF_TM00_CNT            
    // CONF_TM00_PSNT           
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM00 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM00_CounterMode_Select            CONF_TM00_CR0_MDS 
    #define mTM00_Period_Select                 CONF_TM00_CNT 
    #define mTM00_Prescaler_Select              CONF_TM00_PSNT 
    
    
#endif

// --------------------------------------------------------------------
// TM01 Module
// --------------------------------------------------------------------
#if defined(CONF_TM01_MODE)               

    // ----------------------------------------------
    #define CONF_TM01_INT   CONF_TM01_INT_IEA       |\
                            CONF_TM01_INT_EXIE      |\
                            CONF_TM01_INT_TIE       |\
                            CONF_TM01_INT_TIE2

    // ----------------------------------------------
    #define CONF_TM01_CLK   CONF_TM01_CLK_CKS_SEL   |\
                            CONF_TM01_CLK_CKI_SEL   |\
                            CONF_TM01_CLK_CKI_DIV   |\
                            CONF_TM01_CLK_CKE_SEL   
                            
    // ----------------------------------------------
    #define CONF_TM01_TRG   CONF_TM01_TRG_ITR_MUX   |\
                            CONF_TM01_TRG_TRG_MUX   |\
                            CONF_TM01_TRG_TRGI_MDS  |\
                            CONF_TM01_TRG_TRGI2_MDS |\
                            CONF_TM01_TRG_TRGO_MDS  |\
                            CONF_TM01_TRG_UEV_SEL   |\
                            CONF_TM01_TRG_TRGO_INV  
                            
    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM01_CR0_ASTOP_EN)
    #define CONF_TM01_CR0   CONF_TM01_CR0_EX_EN     |\
                            CONF_TM01_CR0_UEX_EN    |\
                            CONF_TM01_CR0_MDS       |\
                            CONF_TM01_CR0_ASTOP_EN  |\
                            CONF_TM01_CR0_UEV_DIS
    #else
    #define CONF_TM01_CR0   CONF_TM01_CR0_EX_EN     |\
                            CONF_TM01_CR0_UEX_EN    |\
                            CONF_TM01_CR0_MDS       |\
                            CONF_TM01_CR0_UEV_DIS     
    #endif
                            
    // ----------------------------------------------
    #define CONF_TM01_CKO   CONF_TM01_CKO_CKO_STA   |\
                            CONF_TM01_CKO_CKO_EN    |\
                            CONF_TM01_CKO_CKO_SEL

    // ----------------------------------------------
    // CONF_TM01_CNT            
    // CONF_TM01_PSNT           
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM01 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM01_CounterMode_Select            CONF_TM01_CR0_MDS 
    #define mTM01_Period_Select                 CONF_TM01_CNT 
    #define mTM01_Prescaler_Select              CONF_TM01_PSNT 
    
    
#endif

// --------------------------------------------------------------------
// TM10 Module
// --------------------------------------------------------------------
#if defined(CONF_TM10_MODE)               

    // ----------------------------------------------
    #define CONF_TM10_INT   CONF_TM10_INT_IEA       |\
                            CONF_TM10_INT_EXIE      |\
                            CONF_TM10_INT_TIE       |\
                            CONF_TM10_INT_TIE2

    // ----------------------------------------------
    #define CONF_TM10_CLK   CONF_TM10_CLK_CKS_SEL   |\
                            CONF_TM10_CLK_CKI_SEL   |\
                            CONF_TM10_CLK_CKI_DIV   |\
                            CONF_TM10_CLK_CKE_SEL

    // ----------------------------------------------
    #define CONF_TM10_TRG   CONF_TM10_TRG_ITR_MUX   |\
                            CONF_TM10_TRG_TRG_MUX   |\
                            CONF_TM10_TRG_TRGI_MDS  |\
                            CONF_TM10_TRG_TRGI2_MDS |\
                            CONF_TM10_TRG_TRGO_MDS  |\
                            CONF_TM10_TRG_UEV_SEL   |\
                            CONF_TM10_TRG_TRGO_INV

    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM10_CR0_ASTOP_EN)
    #define CONF_TM10_CR0   CONF_TM10_CR0_MDS       |\
                            CONF_TM10_CR0_EX_EN     |\
                            CONF_TM10_CR0_UEX_EN    |\
                            CONF_TM10_CR0_ASTOP_EN  |\
                            CONF_TM10_CR0_UEV_DIS
    #else
    #define CONF_TM10_CR0   CONF_TM10_CR0_MDS       |\
                            CONF_TM10_CR0_EX_EN     |\
                            CONF_TM10_CR0_UEX_EN    |\
                            CONF_TM10_CR0_UEV_DIS
    #endif

    // ----------------------------------------------
    #define CONF_TM10_CKO   CONF_TM10_CKO_CKO_STA   |\
                            CONF_TM10_CKO_CKO_EN    |\
                            CONF_TM10_CKO_CKO_SEL     

    // ----------------------------------------------
    // CONF_TM10_CNT            
    // CONF_TM10_PSNT 
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM10 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM10_CounterMode_Select            CONF_TM10_CR0_MDS 
    #define mTM10_Period_Select                 CONF_TM10_CNT 
    #define mTM10_Prescaler_Select              CONF_TM10_PSNT 
    
    
#endif         

// --------------------------------------------------------------------
// TM16 Module
// --------------------------------------------------------------------
#if defined(CONF_TM16_MODE)               

    // ----------------------------------------------
    #define CONF_TM16_INT   CONF_TM16_INT_IEA       |\
                            CONF_TM16_INT_EXIE      |\
                            CONF_TM16_INT_TIE       |\
                            CONF_TM16_INT_TIE2      
                            
    // ----------------------------------------------
    #define CONF_TM16_CLK   CONF_TM16_CLK_CKS_SEL   |\
                            CONF_TM16_CLK_CKI_SEL   |\
                            CONF_TM16_CLK_CKI_DIV   |\
                            CONF_TM16_CLK_CKE_SEL   
                            
    // ----------------------------------------------
    #define CONF_TM16_TRG   CONF_TM16_TRG_TRG_MUX   |\
                            CONF_TM16_TRG_TRGI_MDS  |\
                            CONF_TM16_TRG_TRGI2_MDS |\
                            CONF_TM16_TRG_TRGO_MDS  |\
                            CONF_TM16_TRG_UEV_SEL   |\
                            CONF_TM16_TRG_ITR_MUX   |\
                            CONF_TM16_TRG_TRGO_INV  
                            
    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM16_CR0_ASTOP_EN)
    #define CONF_TM16_CR0   CONF_TM16_CR0_MDS       |\
                            CONF_TM16_CR0_DIR       |\
                            CONF_TM16_CR0_EX_EN     |\
                            CONF_TM16_CR0_UEX_EN    |\
                            CONF_TM16_CR0_ASTOP_EN  |\
                            CONF_TM16_CR0_UEV_DIS   
    #else
    #define CONF_TM16_CR0   CONF_TM16_CR0_MDS       |\
                            CONF_TM16_CR0_DIR       |\
                            CONF_TM16_CR0_EX_EN     |\
                            CONF_TM16_CR0_UEX_EN    |\
                            CONF_TM16_CR0_UEV_DIS   
    #endif
                            
    // ----------------------------------------------
    #define CONF_TM16_CKO   CONF_TM16_CKO_CKO_STA   |\
                            CONF_TM16_CKO_CKO_EN    |\
                            CONF_TM16_CKO_CKO_SEL

    // ----------------------------------------------
    // CONF_TM16_CNT            
    // CONF_TM16_PSNT           
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM16 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM16_CounterMode_Select            CONF_TM16_CR0_MDS 
    #define mTM16_Period_Select                 CONF_TM16_CNT 
    #define mTM16_Prescaler_Select              CONF_TM16_PSNT 
    
    
#endif

// --------------------------------------------------------------------
// TM20 Module
// --------------------------------------------------------------------
#if defined(CONF_TM20_MODE)               

    // ----------------------------------------------
    // Repetition timer underflow interrupt
    #if defined(CONF_TM20_INT_RTU_IE)
    #define PRE_TM20_INT_0  CONF_TM20_INT_RTU_IE   
    #else
    #define PRE_TM20_INT_0  0   
    #endif
    // Input duty capture complete interrupt 
    #if defined(CONF_TM20_INT_IDC_IE)
    #define PRE_TM20_INT_1  CONF_TM20_INT_IDC_IE
    #else
    #define PRE_TM20_INT_1  0 
    #endif

    #define CONF_TM20_INT   CONF_TM20_INT_IEA       |\
                            CONF_TM20_INT_EXIE      |\
                            CONF_TM20_INT_TIE       |\
                            CONF_TM20_INT_TIE2      |\
                            CONF_TM20_INT_CC0_IE    |\
                            PRE_TM20_INT_0          |\
                            PRE_TM20_INT_1          |\
                            CONF_TM20_INT_CC1_IE
                            
    // ----------------------------------------------
    #define CONF_TM20_CLK   CONF_TM20_CLK_CKS_SEL   |\
                            CONF_TM20_CLK_CKI_SEL   |\
                            CONF_TM20_CLK_CKI_DIV   |\
                            CONF_TM20_CLK_CKE_SEL
                            
    // ----------------------------------------------
    #define CONF_TM20_TRG   CONF_TM20_TRG_ITR_MUX   |\
                            CONF_TM20_TRG_TRG_MUX   |\
                            CONF_TM20_TRG_TRGI_MDS  |\
                            CONF_TM20_TRG_TRGI2_MDS |\
                            CONF_TM20_TRG_TRGO_MDS  |\
                            CONF_TM20_TRG_UEV_SEL   |\
                            CONF_TM20_TRG_TRGO_INV
                            
    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM20_CR0_ASTOP_EN)
    #define PRE_TM20_CR0_0  CONF_TM20_CR0_ASTOP_EN  
    #else
    #define PRE_TM20_CR0_0  0  
    #endif
    // Input duty capture 
    #if defined(CONF_TM20_CR0_IDC_EN)
    #define PRE_TM20_CR0_1  CONF_TM20_CR0_IDC_EN      
    #else
    #define PRE_TM20_CR0_1  0       
    #endif

    #define CONF_TM20_CR0   CONF_TM20_CR0_MDS       |\
                            CONF_TM20_CR0_EX_EN     |\
                            CONF_TM20_CR0_UEX_EN    |\
                            PRE_TM20_CR0_0          |\
                            PRE_TM20_CR0_1          |\
                            CONF_TM20_CR0_UEV_DIS
                            
    // ----------------------------------------------
    #define CONF_TM20_CR1   CONF_TM20_CR1_OVR0_MDS  |\
                            CONF_TM20_CR1_OVR1_MDS

    // ----------------------------------------------
    #define CONF_TM20_CKO   CONF_TM20_CKO_CKO_STA   |\
                            CONF_TM20_CKO_CKO_EN    |\
                            CONF_TM20_CKO_CKO_SEL

    // ----------------------------------------------
    // CONF_TM20_CNT            
    // CONF_TM20_PSNT           

    // ----------------------------------------------
    #define CONF_TM20_CCMDS CONF_TM20_CCMDS_CC0_MDS |\
                            CONF_TM20_CCMDS_CC1_MDS
                            
    // ----------------------------------------------
    #define CONF_TM20_ICCR  CONF_TM20_ICCR_IC0_MUX  |\
                            CONF_TM20_ICCR_IC0_TRGS |\
                            CONF_TM20_ICCR_IC1_MUX  |\
                            CONF_TM20_ICCR_IC1_TRGS
                            
    // ----------------------------------------------
    // with 'Write access protected control - 0x00003030'
    #define CONF_TM20_OSCR  CONF_TM20_OSCR_CH0      |\
                            CONF_TM20_OSCR_CH0H     |\
                            CONF_TM20_OSCR_CH1      |\
                            CONF_TM20_OSCR_CH1H     |\
                            0x00003030
                              
    // ----------------------------------------------
    #define CONF_TM20_OCCR0 CONF_TM20_OCCR0_OC0_OE0 |\
                            CONF_TM20_OCCR0_OC0_OE1 |\
                            CONF_TM20_OCCR0_OC0_OE2 |\
                            CONF_TM20_OCCR0_OC0N_OE |\
                            CONF_TM20_OCCR0_OC1_OE0 |\
                            CONF_TM20_OCCR0_OC1_OE1 |\
                            CONF_TM20_OCCR0_OC1_OE2 |\
                            CONF_TM20_OCCR0_OC1N_OE |\
                            CONF_TM20_OCCR1_OC0_POE0|\
                            CONF_TM20_OCCR1_OC0_POE1|\
                            CONF_TM20_OCCR1_OC0_POE2|\
                            CONF_TM20_OCCR1_OC1_POE0|\
                            CONF_TM20_OCCR1_OC1_POE1|\
                            CONF_TM20_OCCR1_OC1_POE2|\
                            CONF_TM20_OCCR1_POE_EN0 |\
                            CONF_TM20_OCCR1_POE_EN1 |\
                            CONF_TM20_OCCR1_POE_EN2
                            
    // ----------------------------------------------
    #define CONF_TM20_OCCR1 CONF_TM20_OCCR1_OC0_INV |\
                            CONF_TM20_OCCR1_OC0N_INV|\
                            CONF_TM20_OCCR1_OC0H_INV|\
                            CONF_TM20_OCCR1_OC1_INV |\
                            CONF_TM20_OCCR1_OC1N_INV|\
                            CONF_TM20_OCCR1_OC1H_INV
                            
    // ----------------------------------------------
    #define CONF_TM20_BS    CONF_TM20_BS_STP0_STA   |\
                            CONF_TM20_BS_STP0N_STA  |\
                            CONF_TM20_BS_STP1_STA   |\
                            CONF_TM20_BS_STP1N_STA
                            
    // ----------------------------------------------
    // CONF_TM20_CC0A_OC        
    // CONF_TM20_CC0A_PWM       

    // CONF_TM20_CC1A_OC        
    // CONF_TM20_CC1A_PWM       
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM20 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM20_CounterMode_Select            CONF_TM20_CR0_MDS 
    #define mTM20_Period_Select                 CONF_TM20_CNT 
    #define mTM20_Prescaler_Select              CONF_TM20_PSNT 
    
    
#endif

// --------------------------------------------------------------------
// TM26 Module
// --------------------------------------------------------------------
#if defined(CONF_TM26_MODE)               

    // ----------------------------------------------
    // Repetition timer underflow interrupt
    #if defined(CONF_TM26_INT_RTU_IE)
    #define PRE_TM26_INT_0  CONF_TM26_INT_RTU_IE   
    #else
    #define PRE_TM26_INT_0  0   
    #endif
    // Input duty capture complete interrupt 
    #if defined(CONF_TM26_INT_IDC_IE)
    #define PRE_TM26_INT_1  CONF_TM26_INT_IDC_IE
    #else
    #define PRE_TM26_INT_1  0   
    #endif

    #define CONF_TM26_INT   CONF_TM26_INT_IEA       |\
                            CONF_TM26_INT_EXIE      |\
                            CONF_TM26_INT_TIE       |\
                            CONF_TM26_INT_TIE2      |\
                            CONF_TM26_INT_CC0_IE    |\
                            CONF_TM26_INT_CC1_IE    |\
                            CONF_TM26_INT_DIRC_IE   |\
                            CONF_TM26_INT_IDX_IE    |\
                            PRE_TM26_INT_0          |\
                            PRE_TM26_INT_1          |\
                            CONF_TM26_INT_QPE_IE
                            
    // ----------------------------------------------
    #define CONF_TM26_CLK   CONF_TM26_CLK_CKS_SEL   |\
                            CONF_TM26_CLK_CKI_SEL   |\
                            CONF_TM26_CLK_CKI_DIV   |\
                            CONF_TM26_CLK_CKE_SEL
                            
    // ----------------------------------------------
    #define CONF_TM26_TRG   CONF_TM26_TRG_TRG_MUX   |\
                            CONF_TM26_TRG_TRGI_MDS  |\
                            CONF_TM26_TRG_TRGI2_MDS |\
                            CONF_TM26_TRG_TRGO_MDS  |\
                            CONF_TM26_TRG_UEV_SEL   |\
                            CONF_TM26_TRG_ITR_MUX   |\
                            CONF_TM26_TRG_TRGO_INV  |\
                            CONF_TM26_TRG_QEI_MDS   |\
                            CONF_TM26_TRG_IDX_EN    |\
                            CONF_TM26_TRG_IDX_MDS
                            
    // Check internal clock divider when QEI is activated
    #if (CONF_TM26_TRG_QEI_MDS > 0)
        #if (CONF_TM26_CLK_CKI_DIV > 0)
            #error "(TM26) The QEI function is used, but the timer cannot accept the internal clock divider (>DIV1)."
        #endif
    #endif
                            
    // ----------------------------------------------
    // Timer auto stop mode
    #if defined(CONF_TM26_CR0_ASTOP_EN)
    #define CONF_TM26_CR0   CONF_TM26_CR0_MDS       |\
                            CONF_TM26_CR0_DIR       |\
                            CONF_TM26_CR0_EX_EN     |\
                            CONF_TM26_CR0_UEX_EN    |\
                            CONF_TM26_CR0_ASTOP_EN  |\
                            CONF_TM26_CR0_UEV_DIS
    #else 
    #define CONF_TM26_CR0   CONF_TM26_CR0_MDS       |\
                            CONF_TM26_CR0_DIR       |\
                            CONF_TM26_CR0_EX_EN     |\
                            CONF_TM26_CR0_UEX_EN    |\
                            CONF_TM26_CR0_UEV_DIS
    #endif
                            
    // ----------------------------------------------
    #define CONF_TM26_CR1   CONF_TM26_CR1_OVR0_MDS  |\
                            CONF_TM26_CR1_OVR1_MDS

    // ----------------------------------------------
    #define CONF_TM26_CKO   CONF_TM26_CKO_CKO_STA   |\
                            CONF_TM26_CKO_CKO_EN    |\
                            CONF_TM26_CKO_CKO_SEL

    // ----------------------------------------------
    // CONF_TM26_CNT            
    // CONF_TM26_PSNT           

    // ----------------------------------------------
    #define CONF_TM26_CCMDS CONF_TM26_CCMDS_CC0_MDS |\
                            CONF_TM26_CCMDS_CC1_MDS
                            
    // ----------------------------------------------
    #define CONF_TM26_ICCR  CONF_TM26_ICCR_IC0_MUX  |\
                            CONF_TM26_ICCR_IC0_TRGS |\
                            CONF_TM26_ICCR_IC1_MUX  |\
                            CONF_TM26_ICCR_IC1_TRGS
                            
    // ----------------------------------------------
    // with 'Write access protected control - 0x00003030'
    #define CONF_TM26_OSCR  CONF_TM26_OSCR_CH0      |\
                            CONF_TM26_OSCR_CH0H     |\
                            CONF_TM26_OSCR_CH1      |\
                            CONF_TM26_OSCR_CH1H     |\
                            0x00003030
                            
    // ----------------------------------------------
    #define CONF_TM26_OCCR0 CONF_TM26_OCCR0_OC0_OE0 |\
                            CONF_TM26_OCCR0_OC0_OE1 |\
                            CONF_TM26_OCCR0_OC0_OE2 |\
                            CONF_TM26_OCCR0_OC0N_OE |\
                            CONF_TM26_OCCR0_OC1_OE0 |\
                            CONF_TM26_OCCR0_OC1_OE1 |\
                            CONF_TM26_OCCR0_OC1_OE2 |\
                            CONF_TM26_OCCR0_OC1N_OE
                            
    // ----------------------------------------------
    #define CONF_TM26_OCCR1 CONF_TM26_OCCR1_OC0_INV |\
                            CONF_TM26_OCCR1_OC0N_INV|\
                            CONF_TM26_OCCR1_OC0H_INV|\
                            CONF_TM26_OCCR1_OC1_INV |\
                            CONF_TM26_OCCR1_OC1N_INV|\
                            CONF_TM26_OCCR1_OC1H_INV|\
                            CONF_TM26_OCCR1_OC0_POE0|\
                            CONF_TM26_OCCR1_OC0_POE1|\
                            CONF_TM26_OCCR1_OC0_POE2|\
                            CONF_TM26_OCCR1_OC1_POE0|\
                            CONF_TM26_OCCR1_OC1_POE1|\
                            CONF_TM26_OCCR1_OC1_POE2|\
                            CONF_TM26_OCCR1_POE_EN0 |\
                            CONF_TM26_OCCR1_POE_EN1 |\
                            CONF_TM26_OCCR1_POE_EN2
                            
    // ----------------------------------------------
    #define CONF_TM26_BS    CONF_TM26_BS_STP0_STA   |\
                            CONF_TM26_BS_STP0N_STA  |\
                            CONF_TM26_BS_STP1_STA   |\
                            CONF_TM26_BS_STP1N_STA
                            
    // ----------------------------------------------
    // CONF_TM26_CC0A_OC        
    // CONF_TM26_CC0A_PWM       

    // CONF_TM26_CC1A_OC        
    // CONF_TM26_CC1A_PWM       
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM26 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM26_CounterMode_Select            CONF_TM26_CR0_MDS 
    #define mTM26_Period_Select                 CONF_TM26_CNT 
    #define mTM26_Prescaler_Select              CONF_TM26_PSNT 
    
    
#endif

// --------------------------------------------------------------------
// TM36 Module
// --------------------------------------------------------------------
#if defined(CONF_TM36_MODE)               

    // ----------------------------------------------
    // Repetition timer underflow interrupt
    #if defined(CONF_TM36_INT_RTU_IE)
    #define PRE_TM36_INT_0  CONF_TM36_INT_RTU_IE   
    #else
    #define PRE_TM36_INT_0  0         
    #endif
    // Input duty capture complete interrupt 
    #if defined(CONF_TM36_INT_IDC_IE)
    #define PRE_TM36_INT_1  CONF_TM36_INT_IDC_IE
    #else
    #define PRE_TM36_INT_1  0
    #endif

    #define CONF_TM36_INT   CONF_TM36_INT_IEA       |\
                            CONF_TM36_INT_BK_IE     |\
                            CONF_TM36_INT_EXIE      |\
                            CONF_TM36_INT_TIE       |\
                            CONF_TM36_INT_TIE2      |\
                            CONF_TM36_INT_CC0_IE    |\
                            CONF_TM36_INT_CC1_IE    |\
                            CONF_TM36_INT_CC2_IE    |\
                            CONF_TM36_INT_CC3_IE    |\
                            CONF_TM36_INT_DIRC_IE   |\
                            CONF_TM36_INT_IDX_IE    |\
                            PRE_TM36_INT_0          |\
                            PRE_TM36_INT_1          |\
                            CONF_TM36_INT_QPE_IE    

    // ----------------------------------------------
    // Repetition Timer/Counter clock source                        
    #if defined(CONF_TM36_CLK_RC_CKS)
    #define CONF_TM36_CLK   CONF_TM36_CLK_CKS_SEL   |\
                            CONF_TM36_CLK_CKI_SEL   |\
                            CONF_TM36_CLK_CKI_DIV   |\
                            CONF_TM36_CLK_CKE_SEL   |\
                            CONF_TM36_CLK_RC_CKS    |\
                            CONF_TM36_CLK_DTG_DIV
    #else                       
    #define CONF_TM36_CLK   CONF_TM36_CLK_CKS_SEL   |\
                            CONF_TM36_CLK_CKI_SEL   |\
                            CONF_TM36_CLK_CKI_DIV   |\
                            CONF_TM36_CLK_CKE_SEL   |\
                            CONF_TM36_CLK_DTG_DIV
    #endif

    // ----------------------------------------------
    #define CONF_TM36_TRG   CONF_TM36_TRG_ITR_MUX   |\
                            CONF_TM36_TRG_TRG_MUX   |\
                            CONF_TM36_TRG_TRGI_MDS  |\
                            CONF_TM36_TRG_TRGI2_MDS |\
                            CONF_TM36_TRG_TRGO_MDS  |\
                            CONF_TM36_TRG_UEV_SEL   |\
                            CONF_TM36_TRG_TRGO_INV  |\
                            CONF_TM36_TRG_QEI_MDS   |\
                            CONF_TM36_TRG_IDX_EN    |\
                            CONF_TM36_TRG_IDX_MDS
    
    // Check internal clock divider when QEI is activated
    #if (CONF_TM36_TRG_QEI_MDS > 0)
        #if (CONF_TM36_CLK_CKI_DIV > 0)
            #error "(TM36) The QEI function is used, but the timer cannot accept the internal clock divider (>DIV1)."
        #endif
    #endif

    // ----------------------------------------------
    // Repetition Counter control                        
    #if defined(CONF_TM36_CR0_RC_EN)
    #define PRE_TM36_CR0_0  CONF_TM36_CR0_RC_EN     |\
                            CONF_TM36_CR0_RC_STP
    #else
    #define PRE_TM36_CR0_0  0
    #endif
    // Timer auto stop mode
    #if defined(CONF_TM36_CR0_ASTOP_EN)
    #define PRE_TM36_CR0_1  CONF_TM36_CR0_ASTOP_EN
    #else
    #define PRE_TM36_CR0_1  0
    #endif
    // Input duty capture 
    #if defined(CONF_TM36_CR0_IDC_EN)
    #define PRE_TM36_CR0_2  CONF_TM36_CR0_IDC_EN    
    #else
    #define PRE_TM36_CR0_2  0
    #endif

    #define CONF_TM36_CR0   CONF_TM36_CR0_MDS       |\
                            CONF_TM36_CR0_DIR       |\
                            CONF_TM36_CR0_EX_EN     |\
                            CONF_TM36_CR0_UEX_EN    |\
                            PRE_TM36_CR0_0          |\
                            PRE_TM36_CR0_1          |\
                            PRE_TM36_CR0_2          |\
                            CONF_TM36_CR0_UEV_DIS
                            
    // ----------------------------------------------
    #define CONF_TM36_CR1   CONF_TM36_CR1_OVR0_MDS  |\
                            CONF_TM36_CR1_OVR1_MDS  |\
                            CONF_TM36_CR1_OVR2_MDS  |\
                            CONF_TM36_CR1_OVR3_MDS

    // ----------------------------------------------
    #define CONF_TM36_CKO   CONF_TM36_CKO_CKO_STA   |\
                            CONF_TM36_CKO_CKO_EN    |\
                            CONF_TM36_CKO_CKO_SEL
                            
    // ----------------------------------------------
    #define CONF_TM36_RCNT  CONF_TM36_TM20_RCNT_RCNT
                                                     
    // ----------------------------------------------
    // CONF_TM36_CNT                                 
    // CONF_TM36_PSNT                                
                                                     
    // ----------------------------------------------
    #define CONF_TM36_CCMDS CONF_TM36_CCMDS_CC0_MDS |\
                            CONF_TM36_CCMDS_CC1_MDS |\
                            CONF_TM36_CCMDS_CC2_MDS |\
                            CONF_TM36_CCMDS_CC3_MDS
                            
    // ----------------------------------------------
    #define CONF_TM36_ICCR  CONF_TM36_ICCR_IC0_MUX  |\
                            CONF_TM36_ICCR_IC0_TRGS |\
                            CONF_TM36_ICCR_IC1_MUX  |\
                            CONF_TM36_ICCR_IC1_TRGS |\
                            CONF_TM36_ICCR_IC2_MUX  |\
                            CONF_TM36_ICCR_IC2_TRGS |\
                            CONF_TM36_ICCR_IC3_MUX  |\
                            CONF_TM36_ICCR_IC3_TRGS
                            
    // ----------------------------------------------
    // with 'Write access protected control - 0x0000F0F0'
    #define CONF_TM36_OSCR  CONF_TM36_OSCR_CH0      |\
                            CONF_TM36_OSCR_CH0H     |\
                            CONF_TM36_OSCR_CH1      |\
                            CONF_TM36_OSCR_CH1H     |\
                            CONF_TM36_OSCR_CH2      |\
                            CONF_TM36_OSCR_CH2H     |\
                            CONF_TM36_OSCR_CH3      |\
                            CONF_TM36_OSCR_CH3H     |\
                            0x0000F0F0
                            
    // ----------------------------------------------
    #define CONF_TM36_OCCR0 CONF_TM36_OCCR0_OC0_OE0 |\
                            CONF_TM36_OCCR0_OC0_OE1 |\
                            CONF_TM36_OCCR0_OC0_OE2 |\
                            CONF_TM36_OCCR0_OC0N_OE |\
                            CONF_TM36_OCCR0_OC1_OE0 |\
                            CONF_TM36_OCCR0_OC1_OE1 |\
                            CONF_TM36_OCCR0_OC1_OE2 |\
                            CONF_TM36_OCCR0_OC1N_OE |\
                            CONF_TM36_OCCR0_OC2_OE  |\
                            CONF_TM36_OCCR0_OC2N_OE |\
                            CONF_TM36_OCCR0_OC3_OE  |\
                            CONF_TM36_OCCR1_OC0_POE0|\
                            CONF_TM36_OCCR1_OC0_POE1|\
                            CONF_TM36_OCCR1_OC0_POE2|\
                            CONF_TM36_OCCR1_OC1_POE0|\
                            CONF_TM36_OCCR1_OC1_POE1|\
                            CONF_TM36_OCCR1_OC1_POE2|\
                            CONF_TM36_OCCR1_POE_EN0 |\
                            CONF_TM36_OCCR1_POE_EN1 |\
                            CONF_TM36_OCCR1_POE_EN2
                            
    // ----------------------------------------------
    #define CONF_TM36_OCCR1 CONF_TM36_OCCR1_OC0_INV |\
                            CONF_TM36_OCCR1_OC0N_INV|\
                            CONF_TM36_OCCR1_OC0H_INV|\
                            CONF_TM36_OCCR1_OC1_INV |\
                            CONF_TM36_OCCR1_OC1N_INV|\
                            CONF_TM36_OCCR1_OC1H_INV|\
                            CONF_TM36_OCCR1_OC2_INV |\
                            CONF_TM36_OCCR1_OC2N_INV|\
                            CONF_TM36_OCCR1_OC2H_INV|\
                            CONF_TM36_OCCR1_OC3_INV |\
                            CONF_TM36_OCCR1_OC3H_INV
                            
    // ----------------------------------------------
    #define CONF_TM36_PWM   CONF_TM36_PWM_PWM_MDS   |\
                            CONF_TM36_PWM_DTG_DY
                            
    // ----------------------------------------------
    // COMP0 module
    #if defined(CONF_TM36_BS_BKE_EN4)
    #define PRE_TM36_BS_0   CONF_TM36_BS_BKE_EN4
    #else
    #define PRE_TM36_BS_0   0   
    #endif
    // COMP1 module
    #if defined(CONF_TM36_BS_BKE_EN5)
    #define PRE_TM36_BS_1   CONF_TM36_BS_BKE_EN5
    #else
    #define PRE_TM36_BS_1   0   
    #endif
    // COMP2 module
    #if defined(CONF_TM36_BS_BKE_EN6)
    #define PRE_TM36_BS_2   CONF_TM36_BS_BKE_EN6
    #else
    #define PRE_TM36_BS_2   0   
    #endif
    // COMP3 module
    #if defined(CONF_TM36_BS_BKE_EN7)
    #define PRE_TM36_BS_3   CONF_TM36_BS_BKE_EN7
    #else
    #define PRE_TM36_BS_3   0   
    #endif

    #define CONF_TM36_BS    CONF_TM36_BS_BK_MDS     |\
                            CONF_TM36_BS_BK03_CTL   |\
                            CONF_TM36_BS_BK3_EN     |\
                            CONF_TM36_BS_BKE_EN0    |\
                            CONF_TM36_BS_BKE_EN1    |\
                            CONF_TM36_BS_BKE_EN2    |\
                            CONF_TM36_BS_BKE_EN3    |\
                            PRE_TM36_BS_0           |\
                            PRE_TM36_BS_1           |\
                            PRE_TM36_BS_2           |\
                            PRE_TM36_BS_3           |\
                            CONF_TM36_BS_BKI_EN0    |\
                            CONF_TM36_BS_BKI_EN2    |\
                            CONF_TM36_BS_STP0_STA   |\
                            CONF_TM36_BS_STP0N_STA  |\
                            CONF_TM36_BS_STP1_STA   |\
                            CONF_TM36_BS_STP1N_STA  |\
                            CONF_TM36_BS_STP2_STA   |\
                            CONF_TM36_BS_STP2N_STA  |\
                            CONF_TM36_BS_STP3_STA

    // ----------------------------------------------
    // CONF_TM36_CC0A_OC        
    // CONF_TM36_CC0A_PWM       

    // CONF_TM36_CC1A_OC        
    // CONF_TM36_CC1A_PWM       

    // CONF_TM36_CC2A_OC        
    // CONF_TM36_CC2A_PWM     
      
    // CONF_TM36_CC3A_OC        
    // CONF_TM36_CC3A_PWM 
                                                  

    
    // ------------------------------------------------------------------------
    // Assemble mTM36 structure within Middleware level
    // ------------------------------------------------------------------------
    #define mTM36_CounterMode_Select            CONF_TM36_CR0_MDS 
    #define mTM36_Period_Select                 CONF_TM36_CNT 
    #define mTM36_Prescaler_Select              CONF_TM36_PSNT 
    
    
#endif

    
/**
 * @name  Function announce
 *      
 */
///@{ 
void TM_Init(void);

///@}
#endif  // _MG32_TM_INIT_H

