;******************************************************************************
;*                                                                            *
;* @file        MG32_IEC60730_RAM_ASM.s                                   *
;*                                                                            *
;* @brief       Check MCU full RAM area before main routine.                  *
;*                                                                            *
;* @par         Project                                                       *
;*              MG32                                                      *
;* @version     V1.00                                                         *
;* @date        2021/10/05 17:58                                              *
;* @author      Megawin Software Center                                       *
;******************************************************************************
;  @par 		    Disclaimer 
;  		The Demo software is provided "AS IS"  without any warranty, either  
;  		expressed or implied, including, but not limited to, the implied warranties
;  		of merchantability and fitness for a particular purpose.  The author will 
;  		not be liable for any special, incidental, consequential or indirect 
;  		damages due to loss of data or any other reason. 
;  		These statements agree with the world wide and local dictated laws about 
;  		authorship and violence against these laws. 
;*******************************************************************************

  THUMB
  REQUIRE8
  PRESERVE8

  AREA |.text|, CODE, READONLY, ALIGN=2

  ; Reference to the FailSafe routine to be executed in case of non-recoverable
  ; failure
  IMPORT FailSafePOR

    ; C variables for control flow monitoring
    ;Chip MG32F02A132
    IF :DEF:MG32F02A132
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20003FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02A072
    IF :DEF:MG32F02A072
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20001FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MA862
    IF :DEF:MA862
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20001FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02A032
    IF :DEF:MG32F02A032
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20000FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02A128
    IF :DEF:MG32F02A128
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20003FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02U128
    IF :DEF:MG32F02U128
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20003FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02A064
    IF :DEF:MG32F02A064
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20001FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02U064
    IF :DEF:MG32F02U064
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20001FFC  ; RAM end address - 4 byte
    ENDIF
    ;Chip MG32F02V032
    IF :DEF:MG32F02V032
RAM_START_ADDR  EQU     0x20000000  ; RAM start address
RAM_END_ADDR    EQU     0x20000FFC  ; RAM end address - 4 byte
    ENDIF

;*******************************************************************************
; Function Name  : IEC60730_RAM_Full_ASM
; Description    : Cortex-M0 RAM test at start-up
; Input          : None.
; Output         : Branch directly to a Fail Safe routine in case of failure
; Return         : TEST_SUCCESSFULL (=0)
; WARNING        : (R0~R2) registers destroyed when exiting this function.
;*******************************************************************************/

IEC60730_RAM_Full_ASM PROC
    EXPORT IEC60730_RAM_Full_ASM

    ; R0 = RAM_START address
    ; R1 = RAM_END address
    ; R2 = Write / Compare register
    
    ; ---------------------------- STEP 1 ----------------------------------- 
    ; Write background with addresses increasing 
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    LDR R2,=0x00000000
REPEAT_CLEAR_RAM
    STR R2,[R0]
    ADDS R0,#4    
    CMP R0,R1
    BLS REPEAT_CLEAR_RAM      ; R0 <= R1

    ; ---------------------------- STEP 2 ----------------------------------- 
    ; Verify background and write inverted background with addresses increasing 
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP2_CHECK_RAM
    LDRB R2,[R0]
    CMP R2,#0
    BEQ STEP2_EQUAL           
    BLAL FailSafePOR          ; if not equal then go to FailSafePOR
STEP2_EQUAL
    MVNS R2, R2               ; Rerverse R2 reg
    STRB R2,[R0]              ; Write 0xFF to RAM
    ADDS R0, #1
    CMP R0,R1
    BNE REPEAT_STEP2_CHECK_RAM  ; R0 != R1

    ; ---------------------------- STEP 3 ----------------------------------- */
    ; Verify inverted background and write background with addresses increasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP3_CHECK_RAM
    LDRB R2,[R0]
    CMP R2,#0x000000FF
    BEQ STEP3_EQUAL           
    BLAL FailSafePOR          ; if not equal then go to FailSafePOR
STEP3_EQUAL
    MVNS R2, R2               ; Rerverse R2 reg to (0x00)
    STRB R2,[R0]              ; Write 0xFF to RAM
    ADDS R0, #1
    CMP R0,R1
    BNE REPEAT_STEP3_CHECK_RAM  ; R0 != R1
    

    ; ---------------------------- STEP 4 ----------------------------------- */
    ; Verify background and write inverted background with addresses decreasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#3                ; 0x?????FFF
REPEAT_STEP4_CHECK_RAM
    LDRB R2,[R1]
    CMP R2,#0
    BEQ STEP4_EQUAL           
    BLAL FailSafePOR          ; if not equal then go to FailSafePOR
STEP4_EQUAL
    MVNS R2, R2               ; Rerverse R2 reg
    STRB R2,[R1]              ; Write 0xFF to RAM
    SUBS R1, #1
    CMP R0,R1
    BLS REPEAT_STEP4_CHECK_RAM  ; R0 <= R1

    ; ---------------------------- STEP 5 ----------------------------------- */
    ; Verify inverted background and write background with addresses decreasing */
    LDR R0,=RAM_START_ADDR        
    LDR R1,=RAM_END_ADDR
    ADDS R1,#3                ; 0x?????FFF
REPEAT_STEP5_CHECK_RAM
    LDRB R2,[R1]
    CMP R2,#0x000000FF
    BEQ STEP5_EQUAL           
    BLAL FailSafePOR          ; if not equal then go to FailSafePOR
STEP5_EQUAL
    MVNS R2, R2               ; Rerverse R2 reg to (0x00)
    STRB R2,[R1]              ; Write 0xFF to RAM
    SUBS R1, #1
    CMP R0,R1
    BLS REPEAT_STEP5_CHECK_RAM  ; R0 <= R1

    ; ---------------------------- STEP 6 ----------------------------------- */
    ; Verify background with addresses increasing */
    LDR R0,=RAM_START_ADDR         
    LDR R1,=RAM_END_ADDR
    ADDS R1,#4
REPEAT_STEP6_CHECK_RAM
    LDR R2,[R0]
    CMP R2,#0
    BEQ STEP6_EQUAL           
    BLAL FailSafePOR          ; if not equal then go to FailSafePOR
STEP6_EQUAL
    ADDS R0, #4
    CMP R0,R1
    BNE REPEAT_STEP6_CHECK_RAM  ; R0 != R1
    
    ; ---------------------------- STEP 7 ----------------------------------- */
    ; If next instruction is not executed, R0 will hold a value different from 0
    MOVS R0, #0x0             ; RAM TEST SUCCESS
    BX LR                     ; return to the caller

    ALIGN

    ENDP

    END
/******************* (C) COPYRIGHT 2018 Megawin ************ END OF FILE *****/


