/**
 ******************************************************************************
 *
 * @file        MG32_DMA.h
 *
 * @brief       MG32 DMA Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V1.53 (Register File Date : 2023_1025)
 * @date        2023/10/25 14:29 (H File Generated Date)
 * @author      HeadCodeGen V1.46
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_DMA_H
#define _MG32_DMA_H
#define _MG32_DMA_H_VER                         153     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_DMA_H_VER)
    #error "_MG32_DMA_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      DMA_Struct
 *              DMA  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  CH0_GIF       :1;     //[0] DMA channel-0 global interrupt flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_TCF       :1;     //[1] DMA channel-0 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_THF       :1;     //[2] DMA channel-0 transfer half flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_ERRF      :1;     //[3] DMA channel-0 transfer error flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :1;     //[5] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :1;     //[11] 
            __I  uint8_t                :4;     //[15..12] 
            __I  uint16_t               :15;    //[30..16] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  DMA status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] DMA interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :7;     //[7..1] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :15;    //[30..16] 
            __I  uint8_t                :1;     //[31] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  DMA interrupt enable register */

    __I uint32_t  RESERVED0[2];         /*!< RESERVED0  ~ Offset[0x08]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] DMA controller enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[1] 
            __IO uint8_t  FGBUS_SEL     :1;     //[2] DMA flash-to-GPL transfer bus width select
                                        //0 = 1BYTE (8-bit)
                                        //1 = 4BYTE (32-bit)
            __I  uint8_t                :1;     //[3] 
            __IO uint8_t  GPL_CHS       :2;     //[5..4] DMA channel select for extra GPL function
                                        //0x0 = Disable : no any channel with GPL function
                                        //0x1 = CH0
                                        //0x2 = Reserved : reserved for CH1
                                        //0x3 = Reserved : reserved for CH2
            __I  uint8_t                :2;     //[7..6] 
            __I  uint8_t                :8;     //[15..8] 
            __IO uint8_t  CH0_ENB       :1;     //[16] DMA channel-0 operation enable bit. This bit is as same as DMA_CH0_EN.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[17] 
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :5;     //[23..19] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  DMA global control register 0 */

    __I uint32_t  RESERVED1;            /*!< RESERVED1  ~ Offset[0x14]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  MAIN_STA      :3;     //[2..0] 
            __I  uint8_t                :1;     //[3] 
            __I  uint8_t  CH_STA        :3;     //[6..4] 
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t  SEL_CH0       :1;     //[8] 
            __I  uint8_t                :1;     //[9] 
            __I  uint8_t                :1;     //[10] 
            __I  uint8_t                :5;     //[15..11] 
            __I  uint8_t  XMDS_CH0      :3;     //[18..16] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :3;     //[22..20] 
            __I  uint8_t                :1;     //[23] 
            __I  uint8_t                :3;     //[26..24] 
            __I  uint8_t                :1;     //[27] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  DMA global control register 2 */

    __I uint32_t  RESERVED2;            /*!< RESERVED2  ~ Offset[0x1C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH0_EN        :1;     //[0] DMA channel operation enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_HOLD      :1;     //[1] DMA channel operation hold enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_LOOP      :1;     //[2] DMA loop mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_ADSEL     :1;     //[3] DMA address increased mode select
                                        //0 = Normal : sequential increment 1
                                        //1 = SKIP3 : address increment from 0 to 1,2 then return 0
            __I  uint8_t                :2;     //[5..4] 
            __IO uint8_t  CH0_LAST      :1;     //[6] DMA Channel-0 last loop command
                                        //0 = Not
                                        //1 = Yes
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  CH0_XMDS      :2;     //[9..8] DMA channel external pin trigger request mode select
                                        //0x0 = Disable : disable external request pin input
                                        //0x1 = Single : single request mode
                                        //0x2 = Block : block request mode
                                        //0x3 = Demand : demand request mode(active high)
            __I  uint8_t                :2;     //[11..10] 
            __IO uint8_t  CH0_BSIZE     :2;     //[13..12] DMA transfer burst size
                                        //0x0 = One
                                        //0x1 = Two
                                        //0x2 = Reserved
                                        //0x3 = Four
            __I  uint8_t                :1;     //[14] 
            __IO uint8_t  CH0_REQ       :1;     //[15] DMA channel data transfer request enable
                                        //0 = No : no effect
                                        //1 = Enable
            __I  uint8_t                :1;     //[16] 
            __IO uint8_t  CH0_CIE       :1;     //[17] DMA channel-0 transfer complete interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_HIE       :1;     //[18] DMA channel-0 transfer half interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_EIE       :1;     //[19] DMA channel-0 transfer error interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[23..20] 
            __I  uint8_t                :1;     //[24] 
            __IO uint8_t  CH0_TC2F      :1;     //[25] DMA channel-0 transfer complete flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_TH2F      :1;     //[26] DMA channel-0 transfer half flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  CH0_ERR2F     :1;     //[27] DMA channel-0 transfer error flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CH0A;                              /*!< CH0A       ~ Offset[0x20]  DMA channel-0 control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CH0_SRC       :4;     //[3..0] DMA channel transfer peripheral source select
            __I  uint8_t                :4;     //[7..4] 
            __IO uint8_t  CH0_DET       :4;     //[11..8] DMA channel transfer peripheral destination select
            __I  uint8_t                :4;     //[15..12] 
            __IO uint8_t  CH0_SINC      :1;     //[16] DMA source memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_DINC      :1;     //[17] DMA destination memory transfer address auto increased enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_SSYNC     :1;     //[18] DMA source process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CH0_DSYNC     :1;     //[19] DMA destination process synchronization enable bit
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :2;     //[21..20] 
            __I  uint8_t                :2;     //[23..22] 
            __I  uint8_t                :1;     //[24] 
            __I  uint8_t                :7;     //[31..25] 
        }MBIT;
    }CH0B;                              /*!< CH0B       ~ Offset[0x24]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint16_t CH0_NUM       :16;    //[15..0] DMA transfer data count initial number
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH0NUM;                            /*!< CH0NUM     ~ Offset[0x28]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint16_t CH0_CNT       :16;    //[15..0] DMA transfer data count current value
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CH0CNT;                            /*!< CH0CNT     ~ Offset[0x2C]  DMA channel-0 control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH0_SSA       :32;    //[31..0] DMA source memory transfer start address.
        }MBIT;
    }CH0SSA;                            /*!< CH0SSA     ~ Offset[0x30]  DMA channel-0 source start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH0_SCA       :32;    //[31..0] DMA source memory transfer current address
        }MBIT;
    }CH0SCA;                            /*!< CH0SCA     ~ Offset[0x34]  DMA channel-0 source current address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint32_t CH0_DSA       :32;    //[31..0] DMA destination memory transfer start address.
        }MBIT;
    }CH0DSA;                            /*!< CH0DSA     ~ Offset[0x38]  DMA channel-0 destination start address register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint32_t CH0_DCA       :32;    //[31..0] DMA destination memory transfer current address
        }MBIT;
    }CH0DCA;                            /*!< CH0DCA     ~ Offset[0x3C]  DMA channel-0 destination current address register */

} DMA_Struct;

/**
 ******************************************************************************
 *
 * @name        DMA  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define DMA_Base                        ((uint32_t)0x4BF00000)              /*!< Direct Memory Access Control */
#define DMA                             ((DMA_Struct*) DMA_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        DMA  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        DMA_STA  [register's definitions]
 *              Offset[0x00]  DMA status register (0x4BF00000)
 ******************************************************************************
 */
///@{
#define DMA_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_STA */
#define DMA_STA_CH0_ERRF_mask_w                     ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_ERRF_mask_h0                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_ERRF_mask_b0                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_ERRF_normal_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_ERRF_normal_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_ERRF_normal_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_ERRF_happened_w                 ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_ERRF_happened_h0                ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_ERRF_happened_b0                ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_THF_mask_w                      ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_THF_mask_h0                     ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_THF_mask_b0                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_THF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_THF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_THF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_THF_happened_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_THF_happened_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_THF_happened_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_TCF_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_TCF_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_TCF_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_TCF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_TCF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_TCF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_TCF_happened_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_TCF_happened_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_TCF_happened_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_STA_CH0_GIF_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_STA_CH0_GIF_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_STA_CH0_GIF_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_STA_CH0_GIF_normal_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_STA_CH0_GIF_normal_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_STA_CH0_GIF_normal_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_STA_CH0_GIF_happened_w                  ((uint32_t)0x00000001)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_STA_CH0_GIF_happened_h0                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_STA_CH0_GIF_happened_b0                 ((uint8_t )0x01)        /*!< Bit Value =(1):Happened of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_INT  [register's definitions]
 *              Offset[0x04]  DMA interrupt enable register (0x4BF00004)
 ******************************************************************************
 */
///@{
#define DMA_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_INT */
#define DMA_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CR0  [register's definitions]
 *              Offset[0x10]  DMA global control register 0 (0x4BF00010)
 ******************************************************************************
 */
///@{
#define DMA_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CR0 */
#define DMA_CR0_CH0_ENB_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CR0_CH0_ENB_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CR0_CH0_ENB_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR0_CH0_ENB_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_CH0_ENB_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_CH0_ENB_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_CH0_ENB_enable_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_CH0_ENB_enable_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_CH0_ENB_enable_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CR0_GPL_CHS_mask_w                      ((uint32_t)0x00000030)  /*!< Bit Mask of 32bit */
#define DMA_CR0_GPL_CHS_mask_h0                     ((uint16_t)0x0030)      /*!< Bit Mask of 16bit */
#define DMA_CR0_GPL_CHS_mask_b0                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CR0_GPL_CHS_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CR0_GPL_CHS_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CR0_GPL_CHS_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CR0_GPL_CHS_ch0_w                       ((uint32_t)0x00000010)  /*!< Bit Value =(0x1):CH0 of 32bit */
#define DMA_CR0_GPL_CHS_ch0_h0                      ((uint16_t)0x0010)      /*!< Bit Value =(0x1):CH0 of 16bit */
#define DMA_CR0_GPL_CHS_ch0_b0                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):CH0 of 8bit */

#define DMA_CR0_FGBUS_SEL_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CR0_FGBUS_SEL_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CR0_FGBUS_SEL_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CR0_FGBUS_SEL_1byte_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):1BYTE of 32bit */
#define DMA_CR0_FGBUS_SEL_1byte_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):1BYTE of 16bit */
#define DMA_CR0_FGBUS_SEL_1byte_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):1BYTE of 8bit */
#define DMA_CR0_FGBUS_SEL_4byte_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):4BYTE of 32bit */
#define DMA_CR0_FGBUS_SEL_4byte_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):4BYTE of 16bit */
#define DMA_CR0_FGBUS_SEL_4byte_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):4BYTE of 8bit */

#define DMA_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CR2  [register's definitions]
 *              Offset[0x18]  DMA global control register 2 (0x4BF00018)
 ******************************************************************************
 */
///@{
#define DMA_CR2_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CR2 */
#define DMA_CR2_XMDS_CH0_mask_w                     ((uint32_t)0x00070000)  /*!< Bit Mask of 32bit */
#define DMA_CR2_XMDS_CH0_mask_h1                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define DMA_CR2_XMDS_CH0_mask_b2                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DMA_CR2_XMDS_CH0_shift_w                    (16)                    /*!< Bit Shift of 32bit */
#define DMA_CR2_XMDS_CH0_shift_h1                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_XMDS_CH0_shift_b2                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_SEL_CH0_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define DMA_CR2_SEL_CH0_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define DMA_CR2_SEL_CH0_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CR2_SEL_CH0_shift_w                     (8)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_SEL_CH0_shift_h0                    (8)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_SEL_CH0_shift_b1                    (0)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_CH_STA_mask_w                       ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define DMA_CR2_CH_STA_mask_h0                      ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define DMA_CR2_CH_STA_mask_b0                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define DMA_CR2_CH_STA_shift_w                      (4)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_CH_STA_shift_h0                     (4)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_CH_STA_shift_b0                     (4)                     /*!< Bit Shift of 8bit */

#define DMA_CR2_MAIN_STA_mask_w                     ((uint32_t)0x00000007)  /*!< Bit Mask of 32bit */
#define DMA_CR2_MAIN_STA_mask_h0                    ((uint16_t)0x0007)      /*!< Bit Mask of 16bit */
#define DMA_CR2_MAIN_STA_mask_b0                    ((uint8_t )0x07)        /*!< Bit Mask of 8bit */
#define DMA_CR2_MAIN_STA_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CR2_MAIN_STA_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CR2_MAIN_STA_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0A  [register's definitions]
 *              Offset[0x20]  DMA channel-0 control register 0 (0x4BF00020)
 ******************************************************************************
 */
///@{
#define DMA_CH0A_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0A */
#define DMA_CH0A_CH0_ERR2F_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_ERR2F_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_ERR2F_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_ERR2F_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_ERR2F_normal_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_ERR2F_normal_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_ERR2F_happened_w               ((uint32_t)0x08000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_ERR2F_happened_h1              ((uint16_t)0x0800)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_ERR2F_happened_b3              ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_TH2F_mask_w                    ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_TH2F_mask_h1                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_TH2F_mask_b3                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_TH2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_TH2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_TH2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_TH2F_happened_w                ((uint32_t)0x04000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_TH2F_happened_h1               ((uint16_t)0x0400)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_TH2F_happened_b3               ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_TC2F_mask_w                    ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_TC2F_mask_h1                   ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_TC2F_mask_b3                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_TC2F_normal_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_TC2F_normal_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_TC2F_normal_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_TC2F_happened_w                ((uint32_t)0x02000000)  /*!< Bit Value =(1):Happened of 32bit */
#define DMA_CH0A_CH0_TC2F_happened_h1               ((uint16_t)0x0200)      /*!< Bit Value =(1):Happened of 16bit */
#define DMA_CH0A_CH0_TC2F_happened_b3               ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define DMA_CH0A_CH0_EIE_mask_w                     ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_EIE_mask_h1                    ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_EIE_mask_b2                    ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_EIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_EIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_EIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_EIE_enable_w                   ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_EIE_enable_h1                  ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_EIE_enable_b2                  ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_HIE_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_HIE_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_HIE_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_HIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_HIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_HIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_HIE_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_HIE_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_HIE_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_CIE_mask_w                     ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_CIE_mask_h1                    ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_CIE_mask_b2                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_CIE_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_CIE_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_CIE_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_CIE_enable_w                   ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_CIE_enable_h1                  ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_CIE_enable_b2                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_REQ_mask_w                     ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_REQ_mask_h0                    ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_REQ_mask_b1                    ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_REQ_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):No of 32bit */
#define DMA_CH0A_CH0_REQ_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):No of 16bit */
#define DMA_CH0A_CH0_REQ_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0):No of 8bit */
#define DMA_CH0A_CH0_REQ_enable_w                   ((uint32_t)0x00008000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_REQ_enable_h0                  ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_REQ_enable_b1                  ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_BSIZE_mask_w                   ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_BSIZE_mask_h0                  ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_BSIZE_mask_b1                  ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_BSIZE_one_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):One of 32bit */
#define DMA_CH0A_CH0_BSIZE_one_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0x0):One of 16bit */
#define DMA_CH0A_CH0_BSIZE_one_b1                   ((uint8_t )0x00)        /*!< Bit Value =(0x0):One of 8bit */
#define DMA_CH0A_CH0_BSIZE_two_w                    ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):Two of 32bit */
#define DMA_CH0A_CH0_BSIZE_two_h0                   ((uint16_t)0x1000)      /*!< Bit Value =(0x1):Two of 16bit */
#define DMA_CH0A_CH0_BSIZE_two_b1                   ((uint8_t )0x10)        /*!< Bit Value =(0x1):Two of 8bit */
#define DMA_CH0A_CH0_BSIZE_four_w                   ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):Four of 32bit */
#define DMA_CH0A_CH0_BSIZE_four_h0                  ((uint16_t)0x3000)      /*!< Bit Value =(0x3):Four of 16bit */
#define DMA_CH0A_CH0_BSIZE_four_b1                  ((uint8_t )0x30)        /*!< Bit Value =(0x3):Four of 8bit */

#define DMA_CH0A_CH0_XMDS_mask_w                    ((uint32_t)0x00000300)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_XMDS_mask_h0                   ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_XMDS_mask_b1                   ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_XMDS_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):Disable of 32bit */
#define DMA_CH0A_CH0_XMDS_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0x0):Disable of 16bit */
#define DMA_CH0A_CH0_XMDS_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0x0):Disable of 8bit */
#define DMA_CH0A_CH0_XMDS_single_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):Single of 32bit */
#define DMA_CH0A_CH0_XMDS_single_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):Single of 16bit */
#define DMA_CH0A_CH0_XMDS_single_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):Single of 8bit */
#define DMA_CH0A_CH0_XMDS_block_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(0x2):Block of 32bit */
#define DMA_CH0A_CH0_XMDS_block_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(0x2):Block of 16bit */
#define DMA_CH0A_CH0_XMDS_block_b1                  ((uint8_t )0x02)        /*!< Bit Value =(0x2):Block of 8bit */
#define DMA_CH0A_CH0_XMDS_demand_w                  ((uint32_t)0x00000300)  /*!< Bit Value =(0x3):Demand of 32bit */
#define DMA_CH0A_CH0_XMDS_demand_h0                 ((uint16_t)0x0300)      /*!< Bit Value =(0x3):Demand of 16bit */
#define DMA_CH0A_CH0_XMDS_demand_b1                 ((uint8_t )0x03)        /*!< Bit Value =(0x3):Demand of 8bit */

#define DMA_CH0A_CH0_LAST_mask_w                    ((uint32_t)0x00000040)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_LAST_mask_h0                   ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_LAST_mask_b0                   ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_LAST_not_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Not of 32bit */
#define DMA_CH0A_CH0_LAST_not_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Not of 16bit */
#define DMA_CH0A_CH0_LAST_not_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Not of 8bit */
#define DMA_CH0A_CH0_LAST_yes_w                     ((uint32_t)0x00000040)  /*!< Bit Value =(1):Yes of 32bit */
#define DMA_CH0A_CH0_LAST_yes_h0                    ((uint16_t)0x0040)      /*!< Bit Value =(1):Yes of 16bit */
#define DMA_CH0A_CH0_LAST_yes_b0                    ((uint8_t )0x40)        /*!< Bit Value =(1):Yes of 8bit */

#define DMA_CH0A_CH0_ADSEL_mask_w                   ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_ADSEL_mask_h0                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_ADSEL_mask_b0                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_ADSEL_normal_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define DMA_CH0A_CH0_ADSEL_normal_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define DMA_CH0A_CH0_ADSEL_normal_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define DMA_CH0A_CH0_ADSEL_skip3_w                  ((uint32_t)0x00000008)  /*!< Bit Value =(1):SKIP3 of 32bit */
#define DMA_CH0A_CH0_ADSEL_skip3_h0                 ((uint16_t)0x0008)      /*!< Bit Value =(1):SKIP3 of 16bit */
#define DMA_CH0A_CH0_ADSEL_skip3_b0                 ((uint8_t )0x08)        /*!< Bit Value =(1):SKIP3 of 8bit */

#define DMA_CH0A_CH0_LOOP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_LOOP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_LOOP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_LOOP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_LOOP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_LOOP_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_LOOP_enable_w                  ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_LOOP_enable_h0                 ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_LOOP_enable_b0                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_HOLD_mask_w                    ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_HOLD_mask_h0                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_HOLD_mask_b0                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_HOLD_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_HOLD_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_HOLD_disable_b0                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_HOLD_enable_w                  ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_HOLD_enable_h0                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_HOLD_enable_b0                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0A_CH0_EN_mask_w                      ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define DMA_CH0A_CH0_EN_mask_h0                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH0A_CH0_EN_mask_b0                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH0A_CH0_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0A_CH0_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0A_CH0_EN_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0A_CH0_EN_enable_w                    ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0A_CH0_EN_enable_h0                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0A_CH0_EN_enable_b0                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0B  [register's definitions]
 *              Offset[0x24]  DMA channel-0 control register 1 (0x4BF00024)
 ******************************************************************************
 */
///@{
#define DMA_CH0B_default                            ((uint32_t)0x00030000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0B */
#define DMA_CH0B_CH0_DSYNC_mask_w                   ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DSYNC_mask_h1                  ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DSYNC_mask_b2                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_DSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_DSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_DSYNC_enable_w                 ((uint32_t)0x00080000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_DSYNC_enable_h1                ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_DSYNC_enable_b2                ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_SSYNC_mask_w                   ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SSYNC_mask_h1                  ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SSYNC_mask_b2                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SSYNC_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_SSYNC_disable_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_SSYNC_disable_b2               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_SSYNC_enable_w                 ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_SSYNC_enable_h1                ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_SSYNC_enable_b2                ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_DINC_mask_w                    ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DINC_mask_h1                   ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DINC_mask_b2                   ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_DINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_DINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_DINC_enable_w                  ((uint32_t)0x00020000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_DINC_enable_h1                 ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_DINC_enable_b2                 ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_SINC_mask_w                    ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SINC_mask_h1                   ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SINC_mask_b2                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SINC_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define DMA_CH0B_CH0_SINC_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define DMA_CH0B_CH0_SINC_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define DMA_CH0B_CH0_SINC_enable_w                  ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define DMA_CH0B_CH0_SINC_enable_h1                 ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define DMA_CH0B_CH0_SINC_enable_b2                 ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define DMA_CH0B_CH0_DET_mask_w                     ((uint32_t)0x00000F00)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_DET_mask_h0                    ((uint16_t)0x0F00)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_DET_mask_b1                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_DET_shift_w                    (8)                     /*!< Bit Shift of 32bit */
#define DMA_CH0B_CH0_DET_shift_h0                   (8)                     /*!< Bit Shift of 16bit */
#define DMA_CH0B_CH0_DET_shift_b1                   (0)                     /*!< Bit Shift of 8bit */

#define DMA_CH0B_CH0_SRC_mask_w                     ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define DMA_CH0B_CH0_SRC_mask_h0                    ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define DMA_CH0B_CH0_SRC_mask_b0                    ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define DMA_CH0B_CH0_SRC_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0B_CH0_SRC_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0B_CH0_SRC_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0NUM  [register's definitions]
 *              Offset[0x28]  DMA channel-0 control register 1 (0x4BF00028)
 ******************************************************************************
 */
///@{
#define DMA_CH0NUM_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0NUM */
#define DMA_CH0NUM_CH0_NUM_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0NUM_CH0_NUM_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH0NUM_CH0_NUM_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0NUM_CH0_NUM_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0NUM_CH0_NUM_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0CNT  [register's definitions]
 *              Offset[0x2C]  DMA channel-0 control register 1 (0x4BF0002C)
 ******************************************************************************
 */
///@{
#define DMA_CH0CNT_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0CNT */
#define DMA_CH0CNT_CH0_CNT_mask_w                   ((uint32_t)0x0000FFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0CNT_CH0_CNT_mask_h0                  ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define DMA_CH0CNT_CH0_CNT_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0CNT_CH0_CNT_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0CNT_CH0_CNT_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SSA  [register's definitions]
 *              Offset[0x30]  DMA channel-0 source start address register (0x4BF00030)
 ******************************************************************************
 */
///@{
#define DMA_CH0SSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0SSA */
#define DMA_CH0SSA_CH0_SSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0SSA_CH0_SSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0SSA_CH0_SSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0SSA_CH0_SSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0SCA  [register's definitions]
 *              Offset[0x34]  DMA channel-0 source current address register (0x4BF00034)
 ******************************************************************************
 */
///@{
#define DMA_CH0SCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0SCA */
#define DMA_CH0SCA_CH0_SCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0SCA_CH0_SCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0SCA_CH0_SCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0SCA_CH0_SCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DSA  [register's definitions]
 *              Offset[0x38]  DMA channel-0 destination start address register (0x4BF00038)
 ******************************************************************************
 */
///@{
#define DMA_CH0DSA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0DSA */
#define DMA_CH0DSA_CH0_DSA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0DSA_CH0_DSA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0DSA_CH0_DSA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0DSA_CH0_DSA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        DMA_CH0DCA  [register's definitions]
 *              Offset[0x3C]  DMA channel-0 destination current address register (0x4BF0003C)
 ******************************************************************************
 */
///@{
#define DMA_CH0DCA_default                          ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of DMA_CH0DCA */
#define DMA_CH0DCA_CH0_DCA_mask_w                   ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define DMA_CH0DCA_CH0_DCA_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define DMA_CH0DCA_CH0_DCA_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define DMA_CH0DCA_CH0_DCA_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_DMA_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32_DMA.h                         */
/*----------------------------------------------------------------------------*/
