///////////////////////////////////////////////////
//
//	FILE:       MPC89_WatchDog.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.9.30
//	PURPOSE:    Demo Watch Dog mode
//  Description:
//              When power on will turn on LED1(P12)
//              When watch dog count overflow(about 6 seconds) will reset and turn on LED2(P13)
//              If always set CLRW = 1, then watch dog always recount,
//              Therefore watch will not reset.
//
///////////////////////////////////////////////////
#include "REG_MPC89L51-515.H"
//#include "REG_MPC82L54.H"
//#include "REG_MPC82G516.H"
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
    if((PCON & 0x10)==0x10)
        P12 = 0;//Power On Reset
    else 
        P13 = 0;//Watch Dog or Reset-Pin Reset
    PCON &= 0xef;//Clear POF
    WDTCR = 0x27;//Enable Watch Dog
	while (1) 
    {
//        WDTCR |= 0x10;//Set CLRW = 1 -> Recount watch dog
    }
}
