///////////////////////////////////////////////////
//
//	FILE:       MPC89_Power_Saving.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.3.5
//	PURPOSE:    Demo Power Saving mode
//  Description:
//      Idle mode: Turn off internal clock,  
//                 except interrupt, timer and serial port.
//        Wake up: Any interrupt.        
//      Power Down mode: Turn off all clock.
//        Wake up: Only External Interrupt.(INT0 ~ INT3)
//
///////////////////////////////////////////////////
#include "REG_MPC89L51-515.H"
//#include "REG_MPC82L54.H"
//#include "REG_MPC82G516.H"
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
    TMOD = 0x01;
    IE = 0x83;          //Enable Timer0 & External 0 Interrupt
//    PCON2   =   0x05;   //Set Idle mode clock divided by 128 
//PCON2 only for 82 series MCU
    TR0 = 1;
    PCON    =   0x01;   //Enter Idle Mode
//    PCON    =   0x02;   //Enter Power Down Mode
	while (1) {}
}
///////////////////////////////////////////////////
//
//	External_0_Interrupt()
//  PURPOSE:
//      Wake up MCU from Idle mode or Power Down mode
//
///////////////////////////////////////////////////
void External_0_Interrupt() interrupt 0
{
    P12 = 0;    //Light LED
}
///////////////////////////////////////////////////
//
//	Timer_0_Interrupt()
//  PURPOSE:
//      When Timer 0 overflow will wake up MCU from Idle mode
//
///////////////////////////////////////////////////
void Timer_0_Interrupt() interrupt 1
{
    P13 = 0;    //Light LED
}
