/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			UART0 ͨ485ͼ(ʹж) P17DE/RE
*
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define IO_485_CTRL		P17

#define Set485Tx()		IO_485_CTRL=1
#define Set485Rx()		IO_485_CTRL=0

#define UART0_RX_BUFF_SIZE   32   		 //ֽ
#define UART0_TX_BUFF_SIZE   32   		 //ֽ
xdata u8 RcvBuf[UART0_RX_BUFF_SIZE];
u8 Uart0RxIn =0;


u8 UartOvTime;
bit bUartOvFlag;
u8 LedTime;

/***********************************************************************************
*:   void INT_UART0(void)
*:UART0 жϷ
		 
*:   
*:     
*************************************************************************************/
void INT_UART0(void) interrupt INT_VECTOR_UART0
{
	_push_(SFRPI);		   //SFRPIĴֵ

	SFR_SetPage(0);		   /*0ҳĴ*/  //S0CON0ҳ
	if(TI0)					//ж
	{
	   TI0 = 0;	   
	}
	if(RI0)					//ж
	{
		RI0 = 0;				//жϱ־
		if(Uart0RxIn<UART0_RX_BUFF_SIZE)
		{
			RcvBuf[Uart0RxIn] = S0BUF;
			Uart0RxIn++;

			UartOvTime=10;
		}
		
	}
	_pop_(SFRPI);		   //ָSFRPIĴֵ
}

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;

	if(LedTime!=0) LedTime--;
	if(UartOvTime!=0)
	{
		UartOvTime--;
		if(UartOvTime==0) bUartOvFlag=TRUE;
	}
}

/***********************************************************************************
*:void Uart0SendByte(u8 tByte)
*:Uart0
*:u8 tByte: ͵
*:     
*************************************************************************************/
void Uart0SendByte(u8 tByte)
{
	bit bES;
	bES=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES;
}

/***********************************************************************************
*:void Uart0SendStr(BYTE* PStr)
*:Uart0ַ
*: u8* PStr:ַʼַ
*:     
*************************************************************************************/
void Uart0SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		Uart0SendByte(*PStr);
		PStr ++;
	}
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);				//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();			// ʹ P24,P25,P26,P27 
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);		//  P30,P31,P33,P34,P35 Ϊ׼˫
	PORT_SetP1PushPull(BIT7);							//  P17485
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();			//	ʹT0ж
	INT_EnUART0();			//	ʹܴж
	
}	

/***********************************************************************************
*:   void InitUart0_S1BRG(void)
*:   Uart0ʼʹS1BRGΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{
	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1
	
	UART0_SetBRGFromS1BRG();			// òԴΪ S1BRG
	UART0_SetS1BRGBaudRateX2();			// 2x
	UART1_SetS1BRGSelSYSCLK();			// S1BRGʱΪSysclk

    // ò
	UART1_SetS1BRGValue(S1BRG_BRGRL_9600_2X_12000000_1T);
	
	UART1_EnS1BRG();					// S1BRGʱ
}

/***********************************************************************************
*:   void InitUart0_T1(void)
*:   Uart0ʼ ʹT1ΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_T1(void)
{
	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART0
	
	UART0_SetBRGFromT1();				// òԴΪ T1
	UART0_SetT1BaudRateX2();			// 2x

	TM_SetT1Mode_2_8BIT_AUTORELOAD();
	TM_SetT1Clock_SYSCLK();
	TM_SetT1Gate_Disable();

    // ò
	TM_SetT1HighByte(T1_BRGRL_9600_2X_12000000_1T);
	TM_SetT1LowByte(T1_BRGRL_9600_2X_12000000_1T);

	TM_EnableT1();
}

/***********************************************************************************
*:   void InitUart0_T2(void)
*:   Uart0ʼ ,ʹT2ΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_T2(void)
{	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1

	TM_SetT2Mode_BRG();					// òԴΪ T2
	TM_SetT2Clock_SYSCLK();				// T2ʱԴΪSYSCLK
	UART0_SetT2BaudRateX1();			// X1

	TM_SetT2RLLowByte(LOBYTE(T2_BRGRL_9600_1X_11059200_1T));
	TM_SetT2RLHighByte(HIBYTE(T2_BRGRL_9600_1X_11059200_1T));
	TM_SetT2LowByte(LOBYTE(T2_BRGRL_9600_1X_11059200_1T));
	TM_SetT2HighByte(HIBYTE(T2_BRGRL_9600_1X_11059200_1T));


	TM_EnableT2();
	
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();	
				
	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitTimer0();
	InitUart0_T1();
	//InitUart0_T2();
	//InitUart0_S1BRG();
	InitInterrupt();
}

void main()
{
	u8 i;
	
	InitSystem();

	Uart0RxIn=0;
	UartOvTime=0;
	bUartOvFlag=FALSE;

	INT_EnAll();			//  ʹȫж
	
	Set485Rx();
	
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;	

	Set485Tx();
	DelayXus(10);
	Uart0SendStr("Start!\n");
	DelayXus(10);
	Set485Rx();

	while(1)
	{
		if(LedTime==0)
		{
			LedTime=100;
			LED_G_0 = !LED_G_0;
		}
		if(bUartOvFlag)
		{
			Set485Tx();
			DelayXus(10);
			for(i=0;i<Uart0RxIn;i++)
			{
				Uart0SendByte(RcvBuf[i]);
			}
			Uart0RxIn=0;
			DelayXus(10);
			Set485Rx();
			bUartOvFlag=0;
		}

	}

}


