/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=24MHz, SysCLK=24MHz
*	
*			RTCʱΪXTAL 32768Hz
*			RTC Clock ԤƵ 16364
*			RTC ֵ (64-1)=63
*			RTCƵΪ 32768/16384/1 = 2Hz
*			ģʽ, RTC
*	ע
*	
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		24000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

/***********************************************************************************
*:   void INT_SF(void)
*:SF(ϵͳ־λ)жϷ
*		 RTC,WDTF,BOD0F,BOD1F
*:   
*:     
*************************************************************************************/
void INT_SF(void) interrupt INT_VECTOR_SF
{
	if((PCON1&WDTF)!=0)
	{
		PCON1=WDTF;
	}
	if((PCON1&BOF0)!=0)
	{
		PCON1=BOF0;
	}
	if((PCON1&BOF1)!=0)
	{
		PCON1=BOF1;
	}
	if((PCON1&RTCF)!=0)
	{
		PCON1=RTCF;
		LED_R=!LED_R;
	}
}

/***********************************************************************************
*:   u8 IAP_ReadPPage(u8 PsfrAddr)
*:ȡPҳ⹦
*:u8 PsfrAddr: Pҳַ   
*:u8: Pҳ     
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}

/***********************************************************************************
*:   void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:дPҳ⹦
*:  
*		 u8 PsfrAddr: Pҳַ
*		 u8 PsfrData: Pҳ
*:  
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitRTC(void)
*:RTC ʼ	
*		RTCʱΪILRCO 32KHz
*		RTC Clock ԤƵ 32
*		RTC ֵ (64-10)=54
*		RTCƵΪ 32K/32/10=100Hz
*:   
*:     
*************************************************************************************/
void InitRTC(void)
{	
	RTC_Disable();
	RTC_SetClock_ECKI_P60_Div_16384();		// ѡRTCʱΪ P60/16384
	RTC_SetReload(64-1);					// RTC ֵ (64-1)=63
	RTC_SetCounter(64-1);

	RTC_ClearRTCF();			// RTCF
	RTC_Enable();				// ʹRTC
	
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnSF_RTC();			// ʹRTCж,ʹϵͳ־ж
	INT_EnSF();				// ʹϵͳ־ж
}	

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);							//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// Enable xtal 32768,IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(GAIN_FOR_32K|ENABLE_XTAL|ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
	
	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();

	InitClock();
	
	InitRTC();			

	InitInterrupt();		// жϳʼ
	
	INT_EnAll();			// ʹȫж

}

void main()
{
	u8 i;
	
	u8 BakCKCON2;			// CKCON2 (ʹPLL CKMƵ)
	
    InitSystem();
	
 	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
 	LED_G_0=1;LED_G_1=1;LED_R=1;

					
    while(1)
    {
    	for(i=0;i<50;i++)
    	{
	    	DelayXms(100);
	    	LED_G_0=!LED_G_0;
    	}
		LED_G_0=1;
    	LED_G_1=0;
		RTC_Disable();
		RTC_SetReload(64-10);					// RTC ֵ ,ʱ0.5s*10=5s
		RTC_SetCounter(64-10);
		RTC_ClearRTCF();						// RTCF
		RTC_Enable();							// ʹRTC
    	LED_R=1;

		// MCK=OSCin
		BakCKCON2=IAP_ReadPPage(CKCON2_P);							// CKCON2 (ʹPLL CKMƵ)
		IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));	// MCK=OSCin (ʹPLL CKMƵ)

    	POW_SetMode_PD();	// ģʽ
    	_nop_();

		DelayXus(100);												// ʱCKMȶ (ʹPLL CKMƵ)
		IAP_WritePPage(CKCON2_P,BakCKCON2);							// ָCKCON2,ѡʹñƵ (ʹPLL CKMƵ)

    	LED_G_1=1;
		RTC_Disable();
		RTC_SetReload(64-1);					// RTC ֵ ,ʱ0.5s*1=0.5s
		RTC_SetCounter(64-1);
		RTC_ClearRTCF();						// RTCF
		RTC_Enable();							// ʹRTC
    	
    }
}






