/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			1ģʽ4 (SPIģʽ)
*			SPICLK <-->TXD1	P13
*			MOSI   <-->RXD1 P12
*			MISO   <-->S1MI P10
*			NSS    <-->     P11		
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define SPI_NSS		P11

// ѡSPICLK ʼƽ
#define SPICLK_LOW	0	// SPICLK  ʼΪ͵ƽ
#define SPICLK_HIGH	1	// SPICLK  ʼΪ͵ƽ
#define SPI_CPOL  SPICLK_LOW	

// ѡݴ˳
#define LSB	0	// λ
#define MSB	1	// λ
#define SPI_DORD	MSB

// ѡSPI Ĵٶ
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);				//  P2 Ϊ©
	PORT_EnP24P25P26P27PullHigh();			// ʹ P24,P25,P26,P27 
	PORT_SetP1PushPull(BIT1|BIT2|BIT3);		// P11,P12,P13Ϊ,P13(SPICLK),P12(MOSI),P11(nSS)
	PORT_SetP1OpenDrain(BIT0);				// P10Ϊ©ģʽ,MISO
	PORT_EnP10P11P12P13PullHigh();			// ʹP10~P13
}
/***********************************************************************************
*:   BYTE Uart1SPITransceiver(BYTE ToSend)
*:   SPIͺ
*:   BYTE ToSend
*:     
*************************************************************************************/
BYTE Uart1SPITransceiver(BYTE ToSend)
{
	u8 x;
#if (SPI_CPOL==SPICLK_LOW)									
	P13 = 0;					// SPICLK  ʼΪ͵ƽ
#else	
	P13 = 1;					// SPICLK  ʼΪߵƽ
#endif
	SFR_SetPage(1);

#if (SPI_DORD==MSB)
	BOREV=ToSend;
	S1BUF=BOREV;
#else
	S1BUF=ToSend;
#endif
	while(TI1==0);
	TI1=0;
#if (SPI_DORD==MSB)
	BOREV=S1BUF;
	x=BOREV;
#else
	x=S1BUF;
#endif
	SFR_SetPage(0);
	return x;
}

/***********************************************************************************
*:   void InitUart1_SPI_Master(void)
*:   Uart1ʼ SPI Master
*:   
*:     
*************************************************************************************/
void InitUart1_SPI_Master(void)
{
#if (SPI_CPOL==SPICLK_LOW)									
	P13 = 0;					// SPICLK  ʼΪ͵ƽ
#else	
	P13 = 1;					// SPICLK  ʼΪߵƽ
#endif
	UART1_SetModeSPIMaster();			// ôSPIģʽ
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART1_SetSPIClock_SYSCLKDiv4(); 	// SPIʱΪϵͳʱӵ4Ƶ
#else
	UART1_SetSPIClock_SYSCLKDiv12();	// SPIʱΪϵͳʱӵ12Ƶ
#endif
	

	
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart1_SPI_Master();
}

void main()
{
	InitSystem();
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;	
		SPI_NSS=0;
		Uart1SPITransceiver(0x05);	
		SPI_NSS=1;
	}

}


