/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=24MHz, SysCLK=24MHz
*	
*			PCAʱ: 96MHz
*			CH0(P22)/CH1(P33),CH2(P24)/CH3(P34),CH4(P26)/CH5(P35),CH6(P20)/CH7(P21)
*			4Ի,ض,ֱΪ10bit
*			PWMƵ: 96MHz/(1024)=93.750KHz
*
*           P10ΪPWMP10=1:  P10=0: 
*	ע
*	
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		24000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

idata WordTypeDef wDuty[4];

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	P2=B10101000;									// PWM͵ƽ
	P3=B11000111;
	PORT_SetP2PushPull(BIT0|BIT1|BIT2|BIT4|BIT6);	// P20(PWM6),P21(PWM7),P22(CEX0),P24(CEX2),P26(CEX4)Ϊ
	PORT_SetP3PushPull(BIT3|BIT4|BIT5);				// P33(CEX1),P34(CEX3),P35(CEX5)Ϊ

	P10=1;
	PORT_SetP1OpenDrainPu(BIT0);					// P10Ϊ©ڿ
}

/***********************************************************************************
*:   void InitPCA_PWM(void)
*:   PCAʼ
*:   
*:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_CKMIX16();				// 96MHz(ע:ʹCKMIX16/96MHz֮ǰ,ʹCKM(ENCKM=1))
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();
	PCA_CH4_SetMode_PWM();
	PCA_CH5_SetMode_PWM();
	PCA_CH6_SetMode_PWM();
	PCA_CH7_SetMode_PWM();

	PCA_CH0_SetPWM_10Bit();
	PCA_CH1_SetPWM_10Bit();
	PCA_CH2_SetPWM_10Bit();
	PCA_CH3_SetPWM_10Bit();
	PCA_CH4_SetPWM_10Bit();
	PCA_CH5_SetPWM_10Bit();
	PCA_CH6_SetPWM_10Bit();
	PCA_CH7_SetPWM_10Bit();

	PCA_CH01_SetPWM_EnBufferMode();		// CH0,CH1 ʹܻģʽ
	PCA_CH23_SetPWM_EnBufferMode();		// CH2,CH3 ʹܻģʽ
	PCA_CH45_SetPWM_EnBufferMode();		// CH4,CH5 ʹܻģʽ
	PCA_CH67_SetPWM_EnBufferMode();		// CH6,CH7 ʹܻģʽ

	PCA_SetPWM_EdgeAligned();			// ض

	// PWMռձȱȽֵ
	PCA_CH0_SetValue_10Bit(0,0);
	PCA_CH1_SetValue_10Bit(0,0);
	PCA_CH2_SetValue_10Bit(0,0);
	PCA_CH3_SetValue_10Bit(0,0);
	PCA_CH4_SetValue_10Bit(0,0);
	PCA_CH5_SetValue_10Bit(0,0);
	PCA_CH6_SetValue_10Bit(0,0);
	PCA_CH7_SetValue_10Bit(0,0);

	// ü
	PCA_SetCounter(0);
	PCA_SetCounterReload(0);

	// ֹPWM
	PCA_SetPWM0_DisOutput();					
	PCA_SetPWM1_DisOutput();
	PCA_SetPWM2_DisOutput();
	PCA_SetPWM3_DisOutput();
	PCA_SetPWM4_DisOutput();
	PCA_SetPWM5_DisOutput();
	PCA_SetPWM6_DisOutput();
	PCA_SetPWM7_DisOutput();

	PCA_SetCEX1CEX3CEX5_P33P34P35();	// CEX1:P33,CEX3:P34,CEX5:P35

	PCA_EnPCACounter();					// ʹPCA
	
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPCA_PWM();

}


void main()
{
	u8 cnt,inx;
	bit bOutFlag;
    InitSystem();

	LED_G_0=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;

	wDuty[0].W=0;
	wDuty[1].W=0;
	wDuty[2].W=0;
	wDuty[3].W=0;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	LED_G_1=!LED_G_1;
	    	if(bOutFlag==TRUE)
			{
		   		inx++;
		    	if(inx>=8)
				{
					inx=0;
				}
		    	switch(inx)
				{
					case 0:
						// ռձ100% ȫߵƽ	
						// PWMռձֵ
						wDuty[0].W=0x0000;
						wDuty[1].W=0x0000;
						wDuty[2].W=0x0000;
						wDuty[3].W=0x0000;
						break;

					case 1:
						// ռձ75% 	
						// PWMռձֵ
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						wDuty[2].W=0x0100;
						wDuty[3].W=0x0100;
						break;

					case 2:
						// ռձ50% 	
						// PWMռձֵ
						wDuty[0].W=0x0200;
						wDuty[1].W=0x0200;
						wDuty[2].W=0x0200;
						wDuty[3].W=0x0200;
						break;

					case 3:
						// ռձ25% 	
						// PWMռձֵ
						wDuty[0].W=0x0300;
						wDuty[1].W=0x0300;
						wDuty[2].W=0x0300;
						wDuty[3].W=0x0300;
						break;
						
					case 4:
						// ռձ0% 	 ȫ͵ƽ
						// PWMռձֵ
						wDuty[0].W=0x0400;
						wDuty[1].W=0x0400;
						wDuty[2].W=0x0400;
						wDuty[3].W=0x0400;
						break;

					case 5:
						// ռձ25% 	
						// PWMռձֵ
						wDuty[0].W=0x0300;
						wDuty[1].W=0x0300;
						wDuty[2].W=0x0300;
						wDuty[3].W=0x0300;
						break;

					case 6:
						// ռձ50% 	
						// PWMռձֵ
						wDuty[0].W=0x0200;
						wDuty[1].W=0x0200;
						wDuty[2].W=0x0200;
						wDuty[3].W=0x0200;
						break;

					case 7:
						// ռձ75% 	
						// PWMռձֵ
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						wDuty[2].W=0x0100;
						wDuty[3].W=0x0100;
						break;
						
		    	}
				// ģʽ,CH0/CH1ֵĴΪCH1ֵ
				PCA_CH1_SetValue_10Bit(wDuty[0].B.BHigh,wDuty[0].B.BLow);
				// ģʽ,CH2/CH3ֵĴΪCH3ֵ
				PCA_CH3_SetValue_10Bit(wDuty[1].B.BHigh,wDuty[1].B.BLow);
				// ģʽ,CH4/CH5ֵĴΪCH5ֵ
				PCA_CH5_SetValue_10Bit(wDuty[2].B.BHigh,wDuty[2].B.BLow);
				// ģʽ,CH6/CH7ֵĴΪCH7ֵ
				PCA_CH7_SetValue_10Bit(wDuty[3].B.BHigh,wDuty[3].B.BLow);
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				LED_G_0=0;
				// ʹPWM
				PCA_SetPWM0_EnOutput(); 				
				PCA_SetPWM1_EnOutput();
				PCA_SetPWM2_EnOutput(); 				
				PCA_SetPWM3_EnOutput();
				PCA_SetPWM4_EnOutput(); 				
				PCA_SetPWM5_EnOutput();
				PCA_SetPWM6_EnOutput(); 				
				PCA_SetPWM7_EnOutput();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				LED_G_0=1;
				// ֹPWM
				PCA_SetPWM0_DisOutput();					
				PCA_SetPWM1_DisOutput();
				PCA_SetPWM2_DisOutput();					
				PCA_SetPWM3_DisOutput();
				PCA_SetPWM4_DisOutput();					
				PCA_SetPWM5_DisOutput();
				PCA_SetPWM6_DisOutput();					
				PCA_SetPWM7_DisOutput();
				P2=B10101000;									// PWM͵ƽ
				P3=B11000111;
			}
    	}
    }
}


