/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=24MHz, SysCLK=24MHz
*	
*			P32,P33,P14,P15INT1,INT0,INT2,INT3½ش
*			5sжϴ,ģʽ
*			INT1,INT0,INT2,INT3͵ƽ
*	ע
*	
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		24000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

u8 WakeUpSorce;
u8 INTCnt;

/***********************************************************************************
*:   void INT_INT0(void)	
*:INT0жϷ
*:   
*:     
*************************************************************************************/
void INT_INT0(void)		interrupt INT_VECTOR_INT0
{
	WakeUpSorce=0;
	INTCnt=0;
	LED_G_0=1;LED_G_1=1;LED_R=1;
}

/***********************************************************************************
*:   void INT_INT1(void)	
*:INT1жϷ
*:   
*:     
*************************************************************************************/
void INT_INT1(void)		interrupt INT_VECTOR_INT1
{
	WakeUpSorce=1;
	INTCnt=0;
	LED_G_0=1;LED_G_1=1;LED_R=1;
}

/***********************************************************************************
*:   void INT_INT2(void)	
*:INT2жϷ
*:   
*:     
*************************************************************************************/
void INT_INT2(void)		interrupt INT_VECTOR_INT2
{
	WakeUpSorce=2;
	INTCnt=0;
	LED_G_0=1;LED_G_1=1;LED_R=1;
}

/***********************************************************************************
*:   void INT_INT3(void)	
*:INT3жϷ
*:   
*:     
*************************************************************************************/
void INT_INT3(void)		interrupt INT_VECTOR_INT3
{
	WakeUpSorce=3;
	INTCnt=0;
	LED_G_0=1;LED_G_1=1;LED_R=1;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   u8 IAP_ReadPPage(u8 PsfrAddr)
*:ȡPҳ⹦
*:u8 PsfrAddr: Pҳַ   
*:u8: Pҳ     
*************************************************************************************/
u8 IAP_ReadPPage(u8 PsfrAddr)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFMT = ISP_READ_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
	return IFD;
}

/***********************************************************************************
*:   void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:дPҳ⹦
*:  
*		 u8 PsfrAddr: Pҳַ
*		 u8 PsfrData: Pҳ
*:  
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnINT0();							//	ʹINT0ж
	INT_EnINT1();							//	ʹINT1ж
	INT_EnINT2();							//	ʹINT2ж
	INT_EnINT3();							//	ʹINT3ж
}	

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(BIT4|BIT5|BIT6|BIT7);			//  P24,P25,P26,P27 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 

	PORT_EnP20P21P22P23PullHigh();						// ʹ P20,P21,P22,P23 

	PORT_SetP1OpenDrain(BIT4|BIT5|BIT6|BIT7);			//  P14,P15,P16,P17 Ϊ©ģʽ
	PORT_EnP14P15P16P17PullHigh();						// ʹ P14,P15,P16,P17 

	PORT_EnP10P11P12P13PullHigh();						// ʹ P10,P11,P12,P13 


	PORT_SetP3QuasiBi(0xFF);							//  P3 Ϊ׼˫ģʽ

	PORT_EnP40P41PullHigh();						// ʹ P40,P41 
	PORT_EnP44P45P47PullHigh();						// ʹ P44,P45,P46,P47 

	PORT_EnP60P61PullHigh();						// ʹ P60,P61 
}

/***********************************************************************************
*:   void InitINT0(void)
*:   INT0ʼ
*:   
*:     
*************************************************************************************/
void InitINT0(void)
{
	INT_SetINT0P32();						//INT0P32
	INT_SetINT0_DetectFallingEdge();		//INT0ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪ͵ƽ
	INT_SetINT0Filter_Sysclk_x3();			//INT0˲Ϊsysclk*3

}

/***********************************************************************************
*:   void InitINT1(void)
*:   INT1ʼ
*:   
*:     
*************************************************************************************/
void InitINT1(void)
{
	INT_SetINT1P33();						//INT1P33
	INT_SetINT0_DetectFallingEdge();		//INT1ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪ͵ƽ
	INT_SetINT1Filter_Sysclk_x3();			//INT1˲Ϊsysclk*3

}

/***********************************************************************************
*:   void InitINT2(void)
*:   INT2ʼ
*:   
*:     
*************************************************************************************/
void InitINT2(void)
{
	INT_SetINT2P14();						//INT2P14
	INT_SetINT0_DetectFallingEdge();		//INT2ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪ͵ƽ
	INT_SetINT2Filter_Sysclk_x3();			//INT2˲Ϊsysclk*3

}

/***********************************************************************************
*:   void InitINT3(void)
*:   INT3ʼ
*:   
*:     
*************************************************************************************/
void InitINT3(void)
{
	INT_SetINT3P15();						//INT3P15
	INT_SetINT0_DetectFallingEdge();		//INT3ⲿжϼⷽʽΪ½ؼ, ģʽ,ԶתΪ͵ƽ
	INT_SetINT3Filter_Sysclk_x3();			//INT3˲Ϊsysclk*3

}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitINT0();
	InitINT1();
	InitINT2();
	InitINT3();
	InitInterrupt();

	INT_EnAll();  // ʹȫж
}

void main()
{
	u8 BakCKCON2;
	
	InitSystem();
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(2000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
	INTCnt=0;
	WakeUpSorce=0;
	while(1)
	{

		if(WakeUpSorce == 0)
		{
			LED_G_0=!LED_G_0;
		}
		else if(WakeUpSorce == 1)
		{
			LED_R=!LED_R;
		}
		else if(WakeUpSorce == 2)
		{
			LED_G_1=!LED_G_1;
		}
		else if(WakeUpSorce == 3)
		{
			LED_G_1=!LED_G_1;
			LED_R=!LED_R;
		}
		else 
		{
			LED_G_0=!LED_G_0;
			LED_R=!LED_R;
			LED_G_1=!LED_G_1;
		}
		DelayXms(100);
		INTCnt++;
		if(INTCnt >=50)
		{
			LED_G_0=1;LED_G_1=1;LED_R=1;

			BakCKCON2=IAP_ReadPPage(CKCON2_P);							// CKCON2 (ʹPLL CKMƵ)
			IAP_WritePPage(CKCON2_P,BakCKCON2&(~(MCKS0_P|MCKS1_P)));		// MCK=OSCin (ʹPLL CKMƵ)
			
			POW_SetMode_PD();											// ʹMCUģʽ
			
			_nop_();
			DelayXus(100);												// ʱCKMȶ (ʹPLL CKMƵ)
			IAP_WritePPage(CKCON2_P,BakCKCON2); 						// ָCKCON2,ѡʹñƵ (ʹPLL CKMƵ)

			INT_DisAll();							// ֹȫж	
			if(WakeUpSorce == 0)
			{
				LED_G_0=0;
			}
			else if(WakeUpSorce == 1)
			{
				LED_R=0;
			}
			else if(WakeUpSorce == 2)
			{
				LED_G_1=0;
			}
			else if(WakeUpSorce == 3)
			{
				LED_G_1=!LED_G_1;
				LED_R=!LED_R;
			}
			else 
			{
				LED_G_0=!LED_G_0;
				LED_R=!LED_R;
				LED_G_1=!LED_G_1;
			}
			DelayXms(1000);
			LED_G_0=1;LED_G_1=1;LED_R=1;
			INT_EnAll();							// ʹȫж	
			INTCnt=0;
		}

	}

}






