/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			ʱΪ ILRCO 32KHz
*	ע
*	
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"


#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

/*************************************************
*:     void DelayXms(u16 xMs)
*:   		ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();

		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitClock_ILRCO(void)
*:   ʼClock
*:   
*:     
*************************************************************************************/
void InitClock_ILRCO(void)
{
	// P60  MCK/4
	CLK_P60OC_MCKDiv4();

	// IHRCO Enable, MCK=OSCin, OSCin=ILRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);
	nop();
	// IHRCO Disable, MCK=OSCin, OSCin=ILRCO
	CLK_SetCKCON2(DISABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);

}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);		//  P30,P31,P33,P34,P35 Ϊ׼˫
	PORT_EnP10P11P12P13PullHigh();
	PORT_EnP14P15P16P17PullHigh();
	PORT_EnP20P21P22P23PullHigh();
	PORT_EnP24P25P26P27PullHigh();
	PORT_EnP44P45P47PullHigh();
	PORT_EnP60P61PullHigh();

}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitClock_ILRCO();
	InitPort();

}

void main()
{
	u8 i;
	
    InitSystem();
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
					
    while(1)
    {
    	for(i=0;i<10;i++)
    	{
    		LED_R=0;
			DelayXms(100);
			LED_R=1;
			DelayXms(100);
    	}
    	DelayXms(4000);
    }
}


