/*********************************************************************
*    Ŀ:MG82F5B32-DEMO
*			԰ʹ MA82G5B32	LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			ADC 10bit, P10Ϊ
*			ʹڲ2.4VΪοѹ
*    ע:
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27


#define TEST_ADC_DATA_CNT		64
xdata WordTypeDef TestBuf[TEST_ADC_DATA_CNT];
u8 TestBufLen;

#define _RESOLUTION_10BIT_	0
#define _RESOLUTION_12BIT_	1

#define _DEFAULT_ADC_RESOLUTION_	_RESOLUTION_12BIT_

#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_10BIT_)
#define VCC_REF					(3300L)
#define ADC_VALUE_MAX			(1024L)
#define IVR_ADC_MIN				(714L)		// 2.3v@3.3V 
#define IVR_ADC_MAX				(776L)		// 2.5v@3.3V
#define IVR_ADC_DEFAULT			(745L)		// 2.4v@3.3V
#endif

#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_12BIT_)
#define VCC_REF					(3300L)
#define ADC_VALUE_MAX			(4096L)
#define IVR_ADC_MIN				(2855L)		// 2.3v@3.3V 
#define IVR_ADC_MAX				(3103L)		// 2.5v@3.3V
#define IVR_ADC_DEFAULT			(2979L)		// 2.4v@3.3V
#endif

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitUart0_S1BRG(void)
*:   Uart0ʼ ,ʹS1BRGΪԴ
*:   
*:     
*************************************************************************************/
void InitUart0_S1BRG(void)
{	
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹUART1
	UART0_SetBRGFromS1BRG();			// òԴΪ S1BRG
	UART0_SetS1BRGBaudRateX2();			// 2x
	UART1_SetS1BRGSelSYSCLK();			// S1BRGʱΪSysclk

    // ò
	UART1_SetS1BRGValue(S1BRG_BRGRL_9600_2X_12000000_1T);
	
	UART1_EnS1BRG();					// S1BRGʱ
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(BIT4|BIT5|BIT6|BIT7);			//  P24,P25,P26,P27 Ϊ©
	PORT_EnP24P25P26P27PullHigh();						// ʹ P24,P25,P26,P27 
	PORT_SetP1AInputOnly(BIT0);  					    //  P10룬ADCͨ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ	
*:   
*:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ

	TM_DisableT0();							// ֹT0
}

/***********************************************************************************
*:   void InitADC(void)
*:   ADCʼ
*:   
*:     
*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();						// ʹADC
	ADC_SetClock_SYSCLKDiv2();			// ADCתʱΪ SYSCLK       ת= 12M/2/30=200k
	ADC_SetMode_SetADCS();				// ADCģʽ, ADCS
	ADC_SetRightJustified();			// ADCתҶ

#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_10BIT_)
	ADC_SetADCData_10Bit();
#endif
	
#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_12BIT_)
	ADC_SetADCData_12Bit();
#endif

	ADC_SetVREF_IVR24();				// VREF+ Ϊڲ2.4V

	ADC_SetChannel_AIN0();				// ѡͨΪAIN0(P10)
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S1BRG();
	InitADC();
	InitTimer0();
}

/***********************************************************************************
*:   u16 GetAdcData()
*:	ȡǰͨADC 
*:   
*:   u16 :ADC Value
*************************************************************************************/
u16 GetAdcValue()
{
	WordTypeDef wAdcValue;
	ADCON0 = ADCON0|ADCS;							// λADCS,ADC
    while((ADCON0&ADCI)==0);           				// ȴADCת
    wAdcValue.B.BHigh=ADCDH;
    wAdcValue.B.BLow=ADCDL;
 	ADCON0 = ADCON0&(~ADCI);		           		// ־λ
#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_10BIT_)
	return wAdcValue.W&0x03FF;
#endif
		
#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_12BIT_)
	return wAdcValue.W&0x0FFF;
#endif
}

/***********************************************************************************
*:   unsigned int GetIVRef()
*:   ȡڲIVRefУ׼ֵ
*:   
*ز:   unsigned int :IVRef 3.3VµADCֵ(12λ)
*************************************************************************************/
unsigned int GetIVRef()
{
unsigned char IVR_CodeHigh,IVR_CodeLow;
	ISPCR = 0x80;
	IFMT = 0x06;
	IFADRH = 0x00;
	IFADRL = 0xC0;
	
	SCMD = 0x46;
	SCMD = 0xB9;
	IVR_CodeHigh= IFD;

	IFADRL ++;
	SCMD = 0x46;
	SCMD = 0xB9;
	IVR_CodeLow= IFD;

	ISPCR = 0x00;
	
	return (IVR_CodeHigh*256+IVR_CodeLow);
}

void main()
{
	u8 i;
	DWordTypeDef dwTemp;
	WordTypeDef wVinValue,wIVRefValue;
	WordTypeDef wIVRAdjAdc;

	u16 wAdcMIN,wAdcMAX,wAdcAVG;
	WordTypeDef wAdcTime;
	
    InitSystem();
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
	
	printf("\nHello...ADC Vref = IVR 2.4V...");

#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_10BIT_)
	wIVRAdjAdc.W=GetIVRef()>>2;				
#endif
#if (_DEFAULT_ADC_RESOLUTION_==_RESOLUTION_12BIT_)
		wIVRAdjAdc.W=GetIVRef(); 			
#endif

	// 
	printf("\nIVR ADC@3.3V:%d",wIVRAdjAdc.W);
	// IVRefУ׼ֵǷڷΧ(2.3~2.5)
	if((wIVRAdjAdc.W <IVR_ADC_MIN)||(wIVRAdjAdc.W>=IVR_ADC_MAX))
	{ // 洢IVRefֵ,ΪĬֵ 2.4V@3.3V
		// 
		wIVRAdjAdc.W=IVR_ADC_DEFAULT;
		printf(" Err..Set Default:%d",wIVRAdjAdc.W);
	}
	// IVRĵѹֵ
	dwTemp.DW=wIVRAdjAdc.W;
	wIVRefValue.W=dwTemp.DW*VCC_REF/ADC_VALUE_MAX;
	printf(", VRef Voltage:%dmV",wIVRefValue.W);


	TestBufLen=0;

	TH0=0;
	TL0=0;
	TM_EnableT0();
    while(1)
    {
    	TestBuf[TestBufLen].W=GetAdcValue();
		LED_R = !LED_R;
		TestBufLen++;
		if(TestBufLen>=TEST_ADC_DATA_CNT)
		{
			TM_DisableT0();
			wAdcTime.B.BHigh=TH0;
			wAdcTime.B.BLow=TL0;
			
			dwTemp.DW=0;
			wAdcMIN=0xFFFF;
			wAdcMAX=0x0000;
			
			for(i=0;i<(TEST_ADC_DATA_CNT);i++)
			{
				dwTemp.DW=dwTemp.DW+TestBuf[i].W;
				if(wAdcMIN>=TestBuf[i].W)
				{
					wAdcMIN=TestBuf[i].W;
				}
				if(wAdcMAX<TestBuf[i].W)
				{
					wAdcMAX=TestBuf[i].W;
				}
				
			}
			wAdcAVG=dwTemp.DW/TEST_ADC_DATA_CNT;		
			printf("\nADC ");
			printf("Sample cnt:%bd,",i);
			printf("Total time:%d,",wAdcTime.W);
			printf("MIN:%04X,",wAdcMIN);
			printf("MAX:%04X,",wAdcMAX);
			printf("AVG:%04X,",wAdcAVG);

			
			// AIN0ѹֵ
			dwTemp.DW=wIVRefValue.W;
			wVinValue.W=dwTemp.DW*wAdcAVG/ADC_VALUE_MAX;
			
			// 
			printf("IO Voltage:%dmV",wVinValue.W);
			DelayXms(1000);
			TestBufLen=0;

			TH0=0;
			TL0=0;
			TM_EnableT0();
		}
    }
}



